/*
 * Copyright (C) 2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.watcher;

import static org.junit.Assert.assertFalse;

import java.net.InetAddress;
import java.util.Random;

import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.videolan.vlma.model.Program;

public class HttpStreamWatcherTest {

    private Configuration configuration;
    private StreamWatcher watcher;

    @Before
    public void setup() {
        configuration = new BaseConfiguration();
        Random random = new Random();
        configuration.setProperty("vlma.streaming.http.port", 81 + random.nextInt(10000));
        watcher = new HttpStreamWatcher();
        ((HttpStreamWatcher) watcher).setConfiguration(configuration);
    }

    @Test
    public void testIsPlayed() throws Exception {
        Program program = new Program();
        program.setSapGroup("group");
        program.setSapName("name");
        assertFalse(watcher.isPlayed(program));
        // Pick a random address
        program.setPlayer(InetAddress.getByName("127.0.0.1"));
        assertFalse(watcher.isPlayed(program));
    }

}
