/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.Pdef;
import org.jrobin.graph.Plottable;
import org.jrobin.graph.Sdef;

public class RrdExportDef
implements Serializable {
    public static final int STRICT_IMPLICIT_OFF = 0;
    public static final int STRICT_IMPLICIT_ON = 1;
    public static final int STRICT_EXPLICIT_OFF = 2;
    public static final int STRICT_EXPLICIT_ON = 3;
    private long endTime = Util.getTime();
    private long startTime = Util.getTime() - 86400L;
    private long resolution = 1L;
    private int strict = 0;
    private int numSdefs = 0;
    private int numDefs = 0;
    protected FetchSourceList fetchSources = new FetchSourceList(10);
    protected ArrayList pdefList = new ArrayList(10);
    protected ArrayList cdefList = new ArrayList(10);
    protected ArrayList exportList = new ArrayList(10);
    protected ArrayList edefList = new ArrayList(3);

    public RrdExportDef() {
    }

    public RrdExportDef(long l, long l2) throws RrdException {
        this.setTimePeriod(l, l2);
    }

    public RrdExportDef(Date date, Date date2) throws RrdException {
        this.setTimePeriod(date, date2);
    }

    public RrdExportDef(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) throws RrdException {
        this.setTimePeriod(gregorianCalendar, gregorianCalendar2);
    }

    public void setTimePeriod(long l, long l2) throws RrdException {
        if (l < 0L || l2 != 0L && l2 <= l) {
            throw new RrdException("Invalid start/end time: " + l + "/" + l2);
        }
        this.startTime = l;
        this.endTime = l2;
    }

    public void setTimePeriod(Date date, Date date2) throws RrdException {
        this.setTimePeriod(date.getTime() / 1000L, date2.getTime() / 1000L);
    }

    public void setTimePeriod(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) throws RrdException {
        this.setTimePeriod(gregorianCalendar.getTime(), gregorianCalendar2.getTime());
    }

    public void setResolution(long l) {
        this.resolution = l;
    }

    public void datasource(String string, String string2, String string3, String string4) throws RrdException {
        this.fetchSources.add(string, string2, string3, string4);
        ++this.numDefs;
    }

    public void datasource(String string, String string2, String string3, String string4, String string5) throws RrdException {
        this.fetchSources.add(string, string2, string3, string4, string5);
        ++this.numDefs;
    }

    public void setDatasources(FetchSourceList fetchSourceList) {
        this.fetchSources = fetchSourceList;
        this.numDefs = this.fetchSources.defCount();
    }

    public void datasource(String string, String string2) {
        this.cdefList.add(new Cdef(string, string2));
    }

    public void datasource(String string, String string2, String string3) throws RrdException {
        this.cdefList.add(new Sdef(string, string2, string3));
        ++this.numSdefs;
    }

    public void datasource(String string, Plottable plottable) {
        this.pdefList.add(new Pdef(string, plottable));
    }

    public void datasource(String string, Plottable plottable, int n) {
        this.pdefList.add(new Pdef(string, plottable, n));
    }

    public void datasource(String string, Plottable plottable, String string2) {
        this.pdefList.add(new Pdef(string, plottable, string2));
    }

    public void addExportData(ExportData exportData) {
        this.edefList.add(exportData);
    }

    public void export(String string) {
        this.export(string, "");
    }

    public void export(String string, String string2) {
        if (this.strict == 0) {
            this.strict = 1;
        }
        this.exportList.add(new String[]{string, string2});
    }

    public void setStrictExport(boolean bl) {
        this.strict = bl ? 3 : 2;
    }

    public void exportXmlTemplate(OutputStream outputStream) {
        int n;
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.startTag("rrd_export_def");
        xmlWriter.startTag("span");
        xmlWriter.writeTag("start", this.getStartTime());
        xmlWriter.writeTag("end", this.getEndTime());
        xmlWriter.closeTag();
        xmlWriter.startTag("options");
        if (this.resolution > 1L) {
            xmlWriter.writeTag("resolution", this.resolution);
        }
        xmlWriter.writeTag("strict_export", this.strict == 1 || this.strict == 3 ? "true" : "false");
        xmlWriter.closeTag();
        xmlWriter.startTag("datasources");
        for (n = 0; n < this.fetchSources.size(); ++n) {
            this.fetchSources.get(n).exportXml(xmlWriter);
        }
        for (n = 0; n < this.cdefList.size(); ++n) {
            Cdef cdef = (Cdef)this.cdefList.get(n);
            cdef.exportXml(xmlWriter);
        }
        xmlWriter.closeTag();
        xmlWriter.startTag("exports");
        String[][] stringArray = this.getExportDatasources();
        for (int i = 0; i < stringArray.length; ++i) {
            xmlWriter.startTag("export");
            xmlWriter.writeTag("datasource", stringArray[i][0]);
            xmlWriter.writeTag("legend", stringArray[i][1]);
            xmlWriter.closeTag();
        }
        xmlWriter.closeTag();
        xmlWriter.closeTag();
        xmlWriter.flush();
        xmlWriter.flush();
    }

    public String getXmlTemplate() {
        return this.exportXmlTemplate();
    }

    public String exportXmlTemplate() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportXmlTemplate(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public void exportXmlTemplate(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, false);
        this.exportXmlTemplate(fileOutputStream);
        fileOutputStream.close();
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getEndTime() {
        return this.endTime;
    }

    protected long getResolution() {
        return this.resolution;
    }

    protected int getNumDefs() {
        return this.numDefs;
    }

    protected Cdef[] getCdefs() {
        return this.cdefList.toArray(new Cdef[0]);
    }

    protected Pdef[] getPdefs() {
        return this.pdefList.toArray(new Pdef[0]);
    }

    protected ExportData[] getExportData() {
        return this.edefList.toArray(new ExportData[0]);
    }

    protected int getNumSdefs() {
        return this.numSdefs;
    }

    protected FetchSourceList getFetchSources() {
        return this.fetchSources;
    }

    protected boolean isStrict() {
        return this.strict == 1 || this.strict == 3;
    }

    protected String[][] getExportDatasources() {
        return (String[][])this.exportList.toArray((T[])new String[0][2]);
    }
}

