#!/bin/sh

# Pre-Compile.sh
# MobileVLC
#
# Created by Pierre d'Herbemont on 6/27/10.
# Copyright 2010 __MyCompanyName__. All rights reserved.



plugins+="access/access_attachment "
plugins+="access/access_avio "
plugins+="access/access_bd "
plugins+="access/access_ftp "
plugins+="access/access_http "
plugins+="access/access_imem "
plugins+="access/access_mmap "
plugins+="access/access_mms "
plugins+="access/access_tcp "
plugins+="access/access_udp "
plugins+="access/filesystem "
plugins+="access/rtp "
plugins+="access/zip "
plugins+="access_output/access_output_dummy "
plugins+="access_output/access_output_file "
plugins+="access_output/access_output_http "
plugins+="access_output/access_output_livehttp "
plugins+="access_output/access_output_udp "
plugins+="audio_filter/a52tospdif "
plugins+="audio_filter/audio_format "
plugins+="audio_filter/audiobargraph_a "
plugins+="audio_filter/bandlimited_resampler "
plugins+="audio_filter/chorus_flanger "
plugins+="audio_filter/converter_fixed "
plugins+="audio_filter/dolby_surround_decoder "
plugins+="audio_filter/dtstospdif "
plugins+="audio_filter/equalizer "
plugins+="audio_filter/headphone_channel_mixer "
plugins+="audio_filter/mono "
plugins+="audio_filter/normvol "
plugins+="audio_filter/param_eq "
plugins+="audio_filter/scaletempo "
plugins+="audio_filter/simple_channel_mixer "
plugins+="audio_filter/trivial_channel_mixer "
plugins+="audio_filter/ugly_resampler "
plugins+="audio_mixer/float32_mixer "
plugins+="audio_mixer/spdif_mixer "
plugins+="audio_mixer/trivial_mixer "
plugins+="audio_output/aout_file "
plugins+="audio_output/audioqueue "
plugins+="codec/a52 "
plugins+="codec/adpcm "
plugins+="codec/aes3 "
plugins+="codec/araw "
plugins+="codec/avcodec "
plugins+="codec/cc "
plugins+="codec/cdg "
plugins+="codec/cvdsub "
plugins+="codec/dts "
plugins+="codec/dvbsub "
plugins+="codec/invmem "
plugins+="codec/faad "
plugins+="codec/lpcm "
plugins+="codec/mpeg_audio "
plugins+="codec/rawvideo "
plugins+="codec/spudec "
plugins+="codec/subsdec "
plugins+="codec/subsusf "
plugins+="codec/svcdsub "
plugins+="codec/t140 "
plugins+="codec/telx "
plugins+="demux/aiff "
plugins+="demux/asf "
plugins+="demux/au "
plugins+="demux/avformat "
plugins+="demux/avi "
plugins+="demux/demux_cdg "
plugins+="demux/demuxdump "
plugins+="demux/dirac "
plugins+="demux/es "
plugins+="demux/flacsys "
plugins+="demux/h264 "
plugins+="demux/image "
plugins+="demux/live555 "
plugins+="demux/mjpeg "
plugins+="demux/mp4 "
plugins+="demux/mpgv "
plugins+="demux/nsc "
plugins+="demux/nsv "
plugins+="demux/nuv "
plugins+="demux/playlist "
plugins+="demux/ps "
plugins+="demux/pva "
plugins+="demux/rawaud "
plugins+="demux/rawdv "
plugins+="demux/rawvid "
plugins+="demux/real "
plugins+="demux/smf "
plugins+="demux/subtitle "
plugins+="demux/tta "
plugins+="demux/ty "
plugins+="demux/ts "
plugins+="demux/vc1 "
plugins+="demux/vobsub "
plugins+="demux/voc "
plugins+="demux/wav "
plugins+="demux/xa "
plugins+="meta_engine/folder "
plugins+="misc/audioscrobbler "
plugins+="misc/dummy "
plugins+="misc/export "
plugins+="misc/logger "
plugins+="misc/quartztext "
plugins+="misc/sqlite "
plugins+="misc/stats "
plugins+="misc/vod_rtsp "
plugins+="misc/xtag "
plugins+="mux/mux_asf "
plugins+="mux/mux_avi "
plugins+="mux/mux_dummy "
plugins+="mux/mux_mp4 "
plugins+="mux/mux_mpjpeg "
plugins+="mux/mux_ps "
plugins+="mux/mux_wav "
plugins+="packetizer/packetizer_copy "
plugins+="packetizer/packetizer_dirac "
plugins+="packetizer/packetizer_flac "
plugins+="packetizer/packetizer_h264 "
plugins+="packetizer/packetizer_mlp "
plugins+="packetizer/packetizer_mpeg4audio "
plugins+="packetizer/packetizer_mpeg4video "
plugins+="packetizer/packetizer_mpegvideo "
plugins+="packetizer/packetizer_vc1 "
plugins+="services_discovery/mediadirs "
plugins+="services_discovery/podcast "
plugins+="services_discovery/sap "
plugins+="stream_filter/decomp "
plugins+="stream_filter/stream_filter_record "
plugins+="stream_out/stream_out_autodel "
plugins+="stream_out/stream_out_bridge "
plugins+="stream_out/stream_out_description "
plugins+="stream_out/stream_out_display "
plugins+="stream_out/stream_out_dummy "
plugins+="stream_out/stream_out_duplicate "
plugins+="stream_out/stream_out_es "
plugins+="stream_out/stream_out_gather "
plugins+="stream_out/stream_out_mosaic_bridge "
plugins+="stream_out/stream_out_record "
plugins+="stream_out/stream_out_rtp "
plugins+="stream_out/stream_out_smem "
plugins+="stream_out/stream_out_standard "
plugins+="stream_out/stream_out_transcode "
plugins+="video_chroma/grey_yuv "
plugins+="video_chroma/i420_rgb "
plugins+="video_chroma/i420_yuy2 "
plugins+="video_chroma/i422_i420 "
plugins+="video_chroma/i422_yuy2 "
plugins+="video_chroma/yuy2_i420 "
plugins+="video_chroma/yuy2_i422 "
plugins+="video_filter/adjust "
plugins+="video_filter/alphamask "
plugins+="video_filter/audiobargraph_v "
plugins+="video_filter/ball "
plugins+="video_filter/blend "
plugins+="video_filter/blendbench "
plugins+="video_filter/bluescreen "
plugins+="video_filter/canvas "
plugins+="video_filter/chain "
plugins+="video_filter/clone "
plugins+="video_filter/colorthres "
plugins+="video_filter/croppadd "
plugins+="video_filter/deinterlace "
plugins+="video_filter/dynamicoverlay "
plugins+="video_filter/erase "
plugins+="video_filter/extract "
plugins+="video_filter/gaussianblur "
plugins+="video_filter/gradfun "
plugins+="video_filter/gradient "
plugins+="video_filter/grain "
plugins+="video_filter/invert "
plugins+="video_filter/logo "
plugins+="video_filter/magnify "
plugins+="video_filter/marq "
plugins+="video_filter/mirror "
plugins+="video_filter/mosaic "
plugins+="video_filter/motionblur "
plugins+="video_filter/motiondetect "
plugins+="video_filter/noise "
plugins+="video_filter/psychedelic "
plugins+="video_filter/puzzle "
plugins+="video_filter/ripple "
plugins+="video_filter/rotate "
plugins+="video_filter/rss "
plugins+="video_filter/rv32 "
plugins+="video_filter/scale "
plugins+="video_filter/scene "
plugins+="video_filter/sharpen "
plugins+="video_filter/swscale "
plugins+="video_filter/wall "
plugins+="video_filter/wave "
plugins+="video_filter/yuvp "
plugins+="video_output/vmem "
plugins+="video_output/vout_ios "
plugins+="video_output/yuv "

pushd `dirname $0` > /dev/null
PROJECT_DIR=`pwd`
popd > /dev/null

VLC_SRC_DIR="$PROJECT_DIR/../../../.."

VLC_CONTRIB_DIR="$VLC_SRC_DIR/extras/contrib/hosts/\$(VLC_ARCH)-apple-darwin10/ios"

echo -ne "// This file is autogenerated by $(basename $0)\n\n" > $PROJECT_DIR/vlc-plugins.h
echo -ne "// This file is autogenerated by $(basename $0)\n\n" > $PROJECT_DIR/vlc-plugins.xcconfig

LDFLAGS=""
DEFINITION=""
BUILTINS="const void *vlc_builtins_modules[] = {\n"
for i in $plugins; do
    dir=`dirname $i`
    name=`basename $i`
    LDFLAGS+="\$(VLC_INSTALL_DIR)/lib/vlc/plugins/${dir}/lib${name}_plugin.a "
    DEFINITION+="vlc_declare_plugin(${name});\n"
    BUILTINS+="    vlc_plugin(${name}),\n"
done;
BUILTINS+="    NULL\n"
BUILTINS+="};\n"
echo -ne "VLC_PLUGINS_LDFLAGS=$LDFLAGS" >> $PROJECT_DIR/vlc-plugins.xcconfig
echo -ne "$DEFINITION\n$BUILTINS" >> $PROJECT_DIR/vlc-plugins.h
