/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import org.videolan.Logger;

public class BDJClassFileTransformer {
    private static final Logger logger = Logger.getLogger(BDJClassFileTransformer.class.getName());

    public byte[] rename(byte[] b, int off, int len, Map mappings) throws ClassFormatError {
        byte[] r = new byte[len];
        for (int i = 0; i < len; ++i) {
            r[i] = b[i + off];
        }
        return this.rename(r, mappings);
    }

    public byte[] rename(byte[] b, Map mappings) throws ClassFormatError {
        logger.info("Trying to rename class (" + b.length + " bytes)");
        try {
            SimpleRemapper m = new SimpleRemapper(mappings);
            ClassReader cr = new ClassReader(b);
            ClassWriter cw = new ClassWriter(cr, 2);
            RemappingClassAdapter cv = new RemappingClassAdapter(cw, m);
            cr.accept(cv, 10);
            return cw.toByteArray();
        }
        catch (Exception e) {
            logger.error("Failed renaming class: " + e);
            return null;
        }
    }

    public byte[] strip(byte[] b, int off, int len) throws ClassFormatError {
        logger.info("Trying to transform broken class file (" + len + " bytes)");
        byte[] r = new byte[len];
        for (int i = 0; i < len; ++i) {
            r[i] = b[i + off];
        }
        try {
            ClassReader cr = new ClassReader(r);
            ClassWriter cw = new ClassWriter(cr, 0);
            MyClassVisitor cv = new MyClassVisitor(cw);
            cr.accept(cv, 10);
            return cw.toByteArray();
        }
        catch (Exception e) {
            logger.error("Failed transforming class: " + e);
            return r;
        }
    }

    private static final class MyMethodVisitor
    extends MethodVisitor {
        public MyMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitAttribute(Attribute attr) {
            super.visitAttribute(attr);
        }
    }

    private static final class MyClassVisitor
    extends ClassVisitor {
        public MyClassVisitor(ClassVisitor cv) {
            super(262144, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new MyMethodVisitor(mv);
        }
    }
}

