/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vlcskineditor.Item;
import vlcskineditor.Skin;
import vlcskineditor.items.Anchor;
import vlcskineditor.items.Button;
import vlcskineditor.items.Checkbox;
import vlcskineditor.items.Group;
import vlcskineditor.items.Image;
import vlcskineditor.items.Panel;
import vlcskineditor.items.Playtree;
import vlcskineditor.items.RadialSlider;
import vlcskineditor.items.Slider;
import vlcskineditor.items.Text;
import vlcskineditor.items.Video;

public class XML {
    public static String getValue(String string, String string2) {
        int n = string.indexOf(" " + string2 + "=\"") + string2.length() + 3;
        int n2 = string.indexOf("\"", n);
        return string.substring(n, n2);
    }

    public static int getIntValue(String string, String string2) {
        int n = 0;
        try {
            n = Integer.parseInt(XML.getValue(string, string2).trim());
        }
        catch (Exception exception) {
            System.err.println("Could not parse int from getValue(" + string + "," + string2 + "): " + XML.getValue(string, string2));
        }
        return n;
    }

    public static boolean getBoolValue(String string, String string2) {
        boolean bl = false;
        try {
            bl = Boolean.parseBoolean(XML.getValue(string, string2).trim());
        }
        catch (Exception exception) {
            System.err.println("Could not parse boolean from getValue(" + string + "," + string2 + "): " + XML.getValue(string, string2));
        }
        return bl;
    }

    public static String getStringAttributeValue(Node node, String string, String string2) {
        if (node.getAttributes().getNamedItem(string) != null) {
            String string3 = node.getAttributes().getNamedItem(string).getNodeValue();
            if (string.equals("id") && string3.equals("none")) {
                return string2;
            }
            return string3;
        }
        return string2;
    }

    public static int getIntAttributeValue(Node node, String string, int n) {
        try {
            if (node.getAttributes().getNamedItem(string) != null) {
                return Integer.parseInt(node.getAttributes().getNamedItem(string).getNodeValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Tried to get a node's attribute as an integer, although it is no integer. It's value is " + node.getAttributes().getNamedItem(string).getNodeValue());
        }
        return n;
    }

    public static boolean getBoolAttributeValue(Node node, String string, boolean bl) {
        if (node.getAttributes().getNamedItem(string) != null) {
            return Boolean.parseBoolean(node.getAttributes().getNamedItem(string).getNodeValue());
        }
        return bl;
    }

    public static void parseChildItems(Node node, List<Item> list, Skin skin) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equals("Anchor")) {
                list.add(new Anchor(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Button")) {
                list.add(new Button(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Checkbox")) {
                list.add(new Checkbox(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Group")) {
                list.add(new Group(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Image")) {
                list.add(new Image(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Panel")) {
                list.add(new Panel(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Playtree")) {
                list.add(new Playtree(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Playlist")) {
                ((Element)nodeList.item(i)).setAttribute("flat", "true");
                list.add(new Playtree(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("RadialSlider")) {
                list.add(new RadialSlider(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Slider")) {
                list.add(new Slider(nodeList.item(i), skin));
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("Text")) {
                list.add(new Text(nodeList.item(i), skin));
                continue;
            }
            if (!nodeList.item(i).getNodeName().equals("Video")) continue;
            list.add(new Video(nodeList.item(i), skin));
        }
    }
}

