.\" $Id: tit2cit.man,v 1.1.1.1 2001/08/08 14:32:35 cvsadmin Exp $
.TH TIT2CIT 1 "CXTERM Version 5.0" "January 1, 1995"
.SH NAME
tit2cit, cit2tit \- Input method compiler for cxterm
.SH SYNOPSIS
.B tit2cit
[file]
.br
.B cit2tit
[file]
.SH DESCRIPTION
Input methods for \fIcxterm\fR are stored as external files
and are loaded by cxterm in runtime on demand.
Input method files have two formats, text format and compiled format.
.PP
Text format has suffix .tit (tit for Text Input Table) in the file name,
and is intended to be read and written by human; compiled format has
suffix .cit (cit for Compiled Input Table) in the file name,
and is loaded by cxterm. Utilities \fItit2cit\fR and \fIcit2tit\fR
convert input method files between these two formats.
.PP
If the \fIfile\fR argument is given to the \fItit2cit\fR or \fIcit2tit\fR,
the input is taken from the file, otherwise the input is from stdin.
Both programs write the input table to stdout.
.SH "TIT FILE FORMAT"
A .tit file is a line-oriented text (English and Chinese) file.
The whole file contains of two parts, the definition part followed by
the dictionary part.
All lines begin with leading '#' are ignored. Then each line consists of
one keyword and followed by zero or more definitions. In the following
formal specification,
.LP
\fI<key>\fR means any character with ASCII code from 0 to 127, if not
printable, the character should be in \\ooo format, where ooo is
the ASCII code in 3 octal-decimal digit form;
.LP
\fI<keys>\fR
means a continuous string of \fI<key>\fR;
.LP
\fI<string>\fR means any string of ASCII characters (unprintable in \ooo)
and Chinese characters;
.LP
\fI<Cstring>\fR means string of Chinese characters;
.LP
\fI\\000\fR indicates an empty field.
.SH "DEFINITION PART"
.PP
Each line is consisted of a keyword and followed by optional
definitions:
.TP 8
.B ENCODE: \fI<string>\fP
Define the encoding of the input method.
Valid values of \fI<string>\fP are GB, BIG5, JIS, and KS;
the default is GB.
.TP 8
.B AUTOSELECT: \fI<string>\fP
Specify whether a Chinese character should be automatically input
without a selection key,
when it is the only candidate of a given input string.
Valid values of \fI<string>\fP are NEVER, ALWAYS, or WHENNOMATCH;
the default is NEVER.
.TP 8
.B PROMPT: \fI<string>\fP
Define prompt string to be shown in the cxterm input area.
Valid values of \fI<string>\fP are any Chinese and English mixed string
shorter or equal to 24 bytes. There is no default value for this prompt.
.TP 8
.B VALIDINPUTKEY: \fI<keys>\fP
Specify all the valid input keys that can be used in the input string of a
Chinese character. There is no default valid input keys.
.TP 8
.B WILDCARDKEY: \fI<keys>\fP
Specify the keys for use to match any number of input keys in Chinese input.
The default value is "*".
.TP 8
.B WILDCHARKEY: \fI<keys>\fP
Specify the keys for use to match any single input key in Chinese input.
The default value is "?".
.TP 8
.B ASSOCIATIONKEY: \fI<keys>\fP
Specify the keys for use in association phrase input by composition.
The default value is "-".
.TP 8
.B SELECTKEY: \fI<keys> <keys> ...\fP
Specify the keys to be used in Chinese input selection. They must be
in same order of the choices shown on the input area.
The number of sets of keys \fI<keys>\fP can not exceed 16.
The default value is
.nf
	SELECTKEY: 1\\040 2 3 4 5 6 7 8 9 0
.fi
.TP 8
.B MOVERIGHT: \fI<keys>\fP
Specify the keys to be used to show more choices at the right.
The default value is ".>"
.TP 8
.B MOVELEFT: \fI<keys>\fP
Specify the keys to be used to show more choices at the left.
The default value is ",<"
.TP 8
.B BACKSPACE: \fI<keys>\fP
Specify the keys to be used for backspace in Chinese input area. 
The default value is "\\010\\177" (Backspace, Delete).
.TP 8
.B DELETEALL: \fI<keys>\fP
Specify the keys to be used to clear all input in Chinese input area. 
The default value is "\\015\\025" (Return, CTRL-U).
.TP 8
.B CURSOR-BEGIN: \fI<keys>\fP
Specify the keys to move the cursor to the beginning
of the input keystroke buffer.
There is no default cursor movement key.
.TP 8
.B CURSOR-END: \fI<keys>\fP
Specify the keys to move the cursor to the end
of the input keystroke buffer.
There is no default cursor movement key.
.TP 8
.B CURSOR-FORW: \fI<keys>\fP
Specify the keys to move the cursor forward one key
in the input keystroke buffer.
There is no default cursor movement key.
.TP 8
.B CURSOR-BACK: \fI<keys>\fP
Specify the keys to move the cursor backward one key
in the input keystroke buffer.
There is no default cursor movement key.
.TP 8
.B CURSOR-ERASE: \fI<keys>\fP
Specify the keys to delete the input key at the cursor position.
There is no default cursor movement key.
.TP 8
.B REPEATKEY: \fI<keys>\fP
Specify the keys to be used to repeat the input of last selection.
The default value is "\\020\\022" (CTRL-P, CTRL-R).
.TP 8
.B KEYPROMPT(\fI<key>\fP): \fI<string>\fP
Define corresponding \fI<string>\fP to be displayed in input area when
the key \fI<key>\fP is input.
Maximum length of each \fI<string>\fP is 4 bytes.
Default value of \fI<string>\fP is the \fI<key>\fP itself.
.TP 8
.B COMMENT \fIanything\fP
Any thing follows \fBCOMMENT\fP will be saved at the end of the .cit file.
.SH "DICTIONARY PART"
.PP
The dictionary part contains optional hanzi dictionary and phrase dictionary.
.PP
The hanzi dictionary starts with \fBBEGINDICTIONARY\fP.
Each lines in the hanzi dictionary is in the form of:
.nf
	\fI<keys>\fP	\fI<Cstring>\fP
.fi
Each individual Chinese character in \fI<Cstring>\fP 
can be input by key sequence \fI<keys>\fP.
.PP
The phrase dictionary starts with \fBBEGINPHRASE\fP.
A phrase is a unit of multiple Chinese characters
and is input together as a whole.
Each lines in the phrase dictionary is in the form of:
.nf
	\fI<keys>\fP	\fI<Cstring>\fP \fI<Cstring>\fP ...
.fi
Each \fI<Cstring>\fP can be input by key sequence \fI<keys>\fP.
.SH BUG
\fIcit2tit\fP is not an exact reverse of \fItit2cit\fP.
.SH "SEE ALSO"
.BI cxterm(1),
.BI X(1)
.SH COPYRIGHT
Copyright 1991,1994,1995 Yongguang Zhang.
