/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef LANGUAGEINFO_H
#define LANGUAGEINFO_H
#include <QString>
#include <QFile>
#include <QXmlStreamReader>
#include <QDebug>
//sudo apt install libqapt-dev
#include <QApt/DownloadProgress>
#include <QApt/Globals>
#include <QApt/Backend>
#include <QtConcurrentRun>

class LanguageInfo : public QObject{
    Q_OBJECT
public:
    LanguageInfo(QObject *parent = nullptr);
    ~LanguageInfo();
    void init();

private:
    bool isAvailable(QString languageCode);
    bool isInstalled(QString languageCode);
    void readLangInfo(QString localFile = "/usr/share/xml/iso-codes/iso_639_3.xml");
    void getAvailableLanguage();
    void getInstalledLanguage();

private:
    QApt::Backend *m_backend = nullptr;
    QFuture<void> threadRun;
    QMap<QString, QString> localLangMap;
    QMap<QString, QString> availableLangMap;
    QMap<QString, QString> installedLangMap;

Q_SIGNALS:
    void initFinished(QMap<QString, QString> availableLangMap,QMap<QString, QString> installedLangMap);
};

#endif // LANGUAGEINFO_H
