<?php

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

// Try to load our extension if it's not already loaded.
if (!extension_loaded('openbabel')) {
  if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
    if (!dl('php_openbabel.dll')) return;
  } else {
    // PHP_SHLIB_SUFFIX gives 'dylib' on MacOS X but modules are 'so'.
    if (PHP_SHLIB_SUFFIX === 'dylib') {
      if (!dl('openbabel.so')) return;
    } else {
      if (!dl('openbabel.'.PHP_SHLIB_SUFFIX)) return;
    }
  }
}



abstract class openbabel {
	static function toAliasData($data) {
		$r=toAliasData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new AliasData($r);
		}
		return $r;
	}

	static function toAngleData($data) {
		$r=toAngleData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAngleData($r);
		}
		return $r;
	}

	static function toCommentData($data) {
		$r=toCommentData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBCommentData($r);
		}
		return $r;
	}

	static function toConformerData($data) {
		$r=toConformerData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBConformerData($r);
		}
		return $r;
	}

	static function toExternalBondData($data) {
		$r=toExternalBondData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBExternalBondData($r);
		}
		return $r;
	}

	static function toGridData($data) {
		$r=toGridData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBGridData($r);
		}
		return $r;
	}

	static function toMatrixData($data) {
		$r=toMatrixData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMatrixData($r);
		}
		return $r;
	}

	static function toNasaThermoData($data) {
		return toNasaThermoData($data);
	}

	static function toPairData($data) {
		$r=toPairData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBPairData($r);
		}
		return $r;
	}

	static function toRateData($data) {
		return toRateData($data);
	}

	static function toRotamerList($data) {
		$r=toRotamerList($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRotamerList($r);
		}
		return $r;
	}

	static function toRotationData($data) {
		$r=toRotationData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRotationData($r);
		}
		return $r;
	}

	static function toSerialNums($data) {
		$r=toSerialNums($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBSerialNums($r);
		}
		return $r;
	}

	static function toSetData($data) {
		$r=toSetData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBSetData($r);
		}
		return $r;
	}

	static function toSymmetryData($data) {
		$r=toSymmetryData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBSymmetryData($r);
		}
		return $r;
	}

	static function toTorsionData($data) {
		$r=toTorsionData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBTorsionData($r);
		}
		return $r;
	}

	static function toUnitCell($data) {
		$r=toUnitCell($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBUnitCell($r);
		}
		return $r;
	}

	static function toVectorData($data) {
		$r=toVectorData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBVectorData($r);
		}
		return $r;
	}

	static function toVibrationData($data) {
		$r=toVibrationData($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBVibrationData($r);
		}
		return $r;
	}

	static function toVirtualBond($data) {
		$r=toVirtualBond($data);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBVirtualBond($r);
		}
		return $r;
	}

	static function ttab_set($ttab) {
		ttab_set($ttab);
	}

	static function ttab_get() {
		$r=ttab_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBTypeTable($r);
		}
		return $r;
	}

	static function resdat_set($resdat) {
		resdat_set($resdat);
	}

	static function resdat_get() {
		$r=resdat_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidueData($r);
		}
		return $r;
	}

	const M_PI = M_PI;

	static function rotate_coords($arg1,$m,$arg3) {
		rotate_coords($arg1,$m,$arg3);
	}

	static function calc_rms($arg1,$arg2,$arg3) {
		return calc_rms($arg1,$arg2,$arg3);
	}

	const RAD_TO_DEG = RAD_TO_DEG;

	const DEG_TO_RAD = DEG_TO_RAD;

	static function dot($v1,$v2) {
		return dot($v1,$v2);
	}

	static function cross($arg1,$arg2) {
		$r=cross($arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	static function vectorAngle($v1,$v2) {
		return vectorAngle($v1,$v2);
	}

	static function CalcTorsionAngle($a,$b,$c_,$d) {
		return CalcTorsionAngle($a,$b,$c_,$d);
	}

	static function Point2PlaneSigned($a,$b,$c_,$d) {
		return Point2PlaneSigned($a,$b,$c_,$d);
	}

	static function Point2Plane($a,$b,$c_,$d) {
		return Point2Plane($a,$b,$c_,$d);
	}

	static function Point2PlaneAngle($a,$b,$c_,$d) {
		return Point2PlaneAngle($a,$b,$c_,$d);
	}

	static function Point2Line($a,$b,$c_) {
		return Point2Line($a,$b,$c_);
	}

	static function VZero_get() {
		$r=VZero_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	static function VX_get() {
		$r=VX_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	static function VY_get() {
		$r=VY_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	static function VZ_get() {
		$r=VZ_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	const SETWORD = SETWORD;

	const WORDROLL = WORDROLL;

	const WORDMASK = WORDMASK;

	const STARTWORDS = STARTWORDS;

	static function Tanimoto($bv1,$bv2) {
		return Tanimoto($bv1,$bv2);
	}

	static function OBReleaseVersion() {
		return OBReleaseVersion();
	}

	const UndefinedData = 0;

	const PairData = 1;

	const EnergyData = 2;

	const CommentData = 3;

	const ConformerData = 4;

	const ExternalBondData = 5;

	const RotamerList = 6;

	const VirtualBondData = 7;

	const RingData = 8;

	const TorsionData = 9;

	const AngleData = 10;

	const SerialNums = 11;

	const UnitCell = 12;

	const SpinData = 13;

	const ChargeData = 14;

	const SymmetryData = 15;

	const OccupationData = 17;

	const DensityData = 18;

	const ElectronicData = 19;

	const VibrationData = 20;

	const RotationData = 21;

	const NuclearData = 22;

	const SetData = 23;

	const GridData = 24;

	const VectorData = 25;

	const MatrixData = 26;

	const StereoData = 27;

	const DOSData = 28;

	const ElectronicTransitionData = 29;

	const CustomData0 = 16384;

	const CustomData1 = 16385;

	const CustomData2 = 16386;

	const CustomData3 = 16387;

	const CustomData4 = 16388;

	const CustomData5 = 16389;

	const CustomData6 = 16390;

	const CustomData7 = 16391;

	const CustomData8 = 16392;

	const CustomData9 = 16393;

	const CustomData10 = 16394;

	const CustomData11 = 16395;

	const CustomData12 = 16396;

	const CustomData13 = 16397;

	const CustomData14 = 16398;

	const CustomData15 = 16399;

	const any = 0;

	const fileformatInput = fileformatInput;

	const userInput = userInput;

	const perceived = perceived;

	const external = external;

	const local = local;

	const MaxMonoAtom = MaxMonoAtom;

	const MaxMonoBond = MaxMonoBond;

	static function chainsparser_set($chainsparser) {
		chainsparser_set($chainsparser);
	}

	static function chainsparser_get() {
		$r=chainsparser_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBChainsParser($r);
		}
		return $r;
	}

	static function atomtyper_set($atomtyper) {
		atomtyper_set($atomtyper);
	}

	static function atomtyper_get() {
		$r=atomtyper_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtomTyper($r);
		}
		return $r;
	}

	static function aromtyper_set($aromtyper) {
		aromtyper_set($aromtyper);
	}

	static function aromtyper_get() {
		$r=aromtyper_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAromaticTyper($r);
		}
		return $r;
	}

	const obError = 0;

	const obWarning = obWarning;

	const obInfo = obInfo;

	const obAuditMsg = obAuditMsg;

	const obDebug = obDebug;

	const always = 0;

	const onceOnly = onceOnly;

	static function obErrorLog_set($obErrorLog) {
		obErrorLog_set($obErrorLog);
	}

	static function obErrorLog_get() {
		$r=obErrorLog_get();
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMessageHandler($r);
		}
		return $r;
	}

	const NOTREADABLE = NOTREADABLE;

	const READONEONLY = READONEONLY;

	const READBINARY = READBINARY;

	const ZEROATOMSOK = ZEROATOMSOK;

	const NOTWRITABLE = NOTWRITABLE;

	const WRITEONEONLY = WRITEONEONLY;

	const WRITEBINARY = WRITEBINARY;

	const READXML = READXML;

	const DEPICTION2D = DEPICTION2D;

	const DEFAULTFORMAT = DEFAULTFORMAT;

	const MAXSETNO = MAXSETNO;

	const MAXELEM = MAXELEM;

	const MAXRES = MAXRES;

	const AA_ALA = AA_ALA;

	const AA_GLY = AA_GLY;

	const AA_LEU = AA_LEU;

	const AA_SER = AA_SER;

	const AA_VAL = AA_VAL;

	const AA_THR = AA_THR;

	const AA_LYS = AA_LYS;

	const AA_ASP = AA_ASP;

	const AA_ILE = AA_ILE;

	const AA_ASN = AA_ASN;

	const AA_GLU = AA_GLU;

	const AA_PRO = AA_PRO;

	const AA_ARG = AA_ARG;

	const AA_PHE = AA_PHE;

	const AA_GLN = AA_GLN;

	const AA_TYR = AA_TYR;

	const AA_HIS = AA_HIS;

	const AA_CYS = AA_CYS;

	const AA_MET = AA_MET;

	const AA_TRP = AA_TRP;

	const ACIDIC = 0;

	const ACYCLIC = 1;

	const ALIPHATIC = 2;

	const AROMATIC = 3;

	const BASIC = 4;

	const BURIED = 5;

	const CHARGED = 6;

	const CYCLIC = 7;

	const HYDROPHOBIC = 8;

	const LARGE = 9;

	const MEDIUM = 10;

	const NEGATIVE = 11;

	const NEUTRAL = 12;

	const POLAR = 13;

	const POSITIVE = 14;

	const SMALL = 15;

	const SURFACE = 16;

	const ALPHA_CARBON = 0;

	const AMINO_BACKBONE = 1;

	const BACKBONE = 2;

	const CYSTEINE_SULPHUR = 3;

	const LIGAND = 4;

	const NUCLEIC_BACKBONE = 5;

	const SHAPELY_BACKBONE = 6;

	const SHAPELY_SPECIAL = 7;

	const SIDECHAIN = 8;

	const SUGAR_PHOSPHATE = 9;

	const ALA = 0;

	const GLY = 1;

	const LEU = 2;

	const SER = 3;

	const VAL = 4;

	const THR = 5;

	const LYS = 6;

	const ASP = 7;

	const ILE = 8;

	const ASN = 9;

	const GLU = 10;

	const PRO = 11;

	const ARG = 12;

	const PHE = 13;

	const GLN = 14;

	const TYR = 15;

	const HIS = 16;

	const CYS = 17;

	const MET = 18;

	const TRP = 19;

	const ASX = 20;

	const GLX = 21;

	const PCA = 22;

	const HYP = 23;

	const A = 24;

	const C = 25;

	const G = 26;

	const T = 27;

	const U = 28;

	const UPLUS = 29;

	const I = 30;

	const _1MA = 32;

	const _5MC = 32;

	const OMC = 33;

	const _1MG = 34;

	const _2MG = 35;

	const M2G = 36;

	const _7MG = 37;

	const OMG = 38;

	const YG = 39;

	const H2U = 40;

	const _5MU = 41;

	const PSU = 42;

	const UNK = 43;

	const ACE = 44;

	const c_FOR = 45;

	const HOH = 46;

	const DOD = 47;

	const SO4 = 48;

	const PO4 = 49;

	const NAD = 50;

	const COA = 51;

	const NAP = 52;

	const NDP = 53;

	const AMINO = 0;

	const AMINO_NUCLEO = 1;

	const COENZYME = 2;

	const ION = 3;

	const NUCLEO = 4;

	const PROTEIN = 5;

	const PURINE = 6;

	const PYRIMIDINE = 7;

	const SOLVENT = 8;

	const WATER = 9;

	const OB_4RING_ATOM = OB_4RING_ATOM;

	const OB_3RING_ATOM = OB_3RING_ATOM;

	const OB_AROMATIC_ATOM = OB_AROMATIC_ATOM;

	const OB_RING_ATOM = OB_RING_ATOM;

	const OB_DONOR_ATOM = OB_DONOR_ATOM;

	const OB_ACCEPTOR_ATOM = OB_ACCEPTOR_ATOM;

	const OBATOM_TYPE_LEN = OBATOM_TYPE_LEN;

	const OB_AROMATIC_BOND = OB_AROMATIC_BOND;

	const OB_WEDGE_BOND = OB_WEDGE_BOND;

	const OB_HASH_BOND = OB_HASH_BOND;

	const OB_RING_BOND = OB_RING_BOND;

	const OB_CLOSURE_BOND = OB_CLOSURE_BOND;

	const OB_WEDGE_OR_HASH_BOND = OB_WEDGE_OR_HASH_BOND;

	const OB_SSSR_MOL = OB_SSSR_MOL;

	const OB_RINGFLAGS_MOL = OB_RINGFLAGS_MOL;

	const OB_AROMATIC_MOL = OB_AROMATIC_MOL;

	const OB_ATOMTYPES_MOL = OB_ATOMTYPES_MOL;

	const OB_CHIRALITY_MOL = OB_CHIRALITY_MOL;

	const OB_PCHARGE_MOL = OB_PCHARGE_MOL;

	const OB_HYBRID_MOL = OB_HYBRID_MOL;

	const OB_CLOSURE_MOL = OB_CLOSURE_MOL;

	const OB_H_ADDED_MOL = OB_H_ADDED_MOL;

	const OB_PH_CORRECTED_MOL = OB_PH_CORRECTED_MOL;

	const OB_CHAINS_MOL = OB_CHAINS_MOL;

	const OB_TCHARGE_MOL = OB_TCHARGE_MOL;

	const OB_TSPIN_MOL = OB_TSPIN_MOL;

	const OB_RINGTYPES_MOL = OB_RINGTYPES_MOL;

	const OB_PATTERN_STRUCTURE = OB_PATTERN_STRUCTURE;

	const OB_LSSR_MOL = OB_LSSR_MOL;

	const OB_ATOMSPIN_MOL = OB_ATOMSPIN_MOL;

	const OB_REACTION_MOL = OB_REACTION_MOL;

	const OB_CURRENT_CONFORMER = OB_CURRENT_CONFORMER;

	const AllHydrogen = 0;

	const PolarHydrogen = PolarHydrogen;

	const NonPolarHydrogen = NonPolarHydrogen;

	static function ThrowError($str) {
		ThrowError($str);
	}

	static function CartesianToInternal($arg1,$arg2) {
		CartesianToInternal($arg1,$arg2);
	}

	static function InternalToCartesian($arg1,$arg2) {
		InternalToCartesian($arg1,$arg2);
	}

	static function NewExtension($arg1,$arg2) {
		return NewExtension($arg1,$arg2);
	}

	static function NoId_get() {
		return NoId_get();
	}

	const BUFF_SIZE = BUFF_SIZE;

	static function get_rmat($arg1,$arg2,$arg3,$arg4) {
		get_rmat($arg1,$arg2,$arg3,$arg4);
	}

	static function ob_make_rmat($mat,$rmat) {
		ob_make_rmat($mat,$rmat);
	}

	static function qtrfit($r_,$f,$size,$u) {
		qtrfit($r_,$f,$size,$u);
	}

	static function superimpose($arg1,$arg2,$arg3) {
		return superimpose($arg1,$arg2,$arg3);
	}

	static function CompareRingSize($arg1,$arg2) {
		return CompareRingSize($arg1,$arg2);
	}

	static function SmartsLexReplace($arg1,$arg2) {
		SmartsLexReplace($arg1,$arg2);
	}

	static function AliasDataType_get() {
		return AliasDataType_get();
	}

	const OBFF_LOGLVL_NONE = OBFF_LOGLVL_NONE;

	const OBFF_LOGLVL_LOW = OBFF_LOGLVL_LOW;

	const OBFF_LOGLVL_MEDIUM = OBFF_LOGLVL_MEDIUM;

	const OBFF_LOGLVL_HIGH = OBFF_LOGLVL_HIGH;

	const OBFF_ENERGY = OBFF_ENERGY;

	const OBFF_EBOND = OBFF_EBOND;

	const OBFF_EANGLE = OBFF_EANGLE;

	const OBFF_ESTRBND = OBFF_ESTRBND;

	const OBFF_ETORSION = OBFF_ETORSION;

	const OBFF_EOOP = OBFF_EOOP;

	const OBFF_EVDW = OBFF_EVDW;

	const OBFF_EELECTROSTATIC = OBFF_EELECTROSTATIC;

	const OBFF_CONST_IGNORE = OBFF_CONST_IGNORE;

	const OBFF_CONST_ATOM = OBFF_CONST_ATOM;

	const OBFF_CONST_ATOM_X = OBFF_CONST_ATOM_X;

	const OBFF_CONST_ATOM_Y = OBFF_CONST_ATOM_Y;

	const OBFF_CONST_ATOM_Z = OBFF_CONST_ATOM_Z;

	const OBFF_CONST_DISTANCE = OBFF_CONST_DISTANCE;

	const OBFF_CONST_ANGLE = OBFF_CONST_ANGLE;

	const OBFF_CONST_TORSION = OBFF_CONST_TORSION;

	const OBFF_CONST_CHIRAL = OBFF_CONST_CHIRAL;

	const OBFF_NUMERICAL_GRADIENT = OBFF_NUMERICAL_GRADIENT;

	const OBFF_ANALYTICAL_GRADIENT = OBFF_ANALYTICAL_GRADIENT;

	const KCAL_TO_KJ = KCAL_TO_KJ;

	static function MapsTo($map,$queryIndex,$queriedIndex) {
		return MapsTo($map,$queryIndex,$queriedIndex);
	}

	static function FindAutomorphisms($mol_or_functor,$aut_or_mol,$symmetry_classes_or_mask=null,$mask_or_maxMemory=null,$maxMemory=null) {
		switch (func_num_args()) {
		case 2: $r=FindAutomorphisms($mol_or_functor,$aut_or_mol); break;
		case 3: $r=FindAutomorphisms($mol_or_functor,$aut_or_mol,$symmetry_classes_or_mask); break;
		case 4: $r=FindAutomorphisms($mol_or_functor,$aut_or_mol,$symmetry_classes_or_mask,$mask_or_maxMemory); break;
		default: $r=FindAutomorphisms($mol_or_functor,$aut_or_mol,$symmetry_classes_or_mask,$mask_or_maxMemory,$maxMemory);
		}
		return $r;
	}

	static function CompileMoleculeQuery($mol,$mask=null) {
		switch (func_num_args()) {
		case 1: $r=CompileMoleculeQuery($mol); break;
		default: $r=CompileMoleculeQuery($mol,$mask);
		}
		if (!is_resource($r)) return $r;
		return new OBQuery($r);
	}

	static function CompileSmilesQuery($smiles,$mask=null) {
		switch (func_num_args()) {
		case 1: $r=CompileSmilesQuery($smiles); break;
		default: $r=CompileSmilesQuery($smiles,$mask);
		}
		if (!is_resource($r)) return $r;
		return new OBQuery($r);
	}

	static function CanonicalLabels($mol,$symmetry_classes,$canonical_labels,$mask=null,$maxSeconds=5,$onlyOne=false) {
		switch (func_num_args()) {
		case 3: CanonicalLabels($mol,$symmetry_classes,$canonical_labels); break;
		default: CanonicalLabels($mol,$symmetry_classes,$canonical_labels,$mask,$maxSeconds,$onlyOne);
		}
	}

	static function PerceiveStereo($mol,$force=false) {
		PerceiveStereo($mol,$force);
	}

	static function StereoFrom2D($mol,$updown=null,$force=false) {
		StereoFrom2D($mol,$updown,$force);
	}

	static function StereoFrom3D($mol,$force=false) {
		StereoFrom3D($mol,$force);
	}

	static function StereoFrom0D($mol) {
		StereoFrom0D($mol);
	}

	static function TetrahedralFrom3D($mol,$stereoUnits,$addToMol=true) {
		return TetrahedralFrom3D($mol,$stereoUnits,$addToMol);
	}

	static function TetrahedralFrom2D($mol,$stereoUnits,$addToMol=true) {
		return TetrahedralFrom2D($mol,$stereoUnits,$addToMol);
	}

	static function TetrahedralFrom0D($mol,$stereoUnits,$addToMol=true) {
		return TetrahedralFrom0D($mol,$stereoUnits,$addToMol);
	}

	static function CisTransFrom3D($mol,$stereoUnits,$addToMol=true) {
		return CisTransFrom3D($mol,$stereoUnits,$addToMol);
	}

	static function CisTransFrom2D($mol,$stereoUnits,$updown=null,$addToMol=true) {
		return CisTransFrom2D($mol,$stereoUnits,$updown,$addToMol);
	}

	static function TetStereoToWedgeHash($mol,$updown,$from) {
		return TetStereoToWedgeHash($mol,$updown,$from);
	}

	static function GetUnspecifiedCisTrans($mol) {
		return GetUnspecifiedCisTrans($mol);
	}

	static function StereoRefToImplicit($mol,$atomId) {
		StereoRefToImplicit($mol,$atomId);
	}

	static function ImplicitRefToStereo($mol,$centerId,$newId) {
		ImplicitRefToStereo($mol,$centerId,$newId);
	}

	static function CisTransFrom0D($mol,$stereoUnits,$addToMol=true) {
		return CisTransFrom0D($mol,$stereoUnits,$addToMol);
	}

	static function FindStereogenicUnits($mol,$symClasses,$automorphisms=null) {
		switch (func_num_args()) {
		case 2: $r=FindStereogenicUnits($mol,$symClasses); break;
		default: $r=FindStereogenicUnits($mol,$symClasses,$automorphisms);
		}
		return $r;
	}

	const N_PROPERTIES = N_PROPERTIES;
}

/* PHP Proxy Classes */
class vectorInt {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_int_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorInt(); break;
		default: $this->_cPtr=new_vectorInt($n);
		}
	}

	function size() {
		return vectorInt_size($this->_cPtr);
	}

	function is_empty() {
		return vectorInt_is_empty($this->_cPtr);
	}

	function get($i) {
		return vectorInt_get($this->_cPtr,$i);
	}

	function set($i,$val) {
		vectorInt_set($this->_cPtr,$i,$val);
	}
}

class vectorUnsignedInt {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_unsigned_int_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorUnsignedInt(); break;
		default: $this->_cPtr=new_vectorUnsignedInt($n);
		}
	}

	function size() {
		return vectorUnsignedInt_size($this->_cPtr);
	}

	function is_empty() {
		return vectorUnsignedInt_is_empty($this->_cPtr);
	}

	function get($i) {
		return vectorUnsignedInt_get($this->_cPtr,$i);
	}

	function set($i,$val) {
		vectorUnsignedInt_set($this->_cPtr,$i,$val);
	}
}

class vectorvInt {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_std__vectorT_int_t_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorvInt(); break;
		default: $this->_cPtr=new_vectorvInt($n);
		}
	}

	function size() {
		return vectorvInt_size($this->_cPtr);
	}

	function is_empty() {
		return vectorvInt_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorvInt_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorInt($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorvInt_set($this->_cPtr,$i,$val);
	}
}

class vectorDouble {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_double_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorDouble(); break;
		default: $this->_cPtr=new_vectorDouble($n);
		}
	}

	function size() {
		return vectorDouble_size($this->_cPtr);
	}

	function is_empty() {
		return vectorDouble_is_empty($this->_cPtr);
	}

	function get($i) {
		return vectorDouble_get($this->_cPtr,$i);
	}

	function set($i,$val) {
		vectorDouble_set($this->_cPtr,$i,$val);
	}
}

class vectorString {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_std__string_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorString(); break;
		default: $this->_cPtr=new_vectorString($n);
		}
	}

	function size() {
		return vectorString_size($this->_cPtr);
	}

	function is_empty() {
		return vectorString_is_empty($this->_cPtr);
	}

	function get($i) {
		return vectorString_get($this->_cPtr,$i);
	}

	function set($i,$val) {
		vectorString_set($this->_cPtr,$i,$val);
	}
}

class vectorVector3 {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__vector3_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorVector3(); break;
		default: $this->_cPtr=new_vectorVector3($n);
		}
	}

	function size() {
		return vectorVector3_size($this->_cPtr);
	}

	function is_empty() {
		return vectorVector3_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorVector3_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorVector3_set($this->_cPtr,$i,$val);
	}
}

class vectorvVector3 {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_std__vectorT_OpenBabel__vector3_t_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorvVector3(); break;
		default: $this->_cPtr=new_vectorvVector3($n);
		}
	}

	function size() {
		return vectorvVector3_size($this->_cPtr);
	}

	function is_empty() {
		return vectorvVector3_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorvVector3_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorVector3($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorvVector3_set($this->_cPtr,$i,$val);
	}
}

class vectorOBMol {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__OBMol_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorOBMol(); break;
		default: $this->_cPtr=new_vectorOBMol($n);
		}
	}

	function size() {
		return vectorOBMol_size($this->_cPtr);
	}

	function is_empty() {
		return vectorOBMol_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorOBMol_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorOBMol_set($this->_cPtr,$i,$val);
	}
}

class vectorOBBond {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__OBBond_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorOBBond(); break;
		default: $this->_cPtr=new_vectorOBBond($n);
		}
	}

	function size() {
		return vectorOBBond_size($this->_cPtr);
	}

	function is_empty() {
		return vectorOBBond_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorOBBond_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorOBBond_set($this->_cPtr,$i,$val);
	}
}

class vectorOBResidue {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__OBResidue_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorOBResidue(); break;
		default: $this->_cPtr=new_vectorOBResidue($n);
		}
	}

	function size() {
		return vectorOBResidue_size($this->_cPtr);
	}

	function is_empty() {
		return vectorOBResidue_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorOBResidue_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorOBResidue_set($this->_cPtr,$i,$val);
	}
}

class vectorOBRing {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__OBRing_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorOBRing(); break;
		default: $this->_cPtr=new_vectorOBRing($n);
		}
	}

	function size() {
		return vectorOBRing_size($this->_cPtr);
	}

	function is_empty() {
		return vectorOBRing_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorOBRing_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorOBRing_set($this->_cPtr,$i,$val);
	}
}

class vectorpOBRing {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__OBRing_p_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorpOBRing(); break;
		default: $this->_cPtr=new_vectorpOBRing($n);
		}
	}

	function size() {
		return vectorpOBRing_size($this->_cPtr);
	}

	function is_empty() {
		return vectorpOBRing_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorpOBRing_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorpOBRing_set($this->_cPtr,$i,$val);
	}
}

class vectorpOBGenericData {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__OBGenericData_p_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorpOBGenericData(); break;
		default: $this->_cPtr=new_vectorpOBGenericData($n);
		}
	}

	function size() {
		return vectorpOBGenericData_size($this->_cPtr);
	}

	function is_empty() {
		return vectorpOBGenericData_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorpOBGenericData_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBGenericData($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorpOBGenericData_set($this->_cPtr,$i,$val);
	}
}

class vectorpOBInternalCoord {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_OpenBabel__OBInternalCoord_p_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vectorpOBInternalCoord(); break;
		default: $this->_cPtr=new_vectorpOBInternalCoord($n);
		}
	}

	function size() {
		return vectorpOBInternalCoord_size($this->_cPtr);
	}

	function is_empty() {
		return vectorpOBInternalCoord_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vectorpOBInternalCoord_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBInternalCoord($r);
		}
		return $r;
	}

	function set($i,$val) {
		vectorpOBInternalCoord_set($this->_cPtr,$i,$val);
	}
}

class pairUIntUInt {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'first') return pairUIntUInt_first_set($this->_cPtr,$value);
		if ($var === 'second') return pairUIntUInt_second_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'first') return pairUIntUInt_first_get($this->_cPtr);
		if ($var === 'second') return pairUIntUInt_second_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('pairUIntUInt_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($first_or_p=null,$second=null) {
		if (is_resource($first_or_p) && get_resource_type($first_or_p) === '_p_std__pairT_unsigned_int_unsigned_int_t') {
			$this->_cPtr=$first_or_p;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_pairUIntUInt(); break;
		case 1: $this->_cPtr=new_pairUIntUInt($first_or_p); break;
		default: $this->_cPtr=new_pairUIntUInt($first_or_p,$second);
		}
	}
}

class vpairUIntUInt {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_std__pairT_unsigned_int_unsigned_int_t_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vpairUIntUInt(); break;
		default: $this->_cPtr=new_vpairUIntUInt($n);
		}
	}

	function size() {
		return vpairUIntUInt_size($this->_cPtr);
	}

	function is_empty() {
		return vpairUIntUInt_is_empty($this->_cPtr);
	}

	function get($i) {
		$r=vpairUIntUInt_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new pairUIntUInt($r);
		}
		return $r;
	}

	function set($i,$val) {
		vpairUIntUInt_set($this->_cPtr,$i,$val);
	}
}

class vvpairUIntUInt {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($n=null) {
		if (is_resource($n) && get_resource_type($n) === '_p_std__vectorT_std__vectorT_std__pairT_unsigned_int_unsigned_int_t_t_t') {
			$this->_cPtr=$n;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vvpairUIntUInt(); break;
		default: $this->_cPtr=new_vvpairUIntUInt($n);
		}
	}

	function size() {
		return vvpairUIntUInt_size($this->_cPtr);
	}

	function capacity() {
		return vvpairUIntUInt_capacity($this->_cPtr);
	}

	function reserve($n) {
		vvpairUIntUInt_reserve($this->_cPtr,$n);
	}

	function clear() {
		vvpairUIntUInt_clear($this->_cPtr);
	}

	function push($x) {
		vvpairUIntUInt_push($this->_cPtr,$x);
	}

	function is_empty() {
		return vvpairUIntUInt_is_empty($this->_cPtr);
	}

	function pop() {
		$r=vvpairUIntUInt_pop($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vpairUIntUInt($r);
		}
		return $r;
	}

	function get($i) {
		$r=vvpairUIntUInt_get($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vpairUIntUInt($r);
		}
		return $r;
	}

	function set($i,$val) {
		vvpairUIntUInt_set($this->_cPtr,$i,$val);
	}
}

class OBGlobalDataBase {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBGlobalDataBase') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBGlobalDataBase();
	}

	function Init() {
		OBGlobalDataBase_Init($this->_cPtr);
	}

	function GetSize() {
		return OBGlobalDataBase_GetSize($this->_cPtr);
	}

	function SetReadDirectory($dir) {
		OBGlobalDataBase_SetReadDirectory($this->_cPtr,$dir);
	}

	function SetEnvironmentVariable($var) {
		OBGlobalDataBase_SetEnvironmentVariable($this->_cPtr,$var);
	}

	function ParseLine($arg1) {
		OBGlobalDataBase_ParseLine($this->_cPtr,$arg1);
	}
}

class OBAtomHOF {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($element,$charge,$method,$desc,$T,$value,$multiplicity,$unit) {
		if (is_resource($element) && get_resource_type($element) === '_p_OpenBabel__OBAtomHOF') {
			$this->_cPtr=$element;
			return;
		}
		$this->_cPtr=new_OBAtomHOF($element,$charge,$method,$desc,$T,$value,$multiplicity,$unit);
	}

	function Element() {
		return OBAtomHOF_Element($this->_cPtr);
	}

	function Charge() {
		return OBAtomHOF_Charge($this->_cPtr);
	}

	function Method() {
		return OBAtomHOF_Method($this->_cPtr);
	}

	function Desc() {
		return OBAtomHOF_Desc($this->_cPtr);
	}

	function T() {
		return OBAtomHOF_T($this->_cPtr);
	}

	function Value() {
		return OBAtomHOF_Value($this->_cPtr);
	}

	function Multiplicity() {
		return OBAtomHOF_Multiplicity($this->_cPtr);
	}

	function Unit() {
		return OBAtomHOF_Unit($this->_cPtr);
	}
}

class OBAtomicHeatOfFormationTable extends OBGlobalDataBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGlobalDataBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGlobalDataBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGlobalDataBase::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBAtomicHeatOfFormationTable') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBAtomicHeatOfFormationTable();
	}

	function GetHeatOfFormation($elem,$charge,$method,$T,$dhof0,$dhofT,$S0T) {
		return OBAtomicHeatOfFormationTable_GetHeatOfFormation($this->_cPtr,$elem,$charge,$method,$T,$dhof0,$dhofT,$S0T);
	}
}

class OBTypeTable extends OBGlobalDataBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGlobalDataBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGlobalDataBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGlobalDataBase::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBTypeTable') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBTypeTable();
	}

	function SetFromType($arg1) {
		return OBTypeTable_SetFromType($this->_cPtr,$arg1);
	}

	function SetToType($arg1) {
		return OBTypeTable_SetToType($this->_cPtr,$arg1);
	}

	function Translate($to_or_from,$from=null) {
		switch (func_num_args()) {
		case 1: $r=OBTypeTable_Translate($this->_cPtr,$to_or_from); break;
		default: $r=OBTypeTable_Translate($this->_cPtr,$to_or_from,$from);
		}
		return $r;
	}

	function GetFromType() {
		return OBTypeTable_GetFromType($this->_cPtr);
	}

	function GetToType() {
		return OBTypeTable_GetToType($this->_cPtr);
	}
}

class OBResidueData extends OBGlobalDataBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGlobalDataBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGlobalDataBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGlobalDataBase::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBResidueData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBResidueData();
	}

	function SetResName($arg1) {
		return OBResidueData_SetResName($this->_cPtr,$arg1);
	}

	function LookupBO($arg1,$arg2=null) {
		switch (func_num_args()) {
		case 1: $r=OBResidueData_LookupBO($this->_cPtr,$arg1); break;
		default: $r=OBResidueData_LookupBO($this->_cPtr,$arg1,$arg2);
		}
		return $r;
	}

	function LookupType($arg1,$arg2,$arg3) {
		return OBResidueData_LookupType($this->_cPtr,$arg1,$arg2,$arg3);
	}

	function AssignBonds($arg1) {
		return OBResidueData_AssignBonds($this->_cPtr,$arg1);
	}
}

class OBStopwatch {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function Start() {
		OBStopwatch_Start($this->_cPtr);
	}

	function Lap() {
		return OBStopwatch_Lap($this->_cPtr);
	}

	function Elapsed() {
		return OBStopwatch_Elapsed($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBStopwatch') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBStopwatch();
	}
}

class OBSqrtTbl {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($max=null,$incr=null) {
		if (is_resource($max) && get_resource_type($max) === '_p_OpenBabel__OBSqrtTbl') {
			$this->_cPtr=$max;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBSqrtTbl(); break;
		case 1: $this->_cPtr=new_OBSqrtTbl($max); break;
		default: $this->_cPtr=new_OBSqrtTbl($max,$incr);
		}
	}

	function Sqrt($d2) {
		return OBSqrtTbl_Sqrt($this->_cPtr,$d2);
	}

	function Init($max,$incr) {
		OBSqrtTbl_Init($this->_cPtr,$max,$incr);
	}
}

class vector3 {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($inX_or_inV_or_v=null,$inY=null,$inZ=null) {
		if (is_resource($inX_or_inV_or_v) && get_resource_type($inX_or_inV_or_v) === '_p_OpenBabel__vector3') {
			$this->_cPtr=$inX_or_inV_or_v;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_vector3(); break;
		case 1: $this->_cPtr=new_vector3($inX_or_inV_or_v); break;
		case 2: $this->_cPtr=new_vector3($inX_or_inV_or_v,$inY); break;
		default: $this->_cPtr=new_vector3($inX_or_inV_or_v,$inY,$inZ);
		}
	}

	function begin() {
		return vector3_begin($this->_cPtr);
	}

	function end() {
		return vector3_end($this->_cPtr);
	}

	function Set($inX_or_c,$inY=null,$inZ=null) {
		switch (func_num_args()) {
		case 1: vector3_Set($this->_cPtr,$inX_or_c); break;
		case 2: vector3_Set($this->_cPtr,$inX_or_c,$inY); break;
		default: vector3_Set($this->_cPtr,$inX_or_c,$inY,$inZ);
		}
	}

	function SetX($inX) {
		vector3_SetX($this->_cPtr,$inX);
	}

	function SetY($inY) {
		vector3_SetY($this->_cPtr,$inY);
	}

	function SetZ($inZ) {
		vector3_SetZ($this->_cPtr,$inZ);
	}

	function GetX() {
		return vector3_GetX($this->_cPtr);
	}

	function GetY() {
		return vector3_GetY($this->_cPtr);
	}

	function GetZ() {
		return vector3_GetZ($this->_cPtr);
	}

	function Get($c_) {
		vector3_Get($this->_cPtr,$c_);
	}

	function AsArray() {
		return vector3_AsArray($this->_cPtr);
	}

	function add($v_or_f) {
		$r=vector3_add($this->_cPtr,$v_or_f);
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function randomUnitVector() {
		vector3_randomUnitVector($this->_cPtr);
	}

	function normalize() {
		$r=vector3_normalize($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function CanBeNormalized() {
		return vector3_CanBeNormalized($this->_cPtr);
	}

	function length_2() {
		return vector3_length_2($this->_cPtr);
	}

	function length() {
		return vector3_length($this->_cPtr);
	}

	function x() {
		return vector3_x($this->_cPtr);
	}

	function y() {
		return vector3_y($this->_cPtr);
	}

	function z() {
		return vector3_z($this->_cPtr);
	}

	function IsApprox($other,$precision) {
		return vector3_IsApprox($this->_cPtr,$other,$precision);
	}

	function distSq($vv) {
		return vector3_distSq($this->_cPtr,$vv);
	}

	function createOrthoVector($v) {
		return vector3_createOrthoVector($this->_cPtr,$v);
	}
}

class matrix3x3 {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($s_or_row1_or_d=null,$row2=null,$row3=null) {
		if (is_resource($s_or_row1_or_d) && get_resource_type($s_or_row1_or_d) === '_p_OpenBabel__matrix3x3') {
			$this->_cPtr=$s_or_row1_or_d;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_matrix3x3(); break;
		case 1: $this->_cPtr=new_matrix3x3($s_or_row1_or_d); break;
		case 2: $this->_cPtr=new_matrix3x3($s_or_row1_or_d,$row2); break;
		default: $this->_cPtr=new_matrix3x3($s_or_row1_or_d,$row2,$row3);
		}
	}

	function GetArray($m) {
		matrix3x3_GetArray($this->_cPtr,$m);
	}

	function inverse() {
		$r=matrix3x3_inverse($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}

	function transpose() {
		$r=matrix3x3_transpose($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}

	function determinant() {
		return matrix3x3_determinant($this->_cPtr);
	}

	function isSymmetric() {
		return matrix3x3_isSymmetric($this->_cPtr);
	}

	function isOrthogonal() {
		return matrix3x3_isOrthogonal($this->_cPtr);
	}

	function isDiagonal() {
		return matrix3x3_isDiagonal($this->_cPtr);
	}

	function isUnitMatrix() {
		return matrix3x3_isUnitMatrix($this->_cPtr);
	}

	function Get($row,$column) {
		return matrix3x3_Get($this->_cPtr,$row,$column);
	}

	function Set($row,$column,$v) {
		matrix3x3_Set($this->_cPtr,$row,$column,$v);
	}

	function SetColumn($column,$v) {
		matrix3x3_SetColumn($this->_cPtr,$column,$v);
	}

	function SetRow($row,$v) {
		matrix3x3_SetRow($this->_cPtr,$row,$v);
	}

	function GetColumn($col) {
		$r=matrix3x3_GetColumn($this->_cPtr,$col);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetRow($row) {
		$r=matrix3x3_GetRow($this->_cPtr,$row);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function SetupRotMat($x,$y,$z) {
		matrix3x3_SetupRotMat($this->_cPtr,$x,$y,$z);
	}

	function PlaneReflection($norm) {
		matrix3x3_PlaneReflection($this->_cPtr,$norm);
	}

	function RotAboutAxisByAngle($axis,$angle) {
		matrix3x3_RotAboutAxisByAngle($this->_cPtr,$axis,$angle);
	}

	function FillOrth($alpha,$beta,$gamma,$a,$b,$c_) {
		matrix3x3_FillOrth($this->_cPtr,$alpha,$beta,$gamma,$a,$b,$c_);
	}

	function findEigenvectorsIfSymmetric($eigenvals) {
		$r=matrix3x3_findEigenvectorsIfSymmetric($this->_cPtr,$eigenvals);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}

	static function jacobi($n,$a,$d,$v) {
		matrix3x3_jacobi($n,$a,$d,$v);
	}
}

class transform3d {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($m_or_s_or_row1_or_d=null,$v_or_row2_or_t=null,$row3=null,$translation=null) {
		if (is_resource($m_or_s_or_row1_or_d) && get_resource_type($m_or_s_or_row1_or_d) === '_p_OpenBabel__transform3d') {
			$this->_cPtr=$m_or_s_or_row1_or_d;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_transform3d(); break;
		case 1: $this->_cPtr=new_transform3d($m_or_s_or_row1_or_d); break;
		case 2: $this->_cPtr=new_transform3d($m_or_s_or_row1_or_d,$v_or_row2_or_t); break;
		case 3: $this->_cPtr=new_transform3d($m_or_s_or_row1_or_d,$v_or_row2_or_t,$row3); break;
		default: $this->_cPtr=new_transform3d($m_or_s_or_row1_or_d,$v_or_row2_or_t,$row3,$translation);
		}
	}

	function DescribeAsString() {
		return transform3d_DescribeAsString($this->_cPtr);
	}

	function DescribeAsValues() {
		return transform3d_DescribeAsValues($this->_cPtr);
	}

	function Normalize() {
		transform3d_Normalize($this->_cPtr);
	}
}

class SpaceGroup {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'HEXAGONAL_ORIGIN') return SpaceGroup_HEXAGONAL_ORIGIN_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('SpaceGroup_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__SpaceGroup') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_SpaceGroup();
	}

	function SetHMName($name) {
		SpaceGroup_SetHMName($this->_cPtr,$name);
	}

	function SetHallName($name) {
		SpaceGroup_SetHallName($this->_cPtr,$name);
	}

	function SetId($n) {
		SpaceGroup_SetId($this->_cPtr,$n);
	}

	function AddTransform($s) {
		SpaceGroup_AddTransform($this->_cPtr,$s);
	}

	function GetHMName() {
		return SpaceGroup_GetHMName($this->_cPtr);
	}

	function GetHallName() {
		return SpaceGroup_GetHallName($this->_cPtr);
	}

	function GetId() {
		return SpaceGroup_GetId($this->_cPtr);
	}

	function GetOriginAlternative() {
		return SpaceGroup_GetOriginAlternative($this->_cPtr);
	}

	function Transform($v) {
		return SpaceGroup_Transform($this->_cPtr,$v);
	}

	function BeginTransform($i) {
		$r=SpaceGroup_BeginTransform($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new transform3d($r);
		}
		return $r;
	}

	function NextTransform($i) {
		$r=SpaceGroup_NextTransform($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new transform3d($r);
		}
		return $r;
	}

	static function GetSpaceGroup($name_or_id) {
		$r=SpaceGroup_GetSpaceGroup($name_or_id);
		if (!is_resource($r)) return $r;
		return new SpaceGroup($r);
	}

	static function Find($group) {
		$r=SpaceGroup_Find($group);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new SpaceGroup($r);
		}
		return $r;
	}

	function IsValid() {
		return SpaceGroup_IsValid($this->_cPtr);
	}
}

class OBBitVec {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($size_in_bits_or_bv=null) {
		if (is_resource($size_in_bits_or_bv) && get_resource_type($size_in_bits_or_bv) === '_p_OpenBabel__OBBitVec') {
			$this->_cPtr=$size_in_bits_or_bv;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBBitVec(); break;
		default: $this->_cPtr=new_OBBitVec($size_in_bits_or_bv);
		}
	}

	function SetBitOn($bit_offset) {
		OBBitVec_SetBitOn($this->_cPtr,$bit_offset);
	}

	function SetBitOff($bit_offset) {
		OBBitVec_SetBitOff($this->_cPtr,$bit_offset);
	}

	function SetRangeOn($lo_bit_offset,$hi_bit_offset) {
		OBBitVec_SetRangeOn($this->_cPtr,$lo_bit_offset,$hi_bit_offset);
	}

	function SetRangeOff($lo_bit_offset,$hi_bit_offset) {
		OBBitVec_SetRangeOff($this->_cPtr,$lo_bit_offset,$hi_bit_offset);
	}

	function Fold($new_bit_size) {
		OBBitVec_Fold($this->_cPtr,$new_bit_size);
	}

	function FirstBit($bit_offset=0) {
		return OBBitVec_FirstBit($this->_cPtr,$bit_offset);
	}

	function NextBit($last_bit_offset) {
		return OBBitVec_NextBit($this->_cPtr,$last_bit_offset);
	}

	function EndBit() {
		return OBBitVec_EndBit($this->_cPtr);
	}

	function GetSize() {
		return OBBitVec_GetSize($this->_cPtr);
	}

	function CountBits() {
		return OBBitVec_CountBits($this->_cPtr);
	}

	function IsEmpty() {
		return OBBitVec_IsEmpty($this->_cPtr);
	}

	function Resize($size_in_bits) {
		return OBBitVec_Resize($this->_cPtr,$size_in_bits);
	}

	function ResizeWords($size_in_words) {
		return OBBitVec_ResizeWords($this->_cPtr,$size_in_words);
	}

	function BitIsSet($bit_offset) {
		return OBBitVec_BitIsSet($this->_cPtr,$bit_offset);
	}

	function FromVecInt($bit_offsets) {
		OBBitVec_FromVecInt($this->_cPtr,$bit_offsets);
	}

	function FromString($line,$bits) {
		OBBitVec_FromString($this->_cPtr,$line,$bits);
	}

	function ToVecInt($bit_offsets) {
		OBBitVec_ToVecInt($this->_cPtr,$bit_offsets);
	}

	function Clear() {
		OBBitVec_Clear($this->_cPtr);
	}

	function Negate() {
		OBBitVec_Negate($this->_cPtr);
	}

	function GetWords($vec) {
		OBBitVec_GetWords($this->_cPtr,$vec);
	}

	function add($bv) {
		$r=OBBitVec_add($this->_cPtr,$bv);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBitVec($r);
		}
		return $r;
	}
}

class OBGenericData {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($attr=null,$type=null,$source=null) {
		if (is_resource($attr) && get_resource_type($attr) === '_p_OpenBabel__OBGenericData') {
			$this->_cPtr=$attr;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBGenericData(); break;
		case 1: $this->_cPtr=new_OBGenericData($attr); break;
		case 2: $this->_cPtr=new_OBGenericData($attr,$type); break;
		default: $this->_cPtr=new_OBGenericData($attr,$type,$source);
		}
	}

	function c_Clone($arg1) {
		$r=OBGenericData_c_Clone($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBGenericData($r);
		}
		return $r;
	}

	function SetAttribute($v) {
		OBGenericData_SetAttribute($this->_cPtr,$v);
	}

	function SetOrigin($s) {
		OBGenericData_SetOrigin($this->_cPtr,$s);
	}

	function GetAttribute() {
		return OBGenericData_GetAttribute($this->_cPtr);
	}

	function GetDataType() {
		return OBGenericData_GetDataType($this->_cPtr);
	}

	function GetValue() {
		return OBGenericData_GetValue($this->_cPtr);
	}

	function GetOrigin() {
		return OBGenericData_GetOrigin($this->_cPtr);
	}
}

class OBBase {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function Clear() {
		return OBBase_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBBase_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	static function ClassDescription() {
		return OBBase_ClassDescription();
	}

	function GetTitle($replaceNewlines=true) {
		return OBBase_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBBase_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBBase_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBBase_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBBase_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBBase_DataSize($this->_cPtr);
	}

	function GetAllData($type) {
		$r=OBBase_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBBase_GetData($this->_cPtr); break;
		default: $r=OBBase_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function BeginData() {
		return OBBase_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBBase_EndData($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBBase') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBBase();
	}
}

class OBCommentData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($arg1=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBCommentData') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBCommentData(); break;
		default: $this->_cPtr=new_OBCommentData($arg1);
		}
	}

	function SetData($data_or_d) {
		OBCommentData_SetData($this->_cPtr,$data_or_d);
	}

	function GetData() {
		return OBCommentData_GetData($this->_cPtr);
	}
}

class OBExternalBond {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($arg1=null,$arg2=null,$arg3=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBExternalBond') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBExternalBond(); break;
		case 1: $this->_cPtr=new_OBExternalBond($arg1); break;
		case 2: $this->_cPtr=new_OBExternalBond($arg1,$arg2); break;
		default: $this->_cPtr=new_OBExternalBond($arg1,$arg2,$arg3);
		}
	}

	function GetIdx() {
		return OBExternalBond_GetIdx($this->_cPtr);
	}

	function GetAtom() {
		$r=OBExternalBond_GetAtom($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetBond() {
		$r=OBExternalBond_GetBond($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function SetIdx($idx) {
		OBExternalBond_SetIdx($this->_cPtr,$idx);
	}

	function SetAtom($atom) {
		OBExternalBond_SetAtom($this->_cPtr,$atom);
	}

	function SetBond($bond) {
		OBExternalBond_SetBond($this->_cPtr,$bond);
	}
}

class OBExternalBondData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBExternalBondData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBExternalBondData();
	}

	function SetData($arg1,$arg2,$arg3) {
		OBExternalBondData_SetData($this->_cPtr,$arg1,$arg2,$arg3);
	}

	function GetData() {
		return OBExternalBondData_GetData($this->_cPtr);
	}
}

class OBPairData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBPairData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBPairData();
	}

	function SetValue($v) {
		OBPairData_SetValue($this->_cPtr,$v);
	}
}

class OBSetData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBSetData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBSetData();
	}

	function AddData($d) {
		OBSetData_AddData($this->_cPtr,$d);
	}

	function SetData($vdata) {
		OBSetData_SetData($this->_cPtr,$vdata);
	}

	function GetData($s=null) {
		switch (func_num_args()) {
		case 0: $r=OBSetData_GetData($this->_cPtr); break;
		default: $r=OBSetData_GetData($this->_cPtr,$s);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetBegin() {
		return OBSetData_GetBegin($this->_cPtr);
	}

	function GetEnd() {
		return OBSetData_GetEnd($this->_cPtr);
	}

	function DeleteData($gd) {
		OBSetData_DeleteData($this->_cPtr,$gd);
	}
}

class OBVirtualBond extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($arg1=null,$arg2=null,$arg3=null,$stereo=0) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBVirtualBond') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBVirtualBond(); break;
		case 1: $this->_cPtr=new_OBVirtualBond($arg1); break;
		case 2: $this->_cPtr=new_OBVirtualBond($arg1,$arg2); break;
		default: $this->_cPtr=new_OBVirtualBond($arg1,$arg2,$arg3,$stereo);
		}
	}

	function GetBgn() {
		return OBVirtualBond_GetBgn($this->_cPtr);
	}

	function GetEnd() {
		return OBVirtualBond_GetEnd($this->_cPtr);
	}

	function GetOrder() {
		return OBVirtualBond_GetOrder($this->_cPtr);
	}

	function GetStereo() {
		return OBVirtualBond_GetStereo($this->_cPtr);
	}
}

class OBRingData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($arg1=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBRingData') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBRingData(); break;
		default: $this->_cPtr=new_OBRingData($arg1);
		}
	}

	function SetData($vr) {
		OBRingData_SetData($this->_cPtr,$vr);
	}

	function PushBack($r_) {
		OBRingData_PushBack($this->_cPtr,$r_);
	}

	function GetData() {
		$r=OBRingData_GetData($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBRing($r);
		}
		return $r;
	}

	function BeginRings() {
		return OBRingData_BeginRings($this->_cPtr);
	}

	function EndRings() {
		return OBRingData_EndRings($this->_cPtr);
	}

	function BeginRing($i) {
		$r=OBRingData_BeginRing($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function NextRing($i) {
		$r=OBRingData_NextRing($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}
}

class OBUnitCell extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	const Undefined = 0;

	const Triclinic = OBUnitCell_Triclinic;

	const Monoclinic = OBUnitCell_Monoclinic;

	const Orthorhombic = OBUnitCell_Orthorhombic;

	const Tetragonal = OBUnitCell_Tetragonal;

	const Rhombohedral = OBUnitCell_Rhombohedral;

	const Hexagonal = OBUnitCell_Hexagonal;

	const Cubic = OBUnitCell_Cubic;

	function __construct($arg1=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBUnitCell') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBUnitCell(); break;
		default: $this->_cPtr=new_OBUnitCell($arg1);
		}
	}

	function SetData($a_or_v1_or_m,$b_or_v2=null,$c_or_v3=null,$alpha=null,$beta=null,$gamma=null) {
		switch (func_num_args()) {
		case 1: OBUnitCell_SetData($this->_cPtr,$a_or_v1_or_m); break;
		case 2: OBUnitCell_SetData($this->_cPtr,$a_or_v1_or_m,$b_or_v2); break;
		case 3: OBUnitCell_SetData($this->_cPtr,$a_or_v1_or_m,$b_or_v2,$c_or_v3); break;
		case 4: OBUnitCell_SetData($this->_cPtr,$a_or_v1_or_m,$b_or_v2,$c_or_v3,$alpha); break;
		case 5: OBUnitCell_SetData($this->_cPtr,$a_or_v1_or_m,$b_or_v2,$c_or_v3,$alpha,$beta); break;
		default: OBUnitCell_SetData($this->_cPtr,$a_or_v1_or_m,$b_or_v2,$c_or_v3,$alpha,$beta,$gamma);
		}
	}

	function SetOffset($v1) {
		OBUnitCell_SetOffset($this->_cPtr,$v1);
	}

	function SetSpaceGroup($sg) {
		OBUnitCell_SetSpaceGroup($this->_cPtr,$sg);
	}

	function SetLatticeType($lt) {
		OBUnitCell_SetLatticeType($this->_cPtr,$lt);
	}

	function FillUnitCell($arg1) {
		OBUnitCell_FillUnitCell($this->_cPtr,$arg1);
	}

	function GetA() {
		return OBUnitCell_GetA($this->_cPtr);
	}

	function GetB() {
		return OBUnitCell_GetB($this->_cPtr);
	}

	function GetC() {
		return OBUnitCell_GetC($this->_cPtr);
	}

	function GetAlpha() {
		return OBUnitCell_GetAlpha($this->_cPtr);
	}

	function GetBeta() {
		return OBUnitCell_GetBeta($this->_cPtr);
	}

	function GetGamma() {
		return OBUnitCell_GetGamma($this->_cPtr);
	}

	function GetOffset() {
		$r=OBUnitCell_GetOffset($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetSpaceGroup() {
		$r=OBUnitCell_GetSpaceGroup($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new SpaceGroup($r);
	}

	function GetSpaceGroupName() {
		return OBUnitCell_GetSpaceGroupName($this->_cPtr);
	}

	function GetLatticeType($spacegroup=null) {
		switch (func_num_args()) {
		case 0: $r=OBUnitCell_GetLatticeType($this->_cPtr); break;
		default: $r=OBUnitCell_GetLatticeType($this->_cPtr,$spacegroup);
		}
		return $r;
	}

	function GetCellVectors() {
		$r=OBUnitCell_GetCellVectors($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorVector3($r);
		}
		return $r;
	}

	function GetCellMatrix() {
		$r=OBUnitCell_GetCellMatrix($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}

	function GetOrthoMatrix() {
		$r=OBUnitCell_GetOrthoMatrix($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}

	function GetOrientationMatrix() {
		$r=OBUnitCell_GetOrientationMatrix($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}

	function GetFractionalMatrix() {
		$r=OBUnitCell_GetFractionalMatrix($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}

	function FractionalToCartesian($frac) {
		$r=OBUnitCell_FractionalToCartesian($this->_cPtr,$frac);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function CartesianToFractional($cart) {
		$r=OBUnitCell_CartesianToFractional($this->_cPtr,$cart);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function WrapCartesianCoordinate($cart) {
		$r=OBUnitCell_WrapCartesianCoordinate($this->_cPtr,$cart);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function WrapFractionalCoordinate($frac) {
		$r=OBUnitCell_WrapFractionalCoordinate($this->_cPtr,$frac);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetSpaceGroupNumber($name=null) {
		switch (func_num_args()) {
		case 0: $r=OBUnitCell_GetSpaceGroupNumber($this->_cPtr); break;
		default: $r=OBUnitCell_GetSpaceGroupNumber($this->_cPtr,$name);
		}
		return $r;
	}

	function GetCellVolume() {
		return OBUnitCell_GetCellVolume($this->_cPtr);
	}
}

class OBConformerData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($arg1=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBConformerData') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBConformerData(); break;
		default: $this->_cPtr=new_OBConformerData($arg1);
		}
	}

	function SetDimension($vd) {
		OBConformerData_SetDimension($this->_cPtr,$vd);
	}

	function SetEnergies($ve) {
		OBConformerData_SetEnergies($this->_cPtr,$ve);
	}

	function SetForces($vf) {
		OBConformerData_SetForces($this->_cPtr,$vf);
	}

	function SetVelocities($vv) {
		OBConformerData_SetVelocities($this->_cPtr,$vv);
	}

	function SetDisplacements($vd) {
		OBConformerData_SetDisplacements($this->_cPtr,$vd);
	}

	function SetData($vdat) {
		OBConformerData_SetData($this->_cPtr,$vdat);
	}

	function GetDimension() {
		return OBConformerData_GetDimension($this->_cPtr);
	}

	function GetEnergies() {
		$r=OBConformerData_GetEnergies($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetForces() {
		$r=OBConformerData_GetForces($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorvVector3($r);
		}
		return $r;
	}

	function GetVelocities() {
		$r=OBConformerData_GetVelocities($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorvVector3($r);
		}
		return $r;
	}

	function GetDisplacements() {
		$r=OBConformerData_GetDisplacements($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorvVector3($r);
		}
		return $r;
	}

	function GetData() {
		$r=OBConformerData_GetData($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorString($r);
		}
		return $r;
	}
}

class OBSymmetryData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($arg1=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBSymmetryData') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBSymmetryData(); break;
		default: $this->_cPtr=new_OBSymmetryData($arg1);
		}
	}

	function SetData($pg,$sg=null) {
		switch (func_num_args()) {
		case 1: OBSymmetryData_SetData($this->_cPtr,$pg); break;
		default: OBSymmetryData_SetData($this->_cPtr,$pg,$sg);
		}
	}

	function SetPointGroup($pg) {
		OBSymmetryData_SetPointGroup($this->_cPtr,$pg);
	}

	function SetSpaceGroup($sg) {
		OBSymmetryData_SetSpaceGroup($this->_cPtr,$sg);
	}

	function GetPointGroup() {
		return OBSymmetryData_GetPointGroup($this->_cPtr);
	}

	function GetSpaceGroup() {
		return OBSymmetryData_GetSpaceGroup($this->_cPtr);
	}
}

class OBTorsion {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($arg1) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBTorsion') {
			$this->_cPtr=$arg1;
			return;
		}
		$this->_cPtr=new_OBTorsion($arg1);
	}

	function Clear() {
		OBTorsion_Clear($this->_cPtr);
	}

	function c_Empty() {
		return OBTorsion_c_Empty($this->_cPtr);
	}

	function AddTorsion($a_or_atoms,$b=null,$c_=null,$d=null) {
		switch (func_num_args()) {
		case 1: $r=OBTorsion_AddTorsion($this->_cPtr,$a_or_atoms); break;
		case 2: $r=OBTorsion_AddTorsion($this->_cPtr,$a_or_atoms,$b); break;
		case 3: $r=OBTorsion_AddTorsion($this->_cPtr,$a_or_atoms,$b,$c_); break;
		default: $r=OBTorsion_AddTorsion($this->_cPtr,$a_or_atoms,$b,$c_,$d);
		}
		return $r;
	}

	function SetAngle($radians,$index=0) {
		return OBTorsion_SetAngle($this->_cPtr,$radians,$index);
	}

	function SetData($arg1) {
		return OBTorsion_SetData($this->_cPtr,$arg1);
	}

	function GetAngle($radians,$index=0) {
		return OBTorsion_GetAngle($this->_cPtr,$radians,$index);
	}

	function GetBondIdx() {
		return OBTorsion_GetBondIdx($this->_cPtr);
	}

	function GetSize() {
		return OBTorsion_GetSize($this->_cPtr);
	}

	function GetBC() {
		return OBTorsion_GetBC($this->_cPtr);
	}

	function GetADs() {
		return OBTorsion_GetADs($this->_cPtr);
	}

	function IsProtonRotor() {
		return OBTorsion_IsProtonRotor($this->_cPtr);
	}
}

class OBTorsionData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	function Clear() {
		OBTorsionData_Clear($this->_cPtr);
	}

	function GetData() {
		return OBTorsionData_GetData($this->_cPtr);
	}

	function GetSize() {
		return OBTorsionData_GetSize($this->_cPtr);
	}

	function SetData($torsion) {
		OBTorsionData_SetData($this->_cPtr,$torsion);
	}

	function FillTorsionArray($torsions) {
		return OBTorsionData_FillTorsionArray($this->_cPtr,$torsions);
	}
}

class OBAngle {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($arg1) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBAngle') {
			$this->_cPtr=$arg1;
			return;
		}
		$this->_cPtr=new_OBAngle($arg1);
	}

	function Clear() {
		OBAngle_Clear($this->_cPtr);
	}

	function GetAngle() {
		return OBAngle_GetAngle($this->_cPtr);
	}

	function SetAngle($angle) {
		OBAngle_SetAngle($this->_cPtr,$angle);
	}

	function SetAtoms($vertex_or_atoms,$a=null,$b=null) {
		switch (func_num_args()) {
		case 1: OBAngle_SetAtoms($this->_cPtr,$vertex_or_atoms); break;
		case 2: OBAngle_SetAtoms($this->_cPtr,$vertex_or_atoms,$a); break;
		default: OBAngle_SetAtoms($this->_cPtr,$vertex_or_atoms,$a,$b);
		}
	}
}

class OBAngleData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	function Clear() {
		OBAngleData_Clear($this->_cPtr);
	}

	function FillAngleArray($angles,$size=null) {
		switch (func_num_args()) {
		case 1: $r=OBAngleData_FillAngleArray($this->_cPtr,$angles); break;
		default: $r=OBAngleData_FillAngleArray($this->_cPtr,$angles,$size);
		}
		return $r;
	}

	function SetData($arg1) {
		OBAngleData_SetData($this->_cPtr,$arg1);
	}

	function GetSize() {
		return OBAngleData_GetSize($this->_cPtr);
	}
}

class OBSerialNums extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($cp=null) {
		if (is_resource($cp) && get_resource_type($cp) === '_p_OpenBabel__OBSerialNums') {
			$this->_cPtr=$cp;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBSerialNums(); break;
		default: $this->_cPtr=new_OBSerialNums($cp);
		}
	}

	function GetData() {
		return OBSerialNums_GetData($this->_cPtr);
	}

	function SetData($sm) {
		OBSerialNums_SetData($this->_cPtr,$sm);
	}
}

class OBVibrationData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBVibrationData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBVibrationData();
	}

	function SetData($lx,$frequencies,$intensities,$arg4=null) {
		switch (func_num_args()) {
		case 3: OBVibrationData_SetData($this->_cPtr,$lx,$frequencies,$intensities); break;
		default: OBVibrationData_SetData($this->_cPtr,$lx,$frequencies,$intensities,$arg4);
		}
	}

	function GetLx() {
		$r=OBVibrationData_GetLx($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorvVector3($r);
		}
		return $r;
	}

	function GetFrequencies() {
		$r=OBVibrationData_GetFrequencies($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetIntensities() {
		$r=OBVibrationData_GetIntensities($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetRamanActivities() {
		$r=OBVibrationData_GetRamanActivities($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetNumberOfFrequencies() {
		return OBVibrationData_GetNumberOfFrequencies($this->_cPtr);
	}
}

class OBDOSData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBDOSData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBDOSData();
	}

	function SetData($arg1,$arg2,$arg3,$arg4) {
		OBDOSData_SetData($this->_cPtr,$arg1,$arg2,$arg3,$arg4);
	}

	function GetFermiEnergy() {
		return OBDOSData_GetFermiEnergy($this->_cPtr);
	}

	function GetEnergies() {
		$r=OBDOSData_GetEnergies($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetDensities() {
		$r=OBDOSData_GetDensities($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetIntegration() {
		$r=OBDOSData_GetIntegration($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}
}

class OBOrbital {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function SetData($energy,$occupation=2.0,$symbol=null) {
		switch (func_num_args()) {
		case 1: case 2: OBOrbital_SetData($this->_cPtr,$energy,$occupation); break;
		default: OBOrbital_SetData($this->_cPtr,$energy,$occupation,$symbol);
		}
	}

	function GetEnergy() {
		return OBOrbital_GetEnergy($this->_cPtr);
	}

	function GetOccupation() {
		return OBOrbital_GetOccupation($this->_cPtr);
	}

	function GetSymbol() {
		return OBOrbital_GetSymbol($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBOrbital') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBOrbital();
	}
}

class OBOrbitalData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBOrbitalData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBOrbitalData();
	}

	function SetAlphaOrbitals($orbitalList) {
		OBOrbitalData_SetAlphaOrbitals($this->_cPtr,$orbitalList);
	}

	function SetBetaOrbitals($orbitalList) {
		OBOrbitalData_SetBetaOrbitals($this->_cPtr,$orbitalList);
	}

	function SetHOMO($alpha,$beta=0) {
		OBOrbitalData_SetHOMO($this->_cPtr,$alpha,$beta);
	}

	function SetOpenShell($openShell) {
		OBOrbitalData_SetOpenShell($this->_cPtr,$openShell);
	}

	function IsOpenShell() {
		return OBOrbitalData_IsOpenShell($this->_cPtr);
	}

	function GetAlphaHOMO() {
		return OBOrbitalData_GetAlphaHOMO($this->_cPtr);
	}

	function GetBetaHOMO() {
		return OBOrbitalData_GetBetaHOMO($this->_cPtr);
	}

	function GetAlphaOrbitals() {
		return OBOrbitalData_GetAlphaOrbitals($this->_cPtr);
	}

	function GetBetaOrbitals() {
		return OBOrbitalData_GetBetaOrbitals($this->_cPtr);
	}

	function LoadClosedShellOrbitals($energies,$symmetries,$alphaHOMO) {
		OBOrbitalData_LoadClosedShellOrbitals($this->_cPtr,$energies,$symmetries,$alphaHOMO);
	}

	function LoadAlphaOrbitals($energies,$symmetries,$alphaHOMO) {
		OBOrbitalData_LoadAlphaOrbitals($this->_cPtr,$energies,$symmetries,$alphaHOMO);
	}

	function LoadBetaOrbitals($energies,$symmetries,$betaHOMO) {
		OBOrbitalData_LoadBetaOrbitals($this->_cPtr,$energies,$symmetries,$betaHOMO);
	}
}

class OBElectronicTransitionData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBElectronicTransitionData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBElectronicTransitionData();
	}

	function SetData($wavelengths,$forces) {
		OBElectronicTransitionData_SetData($this->_cPtr,$wavelengths,$forces);
	}

	function SetEDipole($arg1) {
		OBElectronicTransitionData_SetEDipole($this->_cPtr,$arg1);
	}

	function SetRotatoryStrengthsVelocity($arg1) {
		OBElectronicTransitionData_SetRotatoryStrengthsVelocity($this->_cPtr,$arg1);
	}

	function SetRotatoryStrengthsLength($arg1) {
		OBElectronicTransitionData_SetRotatoryStrengthsLength($this->_cPtr,$arg1);
	}

	function GetWavelengths() {
		$r=OBElectronicTransitionData_GetWavelengths($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetForces() {
		$r=OBElectronicTransitionData_GetForces($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetEDipole() {
		$r=OBElectronicTransitionData_GetEDipole($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetRotatoryStrengthsVelocity() {
		$r=OBElectronicTransitionData_GetRotatoryStrengthsVelocity($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetRotatoryStrengthsLength() {
		$r=OBElectronicTransitionData_GetRotatoryStrengthsLength($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}
}

class OBRotationData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	const UNKNOWN = 0;

	const ASYMMETRIC = OBRotationData_ASYMMETRIC;

	const SYMMETRIC = OBRotationData_SYMMETRIC;

	const LINEAR = OBRotationData_LINEAR;

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRotationData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRotationData();
	}

	function SetData($RotorType,$RotationalConstants,$SymmetryNumber) {
		OBRotationData_SetData($this->_cPtr,$RotorType,$RotationalConstants,$SymmetryNumber);
	}

	function GetRotConsts() {
		$r=OBRotationData_GetRotConsts($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetSymmetryNumber() {
		return OBRotationData_GetSymmetryNumber($this->_cPtr);
	}

	function GetRotorType() {
		return OBRotationData_GetRotorType($this->_cPtr);
	}
}

class OBVectorData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBVectorData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBVectorData();
	}

	function SetData($x_or_data,$y=null,$z=null) {
		switch (func_num_args()) {
		case 1: OBVectorData_SetData($this->_cPtr,$x_or_data); break;
		case 2: OBVectorData_SetData($this->_cPtr,$x_or_data,$y); break;
		default: OBVectorData_SetData($this->_cPtr,$x_or_data,$y,$z);
		}
	}

	function GetData() {
		$r=OBVectorData_GetData($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}
}

class OBMatrixData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBMatrixData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBMatrixData();
	}

	function SetData($data) {
		OBMatrixData_SetData($this->_cPtr,$data);
	}

	function GetData() {
		$r=OBMatrixData_GetData($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new matrix3x3($r);
		}
		return $r;
	}
}

class OBFreeGridPoint {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($x=null,$y=null,$z=null,$V=null) {
		if (is_resource($x) && get_resource_type($x) === '_p_OpenBabel__OBFreeGridPoint') {
			$this->_cPtr=$x;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBFreeGridPoint(); break;
		case 1: $this->_cPtr=new_OBFreeGridPoint($x); break;
		case 2: $this->_cPtr=new_OBFreeGridPoint($x,$y); break;
		case 3: $this->_cPtr=new_OBFreeGridPoint($x,$y,$z); break;
		default: $this->_cPtr=new_OBFreeGridPoint($x,$y,$z,$V);
		}
	}

	function GetX() {
		return OBFreeGridPoint_GetX($this->_cPtr);
	}

	function GetY() {
		return OBFreeGridPoint_GetY($this->_cPtr);
	}

	function GetZ() {
		return OBFreeGridPoint_GetZ($this->_cPtr);
	}

	function GetV() {
		return OBFreeGridPoint_GetV($this->_cPtr);
	}

	function SetX($x) {
		OBFreeGridPoint_SetX($this->_cPtr,$x);
	}

	function SetY($y) {
		OBFreeGridPoint_SetY($this->_cPtr,$y);
	}

	function SetZ($z) {
		OBFreeGridPoint_SetZ($this->_cPtr,$z);
	}

	function SetV($V) {
		OBFreeGridPoint_SetV($this->_cPtr,$V);
	}
}

class OBFreeGrid extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBFreeGrid') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBFreeGrid();
	}

	function NumPoints() {
		return OBFreeGrid_NumPoints($this->_cPtr);
	}

	function AddPoint($x,$y,$z,$V) {
		OBFreeGrid_AddPoint($this->_cPtr,$x,$y,$z,$V);
	}

	function BeginPoints() {
		return OBFreeGrid_BeginPoints($this->_cPtr);
	}

	function EndPoints() {
		return OBFreeGrid_EndPoints($this->_cPtr);
	}

	function BeginPoint($i) {
		$r=OBFreeGrid_BeginPoint($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBFreeGridPoint($r);
		}
		return $r;
	}

	function NextPoint($i) {
		$r=OBFreeGrid_NextPoint($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBFreeGridPoint($r);
		}
		return $r;
	}

	function Clear() {
		OBFreeGrid_Clear($this->_cPtr);
	}
}

class OBPcharge extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBPcharge') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBPcharge();
	}

	function NumPartialCharges() {
		return OBPcharge_NumPartialCharges($this->_cPtr);
	}

	function AddPartialCharge($q) {
		OBPcharge_AddPartialCharge($this->_cPtr,$q);
	}

	function GetPartialCharge() {
		$r=OBPcharge_GetPartialCharge($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}
}

class OBGridData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBGridData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBGridData();
	}

	const BOHR = 0;

	const ANGSTROM = OBGridData_ANGSTROM;

	const OTHER = OBGridData_OTHER;

	function GetXAxis() {
		$r=OBGridData_GetXAxis($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetYAxis() {
		$r=OBGridData_GetYAxis($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetZAxis() {
		$r=OBGridData_GetZAxis($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetAxes($x_or_v1,$y_or_v2,$z_or_v3) {
		OBGridData_GetAxes($this->_cPtr,$x_or_v1,$y_or_v2,$z_or_v3);
	}

	function GetNumberOfPoints($nx=null,$ny=null,$nz=null) {
		switch (func_num_args()) {
		case 0: $r=OBGridData_GetNumberOfPoints($this->_cPtr); break;
		case 1: $r=OBGridData_GetNumberOfPoints($this->_cPtr,$nx); break;
		case 2: $r=OBGridData_GetNumberOfPoints($this->_cPtr,$nx,$ny); break;
		default: $r=OBGridData_GetNumberOfPoints($this->_cPtr,$nx,$ny,$nz);
		}
		return $r;
	}

	function GetNumberOfSteps($steps) {
		OBGridData_GetNumberOfSteps($this->_cPtr,$steps);
	}

	function GetValues() {
		$r=OBGridData_GetValues($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetValue($i_or_pos,$j=null,$k=null) {
		switch (func_num_args()) {
		case 1: $r=OBGridData_GetValue($this->_cPtr,$i_or_pos); break;
		case 2: $r=OBGridData_GetValue($this->_cPtr,$i_or_pos,$j); break;
		default: $r=OBGridData_GetValue($this->_cPtr,$i_or_pos,$j,$k);
		}
		return $r;
	}

	function GetUnit() {
		return OBGridData_GetUnit($this->_cPtr);
	}

	function GetMinValue() {
		return OBGridData_GetMinValue($this->_cPtr);
	}

	function GetMaxValue() {
		return OBGridData_GetMaxValue($this->_cPtr);
	}

	function GetOriginVector($o=null) {
		switch (func_num_args()) {
		case 0: $r=OBGridData_GetOriginVector($this->_cPtr); break;
		default: $r=OBGridData_GetOriginVector($this->_cPtr,$o);
		}
		return $r;
	}

	function GetMaxVector() {
		$r=OBGridData_GetMaxVector($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetUnrestricted() {
		return OBGridData_GetUnrestricted($this->_cPtr);
	}

	function GetNumSymmetries() {
		return OBGridData_GetNumSymmetries($this->_cPtr);
	}

	function SetNumberOfPoints($nx,$ny,$nz) {
		OBGridData_SetNumberOfPoints($this->_cPtr,$nx,$ny,$nz);
	}

	function SetLimits($origin,$x,$y,$z) {
		OBGridData_SetLimits($this->_cPtr,$origin,$x,$y,$z);
	}

	function SetValue($i,$j,$k,$val) {
		return OBGridData_SetValue($this->_cPtr,$i,$j,$k,$val);
	}

	function SetValues($v) {
		OBGridData_SetValues($this->_cPtr,$v);
	}

	function SetUnit($u) {
		OBGridData_SetUnit($this->_cPtr,$u);
	}

	function SetUnrestricted($u) {
		OBGridData_SetUnrestricted($this->_cPtr,$u);
	}

	function SetNumSymmetries($s) {
		OBGridData_SetNumSymmetries($this->_cPtr,$s);
	}
}

class OBChainsParser {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBChainsParser') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBChainsParser();
	}

	function PerceiveChains($mol,$nukeSingleResidue=false) {
		return OBChainsParser_PerceiveChains($this->_cPtr,$mol,$nukeSingleResidue);
	}
}

class OBAtomTyper extends OBGlobalDataBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGlobalDataBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGlobalDataBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGlobalDataBase::__isset($var);
	}

	function __construct($rhs=null) {
		if (is_resource($rhs) && get_resource_type($rhs) === '_p_OpenBabel__OBAtomTyper') {
			$this->_cPtr=$rhs;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBAtomTyper(); break;
		default: $this->_cPtr=new_OBAtomTyper($rhs);
		}
	}

	function AssignHyb($arg1) {
		OBAtomTyper_AssignHyb($this->_cPtr,$arg1);
	}

	function AssignTypes($arg1) {
		OBAtomTyper_AssignTypes($this->_cPtr,$arg1);
	}
}

class OBAromaticTyper {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBAromaticTyper') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBAromaticTyper();
	}

	function AssignAromaticFlags($arg1) {
		OBAromaticTyper_AssignAromaticFlags($this->_cPtr,$arg1);
	}
}

class OBRingTyper extends OBGlobalDataBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGlobalDataBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGlobalDataBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGlobalDataBase::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRingTyper') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRingTyper();
	}

	function AssignTypes($arg1) {
		OBRingTyper_AssignTypes($this->_cPtr,$arg1);
	}
}

class dummy {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_std__binary_functionT_char_const_p_char_const_p_bool_t') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_dummy();
	}
}

class CharPtrLess extends dummy {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		dummy::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return dummy::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return dummy::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__CharPtrLess') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_CharPtrLess();
	}
}

abstract class OBPlugin {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	function Description() {
		return OBPlugin_Description($this->_cPtr);
	}

	function TypeID() {
		return OBPlugin_TypeID($this->_cPtr);
	}

	function Display($txt,$param,$ID=null) {
		switch (func_num_args()) {
		case 2: $r=OBPlugin_Display($this->_cPtr,$txt,$param); break;
		default: $r=OBPlugin_Display($this->_cPtr,$txt,$param,$ID);
		}
		return $r;
	}

	function MakeInstance($arg1) {
		$r=OBPlugin_MakeInstance($this->_cPtr,$arg1);
		$this->_cPtr = $r;
		return $this;
	}

	function Init() {
		OBPlugin_Init($this->_cPtr);
	}

	static function GetPlugin($Type,$ID) {
		$r=OBPlugin_GetPlugin($Type,$ID);
		$this->_cPtr = $r;
		return $this;
	}

	function GetID() {
		return OBPlugin_GetID($this->_cPtr);
	}

	static function ListAsVector($PluginID,$param,$vlist) {
		return OBPlugin_ListAsVector($PluginID,$param,$vlist);
	}

	static function c_List($PluginID,$param=null,$os=null) {
		switch (func_num_args()) {
		case 1: OBPlugin_c_List($PluginID); break;
		case 2: OBPlugin_c_List($PluginID,$param); break;
		default: OBPlugin_c_List($PluginID,$param,$os);
		}
	}

	static function ListAsString($PluginID,$param=null) {
		switch (func_num_args()) {
		case 1: $r=OBPlugin_ListAsString($PluginID); break;
		default: $r=OBPlugin_ListAsString($PluginID,$param);
		}
		return $r;
	}

	static function FirstLine($txt) {
		return OBPlugin_FirstLine($txt);
	}

	static function Begin($PluginID) {
		return OBPlugin_Begin($PluginID);
	}

	static function End($PluginID) {
		return OBPlugin_End($PluginID);
	}

	function GetMap() {
		return OBPlugin_GetMap($this->_cPtr);
	}

	static function LoadAllPlugins() {
		OBPlugin_LoadAllPlugins();
	}
}

class stringbuf {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_std__stringbuf') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_stringbuf();
	}
}

class OBError {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($method=null,$errorMsg=null,$explanation=null,$possibleCause=null,$suggestedRemedy=null,$arg6=null) {
		if (is_resource($method) && get_resource_type($method) === '_p_OpenBabel__OBError') {
			$this->_cPtr=$method;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBError(); break;
		case 1: $this->_cPtr=new_OBError($method); break;
		case 2: $this->_cPtr=new_OBError($method,$errorMsg); break;
		case 3: $this->_cPtr=new_OBError($method,$errorMsg,$explanation); break;
		case 4: $this->_cPtr=new_OBError($method,$errorMsg,$explanation,$possibleCause); break;
		case 5: $this->_cPtr=new_OBError($method,$errorMsg,$explanation,$possibleCause,$suggestedRemedy); break;
		default: $this->_cPtr=new_OBError($method,$errorMsg,$explanation,$possibleCause,$suggestedRemedy,$arg6);
		}
	}

	function message() {
		return OBError_message($this->_cPtr);
	}

	function GetMethod() {
		return OBError_GetMethod($this->_cPtr);
	}

	function GetError() {
		return OBError_GetError($this->_cPtr);
	}

	function GetExplanation() {
		return OBError_GetExplanation($this->_cPtr);
	}

	function GetPossibleCause() {
		return OBError_GetPossibleCause($this->_cPtr);
	}

	function GetSuggestedRemedy() {
		return OBError_GetSuggestedRemedy($this->_cPtr);
	}

	function GetLevel() {
		return OBError_GetLevel($this->_cPtr);
	}
}

class OBMessageHandler {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBMessageHandler') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBMessageHandler();
	}

	function ThrowError($err_or_method,$qqualifier_or_errorMsg=null,$level=null,$qualifier=null) {
		switch (func_num_args()) {
		case 1: OBMessageHandler_ThrowError($this->_cPtr,$err_or_method); break;
		case 2: OBMessageHandler_ThrowError($this->_cPtr,$err_or_method,$qqualifier_or_errorMsg); break;
		case 3: OBMessageHandler_ThrowError($this->_cPtr,$err_or_method,$qqualifier_or_errorMsg,$level); break;
		default: OBMessageHandler_ThrowError($this->_cPtr,$err_or_method,$qqualifier_or_errorMsg,$level,$qualifier);
		}
	}

	function GetMessagesOfLevel($arg1) {
		$r=OBMessageHandler_GetMessagesOfLevel($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorString($r);
		}
		return $r;
	}

	function StartLogging() {
		OBMessageHandler_StartLogging($this->_cPtr);
	}

	function StopLogging() {
		OBMessageHandler_StopLogging($this->_cPtr);
	}

	function SetMaxLogEntries($max) {
		OBMessageHandler_SetMaxLogEntries($this->_cPtr,$max);
	}

	function GetMaxLogEntries() {
		return OBMessageHandler_GetMaxLogEntries($this->_cPtr);
	}

	function ClearLog() {
		OBMessageHandler_ClearLog($this->_cPtr);
	}

	function SetOutputLevel($level) {
		OBMessageHandler_SetOutputLevel($this->_cPtr,$level);
	}

	function GetOutputLevel() {
		return OBMessageHandler_GetOutputLevel($this->_cPtr);
	}

	function SetOutputStream($os) {
		OBMessageHandler_SetOutputStream($this->_cPtr,$os);
	}

	function GetOutputStream() {
		return OBMessageHandler_GetOutputStream($this->_cPtr);
	}

	function StartErrorWrap() {
		return OBMessageHandler_StartErrorWrap($this->_cPtr);
	}

	function StopErrorWrap() {
		return OBMessageHandler_StopErrorWrap($this->_cPtr);
	}

	function GetErrorMessageCount() {
		return OBMessageHandler_GetErrorMessageCount($this->_cPtr);
	}

	function GetWarningMessageCount() {
		return OBMessageHandler_GetWarningMessageCount($this->_cPtr);
	}

	function GetInfoMessageCount() {
		return OBMessageHandler_GetInfoMessageCount($this->_cPtr);
	}

	function GetAuditMessageCount() {
		return OBMessageHandler_GetAuditMessageCount($this->_cPtr);
	}

	function GetDebugMessageCount() {
		return OBMessageHandler_GetDebugMessageCount($this->_cPtr);
	}

	function GetMessageSummary() {
		return OBMessageHandler_GetMessageSummary($this->_cPtr);
	}
}

class obLogBuf extends stringbuf {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		stringbuf::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return stringbuf::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return stringbuf::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__obLogBuf') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_obLogBuf();
	}
}

abstract class OBFormat extends OBPlugin {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBPlugin::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBPlugin::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBPlugin::__isset($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	static function c_Default() {
		return OBFormat_c_Default();
	}

	function FindType($ID) {
		$r=OBFormat_FindType($ID);
		$this->_cPtr = $r;
		return $this;
	}

	function ReadMolecule($arg1,$arg2) {
		return OBFormat_ReadMolecule($this->_cPtr,$arg1,$arg2);
	}

	function ReadChemObject($arg1) {
		return OBFormat_ReadChemObject($this->_cPtr,$arg1);
	}

	function WriteMolecule($arg1,$arg2) {
		return OBFormat_WriteMolecule($this->_cPtr,$arg1,$arg2);
	}

	function WriteChemObject($arg1) {
		return OBFormat_WriteChemObject($this->_cPtr,$arg1);
	}

	function TargetClassDescription() {
		return OBFormat_TargetClassDescription($this->_cPtr);
	}

	function GetType() {
		return OBFormat_GetType($this->_cPtr);
	}

	function SpecificationURL() {
		return OBFormat_SpecificationURL($this->_cPtr);
	}

	function GetMIMEType() {
		return OBFormat_GetMIMEType($this->_cPtr);
	}

	function Flags() {
		return OBFormat_Flags($this->_cPtr);
	}

	function SkipObjects($arg1,$arg2) {
		return OBFormat_SkipObjects($this->_cPtr,$arg1,$arg2);
	}

	function MakeNewInstance() {
		$r=OBFormat_MakeNewInstance($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}

	function RegisterFormat($ID,$MIME=null) {
		switch (func_num_args()) {
		case 1: $r=OBFormat_RegisterFormat($this->_cPtr,$ID); break;
		default: $r=OBFormat_RegisterFormat($this->_cPtr,$ID,$MIME);
		}
		return $r;
	}

	function Display($txt,$param,$ID=null) {
		switch (func_num_args()) {
		case 2: $r=OBFormat_Display($this->_cPtr,$txt,$param); break;
		default: $r=OBFormat_Display($this->_cPtr,$txt,$param,$ID);
		}
		return $r;
	}

	static function FormatFromMIME($MIME) {
		$r=OBFormat_FormatFromMIME($MIME);
		$this->_cPtr = $r;
		return $this;
	}
}

class OBConversion {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($is_or_inFilename_or_o=null,$os_or_outFilename=null) {
		if (is_resource($is_or_inFilename_or_o) && get_resource_type($is_or_inFilename_or_o) === '_p_OpenBabel__OBConversion') {
			$this->_cPtr=$is_or_inFilename_or_o;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBConversion(); break;
		case 1: $this->_cPtr=new_OBConversion($is_or_inFilename_or_o); break;
		default: $this->_cPtr=new_OBConversion($is_or_inFilename_or_o,$os_or_outFilename);
		}
	}

	static function RegisterFormat($ID,$pFormat,$MIME=null) {
		switch (func_num_args()) {
		case 2: $r=OBConversion_RegisterFormat($ID,$pFormat); break;
		default: $r=OBConversion_RegisterFormat($ID,$pFormat,$MIME);
		}
		return $r;
	}

	static function FindFormat($ID) {
		$r=OBConversion_FindFormat($ID);
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_p_OpenBabel__OBFormat': return $r;
		default: return new OBFormat($r);
		}
	}

	static function FormatFromExt($filename,$isgzip=null) {
		switch (func_num_args()) {
		case 1: $r=OBConversion_FormatFromExt($filename); break;
		default: $r=OBConversion_FormatFromExt($filename,$isgzip);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_p_OpenBabel__OBFormat': return $r;
		default: return new OBFormat($r);
		}
	}

	static function FormatFromMIME($MIME) {
		$r=OBConversion_FormatFromMIME($MIME);
		$this->_cPtr = $r;
		return $this;
	}

	static function Description() {
		return OBConversion_Description();
	}

	function GetInStream() {
		return OBConversion_GetInStream($this->_cPtr);
	}

	function GetOutStream() {
		return OBConversion_GetOutStream($this->_cPtr);
	}

	function SetInStream($pIn,$takeOwnership=false) {
		OBConversion_SetInStream($this->_cPtr,$pIn,$takeOwnership);
	}

	function SetOutStream($pOut,$takeOwnership=false) {
		OBConversion_SetOutStream($this->_cPtr,$pOut,$takeOwnership);
	}

	function SetInAndOutFormats($inID_or_pIn,$outID_or_pOut,$ingzip=false,$outgzip=false) {
		$r=OBConversion_SetInAndOutFormats($this->_cPtr,$inID_or_pIn,$outID_or_pOut,$ingzip,$outgzip);
		return $r;
	}

	function SetInFormat($inID_or_pIn,$isgzip=false) {
		$r=OBConversion_SetInFormat($this->_cPtr,$inID_or_pIn,$isgzip);
		return $r;
	}

	function SetOutFormat($outID_or_pOut,$isgzip=false) {
		$r=OBConversion_SetOutFormat($this->_cPtr,$outID_or_pOut,$isgzip);
		return $r;
	}

	function GetInFormat() {
		$r=OBConversion_GetInFormat($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}

	function GetOutFormat() {
		$r=OBConversion_GetOutFormat($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}

	function GetInGzipped() {
		return OBConversion_GetInGzipped($this->_cPtr);
	}

	function GetOutGzipped() {
		return OBConversion_GetOutGzipped($this->_cPtr);
	}

	function GetInFilename() {
		return OBConversion_GetInFilename($this->_cPtr);
	}

	function GetOutFilename() {
		return OBConversion_GetOutFilename($this->_cPtr);
	}

	function GetInPos() {
		return OBConversion_GetInPos($this->_cPtr);
	}

	function GetInLen() {
		return OBConversion_GetInLen($this->_cPtr);
	}

	function GetTitle() {
		return OBConversion_GetTitle($this->_cPtr);
	}

	function GetAuxConv() {
		$r=OBConversion_GetAuxConv($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBConversion($r);
		}
		return $r;
	}

	function SetAuxConv($pConv) {
		OBConversion_SetAuxConv($this->_cPtr,$pConv);
	}

	const INOPTIONS = 0;

	const OUTOPTIONS = OBConversion_OUTOPTIONS;

	const GENOPTIONS = OBConversion_GENOPTIONS;

	const ALL = OBConversion_ALL;

	function IsOption($opt,$opttyp=null) {
		switch (func_num_args()) {
		case 1: $r=OBConversion_IsOption($this->_cPtr,$opt); break;
		default: $r=OBConversion_IsOption($this->_cPtr,$opt,$opttyp);
		}
		return $r;
	}

	function GetOptions($opttyp) {
		return OBConversion_GetOptions($this->_cPtr,$opttyp);
	}

	function AddOption($opt,$opttyp=null,$txt=null) {
		switch (func_num_args()) {
		case 1: OBConversion_AddOption($this->_cPtr,$opt); break;
		case 2: OBConversion_AddOption($this->_cPtr,$opt,$opttyp); break;
		default: OBConversion_AddOption($this->_cPtr,$opt,$opttyp,$txt);
		}
	}

	function RemoveOption($opt,$optype) {
		return OBConversion_RemoveOption($this->_cPtr,$opt,$optype);
	}

	function SetOptions($options,$opttyp) {
		OBConversion_SetOptions($this->_cPtr,$options,$opttyp);
	}

	static function RegisterOptionParam($name,$pFormat,$numberParams=0,$typ=null) {
		switch (func_num_args()) {
		case 2: case 3: OBConversion_RegisterOptionParam($name,$pFormat,$numberParams); break;
		default: OBConversion_RegisterOptionParam($name,$pFormat,$numberParams,$typ);
		}
	}

	static function GetOptionParams($name,$typ) {
		return OBConversion_GetOptionParams($name,$typ);
	}

	function CopyOptions($pSourceConv,$typ=null) {
		switch (func_num_args()) {
		case 1: OBConversion_CopyOptions($this->_cPtr,$pSourceConv); break;
		default: OBConversion_CopyOptions($this->_cPtr,$pSourceConv,$typ);
		}
	}

	function GetSupportedInputFormat() {
		$r=OBConversion_GetSupportedInputFormat($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorString($r);
		}
		return $r;
	}

	function GetSupportedOutputFormat() {
		$r=OBConversion_GetSupportedOutputFormat($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorString($r);
		}
		return $r;
	}

	function Convert($is=null,$os=null) {
		switch (func_num_args()) {
		case 0: $r=OBConversion_Convert($this->_cPtr); break;
		case 1: $r=OBConversion_Convert($this->_cPtr,$is); break;
		default: $r=OBConversion_Convert($this->_cPtr,$is,$os);
		}
		return $r;
	}

	function FullConvert($FileList,$OutputFileName,$OutputFileList) {
		return OBConversion_FullConvert($this->_cPtr,$FileList,$OutputFileName,$OutputFileList);
	}

	function AddChemObject($pOb) {
		return OBConversion_AddChemObject($this->_cPtr,$pOb);
	}

	function GetChemObject() {
		$r=OBConversion_GetChemObject($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function IsLast() {
		return OBConversion_IsLast($this->_cPtr);
	}

	function IsFirstInput() {
		return OBConversion_IsFirstInput($this->_cPtr);
	}

	function SetFirstInput($b=true) {
		OBConversion_SetFirstInput($this->_cPtr,$b);
	}

	function GetOutputIndex() {
		return OBConversion_GetOutputIndex($this->_cPtr);
	}

	function SetOutputIndex($indx) {
		OBConversion_SetOutputIndex($this->_cPtr,$indx);
	}

	function SetMoreFilesToCome() {
		OBConversion_SetMoreFilesToCome($this->_cPtr);
	}

	function SetOneObjectOnly($b=true) {
		OBConversion_SetOneObjectOnly($this->_cPtr,$b);
	}

	function SetLast($b) {
		OBConversion_SetLast($this->_cPtr,$b);
	}

	function IsLastFile() {
		return OBConversion_IsLastFile($this->_cPtr);
	}

	function GetCount() {
		return OBConversion_GetCount($this->_cPtr);
	}

	static function GetDefaultFormat() {
		$r=OBConversion_GetDefaultFormat();
		$this->_cPtr = $r;
		return $this;
	}

	function Write($pOb,$pout=null) {
		return OBConversion_Write($this->_cPtr,$pOb,$pout);
	}

	function WriteString($pOb,$trimWhitespace=false) {
		return OBConversion_WriteString($this->_cPtr,$pOb,$trimWhitespace);
	}

	function WriteFile($pOb,$filePath) {
		return OBConversion_WriteFile($this->_cPtr,$pOb,$filePath);
	}

	function CloseOutFile() {
		OBConversion_CloseOutFile($this->_cPtr);
	}

	function Read($pOb,$pin=null) {
		return OBConversion_Read($this->_cPtr,$pOb,$pin);
	}

	function ReadString($pOb,$input) {
		return OBConversion_ReadString($this->_cPtr,$pOb,$input);
	}

	function ReadFile($pOb,$filePath) {
		return OBConversion_ReadFile($this->_cPtr,$pOb,$filePath);
	}

	function OpenInAndOutFiles($infilepath,$outfilepath) {
		return OBConversion_OpenInAndOutFiles($this->_cPtr,$infilepath,$outfilepath);
	}

	function ReportNumberConverted($count,$pFormat=null) {
		OBConversion_ReportNumberConverted($this->_cPtr,$count,$pFormat);
	}

	function NumInputObjects() {
		return OBConversion_NumInputObjects($this->_cPtr);
	}
}

class OBResidue extends OBBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBBase::__isset($var);
	}

	function __construct($arg1=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBResidue') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBResidue(); break;
		default: $this->_cPtr=new_OBResidue($arg1);
		}
	}

	function AddAtom($atom) {
		OBResidue_AddAtom($this->_cPtr,$atom);
	}

	function InsertAtom($atom) {
		OBResidue_InsertAtom($this->_cPtr,$atom);
	}

	function RemoveAtom($atom) {
		OBResidue_RemoveAtom($this->_cPtr,$atom);
	}

	function SetName($resname) {
		OBResidue_SetName($this->_cPtr,$resname);
	}

	function SetNum($resnum) {
		OBResidue_SetNum($this->_cPtr,$resnum);
	}

	function SetChain($chain) {
		OBResidue_SetChain($this->_cPtr,$chain);
	}

	function SetChainNum($chainnum) {
		OBResidue_SetChainNum($this->_cPtr,$chainnum);
	}

	function SetIdx($idx) {
		OBResidue_SetIdx($this->_cPtr,$idx);
	}

	function SetInsertionCode($insertioncode) {
		OBResidue_SetInsertionCode($this->_cPtr,$insertioncode);
	}

	function SetAtomID($atom,$id) {
		OBResidue_SetAtomID($this->_cPtr,$atom,$id);
	}

	function SetHetAtom($atom,$hetatm) {
		OBResidue_SetHetAtom($this->_cPtr,$atom,$hetatm);
	}

	function SetSerialNum($atom,$sernum) {
		OBResidue_SetSerialNum($this->_cPtr,$atom,$sernum);
	}

	function GetName() {
		return OBResidue_GetName($this->_cPtr);
	}

	function GetNum() {
		return OBResidue_GetNum($this->_cPtr);
	}

	function GetNumString() {
		return OBResidue_GetNumString($this->_cPtr);
	}

	function GetNumAtoms() {
		return OBResidue_GetNumAtoms($this->_cPtr);
	}

	function GetChain() {
		return OBResidue_GetChain($this->_cPtr);
	}

	function GetChainNum() {
		return OBResidue_GetChainNum($this->_cPtr);
	}

	function GetIdx() {
		return OBResidue_GetIdx($this->_cPtr);
	}

	function GetResKey() {
		return OBResidue_GetResKey($this->_cPtr);
	}

	function GetAtoms() {
		return OBResidue_GetAtoms($this->_cPtr);
	}

	function GetBonds($exterior=true) {
		return OBResidue_GetBonds($this->_cPtr,$exterior);
	}

	function GetAtomID($atom) {
		return OBResidue_GetAtomID($this->_cPtr,$atom);
	}

	function GetSerialNum($atom) {
		return OBResidue_GetSerialNum($this->_cPtr,$atom);
	}

	function GetInsertionCode() {
		return OBResidue_GetInsertionCode($this->_cPtr);
	}

	function GetAminoAcidProperty($arg1) {
		return OBResidue_GetAminoAcidProperty($this->_cPtr,$arg1);
	}

	function GetAtomProperty($a,$arg2) {
		return OBResidue_GetAtomProperty($this->_cPtr,$a,$arg2);
	}

	function GetResidueProperty($arg1) {
		return OBResidue_GetResidueProperty($this->_cPtr,$arg1);
	}

	function IsHetAtom($atom) {
		return OBResidue_IsHetAtom($this->_cPtr,$atom);
	}

	function IsResidueType($arg1) {
		return OBResidue_IsResidueType($this->_cPtr,$arg1);
	}

	function BeginAtoms() {
		return OBResidue_BeginAtoms($this->_cPtr);
	}

	function EndAtoms() {
		return OBResidue_EndAtoms($this->_cPtr);
	}

	function BeginAtom($i) {
		$r=OBResidue_BeginAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextAtom($i) {
		$r=OBResidue_NextAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}
}

class OBInternalCoord {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'OBInternalCoord_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === '_a') return new OBAtom(OBInternalCoord__a_get($this->_cPtr));
		if ($var === '_b') return new OBAtom(OBInternalCoord__b_get($this->_cPtr));
		if ($var === '_c') return new OBAtom(OBInternalCoord__c_get($this->_cPtr));
		$func = 'OBInternalCoord_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBInternalCoord_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($a=null,$b=null,$c_=null,$dst=0.0,$ang=0.0,$tor=0.0) {
		if (is_resource($a) && get_resource_type($a) === '_p_OpenBabel__OBInternalCoord') {
			$this->_cPtr=$a;
			return;
		}
		$this->_cPtr=new_OBInternalCoord($a,$b,$c_,$dst,$ang,$tor);
	}
}

class OBAtom extends OBBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'Visit') return OBAtom_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'Visit') return OBAtom_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBBase::__get($var);
	}

	function __isset($var) {
		if (function_exists('OBAtom_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return OBBase::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBAtom') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBAtom();
	}

	function Duplicate($arg1) {
		OBAtom_Duplicate($this->_cPtr,$arg1);
	}

	function SetIdx($idx) {
		OBAtom_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBAtom_SetId($this->_cPtr,$id);
	}

	function SetHyb($hyb) {
		OBAtom_SetHyb($this->_cPtr,$hyb);
	}

	function SetAtomicNum($atomicnum) {
		OBAtom_SetAtomicNum($this->_cPtr,$atomicnum);
	}

	function SetIsotope($iso) {
		OBAtom_SetIsotope($this->_cPtr,$iso);
	}

	function SetImplicitHCount($val) {
		OBAtom_SetImplicitHCount($this->_cPtr,$val);
	}

	function SetFormalCharge($fcharge) {
		OBAtom_SetFormalCharge($this->_cPtr,$fcharge);
	}

	function SetSpinMultiplicity($spin) {
		OBAtom_SetSpinMultiplicity($this->_cPtr,$spin);
	}

	function SetType($type) {
		OBAtom_SetType($this->_cPtr,$type);
	}

	function SetPartialCharge($pcharge) {
		OBAtom_SetPartialCharge($this->_cPtr,$pcharge);
	}

	function SetCoordPtr($c_) {
		OBAtom_SetCoordPtr($this->_cPtr,$c_);
	}

	function SetVector($v_or_x=null,$y=null,$z=null) {
		switch (func_num_args()) {
		case 0: OBAtom_SetVector($this->_cPtr); break;
		case 1: OBAtom_SetVector($this->_cPtr,$v_or_x); break;
		case 2: OBAtom_SetVector($this->_cPtr,$v_or_x,$y); break;
		default: OBAtom_SetVector($this->_cPtr,$v_or_x,$y,$z);
		}
	}

	function SetResidue($res) {
		OBAtom_SetResidue($this->_cPtr,$res);
	}

	function SetParent($ptr) {
		OBAtom_SetParent($this->_cPtr,$ptr);
	}

	function SetAromatic($value=true) {
		OBAtom_SetAromatic($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBAtom_SetInRing($this->_cPtr,$value);
	}

	function ClearCoordPtr() {
		OBAtom_ClearCoordPtr($this->_cPtr);
	}

	function GetFormalCharge() {
		return OBAtom_GetFormalCharge($this->_cPtr);
	}

	function GetAtomicNum() {
		return OBAtom_GetAtomicNum($this->_cPtr);
	}

	function GetIsotope() {
		return OBAtom_GetIsotope($this->_cPtr);
	}

	function GetSpinMultiplicity() {
		return OBAtom_GetSpinMultiplicity($this->_cPtr);
	}

	function GetAtomicMass() {
		return OBAtom_GetAtomicMass($this->_cPtr);
	}

	function GetExactMass() {
		return OBAtom_GetExactMass($this->_cPtr);
	}

	function GetIdx() {
		return OBAtom_GetIdx($this->_cPtr);
	}

	function GetIndex() {
		return OBAtom_GetIndex($this->_cPtr);
	}

	function GetId() {
		return OBAtom_GetId($this->_cPtr);
	}

	function GetCoordinateIdx() {
		return OBAtom_GetCoordinateIdx($this->_cPtr);
	}

	function GetExplicitDegree() {
		return OBAtom_GetExplicitDegree($this->_cPtr);
	}

	function GetTotalDegree() {
		return OBAtom_GetTotalDegree($this->_cPtr);
	}

	function GetExplicitValence() {
		return OBAtom_GetExplicitValence($this->_cPtr);
	}

	function GetTotalValence() {
		return OBAtom_GetTotalValence($this->_cPtr);
	}

	function GetHyb() {
		return OBAtom_GetHyb($this->_cPtr);
	}

	function GetImplicitHCount() {
		return OBAtom_GetImplicitHCount($this->_cPtr);
	}

	function GetHvyDegree() {
		return OBAtom_GetHvyDegree($this->_cPtr);
	}

	function GetHeteroDegree() {
		return OBAtom_GetHeteroDegree($this->_cPtr);
	}

	function GetType() {
		return OBAtom_GetType($this->_cPtr);
	}

	function GetX() {
		return OBAtom_GetX($this->_cPtr);
	}

	function GetY() {
		return OBAtom_GetY($this->_cPtr);
	}

	function GetZ() {
		return OBAtom_GetZ($this->_cPtr);
	}

	function x() {
		return OBAtom_x($this->_cPtr);
	}

	function y() {
		return OBAtom_y($this->_cPtr);
	}

	function z() {
		return OBAtom_z($this->_cPtr);
	}

	function GetCoordinate() {
		return OBAtom_GetCoordinate($this->_cPtr);
	}

	function GetVector() {
		$r=OBAtom_GetVector($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function GetPartialCharge() {
		return OBAtom_GetPartialCharge($this->_cPtr);
	}

	function GetResidue() {
		$r=OBAtom_GetResidue($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBAtom_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetNewBondVector($v,$length) {
		return OBAtom_GetNewBondVector($this->_cPtr,$v,$length);
	}

	function GetBond($arg1) {
		$r=OBAtom_GetBond($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginBonds() {
		return OBAtom_BeginBonds($this->_cPtr);
	}

	function EndBonds() {
		return OBAtom_EndBonds($this->_cPtr);
	}

	function BeginBond($i) {
		$r=OBAtom_BeginBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function NextBond($i) {
		$r=OBAtom_NextBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginNbrAtom($i) {
		$r=OBAtom_BeginNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextNbrAtom($i) {
		$r=OBAtom_NextNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetDistance($index_or_v) {
		return OBAtom_GetDistance($this->_cPtr,$index_or_v);
	}

	function GetAngle($b,$c_) {
		return OBAtom_GetAngle($this->_cPtr,$b,$c_);
	}

	function NewResidue() {
		OBAtom_NewResidue($this->_cPtr);
	}

	function AddResidue($res) {
		OBAtom_AddResidue($this->_cPtr,$res);
	}

	function DeleteResidue() {
		OBAtom_DeleteResidue($this->_cPtr);
	}

	function AddBond($bond) {
		OBAtom_AddBond($this->_cPtr,$bond);
	}

	function InsertBond($i,$bond) {
		OBAtom_InsertBond($this->_cPtr,$i,$bond);
	}

	function DeleteBond($bond) {
		return OBAtom_DeleteBond($this->_cPtr,$bond);
	}

	function ClearBond() {
		OBAtom_ClearBond($this->_cPtr);
	}

	function HtoMethyl() {
		return OBAtom_HtoMethyl($this->_cPtr);
	}

	function SetHybAndGeom($arg1) {
		return OBAtom_SetHybAndGeom($this->_cPtr,$arg1);
	}

	function CountFreeOxygens() {
		return OBAtom_CountFreeOxygens($this->_cPtr);
	}

	function CountFreeSulfurs() {
		return OBAtom_CountFreeSulfurs($this->_cPtr);
	}

	function ExplicitHydrogenCount($ExcludeIsotopes=false) {
		return OBAtom_ExplicitHydrogenCount($this->_cPtr,$ExcludeIsotopes);
	}

	function MemberOfRingCount() {
		return OBAtom_MemberOfRingCount($this->_cPtr);
	}

	function MemberOfRingSize() {
		return OBAtom_MemberOfRingSize($this->_cPtr);
	}

	function CountRingBonds() {
		return OBAtom_CountRingBonds($this->_cPtr);
	}

	function SmallestBondAngle() {
		return OBAtom_SmallestBondAngle($this->_cPtr);
	}

	function AverageBondAngle() {
		return OBAtom_AverageBondAngle($this->_cPtr);
	}

	function LewisAcidBaseCounts() {
		return OBAtom_LewisAcidBaseCounts($this->_cPtr);
	}

	function HasResidue() {
		return OBAtom_HasResidue($this->_cPtr);
	}

	function IsHetAtom() {
		return OBAtom_IsHetAtom($this->_cPtr);
	}

	function IsAromatic() {
		return OBAtom_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBAtom_IsInRing($this->_cPtr);
	}

	function IsInRingSize($arg1) {
		return OBAtom_IsInRingSize($this->_cPtr,$arg1);
	}

	function IsHeteroatom() {
		return OBAtom_IsHeteroatom($this->_cPtr);
	}

	function IsConnected($arg1) {
		return OBAtom_IsConnected($this->_cPtr,$arg1);
	}

	function IsOneThree($arg1) {
		return OBAtom_IsOneThree($this->_cPtr,$arg1);
	}

	function IsOneFour($arg1) {
		return OBAtom_IsOneFour($this->_cPtr,$arg1);
	}

	function IsCarboxylOxygen() {
		return OBAtom_IsCarboxylOxygen($this->_cPtr);
	}

	function IsPhosphateOxygen() {
		return OBAtom_IsPhosphateOxygen($this->_cPtr);
	}

	function IsSulfateOxygen() {
		return OBAtom_IsSulfateOxygen($this->_cPtr);
	}

	function IsNitroOxygen() {
		return OBAtom_IsNitroOxygen($this->_cPtr);
	}

	function IsAmideNitrogen() {
		return OBAtom_IsAmideNitrogen($this->_cPtr);
	}

	function IsPolarHydrogen() {
		return OBAtom_IsPolarHydrogen($this->_cPtr);
	}

	function IsNonPolarHydrogen() {
		return OBAtom_IsNonPolarHydrogen($this->_cPtr);
	}

	function IsAromaticNOxide() {
		return OBAtom_IsAromaticNOxide($this->_cPtr);
	}

	function IsChiral() {
		return OBAtom_IsChiral($this->_cPtr);
	}

	function IsAxial() {
		return OBAtom_IsAxial($this->_cPtr);
	}

	function IsHbondAcceptor() {
		return OBAtom_IsHbondAcceptor($this->_cPtr);
	}

	function IsHbondAcceptorSimple() {
		return OBAtom_IsHbondAcceptorSimple($this->_cPtr);
	}

	function IsHbondDonor() {
		return OBAtom_IsHbondDonor($this->_cPtr);
	}

	function IsHbondDonorH() {
		return OBAtom_IsHbondDonorH($this->_cPtr);
	}

	function IsMetal() {
		return OBAtom_IsMetal($this->_cPtr);
	}

	function HasAlphaBetaUnsat($includePandS=true) {
		return OBAtom_HasAlphaBetaUnsat($this->_cPtr,$includePandS);
	}

	function HasBondOfOrder($bo) {
		return OBAtom_HasBondOfOrder($this->_cPtr,$bo);
	}

	function CountBondsOfOrder($bo) {
		return OBAtom_CountBondsOfOrder($this->_cPtr,$bo);
	}

	function HighestBondOrder() {
		return OBAtom_HighestBondOrder($this->_cPtr);
	}

	function HasNonSingleBond() {
		return OBAtom_HasNonSingleBond($this->_cPtr);
	}

	function HasSingleBond() {
		return OBAtom_HasSingleBond($this->_cPtr);
	}

	function HasDoubleBond() {
		return OBAtom_HasDoubleBond($this->_cPtr);
	}

	function HasAromaticBond() {
		return OBAtom_HasAromaticBond($this->_cPtr);
	}

	function MatchesSMARTS($arg1) {
		return OBAtom_MatchesSMARTS($this->_cPtr,$arg1);
	}
}

class OBBond extends OBBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'Visit') return OBBond_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'Visit') return OBBond_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBBase::__get($var);
	}

	function __isset($var) {
		if (function_exists('OBBond_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return OBBase::__isset($var);
	}

	const Aromatic = OBBond_Aromatic;

	const Ring = OBBond_Ring;

	const Closure = OBBond_Closure;

	const Wedge = OBBond_Wedge;

	const Hash = OBBond_Hash;

	const WedgeOrHash = OBBond_WedgeOrHash;

	const CisOrTrans = OBBond_CisOrTrans;

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBBond') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBBond();
	}

	function SetIdx($idx) {
		OBBond_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBBond_SetId($this->_cPtr,$id);
	}

	function SetBondOrder($order) {
		OBBond_SetBondOrder($this->_cPtr,$order);
	}

	function SetBegin($begin) {
		OBBond_SetBegin($this->_cPtr,$begin);
	}

	function SetEnd($end) {
		OBBond_SetEnd($this->_cPtr,$end);
	}

	function SetParent($ptr) {
		OBBond_SetParent($this->_cPtr,$ptr);
	}

	function SetLength($fixed_or_length,$length=null) {
		switch (func_num_args()) {
		case 1: OBBond_SetLength($this->_cPtr,$fixed_or_length); break;
		default: OBBond_SetLength($this->_cPtr,$fixed_or_length,$length);
		}
	}

	function Set($index,$begin,$end,$order,$flags) {
		OBBond_Set($this->_cPtr,$index,$begin,$end,$order,$flags);
	}

	function SetAromatic($value=true) {
		OBBond_SetAromatic($this->_cPtr,$value);
	}

	function SetWedge($value=true) {
		OBBond_SetWedge($this->_cPtr,$value);
	}

	function SetHash($value=true) {
		OBBond_SetHash($this->_cPtr,$value);
	}

	function SetWedgeOrHash($value=true) {
		OBBond_SetWedgeOrHash($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBBond_SetInRing($this->_cPtr,$value);
	}

	function SetClosure($value=true) {
		OBBond_SetClosure($this->_cPtr,$value);
	}

	function GetIdx() {
		return OBBond_GetIdx($this->_cPtr);
	}

	function GetId() {
		return OBBond_GetId($this->_cPtr);
	}

	function GetBondOrder() {
		return OBBond_GetBondOrder($this->_cPtr);
	}

	function GetFlags() {
		return OBBond_GetFlags($this->_cPtr);
	}

	function GetBeginAtomIdx() {
		return OBBond_GetBeginAtomIdx($this->_cPtr);
	}

	function GetEndAtomIdx() {
		return OBBond_GetEndAtomIdx($this->_cPtr);
	}

	function GetBeginAtom() {
		$r=OBBond_GetBeginAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetEndAtom() {
		$r=OBBond_GetEndAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetNbrAtom($ptr) {
		$r=OBBond_GetNbrAtom($this->_cPtr,$ptr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBBond_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetEquibLength() {
		return OBBond_GetEquibLength($this->_cPtr);
	}

	function GetLength() {
		return OBBond_GetLength($this->_cPtr);
	}

	function GetNbrAtomIdx($ptr) {
		return OBBond_GetNbrAtomIdx($this->_cPtr,$ptr);
	}

	function FindSmallestRing() {
		$r=OBBond_FindSmallestRing($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function IsAromatic() {
		return OBBond_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBBond_IsInRing($this->_cPtr);
	}

	function IsRotor($includeRingBonds=false) {
		return OBBond_IsRotor($this->_cPtr,$includeRingBonds);
	}

	function IsAmide() {
		return OBBond_IsAmide($this->_cPtr);
	}

	function IsPrimaryAmide() {
		return OBBond_IsPrimaryAmide($this->_cPtr);
	}

	function IsSecondaryAmide() {
		return OBBond_IsSecondaryAmide($this->_cPtr);
	}

	function IsTertiaryAmide() {
		return OBBond_IsTertiaryAmide($this->_cPtr);
	}

	function IsEster() {
		return OBBond_IsEster($this->_cPtr);
	}

	function IsCarbonyl() {
		return OBBond_IsCarbonyl($this->_cPtr);
	}

	function IsClosure() {
		return OBBond_IsClosure($this->_cPtr);
	}

	function IsWedge() {
		return OBBond_IsWedge($this->_cPtr);
	}

	function IsHash() {
		return OBBond_IsHash($this->_cPtr);
	}

	function IsWedgeOrHash() {
		return OBBond_IsWedgeOrHash($this->_cPtr);
	}

	function IsCisOrTrans() {
		return OBBond_IsCisOrTrans($this->_cPtr);
	}

	function IsDoubleBondGeometry() {
		return OBBond_IsDoubleBondGeometry($this->_cPtr);
	}
}

class OBReaction extends OBBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBBase::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBReaction') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBReaction();
	}

	function NumReactants() {
		return OBReaction_NumReactants($this->_cPtr);
	}

	function NumProducts() {
		return OBReaction_NumProducts($this->_cPtr);
	}

	function NumAgents() {
		return OBReaction_NumAgents($this->_cPtr);
	}

	function AddReactant($sp) {
		OBReaction_AddReactant($this->_cPtr,$sp);
	}

	function AddProduct($sp) {
		OBReaction_AddProduct($this->_cPtr,$sp);
	}

	function SetTransitionState($sp) {
		OBReaction_SetTransitionState($this->_cPtr,$sp);
	}

	function AddAgent($sp) {
		OBReaction_AddAgent($this->_cPtr,$sp);
	}

	function GetReactant($i) {
		return OBReaction_GetReactant($this->_cPtr,$i);
	}

	function GetProduct($i) {
		return OBReaction_GetProduct($this->_cPtr,$i);
	}

	function GetAgent($i) {
		return OBReaction_GetAgent($this->_cPtr,$i);
	}

	function GetTransitionState() {
		return OBReaction_GetTransitionState($this->_cPtr);
	}

	function GetTitle() {
		return OBReaction_GetTitle($this->_cPtr);
	}

	function GetComment() {
		return OBReaction_GetComment($this->_cPtr);
	}

	function SetTitle($title) {
		OBReaction_SetTitle($this->_cPtr,$title);
	}

	function SetComment($comment) {
		OBReaction_SetComment($this->_cPtr,$comment);
	}

	function IsReversible() {
		return OBReaction_IsReversible($this->_cPtr);
	}

	function SetReversible($b=true) {
		OBReaction_SetReversible($this->_cPtr,$b);
	}

	static function ClassDescription() {
		return OBReaction_ClassDescription();
	}
}

class OBMol extends OBBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBBase::__isset($var);
	}

	function __construct($arg1=null) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBMol') {
			$this->_cPtr=$arg1;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMol(); break;
		default: $this->_cPtr=new_OBMol($arg1);
		}
	}

	function add($mol) {
		$r=OBMol_add($this->_cPtr,$mol);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function ReserveAtoms($natoms) {
		OBMol_ReserveAtoms($this->_cPtr,$natoms);
	}

	function DestroyAtom($arg1) {
		OBMol_DestroyAtom($this->_cPtr,$arg1);
	}

	function DestroyBond($arg1) {
		OBMol_DestroyBond($this->_cPtr,$arg1);
	}

	function DestroyResidue($arg1) {
		OBMol_DestroyResidue($this->_cPtr,$arg1);
	}

	function AddAtom($atom,$forceNewId=false) {
		return OBMol_AddAtom($this->_cPtr,$atom,$forceNewId);
	}

	function InsertAtom($arg1) {
		return OBMol_InsertAtom($this->_cPtr,$arg1);
	}

	function AddBond($beginIdx,$endIdx=null,$order=null,$flags=0,$insertpos=-1) {
		switch (func_num_args()) {
		case 1: $r=OBMol_AddBond($this->_cPtr,$beginIdx); break;
		case 2: $r=OBMol_AddBond($this->_cPtr,$beginIdx,$endIdx); break;
		default: $r=OBMol_AddBond($this->_cPtr,$beginIdx,$endIdx,$order,$flags,$insertpos);
		}
		return $r;
	}

	function AddResidue($arg1) {
		return OBMol_AddResidue($this->_cPtr,$arg1);
	}

	function NewAtom($id=null) {
		switch (func_num_args()) {
		case 0: $r=OBMol_NewAtom($this->_cPtr); break;
		default: $r=OBMol_NewAtom($this->_cPtr,$id);
		}
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function NewBond($id=null) {
		switch (func_num_args()) {
		case 0: $r=OBMol_NewBond($this->_cPtr); break;
		default: $r=OBMol_NewBond($this->_cPtr,$id);
		}
		if (!is_resource($r)) return $r;
		return new OBBond($r);
	}

	function NewResidue() {
		$r=OBMol_NewResidue($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function DeleteAtom($arg1,$destroyAtom=true) {
		return OBMol_DeleteAtom($this->_cPtr,$arg1,$destroyAtom);
	}

	function DeleteBond($arg1,$destroyBond=true) {
		return OBMol_DeleteBond($this->_cPtr,$arg1,$destroyBond);
	}

	function DeleteResidue($arg1,$destroyResidue=true) {
		return OBMol_DeleteResidue($this->_cPtr,$arg1,$destroyResidue);
	}

	function BeginModify() {
		OBMol_BeginModify($this->_cPtr);
	}

	function EndModify($nukePerceivedData=true) {
		OBMol_EndModify($this->_cPtr,$nukePerceivedData);
	}

	function GetMod() {
		return OBMol_GetMod($this->_cPtr);
	}

	function IncrementMod() {
		OBMol_IncrementMod($this->_cPtr);
	}

	function DecrementMod() {
		OBMol_DecrementMod($this->_cPtr);
	}

	function GetFlags() {
		return OBMol_GetFlags($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBMol_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function NumAtoms() {
		return OBMol_NumAtoms($this->_cPtr);
	}

	function NumBonds() {
		return OBMol_NumBonds($this->_cPtr);
	}

	function NumHvyAtoms() {
		return OBMol_NumHvyAtoms($this->_cPtr);
	}

	function NumResidues() {
		return OBMol_NumResidues($this->_cPtr);
	}

	function NumRotors($sampleRingBonds=false) {
		return OBMol_NumRotors($this->_cPtr,$sampleRingBonds);
	}

	function GetAtom($idx) {
		$r=OBMol_GetAtom($this->_cPtr,$idx);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetAtomById($id) {
		$r=OBMol_GetAtomById($this->_cPtr,$id);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetFirstAtom() {
		$r=OBMol_GetFirstAtom($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetBondById($id) {
		$r=OBMol_GetBondById($this->_cPtr,$id);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function GetBond($idx_or_a_or_bgn,$b_or_end=null) {
		switch (func_num_args()) {
		case 1: $r=OBMol_GetBond($this->_cPtr,$idx_or_a_or_bgn); break;
		default: $r=OBMol_GetBond($this->_cPtr,$idx_or_a_or_bgn,$b_or_end);
		}
		if (!is_resource($r)) return $r;
		return new OBBond($r);
	}

	function GetResidue($idx) {
		$r=OBMol_GetResidue($this->_cPtr,$idx);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function GetInternalCoord() {
		$r=OBMol_GetInternalCoord($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBInternalCoord($r);
		}
		return $r;
	}

	function GetTorsion($a,$b,$c_,$d) {
		return OBMol_GetTorsion($this->_cPtr,$a,$b,$c_,$d);
	}

	function GetAngle($a,$b,$c_) {
		return OBMol_GetAngle($this->_cPtr,$a,$b,$c_);
	}

	function AreInSameRing($a,$b) {
		return OBMol_AreInSameRing($this->_cPtr,$a,$b);
	}

	function GetFormula() {
		return OBMol_GetFormula($this->_cPtr);
	}

	function GetSpacedFormula($ones=0,$sp=" ",$implicitH=true) {
		return OBMol_GetSpacedFormula($this->_cPtr,$ones,$sp,$implicitH);
	}

	function GetMolWt($implicitH=true) {
		return OBMol_GetMolWt($this->_cPtr,$implicitH);
	}

	function GetExactMass($implicitH=true) {
		return OBMol_GetExactMass($this->_cPtr,$implicitH);
	}

	function GetTotalCharge() {
		return OBMol_GetTotalCharge($this->_cPtr);
	}

	function GetTotalSpinMultiplicity() {
		return OBMol_GetTotalSpinMultiplicity($this->_cPtr);
	}

	function GetDimension() {
		return OBMol_GetDimension($this->_cPtr);
	}

	function GetCoordinates() {
		return OBMol_GetCoordinates($this->_cPtr);
	}

	function GetSSSR() {
		$r=OBMol_GetSSSR($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBRing($r);
		}
		return $r;
	}

	function GetLSSR() {
		$r=OBMol_GetLSSR($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBRing($r);
		}
		return $r;
	}

	function AutomaticFormalCharge() {
		return OBMol_AutomaticFormalCharge($this->_cPtr);
	}

	function AutomaticPartialCharge() {
		return OBMol_AutomaticPartialCharge($this->_cPtr);
	}

	function SetTitle($title) {
		OBMol_SetTitle($this->_cPtr,$title);
	}

	function SetFormula($molFormula) {
		OBMol_SetFormula($this->_cPtr,$molFormula);
	}

	function SetEnergy($energy) {
		OBMol_SetEnergy($this->_cPtr,$energy);
	}

	function SetDimension($d) {
		OBMol_SetDimension($this->_cPtr,$d);
	}

	function SetTotalCharge($charge) {
		OBMol_SetTotalCharge($this->_cPtr,$charge);
	}

	function SetTotalSpinMultiplicity($spinMultiplicity) {
		OBMol_SetTotalSpinMultiplicity($this->_cPtr,$spinMultiplicity);
	}

	function SetInternalCoord($int_coord) {
		OBMol_SetInternalCoord($this->_cPtr,$int_coord);
	}

	function SetAutomaticFormalCharge($val) {
		OBMol_SetAutomaticFormalCharge($this->_cPtr,$val);
	}

	function SetAutomaticPartialCharge($val) {
		OBMol_SetAutomaticPartialCharge($this->_cPtr,$val);
	}

	function SetAromaticPerceived($value=true) {
		OBMol_SetAromaticPerceived($this->_cPtr,$value);
	}

	function SetSSSRPerceived($value=true) {
		OBMol_SetSSSRPerceived($this->_cPtr,$value);
	}

	function SetLSSRPerceived($value=true) {
		OBMol_SetLSSRPerceived($this->_cPtr,$value);
	}

	function SetRingAtomsAndBondsPerceived($value=true) {
		OBMol_SetRingAtomsAndBondsPerceived($this->_cPtr,$value);
	}

	function SetAtomTypesPerceived($value=true) {
		OBMol_SetAtomTypesPerceived($this->_cPtr,$value);
	}

	function SetRingTypesPerceived($value=true) {
		OBMol_SetRingTypesPerceived($this->_cPtr,$value);
	}

	function SetChainsPerceived($value=true) {
		OBMol_SetChainsPerceived($this->_cPtr,$value);
	}

	function SetChiralityPerceived($value=true) {
		OBMol_SetChiralityPerceived($this->_cPtr,$value);
	}

	function SetPartialChargesPerceived($value=true) {
		OBMol_SetPartialChargesPerceived($this->_cPtr,$value);
	}

	function SetHybridizationPerceived($value=true) {
		OBMol_SetHybridizationPerceived($this->_cPtr,$value);
	}

	function SetClosureBondsPerceived($value=true) {
		OBMol_SetClosureBondsPerceived($this->_cPtr,$value);
	}

	function SetHydrogensAdded($value=true) {
		OBMol_SetHydrogensAdded($this->_cPtr,$value);
	}

	function SetCorrectedForPH($value=true) {
		OBMol_SetCorrectedForPH($this->_cPtr,$value);
	}

	function SetSpinMultiplicityAssigned($value=true) {
		OBMol_SetSpinMultiplicityAssigned($this->_cPtr,$value);
	}

	function SetIsPatternStructure($value=true) {
		OBMol_SetIsPatternStructure($this->_cPtr,$value);
	}

	function SetIsReaction($value=true) {
		OBMol_SetIsReaction($this->_cPtr,$value);
	}

	function HasFlag($flag) {
		return OBMol_HasFlag($this->_cPtr,$flag);
	}

	function SetFlag($flag) {
		OBMol_SetFlag($this->_cPtr,$flag);
	}

	function UnsetFlag($flag) {
		OBMol_UnsetFlag($this->_cPtr,$flag);
	}

	function SetFlags($flags) {
		OBMol_SetFlags($this->_cPtr,$flags);
	}

	static function ClassDescription() {
		return OBMol_ClassDescription();
	}

	function RenumberAtoms($arg1) {
		OBMol_RenumberAtoms($this->_cPtr,$arg1);
	}

	function SetCoordinates($c_) {
		OBMol_SetCoordinates($this->_cPtr,$c_);
	}

	function ToInertialFrame($conf=null,$rmat=null) {
		switch (func_num_args()) {
		case 0: OBMol_ToInertialFrame($this->_cPtr); break;
		case 1: OBMol_ToInertialFrame($this->_cPtr,$conf); break;
		default: OBMol_ToInertialFrame($this->_cPtr,$conf,$rmat);
		}
	}

	function Translate($v,$conf=null) {
		switch (func_num_args()) {
		case 1: OBMol_Translate($this->_cPtr,$v); break;
		default: OBMol_Translate($this->_cPtr,$v,$conf);
		}
	}

	function Rotate($u_or_m,$nconf=null) {
		switch (func_num_args()) {
		case 1: OBMol_Rotate($this->_cPtr,$u_or_m); break;
		default: OBMol_Rotate($this->_cPtr,$u_or_m,$nconf);
		}
	}

	function DeleteHydrogens($arg1=null) {
		switch (func_num_args()) {
		case 0: $r=OBMol_DeleteHydrogens($this->_cPtr); break;
		default: $r=OBMol_DeleteHydrogens($this->_cPtr,$arg1);
		}
		return $r;
	}

	function DeletePolarHydrogens() {
		return OBMol_DeletePolarHydrogens($this->_cPtr);
	}

	function DeleteNonPolarHydrogens() {
		return OBMol_DeleteNonPolarHydrogens($this->_cPtr);
	}

	function DeleteHydrogen($arg1) {
		return OBMol_DeleteHydrogen($this->_cPtr,$arg1);
	}

	function AddHydrogens($polaronly=null,$correctForPH=null,$pH=null) {
		switch (func_num_args()) {
		case 0: $r=OBMol_AddHydrogens($this->_cPtr); break;
		case 1: $r=OBMol_AddHydrogens($this->_cPtr,$polaronly); break;
		case 2: $r=OBMol_AddHydrogens($this->_cPtr,$polaronly,$correctForPH); break;
		default: $r=OBMol_AddHydrogens($this->_cPtr,$polaronly,$correctForPH,$pH);
		}
		return $r;
	}

	function AddPolarHydrogens() {
		return OBMol_AddPolarHydrogens($this->_cPtr);
	}

	function AddNonPolarHydrogens() {
		return OBMol_AddNonPolarHydrogens($this->_cPtr);
	}

	function AddNewHydrogens($whichHydrogen,$correctForPH=false,$pH=7.4) {
		return OBMol_AddNewHydrogens($this->_cPtr,$whichHydrogen,$correctForPH,$pH);
	}

	function StripSalts($threshold=0) {
		return OBMol_StripSalts($this->_cPtr,$threshold);
	}

	function Separate($StartIndex=1) {
		$r=OBMol_Separate($this->_cPtr,$StartIndex);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorOBMol($r);
		}
		return $r;
	}

	function GetNextFragment($iter,$newMol) {
		return OBMol_GetNextFragment($this->_cPtr,$iter,$newMol);
	}

	function CopySubstructure($newmol,$includeatoms,$excludebonds=null,$correctvalence=1,$atomorder=null,$bondorder=null) {
		return OBMol_CopySubstructure($this->_cPtr,$newmol,$includeatoms,$excludebonds,$correctvalence,$atomorder,$bondorder);
	}

	function ConvertDativeBonds() {
		return OBMol_ConvertDativeBonds($this->_cPtr);
	}

	function MakeDativeBonds() {
		return OBMol_MakeDativeBonds($this->_cPtr);
	}

	function ConvertZeroBonds() {
		return OBMol_ConvertZeroBonds($this->_cPtr);
	}

	function CorrectForPH($pH=7.4) {
		return OBMol_CorrectForPH($this->_cPtr,$pH);
	}

	function AssignSpinMultiplicity($NoImplicitH=false) {
		return OBMol_AssignSpinMultiplicity($this->_cPtr,$NoImplicitH);
	}

	function AssignTotalChargeToAtoms($charge) {
		return OBMol_AssignTotalChargeToAtoms($this->_cPtr,$charge);
	}

	function Center($nconf=null) {
		switch (func_num_args()) {
		case 0: $r=OBMol_Center($this->_cPtr); break;
		default: $r=OBMol_Center($this->_cPtr,$nconf);
		}
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function FindSSSR() {
		OBMol_FindSSSR($this->_cPtr);
	}

	function FindLSSR() {
		OBMol_FindLSSR($this->_cPtr);
	}

	function FindRingAtomsAndBonds() {
		OBMol_FindRingAtomsAndBonds($this->_cPtr);
	}

	function FindChildren($children,$bgnIdx_or_bgn,$endIdx_or_end) {
		OBMol_FindChildren($this->_cPtr,$children,$bgnIdx_or_bgn,$endIdx_or_end);
	}

	function FindLargestFragment($frag) {
		OBMol_FindLargestFragment($this->_cPtr,$frag);
	}

	function ContigFragList($arg1) {
		OBMol_ContigFragList($this->_cPtr,$arg1);
	}

	function Align($arg1,$arg2,$arg3,$arg4) {
		OBMol_Align($this->_cPtr,$arg1,$arg2,$arg3,$arg4);
	}

	function ConnectTheDots() {
		OBMol_ConnectTheDots($this->_cPtr);
	}

	function PerceiveBondOrders() {
		OBMol_PerceiveBondOrders($this->_cPtr);
	}

	function FindAngles() {
		OBMol_FindAngles($this->_cPtr);
	}

	function FindTorsions() {
		OBMol_FindTorsions($this->_cPtr);
	}

	function GetGTDVector($arg1) {
		return OBMol_GetGTDVector($this->_cPtr,$arg1);
	}

	function GetGIVector($arg1) {
		OBMol_GetGIVector($this->_cPtr,$arg1);
	}

	function GetGIDVector($arg1) {
		OBMol_GetGIDVector($this->_cPtr,$arg1);
	}

	function Has2D($Not3D=false) {
		return OBMol_Has2D($this->_cPtr,$Not3D);
	}

	function Has3D() {
		return OBMol_Has3D($this->_cPtr);
	}

	function HasNonZeroCoords() {
		return OBMol_HasNonZeroCoords($this->_cPtr);
	}

	function HasAromaticPerceived() {
		return OBMol_HasAromaticPerceived($this->_cPtr);
	}

	function HasSSSRPerceived() {
		return OBMol_HasSSSRPerceived($this->_cPtr);
	}

	function HasLSSRPerceived() {
		return OBMol_HasLSSRPerceived($this->_cPtr);
	}

	function HasRingAtomsAndBondsPerceived() {
		return OBMol_HasRingAtomsAndBondsPerceived($this->_cPtr);
	}

	function HasAtomTypesPerceived() {
		return OBMol_HasAtomTypesPerceived($this->_cPtr);
	}

	function HasRingTypesPerceived() {
		return OBMol_HasRingTypesPerceived($this->_cPtr);
	}

	function HasChiralityPerceived() {
		return OBMol_HasChiralityPerceived($this->_cPtr);
	}

	function HasPartialChargesPerceived() {
		return OBMol_HasPartialChargesPerceived($this->_cPtr);
	}

	function HasHybridizationPerceived() {
		return OBMol_HasHybridizationPerceived($this->_cPtr);
	}

	function HasClosureBondsPerceived() {
		return OBMol_HasClosureBondsPerceived($this->_cPtr);
	}

	function HasChainsPerceived() {
		return OBMol_HasChainsPerceived($this->_cPtr);
	}

	function HasHydrogensAdded() {
		return OBMol_HasHydrogensAdded($this->_cPtr);
	}

	function IsCorrectedForPH() {
		return OBMol_IsCorrectedForPH($this->_cPtr);
	}

	function HasSpinMultiplicityAssigned() {
		return OBMol_HasSpinMultiplicityAssigned($this->_cPtr);
	}

	function IsReaction() {
		return OBMol_IsReaction($this->_cPtr);
	}

	function c_Empty() {
		return OBMol_c_Empty($this->_cPtr);
	}

	function NumConformers() {
		return OBMol_NumConformers($this->_cPtr);
	}

	function SetConformers($v) {
		OBMol_SetConformers($this->_cPtr,$v);
	}

	function AddConformer($f) {
		OBMol_AddConformer($this->_cPtr,$f);
	}

	function SetConformer($i) {
		OBMol_SetConformer($this->_cPtr,$i);
	}

	function CopyConformer($c_,$nconf) {
		OBMol_CopyConformer($this->_cPtr,$c_,$nconf);
	}

	function DeleteConformer($nconf) {
		OBMol_DeleteConformer($this->_cPtr,$nconf);
	}

	function GetConformer($i) {
		return OBMol_GetConformer($this->_cPtr,$i);
	}

	function SetEnergies($energies) {
		OBMol_SetEnergies($this->_cPtr,$energies);
	}

	function GetEnergies() {
		$r=OBMol_GetEnergies($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetEnergy($ci=null) {
		switch (func_num_args()) {
		case 0: $r=OBMol_GetEnergy($this->_cPtr); break;
		default: $r=OBMol_GetEnergy($this->_cPtr,$ci);
		}
		return $r;
	}

	function BeginConformer($i) {
		return OBMol_BeginConformer($this->_cPtr,$i);
	}

	function NextConformer($i) {
		return OBMol_NextConformer($this->_cPtr,$i);
	}

	function GetConformers() {
		return OBMol_GetConformers($this->_cPtr);
	}

	function BeginInternalCoord($i) {
		$r=OBMol_BeginInternalCoord($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBInternalCoord($r);
		}
		return $r;
	}

	function NextInternalCoord($i) {
		$r=OBMol_NextInternalCoord($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBInternalCoord($r);
		}
		return $r;
	}

	function SetTorsion($i,$j,$k,$l,$ang) {
		OBMol_SetTorsion($this->_cPtr,$i,$j,$k,$l,$ang);
	}
}

class OBRing {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'OBRing_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === '_path') return new vectorInt(OBRing__path_get($this->_cPtr));
		if ($var === '_pathset') return new OBBitVec(OBRing__pathset_get($this->_cPtr));
		if ($var === 'ring_id') return OBRing_ring_id_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBRing_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($path_or_src=null,$size_or_set=null) {
		if (is_resource($path_or_src) && get_resource_type($path_or_src) === '_p_OpenBabel__OBRing') {
			$this->_cPtr=$path_or_src;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBRing(); break;
		case 1: $this->_cPtr=new_OBRing($path_or_src); break;
		default: $this->_cPtr=new_OBRing($path_or_src,$size_or_set);
		}
	}

	function Size() {
		return OBRing_Size($this->_cPtr);
	}

	function PathSize() {
		return OBRing_PathSize($this->_cPtr);
	}

	function IsAromatic() {
		return OBRing_IsAromatic($this->_cPtr);
	}

	function SetType($type) {
		OBRing_SetType($this->_cPtr,$type);
	}

	function GetType() {
		return OBRing_GetType($this->_cPtr);
	}

	function GetRootAtom() {
		return OBRing_GetRootAtom($this->_cPtr);
	}

	function IsMember($a_or_b) {
		return OBRing_IsMember($this->_cPtr,$a_or_b);
	}

	function IsInRing($i) {
		return OBRing_IsInRing($this->_cPtr,$i);
	}

	function SetParent($m) {
		OBRing_SetParent($this->_cPtr,$m);
	}

	function GetParent() {
		$r=OBRing_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function findCenterAndNormal($center,$norm1,$norm2) {
		return OBRing_findCenterAndNormal($this->_cPtr,$center,$norm1,$norm2);
	}
}

class OBRingSearch {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRingSearch') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRingSearch();
	}

	function SortRings() {
		OBRingSearch_SortRings($this->_cPtr);
	}

	function RemoveRedundant($arg1) {
		OBRingSearch_RemoveRedundant($this->_cPtr,$arg1);
	}

	function AddRingFromClosure($arg1,$arg2) {
		OBRingSearch_AddRingFromClosure($this->_cPtr,$arg1,$arg2);
	}

	function SaveUniqueRing($arg1,$arg2) {
		return OBRingSearch_SaveUniqueRing($this->_cPtr,$arg1,$arg2);
	}

	function WriteRings() {
		OBRingSearch_WriteRings($this->_cPtr);
	}

	function BeginRings() {
		return OBRingSearch_BeginRings($this->_cPtr);
	}

	function EndRings() {
		return OBRingSearch_EndRings($this->_cPtr);
	}
}

class OBRTree {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($arg1,$arg2) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBRTree') {
			$this->_cPtr=$arg1;
			return;
		}
		$this->_cPtr=new_OBRTree($arg1,$arg2);
	}

	function GetAtomIdx() {
		return OBRTree_GetAtomIdx($this->_cPtr);
	}

	function PathToRoot($arg1) {
		OBRTree_PathToRoot($this->_cPtr,$arg1);
	}
}

class OBSmartsPattern {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($cp=null) {
		if (is_resource($cp) && get_resource_type($cp) === '_p_OpenBabel__OBSmartsPattern') {
			$this->_cPtr=$cp;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBSmartsPattern(); break;
		default: $this->_cPtr=new_OBSmartsPattern($cp);
		}
	}

	function Init($pattern) {
		return OBSmartsPattern_Init($this->_cPtr,$pattern);
	}

	function GetSMARTS() {
		return OBSmartsPattern_GetSMARTS($this->_cPtr);
	}

	function c_Empty() {
		return OBSmartsPattern_c_Empty($this->_cPtr);
	}

	function IsValid() {
		return OBSmartsPattern_IsValid($this->_cPtr);
	}

	function NumAtoms() {
		return OBSmartsPattern_NumAtoms($this->_cPtr);
	}

	function NumBonds() {
		return OBSmartsPattern_NumBonds($this->_cPtr);
	}

	function GetBond($src,$dst,$ord,$idx) {
		OBSmartsPattern_GetBond($this->_cPtr,$src,$dst,$ord,$idx);
	}

	function GetAtomicNum($idx) {
		return OBSmartsPattern_GetAtomicNum($this->_cPtr,$idx);
	}

	function GetCharge($idx) {
		return OBSmartsPattern_GetCharge($this->_cPtr,$idx);
	}

	function GetVectorBinding($idx) {
		return OBSmartsPattern_GetVectorBinding($this->_cPtr,$idx);
	}

	const All = 0;

	const Single = OBSmartsPattern_Single;

	const AllUnique = OBSmartsPattern_AllUnique;

	function Match($mol,$single_or_mlist=null,$mtype=null) {
		switch (func_num_args()) {
		case 1: $r=OBSmartsPattern_Match($this->_cPtr,$mol); break;
		case 2: $r=OBSmartsPattern_Match($this->_cPtr,$mol,$single_or_mlist); break;
		default: $r=OBSmartsPattern_Match($this->_cPtr,$mol,$single_or_mlist,$mtype);
		}
		return $r;
	}

	function HasMatch($mol) {
		return OBSmartsPattern_HasMatch($this->_cPtr,$mol);
	}

	function RestrictedMatch($mol,$pairs_or_bv,$single=false) {
		$r=OBSmartsPattern_RestrictedMatch($this->_cPtr,$mol,$pairs_or_bv,$single);
		return $r;
	}

	function NumMatches() {
		return OBSmartsPattern_NumMatches($this->_cPtr);
	}

	function GetMapList() {
		$r=OBSmartsPattern_GetMapList($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorvInt($r);
		}
		return $r;
	}

	function BeginMList() {
		return OBSmartsPattern_BeginMList($this->_cPtr);
	}

	function EndMList() {
		return OBSmartsPattern_EndMList($this->_cPtr);
	}

	function GetUMapList() {
		$r=OBSmartsPattern_GetUMapList($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorvInt($r);
		}
		return $r;
	}

	function WriteMapList($arg1) {
		OBSmartsPattern_WriteMapList($this->_cPtr,$arg1);
	}
}

class OBSmartsMatcher {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBSmartsMatcher') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBSmartsMatcher();
	}

	function match($mol,$pat,$mlist,$single=false) {
		return OBSmartsMatcher_match($this->_cPtr,$mol,$pat,$mlist,$single);
	}
}

class OBSSMatch {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($arg1,$arg2) {
		if (is_resource($arg1) && get_resource_type($arg1) === '_p_OpenBabel__OBSSMatch') {
			$this->_cPtr=$arg1;
			return;
		}
		$this->_cPtr=new_OBSSMatch($arg1,$arg2);
	}

	function Match($v,$bidx=-1) {
		OBSSMatch_Match($this->_cPtr,$v,$bidx);
	}
}

class AliasData extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__AliasData') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_AliasData();
	}

	function SetAlias($alias) {
		AliasData_SetAlias($this->_cPtr,$alias);
	}

	function GetAlias($rightAligned=false) {
		return AliasData_GetAlias($this->_cPtr,$rightAligned);
	}

	function GetColor() {
		return AliasData_GetColor($this->_cPtr);
	}

	function SetColor($color) {
		AliasData_SetColor($this->_cPtr,$color);
	}

	function IsExpanded() {
		return AliasData_IsExpanded($this->_cPtr);
	}

	static function RevertToAliasForm($mol) {
		AliasData_RevertToAliasForm($mol);
	}

	function Expand($mol,$atomindex) {
		return AliasData_Expand($this->_cPtr,$mol,$atomindex);
	}
}

class OBFingerprint extends OBPlugin {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBPlugin::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBPlugin::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBPlugin::__isset($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	static function c_Default() {
		return OBFingerprint_c_Default();
	}

	function FindType($ID) {
		$r=OBFingerprint_FindType($ID);
		$this->_cPtr = $r;
		return $this;
	}

	function SetBit($vec,$n) {
		OBFingerprint_SetBit($this->_cPtr,$vec,$n);
	}

	function GetBit($vec,$n) {
		return OBFingerprint_GetBit($this->_cPtr,$vec,$n);
	}

	function Fold($vec,$nbits) {
		OBFingerprint_Fold($this->_cPtr,$vec,$nbits);
	}

	function GetFingerprint($pOb,$fp,$nbits=0) {
		return OBFingerprint_GetFingerprint($this->_cPtr,$pOb,$fp,$nbits);
	}

	const FPT_UNIQUEBITS = 1;

	const FPT_NOINFO = 2;

	function Flags() {
		return OBFingerprint_Flags($this->_cPtr);
	}

	function SetFlags($arg1) {
		OBFingerprint_SetFlags($this->_cPtr,$arg1);
	}

	function DescribeBits($arg1,$arg2=true) {
		return OBFingerprint_DescribeBits($this->_cPtr,$arg1,$arg2);
	}

	static function Tanimoto($vec1,$vec2_or_p2) {
		return OBFingerprint_Tanimoto($vec1,$vec2_or_p2);
	}

	static function Getbitsperint() {
		return OBFingerprint_Getbitsperint();
	}

	static function FindFingerprint($ID) {
		$r=OBFingerprint_FindFingerprint($ID);
		$this->_cPtr = $r;
		return $this;
	}
}

class FptIndexHeader {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'FptIndexHeader_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		$func = 'FptIndexHeader_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('FptIndexHeader_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__FptIndexHeader') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_FptIndexHeader();
	}
}

class FastSearch {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function ReadIndexFile($IndexFilename) {
		return FastSearch_ReadIndexFile($this->_cPtr,$IndexFilename);
	}

	function ReadIndex($pIndexstream) {
		return FastSearch_ReadIndex($this->_cPtr,$pIndexstream);
	}

	function Find($pOb,$SeekPositions,$MaxCandidates) {
		return FastSearch_Find($this->_cPtr,$pOb,$SeekPositions,$MaxCandidates);
	}

	function FindMatch($pOb,$SeekPositions,$MaxCandidates) {
		return FastSearch_FindMatch($this->_cPtr,$pOb,$SeekPositions,$MaxCandidates);
	}

	function FindSimilar($pOb,$SeekposMap,$MinTani_or_nCandidates=0,$MaxTani=1.1) {
		$r=FastSearch_FindSimilar($this->_cPtr,$pOb,$SeekposMap,$MinTani_or_nCandidates,$MaxTani);
		return $r;
	}

	function GetFingerprint() {
		$r=FastSearch_GetFingerprint($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}

	function GetIndexHeader() {
		$r=FastSearch_GetIndexHeader($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new FptIndexHeader($r);
		}
		return $r;
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__FastSearch') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_FastSearch();
	}
}

class FastSearchIndexer {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($datafilename_or_pindex,$os,$fpid_or_nmols=0,$FptBits=0,$nmols=0) {
		if (is_resource($datafilename_or_pindex) && get_resource_type($datafilename_or_pindex) === '_p_OpenBabel__FastSearchIndexer') {
			$this->_cPtr=$datafilename_or_pindex;
			return;
		}
		$this->_cPtr=new_FastSearchIndexer($datafilename_or_pindex,$os,$fpid_or_nmols,$FptBits,$nmols);
	}

	function Add($pOb,$seekpos) {
		return FastSearchIndexer_Add($this->_cPtr,$pOb,$seekpos);
	}
}

class OBDescriptor extends OBPlugin {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBPlugin::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBPlugin::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBPlugin::__isset($var);
	}

	static function c_Default() {
		return OBDescriptor_c_Default();
	}

	function __construct($ID,$IsDefault=false) {
		if (is_resource($ID) && get_resource_type($ID) === '_p_OpenBabel__OBDescriptor') {
			$this->_cPtr=$ID;
			return;
		}
		$this->_cPtr=new_OBDescriptor($ID,$IsDefault);
	}

	function FindType($ID) {
		$r=OBDescriptor_FindType($ID);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBDescriptor($r);
		}
		return $r;
	}

	function Predict($arg1,$arg2=null) {
		return OBDescriptor_Predict($this->_cPtr,$arg1,$arg2);
	}

	function PredictAndSave($pOb,$param=null) {
		return OBDescriptor_PredictAndSave($this->_cPtr,$pOb,$param);
	}

	function GetStringValue($pOb,$svalue,$param=null) {
		return OBDescriptor_GetStringValue($this->_cPtr,$pOb,$svalue,$param);
	}

	function Compare($pOb,$ss,$noEval,$param=null) {
		return OBDescriptor_Compare($this->_cPtr,$pOb,$ss,$noEval,$param);
	}

	function Display($txt,$param,$ID=null) {
		switch (func_num_args()) {
		case 2: $r=OBDescriptor_Display($this->_cPtr,$txt,$param); break;
		default: $r=OBDescriptor_Display($this->_cPtr,$txt,$param,$ID);
		}
		return $r;
	}

	function Order($p1_or_s1,$p2_or_s2) {
		return OBDescriptor_Order($this->_cPtr,$p1_or_s1,$p2_or_s2);
	}

	static function FilterCompare($pOb,$ss,$noEval) {
		return OBDescriptor_FilterCompare($pOb,$ss,$noEval);
	}

	static function AddProperties($pOb,$DescrList) {
		OBDescriptor_AddProperties($pOb,$DescrList);
	}

	static function DeleteProperties($pOb,$DescrList) {
		OBDescriptor_DeleteProperties($pOb,$DescrList);
	}

	static function GetValues($pOb,$DescrList) {
		return OBDescriptor_GetValues($pOb,$DescrList);
	}

	static function GetIdentifier($optionText) {
		return OBDescriptor_GetIdentifier($optionText);
	}
}

class LineSearchType {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	const Simple = 0;

	const Newton2Num = LineSearchType_Newton2Num;

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__LineSearchType') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_LineSearchType();
	}
}

class OBFFParameter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'OBFFParameter_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === '_ipar') return new vectorInt(OBFFParameter__ipar_get($this->_cPtr));
		if ($var === '_dpar') return new vectorDouble(OBFFParameter__dpar_get($this->_cPtr));
		$func = 'OBFFParameter_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBFFParameter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function clear() {
		OBFFParameter_clear($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBFFParameter') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBFFParameter();
	}
}

class OBFFCalculation2 {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'OBFFCalculation2_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'b') return new OBAtom(OBFFCalculation2_b_get($this->_cPtr));
		if ($var === 'a') return new OBAtom(OBFFCalculation2_a_get($this->_cPtr));
		$func = 'OBFFCalculation2_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBFFCalculation2_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function SetupPointers() {
		OBFFCalculation2_SetupPointers($this->_cPtr);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBFFCalculation2') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBFFCalculation2();
	}
}

class OBFFCalculation3 extends OBFFCalculation2 {
	public $_cPtr=null;

	function __set($var,$value) {
		$func = 'OBFFCalculation3_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBFFCalculation2::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'c') return new OBAtom(OBFFCalculation3_c_get($this->_cPtr));
		$func = 'OBFFCalculation3_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBFFCalculation2::__get($var);
	}

	function __isset($var) {
		if (function_exists('OBFFCalculation3_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return OBFFCalculation2::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBFFCalculation3') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBFFCalculation3();
	}
}

class OBFFCalculation4 extends OBFFCalculation3 {
	public $_cPtr=null;

	function __set($var,$value) {
		$func = 'OBFFCalculation4_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBFFCalculation3::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'd') return new OBAtom(OBFFCalculation4_d_get($this->_cPtr));
		$func = 'OBFFCalculation4_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBFFCalculation3::__get($var);
	}

	function __isset($var) {
		if (function_exists('OBFFCalculation4_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return OBFFCalculation3::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBFFCalculation4') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBFFCalculation4();
	}
}

class OBFFConstraint {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'OBFFConstraint_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'grada') return new vector3(OBFFConstraint_grada_get($this->_cPtr));
		if ($var === 'gradb') return new vector3(OBFFConstraint_gradb_get($this->_cPtr));
		if ($var === 'gradc') return new vector3(OBFFConstraint_gradc_get($this->_cPtr));
		if ($var === 'gradd') return new vector3(OBFFConstraint_gradd_get($this->_cPtr));
		if ($var === 'a') return new OBAtom(OBFFConstraint_a_get($this->_cPtr));
		if ($var === 'b') return new OBAtom(OBFFConstraint_b_get($this->_cPtr));
		if ($var === 'c') return new OBAtom(OBFFConstraint_c_get($this->_cPtr));
		if ($var === 'd') return new OBAtom(OBFFConstraint_d_get($this->_cPtr));
		$func = 'OBFFConstraint_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBFFConstraint_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBFFConstraint') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBFFConstraint();
	}

	function GetGradient($a) {
		$r=OBFFConstraint_GetGradient($this->_cPtr,$a);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}
}

class OBFFConstraints {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBFFConstraints') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBFFConstraints();
	}

	function Clear() {
		OBFFConstraints_Clear($this->_cPtr);
	}

	function GetConstraintEnergy() {
		return OBFFConstraints_GetConstraintEnergy($this->_cPtr);
	}

	function GetGradient($a) {
		$r=OBFFConstraints_GetGradient($this->_cPtr,$a);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function Setup($mol) {
		OBFFConstraints_Setup($this->_cPtr,$mol);
	}

	function SetFactor($factor) {
		OBFFConstraints_SetFactor($this->_cPtr,$factor);
	}

	function AddIgnore($a) {
		OBFFConstraints_AddIgnore($this->_cPtr,$a);
	}

	function AddAtomConstraint($a) {
		OBFFConstraints_AddAtomConstraint($this->_cPtr,$a);
	}

	function AddAtomXConstraint($a) {
		OBFFConstraints_AddAtomXConstraint($this->_cPtr,$a);
	}

	function AddAtomYConstraint($a) {
		OBFFConstraints_AddAtomYConstraint($this->_cPtr,$a);
	}

	function AddAtomZConstraint($a) {
		OBFFConstraints_AddAtomZConstraint($this->_cPtr,$a);
	}

	function AddDistanceConstraint($a,$b,$length) {
		OBFFConstraints_AddDistanceConstraint($this->_cPtr,$a,$b,$length);
	}

	function AddAngleConstraint($a,$b,$c_,$angle) {
		OBFFConstraints_AddAngleConstraint($this->_cPtr,$a,$b,$c_,$angle);
	}

	function AddTorsionConstraint($a,$b,$c_,$d,$torsion) {
		OBFFConstraints_AddTorsionConstraint($this->_cPtr,$a,$b,$c_,$d,$torsion);
	}

	function DeleteConstraint($index) {
		OBFFConstraints_DeleteConstraint($this->_cPtr,$index);
	}

	function GetFactor() {
		return OBFFConstraints_GetFactor($this->_cPtr);
	}

	function Size() {
		return OBFFConstraints_Size($this->_cPtr);
	}

	function GetConstraintType($index) {
		return OBFFConstraints_GetConstraintType($this->_cPtr,$index);
	}

	function GetConstraintValue($index) {
		return OBFFConstraints_GetConstraintValue($this->_cPtr,$index);
	}

	function GetConstraintAtomA($index) {
		return OBFFConstraints_GetConstraintAtomA($this->_cPtr,$index);
	}

	function GetConstraintAtomB($index) {
		return OBFFConstraints_GetConstraintAtomB($this->_cPtr,$index);
	}

	function GetConstraintAtomC($index) {
		return OBFFConstraints_GetConstraintAtomC($this->_cPtr,$index);
	}

	function GetConstraintAtomD($index) {
		return OBFFConstraints_GetConstraintAtomD($this->_cPtr,$index);
	}

	function IsIgnored($a) {
		return OBFFConstraints_IsIgnored($this->_cPtr,$a);
	}

	function IsFixed($a) {
		return OBFFConstraints_IsFixed($this->_cPtr,$a);
	}

	function IsXFixed($a) {
		return OBFFConstraints_IsXFixed($this->_cPtr,$a);
	}

	function IsYFixed($a) {
		return OBFFConstraints_IsYFixed($this->_cPtr,$a);
	}

	function IsZFixed($a) {
		return OBFFConstraints_IsZFixed($this->_cPtr,$a);
	}

	function GetIgnoredBitVec() {
		$r=OBFFConstraints_GetIgnoredBitVec($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBitVec($r);
		}
		return $r;
	}

	function GetFixedBitVec() {
		$r=OBFFConstraints_GetFixedBitVec($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBitVec($r);
		}
		return $r;
	}
}

class OBForceField extends OBPlugin {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBPlugin::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBPlugin::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBPlugin::__isset($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	static function c_Default() {
		return OBForceField_c_Default();
	}

	function FindType($ID) {
		$r=OBForceField_FindType($ID);
		$this->_cPtr = $r;
		return $this;
	}

	function MakeNewInstance() {
		$r=OBForceField_MakeNewInstance($this->_cPtr);
		$this->_cPtr = $r;
		return $this;
	}

	static function FindForceField($ID) {
		$r=OBForceField_FindForceField($ID);
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_p_OpenBabel__OBForceField': return $r;
		default: return new OBForceField($r);
		}
	}

	function SetParameterFile($filename) {
		OBForceField_SetParameterFile($this->_cPtr,$filename);
	}

	function GetUnit() {
		return OBForceField_GetUnit($this->_cPtr);
	}

	function HasAnalyticalGradients() {
		return OBForceField_HasAnalyticalGradients($this->_cPtr);
	}

	function Setup($mol,$constraints=null) {
		switch (func_num_args()) {
		case 1: $r=OBForceField_Setup($this->_cPtr,$mol); break;
		default: $r=OBForceField_Setup($this->_cPtr,$mol,$constraints);
		}
		return $r;
	}

	function ParseParamFile() {
		return OBForceField_ParseParamFile($this->_cPtr);
	}

	function SetTypes() {
		return OBForceField_SetTypes($this->_cPtr);
	}

	function SetFormalCharges() {
		return OBForceField_SetFormalCharges($this->_cPtr);
	}

	function SetPartialCharges() {
		return OBForceField_SetPartialCharges($this->_cPtr);
	}

	function SetupCalculations() {
		return OBForceField_SetupCalculations($this->_cPtr);
	}

	function SetupPointers() {
		return OBForceField_SetupPointers($this->_cPtr);
	}

	function IsSetupNeeded($mol) {
		return OBForceField_IsSetupNeeded($this->_cPtr,$mol);
	}

	function GetAtomTypes($mol) {
		return OBForceField_GetAtomTypes($this->_cPtr,$mol);
	}

	function GetPartialCharges($mol) {
		return OBForceField_GetPartialCharges($this->_cPtr,$mol);
	}

	function GetCoordinates($mol) {
		return OBForceField_GetCoordinates($this->_cPtr,$mol);
	}

	function UpdateCoordinates($mol) {
		return OBForceField_UpdateCoordinates($this->_cPtr,$mol);
	}

	function GetConformers($mol) {
		return OBForceField_GetConformers($this->_cPtr,$mol);
	}

	function UpdateConformers($mol) {
		return OBForceField_UpdateConformers($this->_cPtr,$mol);
	}

	function SetCoordinates($mol) {
		return OBForceField_SetCoordinates($this->_cPtr,$mol);
	}

	function SetConformers($mol) {
		return OBForceField_SetConformers($this->_cPtr,$mol);
	}

	function GetGrid($step,$padding,$type,$pchg) {
		$r=OBForceField_GetGrid($this->_cPtr,$step,$padding,$type,$pchg);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBGridData($r);
		}
		return $r;
	}

	function AddIntraGroup($group) {
		OBForceField_AddIntraGroup($this->_cPtr,$group);
	}

	function AddInterGroup($group) {
		OBForceField_AddInterGroup($this->_cPtr,$group);
	}

	function AddInterGroups($group1,$group2) {
		OBForceField_AddInterGroups($this->_cPtr,$group1,$group2);
	}

	function ClearGroups() {
		OBForceField_ClearGroups($this->_cPtr);
	}

	function HasGroups() {
		return OBForceField_HasGroups($this->_cPtr);
	}

	function EnableCutOff($enable) {
		OBForceField_EnableCutOff($this->_cPtr,$enable);
	}

	function IsCutOffEnabled() {
		return OBForceField_IsCutOffEnabled($this->_cPtr);
	}

	function SetVDWCutOff($r_) {
		OBForceField_SetVDWCutOff($this->_cPtr,$r_);
	}

	function GetVDWCutOff() {
		return OBForceField_GetVDWCutOff($this->_cPtr);
	}

	function SetElectrostaticCutOff($r_) {
		OBForceField_SetElectrostaticCutOff($this->_cPtr,$r_);
	}

	function GetElectrostaticCutOff() {
		return OBForceField_GetElectrostaticCutOff($this->_cPtr);
	}

	function SetDielectricConstant($epsilon) {
		OBForceField_SetDielectricConstant($this->_cPtr,$epsilon);
	}

	function GetDielectricConstant() {
		return OBForceField_GetDielectricConstant($this->_cPtr);
	}

	function SetUpdateFrequency($f) {
		OBForceField_SetUpdateFrequency($this->_cPtr,$f);
	}

	function GetUpdateFrequency() {
		return OBForceField_GetUpdateFrequency($this->_cPtr);
	}

	function UpdatePairsSimple() {
		OBForceField_UpdatePairsSimple($this->_cPtr);
	}

	function GetNumPairs() {
		return OBForceField_GetNumPairs($this->_cPtr);
	}

	function GetNumElectrostaticPairs() {
		return OBForceField_GetNumElectrostaticPairs($this->_cPtr);
	}

	function GetNumVDWPairs() {
		return OBForceField_GetNumVDWPairs($this->_cPtr);
	}

	function EnableAllPairs() {
		OBForceField_EnableAllPairs($this->_cPtr);
	}

	function GetGradient($a,$arg2=null) {
		switch (func_num_args()) {
		case 1: $r=OBForceField_GetGradient($this->_cPtr,$a); break;
		default: $r=OBForceField_GetGradient($this->_cPtr,$a,$arg2);
		}
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function GetGradientPtr() {
		return OBForceField_GetGradientPtr($this->_cPtr);
	}

	function Energy($gradients=true) {
		return OBForceField_Energy($this->_cPtr,$gradients);
	}

	function E_Bond($gradients=true) {
		return OBForceField_E_Bond($this->_cPtr,$gradients);
	}

	function E_Angle($gradients=true) {
		return OBForceField_E_Angle($this->_cPtr,$gradients);
	}

	function E_StrBnd($gradients=true) {
		return OBForceField_E_StrBnd($this->_cPtr,$gradients);
	}

	function E_Torsion($gradients=true) {
		return OBForceField_E_Torsion($this->_cPtr,$gradients);
	}

	function E_OOP($gradients=true) {
		return OBForceField_E_OOP($this->_cPtr,$gradients);
	}

	function E_VDW($gradients=true) {
		return OBForceField_E_VDW($this->_cPtr,$gradients);
	}

	function E_Electrostatic($gradients=true) {
		return OBForceField_E_Electrostatic($this->_cPtr,$gradients);
	}

	function PrintTypes() {
		OBForceField_PrintTypes($this->_cPtr);
	}

	function PrintFormalCharges() {
		OBForceField_PrintFormalCharges($this->_cPtr);
	}

	function PrintPartialCharges() {
		OBForceField_PrintPartialCharges($this->_cPtr);
	}

	function PrintVelocities() {
		OBForceField_PrintVelocities($this->_cPtr);
	}

	function SetLogFile($pos) {
		return OBForceField_SetLogFile($this->_cPtr,$pos);
	}

	function SetLogLevel($level) {
		return OBForceField_SetLogLevel($this->_cPtr,$level);
	}

	function GetLogLevel() {
		return OBForceField_GetLogLevel($this->_cPtr);
	}

	function OBFFLog($msg) {
		OBForceField_OBFFLog($this->_cPtr,$msg);
	}

	function DistanceGeometry() {
		OBForceField_DistanceGeometry($this->_cPtr);
	}

	function SystematicRotorSearch($geomSteps=2500,$sampleRingBonds=false) {
		OBForceField_SystematicRotorSearch($this->_cPtr,$geomSteps,$sampleRingBonds);
	}

	function SystematicRotorSearchInitialize($geomSteps=2500,$sampleRingBonds=false) {
		return OBForceField_SystematicRotorSearchInitialize($this->_cPtr,$geomSteps,$sampleRingBonds);
	}

	function SystematicRotorSearchNextConformer($geomSteps=2500) {
		return OBForceField_SystematicRotorSearchNextConformer($this->_cPtr,$geomSteps);
	}

	function RandomRotorSearch($conformers,$geomSteps=2500,$sampleRingBonds=false) {
		OBForceField_RandomRotorSearch($this->_cPtr,$conformers,$geomSteps,$sampleRingBonds);
	}

	function RandomRotorSearchInitialize($conformers,$geomSteps=2500,$sampleRingBonds=false) {
		OBForceField_RandomRotorSearchInitialize($this->_cPtr,$conformers,$geomSteps,$sampleRingBonds);
	}

	function RandomRotorSearchNextConformer($geomSteps=2500) {
		return OBForceField_RandomRotorSearchNextConformer($this->_cPtr,$geomSteps);
	}

	function WeightedRotorSearch($conformers,$geomSteps,$sampleRingBonds=false) {
		OBForceField_WeightedRotorSearch($this->_cPtr,$conformers,$geomSteps,$sampleRingBonds);
	}

	function FastRotorSearch($permute=true) {
		return OBForceField_FastRotorSearch($this->_cPtr,$permute);
	}

	function SetLineSearchType($type) {
		OBForceField_SetLineSearchType($this->_cPtr,$type);
	}

	function GetLineSearchType() {
		return OBForceField_GetLineSearchType($this->_cPtr);
	}

	function LineSearch($atom_or_currentCoords,$direction) {
		return OBForceField_LineSearch($this->_cPtr,$atom_or_currentCoords,$direction);
	}

	function Newton2NumLineSearch($direction) {
		return OBForceField_Newton2NumLineSearch($this->_cPtr,$direction);
	}

	function LineSearchTakeStep($origCoords,$direction,$step) {
		OBForceField_LineSearchTakeStep($this->_cPtr,$origCoords,$direction,$step);
	}

	function SteepestDescent($steps,$econv=null,$method=null) {
		switch (func_num_args()) {
		case 1: OBForceField_SteepestDescent($this->_cPtr,$steps); break;
		case 2: OBForceField_SteepestDescent($this->_cPtr,$steps,$econv); break;
		default: OBForceField_SteepestDescent($this->_cPtr,$steps,$econv,$method);
		}
	}

	function SteepestDescentInitialize($steps=1000,$econv=null,$method=null) {
		switch (func_num_args()) {
		case 0: case 1: OBForceField_SteepestDescentInitialize($this->_cPtr,$steps); break;
		case 2: OBForceField_SteepestDescentInitialize($this->_cPtr,$steps,$econv); break;
		default: OBForceField_SteepestDescentInitialize($this->_cPtr,$steps,$econv,$method);
		}
	}

	function SteepestDescentTakeNSteps($n) {
		return OBForceField_SteepestDescentTakeNSteps($this->_cPtr,$n);
	}

	function ConjugateGradients($steps,$econv=null,$method=null) {
		switch (func_num_args()) {
		case 1: OBForceField_ConjugateGradients($this->_cPtr,$steps); break;
		case 2: OBForceField_ConjugateGradients($this->_cPtr,$steps,$econv); break;
		default: OBForceField_ConjugateGradients($this->_cPtr,$steps,$econv,$method);
		}
	}

	function ConjugateGradientsInitialize($steps=1000,$econv=null,$method=null) {
		switch (func_num_args()) {
		case 0: case 1: OBForceField_ConjugateGradientsInitialize($this->_cPtr,$steps); break;
		case 2: OBForceField_ConjugateGradientsInitialize($this->_cPtr,$steps,$econv); break;
		default: OBForceField_ConjugateGradientsInitialize($this->_cPtr,$steps,$econv,$method);
		}
	}

	function ConjugateGradientsTakeNSteps($n) {
		return OBForceField_ConjugateGradientsTakeNSteps($this->_cPtr,$n);
	}

	function GenerateVelocities() {
		OBForceField_GenerateVelocities($this->_cPtr);
	}

	function CorrectVelocities() {
		OBForceField_CorrectVelocities($this->_cPtr);
	}

	function MolecularDynamicsTakeNSteps($n,$T,$timestep=0.001,$method=null) {
		switch (func_num_args()) {
		case 2: case 3: OBForceField_MolecularDynamicsTakeNSteps($this->_cPtr,$n,$T,$timestep); break;
		default: OBForceField_MolecularDynamicsTakeNSteps($this->_cPtr,$n,$T,$timestep,$method);
		}
	}

	function GetConstraints() {
		$r=OBForceField_GetConstraints($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBFFConstraints($r);
		}
		return $r;
	}

	function SetConstraints($constraints) {
		OBForceField_SetConstraints($this->_cPtr,$constraints);
	}

	function SetFixAtom($index) {
		OBForceField_SetFixAtom($this->_cPtr,$index);
	}

	function UnsetFixAtom() {
		OBForceField_UnsetFixAtom($this->_cPtr);
	}

	function SetIgnoreAtom($index) {
		OBForceField_SetIgnoreAtom($this->_cPtr,$index);
	}

	function UnsetIgnoreAtom() {
		OBForceField_UnsetIgnoreAtom($this->_cPtr);
	}

	static function IgnoreCalculation($a,$b,$c_=null,$d=null) {
		switch (func_num_args()) {
		case 2: $r=OBForceField_IgnoreCalculation($a,$b); break;
		case 3: $r=OBForceField_IgnoreCalculation($a,$b,$c_); break;
		default: $r=OBForceField_IgnoreCalculation($a,$b,$c_,$d);
		}
		return $r;
	}

	function DetectExplosion() {
		return OBForceField_DetectExplosion($this->_cPtr);
	}

	function ValidateLineSearch($atom,$direction) {
		$r=OBForceField_ValidateLineSearch($this->_cPtr,$atom,$direction);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	function ValidateSteepestDescent($steps) {
		OBForceField_ValidateSteepestDescent($this->_cPtr,$steps);
	}

	function ValidateConjugateGradients($steps) {
		OBForceField_ValidateConjugateGradients($this->_cPtr,$steps);
	}

	function Validate() {
		return OBForceField_Validate($this->_cPtr);
	}

	function ValidateGradients() {
		return OBForceField_ValidateGradients($this->_cPtr);
	}

	function ValidateGradientError($numgrad,$anagrad) {
		$r=OBForceField_ValidateGradientError($this->_cPtr,$numgrad,$anagrad);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	static function VectorBondDerivative($pos_a,$pos_b,$force_a,$force_b) {
		return OBForceField_VectorBondDerivative($pos_a,$pos_b,$force_a,$force_b);
	}

	static function VectorDistanceDerivative($pos_i,$pos_j,$force_i,$force_j) {
		return OBForceField_VectorDistanceDerivative($pos_i,$pos_j,$force_i,$force_j);
	}

	static function VectorLengthDerivative($a,$b) {
		return OBForceField_VectorLengthDerivative($a,$b);
	}

	static function VectorAngleDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$force_a=null,$force_b=null,$force_c=null) {
		switch (func_num_args()) {
		case 3: $r=OBForceField_VectorAngleDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c); break;
		case 4: $r=OBForceField_VectorAngleDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$force_a); break;
		case 5: $r=OBForceField_VectorAngleDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$force_a,$force_b); break;
		default: $r=OBForceField_VectorAngleDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$force_a,$force_b,$force_c);
		}
		return $r;
	}

	static function VectorOOPDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a=null,$force_b=null,$force_c=null,$force_d=null) {
		switch (func_num_args()) {
		case 4: $r=OBForceField_VectorOOPDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d); break;
		case 5: $r=OBForceField_VectorOOPDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a); break;
		case 6: $r=OBForceField_VectorOOPDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a,$force_b); break;
		case 7: $r=OBForceField_VectorOOPDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a,$force_b,$force_c); break;
		default: $r=OBForceField_VectorOOPDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a,$force_b,$force_c,$force_d);
		}
		return $r;
	}

	static function VectorTorsionDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a=null,$force_b=null,$force_c=null,$force_d=null) {
		switch (func_num_args()) {
		case 4: $r=OBForceField_VectorTorsionDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d); break;
		case 5: $r=OBForceField_VectorTorsionDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a); break;
		case 6: $r=OBForceField_VectorTorsionDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a,$force_b); break;
		case 7: $r=OBForceField_VectorTorsionDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a,$force_b,$force_c); break;
		default: $r=OBForceField_VectorTorsionDerivative($pos_a_or_a,$pos_b_or_b,$pos_c_or_c,$pos_d_or_d,$force_a,$force_b,$force_c,$force_d);
		}
		return $r;
	}

	static function VectorSubtract($i,$j,$result) {
		OBForceField_VectorSubtract($i,$j,$result);
	}

	static function VectorAdd($i,$j,$result) {
		OBForceField_VectorAdd($i,$j,$result);
	}

	static function VectorDivide($i,$n,$result) {
		OBForceField_VectorDivide($i,$n,$result);
	}

	static function VectorMultiply($i,$n,$result) {
		OBForceField_VectorMultiply($i,$n,$result);
	}

	static function VectorSelfMultiply($i,$n) {
		OBForceField_VectorSelfMultiply($i,$n);
	}

	static function VectorNormalize($i) {
		OBForceField_VectorNormalize($i);
	}

	static function VectorCopy($from,$to) {
		OBForceField_VectorCopy($from,$to);
	}

	static function VectorLength($i) {
		return OBForceField_VectorLength($i);
	}

	static function VectorDistance($pos_i,$pos_j) {
		return OBForceField_VectorDistance($pos_i,$pos_j);
	}

	static function VectorAngle($i,$j,$k) {
		return OBForceField_VectorAngle($i,$j,$k);
	}

	static function VectorTorsion($i,$j,$k,$l) {
		return OBForceField_VectorTorsion($i,$j,$k,$l);
	}

	static function VectorOOP($i,$j,$k,$l) {
		return OBForceField_VectorOOP($i,$j,$k,$l);
	}

	static function VectorClear($i) {
		OBForceField_VectorClear($i);
	}

	static function VectorDot($i,$j) {
		return OBForceField_VectorDot($i,$j);
	}

	static function VectorCross($i,$j,$result) {
		OBForceField_VectorCross($i,$j,$result);
	}

	static function PrintVector($i) {
		OBForceField_PrintVector($i);
	}

	function SetLogToStdOut() {
		OBForceField_SetLogToStdOut($this->_cPtr);
	}

	function SetLogToStdErr() {
		OBForceField_SetLogToStdErr($this->_cPtr);
	}
}

class OBBuilder {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBBuilder') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBBuilder();
	}

	function Build($mol,$stereoWarnings=true) {
		return OBBuilder_Build($this->_cPtr,$mol,$stereoWarnings);
	}

	function SetKeepRings() {
		OBBuilder_SetKeepRings($this->_cPtr);
	}

	function UnsetKeepRings() {
		OBBuilder_UnsetKeepRings($this->_cPtr);
	}

	function LoadFragments() {
		OBBuilder_LoadFragments($this->_cPtr);
	}

	function GetFragmentCoord($smiles) {
		$r=OBBuilder_GetFragmentCoord($this->_cPtr,$smiles);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorVector3($r);
		}
		return $r;
	}

	static function GetNewBondVector($atom,$length=null) {
		switch (func_num_args()) {
		case 1: $r=OBBuilder_GetNewBondVector($atom); break;
		default: $r=OBBuilder_GetNewBondVector($atom,$length);
		}
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}

	static function Connect($mol,$a,$b,$newpos_or_bondOrder=1,$bondOrder=1) {
		$r=OBBuilder_Connect($mol,$a,$b,$newpos_or_bondOrder,$bondOrder);
		return $r;
	}

	static function Swap($mol,$a,$b,$c_,$d) {
		return OBBuilder_Swap($mol,$a,$b,$c_,$d);
	}

	static function CorrectStereoBonds($mol) {
		return OBBuilder_CorrectStereoBonds($mol);
	}

	static function CorrectStereoAtoms($mol,$warn=true) {
		return OBBuilder_CorrectStereoAtoms($mol,$warn);
	}

	static function IsSpiroAtom($atomId,$mol) {
		return OBBuilder_IsSpiroAtom($atomId,$mol);
	}

	static function GetFragment($atom) {
		$r=OBBuilder_GetFragment($atom);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBitVec($r);
		}
		return $r;
	}

	static function AddNbrs($fragment,$atom) {
		OBBuilder_AddNbrs($fragment,$atom);
	}
}

class OBOp extends OBPlugin {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBPlugin::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBPlugin::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBPlugin::__isset($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	static function c_Default() {
		return OBOp_c_Default();
	}

	function FindType($ID) {
		$r=OBOp_FindType($ID);
		$this->_cPtr = $r;
		return $this;
	}

	function c_Do($pOb,$OptionText=null,$pOptions=null,$pConv=null) {
		switch (func_num_args()) {
		case 1: $r=OBOp_c_Do($this->_cPtr,$pOb); break;
		default: $r=OBOp_c_Do($this->_cPtr,$pOb,$OptionText,$pOptions,$pConv);
		}
		return $r;
	}

	function WorksWith($pOb) {
		return OBOp_WorksWith($this->_cPtr,$pOb);
	}

	function ProcessVec($arg1) {
		return OBOp_ProcessVec($this->_cPtr,$arg1);
	}

	static function OpOptions($pOb) {
		return OBOp_OpOptions($pOb);
	}

	static function DoOps($pOb,$pOptions,$pConv) {
		return OBOp_DoOps($pOb,$pOptions,$pConv);
	}
}

class OBChargeModel extends OBPlugin {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBPlugin::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBPlugin::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBPlugin::__isset($var);
	}

	static function c_Default() {
		return OBChargeModel_c_Default();
	}

	function __construct($ID,$IsDefault=false) {
		if (is_resource($ID) && get_resource_type($ID) === '_p_OpenBabel__OBChargeModel') {
			$this->_cPtr=$ID;
			return;
		}
		$this->_cPtr=new_OBChargeModel($ID,$IsDefault);
	}

	function FindType($ID) {
		$r=OBChargeModel_FindType($ID);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBChargeModel($r);
		}
		return $r;
	}

	function ComputeCharges($m,$args=null) {
		switch (func_num_args()) {
		case 1: $r=OBChargeModel_ComputeCharges($this->_cPtr,$m); break;
		default: $r=OBChargeModel_ComputeCharges($this->_cPtr,$m,$args);
		}
		return $r;
	}

	function GetFormalCharges() {
		$r=OBChargeModel_GetFormalCharges($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetPartialCharges() {
		$r=OBChargeModel_GetPartialCharges($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetDipoleMoment($arg1) {
		$r=OBChargeModel_GetDipoleMoment($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vector3($r);
		}
		return $r;
	}
}

class OBGraphSym {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($pmol,$frag_atoms=null) {
		if (is_resource($pmol) && get_resource_type($pmol) === '_p_OpenBabel__OBGraphSym') {
			$this->_cPtr=$pmol;
			return;
		}
		$this->_cPtr=new_OBGraphSym($pmol,$frag_atoms);
	}

	static function NoSymmetryClass() {
		return OBGraphSym_NoSymmetryClass_get();
	}

	function GetSymmetry($symmetry_classes) {
		return OBGraphSym_GetSymmetry($this->_cPtr,$symmetry_classes);
	}

	function ClearSymmetry() {
		OBGraphSym_ClearSymmetry($this->_cPtr);
	}
}

abstract class OBIsomorphismMapper {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	static function GetInstance($query,$algorithm=null) {
		switch (func_num_args()) {
		case 1: $r=OBIsomorphismMapper_GetInstance($query); break;
		default: $r=OBIsomorphismMapper_GetInstance($query,$algorithm);
		}
		if (!is_resource($r)) return $r;
		return new OBIsomorphismMapper($r);
	}

	function MapFirst($queried,$map,$mask=null) {
		switch (func_num_args()) {
		case 2: OBIsomorphismMapper_MapFirst($this->_cPtr,$queried,$map); break;
		default: OBIsomorphismMapper_MapFirst($this->_cPtr,$queried,$map,$mask);
		}
	}

	function MapUnique($queried,$maps,$mask=null) {
		switch (func_num_args()) {
		case 2: OBIsomorphismMapper_MapUnique($this->_cPtr,$queried,$maps); break;
		default: OBIsomorphismMapper_MapUnique($this->_cPtr,$queried,$maps,$mask);
		}
	}

	function MapAll($queried,$maps,$mask=null,$maxMemory=null) {
		switch (func_num_args()) {
		case 2: OBIsomorphismMapper_MapAll($this->_cPtr,$queried,$maps); break;
		case 3: OBIsomorphismMapper_MapAll($this->_cPtr,$queried,$maps,$mask); break;
		default: OBIsomorphismMapper_MapAll($this->_cPtr,$queried,$maps,$mask,$maxMemory);
		}
	}

	function MapGeneric($functor,$queried,$mask=null) {
		switch (func_num_args()) {
		case 2: OBIsomorphismMapper_MapGeneric($this->_cPtr,$functor,$queried); break;
		default: OBIsomorphismMapper_MapGeneric($this->_cPtr,$functor,$queried,$mask);
		}
	}

	function SetTimeout($seconds) {
		OBIsomorphismMapper_SetTimeout($this->_cPtr,$seconds);
	}
}

class OBQueryAtom {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($atomicNum=6,$isInRing=false,$isAromatic=false) {
		if (is_resource($atomicNum) && get_resource_type($atomicNum) === '_p_OpenBabel__OBQueryAtom') {
			$this->_cPtr=$atomicNum;
			return;
		}
		$this->_cPtr=new_OBQueryAtom($atomicNum,$isInRing,$isAromatic);
	}

	function GetIndex() {
		return OBQueryAtom_GetIndex($this->_cPtr);
	}

	function GetBonds() {
		return OBQueryAtom_GetBonds($this->_cPtr);
	}

	function GetNbrs() {
		return OBQueryAtom_GetNbrs($this->_cPtr);
	}

	function Matches($atom) {
		return OBQueryAtom_Matches($this->_cPtr,$atom);
	}
}

class OBQueryBond {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($begin,$end,$order=1,$aromatic=false) {
		if (is_resource($begin) && get_resource_type($begin) === '_p_OpenBabel__OBQueryBond') {
			$this->_cPtr=$begin;
			return;
		}
		$this->_cPtr=new_OBQueryBond($begin,$end,$order,$aromatic);
	}

	function GetIndex() {
		return OBQueryBond_GetIndex($this->_cPtr);
	}

	function GetBeginAtom() {
		$r=OBQueryBond_GetBeginAtom($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBQueryAtom($r);
		}
		return $r;
	}

	function GetEndAtom() {
		$r=OBQueryBond_GetEndAtom($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBQueryAtom($r);
		}
		return $r;
	}

	function Matches($bond) {
		return OBQueryBond_Matches($this->_cPtr,$bond);
	}
}

class OBQuery {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function NumAtoms() {
		return OBQuery_NumAtoms($this->_cPtr);
	}

	function NumBonds() {
		return OBQuery_NumBonds($this->_cPtr);
	}

	function GetAtoms() {
		return OBQuery_GetAtoms($this->_cPtr);
	}

	function GetBonds() {
		return OBQuery_GetBonds($this->_cPtr);
	}

	function GetBond($begin,$end) {
		$r=OBQuery_GetBond($this->_cPtr,$begin,$end);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBQueryBond($r);
		}
		return $r;
	}

	function AddAtom($atom) {
		OBQuery_AddAtom($this->_cPtr,$atom);
	}

	function AddBond($bond) {
		OBQuery_AddBond($this->_cPtr,$bond);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBQuery') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBQuery();
	}
}

class OBStereo {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	const CisTrans = OBStereo_CisTrans;

	const ExtendedCisTrans = OBStereo_ExtendedCisTrans;

	const SquarePlanar = OBStereo_SquarePlanar;

	const Tetrahedral = OBStereo_Tetrahedral;

	const ExtendedTetrahedral = OBStereo_ExtendedTetrahedral;

	const TrigonalBipyramidal = OBStereo_TrigonalBipyramidal;

	const Octahedral = OBStereo_Octahedral;

	const NotStereo = 0;

	const UpBond = 1;

	const DownBond = 6;

	const UnknownDir = 4;

	const ShapeU = 1;

	const ShapeZ = 2;

	const Shape4 = 3;

	const ViewFrom = 1;

	const ViewTowards = 2;

	const Clockwise = 1;

	const AntiClockwise = 2;

	const UnknownWinding = 3;

	const NoRef = OBStereo_NoRef;

	const ImplicitRef = OBStereo_ImplicitRef;

	static function MakeRefs($ref1,$ref2,$ref3,$ref4=null) {
		switch (func_num_args()) {
		case 3: $r=OBStereo_MakeRefs($ref1,$ref2,$ref3); break;
		default: $r=OBStereo_MakeRefs($ref1,$ref2,$ref3,$ref4);
		}
		return $r;
	}

	static function ContainsSameRefs($refs1,$refs2) {
		return OBStereo_ContainsSameRefs($refs1,$refs2);
	}

	static function ContainsRef($refs,$ref) {
		return OBStereo_ContainsRef($refs,$ref);
	}

	static function NumInversions($refs) {
		return OBStereo_NumInversions($refs);
	}

	static function Permutate($refs,$i,$j) {
		OBStereo_Permutate($refs,$i,$j);
	}

	static function Permutated($refs,$i,$j) {
		return OBStereo_Permutated($refs,$i,$j);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBStereo') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBStereo();
	}
}

class OBStereoUnit {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'OBStereoUnit_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		$func = 'OBStereoUnit_'.$var.'_get';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBStereoUnit_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($_type=null,$_id=null,$_para=false) {
		if (is_resource($_type) && get_resource_type($_type) === '_p_OpenBabel__OBStereoUnit') {
			$this->_cPtr=$_type;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBStereoUnit(); break;
		case 1: $this->_cPtr=new_OBStereoUnit($_type); break;
		default: $this->_cPtr=new_OBStereoUnit($_type,$_id,$_para);
		}
	}
}

abstract class OBStereoBase extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	function GetMolecule() {
		$r=OBStereoBase_GetMolecule($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetType() {
		return OBStereoBase_GetType($this->_cPtr);
	}

	function SetSpecified($specified) {
		OBStereoBase_SetSpecified($this->_cPtr,$specified);
	}

	function IsSpecified() {
		return OBStereoBase_IsSpecified($this->_cPtr);
	}
}

class OBStereoFacade {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol,$perceive=true) {
		if (is_resource($mol) && get_resource_type($mol) === '_p_OpenBabel__OBStereoFacade') {
			$this->_cPtr=$mol;
			return;
		}
		$this->_cPtr=new_OBStereoFacade($mol,$perceive);
	}

	function NumTetrahedralStereo() {
		return OBStereoFacade_NumTetrahedralStereo($this->_cPtr);
	}

	function HasTetrahedralStereo($atomId) {
		return OBStereoFacade_HasTetrahedralStereo($this->_cPtr,$atomId);
	}

	function GetTetrahedralStereo($atomId) {
		return OBStereoFacade_GetTetrahedralStereo($this->_cPtr,$atomId);
	}

	function NumCisTransStereo() {
		return OBStereoFacade_NumCisTransStereo($this->_cPtr);
	}

	function HasCisTransStereo($bondId) {
		return OBStereoFacade_HasCisTransStereo($this->_cPtr,$bondId);
	}

	function GetCisTransStereo($bondId) {
		return OBStereoFacade_GetCisTransStereo($this->_cPtr,$bondId);
	}

	function NumSquarePlanarStereo() {
		return OBStereoFacade_NumSquarePlanarStereo($this->_cPtr);
	}

	function HasSquarePlanarStereo($atomId) {
		return OBStereoFacade_HasSquarePlanarStereo($this->_cPtr,$atomId);
	}

	function GetSquarePlanarStereo($atomId) {
		return OBStereoFacade_GetSquarePlanarStereo($this->_cPtr,$atomId);
	}
}

class OBRotorRule {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($buffer,$ref,$vals,$d) {
		if (is_resource($buffer) && get_resource_type($buffer) === '_p_OpenBabel__OBRotorRule') {
			$this->_cPtr=$buffer;
			return;
		}
		$this->_cPtr=new_OBRotorRule($buffer,$ref,$vals,$d);
	}

	function IsValid() {
		return OBRotorRule_IsValid($this->_cPtr);
	}

	function GetReferenceAtoms($ref) {
		OBRotorRule_GetReferenceAtoms($this->_cPtr,$ref);
	}

	function SetDelta($d) {
		OBRotorRule_SetDelta($this->_cPtr,$d);
	}

	function GetDelta() {
		return OBRotorRule_GetDelta($this->_cPtr);
	}

	function GetTorsionVals() {
		$r=OBRotorRule_GetTorsionVals($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetSmartsString() {
		return OBRotorRule_GetSmartsString($this->_cPtr);
	}

	function GetSmartsPattern() {
		$r=OBRotorRule_GetSmartsPattern($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBSmartsPattern($r);
		}
		return $r;
	}
}

class OBRotorRules extends OBGlobalDataBase {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGlobalDataBase::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGlobalDataBase::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGlobalDataBase::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRotorRules') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRotorRules();
	}

	function SetFilename($s) {
		OBRotorRules_SetFilename($this->_cPtr,$s);
	}

	function GetRotorIncrements($mol,$bond,$refs,$vals,$delta) {
		OBRotorRules_GetRotorIncrements($this->_cPtr,$mol,$bond,$refs,$vals,$delta);
	}

	function Quiet() {
		OBRotorRules_Quiet($this->_cPtr);
	}
}

class OBRotor {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRotor') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRotor();
	}

	function SetBond($bond) {
		OBRotor_SetBond($this->_cPtr,$bond);
	}

	function SetRings() {
		OBRotor_SetRings($this->_cPtr);
	}

	function SetIdx($idx) {
		OBRotor_SetIdx($this->_cPtr,$idx);
	}

	function SetDihedralAtoms($ref) {
		OBRotor_SetDihedralAtoms($this->_cPtr,$ref);
	}

	function SetRotAtoms($atoms) {
		OBRotor_SetRotAtoms($this->_cPtr,$atoms);
	}

	function SetTorsionValues($angles) {
		OBRotor_SetTorsionValues($this->_cPtr,$angles);
	}

	function SetFixedBonds($bv) {
		OBRotor_SetFixedBonds($this->_cPtr,$bv);
	}

	function SetToAngle($coordinates,$setang) {
		OBRotor_SetToAngle($this->_cPtr,$coordinates,$setang);
	}

	function SetRotor($coordinates,$next,$prev=-1) {
		OBRotor_SetRotor($this->_cPtr,$coordinates,$next,$prev);
	}

	function Precompute($coordinates) {
		OBRotor_Precompute($this->_cPtr,$coordinates);
	}

	function Precalc($conformers) {
		OBRotor_Precalc($this->_cPtr,$conformers);
	}

	function Set($coordinates,$sine_or_idx_or_conformer,$cosine_or_idx=null,$translation=null,$invmag=null) {
		switch (func_num_args()) {
		case 2: OBRotor_Set($this->_cPtr,$coordinates,$sine_or_idx_or_conformer); break;
		case 3: OBRotor_Set($this->_cPtr,$coordinates,$sine_or_idx_or_conformer,$cosine_or_idx); break;
		case 4: OBRotor_Set($this->_cPtr,$coordinates,$sine_or_idx_or_conformer,$cosine_or_idx,$translation); break;
		default: OBRotor_Set($this->_cPtr,$coordinates,$sine_or_idx_or_conformer,$cosine_or_idx,$translation,$invmag);
		}
	}

	function GetBond() {
		$r=OBRotor_GetBond($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function Size() {
		return OBRotor_Size($this->_cPtr);
	}

	function GetIdx() {
		return OBRotor_GetIdx($this->_cPtr);
	}

	function GetDihedralAtoms($ref=null) {
		switch (func_num_args()) {
		case 0: $r=OBRotor_GetDihedralAtoms($this->_cPtr); break;
		default: $r=OBRotor_GetDihedralAtoms($this->_cPtr,$ref);
		}
		if (!is_resource($r)) return $r;
		return new vectorInt($r);
	}

	function GetTorsionValues() {
		$r=OBRotor_GetTorsionValues($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function GetFixedBonds() {
		$r=OBRotor_GetFixedBonds($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBitVec($r);
		}
		return $r;
	}

	function CalcTorsion($coordinates) {
		return OBRotor_CalcTorsion($this->_cPtr,$coordinates);
	}

	function CalcBondLength($coordinates) {
		return OBRotor_CalcBondLength($this->_cPtr,$coordinates);
	}

	function BeginTorIncrement() {
		return OBRotor_BeginTorIncrement($this->_cPtr);
	}

	function EndTorIncrement() {
		return OBRotor_EndTorIncrement($this->_cPtr);
	}

	function RemoveSymTorsionValues($arg1) {
		OBRotor_RemoveSymTorsionValues($this->_cPtr,$arg1);
	}

	function SetDelta($d) {
		OBRotor_SetDelta($this->_cPtr,$d);
	}

	function GetDelta() {
		return OBRotor_GetDelta($this->_cPtr);
	}

	function GetFixedAtoms() {
		$r=OBRotor_GetFixedAtoms($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBitVec($r);
		}
		return $r;
	}

	function SetFixedAtoms($bv) {
		OBRotor_SetFixedAtoms($this->_cPtr,$bv);
	}

	function GetEvalAtoms() {
		$r=OBRotor_GetEvalAtoms($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBitVec($r);
		}
		return $r;
	}

	function SetEvalAtoms($bv) {
		OBRotor_SetEvalAtoms($this->_cPtr,$bv);
	}

	function GetRotAtoms() {
		return OBRotor_GetRotAtoms($this->_cPtr);
	}

	function GetResolution() {
		$r=OBRotor_GetResolution($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}

	function SetNumCoords($nc) {
		OBRotor_SetNumCoords($this->_cPtr,$nc);
	}
}

class OBRotorList {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRotorList') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRotorList();
	}

	function Clear() {
		OBRotorList_Clear($this->_cPtr);
	}

	function Size() {
		return OBRotorList_Size($this->_cPtr);
	}

	function IsFixedBond($arg1) {
		return OBRotorList_IsFixedBond($this->_cPtr,$arg1);
	}

	function HasFixedBonds() {
		return OBRotorList_HasFixedBonds($this->_cPtr);
	}

	function RemoveSymVals($arg1) {
		OBRotorList_RemoveSymVals($this->_cPtr,$arg1);
	}

	function HasRingRotors() {
		return OBRotorList_HasRingRotors($this->_cPtr);
	}

	function Setup($mol,$sampleRings=false) {
		return OBRotorList_Setup($this->_cPtr,$mol,$sampleRings);
	}

	function SetFixedBonds($fix) {
		OBRotorList_SetFixedBonds($this->_cPtr,$fix);
	}

	function Init($fname) {
		OBRotorList_Init($this->_cPtr,$fname);
	}

	function SetQuiet() {
		OBRotorList_SetQuiet($this->_cPtr);
	}

	function SetRotAtoms($arg1) {
		return OBRotorList_SetRotAtoms($this->_cPtr,$arg1);
	}

	function FindRotors($mol,$sampleRingBonds=false) {
		return OBRotorList_FindRotors($this->_cPtr,$mol,$sampleRingBonds);
	}

	function SetEvalAtoms($arg1) {
		return OBRotorList_SetEvalAtoms($this->_cPtr,$arg1);
	}

	function AssignTorVals($arg1) {
		return OBRotorList_AssignTorVals($this->_cPtr,$arg1);
	}

	function BeginRotor($i) {
		$r=OBRotorList_BeginRotor($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRotor($r);
		}
		return $r;
	}

	function NextRotor($i) {
		$r=OBRotorList_NextRotor($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRotor($r);
		}
		return $r;
	}

	function BeginRotors() {
		return OBRotorList_BeginRotors($this->_cPtr);
	}

	function EndRotors() {
		return OBRotorList_EndRotors($this->_cPtr);
	}

	function IdentifyEvalAtoms($mol) {
		return OBRotorList_IdentifyEvalAtoms($this->_cPtr,$mol);
	}

	function SetFixAtoms($fix) {
		OBRotorList_SetFixAtoms($this->_cPtr,$fix);
	}

	function HasFixedAtoms() {
		return OBRotorList_HasFixedAtoms($this->_cPtr);
	}

	function IgnoreSymmetryRemoval() {
		OBRotorList_IgnoreSymmetryRemoval($this->_cPtr);
	}

	function SetRotAtomsByFix($arg1) {
		OBRotorList_SetRotAtomsByFix($this->_cPtr,$arg1);
	}
}

class rotor_digit {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($rs=null) {
		if (is_resource($rs) && get_resource_type($rs) === '_p_OpenBabel__rotor_digit') {
			$this->_cPtr=$rs;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_rotor_digit(); break;
		default: $this->_cPtr=new_rotor_digit($rs);
		}
	}

	function set_size($rs) {
		rotor_digit_set_size($this->_cPtr,$rs);
	}

	function set_state($st) {
		rotor_digit_set_state($this->_cPtr,$st);
	}

	function get_state() {
		return rotor_digit_get_state($this->_cPtr);
	}

	function size() {
		return rotor_digit_size($this->_cPtr);
	}

	function next() {
		return rotor_digit_next($this->_cPtr);
	}
}

class OBRotorKeys {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRotorKeys') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRotorKeys();
	}

	function Clear() {
		OBRotorKeys_Clear($this->_cPtr);
	}

	function NumKeys() {
		return OBRotorKeys_NumKeys($this->_cPtr);
	}

	function AddRotor($size) {
		OBRotorKeys_AddRotor($this->_cPtr,$size);
	}

	function Next() {
		return OBRotorKeys_Next($this->_cPtr);
	}

	function GetKey() {
		$r=OBRotorKeys_GetKey($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorInt($r);
		}
		return $r;
	}
}

class OBRotamerList extends OBGenericData {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		OBGenericData::__set($var,$value);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return OBGenericData::__get($var);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return OBGenericData::__isset($var);
	}

	function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_OpenBabel__OBRotamerList') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_OBRotamerList();
	}

	function Setup($mol,$ref,$nrotors=null) {
		switch (func_num_args()) {
		case 2: OBRotamerList_Setup($this->_cPtr,$mol,$ref); break;
		default: OBRotamerList_Setup($this->_cPtr,$mol,$ref,$nrotors);
		}
	}

	function NumRotors() {
		return OBRotamerList_NumRotors($this->_cPtr);
	}

	function NumRotamers() {
		return OBRotamerList_NumRotamers($this->_cPtr);
	}

	function AddRotamer($key) {
		OBRotamerList_AddRotamer($this->_cPtr,$key);
	}

	function AddRotamers($arr,$nconf) {
		OBRotamerList_AddRotamers($this->_cPtr,$arr,$nconf);
	}

	function GetReferenceArray($arg1) {
		OBRotamerList_GetReferenceArray($this->_cPtr,$arg1);
	}

	function BeginRotamer() {
		return OBRotamerList_BeginRotamer($this->_cPtr);
	}

	function EndRotamer() {
		return OBRotamerList_EndRotamer($this->_cPtr);
	}

	function CreateConformerList($mol) {
		return OBRotamerList_CreateConformerList($this->_cPtr,$mol);
	}

	function ExpandConformerList($mol,$confs) {
		OBRotamerList_ExpandConformerList($this->_cPtr,$mol,$confs);
	}

	function SetCurrentCoordinates($mol,$arr) {
		return OBRotamerList_SetCurrentCoordinates($this->_cPtr,$mol,$arr);
	}

	function SetBaseCoordinateSets($mol_or_bc,$N=null) {
		switch (func_num_args()) {
		case 1: OBRotamerList_SetBaseCoordinateSets($this->_cPtr,$mol_or_bc); break;
		default: OBRotamerList_SetBaseCoordinateSets($this->_cPtr,$mol_or_bc,$N);
		}
	}

	function NumBaseCoordinateSets() {
		return OBRotamerList_NumBaseCoordinateSets($this->_cPtr);
	}

	function GetBaseCoordinateSet($i) {
		return OBRotamerList_GetBaseCoordinateSet($this->_cPtr,$i);
	}

	function NumAtoms() {
		return OBRotamerList_NumAtoms($this->_cPtr);
	}
}

class OBSpectrophore {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	const AngStepSize1 = 0;

	const AngStepSize2 = OBSpectrophore_AngStepSize2;

	const AngStepSize5 = OBSpectrophore_AngStepSize5;

	const AngStepSize10 = OBSpectrophore_AngStepSize10;

	const AngStepSize15 = OBSpectrophore_AngStepSize15;

	const AngStepSize20 = OBSpectrophore_AngStepSize20;

	const AngStepSize30 = OBSpectrophore_AngStepSize30;

	const AngStepSize36 = OBSpectrophore_AngStepSize36;

	const AngStepSize45 = OBSpectrophore_AngStepSize45;

	const AngStepSize60 = OBSpectrophore_AngStepSize60;

	const NoNormalization = 0;

	const NormalizationTowardsZeroMean = OBSpectrophore_NormalizationTowardsZeroMean;

	const NormalizationTowardsUnitStd = OBSpectrophore_NormalizationTowardsUnitStd;

	const NormalizationTowardsZeroMeanAndUnitStd = OBSpectrophore_NormalizationTowardsZeroMeanAndUnitStd;

	const NoStereoSpecificProbes = 0;

	const UniqueStereoSpecificProbes = OBSpectrophore_UniqueStereoSpecificProbes;

	const MirrorStereoSpecificProbes = OBSpectrophore_MirrorStereoSpecificProbes;

	const AllStereoSpecificProbes = OBSpectrophore_AllStereoSpecificProbes;

	function __construct($sphore=null) {
		if (is_resource($sphore) && get_resource_type($sphore) === '_p_OpenBabel__OBSpectrophore') {
			$this->_cPtr=$sphore;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBSpectrophore(); break;
		default: $this->_cPtr=new_OBSpectrophore($sphore);
		}
	}

	function SetResolution($r_=3.0) {
		OBSpectrophore_SetResolution($this->_cPtr,$r_);
	}

	function SetAccuracy($a=null) {
		switch (func_num_args()) {
		case 0: OBSpectrophore_SetAccuracy($this->_cPtr); break;
		default: OBSpectrophore_SetAccuracy($this->_cPtr,$a);
		}
	}

	function SetStereo($s=null) {
		switch (func_num_args()) {
		case 0: OBSpectrophore_SetStereo($this->_cPtr); break;
		default: OBSpectrophore_SetStereo($this->_cPtr,$s);
		}
	}

	function SetNormalization($n=null) {
		switch (func_num_args()) {
		case 0: OBSpectrophore_SetNormalization($this->_cPtr); break;
		default: OBSpectrophore_SetNormalization($this->_cPtr,$n);
		}
	}

	function GetAccuracy() {
		return OBSpectrophore_GetAccuracy($this->_cPtr);
	}

	function GetResolution() {
		return OBSpectrophore_GetResolution($this->_cPtr);
	}

	function GetStereo() {
		return OBSpectrophore_GetStereo($this->_cPtr);
	}

	function GetNormalization() {
		return OBSpectrophore_GetNormalization($this->_cPtr);
	}

	function GetSpectrophore($mol) {
		$r=OBSpectrophore_GetSpectrophore($this->_cPtr,$mol);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorDouble($r);
		}
		return $r;
	}
}

class OBMolAtomIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBMolAtomIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBMolAtomIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBMolAtomIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ai=null) {
		if (is_resource($mol_or_ai) && get_resource_type($mol_or_ai) === '_p_OpenBabel__OBMolAtomIter') {
			$this->_cPtr=$mol_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolAtomIter(); break;
		default: $this->_cPtr=new_OBMolAtomIter($mol_or_ai);
		}
	}

	function __deref__() {
		$r=OBMolAtomIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBMolAtomIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function Duplicate($arg1) {
		OBMolAtomIter_Duplicate($this->_cPtr,$arg1);
	}

	function SetIdx($idx) {
		OBMolAtomIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBMolAtomIter_SetId($this->_cPtr,$id);
	}

	function SetHyb($hyb) {
		OBMolAtomIter_SetHyb($this->_cPtr,$hyb);
	}

	function SetAtomicNum($atomicnum) {
		OBMolAtomIter_SetAtomicNum($this->_cPtr,$atomicnum);
	}

	function SetIsotope($iso) {
		OBMolAtomIter_SetIsotope($this->_cPtr,$iso);
	}

	function SetImplicitHCount($val) {
		OBMolAtomIter_SetImplicitHCount($this->_cPtr,$val);
	}

	function SetFormalCharge($fcharge) {
		OBMolAtomIter_SetFormalCharge($this->_cPtr,$fcharge);
	}

	function SetSpinMultiplicity($spin) {
		OBMolAtomIter_SetSpinMultiplicity($this->_cPtr,$spin);
	}

	function SetType($type) {
		OBMolAtomIter_SetType($this->_cPtr,$type);
	}

	function SetPartialCharge($pcharge) {
		OBMolAtomIter_SetPartialCharge($this->_cPtr,$pcharge);
	}

	function SetVector($v_or_x=null,$y=null,$z=null) {
		switch (func_num_args()) {
		case 0: OBMolAtomIter_SetVector($this->_cPtr); break;
		case 1: OBMolAtomIter_SetVector($this->_cPtr,$v_or_x); break;
		case 2: OBMolAtomIter_SetVector($this->_cPtr,$v_or_x,$y); break;
		default: OBMolAtomIter_SetVector($this->_cPtr,$v_or_x,$y,$z);
		}
	}

	function SetCoordPtr($c_) {
		OBMolAtomIter_SetCoordPtr($this->_cPtr,$c_);
	}

	function SetResidue($res) {
		OBMolAtomIter_SetResidue($this->_cPtr,$res);
	}

	function SetParent($ptr) {
		OBMolAtomIter_SetParent($this->_cPtr,$ptr);
	}

	function SetAromatic($value=true) {
		OBMolAtomIter_SetAromatic($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBMolAtomIter_SetInRing($this->_cPtr,$value);
	}

	function ClearCoordPtr() {
		OBMolAtomIter_ClearCoordPtr($this->_cPtr);
	}

	function GetFormalCharge() {
		return OBMolAtomIter_GetFormalCharge($this->_cPtr);
	}

	function GetAtomicNum() {
		return OBMolAtomIter_GetAtomicNum($this->_cPtr);
	}

	function GetIsotope() {
		return OBMolAtomIter_GetIsotope($this->_cPtr);
	}

	function GetSpinMultiplicity() {
		return OBMolAtomIter_GetSpinMultiplicity($this->_cPtr);
	}

	function GetAtomicMass() {
		return OBMolAtomIter_GetAtomicMass($this->_cPtr);
	}

	function GetExactMass() {
		return OBMolAtomIter_GetExactMass($this->_cPtr);
	}

	function GetIdx() {
		return OBMolAtomIter_GetIdx($this->_cPtr);
	}

	function GetIndex() {
		return OBMolAtomIter_GetIndex($this->_cPtr);
	}

	function GetId() {
		return OBMolAtomIter_GetId($this->_cPtr);
	}

	function GetCoordinateIdx() {
		return OBMolAtomIter_GetCoordinateIdx($this->_cPtr);
	}

	function GetExplicitDegree() {
		return OBMolAtomIter_GetExplicitDegree($this->_cPtr);
	}

	function GetTotalDegree() {
		return OBMolAtomIter_GetTotalDegree($this->_cPtr);
	}

	function GetExplicitValence() {
		return OBMolAtomIter_GetExplicitValence($this->_cPtr);
	}

	function GetTotalValence() {
		return OBMolAtomIter_GetTotalValence($this->_cPtr);
	}

	function GetHyb() {
		return OBMolAtomIter_GetHyb($this->_cPtr);
	}

	function GetImplicitHCount() {
		return OBMolAtomIter_GetImplicitHCount($this->_cPtr);
	}

	function GetHvyDegree() {
		return OBMolAtomIter_GetHvyDegree($this->_cPtr);
	}

	function GetHeteroDegree() {
		return OBMolAtomIter_GetHeteroDegree($this->_cPtr);
	}

	function GetType() {
		return OBMolAtomIter_GetType($this->_cPtr);
	}

	function GetX() {
		return OBMolAtomIter_GetX($this->_cPtr);
	}

	function GetY() {
		return OBMolAtomIter_GetY($this->_cPtr);
	}

	function GetZ() {
		return OBMolAtomIter_GetZ($this->_cPtr);
	}

	function x() {
		return OBMolAtomIter_x($this->_cPtr);
	}

	function y() {
		return OBMolAtomIter_y($this->_cPtr);
	}

	function z() {
		return OBMolAtomIter_z($this->_cPtr);
	}

	function GetCoordinate() {
		return OBMolAtomIter_GetCoordinate($this->_cPtr);
	}

	function GetVector() {
		$r=OBMolAtomIter_GetVector($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function GetPartialCharge() {
		return OBMolAtomIter_GetPartialCharge($this->_cPtr);
	}

	function GetResidue() {
		$r=OBMolAtomIter_GetResidue($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBMolAtomIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetNewBondVector($v,$length) {
		return OBMolAtomIter_GetNewBondVector($this->_cPtr,$v,$length);
	}

	function GetBond($arg1) {
		$r=OBMolAtomIter_GetBond($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginBonds() {
		return OBMolAtomIter_BeginBonds($this->_cPtr);
	}

	function EndBonds() {
		return OBMolAtomIter_EndBonds($this->_cPtr);
	}

	function BeginBond($i) {
		$r=OBMolAtomIter_BeginBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function NextBond($i) {
		$r=OBMolAtomIter_NextBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginNbrAtom($i) {
		$r=OBMolAtomIter_BeginNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextNbrAtom($i) {
		$r=OBMolAtomIter_NextNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetDistance($index_or_v) {
		return OBMolAtomIter_GetDistance($this->_cPtr,$index_or_v);
	}

	function GetAngle($b,$c_) {
		return OBMolAtomIter_GetAngle($this->_cPtr,$b,$c_);
	}

	function NewResidue() {
		OBMolAtomIter_NewResidue($this->_cPtr);
	}

	function AddResidue($res) {
		OBMolAtomIter_AddResidue($this->_cPtr,$res);
	}

	function DeleteResidue() {
		OBMolAtomIter_DeleteResidue($this->_cPtr);
	}

	function AddBond($bond) {
		OBMolAtomIter_AddBond($this->_cPtr,$bond);
	}

	function InsertBond($i,$bond) {
		OBMolAtomIter_InsertBond($this->_cPtr,$i,$bond);
	}

	function DeleteBond($bond) {
		return OBMolAtomIter_DeleteBond($this->_cPtr,$bond);
	}

	function ClearBond() {
		OBMolAtomIter_ClearBond($this->_cPtr);
	}

	function HtoMethyl() {
		return OBMolAtomIter_HtoMethyl($this->_cPtr);
	}

	function SetHybAndGeom($arg1) {
		return OBMolAtomIter_SetHybAndGeom($this->_cPtr,$arg1);
	}

	function CountFreeOxygens() {
		return OBMolAtomIter_CountFreeOxygens($this->_cPtr);
	}

	function CountFreeSulfurs() {
		return OBMolAtomIter_CountFreeSulfurs($this->_cPtr);
	}

	function ExplicitHydrogenCount($ExcludeIsotopes=false) {
		return OBMolAtomIter_ExplicitHydrogenCount($this->_cPtr,$ExcludeIsotopes);
	}

	function MemberOfRingCount() {
		return OBMolAtomIter_MemberOfRingCount($this->_cPtr);
	}

	function MemberOfRingSize() {
		return OBMolAtomIter_MemberOfRingSize($this->_cPtr);
	}

	function CountRingBonds() {
		return OBMolAtomIter_CountRingBonds($this->_cPtr);
	}

	function SmallestBondAngle() {
		return OBMolAtomIter_SmallestBondAngle($this->_cPtr);
	}

	function AverageBondAngle() {
		return OBMolAtomIter_AverageBondAngle($this->_cPtr);
	}

	function LewisAcidBaseCounts() {
		return OBMolAtomIter_LewisAcidBaseCounts($this->_cPtr);
	}

	function HasResidue() {
		return OBMolAtomIter_HasResidue($this->_cPtr);
	}

	function IsHetAtom() {
		return OBMolAtomIter_IsHetAtom($this->_cPtr);
	}

	function IsAromatic() {
		return OBMolAtomIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBMolAtomIter_IsInRing($this->_cPtr);
	}

	function IsInRingSize($arg1) {
		return OBMolAtomIter_IsInRingSize($this->_cPtr,$arg1);
	}

	function IsHeteroatom() {
		return OBMolAtomIter_IsHeteroatom($this->_cPtr);
	}

	function IsConnected($arg1) {
		return OBMolAtomIter_IsConnected($this->_cPtr,$arg1);
	}

	function IsOneThree($arg1) {
		return OBMolAtomIter_IsOneThree($this->_cPtr,$arg1);
	}

	function IsOneFour($arg1) {
		return OBMolAtomIter_IsOneFour($this->_cPtr,$arg1);
	}

	function IsCarboxylOxygen() {
		return OBMolAtomIter_IsCarboxylOxygen($this->_cPtr);
	}

	function IsPhosphateOxygen() {
		return OBMolAtomIter_IsPhosphateOxygen($this->_cPtr);
	}

	function IsSulfateOxygen() {
		return OBMolAtomIter_IsSulfateOxygen($this->_cPtr);
	}

	function IsNitroOxygen() {
		return OBMolAtomIter_IsNitroOxygen($this->_cPtr);
	}

	function IsAmideNitrogen() {
		return OBMolAtomIter_IsAmideNitrogen($this->_cPtr);
	}

	function IsPolarHydrogen() {
		return OBMolAtomIter_IsPolarHydrogen($this->_cPtr);
	}

	function IsNonPolarHydrogen() {
		return OBMolAtomIter_IsNonPolarHydrogen($this->_cPtr);
	}

	function IsAromaticNOxide() {
		return OBMolAtomIter_IsAromaticNOxide($this->_cPtr);
	}

	function IsChiral() {
		return OBMolAtomIter_IsChiral($this->_cPtr);
	}

	function IsAxial() {
		return OBMolAtomIter_IsAxial($this->_cPtr);
	}

	function IsHbondAcceptor() {
		return OBMolAtomIter_IsHbondAcceptor($this->_cPtr);
	}

	function IsHbondAcceptorSimple() {
		return OBMolAtomIter_IsHbondAcceptorSimple($this->_cPtr);
	}

	function IsHbondDonor() {
		return OBMolAtomIter_IsHbondDonor($this->_cPtr);
	}

	function IsHbondDonorH() {
		return OBMolAtomIter_IsHbondDonorH($this->_cPtr);
	}

	function IsMetal() {
		return OBMolAtomIter_IsMetal($this->_cPtr);
	}

	function HasAlphaBetaUnsat($includePandS=true) {
		return OBMolAtomIter_HasAlphaBetaUnsat($this->_cPtr,$includePandS);
	}

	function HasBondOfOrder($bo) {
		return OBMolAtomIter_HasBondOfOrder($this->_cPtr,$bo);
	}

	function CountBondsOfOrder($bo) {
		return OBMolAtomIter_CountBondsOfOrder($this->_cPtr,$bo);
	}

	function HighestBondOrder() {
		return OBMolAtomIter_HighestBondOrder($this->_cPtr);
	}

	function HasNonSingleBond() {
		return OBMolAtomIter_HasNonSingleBond($this->_cPtr);
	}

	function HasSingleBond() {
		return OBMolAtomIter_HasSingleBond($this->_cPtr);
	}

	function HasDoubleBond() {
		return OBMolAtomIter_HasDoubleBond($this->_cPtr);
	}

	function HasAromaticBond() {
		return OBMolAtomIter_HasAromaticBond($this->_cPtr);
	}

	function MatchesSMARTS($arg1) {
		return OBMolAtomIter_MatchesSMARTS($this->_cPtr,$arg1);
	}

	function Clear() {
		return OBMolAtomIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBMolAtomIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBMolAtomIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBMolAtomIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBMolAtomIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBMolAtomIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBMolAtomIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBMolAtomIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBMolAtomIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBMolAtomIter_GetData($this->_cPtr); break;
		default: $r=OBMolAtomIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBMolAtomIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBMolAtomIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBMolAtomIter_EndData($this->_cPtr);
	}
}

class OBMolAtomDFSIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBMolAtomDFSIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBMolAtomDFSIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBMolAtomDFSIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ai=null,$StartIndex=1) {
		if (is_resource($mol_or_ai) && get_resource_type($mol_or_ai) === '_p_OpenBabel__OBMolAtomDFSIter') {
			$this->_cPtr=$mol_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolAtomDFSIter(); break;
		default: $this->_cPtr=new_OBMolAtomDFSIter($mol_or_ai,$StartIndex);
		}
	}

	function __deref__() {
		$r=OBMolAtomDFSIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBMolAtomDFSIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function next() {
		$r=OBMolAtomDFSIter_next($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function Duplicate($arg1) {
		OBMolAtomDFSIter_Duplicate($this->_cPtr,$arg1);
	}

	function SetIdx($idx) {
		OBMolAtomDFSIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBMolAtomDFSIter_SetId($this->_cPtr,$id);
	}

	function SetHyb($hyb) {
		OBMolAtomDFSIter_SetHyb($this->_cPtr,$hyb);
	}

	function SetAtomicNum($atomicnum) {
		OBMolAtomDFSIter_SetAtomicNum($this->_cPtr,$atomicnum);
	}

	function SetIsotope($iso) {
		OBMolAtomDFSIter_SetIsotope($this->_cPtr,$iso);
	}

	function SetImplicitHCount($val) {
		OBMolAtomDFSIter_SetImplicitHCount($this->_cPtr,$val);
	}

	function SetFormalCharge($fcharge) {
		OBMolAtomDFSIter_SetFormalCharge($this->_cPtr,$fcharge);
	}

	function SetSpinMultiplicity($spin) {
		OBMolAtomDFSIter_SetSpinMultiplicity($this->_cPtr,$spin);
	}

	function SetType($type) {
		OBMolAtomDFSIter_SetType($this->_cPtr,$type);
	}

	function SetPartialCharge($pcharge) {
		OBMolAtomDFSIter_SetPartialCharge($this->_cPtr,$pcharge);
	}

	function SetVector($v_or_x=null,$y=null,$z=null) {
		switch (func_num_args()) {
		case 0: OBMolAtomDFSIter_SetVector($this->_cPtr); break;
		case 1: OBMolAtomDFSIter_SetVector($this->_cPtr,$v_or_x); break;
		case 2: OBMolAtomDFSIter_SetVector($this->_cPtr,$v_or_x,$y); break;
		default: OBMolAtomDFSIter_SetVector($this->_cPtr,$v_or_x,$y,$z);
		}
	}

	function SetCoordPtr($c_) {
		OBMolAtomDFSIter_SetCoordPtr($this->_cPtr,$c_);
	}

	function SetResidue($res) {
		OBMolAtomDFSIter_SetResidue($this->_cPtr,$res);
	}

	function SetParent($ptr) {
		OBMolAtomDFSIter_SetParent($this->_cPtr,$ptr);
	}

	function SetAromatic($value=true) {
		OBMolAtomDFSIter_SetAromatic($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBMolAtomDFSIter_SetInRing($this->_cPtr,$value);
	}

	function ClearCoordPtr() {
		OBMolAtomDFSIter_ClearCoordPtr($this->_cPtr);
	}

	function GetFormalCharge() {
		return OBMolAtomDFSIter_GetFormalCharge($this->_cPtr);
	}

	function GetAtomicNum() {
		return OBMolAtomDFSIter_GetAtomicNum($this->_cPtr);
	}

	function GetIsotope() {
		return OBMolAtomDFSIter_GetIsotope($this->_cPtr);
	}

	function GetSpinMultiplicity() {
		return OBMolAtomDFSIter_GetSpinMultiplicity($this->_cPtr);
	}

	function GetAtomicMass() {
		return OBMolAtomDFSIter_GetAtomicMass($this->_cPtr);
	}

	function GetExactMass() {
		return OBMolAtomDFSIter_GetExactMass($this->_cPtr);
	}

	function GetIdx() {
		return OBMolAtomDFSIter_GetIdx($this->_cPtr);
	}

	function GetIndex() {
		return OBMolAtomDFSIter_GetIndex($this->_cPtr);
	}

	function GetId() {
		return OBMolAtomDFSIter_GetId($this->_cPtr);
	}

	function GetCoordinateIdx() {
		return OBMolAtomDFSIter_GetCoordinateIdx($this->_cPtr);
	}

	function GetExplicitDegree() {
		return OBMolAtomDFSIter_GetExplicitDegree($this->_cPtr);
	}

	function GetTotalDegree() {
		return OBMolAtomDFSIter_GetTotalDegree($this->_cPtr);
	}

	function GetExplicitValence() {
		return OBMolAtomDFSIter_GetExplicitValence($this->_cPtr);
	}

	function GetTotalValence() {
		return OBMolAtomDFSIter_GetTotalValence($this->_cPtr);
	}

	function GetHyb() {
		return OBMolAtomDFSIter_GetHyb($this->_cPtr);
	}

	function GetImplicitHCount() {
		return OBMolAtomDFSIter_GetImplicitHCount($this->_cPtr);
	}

	function GetHvyDegree() {
		return OBMolAtomDFSIter_GetHvyDegree($this->_cPtr);
	}

	function GetHeteroDegree() {
		return OBMolAtomDFSIter_GetHeteroDegree($this->_cPtr);
	}

	function GetType() {
		return OBMolAtomDFSIter_GetType($this->_cPtr);
	}

	function GetX() {
		return OBMolAtomDFSIter_GetX($this->_cPtr);
	}

	function GetY() {
		return OBMolAtomDFSIter_GetY($this->_cPtr);
	}

	function GetZ() {
		return OBMolAtomDFSIter_GetZ($this->_cPtr);
	}

	function x() {
		return OBMolAtomDFSIter_x($this->_cPtr);
	}

	function y() {
		return OBMolAtomDFSIter_y($this->_cPtr);
	}

	function z() {
		return OBMolAtomDFSIter_z($this->_cPtr);
	}

	function GetCoordinate() {
		return OBMolAtomDFSIter_GetCoordinate($this->_cPtr);
	}

	function GetVector() {
		$r=OBMolAtomDFSIter_GetVector($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function GetPartialCharge() {
		return OBMolAtomDFSIter_GetPartialCharge($this->_cPtr);
	}

	function GetResidue() {
		$r=OBMolAtomDFSIter_GetResidue($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBMolAtomDFSIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetNewBondVector($v,$length) {
		return OBMolAtomDFSIter_GetNewBondVector($this->_cPtr,$v,$length);
	}

	function GetBond($arg1) {
		$r=OBMolAtomDFSIter_GetBond($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginBonds() {
		return OBMolAtomDFSIter_BeginBonds($this->_cPtr);
	}

	function EndBonds() {
		return OBMolAtomDFSIter_EndBonds($this->_cPtr);
	}

	function BeginBond($i) {
		$r=OBMolAtomDFSIter_BeginBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function NextBond($i) {
		$r=OBMolAtomDFSIter_NextBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginNbrAtom($i) {
		$r=OBMolAtomDFSIter_BeginNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextNbrAtom($i) {
		$r=OBMolAtomDFSIter_NextNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetDistance($index_or_v) {
		return OBMolAtomDFSIter_GetDistance($this->_cPtr,$index_or_v);
	}

	function GetAngle($b,$c_) {
		return OBMolAtomDFSIter_GetAngle($this->_cPtr,$b,$c_);
	}

	function NewResidue() {
		OBMolAtomDFSIter_NewResidue($this->_cPtr);
	}

	function AddResidue($res) {
		OBMolAtomDFSIter_AddResidue($this->_cPtr,$res);
	}

	function DeleteResidue() {
		OBMolAtomDFSIter_DeleteResidue($this->_cPtr);
	}

	function AddBond($bond) {
		OBMolAtomDFSIter_AddBond($this->_cPtr,$bond);
	}

	function InsertBond($i,$bond) {
		OBMolAtomDFSIter_InsertBond($this->_cPtr,$i,$bond);
	}

	function DeleteBond($bond) {
		return OBMolAtomDFSIter_DeleteBond($this->_cPtr,$bond);
	}

	function ClearBond() {
		OBMolAtomDFSIter_ClearBond($this->_cPtr);
	}

	function HtoMethyl() {
		return OBMolAtomDFSIter_HtoMethyl($this->_cPtr);
	}

	function SetHybAndGeom($arg1) {
		return OBMolAtomDFSIter_SetHybAndGeom($this->_cPtr,$arg1);
	}

	function CountFreeOxygens() {
		return OBMolAtomDFSIter_CountFreeOxygens($this->_cPtr);
	}

	function CountFreeSulfurs() {
		return OBMolAtomDFSIter_CountFreeSulfurs($this->_cPtr);
	}

	function ExplicitHydrogenCount($ExcludeIsotopes=false) {
		return OBMolAtomDFSIter_ExplicitHydrogenCount($this->_cPtr,$ExcludeIsotopes);
	}

	function MemberOfRingCount() {
		return OBMolAtomDFSIter_MemberOfRingCount($this->_cPtr);
	}

	function MemberOfRingSize() {
		return OBMolAtomDFSIter_MemberOfRingSize($this->_cPtr);
	}

	function CountRingBonds() {
		return OBMolAtomDFSIter_CountRingBonds($this->_cPtr);
	}

	function SmallestBondAngle() {
		return OBMolAtomDFSIter_SmallestBondAngle($this->_cPtr);
	}

	function AverageBondAngle() {
		return OBMolAtomDFSIter_AverageBondAngle($this->_cPtr);
	}

	function LewisAcidBaseCounts() {
		return OBMolAtomDFSIter_LewisAcidBaseCounts($this->_cPtr);
	}

	function HasResidue() {
		return OBMolAtomDFSIter_HasResidue($this->_cPtr);
	}

	function IsHetAtom() {
		return OBMolAtomDFSIter_IsHetAtom($this->_cPtr);
	}

	function IsAromatic() {
		return OBMolAtomDFSIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBMolAtomDFSIter_IsInRing($this->_cPtr);
	}

	function IsInRingSize($arg1) {
		return OBMolAtomDFSIter_IsInRingSize($this->_cPtr,$arg1);
	}

	function IsHeteroatom() {
		return OBMolAtomDFSIter_IsHeteroatom($this->_cPtr);
	}

	function IsConnected($arg1) {
		return OBMolAtomDFSIter_IsConnected($this->_cPtr,$arg1);
	}

	function IsOneThree($arg1) {
		return OBMolAtomDFSIter_IsOneThree($this->_cPtr,$arg1);
	}

	function IsOneFour($arg1) {
		return OBMolAtomDFSIter_IsOneFour($this->_cPtr,$arg1);
	}

	function IsCarboxylOxygen() {
		return OBMolAtomDFSIter_IsCarboxylOxygen($this->_cPtr);
	}

	function IsPhosphateOxygen() {
		return OBMolAtomDFSIter_IsPhosphateOxygen($this->_cPtr);
	}

	function IsSulfateOxygen() {
		return OBMolAtomDFSIter_IsSulfateOxygen($this->_cPtr);
	}

	function IsNitroOxygen() {
		return OBMolAtomDFSIter_IsNitroOxygen($this->_cPtr);
	}

	function IsAmideNitrogen() {
		return OBMolAtomDFSIter_IsAmideNitrogen($this->_cPtr);
	}

	function IsPolarHydrogen() {
		return OBMolAtomDFSIter_IsPolarHydrogen($this->_cPtr);
	}

	function IsNonPolarHydrogen() {
		return OBMolAtomDFSIter_IsNonPolarHydrogen($this->_cPtr);
	}

	function IsAromaticNOxide() {
		return OBMolAtomDFSIter_IsAromaticNOxide($this->_cPtr);
	}

	function IsChiral() {
		return OBMolAtomDFSIter_IsChiral($this->_cPtr);
	}

	function IsAxial() {
		return OBMolAtomDFSIter_IsAxial($this->_cPtr);
	}

	function IsHbondAcceptor() {
		return OBMolAtomDFSIter_IsHbondAcceptor($this->_cPtr);
	}

	function IsHbondAcceptorSimple() {
		return OBMolAtomDFSIter_IsHbondAcceptorSimple($this->_cPtr);
	}

	function IsHbondDonor() {
		return OBMolAtomDFSIter_IsHbondDonor($this->_cPtr);
	}

	function IsHbondDonorH() {
		return OBMolAtomDFSIter_IsHbondDonorH($this->_cPtr);
	}

	function IsMetal() {
		return OBMolAtomDFSIter_IsMetal($this->_cPtr);
	}

	function HasAlphaBetaUnsat($includePandS=true) {
		return OBMolAtomDFSIter_HasAlphaBetaUnsat($this->_cPtr,$includePandS);
	}

	function HasBondOfOrder($bo) {
		return OBMolAtomDFSIter_HasBondOfOrder($this->_cPtr,$bo);
	}

	function CountBondsOfOrder($bo) {
		return OBMolAtomDFSIter_CountBondsOfOrder($this->_cPtr,$bo);
	}

	function HighestBondOrder() {
		return OBMolAtomDFSIter_HighestBondOrder($this->_cPtr);
	}

	function HasNonSingleBond() {
		return OBMolAtomDFSIter_HasNonSingleBond($this->_cPtr);
	}

	function HasSingleBond() {
		return OBMolAtomDFSIter_HasSingleBond($this->_cPtr);
	}

	function HasDoubleBond() {
		return OBMolAtomDFSIter_HasDoubleBond($this->_cPtr);
	}

	function HasAromaticBond() {
		return OBMolAtomDFSIter_HasAromaticBond($this->_cPtr);
	}

	function MatchesSMARTS($arg1) {
		return OBMolAtomDFSIter_MatchesSMARTS($this->_cPtr,$arg1);
	}

	function Clear() {
		return OBMolAtomDFSIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBMolAtomDFSIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBMolAtomDFSIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBMolAtomDFSIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBMolAtomDFSIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBMolAtomDFSIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBMolAtomDFSIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBMolAtomDFSIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBMolAtomDFSIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBMolAtomDFSIter_GetData($this->_cPtr); break;
		default: $r=OBMolAtomDFSIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBMolAtomDFSIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBMolAtomDFSIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBMolAtomDFSIter_EndData($this->_cPtr);
	}
}

class OBMolAtomBFSIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBMolAtomBFSIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBMolAtomBFSIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBMolAtomBFSIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ai=null,$StartIndex=1) {
		if (is_resource($mol_or_ai) && get_resource_type($mol_or_ai) === '_p_OpenBabel__OBMolAtomBFSIter') {
			$this->_cPtr=$mol_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolAtomBFSIter(); break;
		default: $this->_cPtr=new_OBMolAtomBFSIter($mol_or_ai,$StartIndex);
		}
	}

	function __deref__() {
		$r=OBMolAtomBFSIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBMolAtomBFSIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function CurrentDepth() {
		return OBMolAtomBFSIter_CurrentDepth($this->_cPtr);
	}

	function Duplicate($arg1) {
		OBMolAtomBFSIter_Duplicate($this->_cPtr,$arg1);
	}

	function SetIdx($idx) {
		OBMolAtomBFSIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBMolAtomBFSIter_SetId($this->_cPtr,$id);
	}

	function SetHyb($hyb) {
		OBMolAtomBFSIter_SetHyb($this->_cPtr,$hyb);
	}

	function SetAtomicNum($atomicnum) {
		OBMolAtomBFSIter_SetAtomicNum($this->_cPtr,$atomicnum);
	}

	function SetIsotope($iso) {
		OBMolAtomBFSIter_SetIsotope($this->_cPtr,$iso);
	}

	function SetImplicitHCount($val) {
		OBMolAtomBFSIter_SetImplicitHCount($this->_cPtr,$val);
	}

	function SetFormalCharge($fcharge) {
		OBMolAtomBFSIter_SetFormalCharge($this->_cPtr,$fcharge);
	}

	function SetSpinMultiplicity($spin) {
		OBMolAtomBFSIter_SetSpinMultiplicity($this->_cPtr,$spin);
	}

	function SetType($type) {
		OBMolAtomBFSIter_SetType($this->_cPtr,$type);
	}

	function SetPartialCharge($pcharge) {
		OBMolAtomBFSIter_SetPartialCharge($this->_cPtr,$pcharge);
	}

	function SetVector($v_or_x=null,$y=null,$z=null) {
		switch (func_num_args()) {
		case 0: OBMolAtomBFSIter_SetVector($this->_cPtr); break;
		case 1: OBMolAtomBFSIter_SetVector($this->_cPtr,$v_or_x); break;
		case 2: OBMolAtomBFSIter_SetVector($this->_cPtr,$v_or_x,$y); break;
		default: OBMolAtomBFSIter_SetVector($this->_cPtr,$v_or_x,$y,$z);
		}
	}

	function SetCoordPtr($c_) {
		OBMolAtomBFSIter_SetCoordPtr($this->_cPtr,$c_);
	}

	function SetResidue($res) {
		OBMolAtomBFSIter_SetResidue($this->_cPtr,$res);
	}

	function SetParent($ptr) {
		OBMolAtomBFSIter_SetParent($this->_cPtr,$ptr);
	}

	function SetAromatic($value=true) {
		OBMolAtomBFSIter_SetAromatic($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBMolAtomBFSIter_SetInRing($this->_cPtr,$value);
	}

	function ClearCoordPtr() {
		OBMolAtomBFSIter_ClearCoordPtr($this->_cPtr);
	}

	function GetFormalCharge() {
		return OBMolAtomBFSIter_GetFormalCharge($this->_cPtr);
	}

	function GetAtomicNum() {
		return OBMolAtomBFSIter_GetAtomicNum($this->_cPtr);
	}

	function GetIsotope() {
		return OBMolAtomBFSIter_GetIsotope($this->_cPtr);
	}

	function GetSpinMultiplicity() {
		return OBMolAtomBFSIter_GetSpinMultiplicity($this->_cPtr);
	}

	function GetAtomicMass() {
		return OBMolAtomBFSIter_GetAtomicMass($this->_cPtr);
	}

	function GetExactMass() {
		return OBMolAtomBFSIter_GetExactMass($this->_cPtr);
	}

	function GetIdx() {
		return OBMolAtomBFSIter_GetIdx($this->_cPtr);
	}

	function GetIndex() {
		return OBMolAtomBFSIter_GetIndex($this->_cPtr);
	}

	function GetId() {
		return OBMolAtomBFSIter_GetId($this->_cPtr);
	}

	function GetCoordinateIdx() {
		return OBMolAtomBFSIter_GetCoordinateIdx($this->_cPtr);
	}

	function GetExplicitDegree() {
		return OBMolAtomBFSIter_GetExplicitDegree($this->_cPtr);
	}

	function GetTotalDegree() {
		return OBMolAtomBFSIter_GetTotalDegree($this->_cPtr);
	}

	function GetExplicitValence() {
		return OBMolAtomBFSIter_GetExplicitValence($this->_cPtr);
	}

	function GetTotalValence() {
		return OBMolAtomBFSIter_GetTotalValence($this->_cPtr);
	}

	function GetHyb() {
		return OBMolAtomBFSIter_GetHyb($this->_cPtr);
	}

	function GetImplicitHCount() {
		return OBMolAtomBFSIter_GetImplicitHCount($this->_cPtr);
	}

	function GetHvyDegree() {
		return OBMolAtomBFSIter_GetHvyDegree($this->_cPtr);
	}

	function GetHeteroDegree() {
		return OBMolAtomBFSIter_GetHeteroDegree($this->_cPtr);
	}

	function GetType() {
		return OBMolAtomBFSIter_GetType($this->_cPtr);
	}

	function GetX() {
		return OBMolAtomBFSIter_GetX($this->_cPtr);
	}

	function GetY() {
		return OBMolAtomBFSIter_GetY($this->_cPtr);
	}

	function GetZ() {
		return OBMolAtomBFSIter_GetZ($this->_cPtr);
	}

	function x() {
		return OBMolAtomBFSIter_x($this->_cPtr);
	}

	function y() {
		return OBMolAtomBFSIter_y($this->_cPtr);
	}

	function z() {
		return OBMolAtomBFSIter_z($this->_cPtr);
	}

	function GetCoordinate() {
		return OBMolAtomBFSIter_GetCoordinate($this->_cPtr);
	}

	function GetVector() {
		$r=OBMolAtomBFSIter_GetVector($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function GetPartialCharge() {
		return OBMolAtomBFSIter_GetPartialCharge($this->_cPtr);
	}

	function GetResidue() {
		$r=OBMolAtomBFSIter_GetResidue($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBMolAtomBFSIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetNewBondVector($v,$length) {
		return OBMolAtomBFSIter_GetNewBondVector($this->_cPtr,$v,$length);
	}

	function GetBond($arg1) {
		$r=OBMolAtomBFSIter_GetBond($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginBonds() {
		return OBMolAtomBFSIter_BeginBonds($this->_cPtr);
	}

	function EndBonds() {
		return OBMolAtomBFSIter_EndBonds($this->_cPtr);
	}

	function BeginBond($i) {
		$r=OBMolAtomBFSIter_BeginBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function NextBond($i) {
		$r=OBMolAtomBFSIter_NextBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginNbrAtom($i) {
		$r=OBMolAtomBFSIter_BeginNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextNbrAtom($i) {
		$r=OBMolAtomBFSIter_NextNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetDistance($index_or_v) {
		return OBMolAtomBFSIter_GetDistance($this->_cPtr,$index_or_v);
	}

	function GetAngle($b,$c_) {
		return OBMolAtomBFSIter_GetAngle($this->_cPtr,$b,$c_);
	}

	function NewResidue() {
		OBMolAtomBFSIter_NewResidue($this->_cPtr);
	}

	function AddResidue($res) {
		OBMolAtomBFSIter_AddResidue($this->_cPtr,$res);
	}

	function DeleteResidue() {
		OBMolAtomBFSIter_DeleteResidue($this->_cPtr);
	}

	function AddBond($bond) {
		OBMolAtomBFSIter_AddBond($this->_cPtr,$bond);
	}

	function InsertBond($i,$bond) {
		OBMolAtomBFSIter_InsertBond($this->_cPtr,$i,$bond);
	}

	function DeleteBond($bond) {
		return OBMolAtomBFSIter_DeleteBond($this->_cPtr,$bond);
	}

	function ClearBond() {
		OBMolAtomBFSIter_ClearBond($this->_cPtr);
	}

	function HtoMethyl() {
		return OBMolAtomBFSIter_HtoMethyl($this->_cPtr);
	}

	function SetHybAndGeom($arg1) {
		return OBMolAtomBFSIter_SetHybAndGeom($this->_cPtr,$arg1);
	}

	function CountFreeOxygens() {
		return OBMolAtomBFSIter_CountFreeOxygens($this->_cPtr);
	}

	function CountFreeSulfurs() {
		return OBMolAtomBFSIter_CountFreeSulfurs($this->_cPtr);
	}

	function ExplicitHydrogenCount($ExcludeIsotopes=false) {
		return OBMolAtomBFSIter_ExplicitHydrogenCount($this->_cPtr,$ExcludeIsotopes);
	}

	function MemberOfRingCount() {
		return OBMolAtomBFSIter_MemberOfRingCount($this->_cPtr);
	}

	function MemberOfRingSize() {
		return OBMolAtomBFSIter_MemberOfRingSize($this->_cPtr);
	}

	function CountRingBonds() {
		return OBMolAtomBFSIter_CountRingBonds($this->_cPtr);
	}

	function SmallestBondAngle() {
		return OBMolAtomBFSIter_SmallestBondAngle($this->_cPtr);
	}

	function AverageBondAngle() {
		return OBMolAtomBFSIter_AverageBondAngle($this->_cPtr);
	}

	function LewisAcidBaseCounts() {
		return OBMolAtomBFSIter_LewisAcidBaseCounts($this->_cPtr);
	}

	function HasResidue() {
		return OBMolAtomBFSIter_HasResidue($this->_cPtr);
	}

	function IsHetAtom() {
		return OBMolAtomBFSIter_IsHetAtom($this->_cPtr);
	}

	function IsAromatic() {
		return OBMolAtomBFSIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBMolAtomBFSIter_IsInRing($this->_cPtr);
	}

	function IsInRingSize($arg1) {
		return OBMolAtomBFSIter_IsInRingSize($this->_cPtr,$arg1);
	}

	function IsHeteroatom() {
		return OBMolAtomBFSIter_IsHeteroatom($this->_cPtr);
	}

	function IsConnected($arg1) {
		return OBMolAtomBFSIter_IsConnected($this->_cPtr,$arg1);
	}

	function IsOneThree($arg1) {
		return OBMolAtomBFSIter_IsOneThree($this->_cPtr,$arg1);
	}

	function IsOneFour($arg1) {
		return OBMolAtomBFSIter_IsOneFour($this->_cPtr,$arg1);
	}

	function IsCarboxylOxygen() {
		return OBMolAtomBFSIter_IsCarboxylOxygen($this->_cPtr);
	}

	function IsPhosphateOxygen() {
		return OBMolAtomBFSIter_IsPhosphateOxygen($this->_cPtr);
	}

	function IsSulfateOxygen() {
		return OBMolAtomBFSIter_IsSulfateOxygen($this->_cPtr);
	}

	function IsNitroOxygen() {
		return OBMolAtomBFSIter_IsNitroOxygen($this->_cPtr);
	}

	function IsAmideNitrogen() {
		return OBMolAtomBFSIter_IsAmideNitrogen($this->_cPtr);
	}

	function IsPolarHydrogen() {
		return OBMolAtomBFSIter_IsPolarHydrogen($this->_cPtr);
	}

	function IsNonPolarHydrogen() {
		return OBMolAtomBFSIter_IsNonPolarHydrogen($this->_cPtr);
	}

	function IsAromaticNOxide() {
		return OBMolAtomBFSIter_IsAromaticNOxide($this->_cPtr);
	}

	function IsChiral() {
		return OBMolAtomBFSIter_IsChiral($this->_cPtr);
	}

	function IsAxial() {
		return OBMolAtomBFSIter_IsAxial($this->_cPtr);
	}

	function IsHbondAcceptor() {
		return OBMolAtomBFSIter_IsHbondAcceptor($this->_cPtr);
	}

	function IsHbondAcceptorSimple() {
		return OBMolAtomBFSIter_IsHbondAcceptorSimple($this->_cPtr);
	}

	function IsHbondDonor() {
		return OBMolAtomBFSIter_IsHbondDonor($this->_cPtr);
	}

	function IsHbondDonorH() {
		return OBMolAtomBFSIter_IsHbondDonorH($this->_cPtr);
	}

	function IsMetal() {
		return OBMolAtomBFSIter_IsMetal($this->_cPtr);
	}

	function HasAlphaBetaUnsat($includePandS=true) {
		return OBMolAtomBFSIter_HasAlphaBetaUnsat($this->_cPtr,$includePandS);
	}

	function HasBondOfOrder($bo) {
		return OBMolAtomBFSIter_HasBondOfOrder($this->_cPtr,$bo);
	}

	function CountBondsOfOrder($bo) {
		return OBMolAtomBFSIter_CountBondsOfOrder($this->_cPtr,$bo);
	}

	function HighestBondOrder() {
		return OBMolAtomBFSIter_HighestBondOrder($this->_cPtr);
	}

	function HasNonSingleBond() {
		return OBMolAtomBFSIter_HasNonSingleBond($this->_cPtr);
	}

	function HasSingleBond() {
		return OBMolAtomBFSIter_HasSingleBond($this->_cPtr);
	}

	function HasDoubleBond() {
		return OBMolAtomBFSIter_HasDoubleBond($this->_cPtr);
	}

	function HasAromaticBond() {
		return OBMolAtomBFSIter_HasAromaticBond($this->_cPtr);
	}

	function MatchesSMARTS($arg1) {
		return OBMolAtomBFSIter_MatchesSMARTS($this->_cPtr,$arg1);
	}

	function Clear() {
		return OBMolAtomBFSIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBMolAtomBFSIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBMolAtomBFSIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBMolAtomBFSIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBMolAtomBFSIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBMolAtomBFSIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBMolAtomBFSIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBMolAtomBFSIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBMolAtomBFSIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBMolAtomBFSIter_GetData($this->_cPtr); break;
		default: $r=OBMolAtomBFSIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBMolAtomBFSIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBMolAtomBFSIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBMolAtomBFSIter_EndData($this->_cPtr);
	}
}

class OBMolBondBFSIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBMolBondBFSIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBMolBondBFSIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBMolBondBFSIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ai=null,$StartIndex=0) {
		if (is_resource($mol_or_ai) && get_resource_type($mol_or_ai) === '_p_OpenBabel__OBMolBondBFSIter') {
			$this->_cPtr=$mol_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolBondBFSIter(); break;
		default: $this->_cPtr=new_OBMolBondBFSIter($mol_or_ai,$StartIndex);
		}
	}

	function __deref__() {
		$r=OBMolBondBFSIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBMolBondBFSIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function CurrentDepth() {
		return OBMolBondBFSIter_CurrentDepth($this->_cPtr);
	}

	function SetIdx($idx) {
		OBMolBondBFSIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBMolBondBFSIter_SetId($this->_cPtr,$id);
	}

	function SetBondOrder($order) {
		OBMolBondBFSIter_SetBondOrder($this->_cPtr,$order);
	}

	function SetBegin($begin) {
		OBMolBondBFSIter_SetBegin($this->_cPtr,$begin);
	}

	function SetEnd($end) {
		OBMolBondBFSIter_SetEnd($this->_cPtr,$end);
	}

	function SetParent($ptr) {
		OBMolBondBFSIter_SetParent($this->_cPtr,$ptr);
	}

	function SetLength($fixed_or_length,$length=null) {
		switch (func_num_args()) {
		case 1: OBMolBondBFSIter_SetLength($this->_cPtr,$fixed_or_length); break;
		default: OBMolBondBFSIter_SetLength($this->_cPtr,$fixed_or_length,$length);
		}
	}

	function Set($index,$begin,$end,$order,$flags) {
		OBMolBondBFSIter_Set($this->_cPtr,$index,$begin,$end,$order,$flags);
	}

	function SetAromatic($value=true) {
		OBMolBondBFSIter_SetAromatic($this->_cPtr,$value);
	}

	function SetWedge($value=true) {
		OBMolBondBFSIter_SetWedge($this->_cPtr,$value);
	}

	function SetHash($value=true) {
		OBMolBondBFSIter_SetHash($this->_cPtr,$value);
	}

	function SetWedgeOrHash($value=true) {
		OBMolBondBFSIter_SetWedgeOrHash($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBMolBondBFSIter_SetInRing($this->_cPtr,$value);
	}

	function SetClosure($value=true) {
		OBMolBondBFSIter_SetClosure($this->_cPtr,$value);
	}

	function GetIdx() {
		return OBMolBondBFSIter_GetIdx($this->_cPtr);
	}

	function GetId() {
		return OBMolBondBFSIter_GetId($this->_cPtr);
	}

	function GetBondOrder() {
		return OBMolBondBFSIter_GetBondOrder($this->_cPtr);
	}

	function GetFlags() {
		return OBMolBondBFSIter_GetFlags($this->_cPtr);
	}

	function GetBeginAtomIdx() {
		return OBMolBondBFSIter_GetBeginAtomIdx($this->_cPtr);
	}

	function GetEndAtomIdx() {
		return OBMolBondBFSIter_GetEndAtomIdx($this->_cPtr);
	}

	function GetBeginAtom() {
		$r=OBMolBondBFSIter_GetBeginAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetEndAtom() {
		$r=OBMolBondBFSIter_GetEndAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetNbrAtom($ptr) {
		$r=OBMolBondBFSIter_GetNbrAtom($this->_cPtr,$ptr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBMolBondBFSIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetEquibLength() {
		return OBMolBondBFSIter_GetEquibLength($this->_cPtr);
	}

	function GetLength() {
		return OBMolBondBFSIter_GetLength($this->_cPtr);
	}

	function GetNbrAtomIdx($ptr) {
		return OBMolBondBFSIter_GetNbrAtomIdx($this->_cPtr,$ptr);
	}

	function FindSmallestRing() {
		$r=OBMolBondBFSIter_FindSmallestRing($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function IsAromatic() {
		return OBMolBondBFSIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBMolBondBFSIter_IsInRing($this->_cPtr);
	}

	function IsRotor($includeRingBonds=false) {
		return OBMolBondBFSIter_IsRotor($this->_cPtr,$includeRingBonds);
	}

	function IsAmide() {
		return OBMolBondBFSIter_IsAmide($this->_cPtr);
	}

	function IsPrimaryAmide() {
		return OBMolBondBFSIter_IsPrimaryAmide($this->_cPtr);
	}

	function IsSecondaryAmide() {
		return OBMolBondBFSIter_IsSecondaryAmide($this->_cPtr);
	}

	function IsTertiaryAmide() {
		return OBMolBondBFSIter_IsTertiaryAmide($this->_cPtr);
	}

	function IsEster() {
		return OBMolBondBFSIter_IsEster($this->_cPtr);
	}

	function IsCarbonyl() {
		return OBMolBondBFSIter_IsCarbonyl($this->_cPtr);
	}

	function IsClosure() {
		return OBMolBondBFSIter_IsClosure($this->_cPtr);
	}

	function IsWedge() {
		return OBMolBondBFSIter_IsWedge($this->_cPtr);
	}

	function IsHash() {
		return OBMolBondBFSIter_IsHash($this->_cPtr);
	}

	function IsWedgeOrHash() {
		return OBMolBondBFSIter_IsWedgeOrHash($this->_cPtr);
	}

	function IsCisOrTrans() {
		return OBMolBondBFSIter_IsCisOrTrans($this->_cPtr);
	}

	function IsDoubleBondGeometry() {
		return OBMolBondBFSIter_IsDoubleBondGeometry($this->_cPtr);
	}

	function Clear() {
		return OBMolBondBFSIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBMolBondBFSIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBMolBondBFSIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBMolBondBFSIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBMolBondBFSIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBMolBondBFSIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBMolBondBFSIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBMolBondBFSIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBMolBondBFSIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBMolBondBFSIter_GetData($this->_cPtr); break;
		default: $r=OBMolBondBFSIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBMolBondBFSIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBMolBondBFSIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBMolBondBFSIter_EndData($this->_cPtr);
	}
}

class OBMolBondIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBMolBondIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBMolBondIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBMolBondIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_bi=null) {
		if (is_resource($mol_or_bi) && get_resource_type($mol_or_bi) === '_p_OpenBabel__OBMolBondIter') {
			$this->_cPtr=$mol_or_bi;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolBondIter(); break;
		default: $this->_cPtr=new_OBMolBondIter($mol_or_bi);
		}
	}

	function __deref__() {
		$r=OBMolBondIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBMolBondIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function SetIdx($idx) {
		OBMolBondIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBMolBondIter_SetId($this->_cPtr,$id);
	}

	function SetBondOrder($order) {
		OBMolBondIter_SetBondOrder($this->_cPtr,$order);
	}

	function SetBegin($begin) {
		OBMolBondIter_SetBegin($this->_cPtr,$begin);
	}

	function SetEnd($end) {
		OBMolBondIter_SetEnd($this->_cPtr,$end);
	}

	function SetParent($ptr) {
		OBMolBondIter_SetParent($this->_cPtr,$ptr);
	}

	function SetLength($fixed_or_length,$length=null) {
		switch (func_num_args()) {
		case 1: OBMolBondIter_SetLength($this->_cPtr,$fixed_or_length); break;
		default: OBMolBondIter_SetLength($this->_cPtr,$fixed_or_length,$length);
		}
	}

	function Set($index,$begin,$end,$order,$flags) {
		OBMolBondIter_Set($this->_cPtr,$index,$begin,$end,$order,$flags);
	}

	function SetAromatic($value=true) {
		OBMolBondIter_SetAromatic($this->_cPtr,$value);
	}

	function SetWedge($value=true) {
		OBMolBondIter_SetWedge($this->_cPtr,$value);
	}

	function SetHash($value=true) {
		OBMolBondIter_SetHash($this->_cPtr,$value);
	}

	function SetWedgeOrHash($value=true) {
		OBMolBondIter_SetWedgeOrHash($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBMolBondIter_SetInRing($this->_cPtr,$value);
	}

	function SetClosure($value=true) {
		OBMolBondIter_SetClosure($this->_cPtr,$value);
	}

	function GetIdx() {
		return OBMolBondIter_GetIdx($this->_cPtr);
	}

	function GetId() {
		return OBMolBondIter_GetId($this->_cPtr);
	}

	function GetBondOrder() {
		return OBMolBondIter_GetBondOrder($this->_cPtr);
	}

	function GetFlags() {
		return OBMolBondIter_GetFlags($this->_cPtr);
	}

	function GetBeginAtomIdx() {
		return OBMolBondIter_GetBeginAtomIdx($this->_cPtr);
	}

	function GetEndAtomIdx() {
		return OBMolBondIter_GetEndAtomIdx($this->_cPtr);
	}

	function GetBeginAtom() {
		$r=OBMolBondIter_GetBeginAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetEndAtom() {
		$r=OBMolBondIter_GetEndAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetNbrAtom($ptr) {
		$r=OBMolBondIter_GetNbrAtom($this->_cPtr,$ptr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBMolBondIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetEquibLength() {
		return OBMolBondIter_GetEquibLength($this->_cPtr);
	}

	function GetLength() {
		return OBMolBondIter_GetLength($this->_cPtr);
	}

	function GetNbrAtomIdx($ptr) {
		return OBMolBondIter_GetNbrAtomIdx($this->_cPtr,$ptr);
	}

	function FindSmallestRing() {
		$r=OBMolBondIter_FindSmallestRing($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function IsAromatic() {
		return OBMolBondIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBMolBondIter_IsInRing($this->_cPtr);
	}

	function IsRotor($includeRingBonds=false) {
		return OBMolBondIter_IsRotor($this->_cPtr,$includeRingBonds);
	}

	function IsAmide() {
		return OBMolBondIter_IsAmide($this->_cPtr);
	}

	function IsPrimaryAmide() {
		return OBMolBondIter_IsPrimaryAmide($this->_cPtr);
	}

	function IsSecondaryAmide() {
		return OBMolBondIter_IsSecondaryAmide($this->_cPtr);
	}

	function IsTertiaryAmide() {
		return OBMolBondIter_IsTertiaryAmide($this->_cPtr);
	}

	function IsEster() {
		return OBMolBondIter_IsEster($this->_cPtr);
	}

	function IsCarbonyl() {
		return OBMolBondIter_IsCarbonyl($this->_cPtr);
	}

	function IsClosure() {
		return OBMolBondIter_IsClosure($this->_cPtr);
	}

	function IsWedge() {
		return OBMolBondIter_IsWedge($this->_cPtr);
	}

	function IsHash() {
		return OBMolBondIter_IsHash($this->_cPtr);
	}

	function IsWedgeOrHash() {
		return OBMolBondIter_IsWedgeOrHash($this->_cPtr);
	}

	function IsCisOrTrans() {
		return OBMolBondIter_IsCisOrTrans($this->_cPtr);
	}

	function IsDoubleBondGeometry() {
		return OBMolBondIter_IsDoubleBondGeometry($this->_cPtr);
	}

	function Clear() {
		return OBMolBondIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBMolBondIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBMolBondIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBMolBondIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBMolBondIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBMolBondIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBMolBondIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBMolBondIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBMolBondIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBMolBondIter_GetData($this->_cPtr); break;
		default: $r=OBMolBondIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBMolBondIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBMolBondIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBMolBondIter_EndData($this->_cPtr);
	}
}

class OBAtomAtomIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBAtomAtomIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBAtomAtomIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBAtomAtomIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($atm_or_ai=null) {
		if (is_resource($atm_or_ai) && get_resource_type($atm_or_ai) === '_p_OpenBabel__OBAtomAtomIter') {
			$this->_cPtr=$atm_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBAtomAtomIter(); break;
		default: $this->_cPtr=new_OBAtomAtomIter($atm_or_ai);
		}
	}

	function __deref__() {
		$r=OBAtomAtomIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBAtomAtomIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function Duplicate($arg1) {
		OBAtomAtomIter_Duplicate($this->_cPtr,$arg1);
	}

	function SetIdx($idx) {
		OBAtomAtomIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBAtomAtomIter_SetId($this->_cPtr,$id);
	}

	function SetHyb($hyb) {
		OBAtomAtomIter_SetHyb($this->_cPtr,$hyb);
	}

	function SetAtomicNum($atomicnum) {
		OBAtomAtomIter_SetAtomicNum($this->_cPtr,$atomicnum);
	}

	function SetIsotope($iso) {
		OBAtomAtomIter_SetIsotope($this->_cPtr,$iso);
	}

	function SetImplicitHCount($val) {
		OBAtomAtomIter_SetImplicitHCount($this->_cPtr,$val);
	}

	function SetFormalCharge($fcharge) {
		OBAtomAtomIter_SetFormalCharge($this->_cPtr,$fcharge);
	}

	function SetSpinMultiplicity($spin) {
		OBAtomAtomIter_SetSpinMultiplicity($this->_cPtr,$spin);
	}

	function SetType($type) {
		OBAtomAtomIter_SetType($this->_cPtr,$type);
	}

	function SetPartialCharge($pcharge) {
		OBAtomAtomIter_SetPartialCharge($this->_cPtr,$pcharge);
	}

	function SetVector($v_or_x=null,$y=null,$z=null) {
		switch (func_num_args()) {
		case 0: OBAtomAtomIter_SetVector($this->_cPtr); break;
		case 1: OBAtomAtomIter_SetVector($this->_cPtr,$v_or_x); break;
		case 2: OBAtomAtomIter_SetVector($this->_cPtr,$v_or_x,$y); break;
		default: OBAtomAtomIter_SetVector($this->_cPtr,$v_or_x,$y,$z);
		}
	}

	function SetCoordPtr($c_) {
		OBAtomAtomIter_SetCoordPtr($this->_cPtr,$c_);
	}

	function SetResidue($res) {
		OBAtomAtomIter_SetResidue($this->_cPtr,$res);
	}

	function SetParent($ptr) {
		OBAtomAtomIter_SetParent($this->_cPtr,$ptr);
	}

	function SetAromatic($value=true) {
		OBAtomAtomIter_SetAromatic($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBAtomAtomIter_SetInRing($this->_cPtr,$value);
	}

	function ClearCoordPtr() {
		OBAtomAtomIter_ClearCoordPtr($this->_cPtr);
	}

	function GetFormalCharge() {
		return OBAtomAtomIter_GetFormalCharge($this->_cPtr);
	}

	function GetAtomicNum() {
		return OBAtomAtomIter_GetAtomicNum($this->_cPtr);
	}

	function GetIsotope() {
		return OBAtomAtomIter_GetIsotope($this->_cPtr);
	}

	function GetSpinMultiplicity() {
		return OBAtomAtomIter_GetSpinMultiplicity($this->_cPtr);
	}

	function GetAtomicMass() {
		return OBAtomAtomIter_GetAtomicMass($this->_cPtr);
	}

	function GetExactMass() {
		return OBAtomAtomIter_GetExactMass($this->_cPtr);
	}

	function GetIdx() {
		return OBAtomAtomIter_GetIdx($this->_cPtr);
	}

	function GetIndex() {
		return OBAtomAtomIter_GetIndex($this->_cPtr);
	}

	function GetId() {
		return OBAtomAtomIter_GetId($this->_cPtr);
	}

	function GetCoordinateIdx() {
		return OBAtomAtomIter_GetCoordinateIdx($this->_cPtr);
	}

	function GetExplicitDegree() {
		return OBAtomAtomIter_GetExplicitDegree($this->_cPtr);
	}

	function GetTotalDegree() {
		return OBAtomAtomIter_GetTotalDegree($this->_cPtr);
	}

	function GetExplicitValence() {
		return OBAtomAtomIter_GetExplicitValence($this->_cPtr);
	}

	function GetTotalValence() {
		return OBAtomAtomIter_GetTotalValence($this->_cPtr);
	}

	function GetHyb() {
		return OBAtomAtomIter_GetHyb($this->_cPtr);
	}

	function GetImplicitHCount() {
		return OBAtomAtomIter_GetImplicitHCount($this->_cPtr);
	}

	function GetHvyDegree() {
		return OBAtomAtomIter_GetHvyDegree($this->_cPtr);
	}

	function GetHeteroDegree() {
		return OBAtomAtomIter_GetHeteroDegree($this->_cPtr);
	}

	function GetType() {
		return OBAtomAtomIter_GetType($this->_cPtr);
	}

	function GetX() {
		return OBAtomAtomIter_GetX($this->_cPtr);
	}

	function GetY() {
		return OBAtomAtomIter_GetY($this->_cPtr);
	}

	function GetZ() {
		return OBAtomAtomIter_GetZ($this->_cPtr);
	}

	function x() {
		return OBAtomAtomIter_x($this->_cPtr);
	}

	function y() {
		return OBAtomAtomIter_y($this->_cPtr);
	}

	function z() {
		return OBAtomAtomIter_z($this->_cPtr);
	}

	function GetCoordinate() {
		return OBAtomAtomIter_GetCoordinate($this->_cPtr);
	}

	function GetVector() {
		$r=OBAtomAtomIter_GetVector($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function GetPartialCharge() {
		return OBAtomAtomIter_GetPartialCharge($this->_cPtr);
	}

	function GetResidue() {
		$r=OBAtomAtomIter_GetResidue($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBAtomAtomIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetNewBondVector($v,$length) {
		return OBAtomAtomIter_GetNewBondVector($this->_cPtr,$v,$length);
	}

	function GetBond($arg1) {
		$r=OBAtomAtomIter_GetBond($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginBonds() {
		return OBAtomAtomIter_BeginBonds($this->_cPtr);
	}

	function EndBonds() {
		return OBAtomAtomIter_EndBonds($this->_cPtr);
	}

	function BeginBond($i) {
		$r=OBAtomAtomIter_BeginBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function NextBond($i) {
		$r=OBAtomAtomIter_NextBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginNbrAtom($i) {
		$r=OBAtomAtomIter_BeginNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextNbrAtom($i) {
		$r=OBAtomAtomIter_NextNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetDistance($index_or_v) {
		return OBAtomAtomIter_GetDistance($this->_cPtr,$index_or_v);
	}

	function GetAngle($b,$c_) {
		return OBAtomAtomIter_GetAngle($this->_cPtr,$b,$c_);
	}

	function NewResidue() {
		OBAtomAtomIter_NewResidue($this->_cPtr);
	}

	function AddResidue($res) {
		OBAtomAtomIter_AddResidue($this->_cPtr,$res);
	}

	function DeleteResidue() {
		OBAtomAtomIter_DeleteResidue($this->_cPtr);
	}

	function AddBond($bond) {
		OBAtomAtomIter_AddBond($this->_cPtr,$bond);
	}

	function InsertBond($i,$bond) {
		OBAtomAtomIter_InsertBond($this->_cPtr,$i,$bond);
	}

	function DeleteBond($bond) {
		return OBAtomAtomIter_DeleteBond($this->_cPtr,$bond);
	}

	function ClearBond() {
		OBAtomAtomIter_ClearBond($this->_cPtr);
	}

	function HtoMethyl() {
		return OBAtomAtomIter_HtoMethyl($this->_cPtr);
	}

	function SetHybAndGeom($arg1) {
		return OBAtomAtomIter_SetHybAndGeom($this->_cPtr,$arg1);
	}

	function CountFreeOxygens() {
		return OBAtomAtomIter_CountFreeOxygens($this->_cPtr);
	}

	function CountFreeSulfurs() {
		return OBAtomAtomIter_CountFreeSulfurs($this->_cPtr);
	}

	function ExplicitHydrogenCount($ExcludeIsotopes=false) {
		return OBAtomAtomIter_ExplicitHydrogenCount($this->_cPtr,$ExcludeIsotopes);
	}

	function MemberOfRingCount() {
		return OBAtomAtomIter_MemberOfRingCount($this->_cPtr);
	}

	function MemberOfRingSize() {
		return OBAtomAtomIter_MemberOfRingSize($this->_cPtr);
	}

	function CountRingBonds() {
		return OBAtomAtomIter_CountRingBonds($this->_cPtr);
	}

	function SmallestBondAngle() {
		return OBAtomAtomIter_SmallestBondAngle($this->_cPtr);
	}

	function AverageBondAngle() {
		return OBAtomAtomIter_AverageBondAngle($this->_cPtr);
	}

	function LewisAcidBaseCounts() {
		return OBAtomAtomIter_LewisAcidBaseCounts($this->_cPtr);
	}

	function HasResidue() {
		return OBAtomAtomIter_HasResidue($this->_cPtr);
	}

	function IsHetAtom() {
		return OBAtomAtomIter_IsHetAtom($this->_cPtr);
	}

	function IsAromatic() {
		return OBAtomAtomIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBAtomAtomIter_IsInRing($this->_cPtr);
	}

	function IsInRingSize($arg1) {
		return OBAtomAtomIter_IsInRingSize($this->_cPtr,$arg1);
	}

	function IsHeteroatom() {
		return OBAtomAtomIter_IsHeteroatom($this->_cPtr);
	}

	function IsConnected($arg1) {
		return OBAtomAtomIter_IsConnected($this->_cPtr,$arg1);
	}

	function IsOneThree($arg1) {
		return OBAtomAtomIter_IsOneThree($this->_cPtr,$arg1);
	}

	function IsOneFour($arg1) {
		return OBAtomAtomIter_IsOneFour($this->_cPtr,$arg1);
	}

	function IsCarboxylOxygen() {
		return OBAtomAtomIter_IsCarboxylOxygen($this->_cPtr);
	}

	function IsPhosphateOxygen() {
		return OBAtomAtomIter_IsPhosphateOxygen($this->_cPtr);
	}

	function IsSulfateOxygen() {
		return OBAtomAtomIter_IsSulfateOxygen($this->_cPtr);
	}

	function IsNitroOxygen() {
		return OBAtomAtomIter_IsNitroOxygen($this->_cPtr);
	}

	function IsAmideNitrogen() {
		return OBAtomAtomIter_IsAmideNitrogen($this->_cPtr);
	}

	function IsPolarHydrogen() {
		return OBAtomAtomIter_IsPolarHydrogen($this->_cPtr);
	}

	function IsNonPolarHydrogen() {
		return OBAtomAtomIter_IsNonPolarHydrogen($this->_cPtr);
	}

	function IsAromaticNOxide() {
		return OBAtomAtomIter_IsAromaticNOxide($this->_cPtr);
	}

	function IsChiral() {
		return OBAtomAtomIter_IsChiral($this->_cPtr);
	}

	function IsAxial() {
		return OBAtomAtomIter_IsAxial($this->_cPtr);
	}

	function IsHbondAcceptor() {
		return OBAtomAtomIter_IsHbondAcceptor($this->_cPtr);
	}

	function IsHbondAcceptorSimple() {
		return OBAtomAtomIter_IsHbondAcceptorSimple($this->_cPtr);
	}

	function IsHbondDonor() {
		return OBAtomAtomIter_IsHbondDonor($this->_cPtr);
	}

	function IsHbondDonorH() {
		return OBAtomAtomIter_IsHbondDonorH($this->_cPtr);
	}

	function IsMetal() {
		return OBAtomAtomIter_IsMetal($this->_cPtr);
	}

	function HasAlphaBetaUnsat($includePandS=true) {
		return OBAtomAtomIter_HasAlphaBetaUnsat($this->_cPtr,$includePandS);
	}

	function HasBondOfOrder($bo) {
		return OBAtomAtomIter_HasBondOfOrder($this->_cPtr,$bo);
	}

	function CountBondsOfOrder($bo) {
		return OBAtomAtomIter_CountBondsOfOrder($this->_cPtr,$bo);
	}

	function HighestBondOrder() {
		return OBAtomAtomIter_HighestBondOrder($this->_cPtr);
	}

	function HasNonSingleBond() {
		return OBAtomAtomIter_HasNonSingleBond($this->_cPtr);
	}

	function HasSingleBond() {
		return OBAtomAtomIter_HasSingleBond($this->_cPtr);
	}

	function HasDoubleBond() {
		return OBAtomAtomIter_HasDoubleBond($this->_cPtr);
	}

	function HasAromaticBond() {
		return OBAtomAtomIter_HasAromaticBond($this->_cPtr);
	}

	function MatchesSMARTS($arg1) {
		return OBAtomAtomIter_MatchesSMARTS($this->_cPtr,$arg1);
	}

	function Clear() {
		return OBAtomAtomIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBAtomAtomIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBAtomAtomIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBAtomAtomIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBAtomAtomIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBAtomAtomIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBAtomAtomIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBAtomAtomIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBAtomAtomIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBAtomAtomIter_GetData($this->_cPtr); break;
		default: $r=OBAtomAtomIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBAtomAtomIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBAtomAtomIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBAtomAtomIter_EndData($this->_cPtr);
	}
}

class OBAtomBondIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBAtomBondIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBAtomBondIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBAtomBondIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($atm_or_bi=null) {
		if (is_resource($atm_or_bi) && get_resource_type($atm_or_bi) === '_p_OpenBabel__OBAtomBondIter') {
			$this->_cPtr=$atm_or_bi;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBAtomBondIter(); break;
		default: $this->_cPtr=new_OBAtomBondIter($atm_or_bi);
		}
	}

	function __deref__() {
		$r=OBAtomBondIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBAtomBondIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function SetIdx($idx) {
		OBAtomBondIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBAtomBondIter_SetId($this->_cPtr,$id);
	}

	function SetBondOrder($order) {
		OBAtomBondIter_SetBondOrder($this->_cPtr,$order);
	}

	function SetBegin($begin) {
		OBAtomBondIter_SetBegin($this->_cPtr,$begin);
	}

	function SetEnd($end) {
		OBAtomBondIter_SetEnd($this->_cPtr,$end);
	}

	function SetParent($ptr) {
		OBAtomBondIter_SetParent($this->_cPtr,$ptr);
	}

	function SetLength($fixed_or_length,$length=null) {
		switch (func_num_args()) {
		case 1: OBAtomBondIter_SetLength($this->_cPtr,$fixed_or_length); break;
		default: OBAtomBondIter_SetLength($this->_cPtr,$fixed_or_length,$length);
		}
	}

	function Set($index,$begin,$end,$order,$flags) {
		OBAtomBondIter_Set($this->_cPtr,$index,$begin,$end,$order,$flags);
	}

	function SetAromatic($value=true) {
		OBAtomBondIter_SetAromatic($this->_cPtr,$value);
	}

	function SetWedge($value=true) {
		OBAtomBondIter_SetWedge($this->_cPtr,$value);
	}

	function SetHash($value=true) {
		OBAtomBondIter_SetHash($this->_cPtr,$value);
	}

	function SetWedgeOrHash($value=true) {
		OBAtomBondIter_SetWedgeOrHash($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBAtomBondIter_SetInRing($this->_cPtr,$value);
	}

	function SetClosure($value=true) {
		OBAtomBondIter_SetClosure($this->_cPtr,$value);
	}

	function GetIdx() {
		return OBAtomBondIter_GetIdx($this->_cPtr);
	}

	function GetId() {
		return OBAtomBondIter_GetId($this->_cPtr);
	}

	function GetBondOrder() {
		return OBAtomBondIter_GetBondOrder($this->_cPtr);
	}

	function GetFlags() {
		return OBAtomBondIter_GetFlags($this->_cPtr);
	}

	function GetBeginAtomIdx() {
		return OBAtomBondIter_GetBeginAtomIdx($this->_cPtr);
	}

	function GetEndAtomIdx() {
		return OBAtomBondIter_GetEndAtomIdx($this->_cPtr);
	}

	function GetBeginAtom() {
		$r=OBAtomBondIter_GetBeginAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetEndAtom() {
		$r=OBAtomBondIter_GetEndAtom($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new OBAtom($r);
	}

	function GetNbrAtom($ptr) {
		$r=OBAtomBondIter_GetNbrAtom($this->_cPtr,$ptr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBAtomBondIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetEquibLength() {
		return OBAtomBondIter_GetEquibLength($this->_cPtr);
	}

	function GetLength() {
		return OBAtomBondIter_GetLength($this->_cPtr);
	}

	function GetNbrAtomIdx($ptr) {
		return OBAtomBondIter_GetNbrAtomIdx($this->_cPtr,$ptr);
	}

	function FindSmallestRing() {
		$r=OBAtomBondIter_FindSmallestRing($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function IsAromatic() {
		return OBAtomBondIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBAtomBondIter_IsInRing($this->_cPtr);
	}

	function IsRotor($includeRingBonds=false) {
		return OBAtomBondIter_IsRotor($this->_cPtr,$includeRingBonds);
	}

	function IsAmide() {
		return OBAtomBondIter_IsAmide($this->_cPtr);
	}

	function IsPrimaryAmide() {
		return OBAtomBondIter_IsPrimaryAmide($this->_cPtr);
	}

	function IsSecondaryAmide() {
		return OBAtomBondIter_IsSecondaryAmide($this->_cPtr);
	}

	function IsTertiaryAmide() {
		return OBAtomBondIter_IsTertiaryAmide($this->_cPtr);
	}

	function IsEster() {
		return OBAtomBondIter_IsEster($this->_cPtr);
	}

	function IsCarbonyl() {
		return OBAtomBondIter_IsCarbonyl($this->_cPtr);
	}

	function IsClosure() {
		return OBAtomBondIter_IsClosure($this->_cPtr);
	}

	function IsWedge() {
		return OBAtomBondIter_IsWedge($this->_cPtr);
	}

	function IsHash() {
		return OBAtomBondIter_IsHash($this->_cPtr);
	}

	function IsWedgeOrHash() {
		return OBAtomBondIter_IsWedgeOrHash($this->_cPtr);
	}

	function IsCisOrTrans() {
		return OBAtomBondIter_IsCisOrTrans($this->_cPtr);
	}

	function IsDoubleBondGeometry() {
		return OBAtomBondIter_IsDoubleBondGeometry($this->_cPtr);
	}

	function Clear() {
		return OBAtomBondIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBAtomBondIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBAtomBondIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBAtomBondIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBAtomBondIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBAtomBondIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBAtomBondIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBAtomBondIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBAtomBondIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBAtomBondIter_GetData($this->_cPtr); break;
		default: $r=OBAtomBondIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBAtomBondIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBAtomBondIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBAtomBondIter_EndData($this->_cPtr);
	}
}

class OBResidueIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ri=null) {
		if (is_resource($mol_or_ri) && get_resource_type($mol_or_ri) === '_p_OpenBabel__OBResidueIter') {
			$this->_cPtr=$mol_or_ri;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBResidueIter(); break;
		default: $this->_cPtr=new_OBResidueIter($mol_or_ri);
		}
	}

	function __deref__() {
		$r=OBResidueIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBResidueIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function AddAtom($atom) {
		OBResidueIter_AddAtom($this->_cPtr,$atom);
	}

	function InsertAtom($atom) {
		OBResidueIter_InsertAtom($this->_cPtr,$atom);
	}

	function RemoveAtom($atom) {
		OBResidueIter_RemoveAtom($this->_cPtr,$atom);
	}

	function SetName($resname) {
		OBResidueIter_SetName($this->_cPtr,$resname);
	}

	function SetNum($resnum) {
		OBResidueIter_SetNum($this->_cPtr,$resnum);
	}

	function SetChain($chain) {
		OBResidueIter_SetChain($this->_cPtr,$chain);
	}

	function SetChainNum($chainnum) {
		OBResidueIter_SetChainNum($this->_cPtr,$chainnum);
	}

	function SetIdx($idx) {
		OBResidueIter_SetIdx($this->_cPtr,$idx);
	}

	function SetInsertionCode($insertioncode) {
		OBResidueIter_SetInsertionCode($this->_cPtr,$insertioncode);
	}

	function SetAtomID($atom,$id) {
		OBResidueIter_SetAtomID($this->_cPtr,$atom,$id);
	}

	function SetHetAtom($atom,$hetatm) {
		OBResidueIter_SetHetAtom($this->_cPtr,$atom,$hetatm);
	}

	function SetSerialNum($atom,$sernum) {
		OBResidueIter_SetSerialNum($this->_cPtr,$atom,$sernum);
	}

	function GetName() {
		return OBResidueIter_GetName($this->_cPtr);
	}

	function GetNum() {
		return OBResidueIter_GetNum($this->_cPtr);
	}

	function GetNumString() {
		return OBResidueIter_GetNumString($this->_cPtr);
	}

	function GetNumAtoms() {
		return OBResidueIter_GetNumAtoms($this->_cPtr);
	}

	function GetChain() {
		return OBResidueIter_GetChain($this->_cPtr);
	}

	function GetChainNum() {
		return OBResidueIter_GetChainNum($this->_cPtr);
	}

	function GetIdx() {
		return OBResidueIter_GetIdx($this->_cPtr);
	}

	function GetResKey() {
		return OBResidueIter_GetResKey($this->_cPtr);
	}

	function GetAtoms() {
		return OBResidueIter_GetAtoms($this->_cPtr);
	}

	function GetBonds($exterior=true) {
		return OBResidueIter_GetBonds($this->_cPtr,$exterior);
	}

	function GetAtomID($atom) {
		return OBResidueIter_GetAtomID($this->_cPtr,$atom);
	}

	function GetSerialNum($atom) {
		return OBResidueIter_GetSerialNum($this->_cPtr,$atom);
	}

	function GetInsertionCode() {
		return OBResidueIter_GetInsertionCode($this->_cPtr);
	}

	function GetAminoAcidProperty($arg1) {
		return OBResidueIter_GetAminoAcidProperty($this->_cPtr,$arg1);
	}

	function GetAtomProperty($a,$arg2) {
		return OBResidueIter_GetAtomProperty($this->_cPtr,$a,$arg2);
	}

	function GetResidueProperty($arg1) {
		return OBResidueIter_GetResidueProperty($this->_cPtr,$arg1);
	}

	function IsHetAtom($atom) {
		return OBResidueIter_IsHetAtom($this->_cPtr,$atom);
	}

	function IsResidueType($arg1) {
		return OBResidueIter_IsResidueType($this->_cPtr,$arg1);
	}

	function BeginAtoms() {
		return OBResidueIter_BeginAtoms($this->_cPtr);
	}

	function EndAtoms() {
		return OBResidueIter_EndAtoms($this->_cPtr);
	}

	function BeginAtom($i) {
		$r=OBResidueIter_BeginAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextAtom($i) {
		$r=OBResidueIter_NextAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function Clear() {
		return OBResidueIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBResidueIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBResidueIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBResidueIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBResidueIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBResidueIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBResidueIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBResidueIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBResidueIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBResidueIter_GetData($this->_cPtr); break;
		default: $r=OBResidueIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBResidueIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBResidueIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBResidueIter_EndData($this->_cPtr);
	}
}

class OBResidueAtomIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'Visit') return OBResidueAtomIter_Visit_set($this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'Visit') return OBResidueAtomIter_Visit_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBResidueAtomIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($res_or_ri=null) {
		if (is_resource($res_or_ri) && get_resource_type($res_or_ri) === '_p_OpenBabel__OBResidueAtomIter') {
			$this->_cPtr=$res_or_ri;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBResidueAtomIter(); break;
		default: $this->_cPtr=new_OBResidueAtomIter($res_or_ri);
		}
	}

	function __deref__() {
		$r=OBResidueAtomIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBResidueAtomIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function Duplicate($arg1) {
		OBResidueAtomIter_Duplicate($this->_cPtr,$arg1);
	}

	function SetIdx($idx) {
		OBResidueAtomIter_SetIdx($this->_cPtr,$idx);
	}

	function SetId($id) {
		OBResidueAtomIter_SetId($this->_cPtr,$id);
	}

	function SetHyb($hyb) {
		OBResidueAtomIter_SetHyb($this->_cPtr,$hyb);
	}

	function SetAtomicNum($atomicnum) {
		OBResidueAtomIter_SetAtomicNum($this->_cPtr,$atomicnum);
	}

	function SetIsotope($iso) {
		OBResidueAtomIter_SetIsotope($this->_cPtr,$iso);
	}

	function SetImplicitHCount($val) {
		OBResidueAtomIter_SetImplicitHCount($this->_cPtr,$val);
	}

	function SetFormalCharge($fcharge) {
		OBResidueAtomIter_SetFormalCharge($this->_cPtr,$fcharge);
	}

	function SetSpinMultiplicity($spin) {
		OBResidueAtomIter_SetSpinMultiplicity($this->_cPtr,$spin);
	}

	function SetType($type) {
		OBResidueAtomIter_SetType($this->_cPtr,$type);
	}

	function SetPartialCharge($pcharge) {
		OBResidueAtomIter_SetPartialCharge($this->_cPtr,$pcharge);
	}

	function SetVector($v_or_x=null,$y=null,$z=null) {
		switch (func_num_args()) {
		case 0: OBResidueAtomIter_SetVector($this->_cPtr); break;
		case 1: OBResidueAtomIter_SetVector($this->_cPtr,$v_or_x); break;
		case 2: OBResidueAtomIter_SetVector($this->_cPtr,$v_or_x,$y); break;
		default: OBResidueAtomIter_SetVector($this->_cPtr,$v_or_x,$y,$z);
		}
	}

	function SetCoordPtr($c_) {
		OBResidueAtomIter_SetCoordPtr($this->_cPtr,$c_);
	}

	function SetResidue($res) {
		OBResidueAtomIter_SetResidue($this->_cPtr,$res);
	}

	function SetParent($ptr) {
		OBResidueAtomIter_SetParent($this->_cPtr,$ptr);
	}

	function SetAromatic($value=true) {
		OBResidueAtomIter_SetAromatic($this->_cPtr,$value);
	}

	function SetInRing($value=true) {
		OBResidueAtomIter_SetInRing($this->_cPtr,$value);
	}

	function ClearCoordPtr() {
		OBResidueAtomIter_ClearCoordPtr($this->_cPtr);
	}

	function GetFormalCharge() {
		return OBResidueAtomIter_GetFormalCharge($this->_cPtr);
	}

	function GetAtomicNum() {
		return OBResidueAtomIter_GetAtomicNum($this->_cPtr);
	}

	function GetIsotope() {
		return OBResidueAtomIter_GetIsotope($this->_cPtr);
	}

	function GetSpinMultiplicity() {
		return OBResidueAtomIter_GetSpinMultiplicity($this->_cPtr);
	}

	function GetAtomicMass() {
		return OBResidueAtomIter_GetAtomicMass($this->_cPtr);
	}

	function GetExactMass() {
		return OBResidueAtomIter_GetExactMass($this->_cPtr);
	}

	function GetIdx() {
		return OBResidueAtomIter_GetIdx($this->_cPtr);
	}

	function GetIndex() {
		return OBResidueAtomIter_GetIndex($this->_cPtr);
	}

	function GetId() {
		return OBResidueAtomIter_GetId($this->_cPtr);
	}

	function GetCoordinateIdx() {
		return OBResidueAtomIter_GetCoordinateIdx($this->_cPtr);
	}

	function GetExplicitDegree() {
		return OBResidueAtomIter_GetExplicitDegree($this->_cPtr);
	}

	function GetTotalDegree() {
		return OBResidueAtomIter_GetTotalDegree($this->_cPtr);
	}

	function GetExplicitValence() {
		return OBResidueAtomIter_GetExplicitValence($this->_cPtr);
	}

	function GetTotalValence() {
		return OBResidueAtomIter_GetTotalValence($this->_cPtr);
	}

	function GetHyb() {
		return OBResidueAtomIter_GetHyb($this->_cPtr);
	}

	function GetImplicitHCount() {
		return OBResidueAtomIter_GetImplicitHCount($this->_cPtr);
	}

	function GetHvyDegree() {
		return OBResidueAtomIter_GetHvyDegree($this->_cPtr);
	}

	function GetHeteroDegree() {
		return OBResidueAtomIter_GetHeteroDegree($this->_cPtr);
	}

	function GetType() {
		return OBResidueAtomIter_GetType($this->_cPtr);
	}

	function GetX() {
		return OBResidueAtomIter_GetX($this->_cPtr);
	}

	function GetY() {
		return OBResidueAtomIter_GetY($this->_cPtr);
	}

	function GetZ() {
		return OBResidueAtomIter_GetZ($this->_cPtr);
	}

	function x() {
		return OBResidueAtomIter_x($this->_cPtr);
	}

	function y() {
		return OBResidueAtomIter_y($this->_cPtr);
	}

	function z() {
		return OBResidueAtomIter_z($this->_cPtr);
	}

	function GetCoordinate() {
		return OBResidueAtomIter_GetCoordinate($this->_cPtr);
	}

	function GetVector() {
		$r=OBResidueAtomIter_GetVector($this->_cPtr);
		if (!is_resource($r)) return $r;
		return new vector3($r);
	}

	function GetPartialCharge() {
		return OBResidueAtomIter_GetPartialCharge($this->_cPtr);
	}

	function GetResidue() {
		$r=OBResidueAtomIter_GetResidue($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBResidue($r);
		}
		return $r;
	}

	function GetParent() {
		$r=OBResidueAtomIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function GetNewBondVector($v,$length) {
		return OBResidueAtomIter_GetNewBondVector($this->_cPtr,$v,$length);
	}

	function GetBond($arg1) {
		$r=OBResidueAtomIter_GetBond($this->_cPtr,$arg1);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginBonds() {
		return OBResidueAtomIter_BeginBonds($this->_cPtr);
	}

	function EndBonds() {
		return OBResidueAtomIter_EndBonds($this->_cPtr);
	}

	function BeginBond($i) {
		$r=OBResidueAtomIter_BeginBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function NextBond($i) {
		$r=OBResidueAtomIter_NextBond($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBond($r);
		}
		return $r;
	}

	function BeginNbrAtom($i) {
		$r=OBResidueAtomIter_BeginNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function NextNbrAtom($i) {
		$r=OBResidueAtomIter_NextNbrAtom($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBAtom($r);
		}
		return $r;
	}

	function GetDistance($index_or_v) {
		return OBResidueAtomIter_GetDistance($this->_cPtr,$index_or_v);
	}

	function GetAngle($b,$c_) {
		return OBResidueAtomIter_GetAngle($this->_cPtr,$b,$c_);
	}

	function NewResidue() {
		OBResidueAtomIter_NewResidue($this->_cPtr);
	}

	function AddResidue($res) {
		OBResidueAtomIter_AddResidue($this->_cPtr,$res);
	}

	function DeleteResidue() {
		OBResidueAtomIter_DeleteResidue($this->_cPtr);
	}

	function AddBond($bond) {
		OBResidueAtomIter_AddBond($this->_cPtr,$bond);
	}

	function InsertBond($i,$bond) {
		OBResidueAtomIter_InsertBond($this->_cPtr,$i,$bond);
	}

	function DeleteBond($bond) {
		return OBResidueAtomIter_DeleteBond($this->_cPtr,$bond);
	}

	function ClearBond() {
		OBResidueAtomIter_ClearBond($this->_cPtr);
	}

	function HtoMethyl() {
		return OBResidueAtomIter_HtoMethyl($this->_cPtr);
	}

	function SetHybAndGeom($arg1) {
		return OBResidueAtomIter_SetHybAndGeom($this->_cPtr,$arg1);
	}

	function CountFreeOxygens() {
		return OBResidueAtomIter_CountFreeOxygens($this->_cPtr);
	}

	function CountFreeSulfurs() {
		return OBResidueAtomIter_CountFreeSulfurs($this->_cPtr);
	}

	function ExplicitHydrogenCount($ExcludeIsotopes=false) {
		return OBResidueAtomIter_ExplicitHydrogenCount($this->_cPtr,$ExcludeIsotopes);
	}

	function MemberOfRingCount() {
		return OBResidueAtomIter_MemberOfRingCount($this->_cPtr);
	}

	function MemberOfRingSize() {
		return OBResidueAtomIter_MemberOfRingSize($this->_cPtr);
	}

	function CountRingBonds() {
		return OBResidueAtomIter_CountRingBonds($this->_cPtr);
	}

	function SmallestBondAngle() {
		return OBResidueAtomIter_SmallestBondAngle($this->_cPtr);
	}

	function AverageBondAngle() {
		return OBResidueAtomIter_AverageBondAngle($this->_cPtr);
	}

	function LewisAcidBaseCounts() {
		return OBResidueAtomIter_LewisAcidBaseCounts($this->_cPtr);
	}

	function HasResidue() {
		return OBResidueAtomIter_HasResidue($this->_cPtr);
	}

	function IsHetAtom() {
		return OBResidueAtomIter_IsHetAtom($this->_cPtr);
	}

	function IsAromatic() {
		return OBResidueAtomIter_IsAromatic($this->_cPtr);
	}

	function IsInRing() {
		return OBResidueAtomIter_IsInRing($this->_cPtr);
	}

	function IsInRingSize($arg1) {
		return OBResidueAtomIter_IsInRingSize($this->_cPtr,$arg1);
	}

	function IsHeteroatom() {
		return OBResidueAtomIter_IsHeteroatom($this->_cPtr);
	}

	function IsConnected($arg1) {
		return OBResidueAtomIter_IsConnected($this->_cPtr,$arg1);
	}

	function IsOneThree($arg1) {
		return OBResidueAtomIter_IsOneThree($this->_cPtr,$arg1);
	}

	function IsOneFour($arg1) {
		return OBResidueAtomIter_IsOneFour($this->_cPtr,$arg1);
	}

	function IsCarboxylOxygen() {
		return OBResidueAtomIter_IsCarboxylOxygen($this->_cPtr);
	}

	function IsPhosphateOxygen() {
		return OBResidueAtomIter_IsPhosphateOxygen($this->_cPtr);
	}

	function IsSulfateOxygen() {
		return OBResidueAtomIter_IsSulfateOxygen($this->_cPtr);
	}

	function IsNitroOxygen() {
		return OBResidueAtomIter_IsNitroOxygen($this->_cPtr);
	}

	function IsAmideNitrogen() {
		return OBResidueAtomIter_IsAmideNitrogen($this->_cPtr);
	}

	function IsPolarHydrogen() {
		return OBResidueAtomIter_IsPolarHydrogen($this->_cPtr);
	}

	function IsNonPolarHydrogen() {
		return OBResidueAtomIter_IsNonPolarHydrogen($this->_cPtr);
	}

	function IsAromaticNOxide() {
		return OBResidueAtomIter_IsAromaticNOxide($this->_cPtr);
	}

	function IsChiral() {
		return OBResidueAtomIter_IsChiral($this->_cPtr);
	}

	function IsAxial() {
		return OBResidueAtomIter_IsAxial($this->_cPtr);
	}

	function IsHbondAcceptor() {
		return OBResidueAtomIter_IsHbondAcceptor($this->_cPtr);
	}

	function IsHbondAcceptorSimple() {
		return OBResidueAtomIter_IsHbondAcceptorSimple($this->_cPtr);
	}

	function IsHbondDonor() {
		return OBResidueAtomIter_IsHbondDonor($this->_cPtr);
	}

	function IsHbondDonorH() {
		return OBResidueAtomIter_IsHbondDonorH($this->_cPtr);
	}

	function IsMetal() {
		return OBResidueAtomIter_IsMetal($this->_cPtr);
	}

	function HasAlphaBetaUnsat($includePandS=true) {
		return OBResidueAtomIter_HasAlphaBetaUnsat($this->_cPtr,$includePandS);
	}

	function HasBondOfOrder($bo) {
		return OBResidueAtomIter_HasBondOfOrder($this->_cPtr,$bo);
	}

	function CountBondsOfOrder($bo) {
		return OBResidueAtomIter_CountBondsOfOrder($this->_cPtr,$bo);
	}

	function HighestBondOrder() {
		return OBResidueAtomIter_HighestBondOrder($this->_cPtr);
	}

	function HasNonSingleBond() {
		return OBResidueAtomIter_HasNonSingleBond($this->_cPtr);
	}

	function HasSingleBond() {
		return OBResidueAtomIter_HasSingleBond($this->_cPtr);
	}

	function HasDoubleBond() {
		return OBResidueAtomIter_HasDoubleBond($this->_cPtr);
	}

	function HasAromaticBond() {
		return OBResidueAtomIter_HasAromaticBond($this->_cPtr);
	}

	function MatchesSMARTS($arg1) {
		return OBResidueAtomIter_MatchesSMARTS($this->_cPtr,$arg1);
	}

	function Clear() {
		return OBResidueAtomIter_Clear($this->_cPtr);
	}

	function DoTransformations($arg1,$arg2) {
		$r=OBResidueAtomIter_DoTransformations($this->_cPtr,$arg1,$arg2);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBBase($r);
		}
		return $r;
	}

	function ClassDescription() {
		return OBResidueAtomIter_ClassDescription($this->_cPtr);
	}

	function GetTitle($replaceNewlines=true) {
		return OBResidueAtomIter_GetTitle($this->_cPtr,$replaceNewlines);
	}

	function SetTitle($arg1) {
		OBResidueAtomIter_SetTitle($this->_cPtr,$arg1);
	}

	function HasData($type) {
		return OBResidueAtomIter_HasData($this->_cPtr,$type);
	}

	function DeleteData($type_or_s) {
		return OBResidueAtomIter_DeleteData($this->_cPtr,$type_or_s);
	}

	function CloneData($d) {
		OBResidueAtomIter_CloneData($this->_cPtr,$d);
	}

	function DataSize() {
		return OBResidueAtomIter_DataSize($this->_cPtr);
	}

	function GetData($type_or_source=null) {
		switch (func_num_args()) {
		case 0: $r=OBResidueAtomIter_GetData($this->_cPtr); break;
		default: $r=OBResidueAtomIter_GetData($this->_cPtr,$type_or_source);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case '_p_std__vectorT_OpenBabel__OBGenericData_p_t': return new vectorpOBGenericData($r);
		default: return new OBGenericData($r);
		}
	}

	function GetAllData($type) {
		$r=OBResidueAtomIter_GetAllData($this->_cPtr,$type);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorpOBGenericData($r);
		}
		return $r;
	}

	function BeginData() {
		return OBResidueAtomIter_BeginData($this->_cPtr);
	}

	function EndData() {
		return OBResidueAtomIter_EndData($this->_cPtr);
	}
}

class OBMolAngleIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ai=null) {
		if (is_resource($mol_or_ai) && get_resource_type($mol_or_ai) === '_p_OpenBabel__OBMolAngleIter') {
			$this->_cPtr=$mol_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolAngleIter(); break;
		default: $this->_cPtr=new_OBMolAngleIter($mol_or_ai);
		}
	}

	function __ref__() {
		$r=OBMolAngleIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorUnsignedInt($r);
		}
		return $r;
	}
}

class OBMolTorsionIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ai=null) {
		if (is_resource($mol_or_ai) && get_resource_type($mol_or_ai) === '_p_OpenBabel__OBMolTorsionIter') {
			$this->_cPtr=$mol_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolTorsionIter(); break;
		default: $this->_cPtr=new_OBMolTorsionIter($mol_or_ai);
		}
	}

	function __ref__() {
		$r=OBMolTorsionIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorUnsignedInt($r);
		}
		return $r;
	}
}

class OBMolPairIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ai=null) {
		if (is_resource($mol_or_ai) && get_resource_type($mol_or_ai) === '_p_OpenBabel__OBMolPairIter') {
			$this->_cPtr=$mol_or_ai;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolPairIter(); break;
		default: $this->_cPtr=new_OBMolPairIter($mol_or_ai);
		}
	}

	function __ref__() {
		$r=OBMolPairIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new vectorUnsignedInt($r);
		}
		return $r;
	}
}

class OBMolRingIter {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'OBMolRingIter_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_openbabel_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __get($var) {
		if ($var === '_path') return new vectorInt(OBMolRingIter__path_get($this->_cPtr));
		if ($var === '_pathset') return new OBBitVec(OBMolRingIter__pathset_get($this->_cPtr));
		if ($var === 'ring_id') return OBMolRingIter_ring_id_get($this->_cPtr);
		if ($var === 'thisown') return swig_openbabel_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	function __isset($var) {
		if (function_exists('OBMolRingIter_'.$var.'_get')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __construct($mol_or_ri=null) {
		if (is_resource($mol_or_ri) && get_resource_type($mol_or_ri) === '_p_OpenBabel__OBMolRingIter') {
			$this->_cPtr=$mol_or_ri;
			return;
		}
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_OBMolRingIter(); break;
		default: $this->_cPtr=new_OBMolRingIter($mol_or_ri);
		}
	}

	function __deref__() {
		$r=OBMolRingIter___deref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function __ref__() {
		$r=OBMolRingIter___ref__($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBRing($r);
		}
		return $r;
	}

	function Size() {
		return OBMolRingIter_Size($this->_cPtr);
	}

	function PathSize() {
		return OBMolRingIter_PathSize($this->_cPtr);
	}

	function IsAromatic() {
		return OBMolRingIter_IsAromatic($this->_cPtr);
	}

	function SetType($type) {
		OBMolRingIter_SetType($this->_cPtr,$type);
	}

	function GetType() {
		return OBMolRingIter_GetType($this->_cPtr);
	}

	function GetRootAtom() {
		return OBMolRingIter_GetRootAtom($this->_cPtr);
	}

	function IsMember($a_or_b) {
		return OBMolRingIter_IsMember($this->_cPtr,$a_or_b);
	}

	function IsInRing($i) {
		return OBMolRingIter_IsInRing($this->_cPtr,$i);
	}

	function SetParent($m) {
		OBMolRingIter_SetParent($this->_cPtr,$m);
	}

	function GetParent() {
		$r=OBMolRingIter_GetParent($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (class_exists($c)) return new $c($r);
			return new OBMol($r);
		}
		return $r;
	}

	function findCenterAndNormal($center,$norm1,$norm2) {
		return OBMolRingIter_findCenterAndNormal($this->_cPtr,$center,$norm1,$norm2);
	}
}


?>
