IDLMODULE_MAJOR   = 2
IDLMODULE_MINOR   = 0
IDLMODULE_VERSION = 0x2420# => CORBA 2.4, front-end 2.0
version=2.0.0

.ifdef PYTHON_1
DIR_CXXNAMEQUAL=/NAMES=UPPERCASE
PYTHON_1_NAME=PYTHON_1
.endif

DIR_CXXMACROS = IDLMODULE_VERSION=""""$(IDLMODULE_VERSION)""""\
	OMNIIDL_EXECUTABLE\
	YY_ALWAYS_INTERACTIVE\
	USE_IDLERROR\
	PYTHON_INCLUDE=""""<Python.h>""""\
	$(PYTHON_1_NAME)

DIR_CXXNOWARN=CODEUNREACHABLE

.IFDEF ALPHA
DIR_ALPHA_CXXLINKFLAGS=/sysexe
.ELSE
DIR_VAX_CXXLINKFLAGS=,SYS$SYSTEM:SYS.STB/selective
.ENDIF
DIR_CXXLINKFLAGS = $(DIR_ALPHA_CXXLINKFLAGS)$(DIR_VAX_CXXLINKFLAGS)/map/full\
/prelink=use_olb
DIR_CXXINCLUDES = PYTHON_INCLUDE:

#SUBDIRS = cccp

all ::
	@ $(MakeSubdirs)

export ::
	@ $(MakeSubdirs)

MAINOBJ = $(CONFIG_DIR_V)idlpython.obj
$(MAINOBJ) : idlpython.cc
	$(VERBOSITY) $(CXXCompile)

#############################################################################
#   Make rules for OpenVMS                                                  #
#############################################################################

# Only static linking is currently supported.

libname = _omniidlmodule
staticlib = $(CONFIG_DIR_V)$(libname).olb

OBJ_LIBS = $(staticlib)
OBJ_LIBS_DEPEND = $(staticlib)

omniidl=omniidl$(CONFIG_SUFFIX).exe

all :: $(omniidl)

# MMS/DEFINE=file.mms ignores .ifdef statements and erroneously complains about
# macro redefinitions.

.ifdef ALPHA
CORBAFLOAT_Alpha_OBJS = CorbaIEEEFloat.obj
.endif

CORBAFLOAT_VAX_OBJS = CorbaDFloat.obj CorbaGFloat.obj

CORBAFLOAT_OBJS = $(CORBAFLOAT_VAX_OBJS) $(CORBAFLOAT_Alpha_OBJS)

lex_yy_obj=lex_yy.obj
y_tab_obj=y_tab.obj

CXXSRCS = idlast.cc-
	idlc.cc-
	idlconfig.cc-
	idldump.cc-
	idlerr.cc-
	idlexpr.cc-
	idlfixed.cc-
	idlpython.cc-
	idlrepoId.cc-
	idlscope.cc-
	idltype.cc-
	idlutil.cc-
	idlvalidate.cc-
	lex.yy.cc-
	y.tab.cc

OBJS = $(foreach o,idlerr.obj\
	idlutil.obj\
	idltype.obj\
	idlrepoId.obj\
	idlscope.obj\
	idlexpr.obj\
	idlast.obj\
	idlvalidate.obj\
	idldump.obj\
	idlconfig.obj\
	idlfixed.obj\
	$(CORBAFLOAT_OBJS),$(CONFIG_DIR_V)$(o) )

all :: $(idlc)

$(omniidl) : $(MAINOBJ) $(staticlib)
	$(CXXExecutable)\
	sys$disk:[-]python_$(PYTHON_MAJOR)$(CONFIG_SUFFIX).opt/opt $(staticlib)/lib

export :: $(omniidl)
	@ $(ExportExecutable)

DFILES=$(subst .obj,.d,$(OBJS) $(MAINOBJ)) lex.yy.d y.tab.d

clean ::
	$(RM) $(staticlib)

#clean ::
#	$(RM) $(foreach w,1 2 3 4 5 6 7,$(word $(w),$(DFILES)) )
#	$(RM) $(foreach w,8 9 10 11 12 13 14,$(word $(w),$(DFILES)) )
#	$(RM) $(foreach w,15 16 17 18 19 20 21,$(word $(w),$(DFILES)) )

#veryclean ::
#	$(RM) $(foreach w,1 2 3 4 5 6 7,$(word $(w),$(DFILES)) )
#	$(RM) $(foreach w,8 9 10 11 12 13 14,$(word $(w),$(DFILES)) )
#	$(RM) $(foreach w,15 16 17 18 19 20 21,$(word $(w),$(DFILES)) )

#############################################################################
#   Test executable                                                         #
#############################################################################

$(idlc) : $(CONFIG_DIR_V)idlc.obj $(OBJS) $(CONFIG_DIR_V)lex_yy.obj $(CONFIG_DIR_V)y_tab.obj
	@ $(CXXExecutable) $(staticlib)/lib

$(CONFIG_DIR_V)corbaDFloat.obj : [---.lib.omniORB.orbcore]corbaDFloat.cc
	$(CxxCompile) "/Float=D_Float"

$(CONFIG_DIR_V)corbaGFloat.obj : [---.lib.omniORB.orbcore]corbaGFloat.cc
	$(CxxCompile) "/Float=G_Float"

$(CONFIG_DIR_V)corbaIEEEFloat.obj : [---.lib.omniORB.orbcore]corbaIEEEFloat.cc
	$(CxxCompile) "/Float=IEEE_Float"

$(staticlib) : $(OBJS) $(CONFIG_DIR_V)lex_yy.obj $(CONFIG_DIR_V)y_tab.obj
	if f$search("$(staticlib)").eqs."" then lib/create/log $(staticlib)
	if f$search("$(CONFIG_DIR_V)*.OBJ").nes."" then lib/replace/log $(staticlib) $(CONFIG_DIR_V)*.obj

$(CONFIG_DIR_V)lex_yy.obj : lex.yy.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)y_tab.obj : y.tab.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlerr.obj	: idlerr.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlutil.obj	: idlutil.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idltype.obj	: idltype.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlrepoId.obj	: idlrepoId.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlscope.obj	: idlscope.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlexpr.obj	: idlexpr.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlast.obj	: idlast.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlvalidate.obj	: idlvalidate.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idldump.obj	: idldump.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlconfig.obj	: idlconfig.cc
	$(VERBOSITY) $(CXXCompile)

$(CONFIG_DIR_V)idlfixed.obj	: idlfixed.cc
	$(VERBOSITY) $(CXXCompile)

show ::
	! DIR_CXXFLAGS=$(DIR_CXXFLAGS)
	! DIR_CXXNAMEQUAL=$(DIR_CXXNAMEQUAL)
	! CXXExecutable=$(CXXExecutable)
	! DFILES=$(DFILES)
	! $(RM) $(foreach w,1 2 3 4 5 6 7,$(word $(w),$(DFILES)) )
	! $(RM) $(foreach w,8 9 10 11 12 13 14,$(word $(w),$(DFILES)) )
	! $(RM) $(foreach w,15 16 17 18 19 20 21,$(word $(w),$(DFILES)) )
	! $(dir_initialized)
