/************************************************************************/
/*                                                                      */
/*                Copyright 2011 by Ullrich Koethe                      */
/*                                                                      */
/*    This file is part of the VIGRA computer vision library.           */
/*    The VIGRA Website is                                              */
/*        http://hci.iwr.uni-heidelberg.de/vigra/                       */
/*    Please direct questions, bug reports, and contributions to        */
/*        ullrich.koethe@iwr.uni-heidelberg.de    or                    */
/*        vigra@informatik.uni-hamburg.de                               */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */
/*                                                                      */
/************************************************************************/

#ifndef VIGRA_UNSUPERVISED_TEST_DATA_HXX
#define VIGRA_UNSUPERVISED_TEST_DATA_HXX


double plsaData[1024*159] = {
12., 2., 4., 14., 24., 7., 40., 0., 14., 153., 6., 35., 231., 5., 11., 6., 1., 5., 70., 1., 18., 272., 48., 345., 33., 9., 2., 0., 7., 2., 50., 35., 223., 43., 9., 155., 12., 32., 3., 0., 1., 14., 7., 72., 27., 86., 13., 30., 43., 16., 3., 0., 14., 5., 43., 2., 44., 8., 30., 7., 12., 6., 0., 0., 0., 0., 34., 3., 18., 5., 29., 9., 11., 4., 0., 6., 3., 0., 1., 2., 11., 2., 15., 1., 11., 0., 0., 5., 122., 7., 1902., 86., 107., 248., 118., 105., 74., 13., 10., 19., 12., 2., 1., 7., 10., 4., 12., 7., 27., 9., 31., 13., 38., 8., 8., 4., 6., 9., 4., 3., 2., 3., 7., 4., 0., 6., 3., 13., 1., 0., 11., 3., 3., 0., 6., 3., 8., 30., 3., 9., 4., 14., 4., 26., 4., 3., 8., 5., 23., 7., 41., 5., 3., 12., 7., 38., 9., 22., 5.,

13., 1., 3., 5., 36., 8., 24., 2., 13., 169., 3., 30., 202., 6., 24., 3., 1., 2., 70., 0., 14., 308., 50., 316., 39., 18., 1., 0., 8., 5., 36., 32., 232., 36., 6., 161., 15., 39., 6., 0., 3., 17., 9., 66., 19., 88., 9., 33., 50., 8., 2., 2., 31., 5., 38., 12., 46., 10., 27., 4., 18., 8., 3., 0., 2., 0., 24., 3., 17., 0., 27., 8., 20., 4., 0., 1., 1., 1., 0., 4., 14., 2., 7., 1., 3., 1., 1., 3., 130., 5., 1930., 80., 105., 200., 118., 127., 64., 12., 12., 19., 12., 3., 2., 9., 7., 6., 9., 3., 33., 18., 41., 22., 40., 4., 10., 2., 2., 9., 7., 1., 4., 1., 5., 5., 0., 2., 9., 21., 1., 0., 11., 5., 7., 0., 7., 6., 3., 31., 4., 14., 5., 21., 4., 20., 3., 4., 5., 1., 29., 3., 27., 5., 5., 7., 4., 38., 7., 15., 5.,

9., 3., 4., 8., 27., 4., 32., 1., 13., 163., 0., 35., 176., 6., 12., 3., 5., 5., 78., 0., 21., 260., 48., 303., 38., 15., 1., 2., 7., 7., 43., 33., 238., 36., 9., 163., 13., 31., 1., 0., 4., 26., 9., 79., 18., 81., 15., 34., 38., 12., 3., 1., 28., 5., 27., 15., 56., 9., 35., 4., 8., 8., 3., 0., 1., 0., 25., 4., 12., 3., 35., 3., 8., 3., 0., 2., 2., 2., 2., 1., 10., 5., 16., 5., 10., 1., 0., 6., 139., 7., 1813., 76., 103., 223., 102., 116., 59., 17., 11., 21., 8., 0., 1., 5., 5., 3., 15., 10., 33., 19., 29., 15., 32., 9., 11., 4., 7., 8., 3., 2., 6., 1., 6., 0., 0., 2., 4., 17., 0., 0., 9., 7., 6., 0., 3., 5., 3., 33., 3., 5., 2., 10., 4., 26., 0., 0., 4., 3., 28., 4., 28., 6., 3., 3., 12., 32., 6., 15., 5.,

13., 3., 5., 7., 31., 4., 38., 1., 14., 159., 4., 30., 181., 2., 18., 6., 1., 4., 78., 4., 15., 297., 38., 284., 31., 18., 0., 0., 6., 5., 46., 28., 235., 41., 12., 157., 19., 47., 3., 0., 2., 16., 4., 92., 13., 88., 16., 28., 48., 5., 5., 5., 26., 5., 40., 12., 58., 8., 28., 2., 10., 4., 3., 0., 1., 0., 14., 7., 13., 0., 32., 4., 14., 6., 3., 4., 2., 1., 2., 2., 11., 3., 9., 3., 9., 0., 2., 5., 160., 13., 1942., 112., 86., 230., 93., 118., 61., 17., 10., 18., 12., 1., 4., 4., 5., 3., 13., 7., 37., 21., 38., 15., 39., 6., 4., 4., 4., 7., 9., 2., 1., 6., 6., 7., 0., 1., 4., 10., 4., 0., 11., 3., 1., 0., 4., 2., 3., 21., 4., 14., 3., 6., 1., 20., 4., 2., 4., 3., 26., 5., 38., 9., 2., 6., 4., 27., 7., 6., 7.,

10., 0., 4., 5., 28., 7., 32., 2., 11., 159., 5., 29., 200., 2., 17., 9., 0., 8., 62., 8., 24., 322., 42., 328., 55., 13., 2., 1., 8., 4., 37., 30., 253., 43., 9., 172., 12., 26., 6., 0., 2., 24., 11., 91., 18., 105., 13., 34., 40., 24., 3., 1., 26., 8., 34., 10., 47., 10., 32., 5., 8., 7., 5., 0., 0., 0., 19., 3., 16., 6., 30., 5., 11., 3., 2., 7., 0., 2., 2., 5., 10., 3., 4., 4., 7., 3., 1., 9., 144., 11., 1896., 107., 117., 222., 89., 99., 68., 11., 10., 9., 16., 0., 1., 9., 5., 3., 9., 9., 30., 14., 44., 18., 42., 6., 10., 3., 8., 9., 2., 2., 4., 0., 7., 1., 0., 7., 5., 12., 1., 0., 7., 5., 4., 0., 7., 1., 7., 32., 3., 14., 2., 10., 4., 17., 5., 3., 2., 7., 22., 7., 41., 8., 2., 9., 9., 23., 8., 17., 4.,

13., 1., 3., 8., 24., 7., 24., 1., 20., 163., 4., 24., 210., 3., 8., 7., 0., 6., 73., 1., 13., 304., 53., 296., 38., 25., 0., 3., 7., 4., 45., 38., 230., 29., 6., 152., 14., 59., 6., 0., 2., 11., 9., 78., 11., 104., 10., 29., 57., 20., 7., 1., 27., 8., 28., 6., 35., 8., 24., 10., 8., 11., 1., 0., 0., 0., 23., 8., 16., 4., 35., 3., 10., 4., 2., 7., 0., 2., 5., 5., 14., 3., 6., 3., 6., 0., 0., 7., 135., 8., 1842., 96., 96., 222., 101., 106., 79., 16., 12., 23., 11., 1., 1., 6., 9., 10., 10., 9., 36., 15., 37., 17., 41., 5., 9., 4., 4., 12., 5., 0., 1., 4., 8., 5., 0., 2., 9., 12., 2., 0., 13., 3., 5., 0., 9., 7., 3., 26., 6., 15., 3., 14., 4., 20., 4., 3., 2., 6., 25., 4., 37., 6., 5., 5., 8., 26., 7., 14., 3.,

10., 2., 2., 6., 26., 4., 35., 1., 12., 177., 5., 26., 194., 3., 12., 10., 0., 9., 79., 3., 18., 302., 51., 304., 40., 22., 0., 2., 9., 4., 35., 32., 233., 41., 6., 155., 14., 36., 6., 0., 2., 18., 5., 89., 18., 102., 10., 28., 43., 7., 4., 2., 23., 6., 36., 12., 45., 5., 34., 12., 7., 12., 4., 0., 0., 0., 23., 5., 15., 5., 30., 3., 11., 5., 2., 5., 1., 2., 3., 1., 7., 4., 10., 3., 14., 3., 0., 6., 137., 10., 1802., 102., 94., 256., 93., 123., 52., 12., 12., 23., 16., 2., 5., 5., 3., 4., 12., 6., 31., 17., 26., 10., 50., 12., 8., 0., 9., 6., 4., 1., 1., 2., 8., 2., 0., 5., 4., 20., 5., 0., 5., 2., 5., 0., 6., 5., 3., 33., 3., 14., 2., 25., 1., 20., 4., 4., 1., 9., 30., 0., 28., 10., 4., 4., 1., 26., 5., 12., 3.,

20., 3., 2., 8., 25., 8., 33., 1., 22., 157., 5., 29., 208., 5., 13., 7., 0., 5., 85., 2., 15., 318., 49., 335., 49., 23., 1., 4., 5., 3., 40., 37., 248., 33., 10., 146., 17., 40., 7., 0., 1., 10., 4., 93., 17., 110., 23., 24., 44., 12., 1., 0., 24., 9., 40., 9., 54., 10., 29., 11., 15., 9., 3., 0., 1., 0., 20., 8., 15., 2., 27., 8., 9., 8., 2., 1., 1., 0., 2., 3., 5., 0., 15., 1., 7., 0., 1., 3., 129., 8., 1856., 89., 117., 226., 108., 109., 68., 11., 12., 23., 10., 0., 1., 7., 5., 0., 6., 6., 38., 15., 31., 8., 41., 6., 13., 6., 5., 6., 5., 0., 5., 2., 10., 3., 0., 4., 4., 18., 2., 0., 9., 4., 1., 0., 5., 7., 2., 36., 2., 9., 2., 15., 2., 19., 2., 2., 6., 6., 27., 5., 27., 8., 6., 8., 8., 31., 6., 12., 3.,

15., 4., 0., 9., 20., 3., 30., 1., 11., 146., 4., 35., 199., 6., 19., 6., 1., 7., 78., 1., 15., 308., 40., 345., 44., 15., 2., 2., 6., 2., 41., 24., 233., 42., 7., 161., 6., 35., 10., 0., 1., 23., 7., 70., 28., 84., 5., 38., 45., 20., 2., 1., 26., 9., 25., 7., 44., 5., 20., 5., 9., 7., 2., 0., 1., 0., 21., 2., 15., 5., 21., 2., 11., 7., 1., 6., 0., 1., 1., 3., 13., 2., 11., 0., 7., 1., 0., 4., 138., 6., 1833., 98., 98., 233., 107., 115., 67., 20., 8., 21., 9., 0., 2., 4., 7., 2., 7., 9., 28., 16., 32., 18., 29., 7., 6., 4., 7., 6., 4., 1., 0., 1., 5., 4., 0., 6., 2., 16., 1., 0., 9., 3., 2., 0., 6., 3., 3., 32., 7., 9., 5., 16., 2., 27., 6., 4., 5., 4., 29., 4., 35., 3., 6., 8., 7., 19., 8., 17., 1.,

19., 1., 3., 3., 24., 3., 30., 0., 17., 163., 8., 27., 227., 3., 15., 6., 2., 6., 78., 0., 13., 268., 40., 324., 39., 17., 3., 2., 8., 7., 47., 38., 225., 40., 4., 166., 10., 48., 5., 0., 4., 10., 10., 72., 22., 79., 22., 40., 45., 12., 2., 2., 17., 4., 45., 8., 40., 9., 32., 6., 17., 5., 1., 0., 0., 0., 34., 2., 14., 0., 26., 2., 15., 6., 2., 2., 1., 2., 5., 3., 13., 3., 6., 1., 10., 1., 0., 6., 139., 9., 1919., 100., 88., 241., 99., 110., 72., 15., 14., 15., 8., 0., 2., 9., 10., 3., 7., 12., 23., 11., 39., 23., 42., 6., 5., 3., 8., 5., 9., 1., 0., 2., 14., 2., 0., 3., 5., 14., 0., 0., 7., 6., 6., 0., 8., 2., 4., 39., 4., 8., 4., 10., 4., 21., 3., 0., 5., 7., 20., 6., 28., 3., 3., 7., 3., 32., 5., 8., 3.,

7., 1., 6., 9., 18., 11., 35., 2., 10., 126., 2., 27., 197., 4., 14., 5., 2., 5., 92., 1., 16., 270., 44., 310., 42., 19., 0., 1., 4., 4., 34., 32., 270., 37., 7., 160., 16., 46., 3., 0., 3., 18., 6., 73., 20., 73., 15., 36., 33., 6., 5., 0., 24., 5., 31., 14., 51., 10., 40., 7., 12., 7., 1., 0., 3., 0., 17., 4., 13., 2., 25., 5., 9., 2., 4., 2., 0., 0., 2., 2., 5., 1., 10., 1., 10., 1., 2., 4., 145., 8., 1808., 102., 113., 210., 95., 107., 63., 10., 15., 10., 8., 2., 2., 7., 4., 5., 6., 4., 44., 16., 43., 18., 47., 7., 16., 4., 3., 5., 6., 2., 5., 6., 5., 5., 0., 6., 2., 15., 3., 0., 8., 6., 3., 0., 8., 1., 0., 24., 4., 8., 8., 12., 1., 23., 3., 4., 4., 6., 22., 7., 41., 8., 3., 10., 5., 33., 10., 11., 5.,

16., 1., 3., 7., 8., 6., 28., 1., 8., 171., 3., 29., 206., 3., 18., 4., 2., 4., 84., 3., 16., 305., 47., 305., 45., 22., 1., 1., 8., 5., 53., 28., 223., 53., 11., 146., 7., 37., 6., 0., 2., 14., 5., 78., 22., 88., 11., 30., 40., 12., 2., 0., 20., 7., 39., 12., 31., 6., 31., 6., 9., 5., 2., 0., 0., 0., 17., 10., 17., 5., 24., 3., 8., 5., 1., 5., 2., 0., 3., 3., 9., 4., 8., 0., 12., 1., 1., 2., 169., 4., 1900., 98., 111., 215., 99., 91., 64., 19., 10., 19., 8., 1., 0., 5., 7., 2., 6., 7., 32., 13., 29., 22., 42., 7., 7., 3., 6., 6., 3., 3., 1., 3., 5., 2., 0., 3., 4., 11., 1., 0., 8., 5., 3., 0., 5., 5., 3., 27., 2., 11., 3., 14., 4., 27., 6., 3., 3., 6., 21., 4., 25., 8., 5., 6., 2., 30., 6., 7., 4.,

14., 3., 4., 4., 26., 5., 32., 0., 26., 153., 3., 17., 190., 5., 13., 7., 4., 6., 68., 4., 18., 292., 54., 344., 35., 16., 1., 2., 10., 3., 38., 43., 249., 39., 10., 152., 18., 37., 4., 0., 2., 13., 5., 81., 21., 84., 15., 47., 42., 7., 2., 2., 24., 6., 32., 10., 44., 15., 24., 9., 8., 8., 1., 0., 1., 0., 30., 8., 10., 4., 33., 2., 13., 6., 3., 2., 0., 2., 5., 1., 6., 6., 8., 0., 6., 1., 0., 1., 134., 5., 1787., 98., 98., 235., 98., 130., 67., 13., 12., 16., 10., 1., 2., 4., 7., 4., 11., 2., 47., 19., 29., 20., 39., 8., 7., 6., 2., 12., 3., 4., 2., 3., 11., 7., 0., 6., 7., 20., 2., 0., 12., 1., 2., 0., 7., 4., 1., 36., 4., 11., 1., 10., 2., 25., 1., 4., 6., 6., 29., 3., 36., 6., 6., 6., 6., 33., 5., 10., 6.,

11., 3., 3., 7., 24., 5., 27., 1., 17., 141., 1., 21., 198., 6., 14., 7., 0., 8., 81., 1., 8., 301., 47., 300., 42., 21., 2., 1., 11., 5., 51., 30., 215., 45., 4., 151., 15., 43., 3., 0., 1., 18., 8., 81., 22., 76., 8., 33., 62., 19., 0., 2., 28., 7., 34., 12., 53., 6., 31., 12., 14., 8., 2., 0., 2., 0., 17., 4., 20., 5., 27., 5., 11., 4., 5., 4., 0., 3., 0., 1., 10., 3., 4., 3., 10., 0., 0., 5., 131., 10., 1839., 90., 97., 202., 106., 128., 60., 25., 12., 25., 12., 0., 3., 2., 6., 4., 9., 10., 41., 19., 43., 13., 35., 5., 10., 4., 4., 4., 10., 2., 1., 4., 8., 1., 0., 5., 5., 13., 1., 0., 12., 4., 1., 0., 10., 2., 0., 32., 5., 17., 2., 10., 1., 14., 4., 5., 6., 8., 27., 5., 29., 8., 3., 7., 6., 30., 6., 14., 1.,

10., 2., 4., 15., 21., 10., 26., 1., 14., 154., 2., 17., 179., 4., 16., 11., 3., 5., 75., 3., 17., 282., 33., 275., 44., 22., 1., 1., 4., 3., 49., 33., 261., 43., 5., 163., 14., 50., 6., 0., 3., 23., 5., 81., 14., 69., 13., 45., 35., 7., 5., 2., 26., 7., 32., 8., 39., 10., 40., 8., 8., 3., 2., 0., 2., 0., 15., 7., 19., 6., 30., 3., 13., 3., 1., 2., 1., 1., 1., 1., 13., 1., 10., 1., 5., 1., 0., 6., 153., 7., 1929., 98., 114., 218., 112., 115., 73., 18., 19., 23., 6., 1., 2., 4., 2., 1., 13., 7., 38., 22., 39., 14., 32., 11., 12., 4., 7., 9., 5., 0., 7., 2., 6., 1., 0., 5., 3., 17., 1., 0., 7., 4., 2., 0., 3., 1., 0., 28., 2., 9., 1., 13., 2., 17., 2., 2., 4., 4., 24., 2., 35., 3., 4., 6., 5., 32., 7., 14., 4.,

12., 2., 4., 9., 30., 4., 34., 0., 16., 159., 4., 40., 196., 6., 18., 6., 1., 6., 69., 3., 14., 295., 41., 353., 52., 16., 1., 5., 9., 5., 41., 27., 234., 47., 2., 147., 10., 40., 10., 0., 3., 22., 9., 72., 29., 101., 18., 40., 27., 10., 7., 1., 19., 5., 34., 11., 59., 12., 26., 7., 8., 5., 3., 0., 1., 0., 27., 5., 15., 3., 31., 7., 14., 2., 2., 2., 0., 1., 2., 3., 8., 2., 7., 1., 7., 2., 0., 3., 118., 11., 1952., 87., 92., 213., 110., 104., 73., 13., 19., 15., 11., 1., 2., 3., 2., 3., 11., 8., 41., 11., 34., 13., 45., 6., 9., 9., 4., 7., 5., 1., 6., 2., 5., 5., 0., 5., 5., 15., 3., 0., 10., 5., 1., 0., 3., 3., 1., 34., 5., 12., 2., 14., 2., 19., 2., 5., 8., 3., 36., 3., 28., 5., 7., 7., 5., 38., 5., 22., 8.,

13., 3., 4., 6., 24., 6., 37., 3., 19., 189., 6., 30., 182., 3., 18., 7., 1., 3., 93., 3., 15., 322., 41., 332., 37., 16., 1., 1., 6., 4., 37., 34., 231., 37., 5., 170., 15., 42., 6., 0., 2., 25., 7., 81., 20., 81., 18., 18., 43., 9., 3., 0., 26., 2., 34., 7., 47., 7., 35., 5., 13., 2., 0., 0., 0., 0., 18., 6., 13., 5., 24., 8., 9., 9., 0., 3., 2., 1., 7., 2., 12., 5., 11., 3., 10., 2., 2., 3., 144., 5., 1829., 86., 86., 251., 90., 112., 60., 20., 11., 18., 12., 0., 2., 6., 9., 2., 7., 6., 37., 24., 35., 16., 44., 4., 6., 5., 7., 7., 9., 0., 2., 1., 6., 5., 0., 4., 8., 14., 2., 0., 12., 6., 4., 0., 2., 2., 4., 42., 4., 8., 3., 13., 1., 24., 5., 2., 2., 6., 30., 5., 30., 12., 2., 4., 5., 27., 4., 9., 5.,

9., 1., 3., 9., 29., 5., 27., 2., 22., 164., 4., 34., 227., 4., 14., 5., 0., 4., 66., 0., 16., 294., 56., 351., 33., 21., 1., 3., 7., 2., 34., 31., 224., 37., 8., 175., 7., 30., 8., 0., 1., 18., 9., 85., 15., 82., 9., 35., 52., 10., 2., 0., 28., 8., 43., 8., 48., 10., 47., 5., 11., 1., 6., 0., 3., 0., 22., 2., 10., 2., 29., 2., 6., 6., 1., 3., 2., 2., 3., 3., 12., 2., 9., 1., 9., 2., 1., 5., 142., 6., 1903., 90., 119., 217., 94., 122., 80., 18., 5., 17., 23., 0., 3., 9., 10., 3., 8., 11., 43., 25., 36., 17., 39., 8., 9., 4., 5., 10., 5., 0., 2., 3., 11., 2., 0., 4., 7., 15., 2., 0., 8., 5., 4., 0., 4., 3., 4., 25., 5., 18., 3., 11., 4., 21., 2., 5., 5., 4., 18., 6., 27., 8., 6., 2., 5., 31., 5., 14., 7.,

13., 2., 1., 9., 28., 9., 19., 3., 14., 154., 1., 33., 187., 3., 15., 7., 1., 7., 98., 2., 24., 298., 51., 344., 39., 21., 2., 0., 8., 4., 39., 30., 235., 44., 7., 149., 14., 40., 6., 0., 2., 17., 6., 90., 15., 75., 12., 27., 45., 18., 4., 1., 16., 9., 46., 8., 27., 8., 24., 8., 7., 6., 2., 0., 2., 0., 20., 2., 15., 1., 31., 4., 8., 2., 0., 3., 0., 1., 4., 1., 9., 3., 12., 1., 7., 2., 4., 3., 129., 10., 1955., 91., 95., 212., 102., 118., 78., 19., 10., 22., 11., 0., 0., 9., 6., 4., 7., 7., 33., 15., 37., 11., 39., 7., 16., 1., 7., 7., 5., 2., 1., 1., 12., 9., 0., 7., 9., 12., 1., 0., 6., 3., 3., 0., 6., 5., 6., 29., 1., 10., 2., 18., 0., 20., 4., 5., 2., 3., 31., 4., 27., 7., 6., 10., 7., 32., 13., 16., 10.,

9., 3., 4., 7., 35., 2., 31., 2., 18., 155., 5., 25., 206., 6., 22., 11., 2., 7., 79., 1., 20., 314., 42., 335., 46., 17., 2., 5., 11., 6., 47., 42., 212., 38., 5., 153., 17., 32., 10., 0., 1., 19., 8., 83., 12., 76., 13., 33., 44., 10., 3., 1., 21., 6., 27., 13., 40., 10., 23., 3., 12., 5., 3., 0., 1., 0., 27., 9., 14., 4., 28., 1., 10., 2., 1., 4., 1., 0., 3., 3., 7., 3., 10., 0., 12., 1., 0., 2., 139., 9., 1988., 99., 111., 223., 98., 115., 84., 13., 17., 14., 8., 2., 2., 6., 9., 8., 9., 12., 32., 18., 37., 13., 44., 12., 15., 1., 3., 8., 8., 2., 1., 3., 9., 4., 0., 1., 7., 15., 1., 0., 8., 5., 5., 0., 8., 4., 2., 35., 2., 10., 6., 18., 1., 25., 3., 5., 3., 2., 29., 4., 32., 5., 6., 4., 5., 33., 2., 16., 3.,

7., 1., 4., 5., 31., 5., 39., 1., 14., 172., 0., 24., 215., 3., 12., 7., 1., 3., 92., 2., 14., 287., 41., 332., 44., 25., 1., 0., 5., 9., 44., 40., 202., 50., 3., 150., 10., 39., 6., 0., 3., 20., 12., 69., 13., 82., 18., 23., 54., 9., 4., 0., 22., 6., 27., 13., 57., 5., 25., 5., 9., 7., 4., 0., 0., 0., 33., 6., 12., 1., 39., 5., 11., 5., 2., 2., 0., 0., 5., 4., 15., 4., 10., 2., 14., 0., 0., 4., 146., 5., 1815., 116., 105., 204., 106., 128., 78., 16., 12., 17., 10., 0., 3., 4., 10., 5., 15., 7., 34., 18., 35., 14., 34., 8., 12., 5., 5., 8., 5., 5., 2., 5., 9., 3., 0., 6., 4., 13., 2., 0., 13., 4., 2., 0., 4., 1., 3., 19., 2., 9., 0., 14., 5., 21., 3., 3., 1., 2., 28., 3., 28., 5., 4., 7., 2., 29., 10., 14., 4.,

17., 1., 2., 5., 31., 6., 23., 1., 16., 147., 1., 23., 231., 6., 19., 5., 2., 3., 78., 0., 11., 296., 47., 345., 45., 15., 2., 1., 8., 4., 52., 32., 239., 36., 7., 167., 10., 32., 5., 0., 1., 18., 8., 90., 22., 77., 21., 43., 38., 19., 3., 3., 28., 5., 39., 13., 48., 12., 31., 3., 10., 11., 2., 0., 2., 0., 17., 3., 16., 5., 24., 5., 8., 7., 0., 6., 1., 2., 1., 1., 9., 3., 9., 5., 11., 3., 1., 5., 129., 8., 1937., 89., 88., 230., 92., 121., 58., 17., 11., 21., 14., 1., 1., 8., 7., 6., 6., 9., 35., 22., 36., 14., 49., 8., 9., 2., 3., 5., 2., 2., 1., 5., 14., 3., 0., 2., 2., 13., 0., 0., 8., 3., 4., 0., 6., 5., 3., 37., 6., 13., 0., 8., 3., 19., 1., 4., 4., 4., 19., 3., 38., 4., 5., 9., 5., 34., 5., 16., 7.,

15., 0., 4., 12., 29., 4., 41., 0., 16., 128., 4., 28., 210., 15., 19., 6., 0., 8., 84., 1., 25., 266., 44., 369., 53., 19., 2., 2., 8., 6., 44., 27., 255., 44., 7., 166., 12., 37., 9., 0., 1., 7., 6., 70., 17., 84., 22., 32., 42., 15., 4., 1., 24., 4., 51., 7., 51., 7., 30., 1., 9., 8., 3., 0., 3., 0., 22., 6., 17., 5., 28., 4., 9., 5., 1., 4., 3., 1., 3., 2., 10., 5., 10., 3., 11., 1., 2., 7., 147., 11., 1938., 82., 109., 219., 108., 122., 68., 23., 9., 24., 15., 0., 2., 6., 6., 2., 7., 6., 34., 18., 32., 26., 33., 4., 11., 4., 0., 9., 6., 1., 1., 6., 14., 5., 0., 3., 2., 19., 1., 0., 8., 2., 2., 0., 3., 2., 3., 32., 2., 10., 0., 12., 3., 23., 4., 4., 3., 6., 17., 3., 32., 9., 8., 9., 4., 27., 11., 10., 4.,

12., 0., 2., 6., 31., 3., 19., 1., 12., 160., 7., 30., 189., 8., 17., 6., 0., 5., 99., 2., 16., 292., 52., 364., 31., 17., 0., 4., 4., 6., 50., 39., 259., 40., 10., 131., 19., 40., 2., 0., 2., 25., 5., 93., 20., 97., 10., 32., 43., 17., 3., 2., 24., 6., 43., 5., 48., 8., 34., 4., 6., 4., 1., 0., 1., 0., 21., 5., 15., 4., 34., 6., 16., 7., 1., 4., 0., 1., 6., 1., 15., 1., 6., 2., 10., 1., 2., 4., 137., 16., 1901., 106., 99., 229., 88., 110., 75., 15., 11., 14., 14., 1., 3., 7., 4., 6., 13., 12., 44., 16., 34., 16., 39., 8., 7., 1., 3., 4., 2., 2., 1., 2., 13., 4., 0., 4., 3., 16., 1., 0., 10., 1., 2., 0., 5., 4., 5., 31., 4., 11., 8., 10., 1., 18., 2., 3., 2., 3., 24., 6., 41., 7., 4., 8., 3., 42., 4., 10., 2.,

14., 1., 2., 10., 28., 5., 42., 0., 14., 166., 1., 27., 215., 2., 11., 7., 0., 5., 76., 0., 19., 317., 38., 337., 38., 19., 1., 2., 11., 4., 59., 36., 231., 30., 14., 165., 19., 45., 3., 0., 1., 18., 10., 78., 23., 86., 18., 42., 51., 15., 3., 0., 17., 7., 35., 14., 42., 11., 33., 8., 8., 9., 3., 0., 1., 0., 20., 5., 15., 5., 25., 8., 12., 2., 1., 0., 1., 2., 1., 3., 9., 3., 7., 0., 8., 1., 0., 5., 143., 7., 1949., 88., 98., 192., 84., 126., 72., 19., 9., 19., 5., 0., 3., 5., 1., 4., 12., 8., 32., 14., 42., 12., 31., 8., 8., 4., 9., 6., 6., 0., 5., 3., 6., 2., 0., 5., 5., 12., 3., 0., 12., 1., 2., 0., 7., 3., 4., 22., 4., 11., 0., 14., 2., 21., 3., 2., 7., 3., 24., 1., 34., 11., 4., 4., 2., 37., 5., 11., 4.,

16., 2., 4., 8., 30., 7., 25., 0., 16., 170., 3., 26., 206., 10., 13., 7., 1., 5., 63., 1., 15., 263., 37., 314., 40., 21., 1., 1., 11., 7., 35., 31., 233., 37., 8., 140., 12., 41., 7., 0., 2., 17., 6., 85., 17., 86., 15., 33., 50., 14., 2., 1., 19., 6., 59., 10., 60., 7., 31., 8., 13., 8., 4., 0., 1., 0., 22., 3., 16., 2., 23., 4., 11., 4., 3., 1., 0., 0., 2., 2., 6., 1., 5., 2., 12., 1., 0., 5., 135., 6., 1840., 92., 93., 227., 91., 107., 65., 20., 10., 19., 12., 0., 6., 5., 5., 7., 8., 12., 42., 15., 30., 17., 38., 5., 6., 4., 2., 8., 6., 3., 4., 2., 10., 4., 0., 7., 4., 12., 3., 0., 11., 4., 2., 0., 3., 1., 6., 34., 2., 9., 4., 24., 2., 13., 2., 6., 4., 7., 22., 4., 28., 7., 3., 7., 7., 39., 7., 14., 4.,

11., 1., 3., 2., 13., 6., 6., 0., 5., 29., 2., 12., 29., 0., 16., 2., 2., 2., 18., 1., 5., 13., 13., 25., 38., 6., 0., 1., 3., 1., 10., 10., 17., 7., 3., 17., 3., 15., 7., 2., 1., 2., 2., 9., 14., 13., 41., 7., 22., 9., 3., 0., 3., 3., 14., 1., 8., 4., 8., 18., 7., 19., 10., 4., 1., 1., 11., 1., 3., 3., 8., 5., 4., 4., 3., 4., 5., 2., 0., 5., 5., 0., 0., 1., 1., 4., 5., 2., 3., 3., 3., 1., 3., 0., 1., 4., 2., 0., 1., 3., 4., 3., 0., 3., 2., 2., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 3., 2., 3., 2., 0., 6., 1., 8., 10., 0., 16., 10., 0., 12., 1., 1., 2., 10., 3., 1., 18., 17., 21., 31., 6., 1., 2., 2., 1., 8., 11., 28., 13., 1., 11., 6., 18., 11., 5., 1., 1., 1., 21., 10., 14., 38., 13., 14., 8., 5., 0., 5., 1., 5., 2., 9., 13., 5., 19., 4., 29., 6., 0., 0., 1., 6., 1., 0., 1., 7., 4., 6., 4., 3., 9., 4., 3., 1., 2., 4., 0., 5., 0., 1., 2., 0., 5., 6., 5., 4., 0., 0., 3., 1., 4., 4., 0., 2., 5., 2., 2., 3., 5., 1., 1., 0., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 5., 10., 6., 4., 1., 8., 16., 1., 8., 17., 1., 27., 3., 2., 3., 22., 0., 7., 31., 10., 28., 29., 8., 0., 0., 1., 2., 9., 5., 37., 26., 3., 15., 4., 15., 12., 0., 2., 4., 2., 21., 15., 19., 51., 7., 25., 11., 3., 0., 3., 1., 16., 6., 12., 7., 4., 14., 11., 22., 11., 3., 1., 0., 0., 1., 1., 3., 3., 1., 2., 5., 1., 2., 2., 4., 1., 1., 2., 0., 4., 2., 3., 3., 1., 4., 2., 1., 3., 0., 2., 1., 3., 4., 0., 0., 0., 1., 0., 4., 1., 1., 0., 0., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 2., 4., 10., 4., 15., 0., 5., 18., 2., 13., 25., 1., 20., 2., 1., 1., 13., 0., 4., 35., 14., 24., 32., 2., 1., 0., 1., 3., 8., 7., 29., 11., 0., 13., 5., 15., 8., 4., 1., 4., 3., 8., 12., 20., 55., 7., 19., 11., 5., 1., 4., 2., 14., 3., 7., 3., 11., 14., 5., 24., 7., 2., 2., 2., 10., 1., 2., 0., 5., 3., 4., 4., 0., 1., 1., 3., 1., 3., 1., 0., 1., 0., 3., 3., 2., 4., 3., 2., 8., 2., 5., 2., 1., 9., 3., 0., 2., 2., 1., 0., 1., 2., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 5., 13., 5., 1., 2., 5., 25., 1., 17., 20., 2., 19., 2., 1., 4., 15., 1., 3., 10., 11., 33., 33., 4., 1., 1., 4., 2., 9., 3., 25., 10., 5., 18., 3., 17., 7., 2., 0., 4., 4., 15., 9., 12., 36., 10., 19., 12., 4., 2., 5., 3., 9., 2., 13., 8., 10., 18., 9., 21., 12., 6., 0., 0., 10., 1., 7., 2., 7., 1., 3., 1., 3., 2., 11., 2., 3., 1., 2., 0., 2., 2., 1., 7., 1., 4., 5., 1., 2., 0., 2., 1., 5., 4., 0., 0., 2., 1., 1., 0., 5., 0., 0., 1., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 3., 4., 18., 5., 4., 0., 8., 23., 2., 17., 16., 2., 14., 6., 1., 2., 28., 3., 7., 18., 15., 28., 26., 3., 1., 1., 1., 2., 5., 13., 25., 21., 2., 13., 6., 13., 20., 2., 2., 8., 2., 9., 15., 26., 53., 11., 23., 8., 5., 3., 6., 0., 6., 6., 17., 5., 9., 12., 4., 26., 11., 5., 0., 0., 10., 0., 6., 3., 8., 2., 2., 3., 3., 3., 2., 1., 0., 2., 2., 0., 2., 0., 2., 7., 3., 3., 1., 0., 9., 0., 4., 1., 3., 7., 2., 0., 3., 5., 4., 1., 1., 2., 4., 0., 1., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 7., 29., 3., 37., 2., 10., 156., 3., 21., 209., 2., 21., 4., 3., 4., 81., 6., 10., 296., 43., 361., 38., 15., 1., 2., 4., 4., 44., 40., 235., 39., 9., 168., 16., 36., 4., 0., 2., 19., 5., 79., 18., 91., 13., 28., 48., 13., 4., 1., 32., 8., 39., 5., 48., 10., 25., 5., 8., 7., 3., 0., 0., 0., 29., 1., 14., 2., 27., 5., 13., 4., 1., 3., 3., 0., 1., 2., 10., 2., 8., 5., 8., 1., 2., 2., 138., 9., 1929., 87., 97., 232., 84., 108., 67., 17., 9., 22., 16., 0., 0., 10., 6., 3., 9., 6., 35., 15., 37., 19., 33., 2., 8., 7., 5., 6., 3., 3., 4., 2., 3., 2., 0., 5., 2., 8., 2., 0., 10., 2., 4., 0., 5., 1., 5., 24., 1., 9., 1., 15., 4., 20., 1., 5., 1., 4., 25., 3., 37., 6., 2., 8., 5., 35., 6., 8., 3.,

21., 1., 5., 10., 27., 3., 27., 2., 11., 136., 6., 36., 193., 9., 17., 6., 0., 4., 70., 3., 15., 294., 48., 307., 48., 17., 0., 0., 7., 2., 42., 30., 239., 40., 5., 146., 10., 44., 5., 0., 2., 10., 10., 77., 31., 81., 17., 34., 41., 8., 1., 0., 20., 13., 36., 12., 47., 10., 34., 7., 17., 8., 0., 0., 1., 0., 23., 4., 15., 2., 27., 4., 14., 5., 1., 2., 0., 1., 5., 5., 8., 2., 9., 3., 6., 2., 1., 4., 134., 3., 1858., 98., 101., 249., 118., 113., 71., 18., 8., 13., 17., 1., 3., 7., 4., 3., 8., 5., 35., 21., 31., 20., 39., 9., 9., 3., 3., 10., 5., 1., 2., 1., 12., 4., 0., 2., 3., 14., 2., 0., 10., 3., 2., 0., 7., 1., 2., 35., 0., 14., 3., 9., 2., 23., 3., 5., 2., 8., 31., 7., 22., 10., 6., 6., 3., 24., 7., 16., 6.,

6., 6., 4., 12., 23., 4., 35., 0., 21., 160., 3., 27., 198., 3., 17., 8., 1., 6., 69., 5., 27., 280., 48., 319., 47., 16., 0., 3., 8., 6., 51., 35., 242., 36., 9., 143., 13., 35., 6., 0., 2., 23., 14., 81., 25., 116., 14., 45., 43., 13., 1., 0., 18., 5., 33., 12., 58., 7., 37., 4., 11., 14., 0., 0., 0., 0., 18., 5., 17., 4., 30., 6., 7., 6., 3., 4., 0., 0., 4., 0., 13., 1., 3., 2., 7., 1., 0., 4., 145., 8., 1919., 94., 95., 248., 99., 119., 58., 13., 11., 21., 13., 0., 2., 5., 1., 2., 15., 5., 50., 10., 36., 19., 50., 10., 6., 1., 3., 5., 3., 2., 2., 5., 5., 2., 0., 4., 7., 14., 3., 0., 13., 6., 4., 0., 1., 4., 4., 30., 3., 11., 4., 12., 1., 17., 3., 5., 5., 9., 20., 5., 30., 6., 3., 7., 4., 43., 4., 12., 3.,

14., 3., 6., 14., 24., 15., 33., 2., 25., 166., 1., 20., 209., 7., 16., 9., 1., 7., 86., 2., 14., 305., 46., 313., 46., 13., 1., 1., 4., 5., 41., 36., 258., 35., 12., 176., 15., 38., 5., 0., 2., 24., 8., 79., 17., 90., 15., 31., 45., 17., 6., 1., 28., 6., 46., 7., 54., 11., 34., 4., 12., 9., 1., 0., 0., 0., 22., 6., 6., 4., 34., 4., 18., 2., 3., 3., 1., 3., 3., 2., 14., 1., 10., 1., 10., 1., 3., 4., 151., 8., 1900., 82., 106., 224., 98., 121., 69., 23., 12., 19., 14., 1., 1., 5., 3., 6., 8., 10., 27., 12., 43., 14., 49., 6., 12., 4., 5., 7., 8., 2., 6., 4., 9., 5., 0., 7., 6., 15., 0., 0., 12., 7., 3., 0., 4., 1., 1., 30., 4., 23., 4., 12., 3., 25., 2., 2., 3., 4., 24., 5., 44., 8., 4., 17., 4., 29., 12., 8., 6.,

23., 1., 2., 9., 21., 9., 23., 1., 10., 144., 3., 17., 197., 6., 8., 7., 1., 1., 76., 5., 17., 276., 41., 306., 38., 15., 2., 1., 9., 4., 43., 27., 220., 39., 13., 155., 14., 34., 5., 0., 0., 18., 10., 74., 21., 91., 12., 25., 45., 15., 4., 0., 16., 7., 47., 11., 54., 7., 28., 4., 6., 2., 3., 0., 1., 0., 22., 3., 14., 2., 29., 4., 6., 6., 1., 3., 0., 0., 1., 1., 7., 2., 6., 1., 6., 2., 1., 4., 125., 6., 1964., 110., 77., 206., 98., 101., 71., 19., 16., 15., 13., 0., 1., 6., 5., 4., 3., 14., 32., 18., 29., 13., 37., 8., 11., 3., 5., 9., 5., 5., 5., 5., 10., 2., 0., 5., 4., 16., 0., 0., 10., 5., 2., 0., 8., 2., 3., 42., 1., 9., 2., 15., 0., 19., 2., 4., 4., 1., 35., 3., 31., 9., 6., 8., 3., 29., 5., 9., 2.,

17., 1., 4., 8., 20., 8., 40., 1., 13., 152., 4., 34., 200., 4., 22., 5., 2., 3., 92., 2., 17., 280., 45., 343., 56., 16., 2., 0., 4., 3., 50., 22., 221., 49., 10., 160., 14., 41., 5., 0., 2., 15., 8., 66., 21., 85., 15., 33., 48., 12., 6., 1., 25., 3., 46., 13., 49., 9., 33., 8., 10., 5., 1., 0., 1., 0., 26., 7., 14., 2., 26., 2., 14., 4., 2., 6., 0., 0., 5., 0., 16., 1., 10., 1., 5., 1., 2., 6., 149., 5., 1923., 96., 113., 214., 96., 109., 79., 15., 14., 12., 15., 0., 2., 5., 7., 5., 8., 7., 31., 15., 36., 17., 30., 9., 9., 2., 2., 3., 6., 1., 3., 2., 5., 6., 0., 7., 5., 8., 1., 0., 6., 4., 7., 0., 6., 1., 3., 25., 3., 11., 4., 10., 5., 24., 3., 0., 6., 5., 30., 2., 30., 7., 7., 7., 2., 32., 10., 16., 5.,

10., 4., 3., 6., 31., 2., 39., 2., 17., 159., 4., 36., 213., 8., 14., 12., 0., 1., 83., 2., 19., 264., 35., 351., 40., 21., 1., 4., 8., 2., 47., 40., 245., 45., 6., 147., 19., 29., 7., 0., 0., 18., 7., 83., 16., 85., 14., 28., 62., 13., 4., 2., 38., 12., 38., 10., 53., 3., 24., 7., 13., 8., 1., 0., 2., 0., 25., 3., 16., 4., 23., 3., 17., 8., 2., 2., 0., 0., 5., 1., 11., 2., 10., 0., 5., 0., 0., 2., 142., 10., 1934., 97., 86., 211., 96., 123., 64., 10., 11., 22., 17., 0., 3., 3., 5., 6., 14., 12., 47., 15., 29., 16., 35., 9., 8., 7., 5., 6., 5., 2., 2., 3., 8., 1., 0., 4., 3., 12., 2., 0., 11., 4., 3., 0., 3., 3., 1., 30., 4., 20., 4., 12., 4., 25., 2., 6., 3., 4., 27., 5., 38., 1., 3., 5., 4., 36., 3., 10., 6.,

18., 1., 4., 4., 21., 8., 27., 2., 11., 159., 5., 22., 201., 6., 17., 6., 0., 8., 96., 3., 16., 279., 58., 301., 44., 17., 1., 0., 6., 1., 36., 35., 229., 36., 4., 165., 10., 33., 7., 0., 4., 23., 11., 61., 20., 71., 14., 37., 43., 17., 4., 1., 25., 11., 40., 4., 51., 10., 29., 6., 11., 5., 2., 0., 1., 0., 26., 2., 12., 0., 21., 2., 8., 4., 0., 2., 1., 3., 6., 2., 13., 4., 6., 0., 6., 1., 2., 0., 165., 7., 1869., 86., 95., 244., 86., 122., 68., 16., 8., 19., 9., 2., 1., 7., 7., 6., 12., 7., 34., 17., 26., 17., 42., 8., 9., 7., 5., 7., 7., 3., 2., 2., 8., 1., 0., 3., 4., 13., 2., 0., 15., 4., 2., 0., 8., 2., 3., 26., 2., 20., 3., 14., 5., 18., 0., 2., 5., 5., 29., 5., 24., 4., 7., 9., 4., 43., 5., 11., 4.,

17., 1., 3., 10., 25., 6., 33., 3., 15., 161., 1., 28., 206., 9., 21., 7., 3., 5., 108., 2., 9., 293., 48., 322., 40., 17., 2., 5., 9., 7., 45., 38., 223., 36., 7., 172., 24., 43., 7., 0., 3., 13., 10., 64., 18., 83., 13., 28., 39., 9., 3., 0., 26., 7., 38., 13., 36., 9., 35., 2., 6., 7., 3., 0., 2., 0., 32., 7., 13., 8., 30., 10., 5., 4., 1., 3., 0., 1., 4., 1., 10., 3., 12., 5., 2., 1., 1., 4., 145., 13., 1899., 89., 110., 215., 96., 97., 65., 17., 11., 17., 12., 2., 4., 5., 3., 2., 13., 8., 19., 17., 21., 14., 46., 6., 13., 6., 2., 5., 12., 2., 1., 2., 6., 3., 0., 4., 6., 15., 3., 0., 18., 4., 3., 0., 4., 1., 3., 28., 1., 10., 4., 9., 3., 21., 3., 4., 5., 3., 31., 4., 32., 5., 5., 7., 3., 32., 5., 10., 7.,

8., 0., 9., 6., 27., 5., 29., 1., 16., 150., 6., 29., 195., 6., 13., 11., 0., 4., 82., 2., 12., 306., 47., 309., 43., 15., 0., 0., 7., 8., 39., 33., 236., 40., 13., 164., 20., 40., 7., 0., 2., 22., 13., 84., 21., 76., 13., 37., 51., 20., 3., 0., 26., 6., 42., 7., 51., 11., 38., 8., 14., 9., 7., 0., 1., 0., 20., 4., 12., 3., 32., 8., 11., 6., 1., 0., 2., 2., 1., 4., 10., 1., 10., 1., 4., 2., 1., 5., 137., 8., 1911., 72., 95., 217., 95., 107., 57., 14., 12., 13., 12., 0., 1., 6., 6., 4., 9., 10., 45., 14., 42., 12., 49., 7., 8., 3., 5., 10., 6., 2., 1., 4., 9., 3., 0., 4., 4., 15., 5., 0., 5., 5., 3., 0., 5., 3., 5., 27., 3., 9., 2., 6., 5., 26., 1., 5., 3., 4., 27., 6., 31., 2., 7., 5., 5., 24., 7., 10., 4.,

9., 2., 4., 8., 25., 4., 34., 0., 19., 182., 5., 25., 199., 7., 15., 4., 1., 5., 76., 2., 18., 304., 34., 330., 42., 18., 1., 1., 13., 1., 51., 36., 223., 43., 7., 152., 17., 35., 5., 0., 2., 12., 9., 78., 16., 87., 14., 31., 49., 9., 1., 0., 20., 9., 39., 6., 53., 14., 40., 3., 6., 4., 0., 0., 2., 0., 24., 3., 23., 3., 29., 10., 9., 4., 6., 3., 2., 1., 3., 1., 11., 3., 10., 1., 9., 0., 1., 5., 146., 10., 1786., 84., 110., 230., 98., 102., 71., 14., 9., 22., 11., 1., 1., 9., 9., 5., 5., 2., 27., 17., 46., 20., 39., 4., 11., 3., 2., 9., 6., 0., 2., 1., 7., 8., 0., 4., 9., 15., 3., 0., 9., 4., 3., 0., 5., 2., 6., 27., 3., 9., 5., 13., 1., 21., 6., 2., 5., 2., 18., 5., 35., 7., 5., 8., 8., 42., 6., 13., 8.,

14., 3., 3., 3., 27., 6., 31., 1., 7., 167., 1., 23., 218., 4., 14., 7., 1., 5., 83., 3., 20., 281., 57., 323., 40., 19., 1., 3., 8., 9., 45., 39., 230., 44., 15., 158., 22., 31., 6., 0., 1., 12., 12., 64., 18., 87., 8., 36., 41., 10., 4., 2., 31., 6., 43., 7., 40., 7., 37., 8., 5., 0., 2., 0., 1., 0., 22., 4., 14., 5., 25., 6., 7., 10., 1., 2., 0., 1., 3., 2., 11., 2., 4., 3., 9., 1., 1., 3., 167., 12., 1863., 94., 97., 241., 95., 107., 66., 15., 12., 14., 5., 1., 1., 6., 3., 5., 8., 8., 36., 19., 37., 12., 42., 10., 9., 7., 6., 7., 6., 3., 2., 7., 8., 2., 0., 3., 3., 9., 5., 0., 11., 3., 2., 0., 6., 3., 1., 41., 3., 10., 3., 9., 4., 20., 5., 3., 3., 7., 20., 3., 38., 7., 5., 4., 5., 28., 7., 8., 5.,

10., 1., 3., 11., 29., 8., 22., 1., 12., 166., 2., 22., 191., 4., 16., 5., 0., 2., 88., 0., 17., 292., 51., 338., 51., 25., 0., 4., 5., 8., 37., 20., 227., 44., 12., 157., 12., 37., 7., 0., 5., 15., 8., 82., 19., 91., 11., 41., 48., 15., 3., 1., 25., 2., 43., 7., 52., 9., 27., 7., 7., 10., 2., 0., 0., 0., 17., 7., 17., 2., 33., 4., 10., 2., 3., 3., 0., 1., 3., 1., 15., 4., 10., 0., 12., 1., 1., 4., 131., 10., 1866., 81., 90., 201., 117., 120., 64., 13., 8., 17., 9., 1., 0., 4., 3., 4., 11., 11., 37., 13., 31., 19., 42., 4., 7., 2., 5., 3., 6., 3., 6., 2., 4., 4., 0., 3., 10., 16., 3., 0., 13., 6., 3., 0., 5., 5., 3., 24., 6., 9., 3., 18., 4., 25., 5., 6., 10., 1., 25., 6., 26., 10., 8., 5., 4., 30., 9., 13., 3.,

8., 1., 4., 9., 27., 8., 34., 0., 17., 163., 4., 24., 213., 3., 19., 17., 1., 5., 78., 4., 17., 309., 29., 339., 50., 14., 3., 3., 10., 8., 36., 42., 201., 32., 10., 161., 14., 35., 11., 0., 0., 24., 5., 82., 18., 88., 12., 32., 55., 11., 4., 2., 31., 11., 31., 9., 53., 5., 30., 8., 9., 9., 5., 0., 0., 0., 24., 13., 14., 1., 33., 8., 10., 5., 0., 2., 1., 1., 5., 1., 9., 2., 11., 5., 7., 0., 2., 5., 147., 4., 1911., 99., 112., 205., 109., 122., 63., 12., 16., 14., 14., 0., 1., 2., 1., 2., 8., 5., 40., 13., 24., 12., 40., 10., 10., 7., 4., 11., 3., 4., 3., 3., 4., 2., 0., 4., 9., 22., 1., 0., 8., 2., 2., 0., 4., 3., 5., 30., 1., 10., 1., 7., 1., 15., 3., 1., 7., 5., 20., 5., 44., 8., 4., 11., 4., 35., 4., 12., 9.,

14., 2., 2., 6., 31., 6., 39., 4., 17., 161., 2., 21., 200., 4., 22., 8., 0., 2., 95., 1., 14., 269., 44., 324., 40., 26., 3., 1., 6., 6., 31., 26., 228., 39., 11., 168., 11., 37., 5., 0., 1., 18., 8., 78., 18., 97., 13., 35., 46., 21., 1., 0., 31., 11., 37., 11., 54., 9., 37., 4., 9., 7., 1., 0., 4., 0., 16., 5., 14., 3., 35., 7., 10., 3., 2., 1., 4., 3., 2., 4., 8., 3., 9., 0., 7., 2., 0., 4., 139., 10., 1904., 106., 107., 235., 108., 110., 71., 18., 13., 15., 13., 1., 4., 6., 8., 4., 4., 4., 43., 22., 33., 14., 45., 7., 9., 4., 5., 9., 6., 2., 4., 1., 10., 3., 0., 3., 6., 13., 1., 0., 6., 3., 2., 0., 2., 3., 4., 28., 7., 17., 2., 15., 3., 21., 5., 2., 3., 5., 25., 4., 34., 5., 4., 6., 5., 36., 6., 11., 5.,

8., 1., 2., 8., 24., 5., 35., 0., 19., 171., 4., 29., 195., 7., 18., 10., 0., 1., 101., 4., 18., 302., 36., 335., 48., 15., 0., 2., 4., 6., 54., 31., 232., 45., 6., 154., 18., 47., 4., 0., 1., 21., 4., 83., 17., 85., 15., 35., 66., 14., 2., 1., 33., 9., 51., 12., 63., 6., 38., 5., 7., 7., 2., 0., 0., 0., 18., 5., 13., 2., 23., 2., 14., 4., 1., 2., 0., 2., 3., 1., 5., 1., 8., 1., 11., 0., 2., 4., 148., 6., 1930., 79., 100., 211., 98., 90., 73., 17., 18., 11., 16., 1., 2., 4., 6., 6., 12., 16., 31., 12., 31., 22., 46., 8., 7., 5., 6., 7., 3., 3., 3., 3., 8., 6., 0., 3., 3., 11., 0., 0., 15., 4., 2., 0., 3., 5., 3., 38., 2., 15., 1., 15., 5., 26., 5., 2., 4., 5., 19., 6., 32., 5., 5., 4., 3., 42., 6., 12., 4.,

14., 2., 4., 5., 26., 6., 35., 1., 13., 178., 0., 29., 224., 4., 14., 12., 1., 6., 89., 6., 18., 268., 43., 309., 46., 16., 1., 1., 5., 1., 46., 24., 239., 34., 9., 168., 17., 34., 6., 0., 2., 20., 8., 97., 21., 91., 11., 36., 43., 13., 2., 1., 16., 13., 43., 6., 41., 9., 24., 5., 10., 10., 2., 0., 0., 0., 27., 4., 10., 2., 41., 1., 11., 5., 2., 2., 0., 0., 2., 1., 6., 4., 6., 2., 7., 0., 1., 3., 156., 7., 1818., 93., 103., 228., 96., 116., 66., 20., 12., 19., 9., 0., 1., 6., 3., 5., 7., 12., 24., 17., 23., 11., 46., 5., 10., 4., 2., 7., 0., 4., 0., 1., 8., 3., 0., 3., 4., 13., 2., 0., 4., 2., 2., 0., 4., 3., 5., 35., 3., 13., 2., 7., 5., 27., 0., 5., 4., 6., 26., 5., 27., 6., 3., 10., 2., 36., 5., 13., 7.,

9., 2., 5., 7., 26., 6., 26., 1., 21., 136., 3., 40., 206., 7., 17., 4., 1., 6., 84., 0., 19., 270., 28., 337., 37., 16., 2., 2., 9., 3., 48., 31., 231., 35., 4., 167., 16., 42., 5., 0., 3., 17., 5., 81., 30., 83., 16., 40., 46., 18., 2., 0., 27., 8., 45., 13., 43., 6., 25., 6., 9., 7., 1., 0., 1., 0., 23., 4., 8., 1., 29., 7., 10., 3., 4., 2., 0., 2., 2., 3., 17., 2., 5., 2., 3., 2., 1., 6., 142., 5., 1969., 103., 91., 220., 87., 107., 55., 17., 11., 29., 12., 1., 2., 9., 5., 3., 9., 13., 38., 16., 29., 15., 47., 3., 8., 2., 4., 11., 3., 4., 6., 1., 4., 2., 0., 3., 6., 13., 1., 0., 12., 1., 3., 0., 6., 6., 7., 28., 1., 12., 4., 22., 1., 20., 1., 5., 1., 4., 30., 4., 29., 9., 5., 5., 4., 38., 4., 14., 3.,

20., 1., 6., 6., 20., 4., 35., 0., 16., 148., 6., 28., 186., 3., 11., 7., 1., 4., 85., 3., 17., 258., 38., 364., 41., 24., 0., 3., 2., 3., 43., 33., 207., 39., 4., 161., 18., 35., 5., 0., 4., 16., 12., 78., 14., 97., 12., 31., 39., 12., 4., 0., 30., 4., 43., 10., 64., 10., 27., 8., 8., 8., 3., 0., 1., 0., 31., 5., 13., 1., 21., 3., 10., 6., 3., 2., 1., 1., 1., 0., 8., 2., 4., 2., 5., 1., 1., 4., 158., 9., 1929., 100., 99., 226., 97., 110., 68., 16., 10., 17., 17., 0., 1., 5., 6., 3., 5., 9., 34., 14., 33., 21., 34., 4., 10., 3., 4., 8., 3., 2., 5., 3., 8., 3., 0., 3., 6., 15., 2., 0., 10., 2., 4., 0., 4., 2., 4., 28., 3., 7., 2., 11., 3., 30., 3., 4., 2., 7., 22., 9., 30., 5., 4., 2., 1., 37., 6., 10., 7.,

16., 1., 1., 7., 23., 8., 23., 1., 20., 156., 3., 23., 207., 7., 10., 6., 2., 3., 88., 1., 14., 291., 36., 328., 47., 15., 2., 3., 5., 4., 36., 27., 222., 28., 6., 153., 13., 42., 7., 0., 2., 15., 12., 88., 17., 87., 11., 26., 50., 13., 7., 0., 26., 7., 42., 17., 44., 7., 29., 7., 14., 3., 2., 0., 0., 0., 23., 4., 21., 5., 21., 8., 10., 5., 2., 2., 1., 0., 3., 1., 8., 4., 10., 1., 7., 0., 0., 5., 161., 4., 1918., 103., 88., 234., 101., 113., 57., 17., 12., 12., 11., 1., 2., 6., 6., 4., 15., 6., 40., 16., 41., 17., 45., 7., 9., 3., 5., 6., 3., 1., 6., 4., 10., 2., 0., 2., 1., 18., 3., 0., 3., 4., 2., 0., 8., 3., 3., 18., 5., 8., 6., 17., 3., 22., 5., 1., 2., 5., 25., 3., 34., 8., 10., 8., 2., 36., 7., 16., 3.,

13., 2., 2., 8., 30., 10., 21., 2., 25., 157., 2., 25., 211., 4., 17., 9., 1., 8., 87., 0., 22., 302., 48., 337., 36., 21., 1., 1., 5., 7., 42., 32., 264., 52., 12., 161., 17., 41., 8., 0., 2., 20., 8., 80., 13., 85., 17., 34., 57., 11., 1., 0., 28., 5., 40., 9., 48., 8., 22., 4., 7., 5., 3., 0., 1., 0., 17., 3., 11., 3., 23., 3., 10., 6., 1., 2., 2., 2., 2., 0., 16., 4., 7., 3., 17., 1., 2., 5., 146., 8., 1868., 84., 85., 231., 94., 101., 74., 11., 14., 16., 8., 0., 0., 7., 5., 7., 17., 7., 38., 18., 41., 19., 42., 8., 16., 5., 6., 7., 4., 1., 2., 5., 8., 2., 0., 7., 6., 13., 0., 0., 10., 3., 5., 0., 4., 2., 8., 18., 1., 13., 6., 11., 4., 18., 4., 2., 4., 4., 24., 4., 26., 4., 5., 7., 0., 30., 9., 12., 4.,

23., 1., 2., 4., 30., 8., 20., 0., 14., 137., 4., 26., 199., 5., 15., 2., 1., 4., 77., 1., 17., 279., 43., 358., 29., 23., 1., 1., 10., 1., 51., 27., 250., 31., 13., 161., 18., 40., 3., 0., 0., 19., 11., 70., 19., 89., 15., 27., 45., 16., 1., 3., 23., 5., 35., 10., 51., 8., 22., 8., 5., 7., 1., 0., 0., 0., 36., 13., 9., 2., 34., 7., 14., 3., 4., 2., 1., 2., 2., 2., 11., 5., 8., 1., 7., 1., 0., 4., 121., 8., 1892., 91., 102., 242., 102., 138., 88., 13., 13., 10., 14., 1., 7., 3., 3., 6., 7., 8., 31., 14., 34., 17., 36., 14., 8., 5., 5., 2., 5., 5., 6., 7., 2., 3., 0., 7., 4., 13., 1., 0., 6., 4., 4., 0., 4., 4., 6., 41., 2., 14., 3., 17., 2., 27., 4., 4., 3., 5., 21., 6., 25., 7., 10., 4., 6., 35., 9., 13., 4.,

10., 1., 4., 11., 24., 7., 32., 1., 14., 174., 2., 25., 218., 5., 12., 2., 1., 4., 98., 1., 21., 297., 53., 301., 51., 11., 0., 3., 9., 2., 42., 36., 238., 44., 7., 155., 15., 45., 8., 0., 1., 15., 8., 77., 14., 99., 23., 37., 51., 14., 4., 1., 15., 13., 47., 6., 45., 5., 35., 5., 13., 9., 2., 0., 0., 0., 16., 2., 13., 6., 32., 8., 12., 9., 3., 5., 2., 1., 4., 3., 6., 2., 8., 2., 10., 0., 0., 6., 140., 10., 1853., 89., 94., 197., 88., 115., 69., 17., 11., 23., 11., 0., 3., 5., 7., 3., 12., 10., 31., 16., 32., 10., 39., 7., 13., 5., 5., 15., 3., 4., 2., 2., 7., 4., 0., 2., 3., 14., 1., 0., 10., 2., 4., 0., 3., 3., 1., 35., 5., 8., 1., 15., 5., 16., 4., 8., 8., 7., 20., 3., 26., 7., 4., 10., 4., 23., 9., 10., 5.,

3., 1., 0., 6., 7., 2., 7., 0., 3., 26., 0., 10., 24., 2., 15., 2., 0., 6., 7., 1., 8., 17., 12., 24., 27., 4., 1., 2., 5., 0., 12., 2., 20., 15., 2., 12., 3., 16., 11., 1., 3., 0., 3., 10., 11., 26., 39., 13., 29., 9., 4., 1., 5., 2., 9., 4., 9., 9., 12., 24., 5., 21., 7., 2., 0., 0., 8., 1., 3., 1., 4., 4., 3., 5., 1., 5., 8., 3., 0., 2., 0., 0., 0., 3., 2., 7., 0., 3., 4., 2., 5., 0., 1., 2., 2., 6., 2., 0., 3., 0., 3., 0., 3., 3., 1., 0., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 1., 4., 11., 2., 6., 2., 3., 21., 1., 6., 24., 1., 11., 3., 1., 2., 21., 0., 4., 24., 12., 26., 34., 5., 2., 0., 2., 3., 9., 6., 20., 18., 1., 10., 7., 16., 9., 3., 0., 3., 3., 17., 15., 11., 42., 15., 32., 14., 5., 3., 6., 0., 4., 2., 9., 5., 8., 14., 10., 26., 7., 1., 3., 2., 6., 1., 1., 4., 2., 2., 4., 6., 1., 4., 3., 4., 1., 2., 1., 0., 7., 4., 2., 8., 1., 3., 1., 1., 6., 2., 2., 2., 0., 7., 2., 0., 2., 3., 1., 1., 1., 3., 3., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 1., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 1., 2., 6., 5., 6., 7., 1., 5., 13., 0., 11., 27., 1., 22., 4., 0., 3., 10., 3., 4., 25., 12., 20., 30., 2., 0., 3., 5., 3., 6., 8., 34., 11., 3., 19., 3., 8., 10., 2., 1., 6., 1., 13., 12., 16., 33., 14., 12., 6., 3., 0., 5., 3., 12., 2., 9., 7., 6., 19., 5., 22., 12., 5., 2., 1., 12., 2., 0., 0., 4., 1., 2., 2., 3., 3., 3., 0., 3., 3., 2., 0., 4., 1., 2., 6., 3., 3., 0., 4., 3., 0., 3., 0., 0., 10., 5., 0., 1., 1., 0., 1., 1., 2., 1., 0., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 5., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 3., 8., 4., 2., 5., 1., 8., 15., 2., 17., 24., 0., 14., 2., 2., 1., 22., 4., 3., 19., 12., 21., 28., 3., 1., 2., 4., 0., 7., 7., 25., 14., 0., 10., 3., 13., 9., 3., 2., 5., 2., 10., 9., 19., 48., 14., 25., 9., 3., 0., 4., 1., 9., 6., 7., 8., 3., 13., 5., 18., 8., 3., 1., 1., 9., 2., 1., 1., 6., 2., 5., 1., 5., 2., 2., 1., 1., 1., 4., 0., 3., 1., 0., 3., 2., 3., 5., 4., 4., 0., 2., 1., 1., 6., 1., 0., 1., 2., 5., 1., 3., 3., 2., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 0., 3., 7., 5., 9., 0., 4., 34., 1., 15., 28., 0., 13., 2., 1., 3., 4., 0., 5., 28., 23., 29., 25., 6., 0., 1., 5., 2., 4., 6., 19., 22., 1., 18., 5., 13., 10., 0., 0., 3., 2., 11., 13., 23., 51., 10., 15., 6., 5., 1., 7., 1., 3., 2., 11., 5., 4., 18., 1., 22., 5., 3., 0., 3., 11., 0., 5., 6., 5., 5., 3., 3., 2., 2., 1., 0., 1., 0., 2., 0., 1., 2., 2., 2., 5., 7., 2., 0., 4., 0., 3., 1., 1., 6., 3., 0., 1., 2., 3., 1., 2., 1., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 3., 3., 2., 6., 2., 5., 2., 13., 29., 0., 14., 18., 1., 18., 3., 0., 3., 12., 2., 5., 30., 10., 23., 30., 7., 1., 2., 4., 3., 11., 6., 25., 13., 0., 16., 2., 15., 4., 1., 3., 3., 0., 14., 9., 25., 43., 8., 17., 8., 3., 1., 6., 1., 5., 0., 7., 9., 11., 15., 5., 21., 11., 1., 1., 0., 4., 0., 3., 1., 4., 4., 6., 5., 0., 4., 2., 3., 0., 4., 0., 0., 2., 1., 1., 5., 4., 3., 2., 1., 1., 2., 1., 1., 0., 6., 1., 0., 2., 0., 0., 1., 1., 1., 3., 2., 4., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 4., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 3., 7., 4., 2., 0., 7., 35., 0., 11., 13., 1., 11., 3., 0., 2., 23., 0., 4., 24., 4., 21., 28., 6., 0., 1., 2., 2., 11., 7., 27., 10., 4., 13., 5., 10., 13., 3., 1., 5., 2., 14., 13., 9., 45., 11., 27., 6., 3., 0., 3., 3., 10., 2., 6., 7., 8., 14., 6., 19., 9., 3., 1., 0., 5., 1., 4., 2., 6., 0., 4., 5., 3., 8., 2., 4., 2., 7., 0., 0., 1., 4., 2., 8., 2., 3., 1., 4., 3., 0., 1., 1., 3., 7., 2., 0., 3., 2., 0., 3., 0., 0., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 4., 4., 9., 4., 4., 2., 3., 26., 0., 10., 32., 0., 16., 2., 3., 2., 21., 4., 2., 18., 10., 30., 16., 11., 0., 0., 0., 3., 7., 7., 19., 17., 6., 15., 0., 12., 10., 2., 0., 4., 1., 16., 11., 21., 41., 9., 21., 7., 1., 1., 5., 4., 7., 5., 13., 9., 7., 15., 5., 24., 11., 5., 3., 3., 7., 2., 4., 2., 7., 2., 3., 6., 2., 6., 6., 3., 2., 0., 0., 0., 1., 1., 0., 3., 2., 7., 2., 4., 7., 1., 1., 1., 4., 7., 1., 0., 5., 3., 2., 3., 1., 1., 1., 3., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 3., 5., 3., 1., 4., 1., 4., 20., 1., 14., 29., 0., 17., 3., 2., 3., 22., 1., 4., 22., 7., 16., 29., 7., 1., 0., 3., 3., 8., 6., 28., 24., 1., 14., 2., 14., 6., 2., 1., 3., 4., 8., 13., 14., 51., 7., 15., 10., 5., 3., 7., 2., 15., 3., 10., 4., 8., 10., 5., 9., 4., 3., 4., 1., 7., 0., 1., 2., 3., 3., 3., 6., 2., 5., 1., 3., 0., 5., 0., 0., 1., 1., 1., 5., 2., 5., 3., 8., 4., 0., 1., 1., 3., 5., 4., 0., 2., 1., 2., 2., 2., 2., 4., 4., 2., 0., 0., 0., 0., 3., 0., 0., 6., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 2., 1., 8., 21., 3., 32., 4., 10., 166., 2., 20., 207., 5., 15., 12., 3., 4., 93., 0., 16., 312., 37., 337., 37., 26., 0., 2., 8., 9., 48., 36., 233., 48., 11., 172., 23., 42., 10., 0., 3., 11., 13., 79., 16., 82., 18., 34., 35., 8., 2., 3., 27., 7., 36., 8., 49., 9., 31., 10., 8., 8., 1., 0., 2., 0., 23., 6., 13., 3., 33., 7., 7., 5., 3., 3., 0., 0., 6., 5., 16., 4., 9., 2., 10., 1., 0., 3., 132., 8., 1828., 99., 100., 234., 95., 98., 67., 18., 10., 25., 15., 2., 2., 5., 4., 5., 9., 13., 34., 24., 40., 20., 37., 8., 8., 3., 3., 5., 8., 4., 2., 2., 12., 2., 0., 1., 4., 17., 0., 0., 16., 6., 3., 0., 3., 3., 3., 30., 3., 17., 4., 11., 2., 12., 2., 3., 7., 5., 20., 6., 35., 4., 1., 8., 5., 37., 6., 11., 2.,

14., 2., 3., 7., 21., 4., 37., 0., 18., 165., 3., 31., 193., 5., 16., 12., 0., 5., 90., 6., 16., 258., 34., 311., 41., 16., 2., 1., 9., 1., 32., 41., 249., 48., 5., 178., 7., 32., 8., 0., 0., 12., 15., 68., 15., 78., 15., 40., 57., 9., 3., 0., 27., 3., 40., 7., 56., 8., 29., 6., 7., 6., 3., 0., 0., 0., 19., 3., 13., 2., 28., 3., 14., 5., 2., 5., 1., 0., 5., 1., 8., 0., 5., 2., 4., 1., 1., 5., 136., 5., 1874., 94., 99., 215., 87., 118., 71., 20., 13., 19., 13., 1., 2., 5., 6., 4., 10., 14., 35., 16., 46., 19., 30., 6., 14., 2., 10., 5., 4., 1., 4., 1., 16., 5., 0., 4., 8., 7., 3., 0., 12., 6., 2., 0., 5., 5., 3., 30., 4., 6., 1., 13., 3., 15., 1., 6., 2., 2., 25., 5., 37., 8., 5., 11., 6., 27., 9., 18., 7.,

15., 4., 2., 2., 25., 3., 31., 3., 17., 154., 6., 33., 204., 5., 18., 6., 1., 12., 101., 2., 21., 294., 44., 331., 41., 18., 1., 0., 10., 7., 50., 30., 234., 42., 9., 155., 15., 31., 3., 0., 2., 20., 10., 76., 21., 86., 13., 37., 45., 9., 3., 1., 19., 10., 36., 9., 47., 12., 35., 7., 7., 9., 2., 0., 1., 0., 25., 8., 11., 7., 24., 6., 11., 7., 4., 1., 1., 1., 3., 3., 11., 3., 4., 5., 4., 0., 0., 4., 140., 9., 1756., 74., 86., 201., 102., 103., 78., 18., 10., 32., 6., 3., 3., 6., 4., 2., 5., 7., 32., 27., 27., 24., 39., 9., 8., 5., 9., 4., 1., 1., 0., 3., 6., 1., 0., 6., 5., 13., 4., 0., 16., 3., 0., 0., 5., 8., 2., 34., 3., 10., 2., 15., 1., 20., 7., 3., 3., 2., 25., 1., 38., 7., 3., 8., 9., 27., 7., 20., 3.,

17., 2., 1., 12., 37., 3., 27., 1., 16., 160., 2., 19., 212., 11., 20., 9., 0., 9., 87., 1., 10., 315., 43., 316., 40., 18., 1., 2., 11., 10., 45., 41., 258., 43., 10., 180., 10., 47., 10., 0., 0., 22., 8., 61., 13., 93., 17., 31., 35., 10., 4., 0., 18., 5., 38., 10., 54., 10., 30., 8., 12., 5., 3., 0., 2., 0., 22., 6., 12., 3., 37., 7., 5., 4., 3., 1., 0., 0., 5., 1., 9., 4., 7., 1., 13., 1., 0., 2., 151., 11., 1908., 74., 104., 235., 93., 107., 70., 25., 11., 15., 9., 0., 0., 3., 6., 3., 12., 13., 40., 21., 24., 13., 54., 10., 8., 3., 5., 6., 6., 2., 2., 4., 10., 3., 0., 3., 10., 9., 2., 0., 15., 4., 0., 0., 4., 6., 4., 27., 3., 21., 4., 16., 2., 25., 2., 1., 5., 7., 27., 4., 35., 11., 6., 5., 7., 26., 5., 9., 4.,

13., 2., 3., 10., 35., 8., 34., 1., 17., 172., 2., 39., 184., 6., 22., 7., 0., 2., 88., 0., 16., 313., 51., 321., 45., 23., 2., 2., 5., 7., 48., 40., 248., 31., 6., 161., 23., 52., 8., 0., 3., 9., 5., 79., 18., 93., 15., 46., 41., 15., 1., 0., 27., 8., 33., 11., 53., 6., 23., 7., 11., 9., 2., 0., 2., 0., 22., 6., 17., 3., 24., 4., 10., 4., 1., 5., 0., 0., 7., 1., 12., 4., 11., 3., 6., 0., 0., 7., 137., 3., 1941., 81., 97., 218., 79., 116., 75., 11., 14., 12., 15., 1., 4., 5., 5., 3., 10., 9., 39., 19., 39., 16., 36., 8., 15., 5., 5., 11., 6., 0., 1., 3., 9., 7., 0., 3., 6., 16., 2., 0., 14., 5., 1., 0., 3., 4., 1., 37., 2., 8., 1., 8., 3., 19., 3., 3., 4., 5., 26., 7., 33., 7., 8., 3., 1., 32., 9., 14., 3.,

10., 5., 2., 13., 24., 4., 28., 3., 22., 173., 6., 29., 210., 6., 14., 7., 2., 7., 102., 2., 19., 327., 50., 347., 46., 18., 2., 3., 6., 7., 46., 33., 234., 40., 13., 156., 12., 28., 6., 0., 3., 20., 8., 77., 23., 90., 18., 23., 37., 17., 3., 1., 25., 7., 33., 9., 40., 8., 38., 6., 13., 6., 1., 0., 1., 0., 31., 8., 13., 2., 31., 5., 11., 6., 2., 4., 1., 1., 2., 2., 14., 1., 9., 1., 4., 0., 1., 3., 137., 8., 1829., 81., 104., 217., 90., 110., 74., 19., 6., 12., 20., 1., 4., 6., 6., 2., 12., 6., 45., 18., 32., 17., 49., 4., 11., 1., 3., 11., 8., 3., 3., 2., 8., 3., 0., 3., 5., 16., 3., 0., 8., 4., 3., 0., 3., 1., 0., 34., 2., 14., 2., 11., 1., 20., 1., 2., 2., 3., 28., 6., 23., 6., 9., 6., 4., 37., 8., 10., 5.,

10., 2., 3., 8., 24., 8., 42., 2., 10., 160., 6., 30., 217., 1., 13., 6., 1., 1., 93., 1., 16., 299., 40., 311., 46., 17., 1., 4., 11., 11., 41., 32., 247., 36., 5., 141., 15., 48., 9., 0., 0., 17., 12., 78., 15., 82., 7., 27., 48., 11., 3., 0., 25., 6., 41., 9., 55., 9., 27., 9., 2., 4., 2., 0., 1., 0., 28., 10., 21., 5., 29., 6., 6., 8., 2., 1., 3., 1., 1., 1., 7., 2., 4., 0., 9., 2., 1., 2., 134., 7., 1916., 85., 113., 227., 114., 119., 93., 13., 13., 15., 13., 1., 2., 5., 6., 0., 14., 15., 36., 12., 22., 20., 36., 5., 10., 5., 4., 6., 2., 3., 3., 2., 10., 2., 0., 4., 4., 19., 0., 0., 11., 2., 2., 0., 4., 4., 3., 32., 1., 13., 4., 9., 1., 15., 4., 3., 2., 3., 20., 5., 38., 4., 3., 8., 5., 37., 7., 9., 6.,

5., 1., 2., 5., 29., 4., 38., 0., 16., 163., 6., 28., 209., 4., 11., 4., 1., 8., 84., 3., 15., 277., 45., 312., 42., 15., 0., 3., 4., 7., 46., 33., 233., 39., 3., 167., 15., 38., 4., 0., 1., 15., 7., 72., 16., 90., 15., 37., 45., 14., 1., 1., 23., 6., 39., 12., 50., 7., 38., 7., 3., 12., 2., 0., 1., 0., 25., 6., 12., 4., 30., 2., 10., 4., 4., 3., 3., 2., 4., 1., 11., 1., 13., 3., 9., 3., 1., 4., 138., 9., 1855., 105., 126., 228., 94., 136., 62., 14., 21., 23., 6., 0., 4., 6., 4., 11., 5., 9., 35., 21., 32., 16., 44., 6., 10., 2., 4., 1., 2., 1., 0., 5., 7., 4., 0., 4., 4., 15., 0., 0., 4., 7., 7., 0., 4., 1., 2., 40., 2., 7., 1., 13., 2., 19., 4., 2., 4., 2., 27., 5., 46., 10., 4., 6., 6., 31., 10., 8., 6.,

14., 1., 5., 6., 25., 2., 20., 1., 14., 168., 2., 20., 186., 2., 22., 4., 2., 5., 107., 2., 11., 257., 43., 324., 52., 18., 0., 1., 6., 6., 51., 42., 206., 48., 7., 172., 13., 49., 5., 0., 1., 13., 9., 77., 18., 85., 17., 29., 48., 9., 6., 0., 16., 5., 35., 8., 53., 7., 29., 6., 9., 3., 3., 0., 1., 0., 22., 2., 15., 5., 21., 3., 15., 4., 1., 1., 0., 1., 1., 0., 9., 7., 6., 0., 11., 1., 2., 3., 142., 5., 1757., 75., 103., 190., 81., 110., 68., 13., 10., 19., 15., 0., 1., 10., 6., 7., 8., 12., 31., 15., 32., 27., 37., 6., 9., 5., 3., 5., 1., 1., 3., 5., 5., 3., 0., 6., 6., 15., 5., 0., 9., 4., 5., 0., 7., 2., 2., 26., 1., 11., 3., 11., 3., 26., 4., 0., 4., 5., 20., 4., 33., 4., 5., 11., 4., 32., 2., 10., 4.,

5., 1., 4., 6., 22., 9., 32., 2., 21., 170., 7., 26., 212., 5., 18., 6., 2., 5., 83., 2., 19., 293., 42., 339., 36., 18., 0., 1., 8., 5., 47., 38., 213., 44., 6., 140., 17., 28., 3., 0., 2., 16., 8., 85., 24., 90., 14., 38., 52., 10., 3., 1., 30., 7., 31., 11., 42., 10., 25., 8., 12., 10., 1., 0., 2., 0., 28., 3., 8., 2., 29., 4., 14., 4., 4., 6., 0., 0., 4., 1., 4., 3., 10., 5., 3., 1., 0., 3., 139., 6., 1879., 80., 94., 218., 108., 133., 71., 12., 12., 18., 12., 1., 2., 4., 3., 3., 7., 6., 31., 16., 38., 11., 42., 8., 9., 4., 4., 6., 3., 1., 4., 1., 7., 3., 0., 5., 3., 17., 4., 0., 6., 5., 3., 0., 8., 7., 0., 47., 2., 16., 4., 12., 5., 19., 3., 2., 2., 4., 25., 5., 43., 10., 6., 8., 2., 25., 3., 12., 3.,

8., 3., 3., 10., 24., 8., 33., 2., 14., 171., 2., 36., 201., 4., 16., 6., 0., 4., 71., 1., 13., 272., 47., 328., 47., 17., 0., 3., 8., 3., 39., 35., 205., 33., 8., 149., 17., 36., 9., 0., 3., 18., 6., 88., 21., 71., 17., 25., 47., 24., 3., 0., 34., 15., 47., 10., 52., 10., 29., 6., 11., 6., 4., 0., 0., 0., 19., 7., 8., 4., 26., 3., 13., 4., 3., 2., 1., 0., 0., 3., 10., 3., 6., 2., 5., 1., 2., 1., 137., 7., 1922., 108., 97., 228., 104., 123., 59., 19., 11., 16., 10., 0., 2., 9., 4., 5., 3., 7., 34., 11., 41., 20., 32., 4., 13., 2., 9., 8., 6., 3., 4., 1., 7., 4., 0., 7., 3., 11., 1., 0., 14., 5., 2., 0., 6., 3., 2., 37., 2., 11., 4., 7., 3., 25., 2., 6., 6., 3., 17., 6., 35., 5., 6., 3., 5., 26., 10., 9., 2.,

21., 0., 2., 13., 27., 5., 43., 0., 22., 154., 4., 25., 187., 7., 11., 5., 0., 4., 98., 1., 11., 251., 45., 331., 52., 14., 2., 5., 10., 5., 55., 36., 232., 34., 5., 183., 11., 35., 5., 0., 2., 15., 7., 66., 18., 90., 23., 29., 47., 10., 8., 1., 36., 9., 37., 18., 44., 10., 27., 8., 6., 5., 2., 0., 1., 0., 25., 4., 12., 4., 41., 8., 11., 3., 2., 6., 1., 3., 5., 1., 10., 4., 12., 4., 10., 1., 1., 5., 156., 8., 1855., 112., 88., 221., 100., 97., 75., 17., 11., 21., 7., 0., 0., 4., 2., 1., 9., 8., 38., 14., 40., 16., 32., 12., 12., 2., 4., 7., 5., 1., 3., 3., 6., 4., 0., 3., 5., 17., 2., 0., 11., 4., 2., 0., 12., 3., 0., 32., 4., 13., 2., 9., 4., 19., 2., 6., 2., 5., 25., 2., 32., 3., 5., 7., 4., 28., 7., 14., 1.,

8., 3., 2., 12., 29., 6., 31., 1., 13., 149., 3., 25., 220., 7., 16., 12., 0., 6., 89., 3., 15., 296., 41., 380., 41., 20., 1., 3., 6., 3., 33., 39., 254., 36., 12., 128., 10., 38., 11., 0., 3., 21., 8., 69., 26., 61., 7., 38., 55., 13., 3., 1., 26., 9., 43., 7., 57., 17., 30., 7., 7., 9., 0., 0., 0., 0., 23., 5., 6., 3., 34., 7., 15., 3., 4., 1., 3., 0., 2., 2., 8., 4., 7., 1., 9., 0., 1., 2., 137., 12., 1921., 98., 93., 238., 101., 96., 53., 11., 12., 11., 15., 3., 3., 6., 4., 4., 7., 9., 34., 15., 34., 8., 41., 6., 12., 11., 4., 4., 6., 0., 1., 5., 9., 3., 0., 2., 7., 12., 2., 0., 20., 7., 2., 0., 3., 4., 3., 29., 3., 23., 7., 12., 6., 17., 5., 3., 1., 6., 20., 7., 38., 10., 8., 5., 3., 30., 8., 12., 7.,

8., 2., 5., 6., 20., 4., 32., 1., 16., 150., 4., 34., 224., 6., 17., 5., 2., 7., 89., 2., 14., 284., 50., 342., 45., 15., 0., 1., 5., 6., 45., 40., 213., 51., 14., 150., 12., 36., 2., 0., 2., 16., 6., 65., 18., 100., 6., 36., 47., 14., 4., 1., 25., 2., 40., 11., 53., 3., 31., 3., 10., 5., 3., 0., 0., 0., 37., 3., 13., 1., 35., 3., 19., 9., 0., 6., 1., 2., 2., 3., 10., 1., 10., 2., 6., 1., 1., 4., 146., 6., 1894., 91., 92., 227., 89., 112., 63., 13., 12., 23., 14., 1., 5., 5., 4., 3., 13., 7., 44., 11., 40., 18., 29., 7., 9., 3., 8., 8., 3., 3., 3., 4., 8., 7., 0., 4., 6., 13., 3., 0., 9., 6., 2., 0., 1., 3., 2., 21., 4., 15., 1., 11., 3., 15., 2., 5., 1., 2., 31., 4., 34., 9., 6., 8., 10., 21., 6., 10., 5.,

21., 4., 1., 7., 19., 11., 24., 1., 15., 159., 3., 23., 212., 1., 20., 8., 1., 7., 83., 3., 20., 290., 58., 295., 42., 18., 0., 2., 3., 3., 48., 28., 221., 42., 7., 160., 4., 44., 6., 0., 2., 18., 5., 70., 21., 95., 21., 31., 49., 14., 5., 0., 18., 7., 32., 8., 65., 15., 41., 8., 13., 10., 1., 0., 0., 0., 17., 3., 17., 8., 38., 6., 9., 6., 0., 4., 1., 0., 1., 2., 10., 4., 6., 5., 12., 0., 0., 2., 142., 11., 1875., 109., 105., 217., 100., 108., 75., 13., 5., 19., 12., 1., 3., 5., 5., 1., 14., 6., 33., 20., 30., 18., 39., 12., 11., 2., 7., 9., 2., 2., 3., 3., 6., 2., 0., 4., 6., 18., 0., 0., 12., 1., 0., 0., 6., 2., 2., 29., 5., 8., 3., 19., 3., 25., 2., 3., 2., 6., 23., 3., 33., 6., 2., 10., 7., 38., 3., 12., 1.,

11., 2., 1., 6., 23., 7., 36., 1., 12., 148., 5., 23., 214., 8., 15., 6., 2., 4., 95., 2., 16., 285., 38., 319., 45., 23., 2., 2., 3., 3., 52., 37., 246., 37., 9., 168., 13., 38., 6., 0., 1., 20., 8., 72., 14., 76., 14., 30., 45., 17., 4., 3., 29., 5., 41., 14., 51., 9., 29., 9., 10., 10., 3., 0., 1., 0., 28., 7., 22., 4., 38., 5., 21., 7., 4., 4., 1., 1., 8., 3., 11., 1., 9., 6., 4., 0., 1., 2., 147., 9., 1937., 82., 92., 195., 81., 119., 58., 13., 10., 22., 14., 1., 1., 7., 4., 2., 14., 7., 36., 29., 29., 14., 37., 7., 6., 3., 2., 7., 5., 5., 6., 2., 9., 2., 0., 2., 3., 15., 2., 0., 6., 3., 2., 0., 5., 4., 6., 32., 6., 10., 3., 9., 3., 19., 5., 4., 0., 6., 25., 7., 39., 5., 4., 5., 3., 22., 6., 10., 6.,

14., 5., 1., 1., 26., 3., 28., 0., 17., 173., 2., 17., 186., 7., 21., 5., 0., 5., 100., 1., 10., 270., 54., 346., 41., 17., 0., 2., 11., 5., 41., 31., 227., 37., 8., 174., 15., 40., 8., 0., 0., 18., 6., 71., 22., 93., 20., 43., 35., 14., 2., 2., 19., 7., 32., 13., 67., 12., 42., 7., 9., 9., 1., 0., 3., 0., 17., 1., 10., 2., 21., 7., 13., 11., 1., 2., 2., 2., 3., 3., 20., 3., 7., 3., 8., 0., 0., 2., 144., 6., 1892., 93., 92., 229., 103., 129., 57., 13., 10., 27., 19., 0., 1., 5., 4., 6., 11., 14., 40., 19., 30., 18., 33., 10., 9., 7., 6., 6., 2., 2., 1., 1., 6., 5., 0., 3., 7., 17., 4., 0., 14., 1., 5., 0., 8., 1., 1., 48., 3., 9., 2., 17., 1., 19., 5., 3., 7., 9., 17., 9., 22., 5., 2., 5., 7., 26., 5., 15., 5.,

17., 1., 3., 10., 23., 7., 30., 1., 14., 149., 3., 27., 215., 5., 18., 7., 1., 6., 88., 0., 20., 270., 42., 311., 40., 17., 0., 2., 11., 1., 37., 30., 255., 41., 10., 170., 12., 43., 5., 0., 5., 15., 12., 88., 21., 80., 16., 28., 34., 13., 3., 0., 27., 6., 48., 13., 45., 6., 17., 10., 11., 5., 3., 0., 0., 0., 21., 5., 4., 2., 31., 4., 20., 8., 3., 3., 0., 0., 4., 1., 12., 4., 7., 2., 5., 2., 1., 8., 143., 9., 1877., 84., 102., 231., 112., 108., 79., 16., 4., 16., 11., 1., 5., 6., 6., 6., 10., 9., 41., 19., 32., 16., 39., 10., 12., 1., 4., 9., 10., 3., 0., 3., 11., 3., 0., 6., 4., 21., 1., 0., 11., 3., 4., 0., 5., 3., 3., 27., 4., 10., 1., 7., 1., 21., 1., 3., 4., 8., 25., 6., 36., 9., 6., 7., 4., 23., 4., 12., 4.,

12., 3., 3., 6., 34., 3., 26., 0., 18., 158., 1., 20., 199., 2., 23., 7., 1., 6., 71., 3., 9., 265., 49., 294., 41., 18., 0., 1., 10., 3., 51., 33., 236., 40., 8., 164., 13., 31., 11., 0., 2., 21., 3., 88., 13., 94., 17., 26., 50., 9., 2., 0., 29., 9., 37., 14., 48., 10., 31., 8., 10., 6., 3., 0., 1., 0., 23., 8., 21., 4., 17., 5., 9., 3., 0., 3., 0., 0., 2., 3., 10., 5., 4., 2., 8., 1., 0., 6., 124., 9., 1952., 86., 99., 220., 80., 103., 66., 19., 10., 16., 14., 1., 4., 4., 9., 2., 7., 11., 45., 17., 32., 13., 35., 5., 9., 5., 6., 5., 5., 2., 3., 4., 9., 3., 0., 1., 4., 20., 2., 0., 10., 5., 5., 0., 6., 0., 1., 27., 2., 9., 3., 17., 2., 26., 6., 2., 4., 4., 30., 6., 27., 5., 8., 3., 7., 34., 8., 5., 5.,

14., 3., 6., 8., 29., 4., 34., 1., 21., 150., 3., 33., 201., 3., 11., 4., 1., 5., 84., 3., 15., 270., 47., 321., 52., 19., 3., 3., 7., 1., 48., 34., 197., 42., 7., 155., 15., 36., 6., 0., 4., 11., 10., 80., 17., 78., 13., 34., 48., 14., 2., 0., 31., 4., 31., 9., 52., 10., 33., 3., 10., 10., 3., 0., 1., 0., 33., 5., 16., 1., 31., 7., 7., 8., 2., 6., 2., 0., 4., 1., 14., 0., 7., 3., 9., 1., 1., 7., 136., 12., 1918., 94., 101., 220., 92., 111., 82., 21., 12., 18., 9., 0., 3., 6., 5., 5., 10., 5., 30., 14., 43., 13., 44., 10., 10., 3., 2., 5., 4., 1., 6., 4., 8., 4., 0., 4., 6., 18., 1., 0., 8., 4., 1., 0., 1., 2., 3., 35., 0., 4., 2., 11., 1., 17., 1., 2., 2., 8., 19., 6., 33., 3., 6., 8., 7., 35., 9., 17., 3.,

10., 0., 0., 3., 13., 5., 5., 1., 6., 8., 2., 9., 17., 3., 15., 5., 2., 1., 26., 1., 3., 34., 10., 12., 25., 4., 3., 0., 3., 2., 6., 3., 29., 16., 4., 25., 5., 15., 11., 4., 0., 3., 3., 9., 7., 15., 52., 18., 22., 12., 5., 1., 4., 2., 11., 5., 10., 8., 9., 10., 5., 31., 10., 2., 0., 2., 4., 1., 5., 2., 3., 4., 3., 3., 4., 4., 3., 1., 3., 1., 1., 0., 0., 5., 1., 5., 1., 8., 1., 1., 8., 2., 0., 3., 1., 7., 1., 0., 0., 3., 5., 4., 1., 1., 0., 0., 4., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 5., 3., 12., 1., 2., 1., 1., 21., 1., 15., 21., 1., 20., 5., 3., 2., 19., 0., 3., 20., 12., 26., 31., 4., 0., 2., 4., 1., 9., 7., 28., 15., 1., 12., 1., 11., 6., 1., 0., 3., 2., 10., 12., 19., 43., 13., 19., 7., 5., 1., 6., 1., 5., 2., 6., 7., 5., 17., 7., 17., 7., 2., 0., 3., 9., 1., 2., 2., 2., 2., 1., 4., 3., 5., 9., 2., 0., 3., 6., 0., 1., 1., 2., 10., 2., 3., 3., 1., 3., 0., 2., 0., 4., 8., 2., 0., 3., 0., 1., 2., 3., 2., 2., 0., 3., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 4., 3., 7., 3., 7., 2., 4., 19., 0., 4., 17., 2., 14., 1., 0., 2., 16., 2., 3., 24., 14., 22., 22., 7., 3., 1., 7., 1., 5., 8., 22., 17., 6., 20., 5., 11., 9., 1., 1., 7., 0., 12., 13., 24., 47., 12., 17., 11., 3., 2., 8., 3., 0., 5., 12., 6., 8., 15., 3., 13., 5., 3., 1., 1., 6., 2., 4., 2., 6., 2., 6., 2., 1., 3., 7., 3., 0., 2., 3., 0., 3., 2., 0., 6., 2., 2., 2., 1., 5., 2., 3., 0., 2., 8., 0., 0., 3., 2., 2., 1., 2., 3., 2., 2., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 2., 4., 8., 5., 3., 2., 5., 14., 2., 11., 10., 2., 17., 3., 3., 1., 18., 0., 6., 30., 9., 27., 27., 8., 0., 0., 6., 2., 7., 5., 21., 6., 3., 20., 3., 15., 11., 2., 0., 9., 3., 16., 9., 30., 48., 10., 23., 10., 8., 3., 6., 3., 16., 5., 7., 1., 11., 18., 4., 26., 6., 6., 4., 0., 10., 1., 3., 3., 10., 1., 4., 6., 2., 6., 2., 1., 0., 3., 5., 0., 4., 4., 1., 10., 4., 3., 4., 1., 6., 0., 1., 0., 1., 6., 1., 0., 1., 0., 2., 0., 5., 4., 1., 1., 6., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

17., 2., 3., 5., 10., 4., 7., 1., 5., 16., 2., 17., 18., 0., 17., 3., 0., 5., 20., 2., 4., 22., 11., 24., 25., 3., 0., 0., 2., 2., 3., 9., 14., 19., 3., 25., 5., 15., 8., 4., 1., 7., 3., 12., 14., 11., 62., 8., 25., 6., 4., 2., 2., 5., 9., 6., 4., 4., 3., 12., 4., 23., 14., 5., 0., 2., 4., 2., 1., 4., 3., 5., 5., 7., 4., 4., 3., 3., 1., 2., 3., 0., 1., 3., 1., 3., 1., 3., 2., 1., 4., 2., 2., 0., 4., 9., 0., 0., 2., 4., 2., 3., 1., 1., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 1., 4., 3., 4., 9., 2., 6., 13., 0., 11., 21., 2., 17., 2., 0., 3., 15., 1., 5., 22., 14., 23., 24., 5., 0., 1., 7., 2., 10., 15., 17., 20., 3., 12., 0., 21., 8., 7., 0., 2., 2., 20., 13., 24., 47., 9., 24., 7., 5., 1., 3., 0., 10., 6., 6., 4., 10., 12., 9., 26., 10., 1., 1., 1., 4., 2., 0., 1., 6., 2., 6., 4., 4., 4., 3., 2., 1., 2., 0., 0., 1., 1., 2., 2., 1., 2., 2., 0., 10., 3., 1., 1., 2., 3., 4., 0., 3., 1., 3., 1., 0., 3., 2., 0., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 4., 0., 5., 4., 3., 0., 6., 22., 0., 12., 22., 0., 19., 1., 0., 0., 25., 1., 6., 17., 18., 20., 21., 7., 3., 0., 5., 2., 10., 5., 21., 24., 1., 12., 4., 11., 5., 2., 0., 1., 1., 15., 15., 21., 50., 16., 26., 13., 1., 1., 3., 3., 3., 3., 11., 6., 7., 25., 8., 12., 9., 3., 0., 4., 9., 1., 2., 2., 5., 3., 7., 8., 0., 3., 3., 1., 0., 3., 4., 0., 3., 1., 2., 5., 1., 2., 2., 2., 4., 2., 4., 2., 3., 6., 0., 0., 2., 4., 4., 2., 3., 4., 2., 1., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 2., 3., 8., 3., 8., 1., 8., 26., 1., 14., 16., 1., 11., 3., 1., 0., 22., 1., 1., 17., 9., 26., 24., 5., 0., 0., 7., 2., 10., 6., 24., 15., 0., 15., 5., 15., 15., 0., 0., 3., 1., 18., 9., 24., 41., 14., 17., 7., 4., 1., 6., 2., 3., 3., 10., 7., 5., 18., 3., 24., 10., 5., 0., 2., 4., 0., 4., 2., 5., 2., 7., 3., 3., 6., 2., 3., 3., 2., 2., 0., 5., 2., 5., 3., 2., 4., 2., 2., 4., 0., 1., 2., 4., 4., 5., 0., 2., 1., 2., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 3., 8., 11., 2., 7., 0., 12., 21., 2., 13., 18., 1., 14., 3., 2., 3., 19., 3., 3., 25., 19., 28., 27., 6., 2., 0., 1., 3., 11., 10., 26., 15., 2., 14., 4., 15., 10., 2., 2., 5., 1., 11., 12., 11., 45., 15., 21., 13., 5., 1., 4., 8., 4., 4., 8., 5., 8., 11., 3., 16., 12., 1., 4., 4., 5., 0., 1., 1., 4., 2., 3., 5., 0., 5., 3., 4., 1., 3., 1., 0., 1., 1., 0., 4., 2., 2., 4., 2., 2., 1., 3., 1., 1., 6., 5., 0., 1., 2., 5., 3., 2., 2., 2., 2., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 3., 6., 11., 4., 4., 1., 1., 20., 0., 14., 22., 1., 18., 4., 0., 1., 10., 2., 5., 13., 17., 37., 26., 7., 2., 2., 3., 1., 11., 6., 30., 22., 5., 16., 5., 16., 10., 6., 2., 3., 2., 9., 13., 25., 51., 14., 33., 12., 4., 1., 5., 1., 5., 5., 11., 9., 4., 12., 4., 26., 2., 4., 1., 1., 7., 1., 1., 3., 11., 5., 2., 3., 5., 3., 0., 4., 0., 1., 3., 0., 2., 2., 1., 3., 2., 3., 0., 3., 3., 2., 2., 0., 4., 8., 2., 0., 4., 2., 1., 1., 1., 1., 0., 3., 1., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 4., 4., 11., 3., 3., 1., 6., 18., 3., 15., 27., 1., 15., 1., 1., 0., 25., 2., 4., 29., 9., 19., 19., 5., 2., 0., 2., 1., 5., 9., 32., 20., 4., 16., 5., 10., 5., 0., 1., 5., 1., 13., 12., 12., 42., 11., 31., 9., 6., 2., 1., 2., 7., 5., 8., 2., 6., 18., 9., 23., 13., 0., 0., 1., 8., 2., 4., 1., 4., 1., 2., 3., 0., 5., 2., 1., 0., 1., 7., 0., 0., 0., 2., 2., 1., 2., 3., 0., 4., 0., 7., 0., 3., 5., 1., 0., 3., 1., 3., 1., 3., 0., 1., 0., 0., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 4., 2., 5., 2., 9., 1., 6., 30., 0., 17., 32., 1., 12., 4., 1., 2., 12., 2., 6., 32., 15., 21., 29., 11., 0., 0., 3., 0., 7., 10., 33., 19., 7., 13., 3., 15., 7., 3., 1., 4., 0., 12., 6., 21., 44., 10., 33., 8., 6., 0., 4., 0., 9., 4., 11., 3., 7., 11., 5., 15., 9., 1., 0., 2., 5., 2., 1., 3., 4., 2., 6., 4., 2., 4., 1., 1., 1., 0., 3., 0., 3., 2., 2., 8., 4., 7., 5., 2., 3., 1., 2., 1., 5., 9., 6., 0., 4., 1., 2., 2., 3., 5., 0., 2., 2., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

18., 3., 4., 8., 33., 9., 40., 1., 18., 172., 4., 25., 202., 7., 15., 5., 1., 4., 79., 2., 15., 306., 50., 350., 52., 19., 1., 3., 6., 4., 36., 25., 214., 48., 7., 150., 15., 29., 5., 0., 1., 13., 15., 82., 17., 95., 12., 34., 35., 7., 2., 0., 29., 3., 29., 11., 50., 13., 16., 4., 14., 11., 3., 0., 2., 0., 19., 6., 8., 6., 19., 8., 22., 3., 2., 4., 0., 3., 2., 3., 8., 5., 13., 4., 10., 0., 0., 4., 136., 5., 1896., 86., 83., 236., 91., 111., 90., 14., 16., 14., 21., 3., 2., 4., 4., 4., 8., 6., 39., 12., 43., 16., 46., 5., 12., 4., 7., 6., 6., 4., 7., 1., 3., 6., 0., 2., 4., 12., 3., 0., 8., 7., 1., 0., 3., 2., 2., 25., 3., 11., 7., 20., 2., 16., 7., 2., 3., 1., 32., 6., 32., 3., 4., 4., 3., 37., 4., 12., 6.,

18., 3., 2., 10., 24., 9., 29., 2., 13., 155., 3., 30., 205., 6., 18., 7., 1., 6., 87., 2., 18., 257., 54., 319., 39., 17., 0., 1., 3., 3., 41., 28., 194., 42., 9., 174., 15., 45., 3., 0., 0., 14., 8., 85., 17., 91., 16., 41., 49., 10., 5., 2., 32., 5., 40., 4., 41., 8., 32., 4., 11., 9., 4., 0., 1., 0., 27., 4., 11., 1., 29., 7., 8., 3., 3., 3., 0., 1., 1., 3., 17., 4., 12., 3., 3., 1., 1., 4., 130., 6., 1880., 85., 86., 222., 103., 116., 65., 15., 19., 17., 13., 2., 3., 8., 0., 5., 8., 8., 29., 27., 28., 11., 42., 3., 14., 5., 3., 7., 1., 3., 6., 3., 8., 2., 0., 2., 4., 18., 4., 0., 13., 3., 4., 0., 5., 5., 3., 28., 1., 13., 9., 12., 8., 20., 1., 4., 4., 3., 25., 5., 33., 4., 3., 10., 5., 42., 11., 14., 3.,

8., 3., 4., 9., 24., 4., 37., 0., 21., 179., 3., 34., 240., 7., 17., 5., 0., 4., 88., 4., 8., 289., 48., 370., 37., 17., 2., 3., 6., 6., 51., 24., 206., 37., 9., 163., 13., 40., 5., 0., 4., 15., 6., 88., 17., 109., 13., 28., 45., 13., 2., 1., 21., 6., 33., 5., 53., 7., 38., 6., 12., 12., 2., 0., 0., 0., 21., 3., 18., 1., 30., 5., 15., 6., 4., 1., 2., 0., 2., 2., 9., 3., 15., 2., 12., 3., 2., 2., 144., 5., 1875., 98., 94., 224., 103., 90., 80., 16., 11., 18., 14., 2., 2., 7., 4., 4., 7., 10., 38., 19., 34., 25., 43., 6., 12., 4., 7., 9., 5., 0., 3., 3., 8., 5., 0., 4., 5., 16., 3., 0., 11., 2., 6., 0., 2., 1., 3., 31., 0., 13., 3., 16., 2., 14., 3., 2., 0., 5., 20., 8., 22., 5., 3., 12., 10., 36., 6., 14., 8.,

10., 5., 4., 9., 25., 6., 26., 1., 14., 161., 2., 20., 203., 7., 15., 7., 2., 5., 85., 5., 20., 330., 44., 351., 42., 23., 0., 2., 9., 6., 36., 33., 232., 35., 7., 142., 18., 48., 9., 0., 2., 15., 8., 88., 13., 84., 14., 33., 42., 15., 2., 1., 24., 7., 49., 14., 49., 9., 39., 8., 11., 7., 2., 0., 1., 0., 25., 5., 17., 1., 31., 10., 16., 5., 5., 3., 1., 1., 1., 1., 11., 2., 7., 2., 11., 2., 3., 2., 141., 8., 1924., 87., 89., 217., 93., 129., 65., 15., 13., 13., 8., 1., 5., 9., 4., 5., 6., 6., 35., 18., 34., 18., 38., 6., 11., 8., 8., 8., 9., 0., 4., 1., 8., 4., 0., 3., 3., 15., 3., 0., 6., 4., 4., 0., 4., 2., 0., 28., 2., 9., 4., 14., 3., 24., 2., 4., 4., 2., 23., 3., 35., 8., 11., 8., 3., 34., 5., 10., 8.,

22., 1., 2., 7., 17., 4., 36., 0., 14., 167., 4., 24., 207., 6., 17., 11., 3., 6., 97., 3., 12., 264., 54., 352., 37., 17., 0., 1., 11., 7., 50., 45., 209., 31., 7., 136., 15., 35., 3., 0., 1., 19., 8., 73., 21., 89., 13., 43., 38., 21., 2., 0., 25., 4., 34., 8., 48., 8., 33., 9., 3., 9., 1., 0., 0., 0., 29., 2., 11., 3., 29., 3., 9., 6., 2., 2., 0., 0., 7., 2., 8., 1., 6., 2., 11., 0., 1., 5., 162., 13., 1917., 107., 116., 201., 89., 107., 58., 23., 12., 17., 16., 0., 3., 4., 5., 0., 8., 9., 41., 20., 32., 21., 42., 2., 11., 3., 8., 10., 5., 4., 3., 2., 8., 3., 0., 1., 0., 11., 2., 0., 11., 1., 0., 0., 6., 2., 2., 34., 0., 10., 7., 7., 2., 16., 0., 3., 2., 2., 33., 4., 35., 8., 9., 11., 3., 25., 11., 7., 6.,

21., 0., 4., 9., 25., 4., 29., 2., 18., 150., 3., 29., 181., 4., 8., 4., 0., 5., 73., 1., 20., 313., 54., 303., 59., 20., 1., 4., 9., 9., 40., 27., 230., 47., 5., 152., 16., 47., 8., 0., 4., 22., 7., 99., 18., 70., 9., 35., 61., 12., 2., 3., 24., 4., 42., 6., 55., 12., 39., 4., 12., 5., 1., 0., 0., 0., 19., 2., 15., 1., 27., 3., 9., 4., 2., 0., 1., 0., 4., 4., 7., 2., 7., 3., 11., 0., 2., 5., 141., 10., 1832., 92., 101., 213., 99., 120., 74., 13., 15., 13., 12., 1., 3., 5., 4., 4., 8., 9., 46., 12., 36., 15., 37., 9., 11., 6., 5., 9., 2., 5., 3., 4., 13., 2., 0., 4., 3., 15., 1., 0., 7., 5., 3., 0., 5., 4., 1., 35., 3., 13., 1., 16., 2., 15., 2., 1., 3., 1., 31., 4., 34., 8., 4., 9., 7., 32., 6., 16., 6.,

18., 4., 1., 5., 35., 7., 20., 1., 18., 129., 0., 24., 213., 4., 16., 6., 0., 6., 104., 4., 16., 315., 38., 343., 41., 24., 2., 1., 5., 6., 45., 27., 207., 41., 6., 155., 18., 42., 5., 0., 1., 18., 5., 78., 9., 90., 8., 35., 60., 18., 0., 2., 23., 4., 35., 5., 50., 3., 23., 7., 4., 8., 0., 0., 1., 0., 34., 9., 14., 3., 26., 3., 13., 3., 3., 2., 0., 0., 2., 1., 15., 8., 5., 0., 6., 3., 1., 2., 152., 11., 1958., 77., 71., 237., 87., 111., 72., 18., 11., 23., 12., 1., 2., 8., 7., 5., 6., 5., 28., 14., 30., 14., 43., 15., 9., 6., 3., 10., 5., 2., 2., 1., 7., 3., 0., 4., 9., 13., 1., 0., 8., 3., 3., 0., 3., 3., 3., 22., 3., 12., 5., 17., 4., 11., 0., 3., 6., 8., 32., 3., 39., 4., 9., 6., 6., 32., 9., 16., 5.,

7., 0., 2., 4., 28., 8., 29., 0., 18., 152., 2., 22., 199., 3., 22., 6., 1., 5., 96., 1., 13., 294., 58., 330., 36., 14., 0., 4., 6., 6., 39., 41., 242., 44., 11., 144., 8., 43., 10., 0., 2., 17., 9., 88., 19., 71., 15., 38., 45., 15., 5., 0., 25., 6., 36., 19., 35., 7., 28., 0., 8., 7., 2., 0., 2., 0., 19., 6., 13., 3., 33., 7., 14., 8., 3., 1., 0., 0., 3., 0., 13., 5., 14., 1., 13., 2., 1., 5., 142., 9., 1922., 106., 107., 245., 91., 105., 62., 7., 16., 23., 11., 1., 2., 2., 5., 6., 5., 6., 30., 20., 36., 17., 48., 5., 9., 2., 2., 8., 1., 2., 3., 0., 8., 3., 0., 4., 2., 9., 4., 0., 8., 3., 2., 0., 7., 3., 4., 28., 1., 16., 3., 16., 4., 18., 2., 7., 1., 8., 25., 7., 28., 7., 6., 13., 7., 23., 4., 7., 4.,

15., 1., 4., 8., 17., 6., 35., 0., 22., 159., 2., 27., 178., 4., 16., 7., 1., 1., 65., 2., 14., 273., 44., 350., 32., 15., 2., 2., 7., 11., 53., 37., 239., 34., 7., 159., 14., 33., 7., 0., 0., 18., 5., 80., 21., 87., 14., 23., 45., 9., 8., 3., 22., 11., 37., 8., 48., 12., 33., 10., 8., 11., 4., 0., 1., 0., 29., 4., 5., 4., 28., 7., 12., 4., 4., 4., 1., 0., 2., 3., 11., 4., 8., 3., 13., 1., 0., 3., 119., 4., 1931., 87., 118., 219., 114., 119., 74., 17., 15., 23., 13., 1., 2., 7., 3., 5., 4., 9., 38., 10., 46., 22., 34., 4., 6., 4., 7., 10., 4., 1., 3., 3., 7., 6., 0., 4., 7., 18., 1., 0., 12., 5., 3., 0., 2., 4., 8., 25., 5., 13., 3., 20., 2., 30., 3., 3., 2., 0., 33., 2., 27., 5., 4., 5., 3., 35., 6., 6., 5.,

20., 2., 4., 4., 30., 7., 36., 1., 24., 164., 2., 30., 176., 6., 14., 5., 2., 4., 78., 1., 17., 269., 29., 316., 40., 22., 0., 3., 7., 6., 34., 25., 238., 44., 3., 162., 14., 31., 6., 0., 2., 26., 9., 95., 25., 94., 18., 28., 46., 13., 1., 1., 22., 8., 41., 9., 56., 12., 29., 1., 12., 1., 1., 0., 1., 0., 18., 6., 16., 5., 34., 3., 10., 4., 5., 2., 2., 2., 3., 2., 15., 3., 9., 1., 16., 2., 1., 3., 141., 13., 1903., 81., 99., 232., 88., 110., 65., 27., 13., 11., 19., 2., 0., 6., 3., 3., 7., 6., 38., 13., 38., 9., 56., 5., 8., 3., 4., 5., 5., 1., 6., 4., 14., 2., 0., 1., 5., 10., 0., 0., 11., 3., 1., 0., 5., 1., 1., 44., 4., 9., 0., 13., 5., 17., 4., 4., 5., 2., 25., 1., 34., 4., 4., 11., 5., 39., 3., 16., 5.,

17., 4., 3., 9., 27., 9., 31., 2., 16., 179., 6., 32., 223., 6., 22., 7., 0., 3., 87., 1., 10., 257., 46., 348., 52., 25., 0., 0., 6., 5., 43., 34., 248., 45., 6., 144., 9., 35., 4., 0., 1., 19., 6., 75., 13., 99., 16., 31., 44., 7., 4., 0., 21., 9., 40., 12., 52., 7., 43., 11., 9., 5., 0., 0., 2., 0., 26., 6., 15., 2., 38., 1., 17., 3., 1., 0., 2., 2., 3., 1., 14., 4., 13., 0., 9., 0., 0., 4., 155., 9., 1801., 97., 95., 218., 118., 109., 72., 13., 12., 15., 11., 1., 2., 3., 6., 9., 5., 14., 40., 19., 32., 14., 43., 12., 4., 5., 5., 4., 6., 3., 6., 6., 13., 1., 0., 3., 8., 10., 2., 0., 13., 8., 2., 0., 3., 4., 1., 29., 7., 12., 2., 15., 9., 25., 2., 2., 1., 6., 20., 2., 31., 7., 6., 7., 4., 28., 8., 13., 3.,

6., 1., 5., 7., 28., 4., 31., 4., 17., 186., 2., 27., 222., 5., 16., 8., 0., 3., 76., 2., 17., 256., 40., 319., 30., 27., 1., 1., 7., 8., 51., 36., 248., 38., 8., 143., 12., 49., 2., 0., 1., 15., 7., 77., 17., 96., 19., 33., 55., 16., 3., 1., 25., 8., 50., 7., 46., 9., 20., 13., 9., 11., 0., 0., 1., 0., 23., 5., 13., 4., 32., 4., 7., 6., 2., 1., 0., 1., 3., 3., 6., 0., 8., 2., 7., 0., 2., 4., 142., 7., 1840., 95., 112., 219., 95., 98., 67., 11., 20., 20., 10., 2., 3., 5., 6., 7., 7., 4., 38., 19., 29., 16., 35., 8., 12., 3., 6., 4., 4., 4., 1., 2., 6., 2., 0., 2., 4., 11., 1., 0., 13., 0., 1., 0., 5., 1., 4., 29., 3., 14., 3., 7., 1., 13., 4., 5., 0., 5., 16., 6., 32., 10., 6., 5., 7., 24., 2., 8., 5.,

18., 3., 1., 6., 27., 6., 37., 1., 22., 173., 8., 24., 167., 5., 15., 7., 1., 8., 98., 0., 16., 292., 54., 357., 37., 21., 0., 3., 5., 8., 30., 23., 240., 40., 12., 153., 12., 32., 4., 0., 3., 19., 6., 76., 22., 83., 12., 40., 40., 12., 3., 2., 25., 7., 40., 7., 45., 7., 38., 3., 12., 9., 6., 0., 0., 0., 19., 4., 17., 2., 23., 4., 7., 5., 3., 4., 2., 1., 1., 1., 9., 3., 8., 2., 7., 1., 3., 5., 132., 10., 1853., 89., 87., 219., 92., 104., 57., 23., 7., 14., 16., 1., 0., 6., 1., 3., 9., 3., 49., 11., 32., 11., 42., 10., 6., 6., 4., 5., 10., 1., 2., 1., 5., 1., 0., 2., 7., 13., 4., 0., 10., 4., 2., 0., 7., 2., 0., 31., 5., 6., 2., 12., 8., 15., 3., 5., 4., 5., 28., 6., 42., 6., 5., 8., 4., 24., 6., 9., 7.,

9., 4., 3., 4., 23., 2., 28., 0., 13., 174., 3., 26., 183., 6., 14., 6., 0., 2., 105., 3., 14., 318., 46., 301., 42., 24., 1., 1., 7., 8., 45., 29., 238., 41., 5., 141., 7., 29., 5., 0., 3., 14., 7., 80., 14., 93., 16., 38., 52., 10., 2., 0., 26., 10., 45., 11., 54., 10., 30., 5., 12., 8., 2., 0., 0., 0., 18., 5., 15., 3., 27., 6., 9., 9., 3., 0., 0., 1., 4., 1., 13., 2., 6., 4., 6., 1., 1., 3., 156., 11., 1924., 73., 99., 189., 105., 129., 79., 21., 18., 17., 15., 1., 1., 7., 2., 3., 11., 6., 39., 15., 38., 17., 53., 8., 10., 1., 5., 10., 2., 2., 6., 3., 5., 0., 0., 4., 6., 10., 0., 0., 12., 4., 0., 0., 6., 2., 4., 31., 3., 7., 7., 17., 5., 17., 2., 3., 4., 6., 20., 2., 25., 1., 5., 8., 5., 23., 5., 7., 6.,

14., 3., 2., 10., 26., 5., 32., 1., 15., 138., 3., 27., 197., 8., 13., 5., 1., 3., 83., 1., 25., 303., 29., 334., 46., 18., 0., 2., 5., 2., 57., 35., 242., 45., 10., 155., 15., 38., 8., 0., 1., 16., 9., 92., 19., 85., 14., 39., 44., 10., 3., 1., 25., 7., 36., 15., 47., 10., 20., 7., 6., 4., 3., 0., 1., 0., 16., 5., 10., 1., 28., 4., 16., 3., 2., 3., 0., 3., 6., 1., 8., 3., 10., 3., 6., 1., 0., 9., 150., 7., 1913., 84., 91., 220., 101., 100., 56., 16., 7., 11., 15., 0., 4., 7., 4., 2., 8., 9., 41., 17., 32., 11., 29., 10., 15., 1., 3., 8., 6., 0., 4., 3., 5., 2., 0., 2., 3., 13., 2., 0., 9., 5., 2., 0., 3., 2., 3., 35., 1., 14., 4., 15., 6., 15., 2., 2., 4., 8., 24., 3., 31., 5., 5., 5., 8., 32., 7., 9., 4.,

19., 2., 2., 4., 21., 4., 29., 2., 3., 163., 0., 24., 182., 5., 18., 5., 0., 4., 79., 5., 12., 290., 42., 327., 53., 14., 2., 2., 6., 3., 45., 32., 220., 49., 8., 183., 13., 37., 1., 0., 2., 22., 15., 66., 20., 86., 18., 38., 45., 14., 2., 1., 20., 5., 40., 12., 51., 8., 36., 9., 9., 6., 4., 0., 0., 0., 19., 4., 15., 2., 32., 6., 7., 3., 3., 2., 1., 0., 4., 7., 10., 6., 9., 3., 6., 1., 1., 3., 146., 7., 1904., 78., 98., 228., 89., 127., 65., 22., 11., 11., 16., 0., 4., 8., 6., 10., 10., 6., 43., 16., 40., 11., 37., 10., 13., 4., 6., 12., 6., 2., 5., 4., 9., 7., 0., 2., 8., 10., 2., 0., 11., 5., 4., 0., 0., 5., 1., 21., 3., 16., 4., 11., 1., 23., 2., 0., 2., 6., 22., 0., 39., 8., 6., 11., 3., 38., 6., 14., 4.,

9., 1., 0., 6., 20., 6., 39., 1., 21., 151., 2., 23., 206., 6., 20., 6., 0., 7., 81., 1., 19., 294., 53., 353., 43., 17., 0., 3., 7., 6., 44., 32., 236., 40., 7., 158., 13., 48., 6., 0., 2., 10., 11., 85., 18., 93., 11., 33., 44., 8., 2., 2., 44., 6., 45., 5., 49., 12., 26., 8., 11., 8., 3., 0., 3., 0., 22., 4., 9., 5., 27., 7., 11., 5., 2., 5., 2., 0., 3., 1., 11., 1., 7., 4., 16., 3., 1., 5., 123., 12., 1902., 81., 81., 214., 98., 119., 68., 10., 9., 15., 11., 2., 4., 8., 6., 6., 5., 8., 42., 19., 30., 13., 47., 5., 6., 5., 6., 6., 4., 3., 3., 4., 11., 4., 0., 5., 3., 12., 3., 0., 10., 5., 1., 0., 1., 2., 6., 35., 2., 11., 4., 13., 1., 22., 2., 2., 5., 7., 26., 1., 32., 5., 7., 9., 10., 26., 3., 14., 5.,

10., 2., 4., 3., 33., 7., 27., 1., 9., 168., 3., 21., 214., 1., 14., 11., 1., 0., 80., 3., 19., 269., 36., 353., 40., 20., 0., 3., 7., 5., 37., 34., 233., 31., 11., 165., 13., 37., 4., 0., 2., 14., 9., 72., 9., 89., 13., 33., 42., 10., 1., 1., 23., 8., 37., 13., 45., 5., 31., 5., 11., 7., 2., 0., 3., 0., 17., 4., 10., 3., 26., 5., 15., 4., 1., 7., 1., 2., 4., 5., 13., 1., 13., 0., 6., 2., 0., 8., 136., 7., 1836., 88., 110., 226., 106., 115., 72., 14., 15., 17., 12., 0., 1., 4., 4., 2., 11., 10., 38., 11., 32., 22., 47., 7., 4., 2., 8., 10., 4., 6., 1., 2., 6., 3., 0., 7., 6., 13., 4., 0., 10., 7., 4., 0., 4., 6., 5., 14., 2., 12., 2., 13., 3., 23., 4., 3., 9., 2., 40., 5., 32., 5., 3., 6., 9., 24., 9., 14., 3.,

9., 0., 1., 3., 5., 1., 7., 1., 4., 23., 1., 14., 24., 2., 13., 6., 2., 1., 17., 1., 11., 28., 12., 35., 27., 5., 2., 2., 1., 1., 9., 4., 27., 15., 4., 18., 6., 13., 11., 0., 1., 5., 2., 10., 14., 16., 53., 16., 23., 8., 3., 1., 3., 3., 4., 0., 10., 3., 15., 15., 2., 18., 7., 4., 3., 0., 3., 0., 7., 0., 8., 3., 4., 3., 1., 6., 3., 1., 0., 3., 3., 0., 2., 2., 4., 10., 1., 2., 3., 3., 5., 0., 2., 0., 0., 5., 3., 0., 3., 3., 2., 1., 2., 3., 1., 0., 2., 0., 0., 0., 0., 3., 0., 0., 5., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 0., 2., 12., 1., 3., 0., 7., 22., 1., 10., 16., 0., 12., 4., 0., 3., 22., 1., 3., 18., 10., 25., 23., 4., 1., 1., 2., 2., 9., 6., 24., 16., 2., 16., 8., 16., 5., 2., 0., 2., 1., 12., 9., 13., 53., 15., 27., 8., 7., 1., 7., 1., 3., 2., 11., 5., 12., 14., 5., 26., 8., 3., 0., 0., 9., 3., 4., 7., 1., 1., 2., 4., 1., 2., 4., 3., 1., 1., 3., 0., 2., 1., 2., 4., 2., 3., 3., 6., 1., 1., 4., 2., 4., 8., 1., 0., 1., 2., 2., 3., 3., 1., 0., 1., 4., 0., 0., 0., 0., 6., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 6., 7., 6., 3., 2., 2., 4., 24., 2., 14., 22., 0., 9., 2., 0., 2., 13., 1., 3., 14., 23., 28., 27., 8., 1., 1., 4., 1., 7., 7., 15., 19., 2., 6., 5., 15., 11., 0., 0., 3., 1., 9., 14., 20., 50., 16., 14., 12., 4., 0., 4., 2., 13., 5., 15., 9., 6., 12., 3., 12., 5., 3., 2., 0., 11., 1., 6., 0., 2., 4., 2., 7., 1., 8., 4., 3., 1., 1., 3., 0., 2., 1., 3., 3., 1., 3., 0., 0., 5., 1., 2., 0., 3., 6., 0., 0., 0., 3., 5., 1., 3., 1., 0., 0., 4., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 2., 2., 7., 5., 1., 10., 2., 4., 16., 0., 13., 17., 0., 20., 4., 0., 1., 25., 2., 2., 20., 9., 18., 28., 6., 1., 0., 1., 1., 10., 8., 21., 17., 2., 14., 4., 16., 8., 1., 1., 5., 2., 14., 12., 22., 54., 21., 25., 8., 6., 1., 9., 3., 6., 3., 10., 5., 15., 9., 6., 24., 8., 3., 1., 1., 7., 3., 6., 4., 3., 4., 4., 8., 2., 5., 0., 2., 1., 2., 2., 0., 0., 2., 3., 3., 3., 11., 0., 4., 7., 0., 0., 0., 1., 9., 3., 0., 1., 2., 1., 2., 4., 2., 1., 2., 2., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 1., 2., 10., 3., 9., 0., 5., 35., 1., 11., 20., 1., 10., 1., 0., 1., 11., 1., 4., 27., 13., 25., 25., 13., 1., 1., 3., 1., 13., 10., 35., 12., 2., 15., 3., 13., 6., 4., 1., 2., 1., 12., 8., 22., 48., 7., 17., 12., 6., 1., 7., 2., 9., 4., 15., 4., 10., 19., 5., 23., 4., 4., 0., 1., 5., 1., 5., 2., 7., 1., 8., 2., 5., 0., 1., 7., 1., 1., 2., 0., 2., 3., 2., 3., 1., 3., 4., 3., 6., 0., 1., 2., 1., 4., 1., 0., 4., 1., 1., 1., 1., 3., 1., 1., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 4., 8., 2., 5., 0., 9., 19., 0., 16., 26., 1., 12., 0., 0., 2., 13., 1., 3., 15., 7., 14., 17., 4., 1., 2., 2., 5., 6., 4., 24., 13., 6., 18., 3., 22., 10., 1., 2., 1., 2., 12., 12., 18., 37., 9., 17., 7., 3., 2., 6., 4., 6., 5., 7., 4., 9., 13., 11., 15., 9., 1., 1., 1., 7., 2., 1., 3., 6., 4., 3., 4., 3., 4., 4., 3., 1., 1., 1., 0., 2., 1., 1., 5., 3., 2., 1., 3., 1., 3., 0., 0., 5., 10., 2., 0., 1., 3., 2., 3., 0., 1., 0., 1., 0., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 0., 3., 6., 3., 7., 1., 3., 27., 0., 13., 20., 1., 8., 5., 0., 6., 14., 0., 6., 29., 13., 23., 15., 6., 1., 1., 4., 2., 10., 3., 24., 24., 1., 13., 2., 19., 7., 3., 2., 3., 3., 11., 11., 16., 60., 16., 27., 9., 6., 1., 5., 2., 9., 4., 14., 5., 7., 19., 4., 26., 8., 0., 1., 1., 4., 0., 2., 3., 6., 6., 5., 9., 0., 2., 3., 3., 0., 2., 3., 0., 2., 0., 2., 6., 3., 3., 0., 2., 3., 2., 2., 0., 5., 5., 2., 0., 1., 0., 1., 4., 2., 5., 3., 0., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 3., 3., 4., 3., 5., 1., 6., 28., 2., 12., 19., 1., 17., 2., 3., 2., 22., 0., 4., 15., 11., 21., 24., 9., 3., 3., 2., 3., 9., 6., 30., 19., 2., 17., 3., 11., 9., 1., 0., 4., 3., 9., 16., 17., 45., 12., 22., 11., 3., 1., 4., 1., 4., 1., 13., 4., 5., 20., 2., 18., 9., 1., 0., 2., 5., 0., 3., 1., 7., 3., 4., 2., 0., 4., 1., 1., 0., 4., 1., 0., 1., 2., 1., 9., 1., 7., 5., 0., 4., 0., 1., 2., 3., 5., 4., 0., 1., 3., 4., 3., 2., 0., 1., 0., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 5., 6., 3., 1., 2., 9., 29., 1., 4., 20., 0., 16., 3., 3., 2., 17., 1., 2., 30., 20., 17., 28., 9., 2., 2., 5., 0., 9., 7., 18., 15., 2., 26., 0., 21., 8., 1., 0., 6., 1., 20., 4., 16., 49., 10., 21., 5., 4., 1., 10., 4., 6., 3., 10., 7., 6., 15., 10., 31., 12., 1., 3., 2., 1., 1., 3., 1., 4., 1., 1., 2., 1., 6., 3., 1., 0., 3., 1., 0., 2., 3., 3., 2., 3., 3., 2., 2., 5., 1., 2., 2., 0., 3., 2., 0., 1., 1., 4., 3., 2., 3., 1., 1., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 3., 3., 10., 1., 5., 3., 7., 17., 0., 10., 28., 2., 13., 2., 2., 4., 21., 1., 2., 34., 7., 28., 23., 3., 1., 1., 0., 2., 5., 8., 37., 7., 3., 19., 4., 17., 9., 1., 0., 3., 3., 5., 11., 20., 41., 12., 21., 14., 4., 1., 3., 3., 6., 1., 11., 3., 11., 17., 4., 17., 6., 7., 1., 0., 6., 0., 4., 2., 4., 4., 5., 6., 2., 2., 2., 1., 1., 3., 4., 0., 3., 1., 2., 5., 1., 5., 2., 5., 2., 2., 1., 1., 1., 8., 1., 0., 1., 3., 0., 1., 2., 2., 2., 0., 5., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 1., 2., 4., 2., 5., 0., 6., 27., 1., 12., 23., 2., 17., 3., 3., 2., 14., 3., 2., 20., 16., 30., 35., 9., 2., 0., 4., 0., 9., 4., 23., 12., 7., 12., 5., 17., 9., 3., 0., 4., 3., 14., 7., 28., 44., 13., 16., 9., 7., 1., 7., 3., 10., 3., 5., 7., 6., 14., 3., 20., 11., 5., 0., 1., 4., 0., 4., 3., 7., 2., 8., 2., 0., 5., 2., 3., 1., 1., 1., 0., 3., 0., 1., 5., 2., 3., 0., 4., 5., 0., 2., 0., 2., 11., 1., 0., 1., 1., 1., 2., 4., 2., 1., 2., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 5., 2., 6., 4., 5., 2., 5., 25., 2., 14., 24., 0., 17., 1., 3., 1., 21., 3., 7., 20., 20., 23., 23., 3., 0., 1., 1., 2., 9., 5., 23., 20., 4., 15., 4., 14., 7., 3., 1., 1., 0., 17., 17., 16., 48., 17., 21., 8., 3., 0., 7., 4., 5., 3., 12., 7., 12., 19., 7., 22., 9., 0., 1., 0., 12., 4., 2., 0., 4., 0., 3., 1., 0., 1., 2., 3., 0., 4., 1., 0., 1., 1., 8., 7., 1., 5., 4., 2., 4., 3., 3., 0., 0., 11., 1., 0., 0., 2., 2., 2., 1., 0., 2., 1., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 1., 4., 10., 6., 6., 0., 2., 28., 0., 7., 28., 2., 12., 2., 1., 5., 19., 2., 7., 22., 17., 29., 42., 5., 0., 0., 2., 5., 5., 3., 22., 10., 3., 8., 2., 17., 11., 1., 0., 6., 2., 8., 14., 10., 42., 13., 19., 11., 4., 4., 4., 2., 9., 4., 13., 4., 11., 15., 8., 26., 8., 4., 1., 2., 3., 2., 3., 3., 4., 3., 5., 3., 5., 1., 5., 2., 2., 1., 3., 0., 3., 0., 4., 3., 1., 3., 2., 1., 5., 1., 2., 2., 0., 6., 2., 0., 0., 1., 7., 1., 2., 3., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 8., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 3., 3., 7., 12., 3., 8., 1., 2., 29., 0., 10., 25., 0., 18., 4., 3., 0., 11., 1., 7., 23., 8., 37., 35., 2., 3., 2., 4., 2., 10., 8., 33., 16., 7., 17., 3., 14., 10., 2., 0., 6., 2., 7., 13., 20., 33., 15., 23., 9., 3., 1., 7., 5., 4., 4., 9., 6., 6., 20., 11., 32., 8., 4., 1., 2., 6., 0., 6., 1., 7., 2., 3., 8., 2., 5., 3., 2., 2., 6., 0., 0., 3., 1., 3., 4., 1., 7., 1., 1., 2., 1., 2., 0., 3., 9., 4., 0., 1., 1., 1., 3., 2., 4., 0., 3., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 3., 5., 7., 26., 5., 35., 2., 16., 148., 2., 29., 219., 4., 21., 6., 1., 8., 73., 1., 17., 256., 41., 324., 46., 22., 3., 2., 12., 7., 43., 25., 236., 40., 8., 156., 16., 33., 7., 0., 3., 18., 14., 101., 22., 73., 22., 45., 37., 6., 6., 1., 30., 8., 43., 7., 46., 13., 31., 6., 14., 8., 2., 0., 2., 0., 19., 6., 11., 3., 28., 4., 18., 7., 2., 6., 0., 1., 2., 1., 12., 2., 9., 2., 7., 1., 0., 5., 136., 7., 1863., 90., 97., 220., 113., 118., 58., 13., 15., 18., 15., 1., 0., 4., 6., 8., 12., 6., 37., 18., 36., 25., 36., 5., 13., 5., 5., 7., 7., 1., 2., 5., 5., 1., 0., 1., 4., 12., 3., 0., 7., 5., 6., 0., 5., 1., 5., 27., 6., 9., 3., 13., 5., 23., 0., 0., 1., 3., 23., 6., 25., 5., 4., 7., 8., 26., 4., 10., 3.,

9., 1., 3., 5., 25., 3., 31., 2., 11., 162., 2., 25., 223., 3., 21., 9., 1., 7., 76., 5., 14., 300., 34., 354., 57., 21., 0., 3., 4., 4., 43., 23., 249., 39., 12., 169., 16., 46., 5., 0., 2., 14., 9., 86., 15., 78., 15., 47., 51., 12., 2., 1., 24., 7., 51., 15., 54., 12., 30., 3., 8., 9., 0., 0., 0., 0., 20., 8., 16., 5., 31., 4., 11., 4., 3., 2., 0., 0., 4., 3., 14., 0., 10., 1., 12., 1., 1., 5., 135., 7., 1795., 81., 99., 214., 97., 136., 73., 11., 13., 22., 11., 2., 0., 4., 7., 4., 7., 6., 39., 17., 37., 12., 40., 3., 11., 7., 7., 10., 5., 2., 5., 3., 9., 2., 0., 9., 8., 14., 1., 0., 12., 7., 4., 0., 7., 1., 1., 26., 2., 19., 10., 10., 3., 13., 2., 3., 3., 5., 29., 5., 31., 6., 8., 5., 4., 38., 13., 5., 5.,

10., 2., 2., 11., 26., 8., 36., 1., 18., 176., 6., 17., 205., 3., 17., 4., 1., 6., 69., 0., 16., 258., 47., 326., 47., 14., 1., 2., 12., 1., 42., 35., 231., 50., 9., 163., 17., 35., 6., 0., 0., 25., 6., 84., 12., 90., 17., 36., 43., 16., 2., 0., 20., 6., 31., 7., 54., 4., 35., 5., 8., 4., 0., 0., 1., 0., 28., 6., 17., 6., 23., 7., 14., 9., 2., 5., 1., 1., 1., 1., 10., 3., 8., 3., 7., 1., 1., 3., 145., 9., 1901., 100., 91., 231., 99., 112., 66., 10., 8., 23., 9., 2., 1., 4., 4., 5., 8., 9., 40., 16., 33., 16., 32., 9., 9., 2., 4., 9., 8., 1., 4., 4., 8., 3., 0., 3., 6., 11., 3., 0., 12., 1., 2., 0., 6., 5., 3., 36., 2., 7., 5., 17., 1., 24., 0., 3., 2., 3., 24., 9., 32., 8., 6., 12., 3., 29., 7., 12., 4.,

12., 5., 2., 7., 27., 11., 30., 1., 21., 140., 6., 18., 211., 3., 17., 11., 1., 4., 86., 1., 18., 306., 48., 326., 41., 16., 1., 4., 6., 6., 45., 26., 230., 38., 5., 164., 10., 39., 6., 0., 1., 20., 11., 79., 17., 87., 12., 50., 53., 9., 5., 5., 20., 7., 34., 9., 53., 5., 26., 5., 8., 6., 1., 0., 1., 0., 22., 8., 10., 3., 22., 3., 17., 4., 1., 2., 1., 0., 5., 0., 7., 6., 7., 2., 10., 0., 1., 7., 133., 9., 1784., 86., 89., 198., 88., 134., 70., 15., 9., 16., 10., 0., 2., 4., 9., 5., 5., 8., 38., 20., 34., 10., 41., 7., 13., 5., 6., 5., 4., 3., 6., 4., 6., 3., 0., 11., 3., 16., 2., 0., 7., 4., 2., 0., 6., 2., 1., 33., 2., 13., 2., 18., 5., 18., 6., 8., 3., 5., 28., 6., 26., 5., 2., 5., 5., 26., 7., 14., 8.,

13., 3., 1., 4., 18., 10., 26., 1., 19., 170., 4., 30., 215., 3., 17., 13., 0., 4., 104., 0., 15., 281., 48., 312., 44., 12., 0., 3., 6., 6., 45., 40., 211., 32., 5., 150., 14., 49., 5., 0., 1., 16., 8., 78., 21., 75., 13., 21., 40., 17., 1., 1., 24., 8., 41., 6., 57., 7., 31., 8., 8., 6., 0., 0., 1., 0., 24., 10., 16., 7., 33., 3., 9., 7., 1., 2., 4., 2., 5., 4., 12., 1., 6., 1., 3., 1., 1., 5., 171., 6., 1787., 77., 91., 262., 92., 113., 68., 16., 11., 15., 10., 1., 3., 8., 5., 3., 10., 9., 42., 12., 42., 10., 35., 6., 12., 3., 4., 2., 2., 3., 4., 1., 8., 2., 0., 5., 9., 15., 1., 0., 12., 4., 2., 0., 3., 4., 2., 32., 1., 10., 4., 16., 5., 17., 2., 2., 5., 8., 25., 5., 40., 7., 6., 2., 6., 34., 7., 12., 7.,

9., 2., 2., 10., 31., 7., 37., 0., 11., 165., 4., 36., 192., 5., 11., 5., 1., 5., 81., 2., 11., 288., 39., 329., 48., 18., 1., 3., 4., 3., 34., 30., 238., 46., 8., 144., 14., 38., 6., 0., 1., 26., 10., 73., 21., 75., 14., 25., 49., 9., 1., 0., 29., 7., 41., 8., 50., 10., 39., 9., 12., 6., 1., 0., 1., 0., 28., 2., 13., 3., 18., 4., 11., 7., 3., 0., 3., 1., 2., 1., 7., 4., 7., 1., 9., 0., 1., 5., 137., 9., 1915., 108., 121., 224., 106., 123., 74., 18., 8., 17., 15., 1., 1., 6., 5., 7., 11., 9., 38., 18., 30., 16., 45., 5., 10., 1., 10., 9., 5., 4., 5., 2., 11., 0., 0., 2., 9., 15., 2., 0., 12., 4., 2., 0., 4., 2., 4., 39., 1., 11., 2., 12., 4., 17., 4., 1., 5., 6., 31., 9., 42., 15., 8., 15., 9., 34., 6., 16., 12.,

11., 0., 5., 10., 20., 5., 22., 2., 9., 170., 5., 31., 207., 4., 17., 9., 1., 6., 90., 0., 13., 300., 42., 311., 48., 23., 0., 1., 7., 6., 44., 28., 228., 38., 6., 152., 22., 28., 4., 0., 5., 22., 12., 73., 25., 81., 14., 48., 47., 10., 3., 0., 21., 10., 47., 10., 40., 9., 32., 4., 8., 1., 1., 0., 2., 0., 25., 2., 14., 9., 19., 2., 9., 4., 1., 3., 1., 0., 5., 2., 16., 3., 11., 0., 12., 0., 2., 7., 145., 11., 1911., 94., 116., 217., 95., 117., 80., 14., 9., 32., 11., 2., 1., 3., 8., 5., 9., 12., 51., 24., 35., 16., 42., 5., 6., 2., 6., 8., 3., 4., 5., 0., 8., 6., 0., 4., 7., 14., 2., 0., 8., 4., 4., 0., 6., 5., 7., 27., 5., 13., 0., 14., 3., 22., 6., 2., 2., 5., 34., 4., 27., 5., 4., 2., 4., 28., 9., 15., 6.,

14., 3., 0., 7., 18., 7., 30., 1., 21., 140., 5., 27., 173., 8., 18., 7., 3., 4., 80., 0., 13., 269., 42., 344., 47., 14., 1., 0., 6., 1., 49., 29., 213., 46., 5., 143., 11., 41., 4., 0., 2., 21., 8., 76., 19., 71., 13., 27., 45., 17., 1., 2., 22., 8., 28., 10., 40., 3., 28., 6., 12., 6., 3., 0., 1., 0., 22., 5., 17., 5., 26., 7., 8., 6., 1., 2., 0., 1., 5., 2., 12., 1., 7., 4., 7., 1., 0., 3., 140., 9., 1832., 90., 107., 197., 96., 126., 62., 22., 9., 16., 9., 2., 4., 3., 5., 4., 10., 3., 42., 17., 33., 17., 47., 6., 10., 8., 6., 8., 8., 3., 3., 5., 4., 2., 0., 0., 7., 12., 2., 0., 11., 1., 1., 0., 4., 4., 3., 39., 0., 17., 2., 16., 5., 35., 4., 3., 4., 4., 27., 6., 34., 5., 5., 7., 5., 34., 9., 9., 6.,

13., 1., 1., 8., 27., 6., 33., 0., 21., 158., 3., 35., 217., 6., 12., 8., 2., 7., 71., 1., 11., 265., 35., 303., 36., 10., 2., 4., 7., 3., 45., 36., 230., 40., 10., 164., 16., 30., 4., 0., 1., 23., 8., 96., 17., 87., 24., 44., 46., 19., 3., 2., 26., 12., 46., 12., 43., 10., 31., 5., 9., 15., 0., 0., 4., 0., 29., 3., 15., 1., 25., 4., 14., 2., 1., 4., 2., 1., 1., 1., 10., 4., 11., 2., 5., 1., 0., 1., 142., 7., 1875., 89., 121., 205., 111., 112., 73., 17., 10., 16., 17., 1., 2., 9., 1., 5., 2., 6., 37., 15., 29., 21., 44., 7., 6., 5., 8., 5., 6., 1., 3., 3., 5., 0., 0., 3., 3., 11., 1., 0., 12., 4., 3., 0., 4., 1., 3., 32., 3., 6., 4., 9., 5., 17., 4., 5., 4., 5., 20., 5., 35., 7., 5., 6., 1., 23., 10., 9., 3.,

18., 0., 3., 11., 29., 7., 26., 1., 14., 169., 1., 27., 206., 1., 9., 9., 0., 6., 93., 1., 12., 293., 43., 331., 41., 19., 1., 3., 6., 4., 38., 31., 244., 41., 12., 167., 12., 39., 5., 0., 3., 16., 6., 57., 15., 98., 8., 26., 51., 14., 4., 1., 22., 8., 36., 10., 56., 9., 18., 6., 15., 7., 2., 0., 2., 0., 31., 6., 15., 5., 36., 3., 11., 2., 4., 0., 0., 2., 1., 3., 14., 3., 5., 5., 5., 1., 0., 4., 143., 9., 1944., 90., 98., 210., 91., 120., 81., 15., 18., 10., 11., 0., 2., 5., 5., 4., 11., 9., 35., 21., 36., 15., 38., 5., 5., 5., 5., 11., 4., 1., 2., 0., 8., 1., 0., 3., 7., 14., 0., 0., 10., 2., 2., 0., 2., 2., 5., 28., 4., 14., 3., 20., 2., 20., 6., 3., 3., 4., 30., 4., 26., 9., 5., 4., 4., 30., 8., 9., 4.,

21., 1., 2., 9., 23., 3., 38., 1., 16., 154., 4., 26., 220., 5., 22., 5., 0., 6., 76., 2., 13., 272., 37., 316., 40., 25., 1., 1., 9., 9., 45., 34., 240., 36., 7., 155., 8., 39., 7., 0., 3., 16., 11., 78., 14., 108., 16., 47., 49., 10., 1., 2., 20., 8., 28., 11., 40., 11., 29., 4., 9., 16., 1., 0., 0., 0., 20., 5., 9., 5., 23., 10., 11., 4., 3., 4., 0., 0., 5., 1., 6., 2., 8., 3., 8., 0., 1., 5., 161., 12., 1840., 100., 101., 195., 97., 116., 65., 17., 14., 23., 11., 1., 6., 5., 3., 5., 9., 7., 38., 16., 30., 14., 45., 6., 7., 3., 5., 3., 8., 2., 1., 8., 3., 3., 0., 5., 6., 22., 1., 0., 6., 5., 4., 0., 7., 4., 1., 32., 5., 15., 2., 7., 4., 21., 0., 4., 6., 5., 20., 5., 26., 6., 3., 4., 14., 28., 7., 11., 4.,

11., 3., 0., 9., 28., 5., 37., 0., 12., 147., 2., 33., 194., 5., 5., 5., 1., 3., 82., 2., 18., 312., 39., 311., 36., 16., 0., 1., 7., 2., 46., 37., 231., 45., 11., 146., 14., 38., 6., 0., 2., 13., 8., 73., 19., 73., 16., 28., 31., 19., 1., 0., 32., 5., 35., 10., 36., 5., 30., 6., 13., 8., 1., 0., 0., 0., 24., 2., 16., 4., 30., 4., 8., 6., 0., 4., 0., 2., 0., 7., 10., 2., 9., 3., 13., 1., 0., 4., 138., 8., 1872., 102., 91., 205., 112., 89., 49., 15., 14., 15., 9., 1., 2., 9., 11., 4., 12., 4., 40., 15., 29., 18., 45., 5., 7., 4., 8., 5., 7., 4., 3., 0., 9., 2., 0., 4., 2., 25., 3., 0., 4., 5., 5., 0., 3., 2., 1., 21., 4., 16., 0., 11., 1., 18., 2., 2., 3., 5., 29., 4., 24., 4., 8., 9., 8., 33., 10., 10., 6.,

20., 3., 2., 2., 28., 7., 35., 1., 14., 136., 6., 31., 189., 3., 17., 8., 1., 1., 73., 1., 15., 270., 41., 320., 32., 20., 0., 2., 7., 4., 52., 44., 255., 31., 9., 151., 24., 31., 5., 0., 1., 8., 9., 80., 27., 80., 9., 38., 37., 17., 6., 1., 22., 9., 37., 14., 64., 8., 30., 6., 10., 4., 0., 0., 1., 0., 28., 8., 7., 3., 31., 6., 14., 4., 4., 1., 0., 0., 1., 1., 19., 5., 12., 1., 13., 0., 1., 3., 126., 7., 1937., 95., 103., 234., 90., 129., 56., 12., 8., 18., 17., 0., 0., 4., 2., 7., 13., 4., 35., 11., 32., 10., 28., 6., 14., 2., 4., 3., 7., 2., 3., 2., 6., 1., 0., 3., 1., 15., 1., 0., 6., 5., 0., 0., 5., 0., 1., 29., 3., 11., 7., 20., 5., 22., 3., 5., 9., 6., 24., 3., 47., 4., 5., 5., 9., 25., 8., 9., 2.,

15., 3., 1., 6., 24., 6., 34., 0., 20., 142., 2., 31., 198., 5., 10., 7., 2., 3., 86., 4., 20., 262., 45., 361., 48., 18., 2., 3., 14., 3., 37., 29., 254., 39., 8., 185., 10., 39., 7., 0., 2., 17., 6., 82., 11., 81., 15., 26., 35., 20., 2., 0., 23., 7., 35., 8., 61., 18., 38., 7., 10., 6., 1., 0., 0., 0., 22., 6., 17., 2., 26., 6., 16., 7., 3., 1., 0., 0., 3., 1., 10., 3., 9., 2., 9., 0., 1., 2., 130., 11., 1826., 86., 121., 175., 96., 116., 62., 18., 17., 14., 16., 1., 2., 2., 4., 3., 7., 7., 35., 17., 38., 5., 48., 5., 15., 4., 6., 9., 2., 2., 1., 0., 8., 2., 0., 3., 8., 13., 1., 0., 15., 2., 3., 0., 6., 4., 2., 34., 1., 7., 2., 13., 7., 14., 3., 2., 2., 6., 22., 2., 27., 6., 8., 3., 2., 30., 8., 11., 9.,

18., 2., 1., 8., 27., 8., 21., 1., 8., 159., 3., 29., 228., 4., 10., 5., 2., 10., 79., 2., 15., 254., 60., 377., 52., 22., 2., 1., 5., 8., 43., 33., 225., 40., 6., 134., 9., 47., 3., 0., 0., 15., 11., 97., 12., 78., 17., 36., 52., 12., 2., 0., 22., 5., 34., 10., 38., 9., 27., 3., 13., 9., 6., 0., 1., 0., 16., 10., 15., 7., 33., 1., 10., 1., 3., 2., 1., 0., 5., 2., 15., 3., 5., 1., 8., 2., 0., 6., 130., 6., 1966., 93., 117., 203., 108., 118., 72., 20., 10., 16., 19., 0., 0., 7., 8., 5., 6., 10., 24., 17., 31., 21., 38., 5., 7., 6., 5., 5., 5., 2., 5., 3., 8., 2., 0., 3., 7., 10., 1., 0., 13., 1., 2., 0., 2., 4., 4., 22., 3., 6., 5., 15., 4., 21., 5., 3., 5., 3., 36., 5., 34., 3., 1., 8., 3., 41., 5., 12., 2.,

13., 1., 3., 4., 29., 5., 30., 2., 17., 169., 3., 19., 176., 5., 26., 6., 0., 9., 77., 1., 11., 298., 50., 339., 48., 11., 3., 1., 4., 3., 43., 31., 267., 45., 8., 159., 15., 45., 4., 0., 7., 16., 12., 61., 21., 89., 24., 45., 57., 13., 2., 2., 32., 6., 34., 9., 50., 13., 31., 11., 12., 3., 1., 0., 1., 0., 30., 3., 12., 2., 27., 4., 15., 5., 5., 1., 2., 1., 2., 2., 14., 1., 4., 5., 7., 0., 0., 6., 152., 7., 1859., 105., 115., 203., 102., 107., 72., 20., 17., 21., 19., 1., 5., 6., 4., 8., 12., 4., 33., 16., 34., 14., 34., 5., 19., 6., 3., 15., 3., 2., 1., 1., 8., 2., 0., 3., 4., 18., 2., 0., 12., 1., 5., 0., 3., 1., 1., 34., 6., 10., 2., 20., 4., 21., 6., 1., 3., 3., 28., 5., 26., 5., 5., 6., 2., 22., 6., 9., 7.,

15., 1., 1., 7., 30., 12., 30., 0., 11., 158., 2., 29., 187., 2., 16., 9., 1., 8., 76., 2., 16., 300., 37., 347., 42., 10., 1., 2., 6., 5., 38., 33., 235., 48., 6., 165., 9., 38., 6., 0., 3., 15., 9., 76., 15., 105., 19., 39., 38., 20., 2., 1., 30., 6., 43., 12., 55., 6., 34., 5., 7., 4., 2., 0., 1., 0., 21., 6., 20., 2., 35., 4., 16., 4., 1., 3., 0., 1., 7., 1., 14., 3., 9., 2., 6., 2., 0., 3., 143., 9., 1865., 68., 107., 211., 102., 129., 64., 12., 14., 18., 15., 1., 0., 5., 7., 3., 7., 10., 38., 13., 34., 12., 52., 2., 12., 3., 5., 6., 3., 2., 4., 1., 7., 1., 0., 3., 6., 13., 2., 0., 16., 7., 4., 0., 4., 3., 2., 22., 6., 14., 4., 12., 3., 26., 2., 1., 6., 3., 23., 4., 27., 3., 5., 11., 9., 44., 7., 14., 8.,

1., 1., 2., 5., 1., 3., 5., 0., 5., 21., 0., 10., 25., 3., 16., 2., 0., 1., 27., 1., 7., 26., 8., 28., 27., 9., 0., 3., 7., 3., 4., 9., 33., 17., 3., 14., 5., 22., 7., 2., 2., 2., 5., 13., 15., 19., 43., 6., 25., 11., 5., 1., 10., 2., 10., 4., 10., 4., 7., 19., 8., 20., 6., 4., 1., 0., 7., 1., 2., 3., 6., 3., 3., 2., 0., 3., 2., 1., 1., 3., 3., 0., 3., 1., 0., 2., 3., 1., 1., 4., 5., 0., 3., 2., 1., 5., 5., 0., 9., 3., 3., 3., 0., 1., 2., 0., 1., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 3., 4., 11., 2., 4., 1., 4., 25., 1., 8., 21., 2., 17., 1., 0., 2., 18., 2., 4., 29., 17., 35., 27., 10., 1., 0., 1., 1., 11., 7., 35., 18., 0., 24., 7., 16., 5., 4., 1., 0., 2., 13., 18., 12., 45., 14., 17., 11., 1., 3., 8., 1., 9., 4., 11., 3., 11., 18., 3., 21., 4., 1., 0., 0., 10., 1., 4., 1., 5., 4., 7., 5., 1., 8., 4., 0., 0., 1., 0., 0., 1., 4., 2., 4., 3., 3., 0., 6., 2., 1., 3., 2., 0., 9., 2., 0., 3., 2., 0., 2., 2., 5., 3., 1., 2., 0., 0., 0., 0., 5., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 1., 1., 10., 2., 4., 1., 4., 25., 1., 9., 27., 1., 8., 1., 0., 1., 25., 0., 4., 19., 13., 37., 25., 8., 0., 0., 4., 2., 10., 6., 36., 13., 3., 11., 7., 16., 10., 1., 0., 4., 1., 11., 10., 15., 58., 11., 19., 8., 7., 0., 6., 2., 2., 2., 10., 7., 5., 16., 5., 16., 8., 7., 0., 1., 6., 0., 5., 2., 5., 8., 3., 4., 3., 4., 4., 0., 1., 0., 1., 0., 3., 3., 2., 5., 2., 1., 2., 1., 2., 0., 3., 2., 2., 4., 1., 0., 1., 3., 4., 2., 2., 2., 2., 3., 1., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 0., 1., 8., 5., 8., 0., 2., 7., 3., 11., 28., 1., 7., 1., 0., 2., 18., 0., 6., 18., 11., 29., 34., 6., 1., 1., 3., 2., 13., 7., 34., 24., 4., 19., 4., 13., 2., 2., 1., 8., 2., 11., 13., 15., 36., 17., 21., 9., 5., 1., 6., 0., 5., 2., 7., 5., 4., 16., 8., 32., 10., 4., 1., 1., 8., 0., 7., 3., 5., 0., 4., 3., 3., 4., 1., 1., 0., 1., 0., 0., 0., 2., 2., 2., 1., 3., 1., 3., 3., 0., 0., 2., 2., 10., 3., 0., 1., 3., 1., 3., 1., 2., 1., 1., 1., 0., 0., 0., 0., 5., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 5., 5., 9., 0., 2., 0., 7., 16., 0., 9., 16., 0., 12., 3., 0., 2., 20., 3., 6., 22., 11., 35., 18., 4., 2., 0., 2., 2., 8., 11., 23., 16., 1., 17., 0., 18., 10., 1., 1., 7., 0., 15., 10., 23., 39., 14., 32., 6., 1., 2., 5., 0., 3., 4., 13., 7., 7., 19., 19., 20., 10., 2., 0., 1., 7., 1., 6., 0., 5., 2., 6., 4., 2., 7., 1., 2., 1., 3., 3., 0., 0., 0., 2., 4., 1., 0., 3., 3., 1., 1., 3., 1., 1., 7., 2., 0., 4., 2., 1., 1., 0., 0., 2., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 1., 2., 8., 4., 3., 0., 4., 18., 1., 8., 19., 1., 19., 2., 0., 3., 16., 0., 1., 29., 10., 20., 31., 9., 1., 1., 4., 3., 2., 7., 33., 15., 6., 29., 6., 9., 7., 2., 1., 6., 3., 16., 10., 20., 46., 11., 19., 7., 4., 3., 3., 1., 8., 2., 10., 6., 7., 10., 5., 20., 4., 2., 0., 2., 12., 0., 5., 4., 4., 5., 3., 1., 0., 5., 1., 1., 1., 3., 1., 0., 3., 1., 4., 3., 2., 5., 0., 3., 4., 1., 0., 0., 2., 7., 1., 0., 4., 1., 2., 2., 1., 1., 3., 1., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 4., 2., 5., 3., 6., 2., 7., 9., 2., 19., 22., 0., 24., 2., 0., 3., 15., 1., 4., 18., 8., 20., 31., 7., 2., 0., 4., 4., 7., 6., 26., 15., 4., 22., 4., 18., 8., 1., 0., 6., 1., 11., 11., 21., 46., 14., 18., 15., 3., 0., 7., 1., 10., 6., 8., 5., 12., 18., 7., 28., 7., 3., 2., 2., 10., 1., 2., 1., 10., 2., 4., 1., 3., 3., 4., 1., 1., 3., 1., 0., 0., 2., 0., 5., 0., 8., 3., 2., 5., 0., 3., 3., 4., 2., 4., 0., 2., 3., 2., 2., 1., 2., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 2., 3., 13., 2., 6., 0., 3., 18., 1., 16., 26., 1., 14., 4., 0., 1., 23., 4., 1., 18., 10., 15., 25., 7., 0., 3., 1., 1., 10., 10., 14., 21., 5., 21., 2., 15., 10., 0., 0., 4., 3., 14., 12., 24., 53., 9., 14., 8., 2., 1., 5., 1., 10., 2., 7., 7., 5., 17., 5., 24., 16., 2., 1., 1., 7., 0., 1., 3., 3., 5., 0., 4., 0., 3., 2., 2., 2., 1., 2., 0., 0., 5., 3., 5., 0., 8., 2., 3., 5., 1., 3., 1., 3., 10., 1., 0., 2., 1., 1., 2., 2., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 3., 2., 1., 10., 1., 6., 1., 5., 21., 4., 12., 19., 1., 16., 3., 1., 0., 27., 2., 3., 35., 8., 28., 24., 8., 2., 2., 0., 4., 9., 6., 23., 19., 3., 15., 3., 19., 13., 3., 1., 6., 1., 12., 7., 16., 46., 12., 16., 7., 7., 1., 7., 4., 5., 2., 10., 8., 11., 16., 9., 16., 11., 1., 1., 1., 8., 2., 3., 4., 2., 1., 6., 6., 4., 4., 2., 1., 3., 1., 2., 0., 1., 3., 0., 5., 1., 7., 2., 1., 6., 2., 2., 1., 1., 10., 2., 0., 0., 1., 3., 3., 2., 1., 2., 2., 1., 0., 0., 0., 0., 4., 0., 0., 5., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 4., 3., 6., 2., 6., 1., 7., 22., 0., 7., 8., 1., 16., 1., 1., 1., 18., 1., 6., 37., 20., 20., 34., 1., 1., 0., 0., 4., 13., 6., 25., 14., 4., 12., 4., 12., 16., 4., 1., 4., 1., 6., 8., 15., 50., 12., 15., 9., 4., 0., 7., 3., 8., 4., 8., 11., 10., 13., 3., 21., 10., 1., 2., 2., 4., 3., 4., 0., 6., 5., 2., 5., 2., 9., 6., 2., 1., 3., 2., 0., 1., 0., 1., 4., 1., 7., 0., 1., 3., 0., 2., 1., 1., 9., 2., 0., 1., 1., 1., 3., 2., 5., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 1., 4., 6., 1., 10., 0., 6., 24., 1., 9., 43., 1., 18., 3., 1., 5., 16., 1., 2., 24., 10., 34., 20., 7., 2., 1., 2., 1., 7., 1., 43., 18., 3., 14., 5., 15., 7., 3., 2., 7., 3., 10., 14., 28., 47., 11., 22., 13., 4., 3., 7., 3., 10., 3., 8., 6., 11., 13., 6., 24., 10., 1., 1., 1., 8., 0., 2., 2., 8., 3., 3., 5., 1., 5., 3., 4., 1., 4., 1., 0., 2., 2., 3., 5., 0., 6., 1., 4., 1., 1., 1., 1., 4., 8., 3., 0., 3., 0., 2., 1., 2., 3., 4., 1., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 2., 5., 8., 0., 7., 0., 6., 18., 2., 19., 22., 1., 18., 3., 0., 3., 13., 1., 3., 27., 12., 35., 22., 5., 1., 0., 3., 2., 5., 3., 23., 16., 1., 17., 6., 15., 7., 1., 2., 6., 1., 8., 18., 16., 42., 16., 24., 8., 6., 1., 9., 3., 4., 1., 5., 5., 7., 15., 9., 23., 9., 2., 1., 0., 9., 2., 6., 2., 3., 1., 3., 3., 1., 7., 2., 0., 0., 4., 3., 0., 1., 2., 1., 6., 5., 8., 1., 4., 4., 0., 3., 1., 2., 3., 2., 0., 4., 2., 0., 1., 3., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 5., 11., 2., 2., 2., 7., 29., 0., 15., 17., 1., 17., 1., 2., 4., 28., 4., 4., 22., 13., 16., 24., 7., 2., 0., 2., 2., 11., 11., 21., 12., 2., 9., 0., 10., 8., 1., 1., 1., 1., 11., 12., 11., 40., 20., 16., 13., 5., 0., 7., 2., 5., 1., 9., 3., 4., 17., 5., 32., 3., 3., 3., 1., 8., 0., 7., 1., 3., 5., 6., 5., 4., 6., 7., 4., 2., 5., 1., 0., 0., 5., 2., 6., 3., 4., 1., 3., 7., 1., 4., 2., 2., 3., 2., 0., 2., 3., 0., 3., 1., 3., 1., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 3., 5., 8., 0., 3., 0., 8., 21., 1., 16., 23., 1., 15., 3., 2., 2., 20., 1., 5., 33., 15., 12., 29., 1., 0., 0., 3., 1., 7., 5., 30., 22., 3., 9., 5., 15., 8., 2., 2., 1., 3., 11., 14., 21., 33., 7., 23., 12., 2., 2., 4., 1., 10., 5., 17., 7., 6., 14., 9., 29., 10., 1., 0., 1., 7., 1., 3., 1., 10., 3., 4., 4., 2., 3., 1., 0., 0., 1., 4., 0., 6., 1., 4., 5., 1., 9., 2., 4., 3., 0., 3., 0., 3., 10., 0., 0., 2., 3., 3., 3., 5., 2., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 2., 14., 6., 10., 1., 6., 18., 1., 11., 24., 3., 12., 1., 2., 2., 8., 1., 6., 37., 13., 24., 28., 3., 0., 2., 7., 3., 11., 8., 40., 20., 2., 18., 4., 7., 7., 6., 1., 5., 3., 16., 9., 17., 48., 10., 20., 9., 6., 2., 3., 2., 7., 1., 10., 3., 11., 19., 11., 24., 7., 5., 2., 2., 4., 2., 4., 0., 7., 3., 10., 4., 2., 4., 2., 1., 1., 0., 2., 0., 1., 0., 2., 5., 2., 9., 0., 2., 4., 2., 2., 0., 0., 10., 3., 0., 0., 3., 2., 2., 2., 2., 2., 1., 1., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 5., 6., 22., 10., 36., 0., 19., 170., 3., 30., 224., 5., 12., 3., 1., 4., 67., 0., 20., 242., 47., 349., 52., 22., 1., 2., 7., 1., 35., 40., 244., 34., 5., 175., 15., 51., 8., 0., 5., 16., 8., 83., 17., 93., 11., 42., 43., 11., 1., 0., 20., 11., 22., 6., 47., 12., 25., 5., 5., 8., 2., 0., 3., 0., 20., 6., 12., 3., 28., 3., 11., 1., 2., 0., 0., 1., 2., 3., 9., 2., 6., 2., 8., 2., 0., 3., 132., 10., 1868., 89., 100., 218., 108., 104., 57., 11., 10., 15., 18., 2., 0., 7., 3., 4., 7., 11., 33., 21., 49., 12., 30., 11., 11., 6., 7., 5., 2., 2., 2., 4., 9., 3., 0., 9., 3., 9., 1., 0., 16., 3., 1., 0., 5., 3., 4., 47., 4., 11., 1., 18., 3., 14., 8., 3., 5., 5., 20., 1., 42., 5., 12., 10., 3., 22., 12., 14., 5.,

11., 2., 4., 8., 39., 8., 36., 0., 14., 165., 3., 22., 198., 4., 14., 6., 0., 4., 89., 2., 22., 251., 50., 310., 49., 17., 2., 1., 6., 5., 45., 27., 219., 37., 6., 141., 12., 43., 5., 0., 1., 20., 5., 77., 19., 98., 23., 31., 40., 11., 2., 1., 23., 6., 57., 14., 45., 6., 26., 7., 4., 6., 4., 0., 1., 0., 31., 6., 15., 1., 28., 6., 9., 1., 3., 2., 1., 0., 3., 1., 9., 4., 13., 0., 8., 1., 0., 4., 122., 12., 1899., 90., 89., 224., 78., 125., 66., 24., 14., 23., 14., 1., 1., 7., 2., 4., 8., 9., 36., 12., 38., 22., 34., 8., 6., 0., 8., 8., 3., 4., 3., 2., 9., 2., 0., 5., 8., 9., 2., 0., 10., 4., 2., 0., 4., 5., 3., 25., 2., 10., 5., 9., 2., 22., 5., 5., 3., 5., 24., 3., 33., 9., 3., 9., 5., 27., 8., 14., 7.,

8., 4., 1., 12., 20., 10., 36., 2., 18., 159., 2., 33., 226., 2., 17., 3., 2., 2., 93., 2., 19., 265., 40., 312., 43., 20., 5., 2., 6., 3., 44., 22., 245., 53., 6., 167., 12., 38., 6., 0., 4., 16., 6., 76., 21., 81., 17., 39., 56., 9., 7., 3., 23., 6., 40., 7., 48., 11., 37., 5., 12., 6., 2., 0., 0., 0., 20., 2., 15., 1., 23., 3., 19., 3., 2., 2., 1., 3., 0., 2., 17., 2., 10., 2., 8., 1., 1., 1., 131., 12., 1856., 96., 110., 207., 95., 144., 69., 12., 15., 16., 12., 0., 3., 4., 5., 4., 9., 14., 25., 14., 30., 16., 47., 8., 6., 6., 6., 9., 3., 1., 2., 5., 9., 0., 0., 0., 3., 23., 3., 0., 11., 2., 4., 0., 3., 2., 1., 25., 2., 11., 1., 10., 7., 18., 2., 2., 4., 5., 29., 8., 29., 7., 9., 10., 7., 28., 8., 22., 7.,

15., 6., 0., 7., 36., 4., 31., 1., 12., 167., 3., 22., 226., 1., 16., 7., 2., 3., 74., 6., 17., 307., 41., 303., 50., 21., 0., 3., 7., 9., 30., 15., 225., 34., 7., 167., 16., 31., 3., 0., 0., 19., 6., 75., 16., 86., 17., 29., 36., 16., 3., 0., 31., 6., 43., 11., 43., 12., 30., 9., 10., 7., 0., 0., 2., 0., 20., 9., 15., 6., 31., 2., 9., 3., 1., 1., 1., 4., 1., 0., 13., 4., 8., 4., 7., 0., 2., 5., 132., 7., 1966., 68., 110., 221., 95., 109., 67., 21., 18., 24., 11., 0., 0., 8., 3., 4., 7., 13., 39., 8., 35., 14., 37., 6., 15., 2., 7., 7., 3., 2., 0., 6., 11., 1., 0., 4., 6., 18., 2., 0., 5., 4., 7., 0., 3., 7., 1., 27., 0., 12., 4., 16., 6., 21., 4., 1., 2., 2., 22., 3., 36., 9., 10., 1., 4., 33., 6., 13., 4.,

5., 1., 6., 8., 23., 6., 27., 1., 16., 158., 2., 27., 210., 5., 11., 9., 2., 9., 86., 3., 22., 282., 54., 349., 39., 19., 1., 1., 5., 4., 48., 27., 224., 42., 5., 158., 17., 50., 8., 0., 3., 11., 8., 88., 22., 94., 11., 38., 55., 9., 1., 2., 28., 8., 39., 7., 50., 13., 42., 4., 8., 6., 1., 0., 0., 0., 28., 8., 13., 3., 27., 3., 3., 6., 1., 0., 1., 0., 1., 4., 8., 3., 6., 3., 7., 1., 1., 3., 156., 5., 1878., 105., 114., 229., 86., 122., 82., 16., 13., 19., 14., 1., 4., 6., 5., 5., 8., 11., 26., 16., 33., 17., 54., 3., 13., 0., 6., 8., 2., 5., 5., 5., 7., 3., 0., 4., 5., 11., 2., 0., 13., 7., 1., 0., 3., 9., 4., 31., 2., 11., 9., 10., 0., 15., 3., 0., 6., 6., 25., 2., 30., 5., 6., 7., 7., 34., 5., 12., 3.,

15., 1., 4., 9., 15., 5., 31., 2., 20., 147., 4., 19., 196., 2., 19., 6., 0., 8., 95., 1., 12., 269., 34., 335., 41., 28., 1., 2., 6., 2., 37., 30., 196., 46., 11., 144., 18., 32., 6., 0., 2., 21., 9., 91., 24., 82., 15., 34., 36., 9., 3., 2., 35., 4., 34., 8., 39., 11., 27., 2., 9., 9., 1., 0., 0., 0., 27., 6., 21., 5., 34., 3., 10., 9., 1., 3., 1., 1., 6., 4., 5., 3., 10., 2., 7., 2., 0., 5., 165., 2., 1904., 83., 78., 222., 112., 110., 71., 16., 15., 11., 12., 0., 1., 3., 7., 1., 5., 8., 33., 18., 47., 11., 39., 10., 6., 7., 6., 7., 7., 2., 3., 5., 7., 3., 0., 1., 2., 18., 1., 0., 6., 4., 2., 0., 2., 3., 1., 38., 2., 15., 4., 16., 6., 17., 6., 1., 5., 8., 32., 9., 31., 2., 6., 3., 6., 32., 9., 12., 0.,

11., 0., 1., 11., 18., 8., 28., 3., 24., 143., 2., 28., 201., 6., 17., 10., 0., 5., 84., 3., 18., 274., 42., 311., 33., 16., 1., 4., 10., 8., 43., 23., 219., 41., 5., 171., 16., 39., 11., 0., 5., 13., 10., 78., 24., 98., 22., 38., 45., 17., 3., 2., 25., 9., 30., 7., 54., 5., 32., 7., 5., 6., 2., 0., 1., 0., 19., 8., 16., 1., 35., 6., 11., 5., 1., 4., 2., 1., 5., 1., 12., 3., 11., 2., 5., 1., 0., 2., 145., 10., 1849., 81., 112., 215., 90., 116., 74., 9., 12., 18., 16., 1., 2., 3., 8., 3., 14., 9., 29., 17., 33., 10., 42., 3., 11., 4., 3., 11., 5., 3., 3., 2., 13., 4., 0., 4., 6., 18., 3., 0., 8., 4., 3., 0., 2., 3., 3., 33., 2., 11., 3., 12., 2., 18., 3., 0., 3., 6., 28., 6., 38., 7., 6., 8., 5., 25., 8., 14., 5.,

16., 2., 1., 10., 22., 7., 36., 1., 12., 160., 3., 24., 202., 2., 14., 14., 1., 6., 77., 2., 11., 276., 55., 340., 51., 17., 0., 2., 6., 1., 40., 28., 227., 50., 13., 132., 14., 36., 7., 0., 2., 13., 1., 77., 16., 80., 16., 41., 34., 11., 5., 1., 28., 9., 36., 10., 56., 6., 20., 9., 10., 7., 1., 0., 2., 0., 22., 4., 16., 7., 31., 5., 5., 5., 2., 0., 2., 0., 4., 2., 8., 1., 11., 4., 4., 0., 0., 2., 157., 11., 1887., 79., 101., 215., 89., 102., 63., 19., 9., 12., 12., 0., 5., 2., 6., 3., 8., 10., 37., 15., 30., 17., 28., 12., 10., 5., 10., 5., 7., 2., 2., 4., 11., 1., 0., 4., 6., 10., 2., 0., 15., 4., 2., 0., 7., 8., 3., 29., 2., 8., 2., 12., 1., 18., 0., 4., 3., 5., 35., 2., 30., 7., 14., 5., 5., 25., 10., 16., 8.,

13., 3., 1., 2., 23., 3., 35., 0., 18., 153., 3., 31., 207., 4., 14., 11., 0., 4., 80., 4., 11., 274., 59., 366., 38., 18., 0., 1., 7., 7., 48., 28., 221., 37., 6., 180., 13., 26., 2., 0., 2., 17., 8., 86., 26., 75., 13., 40., 49., 16., 1., 2., 23., 11., 37., 11., 39., 7., 32., 8., 13., 5., 1., 0., 0., 0., 21., 2., 25., 1., 25., 4., 14., 4., 1., 7., 1., 1., 3., 1., 11., 4., 12., 3., 8., 0., 3., 5., 146., 6., 1846., 84., 100., 236., 99., 105., 82., 14., 7., 19., 11., 0., 2., 6., 5., 2., 16., 6., 32., 16., 34., 18., 42., 11., 8., 3., 7., 5., 2., 1., 4., 2., 9., 3., 0., 0., 5., 17., 4., 0., 13., 5., 3., 0., 8., 5., 3., 28., 2., 10., 5., 14., 3., 20., 1., 1., 6., 9., 28., 8., 30., 9., 1., 8., 6., 29., 5., 12., 4.,

12., 3., 3., 10., 32., 5., 33., 0., 13., 142., 1., 34., 217., 4., 18., 8., 1., 5., 78., 1., 14., 305., 42., 315., 39., 18., 0., 2., 5., 1., 54., 26., 225., 36., 13., 167., 17., 37., 5., 0., 2., 11., 3., 76., 23., 97., 11., 42., 29., 16., 2., 0., 35., 13., 36., 10., 56., 6., 39., 6., 9., 7., 1., 0., 1., 0., 18., 3., 23., 5., 20., 6., 7., 4., 4., 2., 1., 0., 6., 5., 9., 4., 12., 2., 7., 1., 3., 4., 163., 8., 1906., 111., 112., 234., 101., 120., 68., 17., 14., 15., 20., 0., 0., 11., 7., 2., 8., 13., 38., 20., 27., 16., 30., 8., 8., 2., 4., 7., 4., 1., 2., 3., 5., 3., 0., 4., 3., 14., 3., 0., 9., 6., 0., 0., 2., 7., 5., 28., 4., 13., 2., 8., 2., 18., 2., 2., 5., 2., 31., 5., 37., 4., 7., 7., 9., 30., 3., 7., 5.,

9., 3., 3., 4., 36., 3., 30., 1., 15., 136., 1., 23., 211., 3., 16., 9., 0., 6., 86., 2., 15., 294., 33., 345., 44., 13., 1., 4., 5., 5., 45., 25., 220., 42., 6., 150., 13., 30., 4., 0., 2., 17., 9., 89., 10., 95., 21., 42., 46., 15., 1., 2., 25., 4., 46., 7., 43., 9., 33., 7., 14., 14., 2., 0., 0., 0., 25., 7., 24., 2., 27., 4., 18., 5., 1., 2., 0., 3., 3., 2., 9., 1., 8., 0., 9., 2., 0., 4., 148., 8., 1932., 107., 102., 229., 108., 117., 62., 10., 4., 13., 13., 0., 1., 3., 5., 3., 9., 8., 38., 9., 24., 20., 39., 13., 11., 1., 3., 7., 3., 2., 3., 4., 3., 1., 0., 4., 5., 12., 1., 0., 17., 2., 3., 0., 9., 3., 3., 29., 2., 14., 2., 12., 3., 19., 4., 4., 2., 6., 36., 2., 41., 5., 5., 11., 1., 28., 6., 3., 5.,

13., 1., 2., 7., 25., 2., 29., 0., 20., 152., 3., 23., 218., 6., 14., 9., 1., 5., 91., 2., 16., 310., 49., 301., 51., 16., 1., 1., 6., 5., 52., 31., 243., 44., 10., 149., 10., 39., 12., 0., 1., 13., 8., 64., 22., 82., 19., 41., 46., 16., 2., 1., 39., 4., 37., 8., 40., 11., 42., 6., 5., 4., 2., 0., 3., 0., 24., 5., 17., 3., 35., 6., 11., 8., 1., 4., 0., 1., 2., 2., 16., 0., 10., 2., 7., 2., 2., 3., 147., 11., 1897., 86., 100., 226., 88., 108., 66., 16., 12., 27., 17., 1., 2., 4., 7., 4., 14., 11., 37., 14., 24., 18., 50., 5., 15., 4., 5., 6., 4., 1., 2., 2., 4., 4., 0., 5., 5., 9., 3., 0., 11., 4., 3., 0., 2., 4., 4., 37., 3., 13., 1., 14., 4., 27., 1., 1., 2., 6., 25., 2., 33., 5., 5., 4., 8., 32., 8., 9., 4.,

15., 1., 1., 9., 24., 5., 40., 1., 14., 154., 1., 23., 194., 9., 20., 11., 0., 8., 66., 3., 14., 257., 50., 296., 36., 22., 0., 1., 4., 12., 47., 37., 249., 51., 10., 158., 8., 46., 3., 0., 1., 12., 8., 75., 12., 82., 10., 38., 43., 14., 3., 0., 25., 5., 35., 9., 45., 7., 30., 4., 8., 4., 3., 0., 0., 0., 28., 6., 11., 2., 29., 4., 13., 1., 4., 0., 1., 3., 5., 2., 15., 2., 5., 3., 7., 3., 2., 3., 119., 12., 1859., 79., 95., 225., 82., 114., 61., 18., 12., 14., 10., 0., 2., 4., 4., 3., 9., 5., 31., 17., 44., 9., 46., 10., 5., 1., 6., 6., 2., 5., 4., 4., 7., 1., 0., 4., 5., 17., 1., 0., 15., 5., 2., 0., 5., 2., 4., 28., 8., 14., 4., 14., 4., 19., 4., 7., 2., 3., 21., 4., 28., 5., 4., 5., 5., 45., 8., 17., 4.,

5., 2., 4., 9., 22., 6., 36., 0., 8., 159., 2., 38., 222., 8., 15., 5., 3., 2., 77., 2., 24., 278., 43., 339., 40., 12., 0., 0., 10., 3., 40., 34., 211., 48., 11., 143., 12., 38., 5., 0., 0., 17., 13., 81., 17., 74., 21., 41., 49., 16., 4., 1., 26., 10., 34., 7., 51., 6., 32., 6., 7., 8., 6., 0., 1., 0., 17., 6., 10., 2., 38., 5., 18., 6., 3., 3., 1., 3., 1., 2., 8., 2., 7., 2., 10., 0., 2., 5., 140., 8., 1829., 94., 98., 231., 87., 110., 65., 13., 11., 21., 12., 1., 4., 6., 4., 3., 9., 13., 27., 23., 31., 18., 30., 6., 14., 2., 2., 11., 3., 2., 2., 3., 10., 0., 0., 2., 8., 11., 3., 0., 13., 4., 6., 0., 2., 2., 4., 31., 3., 13., 0., 15., 3., 18., 4., 3., 3., 6., 33., 4., 35., 5., 5., 4., 5., 34., 7., 9., 4.,

15., 4., 2., 8., 21., 5., 30., 0., 22., 175., 3., 26., 218., 6., 18., 9., 1., 10., 84., 2., 20., 319., 40., 319., 34., 13., 0., 3., 6., 5., 47., 26., 222., 29., 7., 155., 17., 39., 3., 0., 3., 30., 6., 83., 20., 66., 17., 31., 47., 12., 2., 1., 16., 2., 32., 13., 53., 12., 31., 3., 9., 7., 1., 0., 1., 0., 23., 4., 15., 5., 25., 5., 10., 4., 0., 1., 0., 0., 4., 2., 19., 6., 9., 5., 7., 2., 2., 3., 153., 12., 1836., 101., 115., 216., 105., 129., 67., 21., 11., 21., 8., 1., 1., 8., 3., 4., 9., 5., 34., 21., 35., 11., 37., 5., 7., 6., 7., 3., 6., 1., 4., 2., 8., 4., 0., 4., 7., 14., 2., 0., 9., 2., 4., 0., 10., 3., 5., 30., 8., 12., 3., 19., 4., 27., 3., 2., 5., 4., 22., 6., 23., 5., 3., 5., 3., 27., 6., 7., 3.,

5., 1., 1., 0., 4., 4., 6., 2., 6., 19., 1., 20., 20., 0., 15., 3., 0., 1., 15., 4., 1., 26., 11., 21., 31., 2., 4., 2., 3., 3., 8., 4., 22., 14., 7., 17., 3., 9., 8., 2., 0., 2., 0., 11., 10., 27., 39., 15., 24., 9., 3., 3., 7., 6., 6., 1., 8., 11., 10., 14., 10., 22., 10., 2., 0., 0., 4., 1., 4., 2., 5., 5., 3., 4., 2., 8., 1., 2., 1., 4., 3., 0., 1., 5., 1., 5., 5., 1., 4., 2., 3., 0., 3., 1., 3., 4., 2., 0., 3., 1., 2., 3., 6., 3., 2., 0., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 1., 7., 8., 4., 9., 2., 10., 21., 1., 9., 18., 1., 16., 0., 2., 1., 13., 3., 3., 23., 7., 14., 33., 4., 2., 0., 2., 2., 9., 5., 26., 19., 1., 13., 6., 15., 12., 3., 0., 4., 1., 18., 9., 12., 50., 12., 18., 10., 4., 0., 3., 1., 8., 5., 9., 10., 5., 22., 6., 18., 9., 4., 2., 1., 13., 3., 3., 1., 8., 5., 7., 6., 0., 3., 3., 3., 2., 5., 0., 0., 2., 4., 1., 5., 4., 5., 1., 2., 2., 1., 1., 0., 2., 5., 1., 0., 1., 3., 5., 2., 2., 4., 2., 0., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 1., 4., 3., 1., 11., 0., 10., 24., 0., 17., 26., 1., 21., 3., 0., 4., 28., 3., 7., 36., 9., 29., 35., 4., 2., 1., 2., 1., 7., 6., 27., 13., 4., 20., 3., 13., 4., 2., 2., 3., 0., 12., 13., 14., 47., 16., 18., 7., 2., 1., 2., 1., 6., 4., 10., 6., 12., 15., 5., 33., 8., 2., 0., 1., 6., 0., 1., 3., 6., 3., 4., 4., 2., 4., 1., 3., 0., 2., 2., 0., 2., 2., 3., 10., 4., 3., 3., 2., 2., 1., 4., 0., 2., 9., 2., 0., 4., 1., 3., 2., 1., 2., 0., 1., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 5., 6., 3., 5., 9., 0., 3., 14., 1., 10., 23., 0., 16., 3., 2., 2., 24., 0., 5., 9., 17., 12., 28., 8., 1., 4., 4., 4., 10., 5., 27., 12., 5., 14., 6., 15., 7., 1., 1., 2., 1., 13., 10., 25., 60., 15., 16., 6., 2., 1., 6., 1., 13., 5., 9., 5., 5., 13., 10., 21., 6., 3., 1., 1., 6., 0., 2., 1., 5., 2., 2., 4., 1., 1., 3., 2., 0., 3., 0., 0., 3., 2., 1., 5., 0., 6., 1., 2., 4., 0., 0., 1., 2., 5., 2., 0., 5., 2., 2., 4., 2., 1., 3., 0., 4., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 9., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 0., 3., 10., 1., 2., 1., 6., 15., 0., 11., 24., 1., 13., 2., 0., 4., 8., 1., 7., 23., 12., 24., 24., 6., 0., 2., 1., 2., 5., 7., 25., 13., 4., 16., 5., 13., 12., 0., 3., 6., 2., 13., 7., 15., 46., 13., 22., 9., 5., 1., 6., 2., 3., 2., 15., 7., 10., 5., 3., 21., 9., 4., 0., 1., 3., 2., 4., 2., 2., 2., 1., 1., 0., 4., 2., 2., 2., 0., 0., 0., 2., 4., 0., 5., 4., 3., 1., 3., 5., 0., 3., 1., 3., 5., 1., 0., 2., 3., 1., 1., 5., 6., 5., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 0., 2., 8., 4., 5., 0., 9., 10., 1., 11., 28., 4., 11., 2., 1., 3., 14., 2., 3., 26., 9., 40., 28., 4., 0., 2., 0., 2., 5., 4., 25., 15., 5., 26., 8., 11., 4., 2., 3., 6., 3., 10., 10., 19., 40., 10., 22., 17., 5., 0., 7., 3., 5., 0., 10., 8., 8., 16., 7., 29., 6., 4., 2., 1., 12., 1., 4., 4., 8., 3., 4., 2., 1., 6., 2., 2., 1., 3., 1., 0., 3., 1., 0., 5., 3., 6., 2., 4., 2., 0., 3., 0., 1., 6., 0., 0., 1., 1., 3., 4., 0., 2., 2., 1., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 9., 9., 1., 3., 1., 5., 37., 2., 14., 20., 0., 12., 3., 0., 0., 12., 1., 2., 19., 10., 16., 25., 6., 1., 2., 4., 3., 7., 3., 28., 12., 4., 15., 5., 12., 11., 1., 2., 5., 2., 13., 16., 15., 40., 14., 19., 15., 6., 2., 6., 2., 3., 3., 7., 5., 9., 18., 12., 28., 8., 2., 1., 1., 8., 0., 5., 3., 8., 6., 4., 7., 2., 5., 4., 3., 3., 1., 1., 0., 2., 0., 1., 8., 4., 2., 2., 2., 3., 2., 1., 1., 2., 7., 0., 0., 2., 1., 2., 0., 1., 1., 2., 0., 3., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 2., 4., 4., 7., 3., 10., 0., 6., 13., 1., 15., 15., 0., 15., 3., 2., 2., 12., 0., 3., 10., 15., 51., 21., 3., 0., 1., 2., 4., 8., 7., 21., 19., 5., 15., 3., 12., 8., 4., 3., 7., 2., 9., 10., 18., 45., 9., 22., 6., 7., 0., 6., 3., 5., 1., 11., 5., 14., 20., 3., 19., 4., 0., 3., 2., 7., 1., 4., 0., 5., 4., 7., 4., 1., 5., 4., 1., 0., 1., 1., 0., 2., 2., 1., 5., 0., 6., 1., 1., 4., 1., 1., 0., 3., 6., 1., 0., 3., 2., 3., 0., 2., 1., 2., 2., 0., 0., 0., 0., 0., 6., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 1., 8., 1., 6., 3., 4., 28., 4., 14., 22., 0., 16., 1., 1., 3., 13., 3., 4., 25., 8., 28., 24., 6., 0., 1., 4., 1., 7., 13., 32., 18., 4., 23., 6., 16., 12., 4., 3., 6., 1., 9., 11., 10., 44., 14., 31., 9., 1., 2., 5., 1., 7., 4., 8., 8., 4., 13., 9., 24., 3., 3., 1., 0., 4., 3., 4., 0., 6., 2., 1., 5., 3., 8., 4., 0., 0., 1., 2., 0., 4., 3., 2., 6., 2., 7., 3., 0., 3., 2., 3., 2., 2., 10., 2., 0., 4., 0., 1., 3., 2., 2., 3., 1., 4., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 2., 2., 8., 5., 5., 0., 9., 17., 3., 17., 32., 1., 16., 4., 0., 2., 16., 1., 4., 29., 13., 30., 29., 2., 0., 0., 5., 1., 5., 4., 18., 20., 3., 21., 1., 15., 10., 0., 1., 6., 5., 9., 15., 17., 51., 12., 20., 10., 4., 1., 4., 1., 5., 4., 15., 7., 11., 14., 5., 18., 5., 2., 1., 1., 10., 1., 2., 3., 7., 3., 2., 4., 3., 4., 4., 5., 1., 1., 3., 0., 3., 0., 1., 6., 2., 4., 1., 1., 4., 1., 2., 1., 2., 4., 5., 0., 2., 2., 2., 0., 2., 2., 3., 1., 3., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 3., 8., 1., 8., 0., 5., 22., 1., 13., 21., 0., 14., 6., 1., 3., 22., 1., 4., 23., 15., 30., 29., 5., 1., 3., 2., 4., 11., 7., 10., 28., 6., 19., 5., 8., 11., 1., 0., 4., 5., 14., 14., 9., 37., 11., 25., 7., 1., 2., 10., 3., 6., 2., 13., 4., 9., 14., 7., 22., 12., 3., 1., 1., 4., 0., 2., 4., 8., 6., 5., 2., 2., 1., 2., 2., 1., 2., 1., 0., 4., 3., 4., 4., 1., 2., 1., 1., 5., 3., 2., 1., 2., 5., 4., 0., 3., 4., 0., 1., 2., 5., 3., 0., 2., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 4., 2., 11., 2., 6., 0., 6., 13., 0., 18., 13., 1., 15., 5., 2., 4., 20., 0., 3., 18., 9., 16., 30., 9., 0., 0., 1., 3., 10., 10., 27., 11., 3., 22., 2., 15., 11., 1., 0., 5., 3., 12., 12., 11., 34., 12., 18., 14., 4., 1., 11., 2., 9., 1., 11., 3., 6., 10., 11., 14., 14., 3., 0., 0., 6., 1., 4., 5., 6., 3., 7., 1., 3., 5., 2., 1., 0., 5., 1., 0., 5., 2., 2., 2., 1., 5., 1., 4., 5., 0., 0., 1., 1., 6., 4., 0., 0., 0., 1., 0., 5., 1., 3., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 0., 1., 9., 2., 7., 0., 5., 26., 2., 10., 23., 2., 16., 0., 0., 3., 18., 0., 4., 27., 10., 39., 25., 7., 0., 2., 2., 3., 6., 4., 19., 16., 2., 13., 4., 10., 10., 2., 1., 1., 0., 19., 5., 25., 49., 6., 15., 19., 7., 0., 1., 0., 9., 5., 7., 11., 5., 19., 6., 23., 5., 3., 0., 3., 3., 0., 2., 1., 8., 6., 3., 1., 2., 3., 4., 1., 0., 2., 1., 0., 3., 0., 2., 6., 0., 4., 2., 6., 5., 2., 3., 0., 3., 7., 0., 0., 4., 0., 4., 1., 4., 4., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 0., 5., 11., 3., 7., 2., 7., 18., 2., 16., 24., 2., 16., 4., 1., 4., 31., 4., 2., 35., 17., 33., 30., 5., 0., 0., 1., 0., 3., 1., 20., 7., 2., 20., 3., 13., 7., 1., 0., 3., 0., 15., 15., 21., 40., 20., 27., 7., 4., 4., 9., 3., 5., 4., 16., 4., 6., 13., 6., 21., 7., 2., 2., 0., 8., 2., 3., 0., 8., 2., 6., 0., 4., 4., 6., 1., 2., 2., 3., 0., 1., 3., 4., 5., 1., 1., 2., 3., 5., 0., 1., 0., 2., 9., 2., 0., 1., 1., 2., 1., 2., 2., 4., 1., 3., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 5., 1., 5., 3., 7., 1., 8., 36., 1., 12., 22., 1., 4., 4., 3., 3., 19., 1., 3., 21., 11., 22., 25., 6., 1., 0., 3., 0., 5., 8., 24., 10., 5., 15., 2., 16., 11., 2., 0., 2., 1., 12., 13., 20., 51., 9., 27., 7., 1., 1., 9., 6., 3., 2., 9., 6., 9., 20., 4., 23., 6., 4., 1., 0., 9., 3., 3., 4., 8., 4., 4., 4., 2., 6., 1., 2., 1., 1., 2., 0., 2., 1., 1., 8., 2., 5., 4., 1., 3., 0., 1., 1., 2., 4., 1., 0., 1., 4., 3., 6., 1., 0., 8., 2., 0., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 3., 2., 6., 5., 5., 2., 0., 6., 13., 0., 18., 23., 0., 22., 1., 0., 4., 26., 1., 3., 24., 10., 18., 28., 4., 0., 1., 7., 3., 8., 12., 26., 17., 2., 17., 7., 21., 9., 1., 4., 3., 3., 12., 13., 15., 54., 12., 25., 8., 7., 1., 3., 2., 12., 3., 7., 5., 9., 13., 5., 25., 6., 1., 0., 1., 10., 2., 6., 2., 9., 2., 2., 4., 0., 4., 5., 1., 0., 2., 3., 0., 3., 4., 2., 8., 3., 4., 4., 4., 5., 2., 2., 3., 2., 8., 3., 0., 1., 2., 0., 4., 0., 2., 3., 0., 1., 0., 0., 0., 0., 2., 0., 0., 5., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 3., 9., 5., 5., 0., 7., 19., 1., 17., 14., 0., 16., 3., 2., 3., 26., 2., 3., 31., 12., 35., 19., 4., 0., 0., 2., 1., 11., 6., 20., 18., 1., 8., 7., 19., 8., 2., 1., 3., 2., 19., 21., 15., 44., 13., 24., 13., 2., 2., 3., 4., 7., 0., 13., 3., 7., 15., 4., 14., 4., 2., 2., 1., 5., 1., 4., 2., 8., 0., 5., 5., 1., 7., 4., 4., 4., 2., 4., 0., 2., 5., 2., 9., 4., 3., 3., 4., 5., 0., 0., 1., 4., 5., 1., 0., 3., 1., 1., 5., 4., 1., 2., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 5., 1., 11., 17., 4., 35., 0., 9., 151., 1., 23., 208., 5., 19., 9., 2., 7., 56., 1., 19., 297., 44., 367., 43., 17., 1., 2., 9., 3., 48., 36., 251., 33., 7., 144., 12., 48., 6., 0., 5., 15., 8., 56., 21., 91., 11., 23., 48., 17., 2., 2., 18., 7., 41., 14., 51., 8., 22., 4., 14., 7., 3., 0., 1., 0., 28., 5., 9., 4., 27., 3., 14., 2., 4., 7., 0., 1., 4., 0., 13., 4., 10., 0., 16., 1., 3., 6., 155., 8., 1789., 87., 104., 226., 96., 105., 72., 13., 16., 17., 12., 1., 1., 7., 4., 4., 13., 10., 42., 14., 27., 17., 30., 10., 12., 2., 4., 8., 10., 3., 3., 2., 10., 1., 0., 3., 6., 12., 2., 0., 12., 4., 1., 0., 5., 3., 4., 23., 5., 9., 5., 11., 1., 23., 0., 2., 4., 5., 21., 4., 28., 6., 3., 8., 4., 30., 7., 17., 6.,

17., 3., 3., 11., 17., 6., 28., 2., 13., 169., 3., 24., 197., 4., 15., 8., 0., 4., 88., 3., 16., 298., 41., 317., 32., 16., 0., 2., 5., 8., 50., 32., 252., 37., 10., 164., 14., 34., 4., 0., 1., 14., 5., 78., 29., 70., 6., 27., 48., 12., 2., 1., 29., 7., 39., 8., 49., 11., 26., 9., 6., 10., 2., 0., 2., 0., 24., 11., 14., 4., 28., 8., 9., 3., 1., 2., 0., 0., 1., 2., 9., 2., 8., 3., 6., 1., 0., 4., 141., 14., 1815., 97., 123., 209., 115., 119., 69., 19., 21., 29., 13., 2., 2., 5., 8., 2., 11., 10., 36., 19., 48., 17., 37., 8., 15., 5., 5., 5., 4., 1., 1., 5., 8., 1., 0., 4., 5., 14., 0., 0., 7., 3., 4., 0., 9., 1., 4., 33., 0., 8., 0., 12., 2., 22., 2., 3., 4., 4., 22., 6., 29., 4., 5., 5., 3., 29., 7., 12., 3.,

14., 1., 2., 5., 18., 9., 28., 1., 16., 177., 4., 24., 235., 5., 16., 6., 0., 3., 75., 1., 18., 292., 33., 305., 39., 11., 0., 1., 4., 6., 49., 21., 244., 30., 8., 161., 10., 33., 4., 0., 1., 14., 9., 54., 29., 81., 18., 29., 39., 13., 4., 1., 36., 5., 47., 10., 48., 7., 30., 10., 11., 10., 4., 0., 0., 0., 31., 4., 8., 4., 40., 8., 7., 4., 3., 0., 2., 1., 2., 0., 10., 3., 7., 3., 7., 1., 0., 3., 162., 9., 1823., 86., 97., 210., 91., 104., 80., 16., 8., 23., 16., 0., 0., 5., 3., 7., 11., 5., 32., 16., 32., 14., 47., 4., 8., 5., 5., 12., 5., 3., 5., 3., 11., 1., 0., 4., 3., 21., 5., 0., 12., 4., 4., 0., 5., 7., 1., 30., 1., 17., 3., 10., 2., 21., 1., 3., 8., 3., 26., 7., 25., 4., 1., 9., 3., 38., 12., 13., 5.,

15., 4., 3., 9., 29., 4., 29., 2., 12., 148., 3., 21., 208., 6., 25., 9., 1., 6., 74., 0., 13., 306., 47., 320., 37., 11., 0., 2., 5., 8., 36., 32., 225., 42., 9., 174., 15., 36., 3., 0., 2., 16., 7., 77., 22., 83., 18., 31., 52., 13., 0., 0., 29., 9., 44., 13., 40., 6., 31., 4., 10., 6., 3., 0., 0., 0., 22., 5., 17., 5., 29., 2., 11., 7., 1., 1., 2., 1., 2., 1., 8., 2., 7., 3., 12., 2., 2., 5., 137., 10., 1895., 85., 125., 220., 112., 111., 75., 13., 17., 18., 16., 0., 2., 8., 6., 4., 7., 3., 33., 19., 30., 19., 41., 7., 12., 5., 5., 4., 9., 1., 2., 2., 7., 4., 0., 3., 5., 9., 0., 0., 13., 3., 2., 0., 3., 5., 7., 33., 4., 8., 5., 13., 1., 17., 7., 3., 3., 5., 25., 9., 31., 3., 4., 7., 5., 26., 7., 4., 3.,

13., 4., 0., 12., 28., 4., 24., 0., 10., 167., 2., 24., 211., 5., 19., 9., 1., 4., 82., 2., 10., 265., 31., 316., 48., 11., 0., 5., 4., 5., 48., 33., 228., 45., 7., 163., 13., 51., 6., 0., 3., 22., 9., 84., 15., 78., 16., 34., 43., 13., 3., 1., 20., 4., 46., 8., 59., 7., 26., 1., 14., 8., 1., 0., 1., 0., 23., 4., 18., 2., 42., 1., 10., 2., 1., 4., 0., 1., 0., 2., 11., 3., 6., 4., 11., 2., 0., 5., 141., 7., 1863., 87., 111., 208., 114., 117., 70., 17., 14., 25., 20., 1., 0., 5., 9., 5., 11., 15., 38., 20., 29., 20., 45., 16., 8., 7., 10., 11., 6., 5., 1., 3., 10., 5., 0., 3., 8., 17., 3., 0., 7., 4., 6., 0., 6., 1., 3., 33., 3., 8., 0., 13., 3., 22., 0., 5., 2., 3., 27., 3., 26., 7., 3., 2., 4., 30., 3., 13., 5.,

7., 1., 1., 6., 28., 5., 37., 0., 15., 155., 5., 37., 199., 3., 17., 3., 1., 5., 87., 0., 19., 302., 37., 327., 44., 22., 1., 1., 9., 2., 49., 39., 230., 40., 12., 177., 13., 34., 4., 0., 0., 21., 11., 83., 21., 87., 13., 30., 57., 14., 2., 0., 25., 15., 42., 7., 55., 11., 31., 4., 6., 7., 2., 0., 3., 0., 18., 1., 10., 7., 33., 1., 8., 4., 1., 1., 1., 0., 5., 2., 8., 2., 6., 4., 8., 2., 0., 8., 155., 3., 1834., 90., 104., 235., 123., 126., 66., 16., 10., 10., 10., 2., 0., 9., 4., 4., 7., 6., 30., 11., 32., 20., 45., 2., 10., 4., 5., 8., 3., 1., 1., 2., 10., 1., 0., 7., 7., 11., 4., 0., 9., 3., 2., 0., 4., 4., 4., 27., 4., 9., 4., 8., 2., 23., 1., 5., 0., 6., 24., 9., 31., 5., 7., 8., 3., 34., 5., 13., 8.,

16., 1., 3., 9., 18., 8., 28., 1., 14., 135., 2., 26., 223., 4., 9., 4., 1., 8., 86., 1., 11., 297., 48., 332., 35., 20., 1., 0., 10., 7., 45., 45., 226., 39., 12., 141., 15., 34., 5., 0., 0., 13., 8., 90., 21., 90., 9., 29., 47., 9., 3., 0., 32., 9., 49., 12., 47., 7., 39., 9., 11., 7., 2., 0., 1., 0., 23., 2., 20., 3., 24., 9., 9., 7., 3., 3., 3., 0., 2., 2., 11., 5., 4., 3., 9., 0., 0., 1., 153., 11., 1870., 111., 93., 237., 95., 99., 63., 26., 17., 20., 10., 0., 0., 3., 5., 4., 2., 9., 35., 17., 29., 22., 38., 6., 13., 3., 4., 9., 7., 0., 2., 7., 6., 2., 0., 7., 1., 17., 1., 0., 4., 4., 3., 0., 7., 1., 2., 41., 2., 7., 4., 7., 3., 27., 1., 3., 5., 5., 26., 5., 26., 7., 8., 6., 0., 30., 5., 14., 4.,

17., 0., 2., 15., 23., 9., 30., 0., 20., 150., 1., 33., 202., 9., 14., 9., 2., 7., 90., 3., 18., 297., 48., 335., 57., 22., 2., 0., 6., 4., 44., 36., 226., 37., 4., 144., 15., 46., 4., 0., 1., 16., 6., 97., 17., 94., 21., 34., 40., 11., 2., 0., 19., 4., 41., 8., 55., 8., 26., 6., 12., 10., 0., 0., 0., 0., 15., 10., 21., 4., 25., 10., 8., 2., 2., 5., 0., 0., 3., 0., 16., 0., 6., 2., 9., 0., 1., 5., 125., 9., 1903., 86., 98., 234., 100., 110., 63., 18., 14., 14., 16., 0., 1., 1., 6., 4., 4., 11., 49., 16., 41., 14., 45., 4., 13., 6., 4., 4., 3., 1., 4., 1., 9., 2., 0., 7., 9., 16., 3., 0., 6., 3., 4., 0., 5., 5., 1., 40., 0., 14., 2., 17., 3., 23., 7., 3., 2., 6., 17., 5., 29., 9., 4., 9., 5., 32., 8., 11., 6.,

10., 1., 4., 6., 29., 5., 29., 0., 16., 177., 4., 27., 193., 5., 15., 14., 0., 6., 61., 2., 15., 253., 48., 321., 36., 18., 0., 4., 13., 4., 47., 29., 228., 31., 7., 180., 21., 48., 8., 0., 4., 21., 4., 67., 21., 66., 13., 32., 62., 13., 3., 1., 15., 9., 39., 12., 46., 5., 39., 2., 8., 4., 2., 0., 3., 0., 18., 3., 9., 4., 31., 5., 3., 6., 3., 4., 3., 0., 2., 2., 9., 3., 3., 2., 9., 0., 0., 2., 126., 11., 1885., 82., 91., 223., 114., 115., 78., 13., 15., 21., 12., 0., 4., 5., 4., 3., 3., 5., 37., 24., 35., 15., 44., 3., 18., 4., 4., 6., 6., 3., 2., 7., 8., 4., 0., 4., 2., 19., 2., 0., 9., 7., 2., 0., 6., 2., 3., 30., 3., 10., 5., 9., 2., 23., 1., 2., 4., 2., 23., 5., 27., 6., 4., 7., 5., 24., 10., 11., 2.,

18., 0., 4., 10., 31., 10., 28., 0., 17., 145., 0., 28., 198., 4., 11., 7., 0., 1., 79., 1., 15., 262., 32., 336., 38., 11., 2., 0., 7., 4., 43., 38., 231., 47., 14., 178., 13., 32., 5., 0., 5., 26., 7., 66., 29., 84., 15., 34., 38., 13., 4., 1., 20., 6., 29., 10., 63., 11., 17., 6., 13., 8., 1., 0., 0., 0., 22., 5., 10., 3., 33., 4., 16., 4., 2., 3., 6., 1., 4., 1., 11., 1., 5., 5., 2., 2., 1., 7., 162., 9., 1943., 97., 102., 200., 91., 110., 66., 20., 22., 20., 9., 0., 1., 6., 8., 5., 11., 13., 22., 17., 32., 13., 44., 5., 12., 10., 7., 7., 1., 2., 5., 0., 9., 3., 0., 5., 2., 16., 3., 0., 13., 3., 3., 0., 2., 4., 6., 33., 7., 13., 3., 9., 7., 19., 2., 1., 4., 7., 26., 5., 40., 3., 5., 5., 2., 33., 4., 15., 8.,

16., 4., 4., 10., 28., 2., 32., 1., 14., 153., 1., 31., 215., 14., 20., 4., 1., 8., 86., 5., 15., 269., 45., 330., 47., 14., 0., 1., 5., 7., 49., 40., 223., 44., 9., 173., 13., 47., 5., 0., 0., 16., 7., 82., 17., 94., 21., 34., 41., 13., 3., 1., 16., 7., 41., 9., 45., 7., 47., 8., 14., 7., 3., 0., 2., 0., 20., 5., 10., 2., 23., 5., 13., 4., 3., 2., 1., 1., 3., 2., 11., 0., 4., 4., 8., 0., 0., 2., 138., 1., 1868., 94., 87., 246., 82., 103., 74., 10., 17., 24., 14., 0., 1., 9., 2., 4., 9., 15., 41., 13., 46., 11., 51., 7., 6., 4., 9., 7., 3., 1., 4., 4., 4., 4., 0., 3., 7., 8., 4., 0., 8., 5., 3., 0., 5., 0., 3., 31., 3., 10., 5., 13., 1., 19., 3., 5., 7., 2., 35., 2., 32., 10., 10., 5., 7., 19., 6., 15., 6.,

15., 3., 1., 3., 29., 6., 27., 1., 15., 148., 1., 31., 219., 4., 16., 7., 0., 4., 73., 2., 12., 251., 50., 351., 37., 20., 1., 1., 7., 8., 49., 39., 233., 31., 10., 166., 13., 45., 7., 0., 1., 16., 4., 79., 16., 84., 15., 22., 43., 11., 4., 1., 24., 5., 37., 19., 49., 11., 35., 7., 12., 5., 6., 0., 2., 0., 26., 9., 17., 3., 37., 4., 16., 5., 1., 5., 1., 0., 4., 3., 18., 4., 10., 0., 11., 0., 0., 2., 148., 3., 1827., 107., 97., 222., 75., 118., 54., 19., 10., 18., 11., 0., 2., 7., 1., 3., 7., 9., 42., 16., 28., 14., 38., 7., 8., 5., 4., 8., 11., 3., 6., 3., 11., 3., 0., 4., 5., 18., 4., 0., 10., 4., 2., 0., 5., 3., 1., 33., 3., 15., 6., 16., 2., 21., 4., 2., 2., 6., 25., 4., 32., 3., 6., 2., 4., 22., 7., 8., 4.,

15., 3., 1., 18., 22., 10., 22., 1., 16., 161., 5., 19., 211., 7., 15., 5., 0., 6., 67., 2., 16., 318., 38., 340., 46., 18., 0., 3., 8., 5., 50., 34., 261., 44., 5., 154., 17., 37., 5., 0., 0., 13., 5., 91., 18., 78., 12., 34., 46., 18., 2., 1., 28., 13., 39., 10., 48., 6., 38., 6., 12., 5., 1., 0., 0., 0., 23., 5., 19., 1., 26., 5., 9., 8., 1., 2., 1., 1., 1., 5., 9., 3., 7., 3., 7., 2., 1., 4., 150., 7., 1921., 84., 110., 198., 104., 111., 59., 17., 14., 14., 14., 1., 0., 6., 1., 2., 11., 4., 34., 16., 26., 17., 41., 6., 16., 3., 3., 7., 4., 3., 0., 1., 9., 5., 0., 3., 6., 8., 3., 0., 13., 4., 3., 0., 3., 2., 2., 31., 4., 11., 5., 11., 4., 16., 0., 1., 5., 3., 26., 9., 31., 6., 10., 10., 6., 38., 7., 5., 6.,

16., 0., 2., 6., 27., 3., 36., 0., 23., 180., 6., 27., 235., 5., 12., 14., 0., 7., 93., 3., 19., 303., 50., 316., 41., 19., 1., 3., 7., 2., 42., 33., 238., 47., 11., 168., 15., 42., 8., 0., 1., 23., 2., 74., 23., 82., 14., 32., 51., 9., 3., 2., 20., 6., 46., 10., 47., 7., 24., 3., 12., 5., 2., 0., 2., 0., 25., 1., 13., 1., 26., 8., 6., 8., 2., 6., 0., 1., 3., 0., 13., 3., 11., 2., 9., 4., 0., 4., 133., 11., 1865., 106., 99., 218., 85., 111., 70., 16., 7., 17., 17., 1., 4., 7., 3., 8., 9., 3., 42., 16., 23., 13., 37., 11., 12., 3., 3., 8., 2., 1., 6., 2., 12., 6., 0., 2., 0., 11., 5., 0., 9., 3., 4., 0., 3., 1., 5., 27., 6., 10., 4., 10., 6., 25., 3., 5., 6., 4., 37., 5., 34., 7., 7., 7., 4., 24., 2., 13., 4.,

17., 2., 1., 5., 11., 3., 5., 0., 8., 24., 2., 14., 29., 0., 27., 3., 0., 3., 11., 2., 4., 25., 11., 13., 26., 6., 1., 0., 3., 1., 6., 10., 33., 13., 4., 9., 6., 7., 8., 2., 0., 3., 2., 16., 5., 19., 58., 15., 22., 8., 5., 1., 0., 2., 6., 2., 8., 6., 6., 15., 10., 22., 12., 1., 1., 0., 5., 2., 6., 1., 1., 2., 2., 3., 3., 2., 4., 3., 2., 2., 0., 0., 0., 2., 2., 5., 1., 7., 4., 2., 3., 2., 5., 2., 3., 10., 0., 0., 3., 2., 3., 4., 1., 1., 2., 1., 4., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 2., 9., 7., 1., 8., 0., 5., 19., 1., 10., 29., 0., 19., 2., 0., 1., 17., 1., 7., 30., 13., 25., 18., 9., 1., 1., 5., 1., 18., 9., 24., 9., 4., 19., 8., 11., 5., 2., 2., 2., 2., 14., 13., 15., 42., 12., 19., 8., 4., 0., 3., 3., 8., 3., 13., 7., 4., 26., 7., 22., 8., 6., 1., 1., 7., 1., 1., 2., 4., 4., 4., 3., 2., 1., 2., 1., 3., 0., 2., 0., 2., 1., 1., 6., 2., 5., 0., 0., 3., 2., 1., 3., 2., 12., 1., 0., 1., 2., 3., 3., 1., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 0., 4., 8., 4., 8., 1., 8., 28., 1., 10., 24., 0., 16., 5., 2., 2., 10., 3., 4., 23., 11., 32., 23., 5., 0., 1., 5., 1., 13., 7., 24., 11., 4., 11., 9., 14., 9., 0., 2., 3., 1., 13., 12., 16., 50., 6., 19., 8., 2., 0., 3., 1., 6., 3., 9., 5., 10., 15., 6., 17., 6., 2., 0., 0., 10., 0., 7., 0., 6., 1., 7., 3., 2., 3., 2., 0., 2., 1., 3., 0., 3., 6., 2., 8., 4., 9., 2., 1., 4., 1., 3., 4., 4., 8., 2., 0., 2., 1., 2., 3., 4., 0., 2., 0., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 5., 6., 2., 1., 1., 8., 31., 0., 16., 21., 0., 16., 5., 0., 0., 21., 0., 1., 24., 12., 34., 23., 7., 1., 0., 3., 4., 13., 6., 33., 22., 2., 11., 3., 15., 11., 3., 1., 3., 2., 14., 9., 21., 39., 15., 28., 10., 5., 1., 7., 4., 7., 1., 10., 10., 12., 23., 7., 27., 9., 6., 0., 0., 5., 3., 4., 4., 2., 5., 4., 5., 2., 9., 3., 2., 1., 2., 3., 0., 1., 2., 4., 4., 5., 4., 0., 5., 5., 1., 3., 0., 4., 8., 1., 0., 0., 2., 0., 5., 0., 2., 2., 2., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 3., 3., 13., 2., 9., 2., 2., 33., 2., 8., 23., 1., 14., 7., 1., 2., 19., 1., 5., 36., 11., 23., 24., 1., 1., 2., 4., 4., 4., 14., 20., 19., 6., 24., 3., 18., 6., 0., 0., 6., 4., 16., 10., 13., 42., 8., 23., 11., 6., 2., 6., 3., 5., 6., 7., 7., 9., 16., 9., 22., 16., 3., 2., 0., 4., 0., 4., 6., 4., 8., 3., 6., 1., 1., 3., 5., 0., 3., 4., 0., 0., 2., 2., 6., 2., 5., 2., 3., 1., 1., 4., 0., 3., 2., 6., 0., 3., 1., 3., 1., 0., 3., 1., 1., 1., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 3., 2., 8., 3., 6., 0., 3., 22., 1., 10., 26., 1., 21., 2., 2., 4., 19., 6., 3., 18., 11., 34., 29., 8., 1., 2., 0., 2., 7., 5., 31., 17., 5., 19., 1., 17., 9., 1., 0., 5., 3., 16., 8., 17., 36., 8., 25., 7., 3., 2., 5., 2., 5., 3., 9., 5., 8., 14., 4., 29., 6., 4., 0., 3., 8., 0., 0., 0., 3., 1., 4., 4., 2., 4., 4., 1., 1., 2., 0., 0., 6., 4., 1., 4., 3., 4., 2., 3., 7., 0., 0., 1., 0., 4., 0., 0., 3., 1., 2., 4., 0., 1., 3., 1., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 1., 2., 6., 10., 4., 10., 0., 5., 33., 1., 12., 22., 2., 13., 1., 1., 1., 18., 2., 7., 24., 13., 29., 28., 14., 0., 1., 5., 2., 7., 7., 30., 19., 1., 19., 4., 20., 6., 3., 2., 4., 2., 9., 16., 15., 48., 13., 15., 9., 6., 1., 11., 1., 4., 2., 13., 9., 9., 11., 5., 18., 11., 3., 2., 2., 9., 1., 0., 3., 6., 1., 0., 3., 4., 7., 3., 2., 2., 0., 1., 0., 4., 2., 2., 10., 4., 1., 2., 4., 1., 0., 3., 0., 3., 9., 2., 0., 4., 2., 2., 4., 3., 2., 2., 1., 5., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 7., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 4., 7., 6., 5., 4., 3., 5., 21., 0., 9., 25., 3., 15., 4., 0., 0., 14., 1., 7., 31., 10., 24., 31., 6., 1., 1., 5., 4., 8., 6., 24., 14., 3., 9., 9., 18., 9., 5., 0., 5., 3., 17., 9., 12., 47., 15., 12., 8., 6., 0., 7., 4., 5., 4., 10., 6., 12., 10., 4., 18., 13., 5., 1., 1., 6., 3., 7., 3., 6., 5., 6., 4., 2., 7., 3., 1., 1., 1., 0., 0., 4., 2., 3., 4., 2., 2., 1., 1., 0., 1., 0., 1., 2., 4., 2., 0., 2., 2., 1., 3., 2., 3., 3., 0., 1., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 3., 1., 8., 1., 2., 2., 6., 36., 1., 18., 19., 1., 16., 0., 2., 1., 28., 2., 1., 24., 9., 18., 31., 3., 1., 1., 1., 1., 9., 11., 24., 17., 4., 21., 3., 12., 11., 4., 1., 4., 5., 15., 21., 19., 44., 15., 17., 4., 4., 2., 2., 6., 7., 2., 8., 11., 9., 11., 4., 23., 7., 4., 0., 2., 9., 1., 3., 1., 4., 2., 5., 4., 1., 2., 6., 2., 0., 2., 1., 0., 5., 2., 1., 1., 2., 7., 1., 3., 6., 1., 2., 0., 2., 4., 2., 0., 0., 1., 3., 1., 5., 2., 3., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 2., 3., 4., 10., 5., 10., 5., 10., 25., 1., 16., 15., 0., 17., 5., 0., 0., 15., 3., 6., 29., 15., 28., 29., 9., 1., 1., 0., 2., 3., 7., 22., 23., 2., 14., 4., 20., 11., 4., 1., 4., 3., 12., 8., 22., 44., 12., 24., 11., 1., 2., 3., 0., 9., 4., 9., 6., 12., 9., 6., 21., 6., 3., 0., 0., 8., 2., 2., 1., 6., 3., 8., 1., 2., 3., 3., 2., 0., 2., 1., 0., 1., 2., 3., 6., 3., 3., 2., 1., 9., 6., 1., 1., 2., 2., 0., 0., 3., 1., 3., 4., 1., 2., 0., 2., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 4., 1., 10., 2., 8., 2., 4., 17., 0., 6., 18., 1., 14., 4., 0., 1., 20., 1., 5., 20., 11., 21., 32., 9., 3., 0., 5., 2., 8., 5., 23., 16., 1., 6., 5., 9., 12., 2., 1., 7., 1., 7., 15., 20., 43., 22., 16., 6., 3., 1., 11., 2., 6., 0., 13., 6., 10., 16., 3., 20., 9., 4., 1., 0., 7., 0., 3., 2., 11., 2., 3., 3., 1., 5., 1., 0., 2., 1., 1., 0., 1., 2., 3., 5., 1., 5., 2., 0., 6., 1., 1., 1., 2., 12., 2., 0., 5., 3., 6., 1., 2., 2., 2., 0., 5., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 5., 3., 5., 4., 6., 3., 4., 2., 0., 5., 27., 0., 16., 5., 1., 1., 7., 2., 5., 19., 12., 23., 35., 4., 1., 1., 1., 0., 8., 5., 28., 19., 5., 16., 0., 14., 5., 3., 0., 4., 4., 8., 12., 14., 36., 13., 19., 16., 10., 0., 2., 3., 12., 2., 12., 7., 5., 13., 5., 14., 10., 2., 2., 1., 10., 1., 4., 3., 3., 5., 4., 4., 1., 5., 5., 2., 1., 1., 2., 0., 0., 5., 2., 5., 2., 7., 2., 0., 2., 0., 2., 1., 1., 3., 1., 0., 1., 3., 1., 2., 2., 1., 1., 2., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 0., 1., 11., 3., 10., 1., 9., 20., 0., 17., 19., 1., 23., 7., 2., 2., 16., 2., 6., 25., 16., 23., 30., 4., 1., 0., 3., 5., 0., 11., 25., 20., 2., 9., 8., 17., 9., 4., 1., 3., 1., 9., 9., 20., 36., 5., 12., 11., 8., 2., 6., 0., 7., 3., 15., 5., 12., 22., 10., 23., 5., 3., 0., 1., 12., 0., 1., 3., 6., 2., 8., 6., 2., 3., 1., 3., 1., 0., 2., 0., 1., 3., 2., 9., 1., 3., 4., 0., 4., 0., 1., 1., 3., 4., 1., 0., 2., 1., 0., 1., 6., 2., 0., 2., 3., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 3., 7., 5., 6., 4., 0., 4., 20., 0., 17., 20., 1., 12., 5., 1., 2., 31., 0., 4., 26., 12., 18., 14., 6., 0., 1., 4., 2., 6., 10., 24., 20., 2., 10., 2., 12., 6., 2., 0., 3., 3., 12., 8., 15., 60., 10., 21., 8., 5., 1., 8., 4., 13., 2., 8., 8., 15., 15., 6., 14., 10., 1., 0., 2., 10., 1., 3., 0., 9., 2., 4., 4., 3., 5., 4., 0., 0., 0., 4., 0., 2., 4., 1., 8., 2., 7., 2., 2., 8., 3., 2., 1., 1., 8., 3., 0., 2., 3., 0., 2., 2., 1., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 0., 3., 9., 1., 7., 1., 9., 13., 1., 7., 23., 1., 12., 2., 1., 0., 19., 2., 4., 15., 16., 24., 28., 4., 1., 1., 2., 2., 5., 15., 18., 16., 0., 12., 3., 11., 4., 2., 2., 8., 4., 14., 9., 23., 50., 15., 21., 7., 4., 1., 3., 0., 10., 2., 6., 4., 9., 16., 7., 22., 5., 4., 1., 2., 13., 0., 2., 1., 7., 2., 4., 5., 4., 7., 6., 0., 0., 2., 0., 0., 1., 1., 1., 4., 5., 4., 0., 0., 3., 0., 2., 0., 1., 8., 0., 0., 0., 2., 1., 1., 3., 2., 2., 3., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 1., 4., 3., 2., 7., 1., 11., 28., 5., 14., 31., 0., 10., 5., 0., 1., 13., 0., 5., 27., 6., 20., 23., 7., 1., 0., 3., 2., 6., 5., 24., 17., 4., 10., 4., 10., 8., 0., 0., 6., 4., 5., 12., 21., 35., 16., 14., 8., 4., 4., 5., 3., 6., 2., 9., 9., 9., 15., 6., 21., 6., 2., 1., 1., 9., 1., 3., 1., 2., 4., 5., 8., 1., 6., 3., 2., 3., 1., 1., 0., 1., 3., 4., 8., 1., 7., 2., 3., 3., 0., 2., 0., 1., 6., 1., 0., 1., 4., 3., 1., 2., 1., 3., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 2., 2., 2., 4., 4., 2., 6., 16., 0., 8., 24., 1., 16., 3., 0., 2., 16., 0., 4., 17., 8., 35., 26., 5., 0., 1., 2., 2., 7., 13., 26., 18., 2., 15., 1., 8., 4., 2., 2., 3., 2., 19., 6., 12., 41., 7., 24., 6., 4., 0., 6., 5., 9., 4., 11., 6., 7., 12., 1., 27., 11., 5., 0., 0., 8., 1., 2., 1., 7., 1., 3., 4., 3., 5., 4., 3., 1., 2., 1., 0., 2., 1., 4., 6., 0., 4., 4., 3., 6., 0., 0., 1., 3., 7., 1., 0., 2., 1., 2., 1., 3., 3., 0., 3., 6., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 5., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 1., 0., 21., 0., 16., 5., 7., 45., 2., 10., 70., 1., 6., 2., 0., 4., 66., 9., 8., 75., 14., 80., 11., 3., 0., 1., 2., 1., 11., 8., 54., 9., 0., 35., 44., 13., 1., 0., 1., 4., 5., 32., 5., 24., 8., 19., 8., 0., 1., 0., 9., 1., 18., 6., 15., 5., 12., 3., 3., 36., 9., 6., 3., 0., 12., 5., 5., 0., 16., 6., 2., 0., 1., 1., 0., 5., 3., 19., 4., 3., 7., 2., 3., 0., 0., 0., 0., 0., 8., 4., 0., 1., 4., 2., 1., 0., 0., 0., 2., 0., 3., 4., 1., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 1., 1., 2., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 26., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 1., 6., 27., 9., 33., 1., 12., 161., 4., 27., 227., 6., 13., 9., 1., 7., 70., 3., 11., 268., 44., 297., 51., 18., 0., 4., 5., 5., 48., 36., 232., 46., 11., 159., 18., 38., 3., 0., 0., 22., 10., 85., 25., 93., 17., 38., 44., 16., 2., 2., 31., 8., 46., 8., 52., 7., 36., 8., 13., 5., 1., 0., 1., 0., 17., 8., 9., 1., 34., 3., 12., 4., 3., 3., 0., 3., 3., 1., 9., 4., 8., 5., 11., 3., 0., 5., 129., 4., 1868., 103., 97., 201., 82., 108., 66., 16., 7., 19., 10., 3., 1., 6., 2., 5., 11., 7., 39., 16., 38., 18., 37., 9., 8., 1., 9., 7., 11., 1., 5., 5., 6., 7., 0., 4., 6., 11., 3., 0., 9., 3., 4., 0., 8., 2., 2., 26., 3., 12., 3., 12., 2., 27., 3., 3., 4., 2., 23., 4., 26., 6., 8., 8., 6., 32., 5., 7., 6.,

19., 1., 7., 10., 26., 7., 36., 0., 15., 139., 4., 31., 210., 7., 21., 5., 3., 4., 100., 2., 12., 276., 45., 332., 47., 18., 2., 1., 8., 6., 36., 39., 205., 36., 8., 169., 16., 34., 5., 0., 1., 16., 8., 65., 24., 96., 9., 36., 54., 14., 3., 0., 22., 8., 29., 8., 39., 11., 27., 3., 12., 7., 3., 0., 1., 0., 17., 6., 12., 4., 30., 7., 12., 6., 1., 3., 0., 3., 4., 5., 14., 2., 12., 3., 7., 2., 0., 5., 132., 4., 1922., 93., 115., 225., 89., 117., 74., 19., 9., 14., 12., 3., 1., 3., 6., 1., 5., 14., 30., 17., 45., 14., 37., 10., 12., 3., 6., 7., 2., 3., 2., 2., 7., 1., 0., 7., 5., 13., 1., 0., 8., 4., 2., 0., 7., 3., 6., 36., 2., 15., 4., 19., 4., 29., 2., 3., 7., 6., 27., 2., 19., 9., 5., 4., 5., 31., 6., 10., 5.,

15., 3., 3., 4., 29., 8., 28., 3., 19., 200., 4., 27., 215., 7., 16., 6., 0., 8., 87., 3., 21., 283., 31., 305., 41., 19., 2., 2., 10., 5., 38., 19., 246., 35., 10., 155., 15., 40., 6., 0., 4., 19., 8., 74., 25., 82., 18., 35., 46., 19., 2., 1., 26., 7., 30., 13., 46., 6., 37., 5., 6., 8., 1., 0., 0., 0., 30., 7., 16., 5., 27., 5., 12., 7., 2., 0., 2., 1., 1., 3., 13., 4., 9., 3., 6., 0., 1., 3., 155., 10., 1946., 86., 76., 206., 104., 129., 71., 16., 18., 12., 11., 0., 5., 9., 9., 5., 7., 12., 38., 18., 24., 13., 46., 14., 8., 5., 4., 3., 6., 5., 4., 4., 10., 1., 0., 6., 4., 14., 2., 0., 15., 3., 2., 0., 5., 2., 1., 31., 3., 14., 3., 13., 2., 18., 3., 1., 7., 8., 27., 3., 37., 8., 9., 7., 7., 33., 8., 11., 9.,

9., 4., 3., 7., 28., 8., 33., 0., 22., 145., 6., 21., 186., 8., 17., 6., 0., 2., 63., 2., 14., 277., 49., 349., 44., 17., 2., 3., 6., 5., 38., 24., 250., 40., 11., 177., 12., 25., 7., 0., 0., 14., 5., 93., 11., 87., 21., 40., 43., 19., 4., 0., 16., 7., 44., 9., 56., 5., 36., 6., 8., 7., 3., 0., 2., 0., 27., 6., 16., 3., 26., 9., 19., 6., 2., 4., 0., 2., 3., 1., 14., 6., 10., 3., 12., 0., 1., 1., 128., 5., 1873., 87., 106., 219., 92., 110., 80., 15., 6., 21., 17., 0., 3., 10., 7., 2., 7., 11., 44., 21., 39., 12., 39., 6., 11., 5., 5., 4., 4., 2., 1., 2., 7., 3., 0., 3., 7., 20., 4., 0., 11., 5., 3., 0., 5., 7., 4., 37., 2., 8., 4., 9., 2., 27., 3., 3., 4., 7., 15., 7., 31., 4., 4., 10., 10., 25., 7., 10., 4.,

11., 2., 1., 13., 20., 3., 32., 0., 17., 154., 5., 27., 185., 3., 17., 9., 2., 6., 91., 2., 10., 301., 62., 310., 36., 15., 0., 0., 6., 6., 39., 35., 211., 50., 8., 175., 21., 36., 7., 0., 5., 18., 6., 100., 25., 87., 17., 35., 46., 22., 3., 1., 22., 5., 46., 5., 48., 11., 29., 4., 10., 6., 3., 0., 1., 0., 28., 3., 17., 3., 32., 7., 12., 2., 6., 3., 1., 2., 3., 1., 7., 1., 11., 3., 7., 0., 1., 3., 151., 8., 1896., 97., 110., 216., 103., 113., 68., 21., 14., 13., 13., 2., 2., 2., 7., 3., 10., 9., 28., 18., 31., 17., 47., 4., 14., 9., 5., 10., 6., 3., 3., 4., 8., 4., 0., 2., 5., 13., 3., 0., 12., 3., 4., 0., 1., 2., 1., 38., 5., 11., 1., 10., 5., 23., 1., 1., 4., 3., 30., 6., 42., 4., 8., 6., 3., 30., 9., 18., 5.,

10., 1., 3., 14., 39., 2., 29., 0., 9., 153., 3., 24., 188., 7., 14., 3., 0., 4., 75., 1., 17., 287., 48., 345., 37., 14., 1., 2., 4., 4., 49., 29., 237., 41., 8., 165., 16., 35., 4., 0., 1., 21., 8., 74., 23., 91., 23., 41., 46., 19., 3., 0., 32., 4., 31., 13., 56., 7., 25., 4., 8., 6., 4., 0., 0., 0., 23., 3., 19., 3., 28., 3., 10., 8., 0., 1., 0., 2., 2., 7., 12., 1., 9., 1., 5., 0., 2., 2., 132., 7., 1944., 83., 98., 213., 89., 92., 66., 24., 12., 23., 22., 1., 1., 4., 6., 2., 13., 13., 37., 14., 33., 16., 52., 4., 12., 4., 3., 6., 4., 1., 3., 6., 8., 2., 0., 2., 5., 11., 2., 0., 1., 3., 1., 0., 12., 2., 3., 30., 3., 16., 3., 11., 4., 17., 3., 5., 5., 10., 13., 3., 37., 7., 2., 9., 6., 40., 8., 11., 7.,

11., 0., 1., 11., 19., 3., 35., 0., 14., 156., 3., 21., 200., 5., 11., 7., 1., 12., 85., 3., 16., 293., 46., 321., 34., 16., 1., 3., 8., 8., 37., 28., 238., 41., 8., 152., 14., 53., 4., 0., 1., 16., 9., 88., 16., 83., 12., 41., 35., 10., 1., 0., 26., 6., 44., 15., 51., 10., 21., 7., 14., 8., 3., 0., 1., 0., 23., 7., 16., 3., 36., 8., 7., 4., 1., 1., 1., 2., 6., 1., 17., 2., 9., 0., 12., 2., 1., 5., 164., 6., 1867., 89., 93., 216., 90., 116., 56., 9., 18., 25., 13., 1., 3., 7., 3., 5., 10., 11., 30., 19., 40., 13., 33., 4., 9., 4., 4., 12., 4., 0., 2., 2., 12., 6., 0., 3., 6., 20., 3., 0., 15., 5., 2., 0., 7., 3., 4., 38., 3., 10., 1., 14., 1., 19., 2., 3., 4., 5., 21., 7., 29., 8., 5., 9., 3., 29., 4., 10., 6.,

9., 5., 4., 5., 20., 6., 37., 1., 20., 163., 2., 33., 206., 5., 18., 7., 2., 4., 64., 3., 21., 262., 49., 359., 46., 15., 2., 0., 4., 5., 40., 40., 221., 34., 6., 166., 17., 28., 6., 0., 4., 28., 10., 80., 24., 70., 12., 41., 56., 16., 2., 0., 26., 5., 45., 13., 53., 15., 31., 6., 16., 4., 0., 0., 4., 0., 24., 5., 16., 5., 35., 6., 7., 7., 0., 2., 0., 2., 3., 2., 7., 2., 7., 1., 5., 1., 0., 6., 144., 16., 1861., 90., 111., 211., 80., 107., 67., 11., 10., 20., 19., 1., 2., 6., 11., 5., 12., 6., 34., 19., 35., 10., 50., 6., 10., 3., 11., 6., 5., 1., 3., 4., 13., 2., 0., 0., 3., 11., 0., 0., 9., 5., 4., 0., 9., 2., 2., 46., 4., 14., 7., 11., 4., 23., 2., 4., 3., 5., 29., 6., 34., 9., 7., 10., 6., 37., 11., 18., 4.,

19., 0., 4., 7., 15., 7., 23., 0., 13., 152., 4., 20., 197., 2., 15., 8., 1., 4., 79., 1., 12., 275., 37., 338., 37., 15., 1., 1., 13., 2., 51., 32., 250., 48., 9., 182., 12., 34., 6., 0., 2., 18., 4., 77., 14., 95., 13., 33., 47., 14., 8., 1., 24., 2., 31., 15., 54., 10., 24., 10., 9., 4., 0., 0., 0., 0., 27., 4., 12., 2., 38., 2., 8., 2., 0., 3., 0., 1., 3., 2., 5., 2., 9., 4., 5., 2., 2., 3., 154., 8., 1823., 118., 96., 218., 83., 104., 62., 16., 5., 21., 9., 1., 4., 11., 5., 1., 9., 6., 32., 13., 36., 17., 37., 3., 13., 6., 3., 1., 3., 1., 3., 3., 9., 3., 0., 5., 0., 22., 0., 0., 18., 2., 4., 0., 5., 2., 2., 34., 3., 18., 4., 11., 3., 16., 5., 2., 4., 4., 29., 6., 30., 1., 2., 5., 7., 34., 6., 12., 4.,

16., 5., 4., 11., 29., 11., 29., 1., 20., 160., 4., 34., 194., 9., 24., 8., 1., 7., 80., 0., 20., 272., 44., 341., 46., 15., 0., 4., 11., 7., 35., 31., 249., 34., 9., 165., 13., 34., 2., 0., 2., 20., 8., 71., 23., 86., 11., 32., 37., 13., 3., 1., 19., 9., 37., 16., 58., 5., 34., 9., 8., 8., 2., 0., 1., 0., 32., 4., 16., 4., 31., 3., 9., 8., 2., 2., 0., 1., 4., 1., 18., 5., 8., 2., 11., 0., 1., 7., 107., 14., 1910., 91., 83., 221., 99., 123., 77., 20., 9., 23., 16., 1., 2., 8., 6., 4., 11., 14., 38., 15., 39., 21., 44., 2., 10., 5., 5., 7., 4., 1., 5., 1., 11., 2., 0., 1., 6., 11., 0., 0., 10., 2., 3., 0., 5., 3., 4., 32., 5., 10., 3., 7., 2., 18., 4., 3., 4., 5., 30., 7., 21., 6., 4., 8., 3., 26., 8., 14., 7.,

7., 2., 2., 8., 23., 7., 28., 1., 26., 158., 4., 24., 205., 3., 21., 5., 0., 6., 86., 0., 17., 290., 46., 298., 51., 24., 1., 0., 8., 3., 45., 36., 228., 29., 13., 167., 10., 29., 5., 0., 3., 13., 7., 84., 25., 99., 15., 33., 50., 11., 3., 0., 25., 3., 33., 11., 56., 8., 35., 4., 8., 7., 0., 0., 0., 0., 16., 8., 9., 2., 26., 5., 15., 2., 1., 3., 0., 1., 5., 0., 11., 3., 10., 0., 10., 0., 1., 1., 147., 9., 1947., 78., 86., 232., 87., 112., 62., 20., 18., 14., 17., 0., 1., 7., 4., 5., 8., 14., 45., 17., 44., 17., 39., 11., 8., 4., 6., 8., 2., 1., 6., 2., 12., 1., 0., 2., 4., 14., 2., 0., 15., 1., 3., 0., 9., 0., 3., 30., 5., 7., 2., 13., 3., 19., 2., 1., 4., 5., 23., 3., 35., 10., 4., 9., 6., 20., 6., 16., 1.,

7., 2., 4., 7., 23., 5., 33., 0., 17., 170., 4., 23., 218., 7., 15., 7., 1., 9., 86., 1., 13., 309., 51., 372., 38., 22., 1., 3., 4., 7., 60., 36., 214., 57., 4., 155., 10., 40., 10., 0., 2., 11., 6., 79., 16., 87., 20., 38., 43., 7., 1., 0., 28., 7., 26., 11., 48., 9., 33., 3., 9., 6., 5., 0., 0., 0., 17., 4., 10., 3., 39., 7., 8., 2., 3., 2., 0., 4., 1., 3., 12., 3., 7., 0., 7., 1., 0., 4., 173., 8., 1941., 89., 100., 212., 92., 109., 62., 14., 12., 17., 10., 1., 4., 8., 1., 5., 5., 6., 41., 27., 33., 14., 37., 4., 9., 1., 7., 8., 8., 1., 4., 4., 7., 6., 0., 3., 5., 11., 2., 0., 8., 5., 4., 0., 6., 1., 2., 27., 1., 7., 3., 11., 2., 25., 4., 4., 3., 6., 20., 2., 30., 11., 5., 8., 4., 29., 5., 7., 5.,

3., 1., 1., 4., 6., 1., 6., 0., 2., 20., 1., 24., 34., 1., 12., 2., 0., 3., 15., 3., 3., 19., 14., 26., 33., 4., 0., 0., 2., 4., 5., 9., 24., 16., 2., 18., 1., 12., 12., 0., 2., 3., 1., 14., 10., 29., 40., 17., 16., 7., 4., 0., 9., 1., 5., 3., 9., 9., 6., 12., 5., 19., 15., 2., 0., 1., 9., 1., 4., 2., 6., 3., 1., 5., 1., 4., 3., 3., 0., 2., 1., 0., 1., 2., 0., 7., 1., 6., 2., 5., 4., 0., 2., 0., 2., 6., 1., 0., 1., 1., 1., 1., 3., 6., 5., 3., 2., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 1., 3., 12., 3., 4., 2., 3., 23., 3., 19., 16., 0., 8., 2., 0., 2., 13., 3., 3., 32., 14., 18., 21., 4., 1., 0., 2., 3., 9., 5., 33., 16., 2., 20., 1., 15., 5., 0., 2., 1., 1., 17., 18., 12., 55., 19., 13., 7., 9., 0., 3., 2., 5., 3., 11., 5., 9., 15., 3., 14., 15., 2., 1., 1., 4., 1., 2., 2., 3., 2., 1., 4., 3., 5., 2., 2., 0., 0., 3., 0., 3., 2., 2., 4., 3., 2., 3., 3., 4., 1., 2., 1., 2., 5., 2., 0., 1., 2., 0., 0., 3., 4., 4., 1., 4., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 1., 1., 13., 5., 2., 1., 5., 29., 1., 14., 35., 1., 27., 6., 1., 1., 14., 2., 7., 19., 7., 32., 19., 3., 2., 0., 7., 3., 10., 4., 22., 17., 1., 19., 1., 17., 6., 3., 0., 3., 0., 13., 9., 20., 45., 10., 20., 7., 2., 2., 5., 1., 8., 3., 7., 10., 11., 17., 9., 26., 2., 6., 1., 0., 7., 1., 1., 3., 4., 2., 6., 3., 0., 3., 3., 2., 0., 5., 1., 0., 1., 1., 1., 3., 2., 6., 0., 2., 2., 1., 3., 0., 5., 9., 0., 0., 2., 4., 5., 0., 2., 1., 2., 1., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 4., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 6., 7., 4., 3., 0., 6., 24., 1., 17., 22., 0., 15., 5., 2., 3., 24., 1., 4., 20., 12., 30., 22., 3., 1., 1., 1., 2., 5., 9., 24., 16., 2., 20., 5., 17., 13., 0., 2., 1., 1., 5., 13., 18., 42., 14., 18., 6., 1., 1., 5., 0., 9., 2., 10., 7., 9., 18., 8., 22., 4., 6., 1., 1., 8., 1., 0., 1., 6., 2., 1., 4., 3., 3., 3., 2., 2., 2., 1., 0., 1., 2., 1., 6., 3., 4., 3., 1., 7., 2., 0., 2., 1., 13., 2., 0., 2., 1., 0., 2., 0., 3., 1., 2., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 7., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 3., 2., 6., 6., 8., 1., 7., 20., 1., 13., 25., 0., 13., 1., 2., 0., 22., 1., 4., 23., 10., 25., 32., 8., 0., 2., 4., 3., 9., 2., 28., 8., 4., 20., 1., 5., 12., 1., 0., 6., 4., 8., 9., 21., 49., 9., 11., 6., 4., 2., 4., 0., 4., 3., 15., 6., 12., 20., 8., 13., 8., 1., 1., 2., 8., 2., 4., 5., 5., 2., 3., 2., 3., 7., 0., 2., 2., 3., 4., 0., 2., 1., 2., 9., 0., 2., 1., 1., 5., 2., 1., 1., 2., 8., 3., 0., 2., 7., 2., 1., 0., 3., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 4., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 2., 3., 7., 2., 6., 0., 12., 20., 0., 21., 17., 0., 10., 2., 1., 1., 22., 0., 3., 30., 10., 30., 31., 6., 0., 0., 1., 3., 6., 3., 27., 16., 3., 15., 4., 14., 9., 5., 0., 3., 2., 12., 5., 15., 48., 9., 19., 7., 6., 4., 7., 0., 7., 3., 8., 9., 10., 17., 5., 18., 9., 2., 0., 0., 4., 1., 1., 1., 5., 5., 4., 2., 1., 5., 4., 1., 3., 1., 3., 0., 1., 1., 2., 8., 1., 4., 2., 3., 3., 1., 2., 1., 1., 6., 2., 0., 0., 1., 2., 0., 2., 4., 2., 1., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 6., 11., 6., 7., 0., 8., 18., 1., 10., 27., 0., 28., 3., 0., 1., 15., 3., 5., 34., 11., 29., 29., 2., 0., 1., 6., 3., 9., 6., 23., 13., 2., 4., 3., 15., 7., 2., 1., 4., 4., 7., 9., 19., 52., 12., 19., 13., 3., 1., 6., 1., 7., 4., 8., 3., 7., 15., 5., 18., 10., 2., 1., 1., 3., 1., 2., 2., 5., 5., 5., 8., 4., 6., 4., 2., 3., 4., 2., 0., 0., 2., 1., 3., 3., 3., 2., 1., 5., 1., 2., 0., 5., 6., 0., 0., 3., 1., 4., 3., 3., 3., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 4., 2., 5., 2., 9., 1., 7., 11., 2., 11., 28., 0., 13., 2., 1., 3., 14., 1., 2., 28., 15., 40., 28., 5., 0., 0., 3., 1., 8., 8., 29., 9., 3., 13., 3., 18., 13., 0., 0., 7., 4., 15., 10., 13., 56., 7., 23., 9., 8., 3., 7., 3., 6., 2., 12., 6., 12., 20., 3., 13., 13., 2., 2., 1., 5., 2., 1., 2., 4., 4., 1., 3., 0., 5., 2., 2., 0., 0., 3., 0., 1., 2., 0., 4., 1., 4., 1., 0., 3., 0., 3., 3., 1., 9., 0., 0., 2., 1., 2., 1., 3., 4., 1., 1., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 2., 2., 3., 6., 3., 11., 2., 3., 22., 1., 7., 16., 1., 9., 2., 1., 3., 19., 1., 8., 10., 7., 15., 27., 7., 2., 2., 3., 1., 9., 9., 32., 12., 2., 10., 4., 13., 8., 3., 0., 4., 2., 17., 9., 14., 45., 13., 18., 10., 6., 0., 2., 1., 9., 5., 6., 4., 10., 18., 6., 27., 10., 3., 1., 1., 8., 2., 3., 4., 6., 1., 4., 1., 4., 3., 1., 0., 0., 2., 2., 0., 3., 3., 4., 13., 1., 3., 4., 1., 1., 1., 2., 0., 2., 7., 3., 0., 1., 3., 0., 3., 5., 2., 1., 1., 4., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 3., 1., 6., 4., 7., 1., 3., 16., 0., 16., 23., 2., 22., 1., 0., 1., 15., 1., 1., 17., 11., 25., 30., 3., 0., 0., 1., 0., 7., 8., 25., 20., 0., 7., 3., 22., 9., 0., 1., 4., 0., 9., 8., 18., 52., 10., 20., 7., 5., 4., 3., 1., 9., 4., 11., 5., 8., 11., 5., 20., 4., 5., 4., 0., 9., 2., 2., 3., 4., 3., 3., 4., 4., 4., 5., 4., 0., 3., 1., 0., 2., 4., 5., 7., 1., 3., 0., 3., 5., 1., 2., 1., 1., 4., 2., 0., 2., 1., 1., 2., 1., 1., 6., 0., 0., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 4., 1., 5., 1., 7., 0., 4., 15., 2., 10., 27., 1., 17., 3., 0., 0., 29., 3., 3., 22., 9., 27., 23., 3., 0., 0., 4., 2., 8., 7., 17., 14., 2., 7., 7., 12., 13., 1., 0., 4., 2., 5., 9., 15., 46., 15., 19., 6., 5., 2., 3., 2., 10., 5., 11., 2., 6., 15., 4., 26., 7., 4., 1., 0., 6., 2., 4., 1., 6., 1., 4., 5., 0., 6., 3., 1., 0., 1., 3., 0., 2., 3., 2., 10., 2., 1., 2., 1., 3., 1., 3., 0., 1., 10., 5., 0., 2., 3., 1., 3., 0., 2., 1., 0., 1., 0., 0., 0., 0., 2., 0., 0., 6., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 0., 6., 5., 3., 7., 2., 6., 15., 1., 13., 17., 1., 12., 7., 0., 3., 18., 4., 1., 18., 9., 14., 32., 6., 2., 0., 1., 1., 4., 10., 19., 14., 4., 13., 0., 13., 8., 2., 0., 4., 0., 15., 12., 13., 48., 13., 20., 11., 1., 3., 7., 3., 5., 5., 9., 10., 4., 16., 6., 21., 8., 4., 2., 1., 4., 0., 3., 0., 5., 1., 1., 4., 1., 3., 5., 1., 1., 3., 3., 0., 3., 1., 2., 6., 2., 5., 0., 2., 7., 1., 1., 0., 0., 5., 2., 0., 1., 4., 0., 1., 2., 1., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 4., 1., 2., 9., 3., 10., 1., 7., 18., 1., 13., 20., 1., 17., 2., 3., 1., 11., 6., 3., 19., 14., 28., 32., 6., 0., 0., 5., 1., 6., 8., 29., 20., 2., 12., 4., 18., 10., 5., 0., 6., 1., 16., 10., 20., 53., 10., 21., 9., 2., 2., 5., 1., 4., 2., 14., 7., 10., 16., 6., 16., 8., 6., 0., 0., 6., 1., 3., 2., 3., 1., 4., 6., 1., 4., 3., 2., 0., 0., 0., 0., 2., 2., 4., 6., 1., 2., 1., 2., 3., 2., 2., 0., 1., 5., 5., 0., 2., 0., 1., 3., 2., 2., 1., 2., 1., 0., 0., 0., 0., 6., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 4., 6., 5., 4., 1., 5., 29., 0., 14., 22., 1., 9., 1., 2., 3., 22., 4., 7., 33., 17., 20., 25., 11., 0., 0., 0., 2., 8., 5., 21., 13., 2., 21., 5., 11., 11., 2., 3., 6., 0., 13., 6., 13., 67., 11., 23., 14., 5., 0., 4., 1., 8., 3., 9., 9., 13., 21., 3., 23., 4., 3., 1., 1., 7., 3., 1., 2., 7., 3., 4., 4., 1., 5., 5., 1., 0., 2., 2., 0., 1., 3., 1., 11., 1., 6., 2., 4., 2., 0., 2., 0., 3., 8., 0., 0., 2., 3., 4., 1., 3., 2., 1., 2., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 4., 4., 9., 3., 13., 3., 6., 23., 3., 8., 16., 0., 21., 5., 1., 2., 19., 1., 7., 9., 6., 27., 31., 1., 0., 2., 3., 0., 4., 6., 27., 19., 1., 15., 4., 12., 4., 3., 0., 6., 2., 6., 9., 23., 46., 10., 21., 12., 3., 1., 7., 3., 4., 4., 7., 12., 11., 20., 5., 23., 9., 3., 0., 1., 7., 3., 1., 1., 7., 0., 3., 3., 1., 4., 4., 0., 0., 0., 1., 0., 1., 0., 2., 4., 3., 2., 0., 2., 5., 0., 1., 4., 5., 9., 3., 0., 3., 1., 1., 0., 2., 6., 0., 1., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 4., 5., 6., 3., 4., 1., 2., 19., 0., 17., 21., 3., 16., 3., 2., 2., 25., 2., 1., 37., 13., 28., 34., 7., 0., 0., 0., 3., 7., 8., 26., 15., 2., 12., 2., 13., 6., 2., 2., 2., 1., 15., 9., 24., 45., 9., 23., 10., 7., 1., 2., 1., 9., 1., 10., 11., 13., 21., 6., 32., 5., 3., 2., 1., 9., 1., 4., 0., 4., 2., 5., 3., 4., 4., 2., 2., 0., 2., 3., 0., 2., 2., 2., 12., 4., 3., 1., 4., 8., 1., 3., 1., 3., 6., 3., 0., 5., 1., 4., 1., 4., 1., 1., 1., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 2., 3., 9., 4., 5., 2., 7., 11., 2., 15., 10., 2., 19., 1., 2., 1., 20., 2., 5., 20., 13., 28., 25., 8., 3., 2., 3., 5., 8., 8., 26., 20., 5., 13., 4., 8., 10., 1., 0., 7., 3., 20., 15., 23., 51., 7., 21., 10., 4., 2., 10., 2., 8., 3., 6., 4., 8., 16., 4., 24., 10., 2., 1., 1., 10., 0., 3., 1., 9., 2., 5., 4., 1., 2., 2., 4., 2., 0., 0., 0., 3., 3., 3., 6., 1., 4., 2., 3., 1., 1., 0., 1., 2., 7., 3., 0., 1., 2., 4., 2., 1., 1., 1., 1., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 4., 2., 9., 2., 11., 1., 4., 11., 1., 14., 15., 1., 15., 1., 0., 0., 14., 3., 2., 24., 11., 5., 38., 6., 0., 1., 5., 1., 7., 1., 15., 11., 3., 9., 6., 6., 9., 2., 0., 6., 1., 20., 13., 13., 44., 12., 20., 8., 3., 2., 8., 0., 2., 3., 9., 6., 9., 9., 5., 22., 8., 5., 0., 1., 10., 1., 3., 3., 7., 1., 7., 2., 1., 5., 2., 4., 1., 0., 1., 0., 2., 3., 2., 4., 2., 4., 3., 4., 5., 1., 2., 0., 4., 6., 3., 0., 3., 0., 1., 0., 1., 3., 1., 1., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 4., 5., 8., 3., 3., 0., 9., 18., 0., 11., 28., 1., 19., 3., 0., 1., 15., 0., 6., 23., 12., 24., 31., 7., 3., 0., 2., 4., 9., 7., 34., 17., 4., 20., 5., 18., 15., 3., 1., 1., 1., 6., 9., 26., 41., 13., 21., 10., 11., 0., 2., 3., 3., 7., 11., 5., 7., 26., 8., 17., 5., 2., 0., 0., 4., 0., 2., 5., 6., 3., 2., 3., 1., 1., 4., 1., 1., 2., 2., 0., 1., 0., 6., 3., 2., 2., 0., 2., 0., 1., 1., 0., 0., 4., 2., 0., 1., 1., 1., 1., 3., 0., 2., 1., 6., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 3., 2., 7., 0., 17., 2., 7., 39., 1., 4., 50., 0., 3., 5., 0., 4., 72., 19., 5., 84., 21., 84., 9., 2., 0., 0., 4., 3., 12., 7., 64., 7., 2., 43., 33., 10., 5., 0., 2., 8., 4., 23., 4., 26., 9., 12., 6., 2., 3., 0., 6., 5., 18., 7., 30., 3., 13., 3., 1., 30., 3., 7., 1., 0., 19., 2., 9., 3., 11., 2., 2., 0., 3., 0., 0., 6., 3., 11., 5., 3., 3., 2., 5., 0., 0., 0., 0., 0., 2., 3., 2., 0., 1., 0., 3., 0., 2., 0., 1., 0., 1., 1., 3., 0., 2., 0., 1., 0., 0., 0., 0., 0., 1., 0., 1., 5., 1., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 29., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 3., 7., 12., 12., 7., 32., 1., 11., 166., 4., 20., 186., 3., 12., 11., 1., 5., 96., 1., 18., 307., 46., 313., 45., 23., 0., 2., 9., 9., 44., 30., 241., 43., 10., 144., 18., 40., 7., 0., 1., 19., 12., 60., 20., 82., 10., 28., 40., 10., 3., 1., 26., 9., 39., 13., 59., 9., 25., 8., 4., 7., 2., 0., 1., 0., 21., 9., 19., 4., 38., 4., 16., 6., 3., 2., 0., 2., 3., 4., 7., 4., 8., 1., 8., 2., 0., 3., 136., 10., 1888., 91., 107., 218., 122., 115., 70., 15., 9., 21., 16., 0., 2., 7., 3., 5., 13., 10., 45., 15., 35., 12., 32., 4., 8., 2., 3., 6., 6., 4., 4., 5., 8., 4., 0., 6., 5., 21., 3., 0., 11., 6., 3., 0., 5., 1., 7., 34., 0., 9., 5., 11., 1., 20., 2., 2., 3., 3., 22., 5., 29., 3., 8., 3., 5., 26., 5., 12., 7.,

14., 1., 2., 10., 21., 2., 26., 0., 14., 173., 4., 21., 178., 7., 15., 8., 5., 7., 75., 4., 14., 281., 36., 339., 42., 24., 0., 5., 3., 8., 42., 33., 234., 41., 6., 142., 15., 36., 5., 0., 1., 22., 8., 77., 16., 85., 14., 36., 54., 10., 1., 0., 22., 7., 47., 11., 56., 7., 38., 5., 17., 6., 5., 0., 0., 0., 33., 5., 11., 3., 27., 2., 13., 6., 2., 3., 1., 1., 4., 0., 9., 2., 7., 2., 7., 0., 1., 3., 138., 7., 1940., 89., 92., 222., 107., 133., 57., 14., 8., 12., 14., 1., 1., 3., 0., 7., 7., 7., 30., 17., 41., 9., 39., 4., 12., 5., 6., 9., 9., 3., 4., 3., 7., 4., 0., 6., 6., 19., 3., 0., 11., 4., 4., 0., 6., 2., 2., 38., 3., 8., 2., 15., 3., 16., 2., 3., 2., 3., 27., 9., 33., 5., 6., 8., 2., 26., 10., 13., 5.,

16., 3., 4., 12., 30., 4., 34., 1., 20., 176., 3., 21., 192., 6., 14., 7., 2., 7., 59., 2., 17., 317., 41., 316., 45., 20., 2., 4., 6., 6., 50., 30., 236., 35., 16., 178., 12., 37., 6., 0., 3., 10., 10., 79., 17., 78., 18., 24., 54., 10., 3., 4., 33., 7., 50., 8., 50., 6., 27., 6., 16., 11., 3., 0., 1., 0., 24., 3., 15., 5., 32., 5., 10., 7., 1., 1., 0., 2., 4., 3., 9., 2., 12., 3., 12., 0., 2., 3., 144., 9., 1908., 99., 106., 235., 94., 119., 63., 14., 10., 9., 8., 0., 4., 5., 6., 4., 11., 9., 32., 11., 33., 19., 30., 11., 4., 4., 1., 7., 4., 0., 3., 3., 11., 3., 0., 3., 4., 15., 0., 0., 9., 5., 3., 0., 5., 4., 3., 35., 5., 13., 3., 11., 0., 21., 4., 0., 4., 4., 29., 6., 35., 5., 2., 6., 8., 40., 7., 16., 6.,

16., 1., 3., 8., 13., 7., 25., 0., 13., 137., 3., 29., 187., 7., 15., 9., 1., 7., 84., 4., 18., 272., 35., 363., 52., 20., 3., 1., 3., 5., 53., 32., 224., 42., 9., 170., 16., 41., 13., 0., 1., 19., 2., 78., 12., 79., 23., 36., 39., 13., 5., 3., 23., 6., 32., 11., 51., 18., 32., 3., 13., 10., 3., 0., 1., 0., 18., 6., 10., 7., 17., 2., 9., 4., 1., 1., 1., 1., 1., 1., 12., 2., 5., 0., 11., 1., 0., 2., 138., 7., 1841., 78., 103., 224., 108., 104., 73., 13., 10., 21., 14., 0., 1., 6., 2., 6., 9., 10., 30., 12., 33., 13., 39., 10., 10., 5., 3., 6., 8., 2., 2., 3., 6., 4., 0., 1., 5., 7., 3., 0., 6., 4., 2., 0., 2., 2., 2., 37., 4., 12., 3., 18., 3., 15., 1., 10., 5., 0., 15., 2., 26., 5., 7., 7., 3., 29., 7., 14., 3.,

13., 5., 4., 8., 21., 6., 31., 2., 12., 185., 0., 24., 215., 6., 12., 4., 2., 3., 70., 1., 16., 281., 44., 346., 31., 14., 2., 1., 5., 6., 48., 34., 228., 35., 5., 132., 13., 34., 8., 0., 3., 12., 4., 68., 23., 86., 10., 38., 49., 16., 1., 0., 29., 4., 49., 8., 50., 12., 27., 6., 10., 7., 1., 0., 2., 0., 26., 6., 17., 4., 21., 9., 13., 2., 0., 7., 0., 1., 1., 3., 10., 5., 6., 1., 7., 2., 0., 2., 141., 6., 1889., 90., 104., 237., 75., 113., 55., 12., 11., 23., 7., 2., 1., 11., 5., 4., 11., 12., 37., 15., 49., 17., 42., 11., 10., 2., 9., 8., 6., 1., 2., 0., 13., 2., 0., 5., 5., 9., 5., 0., 16., 3., 3., 0., 7., 1., 2., 29., 2., 10., 1., 15., 4., 33., 0., 2., 1., 4., 28., 5., 21., 3., 4., 7., 4., 42., 9., 12., 8.,

10., 1., 0., 6., 26., 4., 35., 0., 10., 152., 2., 25., 208., 6., 18., 7., 2., 7., 95., 0., 10., 276., 40., 322., 50., 25., 2., 2., 6., 6., 36., 32., 218., 42., 12., 174., 12., 35., 6., 0., 5., 19., 5., 73., 24., 79., 17., 29., 52., 20., 4., 1., 31., 12., 53., 7., 37., 9., 25., 6., 9., 3., 2., 0., 3., 0., 20., 5., 17., 1., 27., 6., 11., 1., 4., 3., 0., 2., 2., 1., 13., 4., 7., 2., 4., 1., 0., 6., 147., 12., 1917., 84., 116., 188., 109., 125., 74., 10., 22., 17., 14., 3., 1., 8., 4., 8., 12., 5., 42., 17., 31., 15., 47., 9., 13., 4., 7., 7., 6., 0., 3., 6., 12., 2., 0., 4., 3., 20., 2., 0., 8., 6., 5., 0., 4., 3., 2., 29., 3., 8., 5., 15., 1., 20., 6., 3., 1., 5., 20., 2., 33., 3., 3., 14., 5., 45., 5., 18., 5.,

21., 3., 1., 4., 32., 6., 40., 2., 19., 157., 3., 27., 210., 4., 12., 11., 2., 6., 84., 3., 16., 278., 53., 356., 48., 20., 1., 4., 6., 3., 47., 25., 233., 32., 5., 166., 13., 40., 8., 0., 2., 16., 6., 96., 22., 83., 10., 32., 51., 21., 4., 3., 13., 10., 39., 9., 56., 11., 33., 5., 10., 4., 1., 0., 1., 0., 19., 3., 18., 5., 26., 8., 13., 3., 2., 3., 1., 2., 0., 0., 11., 1., 5., 1., 6., 0., 2., 2., 152., 14., 1938., 84., 104., 207., 89., 109., 65., 15., 7., 15., 15., 1., 0., 2., 7., 2., 13., 5., 37., 17., 32., 18., 38., 9., 10., 5., 5., 5., 9., 3., 2., 3., 5., 1., 0., 4., 1., 16., 2., 0., 11., 3., 5., 0., 4., 4., 2., 21., 1., 12., 1., 14., 5., 24., 2., 1., 3., 3., 26., 3., 40., 4., 4., 6., 6., 28., 11., 7., 5.,

18., 3., 2., 9., 15., 8., 31., 1., 14., 159., 1., 18., 219., 3., 20., 5., 1., 3., 79., 0., 17., 256., 54., 328., 53., 20., 1., 3., 6., 10., 45., 37., 219., 46., 7., 151., 9., 38., 8., 0., 4., 12., 11., 88., 23., 100., 11., 39., 39., 10., 5., 2., 25., 4., 40., 6., 48., 13., 31., 9., 7., 9., 4., 0., 0., 0., 31., 11., 13., 2., 31., 7., 12., 7., 3., 5., 1., 1., 0., 1., 11., 6., 5., 1., 10., 0., 0., 3., 133., 9., 1857., 93., 92., 212., 94., 130., 62., 15., 13., 25., 19., 2., 2., 12., 5., 2., 10., 8., 43., 15., 29., 12., 44., 14., 13., 4., 5., 12., 7., 1., 3., 0., 10., 5., 0., 4., 2., 17., 3., 0., 11., 2., 3., 0., 3., 2., 3., 22., 4., 15., 4., 16., 9., 22., 4., 0., 3., 1., 29., 5., 34., 5., 6., 4., 8., 38., 4., 6., 2.,

7., 3., 7., 8., 21., 10., 23., 1., 12., 155., 4., 20., 204., 5., 14., 7., 2., 7., 79., 3., 14., 290., 46., 293., 46., 25., 1., 1., 8., 9., 52., 39., 218., 51., 8., 161., 12., 36., 2., 0., 2., 14., 11., 84., 23., 82., 17., 29., 50., 15., 1., 2., 26., 5., 49., 13., 45., 9., 29., 3., 12., 7., 3., 0., 3., 0., 20., 4., 16., 2., 43., 4., 5., 2., 2., 2., 2., 0., 5., 2., 12., 5., 7., 0., 7., 3., 1., 1., 149., 7., 1917., 90., 102., 226., 91., 111., 73., 10., 7., 21., 12., 1., 1., 6., 5., 3., 10., 7., 35., 13., 37., 14., 42., 6., 7., 5., 9., 8., 6., 1., 1., 3., 6., 4., 0., 2., 4., 9., 2., 0., 8., 7., 0., 0., 5., 4., 3., 34., 2., 11., 3., 15., 3., 22., 5., 3., 2., 5., 25., 5., 42., 7., 5., 9., 5., 28., 7., 11., 3.,

19., 1., 1., 8., 18., 8., 27., 1., 13., 167., 4., 37., 181., 4., 8., 12., 1., 5., 100., 2., 16., 305., 57., 281., 42., 19., 1., 3., 7., 4., 41., 27., 224., 33., 7., 148., 8., 42., 6., 0., 3., 14., 9., 92., 19., 89., 19., 47., 51., 17., 0., 3., 26., 11., 36., 8., 36., 10., 31., 3., 12., 5., 3., 0., 0., 0., 23., 5., 21., 2., 24., 8., 13., 5., 6., 3., 0., 1., 3., 3., 7., 2., 11., 0., 8., 0., 3., 3., 142., 12., 1972., 80., 97., 234., 102., 100., 63., 8., 12., 11., 7., 1., 1., 10., 4., 4., 8., 7., 28., 26., 33., 16., 36., 2., 5., 5., 6., 6., 6., 2., 6., 3., 5., 3., 0., 4., 2., 13., 0., 0., 10., 1., 2., 0., 4., 5., 1., 35., 2., 9., 2., 9., 4., 29., 3., 1., 1., 6., 31., 3., 30., 6., 6., 3., 0., 31., 9., 7., 2.,

18., 0., 1., 7., 26., 9., 32., 1., 19., 136., 1., 31., 201., 5., 8., 8., 0., 4., 89., 2., 14., 299., 48., 344., 45., 17., 2., 3., 7., 2., 44., 33., 230., 30., 9., 169., 13., 33., 4., 0., 4., 13., 11., 88., 16., 104., 20., 39., 43., 12., 2., 3., 19., 7., 32., 4., 44., 9., 25., 6., 9., 4., 2., 0., 1., 0., 21., 10., 8., 5., 28., 2., 11., 7., 3., 6., 0., 0., 3., 1., 11., 1., 8., 2., 13., 1., 0., 3., 139., 12., 1877., 77., 110., 238., 111., 112., 71., 27., 13., 14., 12., 0., 1., 6., 10., 6., 8., 8., 32., 16., 49., 18., 35., 9., 9., 9., 1., 9., 5., 2., 0., 1., 6., 4., 0., 0., 9., 15., 3., 0., 6., 3., 1., 0., 3., 3., 7., 32., 2., 13., 2., 10., 4., 14., 2., 4., 4., 2., 26., 7., 39., 6., 4., 5., 4., 29., 6., 12., 4.,

8., 2., 3., 1., 6., 2., 6., 1., 7., 21., 1., 15., 13., 3., 19., 4., 0., 3., 15., 3., 5., 36., 10., 21., 23., 6., 2., 2., 2., 0., 6., 8., 29., 10., 2., 17., 2., 21., 13., 2., 1., 2., 2., 12., 15., 8., 49., 15., 22., 10., 3., 1., 4., 4., 4., 3., 6., 7., 10., 16., 11., 21., 13., 4., 0., 3., 4., 0., 3., 2., 4., 2., 5., 2., 2., 4., 4., 1., 0., 1., 3., 0., 2., 4., 3., 8., 1., 3., 2., 3., 2., 0., 3., 0., 3., 7., 3., 0., 0., 1., 2., 0., 2., 1., 1., 0., 4., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 3., 11., 6., 7., 2., 7., 38., 2., 14., 10., 2., 21., 0., 1., 3., 11., 2., 4., 11., 17., 33., 32., 7., 0., 0., 2., 3., 7., 8., 20., 15., 2., 13., 5., 17., 7., 1., 0., 2., 4., 9., 9., 27., 56., 11., 14., 6., 6., 1., 8., 1., 6., 1., 10., 5., 8., 15., 6., 17., 7., 9., 0., 0., 5., 1., 2., 2., 5., 3., 6., 5., 2., 2., 2., 2., 1., 5., 1., 0., 3., 2., 3., 4., 5., 1., 2., 3., 2., 2., 1., 0., 2., 7., 1., 0., 1., 4., 1., 3., 2., 2., 1., 0., 3., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 2., 2., 2., 8., 2., 9., 1., 5., 21., 0., 13., 14., 1., 15., 3., 0., 0., 12., 0., 1., 27., 11., 32., 28., 7., 0., 0., 3., 3., 4., 7., 31., 13., 4., 22., 3., 10., 12., 3., 0., 1., 0., 12., 8., 13., 44., 11., 21., 8., 5., 2., 6., 3., 11., 2., 17., 7., 8., 17., 7., 24., 6., 4., 0., 0., 6., 1., 2., 1., 6., 3., 3., 2., 5., 6., 3., 2., 1., 4., 3., 0., 1., 1., 2., 1., 6., 1., 3., 3., 2., 0., 3., 3., 2., 5., 1., 0., 1., 1., 1., 0., 1., 1., 3., 0., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 2., 1., 10., 2., 8., 3., 9., 18., 0., 8., 21., 2., 19., 2., 1., 1., 11., 2., 5., 16., 10., 24., 23., 4., 2., 0., 3., 1., 5., 5., 17., 19., 3., 13., 8., 15., 12., 1., 1., 6., 1., 16., 8., 11., 30., 7., 21., 6., 3., 0., 2., 1., 11., 0., 13., 6., 6., 18., 3., 14., 8., 1., 1., 0., 7., 0., 3., 3., 5., 1., 6., 4., 3., 5., 7., 2., 1., 1., 2., 0., 0., 0., 2., 8., 1., 2., 1., 1., 4., 0., 3., 2., 2., 8., 0., 0., 1., 4., 1., 2., 4., 2., 2., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 5., 2., 9., 3., 9., 1., 4., 32., 1., 14., 25., 1., 11., 3., 1., 2., 12., 1., 3., 33., 6., 26., 28., 3., 0., 1., 4., 1., 4., 8., 13., 17., 0., 18., 5., 11., 10., 1., 1., 4., 0., 6., 12., 20., 60., 13., 19., 5., 4., 1., 4., 1., 5., 4., 13., 6., 6., 18., 3., 23., 9., 1., 0., 0., 8., 1., 2., 1., 2., 7., 5., 3., 5., 3., 3., 2., 0., 2., 2., 0., 1., 0., 4., 5., 5., 4., 3., 2., 4., 3., 2., 0., 5., 10., 1., 0., 2., 4., 2., 3., 2., 2., 1., 0., 6., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 3., 6., 1., 1., 7., 2., 5., 30., 1., 17., 15., 0., 12., 3., 1., 1., 10., 0., 1., 28., 12., 21., 23., 6., 2., 0., 3., 5., 10., 16., 38., 10., 2., 19., 3., 10., 12., 1., 3., 6., 0., 13., 16., 26., 44., 13., 15., 13., 2., 0., 4., 1., 8., 4., 4., 7., 9., 6., 12., 21., 8., 3., 2., 1., 3., 0., 2., 4., 3., 3., 4., 5., 3., 6., 5., 5., 0., 3., 1., 0., 1., 4., 0., 5., 1., 1., 3., 3., 1., 2., 1., 0., 8., 11., 2., 0., 2., 3., 2., 3., 2., 3., 2., 2., 2., 0., 0., 0., 0., 7., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 1., 2., 4., 2., 3., 2., 3., 27., 1., 20., 22., 1., 21., 2., 1., 3., 19., 1., 8., 10., 15., 29., 29., 8., 0., 0., 0., 3., 5., 13., 25., 10., 3., 12., 5., 16., 9., 1., 2., 4., 4., 10., 14., 15., 38., 17., 17., 11., 4., 2., 5., 0., 10., 5., 9., 6., 7., 10., 4., 21., 13., 4., 1., 1., 4., 0., 4., 0., 5., 4., 3., 3., 0., 3., 2., 0., 0., 0., 1., 0., 0., 1., 3., 9., 5., 4., 0., 0., 7., 0., 3., 0., 2., 5., 3., 0., 2., 2., 0., 4., 1., 2., 3., 1., 3., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 3., 4., 11., 4., 3., 0., 6., 31., 0., 8., 26., 1., 15., 3., 1., 2., 18., 2., 4., 19., 10., 10., 20., 7., 0., 1., 2., 3., 10., 0., 23., 20., 3., 19., 2., 7., 6., 1., 1., 6., 0., 17., 8., 21., 40., 9., 34., 10., 4., 0., 11., 3., 5., 1., 10., 7., 5., 16., 6., 28., 9., 4., 1., 1., 10., 1., 6., 0., 5., 1., 6., 6., 4., 5., 3., 2., 2., 1., 4., 0., 0., 0., 0., 4., 4., 4., 0., 3., 6., 2., 1., 1., 2., 7., 2., 0., 2., 1., 1., 0., 1., 5., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 3., 0., 4., 7., 4., 6., 1., 2., 15., 0., 10., 21., 0., 22., 0., 0., 4., 15., 1., 1., 19., 16., 18., 32., 4., 0., 1., 4., 2., 7., 5., 24., 8., 4., 15., 4., 15., 11., 2., 1., 2., 5., 11., 10., 12., 37., 7., 19., 7., 4., 1., 3., 2., 11., 1., 3., 12., 10., 15., 8., 20., 7., 4., 0., 2., 11., 1., 7., 2., 5., 7., 7., 5., 1., 5., 3., 0., 0., 2., 0., 0., 5., 1., 1., 4., 1., 4., 2., 1., 3., 1., 2., 0., 3., 9., 2., 0., 2., 4., 1., 3., 0., 0., 2., 1., 1., 0., 0., 0., 0., 5., 0., 0., 4., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 3., 6., 7., 5., 4., 1., 4., 26., 1., 14., 27., 2., 18., 1., 0., 2., 13., 2., 4., 23., 11., 29., 26., 7., 0., 3., 4., 3., 9., 10., 26., 18., 3., 17., 3., 5., 11., 0., 2., 2., 0., 16., 13., 12., 51., 12., 19., 11., 2., 1., 4., 1., 8., 3., 9., 7., 9., 9., 9., 17., 8., 1., 0., 0., 7., 1., 3., 3., 2., 4., 2., 1., 4., 2., 2., 2., 1., 0., 1., 0., 4., 0., 1., 5., 3., 6., 4., 2., 3., 1., 3., 1., 1., 6., 0., 0., 3., 1., 0., 3., 2., 0., 4., 1., 2., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 4., 4., 9., 7., 5., 0., 7., 27., 1., 11., 28., 0., 17., 1., 0., 2., 16., 4., 4., 24., 13., 22., 30., 5., 2., 0., 3., 0., 12., 6., 3., 14., 1., 7., 5., 17., 13., 0., 1., 4., 3., 10., 18., 13., 45., 8., 12., 14., 4., 2., 5., 0., 12., 2., 11., 9., 12., 16., 8., 22., 8., 1., 0., 2., 12., 1., 0., 1., 4., 2., 5., 6., 2., 1., 7., 2., 1., 1., 1., 0., 2., 3., 2., 2., 2., 1., 2., 0., 5., 1., 3., 2., 1., 7., 4., 0., 5., 4., 4., 2., 0., 1., 5., 0., 3., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 0., 5., 6., 1., 9., 3., 6., 25., 1., 18., 24., 0., 23., 1., 1., 3., 17., 4., 5., 38., 9., 34., 30., 6., 0., 0., 6., 4., 14., 6., 34., 19., 2., 14., 7., 12., 7., 1., 0., 2., 3., 17., 19., 26., 35., 5., 33., 11., 2., 2., 9., 0., 7., 4., 6., 7., 8., 12., 5., 26., 9., 6., 3., 2., 10., 0., 2., 0., 2., 2., 5., 7., 1., 4., 3., 0., 2., 2., 4., 0., 1., 2., 0., 6., 1., 0., 2., 1., 2., 0., 3., 1., 2., 8., 3., 0., 1., 0., 2., 3., 4., 2., 2., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 4., 6., 13., 5., 7., 1., 5., 37., 1., 12., 17., 0., 20., 2., 0., 3., 16., 2., 1., 33., 12., 16., 22., 2., 0., 1., 5., 3., 11., 16., 28., 19., 0., 14., 4., 7., 11., 2., 0., 7., 1., 15., 7., 19., 40., 8., 27., 3., 2., 3., 3., 4., 4., 2., 6., 3., 4., 20., 4., 24., 10., 3., 1., 0., 5., 0., 1., 2., 10., 7., 3., 9., 0., 6., 6., 2., 2., 2., 4., 0., 3., 2., 1., 7., 6., 3., 4., 3., 8., 1., 1., 0., 1., 5., 2., 0., 2., 2., 3., 1., 1., 2., 2., 0., 4., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 3., 5., 8., 3., 10., 1., 7., 18., 1., 10., 21., 0., 11., 3., 3., 1., 18., 1., 3., 29., 8., 28., 21., 2., 2., 0., 2., 1., 10., 7., 20., 23., 5., 17., 6., 12., 11., 4., 1., 4., 4., 22., 12., 21., 41., 14., 26., 10., 4., 3., 4., 3., 8., 0., 9., 2., 7., 12., 10., 25., 13., 3., 2., 1., 12., 2., 2., 1., 3., 2., 6., 4., 2., 5., 6., 4., 0., 3., 2., 0., 3., 3., 5., 7., 6., 5., 1., 3., 4., 0., 3., 1., 4., 4., 0., 0., 4., 1., 2., 8., 3., 3., 3., 1., 0., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 0., 3., 11., 4., 3., 1., 6., 18., 2., 13., 17., 1., 16., 2., 3., 4., 24., 2., 6., 31., 7., 32., 23., 2., 0., 2., 2., 2., 10., 2., 18., 22., 1., 5., 2., 12., 7., 4., 0., 2., 0., 11., 15., 18., 58., 13., 17., 9., 5., 0., 3., 1., 10., 2., 11., 7., 13., 14., 5., 18., 13., 2., 2., 2., 6., 0., 7., 4., 6., 5., 7., 2., 2., 2., 4., 2., 0., 1., 4., 0., 2., 3., 4., 7., 4., 10., 0., 2., 2., 0., 6., 1., 2., 9., 2., 0., 2., 2., 4., 2., 2., 1., 5., 0., 4., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 2., 4., 9., 3., 4., 2., 8., 19., 1., 22., 31., 1., 8., 4., 0., 3., 28., 3., 4., 22., 12., 18., 29., 6., 2., 2., 5., 3., 8., 10., 30., 18., 3., 12., 5., 13., 10., 1., 2., 2., 2., 11., 9., 16., 45., 19., 25., 8., 1., 1., 6., 1., 6., 3., 14., 8., 7., 12., 7., 19., 4., 3., 0., 3., 10., 2., 2., 3., 3., 3., 4., 4., 4., 4., 3., 1., 1., 0., 3., 0., 2., 2., 2., 4., 1., 3., 4., 2., 6., 1., 0., 1., 1., 4., 1., 0., 4., 3., 3., 2., 1., 3., 1., 2., 4., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 2., 1., 7., 10., 2., 8., 1., 7., 24., 2., 14., 21., 1., 24., 3., 1., 2., 23., 2., 3., 33., 14., 24., 28., 12., 0., 2., 4., 3., 6., 1., 34., 16., 4., 22., 3., 12., 5., 1., 2., 2., 3., 12., 14., 17., 53., 8., 19., 14., 7., 2., 2., 1., 8., 4., 13., 7., 12., 19., 4., 29., 9., 4., 2., 0., 1., 0., 6., 2., 0., 2., 4., 3., 3., 3., 3., 2., 0., 2., 1., 0., 4., 1., 1., 7., 4., 4., 3., 0., 1., 0., 1., 1., 1., 6., 3., 0., 1., 2., 3., 1., 1., 4., 1., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 2., 11., 1., 5., 0., 3., 16., 3., 22., 27., 1., 13., 3., 1., 2., 18., 5., 8., 14., 11., 20., 19., 6., 2., 3., 6., 3., 7., 6., 26., 21., 1., 9., 5., 19., 5., 2., 1., 1., 2., 9., 10., 23., 25., 10., 21., 11., 3., 0., 3., 7., 3., 2., 9., 3., 5., 10., 3., 24., 8., 4., 0., 1., 4., 1., 5., 2., 5., 3., 1., 1., 1., 3., 3., 6., 1., 1., 1., 0., 2., 0., 2., 5., 2., 4., 2., 2., 2., 0., 3., 0., 2., 8., 1., 0., 4., 4., 0., 1., 4., 0., 2., 4., 1., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 1., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 6., 6., 3., 6., 3., 6., 20., 2., 17., 17., 0., 12., 1., 0., 1., 15., 2., 5., 19., 14., 36., 32., 4., 1., 2., 3., 2., 9., 13., 22., 11., 2., 13., 1., 14., 9., 1., 1., 4., 1., 12., 5., 20., 48., 6., 26., 4., 4., 0., 3., 2., 5., 4., 8., 7., 8., 14., 4., 23., 1., 2., 0., 0., 12., 0., 0., 2., 5., 5., 1., 4., 1., 5., 3., 2., 2., 1., 4., 0., 1., 2., 2., 5., 3., 3., 1., 1., 5., 1., 1., 1., 6., 6., 0., 0., 2., 3., 3., 2., 3., 1., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 2., 10., 0., 11., 1., 9., 29., 2., 17., 26., 0., 14., 4., 0., 5., 12., 3., 5., 21., 17., 22., 28., 2., 0., 1., 0., 0., 5., 6., 21., 15., 4., 19., 3., 9., 7., 0., 0., 2., 3., 14., 19., 24., 56., 9., 20., 9., 2., 1., 7., 3., 3., 4., 6., 6., 11., 20., 5., 21., 7., 5., 1., 1., 11., 0., 6., 0., 7., 2., 4., 5., 1., 4., 2., 1., 1., 3., 2., 0., 3., 0., 0., 7., 3., 4., 3., 2., 5., 1., 1., 2., 0., 5., 3., 0., 2., 4., 3., 3., 2., 2., 1., 1., 0., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 3., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 1., 4., 10., 0., 11., 3., 3., 51., 1., 6., 53., 1., 11., 1., 0., 1., 64., 11., 4., 69., 18., 74., 14., 6., 0., 0., 2., 1., 16., 13., 56., 16., 1., 39., 36., 14., 2., 0., 2., 2., 3., 28., 7., 25., 7., 9., 13., 5., 1., 0., 8., 2., 17., 6., 13., 1., 7., 4., 2., 36., 9., 11., 1., 0., 15., 2., 5., 0., 9., 4., 2., 2., 0., 1., 0., 11., 1., 21., 9., 5., 2., 4., 3., 0., 0., 0., 0., 0., 7., 1., 1., 3., 4., 2., 0., 0., 0., 0., 0., 0., 1., 8., 2., 0., 5., 0., 0., 0., 1., 0., 0., 0., 2., 0., 1., 2., 3., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 24., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

19., 3., 3., 5., 19., 6., 30., 0., 15., 163., 5., 20., 201., 2., 13., 9., 0., 5., 79., 5., 11., 297., 38., 348., 49., 14., 0., 1., 7., 2., 42., 33., 223., 44., 5., 159., 10., 39., 6., 0., 0., 17., 13., 74., 20., 93., 12., 28., 41., 21., 6., 0., 33., 2., 40., 7., 49., 11., 24., 4., 14., 7., 0., 0., 1., 0., 26., 5., 10., 3., 26., 1., 14., 2., 2., 4., 0., 0., 1., 2., 15., 0., 6., 2., 8., 3., 0., 7., 134., 7., 1863., 88., 104., 202., 92., 107., 70., 14., 12., 12., 20., 0., 2., 3., 5., 8., 8., 5., 41., 13., 30., 16., 40., 3., 3., 2., 6., 3., 4., 5., 6., 1., 10., 3., 0., 2., 8., 18., 0., 0., 9., 3., 2., 0., 5., 2., 3., 26., 3., 10., 3., 11., 3., 18., 4., 2., 4., 5., 27., 6., 29., 4., 3., 2., 5., 35., 7., 11., 4.,

11., 2., 2., 7., 20., 6., 29., 1., 21., 161., 5., 32., 226., 3., 15., 6., 1., 7., 80., 4., 12., 279., 38., 344., 33., 14., 3., 1., 5., 6., 39., 42., 226., 47., 13., 146., 8., 41., 10., 0., 4., 13., 13., 65., 14., 99., 16., 25., 38., 14., 3., 2., 16., 8., 35., 7., 53., 13., 24., 7., 4., 9., 0., 0., 0., 0., 17., 5., 18., 0., 31., 8., 10., 5., 5., 3., 1., 1., 2., 1., 9., 0., 10., 2., 7., 2., 1., 3., 130., 7., 1891., 108., 108., 205., 95., 115., 61., 16., 12., 17., 18., 2., 2., 7., 3., 3., 8., 11., 32., 20., 33., 22., 43., 13., 12., 3., 6., 6., 6., 1., 6., 3., 3., 2., 0., 7., 7., 18., 1., 0., 10., 5., 5., 0., 2., 3., 2., 40., 4., 10., 3., 15., 4., 14., 6., 2., 3., 8., 26., 4., 31., 9., 4., 9., 4., 29., 4., 8., 6.,

12., 3., 0., 3., 25., 4., 29., 0., 17., 132., 6., 31., 196., 5., 28., 12., 1., 4., 99., 1., 19., 259., 57., 321., 42., 14., 0., 1., 8., 3., 49., 27., 241., 44., 11., 163., 9., 38., 5., 0., 1., 18., 6., 79., 21., 80., 5., 38., 51., 10., 2., 1., 17., 6., 54., 9., 50., 6., 28., 6., 7., 6., 3., 0., 0., 0., 23., 8., 13., 2., 30., 4., 11., 3., 1., 0., 3., 3., 4., 1., 14., 2., 10., 5., 7., 2., 0., 5., 135., 6., 1877., 98., 93., 209., 110., 116., 75., 16., 14., 22., 10., 1., 3., 7., 7., 4., 9., 6., 35., 15., 31., 16., 36., 9., 4., 10., 3., 6., 8., 2., 1., 4., 7., 2., 0., 2., 4., 14., 2., 0., 7., 3., 2., 0., 8., 1., 3., 24., 3., 15., 4., 15., 7., 16., 1., 3., 5., 3., 36., 9., 30., 7., 6., 8., 3., 23., 15., 12., 8.,

20., 2., 3., 12., 25., 4., 33., 0., 18., 125., 4., 15., 192., 6., 19., 7., 2., 2., 70., 2., 13., 271., 49., 317., 47., 16., 0., 3., 4., 4., 38., 26., 234., 45., 7., 154., 19., 43., 6., 0., 7., 12., 9., 70., 26., 90., 12., 33., 50., 7., 2., 1., 23., 6., 44., 10., 60., 9., 35., 7., 9., 5., 5., 0., 2., 0., 23., 5., 9., 7., 30., 6., 10., 3., 0., 4., 1., 5., 5., 6., 14., 3., 12., 1., 6., 1., 0., 4., 129., 7., 1920., 94., 111., 217., 95., 98., 72., 12., 17., 24., 15., 1., 2., 7., 7., 4., 13., 7., 41., 14., 38., 14., 55., 6., 11., 2., 5., 10., 5., 4., 2., 2., 3., 2., 0., 3., 8., 10., 1., 0., 10., 0., 2., 0., 7., 2., 5., 28., 5., 13., 6., 6., 5., 21., 3., 4., 4., 2., 18., 2., 37., 5., 5., 5., 10., 21., 8., 11., 8.,

7., 3., 2., 8., 26., 5., 22., 0., 8., 149., 7., 23., 178., 5., 14., 7., 0., 2., 90., 1., 16., 266., 39., 327., 45., 16., 0., 1., 7., 1., 38., 36., 227., 34., 8., 160., 24., 31., 8., 0., 1., 11., 8., 88., 15., 95., 15., 40., 42., 9., 4., 3., 30., 5., 39., 6., 49., 10., 32., 9., 8., 10., 1., 0., 0., 0., 33., 2., 21., 5., 36., 7., 9., 10., 2., 2., 1., 2., 4., 0., 9., 2., 4., 2., 6., 1., 1., 4., 140., 8., 1893., 75., 99., 226., 97., 125., 53., 14., 13., 22., 18., 2., 1., 8., 2., 4., 11., 7., 32., 11., 32., 17., 42., 7., 13., 3., 11., 5., 7., 0., 3., 2., 8., 6., 0., 3., 7., 15., 3., 0., 11., 3., 4., 0., 4., 3., 4., 32., 3., 14., 6., 13., 5., 22., 0., 2., 4., 2., 21., 4., 32., 4., 2., 11., 5., 29., 10., 10., 8.,

12., 0., 3., 6., 21., 2., 34., 2., 21., 167., 1., 34., 171., 5., 18., 5., 3., 3., 85., 2., 22., 264., 27., 345., 43., 10., 1., 2., 15., 6., 42., 27., 224., 39., 9., 164., 12., 35., 8., 0., 3., 13., 7., 78., 20., 77., 15., 42., 51., 14., 2., 0., 29., 16., 46., 7., 56., 9., 27., 4., 14., 7., 1., 0., 0., 0., 19., 7., 13., 6., 22., 7., 11., 5., 4., 3., 1., 0., 5., 0., 16., 3., 10., 0., 14., 4., 1., 2., 118., 7., 1829., 108., 88., 213., 106., 114., 73., 16., 12., 13., 10., 0., 1., 4., 3., 7., 16., 5., 30., 22., 37., 17., 39., 9., 13., 8., 2., 5., 3., 3., 2., 1., 5., 0., 0., 4., 4., 17., 3., 0., 7., 6., 5., 0., 3., 4., 5., 41., 2., 11., 3., 14., 2., 23., 2., 4., 6., 6., 28., 7., 30., 3., 3., 5., 3., 35., 5., 16., 2.,

15., 0., 2., 13., 23., 12., 22., 2., 7., 143., 3., 33., 210., 3., 16., 9., 0., 7., 80., 2., 14., 292., 48., 309., 47., 16., 2., 2., 5., 8., 33., 39., 238., 34., 7., 166., 18., 28., 7., 0., 5., 18., 8., 82., 16., 85., 15., 39., 38., 15., 0., 0., 29., 2., 36., 9., 57., 9., 32., 4., 20., 13., 0., 0., 0., 0., 31., 5., 15., 2., 23., 5., 14., 2., 3., 3., 1., 2., 0., 1., 14., 3., 10., 3., 7., 1., 0., 6., 137., 10., 1871., 94., 99., 215., 98., 110., 67., 17., 12., 21., 11., 3., 0., 4., 11., 3., 5., 7., 30., 18., 21., 12., 35., 6., 8., 7., 2., 7., 7., 1., 2., 4., 8., 2., 0., 2., 4., 11., 1., 0., 16., 7., 4., 0., 2., 3., 4., 29., 3., 10., 0., 12., 2., 20., 3., 5., 8., 5., 26., 3., 31., 5., 6., 9., 6., 26., 9., 10., 4.,

11., 4., 2., 7., 16., 5., 36., 0., 17., 157., 3., 21., 221., 0., 18., 9., 1., 6., 71., 1., 20., 287., 41., 345., 38., 19., 1., 2., 9., 6., 46., 35., 229., 40., 7., 156., 12., 34., 8., 0., 2., 21., 6., 97., 22., 96., 14., 38., 56., 9., 5., 1., 14., 10., 33., 11., 41., 8., 41., 10., 16., 2., 3., 0., 1., 0., 34., 3., 20., 5., 23., 6., 16., 3., 2., 2., 1., 0., 1., 3., 9., 2., 4., 1., 6., 1., 2., 1., 133., 7., 1900., 87., 92., 224., 108., 102., 71., 14., 17., 15., 17., 0., 0., 8., 7., 5., 12., 4., 37., 16., 35., 12., 30., 7., 7., 1., 3., 7., 1., 4., 3., 3., 11., 4., 0., 5., 0., 11., 2., 0., 8., 3., 3., 0., 2., 3., 4., 20., 2., 14., 5., 14., 3., 21., 2., 1., 4., 3., 31., 1., 33., 9., 7., 7., 6., 33., 4., 12., 5.,

12., 1., 4., 8., 26., 4., 29., 0., 12., 177., 3., 30., 208., 4., 20., 8., 0., 8., 75., 3., 16., 291., 46., 338., 54., 20., 1., 3., 9., 4., 39., 37., 228., 38., 13., 159., 15., 37., 4., 0., 1., 9., 9., 76., 22., 99., 16., 39., 45., 9., 1., 2., 30., 6., 40., 8., 66., 11., 34., 4., 6., 10., 1., 0., 0., 0., 17., 3., 14., 1., 26., 4., 14., 4., 2., 1., 2., 2., 1., 0., 8., 3., 7., 0., 6., 3., 0., 0., 157., 7., 1873., 90., 109., 212., 97., 111., 64., 17., 12., 12., 16., 0., 3., 9., 5., 8., 12., 6., 27., 17., 32., 20., 53., 12., 7., 4., 8., 10., 7., 0., 4., 2., 11., 3., 0., 1., 9., 15., 3., 0., 6., 5., 5., 0., 9., 3., 5., 21., 4., 13., 2., 7., 5., 30., 3., 2., 5., 1., 21., 3., 30., 4., 5., 5., 6., 24., 8., 15., 5.,

14., 1., 3., 8., 18., 7., 39., 2., 23., 128., 5., 22., 200., 4., 13., 7., 0., 7., 94., 3., 19., 288., 35., 335., 41., 19., 0., 2., 8., 5., 42., 28., 219., 45., 8., 180., 10., 36., 7., 0., 4., 15., 10., 77., 21., 82., 15., 32., 43., 13., 0., 2., 24., 4., 38., 14., 57., 16., 33., 4., 9., 9., 2., 0., 0., 0., 23., 4., 12., 2., 23., 6., 15., 4., 0., 6., 2., 2., 6., 1., 13., 4., 4., 4., 9., 1., 0., 2., 154., 9., 1876., 81., 94., 214., 99., 104., 53., 16., 13., 11., 9., 1., 0., 2., 8., 3., 7., 8., 37., 12., 36., 21., 48., 10., 9., 8., 0., 7., 2., 1., 3., 7., 6., 2., 0., 2., 4., 17., 2., 0., 11., 1., 2., 0., 4., 5., 0., 34., 2., 17., 1., 13., 1., 25., 3., 5., 5., 5., 23., 1., 30., 6., 5., 8., 9., 46., 7., 15., 2.,

10., 0., 2., 1., 11., 4., 8., 3., 3., 27., 0., 14., 32., 1., 8., 4., 0., 3., 17., 0., 6., 13., 10., 24., 24., 4., 2., 1., 2., 1., 9., 5., 30., 13., 2., 17., 3., 19., 4., 0., 1., 8., 3., 13., 14., 14., 38., 11., 20., 13., 6., 4., 7., 5., 11., 1., 10., 6., 10., 19., 6., 25., 14., 5., 0., 1., 4., 1., 2., 2., 4., 3., 7., 3., 1., 4., 1., 3., 1., 4., 2., 0., 1., 1., 1., 7., 3., 6., 1., 2., 4., 1., 2., 0., 2., 8., 1., 0., 6., 2., 2., 2., 2., 2., 4., 1., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 3., 11., 5., 7., 2., 5., 13., 1., 19., 24., 2., 13., 3., 1., 1., 13., 0., 3., 22., 9., 30., 20., 5., 0., 1., 2., 3., 5., 8., 27., 17., 8., 15., 9., 13., 9., 3., 0., 5., 3., 9., 16., 25., 45., 17., 19., 5., 5., 2., 1., 2., 2., 2., 7., 9., 7., 16., 7., 19., 7., 3., 1., 1., 7., 4., 0., 1., 6., 6., 2., 1., 2., 6., 4., 4., 0., 0., 2., 0., 2., 1., 2., 9., 3., 3., 4., 0., 4., 0., 2., 0., 2., 6., 0., 0., 1., 3., 1., 1., 0., 3., 2., 3., 2., 0., 0., 0., 0., 4., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 3., 1., 4., 5., 4., 6., 1., 6., 23., 2., 20., 20., 1., 23., 5., 3., 2., 18., 1., 4., 31., 13., 16., 27., 8., 0., 0., 1., 2., 9., 14., 26., 16., 1., 14., 6., 18., 7., 1., 0., 5., 3., 6., 7., 12., 45., 12., 21., 10., 3., 0., 7., 2., 12., 4., 7., 4., 5., 15., 7., 31., 8., 3., 1., 0., 17., 1., 4., 1., 6., 0., 4., 3., 5., 4., 5., 2., 0., 1., 1., 0., 3., 2., 1., 11., 1., 2., 1., 0., 2., 0., 2., 0., 1., 5., 2., 0., 3., 2., 1., 4., 2., 0., 4., 0., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 0., 3., 8., 3., 1., 1., 5., 22., 1., 18., 14., 0., 17., 0., 0., 0., 17., 2., 5., 30., 6., 19., 23., 11., 0., 1., 2., 3., 9., 7., 17., 14., 6., 24., 6., 16., 10., 2., 0., 4., 2., 10., 12., 26., 53., 12., 21., 6., 5., 1., 6., 3., 6., 2., 5., 3., 7., 20., 3., 20., 12., 1., 0., 1., 9., 1., 1., 5., 6., 3., 1., 7., 2., 2., 4., 1., 1., 0., 0., 0., 3., 2., 5., 8., 0., 4., 5., 4., 1., 0., 2., 2., 2., 11., 3., 0., 1., 1., 3., 3., 2., 5., 2., 1., 0., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 1., 8., 5., 3., 4., 2., 2., 22., 1., 18., 11., 1., 14., 4., 3., 2., 27., 5., 6., 15., 11., 18., 21., 5., 2., 0., 4., 0., 6., 2., 17., 18., 2., 15., 3., 12., 7., 1., 1., 3., 1., 15., 13., 19., 41., 10., 17., 5., 2., 0., 5., 3., 3., 2., 9., 7., 11., 14., 8., 29., 9., 3., 1., 0., 2., 0., 5., 1., 2., 3., 1., 6., 4., 1., 4., 2., 0., 2., 3., 0., 3., 1., 1., 9., 5., 11., 2., 1., 1., 0., 4., 1., 5., 9., 1., 0., 2., 1., 1., 0., 4., 2., 1., 0., 2., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 2., 11., 2., 3., 0., 4., 23., 0., 17., 20., 2., 14., 2., 3., 0., 19., 1., 3., 28., 15., 23., 41., 4., 1., 0., 1., 2., 9., 8., 25., 16., 3., 7., 6., 11., 3., 4., 1., 7., 1., 10., 15., 25., 32., 15., 22., 12., 3., 2., 3., 1., 2., 1., 6., 8., 8., 15., 8., 15., 7., 6., 0., 1., 6., 1., 2., 0., 3., 3., 6., 3., 1., 5., 2., 2., 0., 2., 1., 0., 3., 1., 1., 9., 2., 6., 1., 1., 2., 1., 4., 0., 3., 7., 3., 0., 2., 2., 1., 0., 2., 3., 1., 1., 3., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 0., 4., 9., 2., 12., 1., 5., 28., 2., 11., 24., 2., 12., 3., 2., 5., 19., 5., 3., 25., 13., 42., 21., 6., 3., 1., 3., 2., 7., 5., 21., 13., 5., 13., 4., 14., 7., 4., 0., 6., 2., 9., 10., 18., 27., 13., 29., 13., 5., 0., 8., 0., 6., 5., 12., 11., 10., 20., 2., 19., 4., 2., 0., 1., 4., 2., 6., 1., 3., 5., 3., 3., 3., 5., 2., 0., 3., 3., 1., 0., 1., 1., 1., 4., 2., 2., 4., 3., 3., 2., 1., 1., 4., 7., 1., 0., 5., 3., 3., 1., 1., 0., 2., 0., 1., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 1., 8., 7., 3., 3., 2., 2., 22., 4., 9., 15., 1., 21., 4., 0., 3., 16., 2., 2., 34., 18., 33., 21., 4., 1., 0., 1., 2., 4., 3., 32., 18., 4., 19., 4., 14., 8., 4., 0., 6., 1., 6., 10., 18., 37., 7., 13., 11., 7., 1., 4., 2., 7., 1., 3., 9., 8., 15., 8., 23., 8., 3., 0., 1., 8., 3., 3., 0., 7., 6., 6., 2., 3., 3., 2., 3., 2., 2., 3., 0., 1., 2., 4., 6., 4., 2., 4., 3., 9., 2., 4., 1., 4., 8., 4., 0., 2., 1., 2., 3., 2., 3., 0., 2., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 3., 6., 5., 2., 5., 0., 5., 29., 0., 13., 16., 0., 16., 7., 1., 2., 16., 2., 7., 29., 12., 34., 24., 6., 1., 0., 4., 6., 6., 8., 24., 13., 4., 20., 5., 8., 10., 2., 1., 3., 1., 17., 10., 24., 57., 7., 22., 9., 6., 3., 5., 1., 7., 4., 8., 6., 8., 15., 0., 25., 10., 5., 2., 1., 5., 0., 3., 4., 5., 1., 5., 3., 3., 5., 4., 2., 1., 2., 1., 0., 4., 3., 3., 7., 1., 4., 2., 3., 5., 2., 3., 2., 4., 11., 1., 0., 4., 1., 2., 5., 2., 2., 2., 2., 2., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 2., 5., 9., 0., 6., 0., 3., 24., 0., 19., 27., 1., 8., 5., 0., 2., 13., 2., 7., 23., 17., 16., 21., 5., 0., 0., 1., 0., 7., 4., 28., 12., 6., 26., 6., 10., 8., 2., 1., 0., 3., 8., 8., 26., 33., 13., 17., 7., 6., 0., 3., 2., 5., 2., 4., 7., 8., 14., 6., 19., 8., 2., 0., 1., 4., 2., 2., 2., 6., 3., 0., 9., 5., 2., 2., 3., 1., 0., 0., 0., 2., 3., 3., 3., 0., 1., 2., 2., 4., 1., 1., 2., 2., 7., 4., 0., 0., 4., 3., 2., 2., 4., 2., 1., 3., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 0., 6., 6., 2., 5., 0., 5., 28., 0., 11., 32., 1., 20., 4., 0., 1., 20., 3., 6., 35., 12., 25., 27., 8., 0., 1., 3., 1., 9., 4., 15., 13., 3., 26., 0., 12., 6., 1., 2., 6., 4., 7., 14., 19., 44., 18., 27., 2., 5., 1., 8., 0., 6., 2., 8., 8., 6., 18., 6., 27., 5., 3., 0., 3., 8., 0., 4., 1., 4., 1., 2., 2., 1., 4., 0., 3., 0., 0., 3., 0., 1., 2., 1., 9., 3., 4., 0., 2., 5., 1., 4., 0., 3., 7., 0., 0., 3., 4., 0., 1., 1., 0., 3., 1., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 1., 5., 7., 9., 4., 0., 8., 7., 0., 15., 19., 1., 12., 2., 1., 2., 41., 2., 4., 19., 16., 40., 18., 7., 0., 2., 4., 0., 11., 8., 21., 13., 3., 11., 5., 15., 9., 1., 1., 6., 2., 10., 12., 11., 41., 10., 18., 9., 4., 2., 6., 4., 10., 3., 16., 4., 12., 24., 4., 18., 11., 3., 1., 1., 5., 2., 5., 3., 6., 6., 2., 5., 0., 4., 4., 4., 0., 3., 2., 0., 0., 2., 2., 2., 1., 5., 2., 2., 5., 0., 2., 0., 2., 6., 0., 0., 4., 2., 2., 3., 3., 4., 3., 0., 0., 0., 0., 0., 0., 4., 0., 0., 5., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 2., 0., 2., 3., 1., 2., 1., 4., 18., 0., 11., 19., 1., 21., 6., 2., 0., 15., 3., 5., 28., 9., 25., 32., 6., 0., 3., 4., 2., 5., 7., 24., 16., 3., 15., 6., 15., 7., 0., 4., 7., 1., 16., 11., 10., 44., 12., 16., 2., 4., 1., 5., 0., 4., 7., 10., 9., 7., 12., 4., 15., 7., 2., 2., 2., 5., 2., 1., 4., 7., 3., 2., 9., 1., 6., 5., 2., 1., 2., 2., 0., 0., 2., 3., 7., 4., 6., 1., 2., 0., 1., 2., 2., 1., 6., 2., 0., 4., 2., 2., 4., 4., 1., 2., 1., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 1., 4., 7., 2., 8., 2., 6., 31., 0., 15., 23., 1., 10., 6., 0., 1., 24., 0., 4., 26., 16., 27., 23., 6., 0., 0., 4., 1., 13., 14., 24., 17., 2., 17., 1., 15., 8., 4., 1., 6., 0., 18., 5., 12., 36., 14., 29., 5., 4., 0., 10., 2., 6., 4., 13., 2., 11., 22., 4., 21., 9., 4., 2., 1., 4., 1., 4., 2., 5., 3., 3., 3., 1., 1., 5., 2., 1., 0., 2., 0., 2., 1., 3., 8., 2., 6., 5., 4., 1., 0., 4., 0., 2., 10., 3., 0., 1., 3., 0., 1., 1., 5., 2., 0., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 4., 9., 2., 6., 1., 4., 14., 1., 19., 17., 2., 6., 3., 0., 0., 12., 1., 3., 17., 12., 25., 18., 5., 0., 2., 1., 1., 5., 5., 28., 22., 2., 17., 8., 11., 9., 0., 0., 5., 1., 14., 16., 14., 46., 8., 16., 5., 3., 2., 4., 2., 6., 6., 14., 5., 8., 19., 9., 26., 7., 3., 1., 2., 8., 1., 0., 1., 7., 2., 3., 7., 2., 3., 2., 3., 1., 2., 0., 0., 1., 4., 4., 11., 2., 1., 2., 4., 5., 4., 2., 1., 1., 13., 5., 0., 3., 3., 4., 4., 2., 0., 0., 2., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 0., 3., 3., 5., 5., 6., 1., 3., 23., 0., 13., 22., 0., 17., 4., 0., 0., 19., 0., 4., 14., 9., 23., 34., 3., 1., 0., 6., 3., 11., 5., 30., 17., 1., 7., 2., 16., 14., 3., 0., 6., 3., 11., 6., 20., 48., 14., 11., 10., 7., 0., 5., 5., 6., 1., 10., 4., 7., 12., 5., 20., 13., 4., 1., 1., 9., 1., 2., 1., 5., 4., 4., 3., 1., 6., 0., 2., 1., 1., 3., 0., 1., 4., 4., 5., 3., 6., 2., 3., 2., 1., 1., 0., 2., 10., 1., 0., 5., 2., 2., 2., 2., 6., 4., 1., 5., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 1., 5., 4., 10., 3., 6., 0., 4., 26., 3., 16., 20., 0., 15., 2., 1., 2., 9., 1., 8., 24., 10., 22., 17., 3., 1., 2., 2., 1., 10., 11., 16., 12., 3., 21., 4., 11., 14., 0., 2., 4., 2., 15., 14., 21., 54., 12., 21., 6., 4., 1., 2., 2., 4., 5., 11., 10., 10., 21., 8., 21., 10., 4., 1., 0., 8., 0., 3., 1., 4., 4., 5., 4., 1., 3., 4., 1., 2., 1., 1., 0., 5., 3., 0., 9., 3., 4., 2., 5., 1., 0., 5., 2., 1., 7., 1., 0., 0., 2., 0., 2., 1., 0., 2., 1., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 0., 6., 16., 2., 9., 0., 10., 20., 0., 10., 17., 1., 13., 5., 2., 4., 17., 2., 5., 24., 12., 24., 25., 9., 0., 2., 1., 3., 9., 8., 30., 15., 4., 16., 3., 11., 7., 3., 2., 4., 2., 14., 11., 18., 40., 13., 24., 10., 3., 1., 5., 1., 10., 3., 12., 7., 9., 16., 11., 17., 9., 3., 3., 0., 4., 2., 6., 2., 6., 3., 1., 8., 3., 5., 1., 1., 1., 2., 2., 0., 2., 6., 0., 7., 3., 6., 4., 2., 5., 0., 3., 1., 1., 9., 1., 0., 2., 2., 0., 2., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 2., 1., 1., 6., 1., 2., 0., 3., 10., 2., 21., 25., 0., 13., 3., 1., 2., 19., 2., 3., 32., 18., 22., 29., 5., 0., 2., 8., 3., 7., 8., 32., 14., 2., 19., 3., 16., 12., 2., 1., 7., 0., 9., 14., 11., 47., 13., 12., 9., 5., 1., 7., 1., 3., 5., 9., 5., 6., 20., 3., 13., 7., 2., 0., 2., 10., 0., 2., 2., 2., 4., 3., 2., 2., 6., 2., 3., 0., 2., 2., 0., 2., 3., 2., 4., 2., 3., 3., 0., 5., 1., 3., 1., 8., 6., 3., 0., 2., 2., 1., 3., 2., 1., 3., 2., 4., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 10., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 0., 7., 8., 4., 9., 2., 5., 23., 1., 18., 29., 0., 10., 1., 0., 0., 8., 2., 7., 15., 16., 31., 34., 3., 0., 1., 4., 3., 5., 6., 13., 20., 0., 15., 7., 20., 13., 3., 0., 2., 3., 20., 9., 18., 37., 14., 22., 10., 3., 1., 7., 5., 6., 2., 12., 9., 8., 12., 4., 23., 11., 3., 0., 1., 6., 1., 4., 2., 5., 0., 4., 3., 1., 4., 1., 3., 2., 2., 2., 0., 1., 1., 1., 8., 1., 2., 3., 3., 4., 1., 2., 2., 2., 3., 1., 0., 4., 2., 2., 1., 2., 1., 3., 0., 4., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 5., 6., 0., 14., 2., 6., 60., 1., 13., 50., 1., 4., 2., 0., 1., 76., 10., 5., 84., 11., 83., 9., 3., 0., 1., 1., 3., 13., 6., 46., 11., 1., 51., 22., 14., 3., 0., 1., 13., 1., 27., 5., 16., 11., 13., 7., 3., 1., 0., 7., 3., 10., 7., 18., 4., 7., 2., 0., 36., 5., 9., 2., 0., 21., 4., 5., 1., 6., 1., 4., 0., 0., 1., 0., 3., 4., 13., 12., 1., 6., 0., 1., 0., 0., 0., 0., 0., 8., 3., 3., 1., 2., 3., 1., 0., 4., 0., 0., 0., 0., 4., 0., 0., 1., 0., 2., 0., 1., 0., 0., 0., 0., 0., 3., 2., 2., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 30., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 4., 2., 11., 0., 6., 3., 8., 48., 0., 5., 63., 1., 3., 3., 0., 1., 63., 3., 2., 82., 15., 74., 15., 1., 0., 1., 3., 2., 8., 11., 44., 14., 2., 40., 38., 20., 6., 0., 0., 7., 4., 20., 0., 30., 9., 15., 10., 4., 5., 0., 8., 4., 19., 7., 9., 4., 8., 1., 2., 39., 8., 10., 1., 0., 18., 2., 5., 0., 5., 3., 2., 0., 1., 1., 0., 5., 0., 13., 5., 3., 2., 0., 1., 0., 0., 0., 0., 0., 4., 2., 4., 0., 3., 1., 0., 0., 1., 0., 1., 0., 1., 3., 1., 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 0., 5., 0., 3., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 19., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 2., 16., 16., 3., 38., 3., 16., 162., 3., 19., 229., 4., 13., 9., 0., 6., 94., 1., 15., 262., 53., 305., 45., 13., 0., 6., 6., 4., 55., 37., 227., 35., 2., 139., 12., 35., 11., 0., 0., 11., 14., 69., 22., 95., 15., 30., 33., 14., 2., 2., 26., 12., 48., 14., 59., 5., 29., 9., 8., 8., 2., 0., 0., 0., 20., 2., 9., 4., 32., 4., 15., 7., 3., 3., 3., 1., 2., 0., 8., 6., 8., 4., 8., 1., 2., 5., 179., 7., 1907., 98., 96., 241., 107., 105., 88., 16., 14., 21., 14., 0., 3., 6., 2., 3., 10., 8., 39., 16., 27., 18., 30., 5., 8., 5., 5., 9., 2., 2., 3., 1., 9., 5., 0., 5., 5., 19., 0., 0., 9., 10., 2., 0., 6., 3., 1., 40., 1., 15., 3., 12., 0., 23., 4., 1., 1., 5., 33., 2., 25., 9., 2., 4., 7., 28., 8., 11., 7.,

20., 2., 2., 6., 26., 5., 37., 0., 19., 160., 1., 28., 222., 6., 19., 8., 1., 8., 85., 0., 9., 255., 53., 349., 39., 15., 0., 2., 4., 10., 44., 29., 252., 36., 7., 163., 13., 40., 6., 0., 0., 15., 8., 83., 19., 83., 20., 41., 43., 12., 6., 1., 18., 9., 34., 10., 64., 9., 22., 8., 10., 9., 2., 0., 2., 0., 26., 1., 19., 2., 29., 4., 11., 6., 1., 2., 0., 1., 0., 3., 4., 5., 9., 2., 5., 0., 0., 7., 148., 11., 1946., 97., 106., 236., 95., 111., 60., 22., 10., 18., 13., 0., 0., 11., 7., 0., 16., 8., 32., 22., 31., 23., 35., 12., 8., 4., 3., 5., 7., 1., 1., 1., 7., 1., 0., 4., 6., 18., 2., 0., 3., 3., 0., 0., 0., 5., 5., 39., 6., 8., 4., 15., 7., 24., 2., 5., 1., 2., 29., 12., 27., 4., 5., 6., 4., 25., 10., 10., 2.,

10., 0., 1., 9., 34., 3., 35., 0., 19., 146., 3., 24., 222., 11., 24., 3., 0., 4., 67., 1., 23., 267., 53., 323., 38., 21., 2., 2., 8., 5., 50., 26., 241., 37., 8., 135., 15., 42., 3., 0., 3., 14., 7., 77., 21., 85., 14., 32., 65., 9., 5., 2., 30., 5., 39., 14., 43., 12., 36., 6., 6., 10., 5., 0., 0., 0., 22., 4., 14., 2., 22., 5., 10., 4., 1., 3., 1., 1., 0., 3., 10., 2., 8., 1., 10., 2., 0., 5., 123., 7., 1876., 87., 104., 226., 73., 111., 68., 12., 16., 23., 21., 1., 1., 8., 3., 3., 8., 8., 30., 14., 48., 9., 35., 6., 12., 4., 4., 9., 8., 0., 6., 3., 5., 2., 0., 3., 5., 26., 3., 0., 9., 7., 0., 0., 4., 4., 1., 24., 8., 11., 3., 15., 3., 18., 3., 3., 2., 6., 24., 5., 31., 13., 5., 7., 7., 39., 6., 9., 6.,

10., 2., 3., 9., 26., 4., 37., 0., 17., 144., 1., 24., 214., 7., 16., 8., 1., 7., 82., 2., 23., 302., 38., 340., 41., 16., 1., 3., 7., 4., 51., 24., 223., 45., 11., 141., 16., 33., 5., 0., 1., 17., 6., 77., 16., 95., 9., 40., 49., 11., 3., 1., 24., 4., 37., 3., 43., 7., 25., 4., 18., 2., 1., 0., 0., 0., 17., 7., 11., 4., 31., 2., 6., 6., 1., 2., 0., 1., 2., 1., 14., 8., 9., 0., 6., 1., 1., 4., 143., 13., 1888., 96., 86., 229., 95., 106., 58., 17., 11., 15., 7., 0., 1., 2., 2., 8., 3., 3., 42., 16., 37., 15., 30., 3., 7., 1., 3., 6., 4., 2., 3., 2., 9., 5., 0., 6., 2., 11., 2., 0., 9., 5., 6., 0., 8., 5., 3., 28., 6., 11., 3., 13., 6., 13., 5., 3., 5., 4., 21., 7., 30., 5., 4., 7., 6., 25., 5., 8., 13.,

10., 0., 2., 5., 32., 7., 28., 1., 20., 149., 5., 32., 166., 3., 13., 8., 1., 2., 89., 1., 17., 288., 45., 333., 44., 22., 0., 2., 5., 2., 44., 36., 254., 47., 2., 151., 17., 43., 9., 0., 1., 24., 9., 90., 16., 82., 14., 38., 51., 15., 3., 0., 33., 7., 37., 10., 51., 10., 42., 6., 20., 4., 2., 0., 0., 0., 24., 2., 10., 6., 26., 4., 11., 5., 1., 2., 1., 0., 3., 2., 18., 4., 6., 3., 13., 1., 0., 4., 140., 4., 1958., 76., 103., 215., 100., 105., 80., 11., 11., 18., 21., 2., 3., 9., 3., 3., 5., 10., 50., 21., 34., 20., 41., 6., 14., 4., 7., 6., 5., 1., 2., 2., 10., 3., 0., 4., 5., 16., 5., 0., 9., 1., 6., 0., 8., 4., 3., 28., 3., 10., 4., 11., 1., 17., 1., 5., 6., 4., 25., 9., 35., 12., 4., 12., 2., 30., 3., 15., 1.,

13., 1., 3., 10., 21., 6., 37., 0., 16., 152., 4., 34., 190., 4., 20., 7., 0., 4., 88., 1., 14., 276., 37., 338., 34., 10., 2., 5., 8., 6., 48., 35., 248., 40., 6., 159., 16., 48., 11., 0., 0., 23., 6., 70., 17., 76., 16., 39., 37., 15., 3., 0., 29., 10., 34., 9., 46., 7., 29., 7., 5., 8., 4., 0., 1., 0., 34., 9., 19., 2., 29., 0., 13., 8., 4., 2., 2., 2., 4., 0., 13., 3., 10., 3., 10., 1., 0., 6., 138., 6., 1895., 81., 81., 240., 97., 109., 54., 11., 19., 22., 10., 0., 1., 5., 5., 1., 11., 8., 40., 17., 37., 16., 51., 7., 7., 2., 3., 4., 2., 2., 1., 2., 11., 1., 0., 1., 6., 18., 2., 0., 8., 8., 5., 0., 3., 2., 2., 33., 8., 13., 3., 11., 2., 24., 3., 2., 4., 5., 31., 5., 33., 4., 6., 7., 1., 32., 8., 12., 5.,

17., 3., 2., 9., 22., 5., 25., 1., 9., 179., 2., 30., 209., 5., 11., 5., 3., 3., 76., 0., 16., 285., 34., 352., 51., 11., 2., 3., 2., 6., 42., 34., 221., 42., 12., 148., 11., 36., 7., 0., 6., 13., 8., 80., 15., 85., 12., 42., 33., 14., 3., 3., 22., 4., 32., 8., 33., 9., 34., 10., 13., 6., 1., 0., 2., 0., 28., 4., 12., 2., 30., 2., 8., 5., 3., 3., 1., 2., 1., 0., 11., 5., 8., 1., 7., 2., 2., 2., 159., 8., 1923., 80., 85., 240., 91., 112., 77., 20., 15., 23., 8., 2., 1., 5., 3., 7., 4., 10., 35., 13., 27., 14., 33., 8., 8., 6., 3., 3., 4., 1., 3., 1., 9., 0., 0., 5., 4., 20., 2., 0., 9., 4., 6., 0., 8., 4., 2., 34., 2., 12., 1., 15., 3., 33., 3., 2., 11., 10., 18., 2., 31., 8., 5., 4., 7., 29., 6., 15., 4.,

16., 4., 8., 10., 26., 3., 29., 1., 16., 190., 5., 33., 210., 6., 10., 4., 0., 2., 84., 3., 19., 288., 47., 334., 38., 15., 2., 3., 3., 8., 40., 37., 233., 46., 5., 129., 9., 36., 9., 0., 2., 20., 3., 69., 13., 110., 20., 27., 48., 8., 0., 0., 20., 7., 31., 6., 53., 9., 34., 8., 13., 13., 0., 0., 0., 0., 29., 5., 16., 3., 26., 2., 16., 3., 2., 5., 1., 2., 1., 1., 11., 5., 5., 1., 7., 0., 0., 4., 137., 10., 1930., 91., 77., 232., 97., 118., 85., 10., 14., 15., 10., 3., 0., 8., 1., 5., 7., 8., 45., 12., 37., 16., 36., 4., 13., 6., 3., 10., 8., 0., 1., 4., 9., 1., 0., 6., 0., 13., 1., 0., 11., 0., 1., 0., 2., 3., 4., 31., 2., 17., 2., 13., 6., 19., 6., 4., 4., 4., 22., 3., 35., 4., 3., 4., 4., 31., 4., 12., 10.,

21., 0., 3., 11., 25., 4., 43., 0., 18., 152., 3., 26., 238., 6., 6., 7., 0., 6., 77., 5., 16., 309., 40., 298., 36., 10., 1., 1., 3., 6., 42., 13., 215., 26., 6., 151., 20., 45., 8., 0., 1., 14., 4., 74., 17., 103., 18., 36., 46., 9., 2., 1., 22., 9., 36., 9., 35., 4., 33., 4., 11., 7., 3., 0., 1., 0., 19., 5., 11., 4., 27., 4., 10., 6., 2., 2., 2., 0., 2., 0., 8., 2., 13., 1., 7., 1., 2., 1., 131., 7., 1965., 71., 104., 237., 95., 93., 57., 15., 17., 16., 19., 1., 2., 5., 6., 4., 9., 8., 31., 17., 36., 8., 34., 2., 10., 4., 7., 6., 6., 3., 3., 5., 5., 4., 0., 2., 4., 15., 2., 0., 8., 4., 1., 0., 4., 4., 1., 30., 3., 14., 2., 11., 4., 24., 4., 6., 2., 6., 23., 9., 42., 2., 11., 11., 5., 28., 4., 14., 5.,

7., 1., 0., 3., 13., 4., 6., 0., 8., 21., 0., 21., 13., 1., 26., 3., 0., 2., 15., 5., 3., 28., 15., 38., 30., 5., 0., 1., 4., 2., 6., 13., 17., 16., 6., 25., 5., 14., 14., 1., 3., 5., 1., 11., 11., 28., 47., 15., 13., 10., 3., 1., 10., 1., 9., 4., 14., 3., 7., 19., 6., 19., 7., 5., 1., 0., 7., 0., 2., 1., 4., 3., 5., 3., 1., 13., 1., 2., 2., 1., 1., 0., 2., 3., 0., 6., 2., 3., 1., 3., 1., 1., 1., 1., 0., 5., 2., 0., 2., 2., 6., 1., 1., 0., 2., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 0., 7., 11., 1., 8., 2., 11., 28., 1., 7., 18., 2., 15., 1., 0., 2., 24., 2., 5., 25., 14., 19., 24., 8., 1., 0., 0., 1., 10., 9., 25., 11., 1., 7., 5., 23., 6., 2., 2., 4., 1., 12., 15., 6., 43., 6., 20., 10., 5., 1., 6., 1., 10., 2., 10., 2., 8., 15., 8., 24., 9., 2., 0., 2., 8., 3., 2., 1., 2., 3., 4., 3., 2., 1., 1., 3., 2., 0., 3., 0., 5., 2., 5., 4., 1., 6., 4., 2., 3., 3., 3., 1., 2., 5., 4., 0., 3., 0., 4., 1., 0., 0., 6., 1., 4., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 1., 3., 3., 4., 1., 3., 0., 3., 13., 1., 11., 20., 0., 14., 5., 0., 1., 23., 3., 1., 21., 13., 24., 27., 4., 1., 0., 4., 1., 12., 8., 20., 27., 4., 19., 6., 15., 9., 2., 2., 5., 5., 14., 10., 10., 43., 14., 21., 9., 4., 1., 3., 2., 5., 3., 16., 9., 14., 15., 7., 17., 7., 2., 0., 1., 7., 3., 5., 1., 5., 2., 5., 2., 1., 3., 3., 4., 1., 4., 3., 0., 2., 2., 2., 6., 2., 5., 1., 1., 3., 0., 1., 2., 2., 6., 1., 0., 1., 3., 1., 1., 5., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

17., 2., 3., 4., 5., 3., 5., 2., 1., 22., 1., 16., 16., 3., 19., 1., 0., 1., 4., 3., 3., 31., 13., 19., 30., 9., 3., 0., 4., 3., 6., 0., 24., 16., 1., 14., 6., 14., 6., 2., 1., 4., 3., 14., 12., 15., 41., 15., 27., 8., 3., 1., 6., 2., 4., 2., 12., 5., 4., 12., 11., 25., 13., 3., 3., 0., 7., 2., 4., 2., 0., 2., 4., 6., 1., 2., 4., 2., 2., 2., 4., 0., 3., 0., 0., 4., 4., 1., 0., 4., 4., 1., 4., 1., 1., 7., 3., 0., 2., 1., 3., 5., 0., 3., 2., 1., 3., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 0., 3., 6., 4., 13., 1., 9., 18., 0., 13., 15., 3., 11., 5., 0., 2., 29., 0., 1., 24., 11., 31., 24., 7., 1., 0., 3., 2., 6., 12., 19., 9., 2., 20., 3., 11., 10., 1., 1., 2., 3., 12., 11., 17., 37., 11., 15., 10., 1., 2., 2., 1., 13., 1., 5., 4., 4., 15., 3., 24., 4., 3., 1., 2., 5., 1., 1., 1., 3., 2., 4., 2., 1., 5., 0., 3., 1., 3., 6., 0., 1., 0., 3., 7., 3., 4., 2., 0., 2., 0., 0., 0., 1., 3., 6., 0., 1., 4., 2., 3., 1., 0., 4., 1., 3., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 2., 1., 13., 1., 8., 0., 6., 24., 1., 15., 32., 1., 19., 6., 0., 1., 14., 4., 4., 21., 9., 32., 32., 5., 2., 0., 5., 0., 3., 8., 31., 12., 3., 21., 2., 9., 13., 3., 2., 3., 2., 16., 16., 18., 52., 13., 19., 11., 1., 0., 4., 2., 5., 2., 11., 8., 8., 10., 3., 22., 6., 4., 0., 0., 5., 1., 2., 3., 2., 4., 2., 4., 0., 3., 3., 1., 0., 0., 3., 0., 2., 2., 1., 7., 0., 1., 1., 3., 6., 1., 2., 2., 1., 8., 3., 0., 2., 0., 3., 3., 1., 1., 2., 0., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 6., 6., 8., 2., 4., 1., 6., 37., 2., 13., 8., 1., 13., 2., 0., 0., 13., 0., 4., 28., 11., 21., 28., 2., 1., 0., 4., 2., 4., 9., 23., 23., 1., 12., 7., 13., 6., 7., 2., 5., 1., 14., 12., 12., 39., 15., 16., 11., 3., 1., 3., 2., 3., 1., 11., 4., 3., 25., 6., 17., 3., 2., 0., 1., 6., 0., 3., 1., 5., 4., 1., 8., 1., 2., 4., 0., 1., 1., 2., 0., 2., 5., 3., 7., 1., 5., 1., 1., 1., 2., 1., 1., 2., 7., 3., 0., 4., 1., 1., 2., 1., 5., 1., 1., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 3., 7., 5., 6., 1., 10., 25., 1., 9., 24., 0., 18., 0., 3., 0., 17., 2., 4., 24., 15., 25., 25., 3., 0., 0., 3., 4., 5., 6., 21., 22., 8., 17., 4., 12., 12., 0., 1., 6., 1., 8., 5., 16., 47., 10., 20., 8., 5., 0., 5., 1., 8., 1., 9., 4., 11., 26., 8., 25., 11., 7., 4., 0., 5., 3., 6., 1., 5., 6., 4., 6., 1., 5., 1., 3., 2., 2., 2., 0., 3., 2., 0., 6., 5., 4., 2., 5., 5., 0., 1., 4., 1., 8., 1., 0., 1., 4., 4., 2., 2., 2., 1., 3., 0., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 2., 4., 2., 4., 1., 12., 1., 6., 18., 1., 9., 22., 2., 15., 2., 2., 2., 4., 6., 3., 28., 7., 21., 33., 2., 1., 0., 2., 2., 6., 6., 24., 20., 2., 13., 3., 14., 6., 1., 0., 6., 5., 8., 9., 15., 47., 11., 21., 8., 5., 2., 10., 2., 6., 2., 8., 4., 11., 9., 5., 27., 11., 3., 0., 1., 6., 2., 6., 1., 8., 1., 3., 6., 5., 2., 3., 3., 2., 0., 4., 0., 1., 4., 2., 2., 0., 5., 1., 1., 8., 0., 5., 2., 0., 12., 1., 0., 1., 5., 0., 2., 1., 2., 6., 0., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 5., 9., 4., 4., 1., 6., 28., 3., 12., 20., 1., 13., 3., 1., 1., 10., 6., 3., 22., 10., 27., 32., 9., 0., 2., 2., 2., 8., 3., 14., 18., 3., 18., 3., 11., 9., 5., 0., 2., 4., 11., 11., 15., 41., 13., 21., 5., 4., 0., 8., 2., 6., 4., 9., 3., 7., 16., 5., 10., 4., 2., 4., 1., 11., 0., 4., 4., 7., 2., 5., 4., 1., 8., 2., 1., 1., 2., 6., 0., 3., 4., 1., 8., 3., 2., 5., 0., 5., 2., 2., 4., 2., 7., 3., 0., 3., 1., 0., 5., 2., 0., 3., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 3., 3., 7., 4., 6., 1., 7., 8., 0., 9., 22., 2., 17., 2., 3., 3., 16., 1., 4., 28., 12., 36., 35., 6., 1., 2., 2., 1., 10., 3., 32., 15., 1., 13., 2., 13., 7., 4., 0., 7., 2., 8., 13., 23., 39., 13., 28., 11., 2., 0., 4., 2., 9., 2., 12., 9., 15., 7., 5., 30., 5., 6., 1., 0., 5., 1., 3., 1., 5., 4., 0., 7., 1., 5., 5., 2., 0., 1., 1., 0., 1., 4., 0., 4., 4., 0., 2., 2., 1., 1., 2., 1., 0., 5., 2., 0., 4., 3., 1., 2., 2., 1., 2., 2., 6., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 4., 1., 3., 2., 14., 0., 5., 21., 2., 15., 22., 1., 11., 2., 1., 1., 9., 0., 2., 35., 11., 29., 27., 4., 2., 1., 4., 1., 9., 6., 27., 12., 3., 12., 3., 10., 10., 3., 0., 3., 3., 18., 10., 11., 47., 4., 26., 13., 3., 2., 7., 0., 3., 6., 8., 7., 7., 10., 4., 24., 8., 6., 1., 1., 9., 0., 1., 0., 5., 3., 2., 5., 1., 3., 2., 3., 1., 1., 1., 0., 1., 1., 3., 5., 3., 6., 1., 1., 3., 2., 1., 1., 1., 10., 2., 0., 4., 4., 0., 1., 3., 1., 2., 3., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 1., 6., 9., 4., 2., 1., 8., 28., 0., 10., 25., 2., 10., 1., 3., 2., 14., 3., 4., 27., 11., 29., 30., 5., 1., 1., 2., 3., 7., 7., 24., 12., 0., 9., 4., 11., 10., 0., 1., 6., 1., 12., 16., 17., 53., 10., 25., 8., 5., 1., 6., 3., 5., 2., 12., 9., 7., 26., 12., 18., 10., 4., 0., 0., 9., 0., 5., 0., 4., 3., 5., 4., 1., 3., 6., 1., 3., 3., 3., 0., 1., 2., 1., 5., 2., 1., 1., 2., 3., 0., 1., 1., 3., 3., 1., 0., 1., 2., 2., 0., 4., 1., 3., 3., 2., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 4., 3., 8., 2., 6., 1., 7., 21., 0., 10., 25., 0., 18., 4., 0., 3., 16., 4., 4., 22., 8., 23., 29., 10., 2., 2., 1., 2., 6., 3., 17., 14., 3., 18., 5., 17., 8., 0., 0., 5., 0., 17., 4., 12., 52., 12., 22., 7., 3., 0., 8., 2., 6., 4., 9., 5., 10., 19., 6., 25., 6., 2., 4., 0., 9., 1., 1., 1., 4., 4., 4., 0., 2., 7., 3., 5., 3., 4., 1., 0., 3., 0., 4., 5., 2., 3., 3., 2., 3., 0., 1., 1., 3., 6., 2., 0., 2., 0., 2., 2., 2., 4., 1., 0., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 5., 5., 9., 3., 8., 1., 7., 10., 1., 15., 36., 0., 14., 0., 1., 1., 9., 1., 4., 40., 10., 31., 20., 4., 1., 1., 6., 2., 8., 6., 15., 18., 3., 17., 3., 15., 8., 2., 0., 4., 2., 10., 9., 14., 44., 11., 15., 8., 6., 2., 2., 1., 9., 2., 8., 7., 12., 14., 8., 20., 10., 1., 0., 2., 4., 2., 5., 0., 8., 7., 1., 4., 1., 6., 2., 2., 0., 1., 2., 0., 2., 2., 2., 8., 2., 4., 1., 1., 4., 0., 0., 2., 3., 7., 1., 0., 2., 2., 3., 1., 0., 2., 1., 0., 2., 0., 0., 0., 0., 6., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 1., 5., 7., 2., 5., 1., 4., 30., 2., 14., 12., 1., 11., 6., 3., 2., 15., 3., 4., 28., 14., 27., 26., 13., 3., 2., 1., 2., 11., 7., 23., 17., 0., 10., 3., 13., 11., 2., 0., 3., 3., 11., 11., 15., 50., 12., 24., 7., 4., 2., 3., 2., 7., 4., 11., 2., 5., 18., 7., 25., 16., 2., 2., 1., 6., 0., 5., 1., 6., 1., 3., 4., 3., 9., 3., 3., 0., 1., 2., 0., 5., 1., 0., 4., 4., 5., 2., 0., 3., 1., 2., 1., 1., 7., 6., 0., 1., 2., 4., 0., 4., 5., 5., 0., 4., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 1., 1., 5., 9., 5., 6., 1., 4., 30., 1., 12., 19., 0., 13., 0., 0., 1., 23., 4., 1., 30., 13., 24., 25., 8., 1., 1., 2., 4., 7., 5., 34., 20., 3., 11., 2., 8., 10., 1., 1., 7., 1., 7., 7., 18., 57., 14., 29., 8., 3., 1., 3., 3., 4., 3., 9., 4., 13., 15., 8., 17., 8., 5., 2., 1., 5., 0., 3., 0., 3., 2., 4., 9., 2., 6., 3., 1., 0., 1., 1., 0., 2., 3., 1., 5., 3., 6., 0., 0., 5., 1., 1., 0., 1., 8., 0., 0., 6., 3., 2., 3., 1., 1., 3., 0., 0., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 6., 6., 0., 9., 3., 6., 14., 0., 11., 21., 1., 11., 2., 0., 2., 16., 1., 1., 16., 12., 21., 30., 9., 0., 1., 3., 1., 4., 4., 36., 19., 2., 14., 7., 16., 7., 3., 3., 2., 7., 11., 8., 21., 45., 12., 26., 5., 3., 1., 3., 2., 8., 0., 13., 5., 7., 19., 5., 12., 8., 5., 2., 1., 12., 1., 1., 3., 5., 1., 2., 3., 3., 4., 5., 0., 2., 3., 0., 0., 4., 6., 2., 4., 1., 4., 0., 4., 2., 2., 1., 1., 2., 6., 0., 0., 1., 1., 1., 1., 1., 3., 3., 1., 3., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 4., 5., 3., 3., 5., 1., 6., 27., 0., 17., 25., 3., 15., 2., 1., 1., 12., 2., 5., 14., 11., 16., 21., 7., 2., 3., 4., 2., 4., 8., 22., 15., 2., 15., 2., 15., 8., 1., 1., 4., 1., 9., 15., 19., 45., 10., 26., 12., 3., 0., 5., 2., 2., 4., 4., 11., 4., 12., 3., 15., 6., 1., 1., 0., 9., 1., 2., 2., 10., 3., 2., 5., 1., 2., 4., 4., 1., 2., 1., 0., 2., 2., 2., 9., 1., 3., 2., 3., 5., 1., 4., 1., 4., 11., 1., 0., 3., 1., 2., 2., 3., 2., 1., 1., 3., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 0., 6., 7., 1., 6., 1., 6., 4., 3., 15., 16., 2., 13., 0., 2., 3., 22., 2., 1., 29., 16., 17., 30., 5., 1., 1., 4., 1., 7., 7., 16., 11., 4., 17., 4., 23., 10., 2., 0., 3., 1., 10., 5., 18., 40., 13., 20., 6., 3., 1., 8., 2., 8., 3., 14., 7., 10., 17., 1., 21., 6., 3., 0., 1., 8., 2., 3., 2., 2., 4., 5., 2., 2., 7., 3., 0., 2., 0., 1., 0., 2., 5., 2., 5., 2., 5., 5., 4., 5., 1., 3., 2., 5., 10., 3., 0., 4., 3., 2., 1., 3., 5., 0., 1., 1., 0., 0., 0., 0., 5., 0., 0., 3., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 3., 0., 13., 3., 12., 2., 8., 16., 1., 13., 17., 0., 14., 4., 2., 4., 17., 3., 5., 24., 10., 28., 30., 4., 0., 3., 3., 2., 3., 6., 21., 14., 2., 14., 2., 11., 13., 2., 0., 5., 3., 12., 8., 17., 43., 13., 21., 7., 5., 1., 4., 2., 9., 7., 8., 10., 9., 15., 6., 27., 5., 2., 1., 0., 2., 1., 5., 0., 4., 3., 5., 6., 3., 5., 2., 1., 3., 0., 3., 0., 3., 2., 1., 5., 3., 7., 2., 3., 3., 0., 1., 2., 0., 5., 2., 0., 1., 4., 1., 3., 1., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 3., 10., 0., 12., 3., 8., 51., 2., 3., 69., 0., 6., 2., 0., 0., 64., 9., 10., 60., 17., 67., 17., 3., 0., 2., 5., 0., 12., 10., 39., 13., 3., 47., 31., 15., 4., 0., 0., 8., 2., 26., 4., 22., 3., 13., 4., 4., 1., 0., 14., 6., 16., 2., 15., 3., 8., 3., 1., 41., 11., 5., 2., 0., 11., 2., 9., 2., 10., 0., 3., 3., 0., 1., 0., 5., 0., 10., 18., 4., 4., 1., 2., 0., 0., 0., 0., 0., 9., 1., 1., 3., 2., 2., 1., 0., 3., 0., 2., 0., 0., 3., 0., 0., 1., 0., 1., 0., 2., 0., 0., 0., 2., 0., 2., 1., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 26., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 2., 3., 5., 7., 0., 11., 2., 4., 69., 1., 5., 58., 0., 5., 0., 0., 1., 68., 7., 7., 70., 17., 93., 15., 3., 0., 2., 2., 1., 16., 9., 57., 14., 0., 41., 33., 17., 3., 0., 0., 4., 8., 12., 3., 29., 11., 18., 4., 2., 1., 0., 8., 2., 12., 5., 15., 3., 5., 4., 2., 38., 6., 6., 1., 0., 15., 2., 7., 3., 12., 3., 5., 2., 1., 2., 0., 5., 1., 11., 13., 1., 4., 0., 4., 0., 0., 0., 0., 0., 12., 4., 3., 4., 4., 2., 0., 0., 1., 0., 0., 0., 1., 3., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 18., 0., 6., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 1., 11., 30., 6., 31., 0., 16., 170., 1., 25., 212., 3., 21., 10., 0., 4., 85., 3., 22., 260., 40., 314., 53., 18., 1., 3., 9., 2., 47., 37., 227., 36., 10., 169., 12., 39., 5., 0., 1., 16., 4., 78., 24., 84., 10., 38., 42., 20., 4., 0., 30., 8., 35., 9., 48., 9., 33., 8., 16., 5., 1., 0., 0., 0., 18., 4., 14., 4., 23., 5., 15., 4., 2., 0., 2., 0., 5., 1., 7., 2., 13., 3., 15., 0., 1., 8., 139., 7., 1838., 106., 99., 222., 105., 113., 72., 15., 7., 17., 11., 1., 1., 6., 2., 4., 9., 11., 31., 16., 44., 16., 38., 6., 9., 3., 4., 14., 4., 3., 3., 1., 9., 3., 0., 2., 6., 14., 0., 0., 7., 5., 1., 0., 9., 4., 4., 29., 0., 14., 2., 18., 3., 22., 3., 4., 4., 7., 26., 4., 43., 7., 6., 7., 4., 33., 7., 13., 6.,

12., 2., 4., 8., 32., 5., 24., 0., 14., 136., 3., 24., 220., 5., 16., 8., 2., 5., 75., 3., 15., 290., 40., 345., 28., 15., 1., 1., 11., 8., 47., 34., 223., 33., 9., 181., 14., 49., 1., 0., 2., 15., 11., 63., 19., 77., 6., 41., 35., 5., 7., 1., 23., 10., 41., 11., 46., 13., 39., 2., 16., 3., 1., 0., 0., 0., 22., 3., 15., 2., 21., 5., 17., 6., 2., 4., 0., 0., 5., 1., 9., 3., 7., 2., 10., 0., 0., 5., 151., 10., 1794., 90., 102., 257., 84., 115., 57., 16., 12., 16., 9., 3., 3., 5., 6., 5., 11., 7., 41., 14., 28., 19., 38., 6., 9., 0., 8., 5., 7., 0., 5., 1., 6., 1., 0., 6., 4., 21., 1., 0., 10., 4., 3., 0., 6., 5., 0., 33., 5., 17., 2., 10., 7., 21., 2., 3., 3., 4., 27., 3., 31., 5., 11., 3., 6., 34., 5., 8., 7.,

17., 7., 2., 13., 24., 3., 32., 2., 12., 168., 7., 24., 201., 6., 23., 6., 0., 0., 88., 3., 21., 287., 43., 323., 44., 16., 1., 2., 6., 7., 42., 31., 222., 37., 12., 175., 7., 42., 6., 0., 1., 13., 5., 97., 20., 81., 14., 33., 38., 17., 2., 0., 29., 4., 47., 10., 50., 5., 23., 7., 6., 6., 3., 0., 1., 0., 26., 4., 18., 5., 22., 7., 11., 4., 3., 2., 3., 1., 3., 1., 4., 6., 10., 3., 8., 0., 1., 5., 160., 9., 1830., 115., 90., 213., 78., 122., 60., 18., 12., 17., 14., 0., 1., 7., 4., 2., 6., 8., 42., 12., 32., 14., 49., 9., 5., 1., 11., 12., 7., 5., 0., 1., 7., 0., 0., 1., 1., 20., 3., 0., 9., 8., 3., 0., 4., 1., 4., 33., 2., 10., 1., 12., 1., 21., 4., 3., 2., 4., 33., 2., 30., 6., 4., 8., 9., 25., 8., 16., 3.,

8., 1., 3., 5., 26., 5., 35., 0., 16., 162., 4., 37., 195., 2., 22., 4., 0., 5., 75., 3., 12., 248., 51., 318., 48., 21., 0., 3., 8., 2., 40., 39., 238., 45., 8., 154., 9., 54., 5., 0., 4., 15., 7., 63., 26., 99., 15., 39., 42., 14., 6., 1., 25., 6., 42., 11., 38., 10., 39., 6., 9., 11., 6., 0., 3., 0., 26., 6., 12., 2., 28., 7., 15., 4., 1., 5., 1., 0., 4., 3., 6., 2., 8., 1., 9., 2., 1., 2., 151., 11., 1926., 73., 105., 253., 81., 112., 72., 15., 12., 20., 7., 3., 3., 12., 3., 4., 15., 7., 26., 13., 30., 18., 35., 7., 5., 5., 7., 5., 5., 2., 6., 5., 7., 3., 0., 2., 5., 19., 3., 0., 5., 1., 4., 0., 7., 4., 3., 30., 2., 7., 4., 12., 5., 21., 2., 2., 3., 1., 27., 8., 34., 6., 2., 4., 10., 43., 6., 9., 4.,

20., 0., 4., 7., 19., 10., 26., 0., 15., 165., 5., 27., 199., 1., 16., 12., 1., 5., 88., 4., 20., 294., 48., 332., 34., 18., 0., 1., 5., 6., 49., 30., 235., 28., 11., 168., 11., 45., 6., 0., 3., 14., 12., 61., 17., 91., 21., 44., 45., 10., 6., 1., 26., 4., 50., 12., 47., 11., 23., 7., 13., 7., 2., 0., 0., 0., 34., 2., 14., 3., 30., 3., 13., 3., 2., 2., 1., 0., 5., 4., 14., 3., 7., 3., 10., 1., 1., 3., 125., 10., 1845., 101., 110., 235., 84., 100., 65., 14., 8., 17., 12., 1., 4., 7., 8., 3., 8., 9., 38., 13., 37., 13., 42., 11., 15., 5., 4., 10., 4., 3., 3., 2., 8., 5., 0., 6., 8., 12., 1., 0., 9., 5., 1., 0., 2., 5., 4., 27., 2., 11., 1., 12., 4., 20., 2., 5., 5., 6., 36., 4., 38., 6., 5., 9., 5., 28., 2., 22., 4.,

13., 3., 2., 10., 24., 6., 35., 1., 9., 156., 0., 36., 220., 9., 12., 7., 4., 1., 86., 3., 13., 268., 37., 325., 43., 18., 1., 2., 2., 6., 48., 34., 241., 48., 7., 156., 9., 34., 6., 0., 0., 19., 11., 80., 19., 82., 15., 27., 49., 11., 4., 1., 31., 7., 39., 8., 38., 7., 32., 7., 9., 6., 1., 0., 1., 0., 22., 6., 14., 3., 28., 5., 10., 10., 2., 0., 2., 0., 5., 0., 17., 4., 10., 4., 7., 1., 1., 5., 144., 4., 1894., 94., 105., 218., 99., 112., 69., 15., 11., 25., 12., 1., 4., 4., 9., 3., 11., 9., 26., 11., 29., 19., 32., 8., 6., 4., 7., 5., 8., 2., 2., 1., 10., 3., 0., 2., 8., 19., 1., 0., 10., 5., 4., 0., 4., 0., 3., 28., 3., 16., 2., 20., 1., 27., 2., 6., 5., 6., 28., 9., 32., 7., 5., 8., 9., 34., 4., 16., 2.,

18., 1., 1., 7., 27., 3., 35., 0., 9., 162., 2., 24., 209., 4., 17., 7., 2., 11., 69., 1., 11., 304., 43., 329., 45., 13., 0., 2., 8., 4., 49., 21., 230., 40., 5., 156., 9., 60., 6., 0., 1., 18., 6., 72., 16., 71., 9., 26., 50., 18., 1., 2., 28., 5., 36., 8., 59., 8., 33., 3., 7., 8., 5., 0., 1., 0., 26., 2., 20., 5., 22., 4., 25., 2., 2., 2., 0., 0., 3., 2., 11., 4., 10., 3., 10., 3., 0., 4., 130., 3., 1892., 76., 93., 194., 100., 104., 78., 16., 13., 11., 13., 2., 2., 10., 3., 7., 5., 7., 28., 20., 34., 13., 41., 7., 12., 2., 6., 3., 3., 2., 2., 5., 9., 1., 0., 8., 8., 13., 5., 0., 8., 1., 4., 0., 4., 5., 2., 43., 3., 6., 4., 14., 4., 12., 4., 1., 7., 2., 29., 9., 27., 4., 3., 6., 4., 28., 6., 7., 6.,

16., 1., 2., 5., 21., 3., 35., 0., 13., 162., 2., 18., 198., 6., 16., 8., 0., 6., 84., 2., 19., 302., 48., 339., 44., 23., 0., 2., 7., 6., 49., 30., 217., 32., 6., 155., 18., 46., 3., 0., 3., 16., 10., 78., 24., 85., 12., 34., 42., 13., 2., 0., 24., 4., 30., 9., 57., 7., 32., 10., 6., 10., 1., 0., 1., 0., 27., 9., 17., 4., 22., 8., 12., 3., 0., 5., 3., 2., 0., 2., 12., 1., 9., 2., 8., 1., 3., 6., 130., 6., 1868., 98., 106., 229., 97., 124., 86., 17., 9., 11., 13., 1., 3., 3., 6., 2., 9., 8., 38., 19., 36., 18., 37., 9., 9., 4., 7., 8., 2., 1., 3., 3., 5., 8., 0., 3., 5., 14., 1., 0., 15., 0., 2., 0., 2., 3., 3., 26., 3., 17., 3., 10., 2., 27., 3., 1., 0., 4., 25., 6., 24., 6., 4., 9., 7., 23., 6., 16., 5.,

10., 1., 2., 5., 5., 2., 3., 5., 7., 8., 1., 12., 15., 1., 16., 4., 0., 1., 16., 2., 6., 12., 7., 34., 32., 5., 1., 0., 5., 4., 5., 12., 25., 16., 1., 18., 2., 13., 7., 1., 1., 3., 2., 7., 11., 17., 48., 16., 23., 7., 6., 0., 5., 1., 6., 3., 17., 2., 11., 16., 2., 33., 6., 3., 1., 1., 7., 1., 3., 1., 3., 1., 4., 4., 1., 4., 1., 3., 0., 1., 2., 0., 0., 3., 1., 3., 0., 2., 5., 1., 4., 1., 1., 2., 4., 12., 2., 0., 1., 0., 1., 0., 2., 3., 2., 1., 5., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 2., 4., 5., 4., 5., 1., 3., 12., 2., 9., 12., 2., 13., 4., 0., 4., 25., 1., 3., 33., 9., 33., 22., 3., 0., 2., 3., 0., 7., 11., 26., 17., 2., 15., 4., 17., 10., 1., 2., 3., 3., 8., 9., 11., 51., 8., 24., 4., 4., 1., 4., 2., 9., 5., 7., 5., 8., 21., 7., 31., 9., 4., 1., 2., 10., 2., 3., 2., 6., 0., 4., 6., 1., 5., 3., 5., 0., 5., 0., 0., 0., 3., 1., 4., 2., 2., 5., 2., 6., 0., 2., 1., 2., 10., 1., 0., 2., 2., 3., 4., 0., 4., 1., 1., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 1., 3., 4., 6., 5., 2., 0., 7., 6., 0., 17., 24., 2., 17., 6., 2., 0., 17., 1., 0., 20., 13., 26., 23., 5., 0., 0., 4., 2., 6., 15., 13., 11., 5., 21., 1., 11., 12., 1., 0., 6., 2., 14., 12., 16., 35., 9., 28., 10., 2., 1., 2., 3., 5., 4., 10., 8., 8., 23., 9., 20., 9., 3., 0., 0., 8., 0., 3., 0., 4., 3., 5., 8., 5., 4., 3., 0., 2., 2., 0., 0., 1., 3., 5., 5., 3., 2., 2., 1., 2., 1., 7., 0., 3., 10., 1., 0., 0., 1., 1., 5., 3., 3., 2., 1., 3., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 2., 3., 11., 2., 0., 1., 8., 18., 2., 2., 21., 0., 17., 2., 0., 3., 20., 3., 5., 17., 6., 22., 14., 4., 0., 1., 0., 3., 10., 12., 28., 20., 2., 19., 4., 16., 4., 1., 1., 2., 0., 9., 9., 17., 52., 23., 16., 9., 8., 2., 4., 0., 6., 1., 13., 7., 6., 18., 5., 19., 10., 1., 2., 3., 9., 1., 5., 1., 6., 4., 5., 3., 1., 3., 8., 5., 1., 3., 2., 0., 1., 5., 2., 5., 2., 4., 2., 0., 4., 1., 1., 1., 4., 2., 1., 0., 3., 1., 2., 3., 1., 3., 1., 1., 3., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 3., 1., 8., 2., 4., 1., 8., 11., 2., 18., 22., 0., 17., 5., 2., 3., 17., 5., 6., 26., 12., 21., 27., 7., 0., 2., 3., 1., 9., 7., 34., 15., 11., 24., 7., 11., 3., 2., 2., 1., 3., 11., 8., 25., 43., 12., 25., 5., 7., 1., 8., 4., 6., 6., 10., 9., 6., 24., 7., 20., 6., 2., 1., 1., 10., 2., 2., 0., 5., 5., 5., 7., 4., 3., 4., 4., 0., 4., 1., 0., 2., 0., 2., 7., 4., 4., 3., 4., 3., 2., 3., 0., 5., 5., 2., 0., 3., 3., 0., 2., 1., 3., 6., 0., 6., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 0., 9., 9., 4., 2., 1., 5., 41., 1., 10., 32., 0., 9., 4., 3., 3., 18., 0., 1., 24., 15., 18., 26., 3., 3., 0., 2., 2., 8., 3., 23., 13., 1., 16., 2., 6., 11., 2., 2., 6., 2., 6., 15., 15., 48., 10., 17., 8., 7., 0., 5., 0., 7., 5., 10., 7., 11., 26., 4., 26., 9., 1., 1., 0., 8., 3., 5., 2., 9., 3., 4., 4., 1., 6., 4., 4., 1., 1., 1., 0., 1., 4., 0., 5., 1., 7., 6., 2., 2., 0., 2., 2., 2., 8., 2., 0., 3., 1., 5., 1., 0., 1., 4., 1., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 2., 2., 4., 9., 3., 4., 2., 5., 32., 4., 16., 19., 0., 10., 3., 1., 1., 13., 4., 5., 18., 10., 24., 29., 3., 1., 0., 7., 2., 8., 7., 33., 12., 2., 12., 4., 8., 8., 1., 0., 6., 3., 6., 14., 19., 43., 9., 19., 14., 5., 2., 5., 2., 6., 5., 12., 11., 12., 11., 4., 17., 8., 1., 1., 1., 10., 0., 5., 0., 2., 1., 5., 4., 1., 10., 3., 2., 0., 2., 3., 0., 2., 0., 2., 5., 3., 3., 1., 3., 3., 0., 4., 3., 3., 5., 1., 0., 2., 1., 2., 3., 0., 3., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 3., 1., 4., 2., 3., 7., 0., 4., 17., 2., 13., 25., 1., 20., 0., 1., 0., 25., 2., 3., 37., 10., 16., 33., 3., 0., 0., 5., 0., 12., 6., 24., 14., 1., 11., 6., 10., 6., 1., 1., 3., 2., 8., 13., 17., 45., 11., 34., 4., 4., 1., 9., 2., 5., 2., 6., 8., 11., 20., 6., 18., 12., 3., 0., 1., 10., 2., 2., 2., 5., 2., 5., 2., 4., 1., 3., 2., 0., 2., 2., 0., 1., 2., 5., 9., 4., 6., 4., 1., 1., 2., 3., 0., 3., 3., 3., 0., 0., 0., 2., 6., 1., 2., 3., 0., 0., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 3., 2., 8., 2., 5., 0., 5., 27., 2., 15., 22., 1., 22., 3., 0., 2., 23., 1., 5., 24., 14., 24., 29., 5., 0., 1., 3., 2., 4., 2., 25., 17., 4., 17., 3., 15., 8., 0., 1., 3., 1., 13., 4., 12., 43., 13., 25., 9., 2., 0., 7., 2., 5., 4., 11., 6., 5., 19., 9., 25., 2., 2., 0., 0., 5., 0., 8., 3., 4., 2., 8., 7., 2., 6., 4., 1., 2., 0., 3., 0., 3., 2., 2., 5., 2., 4., 0., 1., 0., 1., 3., 1., 2., 7., 2., 0., 1., 0., 0., 4., 2., 0., 1., 1., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 1., 0., 8., 5., 1., 8., 2., 6., 32., 1., 10., 24., 0., 11., 2., 1., 3., 8., 2., 5., 23., 12., 21., 26., 5., 3., 1., 1., 1., 6., 6., 21., 10., 4., 14., 2., 17., 9., 2., 1., 2., 3., 13., 5., 11., 39., 15., 25., 8., 7., 1., 1., 4., 8., 4., 10., 8., 8., 18., 10., 24., 8., 4., 2., 2., 10., 0., 1., 2., 6., 2., 2., 4., 1., 9., 4., 0., 0., 4., 3., 0., 1., 3., 3., 6., 1., 9., 2., 3., 2., 1., 2., 1., 2., 7., 5., 0., 2., 2., 0., 4., 1., 6., 4., 3., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 4., 6., 10., 3., 12., 2., 8., 19., 1., 13., 19., 1., 17., 1., 0., 0., 14., 4., 2., 15., 13., 31., 24., 4., 1., 1., 1., 3., 8., 7., 18., 20., 2., 14., 0., 17., 9., 2., 0., 3., 4., 12., 14., 17., 40., 8., 19., 5., 3., 0., 13., 3., 11., 2., 7., 4., 4., 21., 4., 28., 5., 2., 1., 1., 6., 0., 5., 5., 3., 3., 8., 5., 1., 4., 2., 2., 1., 1., 2., 0., 2., 0., 3., 5., 5., 3., 1., 3., 4., 1., 3., 0., 2., 3., 1., 0., 0., 2., 3., 4., 4., 3., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 2., 3., 6., 4., 6., 1., 0., 23., 1., 16., 17., 1., 17., 5., 4., 1., 17., 2., 2., 30., 13., 22., 32., 4., 0., 0., 4., 4., 10., 11., 19., 11., 3., 23., 8., 13., 9., 4., 3., 8., 3., 18., 17., 15., 40., 10., 17., 6., 3., 0., 5., 1., 9., 3., 7., 4., 6., 20., 7., 16., 10., 2., 1., 1., 6., 0., 1., 2., 6., 2., 3., 4., 6., 1., 6., 1., 3., 3., 1., 0., 2., 5., 2., 9., 2., 6., 1., 4., 1., 0., 1., 0., 3., 2., 0., 0., 1., 2., 3., 1., 5., 1., 4., 1., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 3., 4., 6., 5., 9., 0., 6., 27., 2., 14., 29., 1., 21., 1., 1., 2., 30., 1., 3., 20., 9., 36., 26., 5., 1., 0., 0., 0., 9., 3., 23., 18., 2., 11., 3., 11., 4., 2., 0., 4., 3., 17., 11., 22., 42., 11., 17., 7., 3., 2., 5., 6., 8., 3., 10., 7., 15., 11., 4., 21., 7., 1., 1., 0., 10., 3., 4., 1., 6., 4., 6., 3., 2., 5., 9., 2., 2., 1., 3., 0., 3., 2., 3., 1., 0., 1., 5., 1., 3., 1., 1., 1., 0., 7., 0., 0., 1., 0., 3., 0., 4., 2., 1., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 1., 12., 1., 3., 2., 5., 25., 0., 12., 18., 2., 14., 3., 1., 1., 14., 0., 3., 13., 10., 30., 33., 9., 0., 1., 5., 1., 8., 6., 19., 12., 2., 16., 2., 14., 7., 4., 0., 4., 2., 14., 5., 14., 48., 10., 25., 5., 3., 1., 7., 1., 6., 4., 15., 7., 10., 12., 5., 21., 8., 3., 0., 1., 3., 0., 2., 2., 7., 3., 5., 1., 2., 8., 6., 2., 0., 1., 0., 0., 2., 3., 2., 9., 2., 5., 2., 3., 6., 0., 3., 1., 2., 10., 1., 0., 0., 1., 2., 5., 4., 3., 2., 1., 2., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 3., 6., 2., 5., 1., 2., 34., 1., 24., 19., 0., 13., 3., 2., 1., 17., 1., 4., 20., 13., 19., 27., 5., 3., 0., 3., 4., 2., 9., 35., 13., 4., 26., 8., 16., 10., 4., 0., 4., 6., 15., 11., 17., 55., 10., 19., 8., 8., 0., 8., 2., 8., 2., 10., 4., 6., 26., 3., 16., 8., 4., 1., 1., 10., 3., 3., 3., 3., 2., 5., 4., 4., 6., 3., 1., 0., 2., 4., 0., 3., 2., 3., 7., 2., 7., 4., 1., 3., 2., 3., 1., 0., 8., 0., 0., 4., 0., 1., 2., 2., 1., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 6., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 1., 0., 10., 6., 7., 2., 11., 20., 0., 14., 27., 1., 19., 2., 0., 4., 15., 1., 5., 14., 12., 28., 27., 5., 2., 1., 6., 1., 10., 9., 27., 18., 2., 16., 2., 24., 13., 4., 2., 5., 3., 22., 19., 15., 47., 12., 18., 11., 7., 4., 3., 1., 10., 3., 10., 6., 7., 18., 4., 25., 8., 1., 3., 0., 3., 1., 6., 1., 6., 5., 6., 4., 2., 2., 0., 3., 0., 1., 6., 0., 1., 1., 3., 6., 2., 4., 2., 1., 6., 0., 3., 1., 0., 4., 2., 0., 0., 4., 2., 2., 0., 1., 3., 3., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 1., 6., 4., 2., 10., 2., 6., 26., 1., 21., 17., 1., 11., 3., 1., 1., 21., 5., 5., 20., 11., 18., 26., 6., 0., 1., 5., 0., 10., 10., 14., 21., 0., 14., 5., 18., 6., 2., 0., 7., 2., 8., 12., 19., 53., 12., 25., 8., 1., 1., 6., 1., 6., 4., 14., 8., 5., 22., 7., 23., 8., 4., 1., 0., 6., 0., 4., 1., 8., 6., 6., 3., 2., 3., 8., 1., 0., 2., 1., 0., 2., 2., 4., 8., 2., 4., 1., 5., 3., 1., 0., 0., 1., 7., 2., 0., 1., 1., 0., 2., 3., 0., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 0., 6., 7., 3., 5., 2., 3., 27., 1., 10., 20., 2., 20., 3., 2., 1., 12., 1., 7., 32., 16., 17., 28., 10., 1., 1., 2., 0., 3., 4., 26., 16., 3., 16., 6., 17., 8., 1., 1., 6., 1., 7., 8., 17., 40., 12., 22., 12., 2., 1., 3., 1., 4., 0., 12., 10., 15., 13., 5., 25., 7., 5., 2., 1., 7., 0., 4., 3., 5., 2., 5., 3., 2., 5., 1., 1., 2., 1., 3., 0., 2., 3., 2., 10., 2., 6., 1., 0., 8., 1., 3., 1., 4., 7., 2., 0., 0., 1., 0., 2., 2., 0., 4., 1., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 2., 6., 11., 4., 7., 0., 4., 22., 2., 12., 30., 1., 13., 3., 0., 1., 16., 1., 5., 26., 9., 28., 23., 3., 2., 1., 3., 0., 4., 8., 36., 17., 4., 17., 3., 14., 9., 4., 1., 3., 1., 24., 11., 23., 49., 16., 16., 14., 4., 0., 4., 1., 7., 7., 7., 4., 15., 14., 6., 25., 6., 5., 2., 0., 3., 3., 1., 1., 3., 6., 2., 1., 1., 3., 2., 3., 1., 3., 1., 0., 3., 3., 2., 3., 1., 3., 2., 2., 4., 1., 5., 0., 2., 7., 1., 0., 3., 2., 0., 0., 0., 3., 2., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 0., 4., 11., 1., 5., 3., 3., 22., 1., 13., 25., 2., 22., 1., 1., 3., 22., 0., 4., 22., 10., 25., 19., 6., 2., 0., 4., 2., 3., 8., 14., 14., 2., 9., 4., 20., 5., 2., 0., 5., 2., 15., 9., 13., 39., 9., 15., 6., 7., 0., 5., 3., 9., 3., 10., 2., 7., 18., 1., 24., 7., 2., 2., 2., 5., 1., 5., 2., 5., 4., 1., 6., 0., 5., 3., 2., 0., 1., 2., 0., 0., 2., 5., 4., 3., 3., 0., 3., 4., 0., 0., 2., 1., 6., 2., 0., 0., 0., 1., 2., 2., 5., 2., 0., 3., 0., 0., 0., 0., 4., 0., 0., 5., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 3., 5., 11., 4., 6., 1., 4., 25., 0., 9., 20., 0., 7., 1., 2., 2., 20., 3., 6., 33., 9., 17., 25., 8., 0., 2., 3., 1., 7., 5., 19., 17., 5., 18., 7., 9., 4., 0., 0., 3., 4., 8., 4., 13., 48., 20., 26., 10., 8., 1., 6., 1., 3., 3., 8., 3., 8., 11., 7., 26., 11., 0., 2., 0., 4., 0., 3., 1., 4., 4., 5., 3., 2., 2., 5., 2., 0., 1., 2., 0., 1., 1., 2., 4., 3., 6., 4., 1., 7., 1., 0., 6., 4., 7., 2., 0., 1., 3., 3., 0., 3., 1., 3., 2., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 4., 8., 1., 3., 1., 6., 37., 0., 10., 13., 0., 11., 4., 0., 1., 16., 3., 6., 27., 14., 30., 20., 9., 1., 1., 8., 2., 9., 5., 16., 13., 1., 20., 5., 15., 8., 2., 1., 2., 0., 6., 5., 19., 50., 8., 22., 10., 0., 0., 8., 2., 4., 4., 15., 6., 12., 8., 8., 18., 4., 3., 2., 1., 3., 1., 6., 2., 3., 2., 2., 4., 2., 3., 1., 2., 0., 0., 1., 0., 1., 2., 4., 5., 3., 2., 4., 3., 5., 0., 1., 1., 2., 8., 2., 0., 0., 1., 5., 2., 4., 1., 5., 1., 2., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 1., 3., 10., 0., 13., 3., 5., 47., 2., 9., 61., 0., 7., 3., 0., 2., 62., 10., 14., 79., 10., 84., 12., 7., 0., 0., 1., 2., 19., 10., 68., 18., 4., 32., 34., 11., 8., 0., 0., 5., 1., 33., 11., 22., 4., 17., 2., 3., 1., 0., 13., 10., 14., 8., 20., 4., 6., 1., 2., 44., 12., 4., 3., 0., 8., 2., 5., 2., 15., 3., 5., 0., 0., 0., 0., 4., 2., 15., 10., 4., 6., 1., 6., 0., 0., 0., 0., 0., 9., 1., 5., 2., 3., 1., 2., 0., 0., 0., 0., 0., 0., 3., 4., 0., 1., 0., 2., 0., 1., 0., 0., 0., 0., 0., 1., 1., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 30., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 4., 2., 15., 0., 10., 1., 10., 41., 0., 12., 62., 0., 3., 3., 0., 1., 66., 11., 2., 69., 15., 65., 15., 4., 0., 1., 2., 2., 7., 5., 51., 5., 3., 43., 27., 23., 7., 0., 0., 8., 3., 17., 9., 28., 3., 12., 8., 5., 3., 0., 7., 1., 20., 7., 18., 2., 9., 2., 2., 33., 8., 2., 1., 0., 18., 2., 10., 3., 15., 4., 3., 1., 2., 0., 0., 7., 3., 13., 6., 5., 5., 0., 5., 0., 0., 0., 0., 0., 11., 4., 5., 2., 5., 1., 1., 0., 1., 0., 0., 0., 1., 0., 3., 0., 4., 0., 0., 0., 1., 0., 0., 0., 1., 0., 3., 4., 3., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 13., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 1., 9., 27., 8., 21., 2., 15., 161., 3., 23., 214., 6., 12., 5., 0., 1., 81., 0., 11., 297., 45., 360., 55., 20., 0., 1., 4., 8., 40., 19., 225., 38., 10., 166., 16., 32., 7., 0., 3., 13., 9., 100., 24., 77., 12., 33., 50., 13., 0., 1., 22., 6., 31., 11., 40., 11., 30., 7., 7., 7., 5., 0., 1., 0., 24., 2., 13., 4., 26., 5., 9., 8., 3., 4., 1., 1., 4., 3., 15., 1., 9., 3., 9., 0., 0., 1., 147., 11., 1906., 97., 97., 230., 94., 112., 58., 5., 17., 18., 14., 1., 5., 5., 5., 8., 12., 8., 35., 20., 24., 8., 40., 7., 6., 4., 6., 9., 7., 3., 2., 2., 7., 4., 0., 3., 7., 13., 2., 0., 10., 3., 2., 0., 1., 0., 3., 22., 2., 15., 4., 9., 4., 20., 0., 4., 3., 2., 26., 3., 27., 1., 9., 9., 13., 30., 7., 12., 10.,

18., 1., 3., 7., 26., 6., 33., 0., 11., 151., 5., 27., 197., 2., 19., 8., 0., 5., 80., 1., 24., 289., 46., 293., 35., 24., 0., 3., 9., 12., 52., 37., 210., 44., 14., 152., 7., 41., 5., 0., 2., 18., 5., 78., 15., 85., 10., 25., 52., 8., 3., 0., 28., 7., 26., 7., 46., 13., 35., 8., 11., 7., 5., 0., 1., 0., 28., 6., 10., 2., 28., 5., 7., 4., 2., 4., 1., 2., 1., 2., 9., 6., 7., 5., 11., 1., 1., 5., 129., 8., 1907., 98., 79., 229., 95., 119., 65., 15., 14., 28., 17., 0., 4., 5., 4., 3., 13., 8., 41., 5., 34., 15., 43., 13., 12., 4., 9., 9., 5., 2., 4., 4., 10., 1., 0., 4., 7., 10., 2., 0., 11., 3., 3., 0., 4., 4., 4., 32., 1., 15., 4., 20., 1., 13., 2., 2., 4., 6., 24., 2., 23., 4., 4., 9., 7., 25., 5., 9., 2.,

11., 2., 5., 7., 27., 6., 39., 0., 17., 133., 2., 26., 184., 6., 18., 14., 1., 6., 89., 0., 16., 298., 36., 327., 51., 24., 0., 1., 10., 7., 35., 27., 246., 52., 4., 168., 13., 29., 6., 0., 2., 21., 8., 72., 17., 95., 20., 28., 42., 8., 2., 0., 26., 10., 41., 8., 47., 7., 20., 4., 7., 10., 2., 0., 0., 0., 27., 4., 16., 2., 19., 2., 10., 5., 0., 1., 1., 0., 3., 2., 15., 4., 6., 2., 2., 2., 1., 5., 147., 12., 1820., 88., 110., 228., 85., 95., 70., 10., 16., 16., 18., 1., 1., 3., 2., 3., 12., 4., 37., 13., 41., 13., 54., 6., 7., 5., 7., 8., 8., 2., 6., 3., 5., 4., 0., 7., 7., 21., 1., 0., 11., 3., 2., 0., 3., 3., 1., 37., 1., 16., 4., 8., 5., 30., 4., 1., 4., 4., 22., 3., 30., 4., 6., 5., 5., 26., 6., 12., 4.,

13., 1., 5., 8., 21., 6., 19., 1., 22., 168., 6., 24., 194., 5., 16., 4., 0., 4., 77., 6., 13., 280., 52., 324., 50., 22., 1., 1., 5., 2., 45., 33., 234., 43., 4., 142., 11., 39., 9., 0., 5., 18., 8., 78., 26., 114., 15., 40., 53., 10., 1., 1., 30., 10., 50., 10., 57., 9., 28., 5., 6., 8., 2., 0., 0., 0., 22., 6., 17., 3., 31., 4., 10., 1., 0., 5., 0., 0., 3., 1., 10., 2., 13., 8., 7., 0., 0., 3., 159., 7., 1850., 94., 107., 205., 93., 123., 69., 18., 16., 18., 14., 0., 0., 10., 1., 1., 6., 8., 30., 19., 28., 21., 37., 3., 12., 7., 1., 6., 5., 0., 0., 3., 12., 2., 0., 6., 5., 18., 2., 0., 9., 3., 3., 0., 6., 0., 4., 31., 1., 19., 4., 5., 4., 30., 3., 4., 2., 8., 24., 3., 25., 6., 1., 9., 11., 40., 5., 12., 4.,

18., 0., 2., 9., 15., 4., 32., 0., 20., 153., 2., 23., 222., 6., 17., 10., 2., 6., 88., 2., 18., 273., 42., 315., 55., 16., 2., 4., 6., 3., 55., 28., 233., 57., 5., 137., 25., 25., 9., 0., 3., 11., 3., 77., 24., 101., 15., 29., 32., 8., 0., 1., 25., 6., 35., 7., 32., 8., 27., 5., 14., 3., 2., 0., 5., 0., 22., 5., 13., 4., 26., 6., 14., 1., 0., 5., 0., 1., 3., 2., 13., 3., 9., 2., 8., 0., 2., 1., 119., 12., 1859., 98., 121., 235., 92., 111., 77., 17., 11., 26., 7., 0., 1., 2., 6., 7., 4., 9., 42., 11., 45., 10., 38., 7., 9., 8., 2., 7., 5., 2., 4., 4., 8., 4., 0., 5., 3., 17., 1., 0., 8., 1., 2., 0., 0., 1., 5., 26., 2., 11., 1., 12., 3., 19., 2., 8., 3., 4., 21., 7., 42., 6., 5., 2., 4., 31., 9., 15., 5.,

12., 4., 0., 5., 30., 2., 40., 2., 17., 172., 2., 24., 190., 2., 11., 6., 0., 4., 75., 3., 22., 320., 35., 384., 45., 25., 0., 3., 11., 3., 39., 30., 238., 53., 5., 174., 15., 35., 4., 0., 2., 9., 10., 88., 18., 89., 13., 33., 45., 11., 4., 3., 30., 5., 38., 9., 39., 8., 28., 4., 9., 10., 2., 0., 0., 0., 25., 4., 16., 3., 38., 6., 12., 6., 1., 2., 0., 1., 2., 2., 13., 5., 8., 1., 8., 1., 1., 5., 163., 5., 1961., 80., 116., 237., 111., 99., 71., 12., 19., 20., 16., 1., 3., 8., 5., 7., 7., 10., 36., 12., 36., 16., 44., 5., 10., 3., 3., 12., 4., 2., 4., 2., 8., 4., 0., 3., 8., 15., 2., 0., 8., 4., 5., 0., 4., 2., 5., 35., 2., 13., 4., 8., 2., 28., 1., 3., 6., 4., 28., 3., 28., 4., 6., 10., 4., 28., 9., 10., 4.,

11., 2., 4., 14., 35., 4., 29., 2., 14., 167., 2., 26., 201., 7., 14., 6., 2., 8., 81., 1., 15., 300., 43., 326., 51., 19., 1., 0., 6., 5., 48., 34., 232., 41., 5., 165., 8., 30., 4., 0., 2., 16., 12., 65., 12., 82., 16., 38., 45., 12., 2., 2., 29., 7., 45., 3., 42., 9., 31., 8., 13., 6., 2., 0., 3., 0., 20., 11., 20., 1., 30., 4., 17., 2., 1., 3., 1., 1., 4., 2., 10., 2., 7., 2., 4., 0., 1., 1., 143., 12., 1932., 79., 96., 232., 105., 113., 74., 17., 13., 12., 11., 1., 3., 3., 4., 4., 6., 9., 33., 16., 30., 21., 36., 4., 12., 7., 5., 8., 13., 1., 4., 4., 9., 3., 0., 2., 6., 20., 0., 0., 7., 2., 3., 0., 3., 5., 2., 28., 3., 11., 2., 11., 1., 19., 8., 5., 3., 3., 27., 7., 31., 10., 7., 7., 5., 38., 3., 7., 5.,

8., 3., 6., 2., 4., 0., 4., 2., 7., 24., 1., 13., 17., 1., 18., 1., 2., 5., 20., 0., 6., 12., 19., 26., 27., 4., 1., 0., 2., 4., 12., 13., 33., 19., 1., 15., 2., 14., 9., 2., 0., 6., 5., 13., 10., 14., 50., 16., 21., 9., 5., 3., 3., 5., 8., 2., 11., 6., 6., 20., 6., 22., 9., 0., 1., 1., 10., 3., 3., 1., 7., 1., 4., 3., 1., 5., 6., 3., 2., 3., 2., 0., 3., 1., 3., 5., 1., 7., 3., 1., 2., 3., 1., 1., 3., 8., 0., 0., 1., 5., 0., 2., 1., 3., 1., 0., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 0., 2., 5., 7., 4., 0., 5., 15., 1., 15., 17., 0., 19., 2., 0., 4., 14., 3., 4., 27., 14., 28., 32., 5., 1., 1., 3., 3., 11., 4., 17., 18., 6., 18., 5., 16., 4., 2., 2., 2., 1., 13., 15., 17., 45., 13., 23., 5., 3., 3., 3., 3., 11., 5., 11., 3., 8., 15., 5., 24., 5., 4., 0., 0., 6., 1., 1., 1., 2., 4., 6., 1., 0., 3., 5., 4., 1., 3., 2., 0., 2., 2., 1., 5., 4., 3., 3., 3., 4., 1., 2., 1., 2., 8., 1., 0., 0., 0., 1., 2., 1., 2., 4., 3., 1., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 2., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 7., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 3., 7., 6., 5., 2., 0., 6., 17., 0., 22., 25., 0., 16., 2., 0., 1., 15., 1., 5., 35., 9., 15., 20., 8., 1., 0., 0., 1., 6., 8., 24., 19., 3., 21., 3., 19., 8., 2., 0., 10., 3., 13., 12., 16., 50., 13., 22., 7., 4., 3., 2., 3., 6., 2., 7., 2., 5., 13., 6., 15., 6., 1., 2., 0., 7., 0., 3., 1., 7., 2., 2., 9., 3., 2., 3., 1., 1., 3., 1., 0., 5., 1., 3., 8., 1., 1., 4., 1., 7., 1., 5., 2., 0., 8., 3., 0., 0., 2., 5., 1., 4., 1., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 1., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 2., 2., 2., 4., 5., 2., 2., 3., 16., 0., 15., 23., 2., 19., 3., 1., 2., 23., 1., 2., 17., 18., 17., 21., 6., 0., 1., 1., 2., 2., 3., 36., 16., 4., 15., 7., 7., 12., 3., 0., 4., 3., 12., 13., 23., 45., 20., 22., 6., 3., 3., 6., 3., 3., 1., 11., 5., 5., 17., 8., 21., 11., 0., 1., 1., 3., 0., 3., 2., 4., 1., 3., 0., 3., 7., 2., 1., 0., 3., 0., 0., 6., 0., 1., 3., 0., 2., 1., 0., 4., 1., 0., 1., 2., 7., 1., 0., 2., 2., 3., 6., 2., 3., 1., 1., 3., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 2., 2., 8., 5., 10., 1., 7., 24., 0., 5., 23., 3., 11., 5., 0., 1., 22., 1., 4., 31., 10., 22., 27., 4., 0., 3., 1., 2., 9., 1., 28., 16., 2., 8., 4., 19., 9., 1., 1., 2., 3., 14., 12., 15., 57., 9., 16., 5., 6., 0., 4., 1., 8., 2., 14., 3., 9., 25., 5., 24., 5., 6., 4., 0., 5., 0., 5., 0., 7., 1., 6., 5., 1., 6., 3., 3., 3., 1., 2., 0., 1., 0., 4., 6., 2., 3., 1., 1., 1., 0., 0., 0., 4., 6., 3., 0., 4., 4., 2., 3., 4., 1., 3., 3., 5., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

16., 1., 3., 7., 4., 7., 2., 2., 7., 21., 1., 16., 30., 2., 14., 1., 1., 1., 14., 3., 4., 27., 5., 20., 30., 9., 0., 1., 3., 0., 12., 7., 25., 20., 5., 15., 5., 11., 12., 2., 0., 8., 2., 9., 11., 12., 44., 7., 25., 4., 5., 1., 11., 1., 4., 6., 9., 7., 11., 17., 9., 20., 7., 2., 1., 0., 10., 2., 1., 2., 7., 4., 4., 5., 3., 5., 2., 0., 0., 3., 2., 0., 2., 1., 2., 5., 0., 4., 2., 2., 3., 0., 2., 1., 0., 8., 1., 0., 2., 1., 2., 3., 1., 0., 0., 1., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 2., 3., 11., 0., 5., 0., 6., 31., 0., 14., 19., 0., 15., 2., 0., 3., 27., 3., 5., 40., 9., 31., 27., 3., 1., 0., 1., 1., 4., 7., 19., 10., 3., 17., 3., 20., 11., 4., 0., 5., 2., 7., 13., 15., 45., 8., 10., 5., 5., 0., 5., 3., 5., 4., 7., 3., 9., 15., 5., 21., 6., 1., 1., 1., 6., 0., 2., 3., 8., 2., 5., 7., 2., 7., 3., 4., 1., 2., 6., 0., 4., 3., 2., 8., 1., 4., 1., 0., 4., 0., 2., 0., 3., 10., 4., 0., 2., 4., 1., 1., 2., 0., 4., 0., 1., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 3., 5., 13., 1., 6., 3., 6., 19., 2., 12., 14., 2., 18., 2., 0., 5., 13., 3., 3., 30., 19., 34., 29., 7., 1., 0., 3., 2., 5., 0., 21., 18., 5., 15., 6., 10., 9., 3., 0., 2., 5., 15., 8., 17., 49., 9., 20., 2., 2., 0., 6., 1., 5., 0., 10., 6., 5., 16., 3., 18., 13., 1., 1., 2., 10., 2., 3., 0., 3., 3., 1., 3., 0., 3., 7., 3., 0., 0., 1., 0., 0., 2., 0., 2., 2., 6., 4., 2., 4., 0., 2., 0., 2., 12., 5., 0., 1., 4., 3., 1., 5., 4., 0., 1., 2., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 2., 4., 13., 1., 3., 1., 3., 16., 0., 14., 15., 0., 17., 2., 1., 4., 32., 2., 2., 33., 24., 14., 20., 3., 0., 3., 8., 3., 11., 5., 20., 21., 1., 11., 5., 6., 10., 2., 0., 8., 2., 10., 19., 14., 37., 12., 23., 10., 4., 1., 8., 1., 2., 4., 17., 11., 10., 14., 7., 29., 12., 4., 0., 1., 13., 0., 7., 2., 4., 3., 7., 3., 3., 5., 2., 1., 0., 2., 1., 0., 1., 3., 1., 9., 4., 1., 2., 4., 5., 1., 7., 1., 2., 8., 1., 0., 2., 1., 1., 1., 2., 1., 1., 1., 0., 0., 0., 0., 0., 3., 0., 0., 5., 0., 0., 0., 4., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 1., 4., 10., 3., 0., 2., 8., 22., 0., 13., 20., 0., 11., 4., 1., 3., 17., 1., 4., 26., 15., 23., 26., 9., 1., 0., 2., 3., 9., 6., 23., 30., 4., 14., 8., 13., 5., 1., 3., 4., 1., 12., 18., 18., 46., 12., 24., 5., 2., 1., 5., 3., 10., 1., 8., 7., 13., 17., 7., 24., 6., 3., 2., 1., 8., 1., 1., 2., 4., 3., 4., 3., 1., 1., 3., 1., 1., 5., 1., 0., 6., 2., 2., 4., 4., 6., 2., 1., 2., 0., 2., 0., 0., 9., 1., 0., 0., 0., 2., 2., 4., 2., 4., 0., 0., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 3., 3., 9., 4., 10., 1., 5., 21., 1., 13., 29., 1., 13., 2., 2., 4., 30., 2., 5., 18., 10., 25., 27., 3., 3., 1., 3., 4., 6., 5., 30., 13., 4., 14., 3., 13., 6., 1., 1., 2., 2., 13., 11., 11., 44., 11., 24., 10., 6., 1., 3., 2., 10., 2., 7., 6., 8., 14., 2., 29., 8., 2., 0., 1., 4., 1., 1., 3., 4., 3., 2., 4., 1., 3., 4., 0., 1., 4., 0., 0., 3., 6., 5., 4., 1., 4., 1., 0., 2., 0., 2., 0., 4., 9., 5., 0., 0., 1., 3., 0., 2., 1., 3., 1., 4., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 3., 5., 8., 3., 3., 1., 9., 22., 0., 17., 18., 1., 21., 1., 1., 0., 16., 4., 5., 18., 14., 19., 26., 6., 2., 1., 2., 1., 4., 8., 39., 11., 4., 10., 1., 18., 6., 2., 2., 4., 3., 11., 12., 21., 50., 7., 22., 15., 1., 0., 4., 1., 1., 4., 9., 4., 8., 18., 4., 27., 6., 4., 0., 0., 5., 2., 3., 1., 4., 4., 1., 5., 0., 3., 7., 3., 2., 4., 4., 0., 2., 1., 2., 7., 4., 2., 2., 3., 4., 1., 5., 2., 2., 4., 4., 0., 2., 0., 2., 1., 0., 2., 5., 2., 0., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 1., 5., 5., 5., 8., 0., 7., 28., 1., 15., 29., 1., 20., 3., 0., 1., 17., 2., 4., 26., 7., 19., 22., 13., 1., 3., 0., 2., 5., 7., 25., 23., 2., 20., 7., 13., 11., 2., 0., 6., 1., 9., 14., 21., 38., 6., 21., 7., 6., 0., 0., 1., 7., 2., 18., 1., 5., 13., 9., 25., 12., 1., 0., 1., 6., 2., 5., 1., 2., 3., 3., 4., 3., 4., 1., 1., 2., 1., 2., 0., 1., 2., 4., 3., 2., 2., 2., 2., 5., 0., 3., 1., 1., 8., 0., 0., 2., 2., 1., 4., 4., 1., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 3., 5., 11., 5., 7., 0., 4., 27., 1., 15., 25., 0., 10., 5., 3., 1., 30., 1., 2., 17., 19., 34., 41., 9., 3., 5., 1., 3., 9., 7., 18., 17., 0., 11., 6., 18., 5., 0., 0., 1., 2., 11., 11., 14., 40., 15., 17., 8., 7., 0., 2., 1., 12., 6., 7., 3., 8., 17., 6., 23., 9., 4., 1., 1., 7., 1., 4., 4., 7., 3., 4., 3., 3., 4., 4., 1., 1., 1., 2., 0., 2., 3., 1., 8., 6., 3., 2., 1., 5., 1., 2., 2., 2., 6., 3., 0., 1., 1., 2., 3., 5., 3., 0., 0., 3., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 1., 7., 5., 4., 0., 5., 21., 4., 16., 29., 0., 22., 4., 1., 5., 10., 3., 4., 23., 6., 29., 23., 6., 0., 2., 4., 4., 12., 8., 28., 17., 3., 16., 3., 17., 2., 3., 3., 1., 4., 11., 12., 23., 42., 8., 22., 14., 5., 0., 4., 2., 11., 3., 7., 4., 13., 21., 6., 22., 10., 2., 0., 0., 8., 1., 1., 3., 6., 4., 3., 3., 1., 2., 4., 3., 0., 1., 2., 0., 2., 1., 2., 6., 3., 8., 0., 3., 7., 0., 2., 1., 1., 6., 1., 0., 1., 2., 0., 2., 2., 1., 1., 2., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 2., 4., 7., 4., 2., 0., 10., 11., 0., 14., 30., 1., 24., 3., 1., 5., 21., 1., 6., 17., 15., 18., 41., 5., 1., 1., 3., 2., 8., 4., 33., 20., 7., 13., 1., 13., 7., 5., 2., 3., 4., 14., 18., 16., 41., 16., 20., 11., 1., 0., 0., 2., 5., 5., 11., 3., 8., 16., 7., 34., 6., 4., 1., 0., 8., 3., 1., 2., 6., 3., 4., 2., 2., 2., 2., 0., 1., 3., 1., 0., 0., 4., 1., 3., 5., 0., 4., 1., 3., 1., 2., 1., 3., 6., 3., 0., 0., 1., 3., 5., 2., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 0., 6., 5., 4., 3., 2., 9., 30., 0., 17., 28., 0., 9., 6., 1., 2., 15., 2., 7., 30., 14., 32., 21., 3., 0., 0., 3., 1., 4., 8., 24., 15., 3., 14., 3., 7., 6., 2., 0., 3., 3., 15., 6., 16., 46., 11., 21., 11., 0., 1., 3., 1., 4., 2., 4., 3., 8., 14., 7., 21., 8., 3., 1., 5., 7., 1., 2., 1., 5., 6., 3., 1., 0., 6., 1., 2., 2., 4., 2., 0., 1., 2., 1., 6., 1., 5., 1., 1., 7., 3., 3., 1., 1., 10., 2., 0., 3., 4., 3., 1., 6., 0., 1., 2., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 6., 3., 6., 3., 4., 1., 9., 17., 1., 14., 15., 0., 14., 4., 0., 1., 9., 0., 3., 28., 10., 28., 24., 6., 1., 1., 5., 2., 9., 7., 21., 12., 3., 17., 3., 12., 7., 1., 0., 6., 0., 8., 2., 15., 52., 8., 25., 10., 4., 0., 4., 3., 8., 2., 15., 4., 9., 17., 7., 20., 14., 3., 2., 1., 9., 1., 5., 2., 6., 2., 1., 9., 3., 2., 5., 1., 3., 2., 1., 0., 1., 1., 6., 7., 3., 4., 2., 2., 2., 1., 2., 1., 4., 2., 2., 0., 3., 3., 2., 1., 0., 4., 2., 1., 2., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 6., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 2., 9., 3., 5., 0., 3., 18., 1., 15., 27., 3., 18., 6., 0., 2., 27., 2., 5., 30., 13., 25., 35., 4., 0., 2., 2., 2., 9., 6., 23., 23., 2., 7., 4., 10., 11., 2., 0., 3., 2., 16., 12., 10., 48., 9., 24., 7., 3., 1., 4., 1., 8., 1., 9., 6., 6., 18., 3., 15., 6., 3., 0., 0., 12., 0., 5., 4., 9., 1., 4., 4., 3., 5., 3., 0., 1., 7., 1., 0., 0., 0., 3., 7., 2., 5., 2., 0., 2., 1., 3., 0., 4., 5., 1., 0., 1., 6., 3., 1., 1., 2., 2., 1., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 0., 2., 9., 2., 4., 1., 5., 20., 0., 13., 13., 3., 15., 2., 0., 2., 21., 2., 4., 27., 17., 29., 15., 3., 1., 2., 0., 5., 7., 11., 23., 19., 0., 9., 5., 20., 10., 2., 2., 6., 2., 10., 15., 18., 36., 10., 15., 10., 3., 2., 4., 2., 12., 3., 11., 5., 8., 7., 11., 17., 5., 0., 0., 1., 5., 0., 4., 6., 3., 6., 6., 4., 0., 1., 2., 2., 0., 2., 4., 0., 0., 4., 2., 11., 0., 3., 3., 3., 6., 0., 4., 2., 2., 4., 0., 0., 1., 1., 0., 0., 0., 4., 1., 2., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 4., 12., 2., 6., 0., 9., 14., 1., 9., 13., 1., 16., 6., 2., 1., 10., 0., 4., 23., 10., 29., 28., 4., 1., 1., 4., 2., 6., 3., 25., 20., 3., 11., 1., 8., 6., 1., 0., 0., 0., 10., 11., 20., 45., 15., 21., 7., 7., 1., 4., 4., 4., 5., 3., 6., 6., 13., 3., 16., 5., 4., 1., 1., 10., 1., 3., 2., 6., 4., 3., 7., 3., 2., 2., 4., 0., 4., 4., 0., 1., 2., 2., 10., 1., 4., 1., 2., 5., 1., 3., 1., 4., 6., 0., 0., 2., 2., 5., 1., 3., 3., 4., 3., 0., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 3., 2., 6., 5., 8., 1., 7., 28., 2., 12., 21., 0., 13., 0., 0., 3., 35., 4., 4., 41., 8., 23., 22., 6., 0., 0., 0., 1., 6., 2., 28., 12., 1., 11., 7., 13., 5., 2., 1., 5., 2., 11., 10., 14., 35., 12., 14., 13., 6., 1., 8., 0., 15., 2., 8., 9., 8., 18., 4., 16., 6., 4., 0., 1., 5., 1., 3., 0., 2., 3., 6., 4., 2., 6., 3., 2., 2., 2., 2., 0., 3., 3., 1., 4., 0., 3., 3., 2., 4., 1., 2., 1., 1., 7., 1., 0., 0., 1., 1., 1., 3., 6., 2., 0., 3., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 2., 3., 6., 0., 14., 2., 6., 45., 0., 7., 61., 0., 4., 1., 0., 4., 77., 10., 4., 67., 12., 70., 13., 6., 0., 1., 4., 2., 14., 9., 41., 11., 4., 43., 32., 15., 7., 0., 1., 9., 3., 24., 0., 26., 6., 12., 5., 5., 0., 0., 8., 8., 16., 6., 9., 0., 12., 5., 1., 33., 7., 6., 3., 0., 12., 3., 8., 3., 10., 0., 3., 0., 3., 3., 0., 2., 5., 18., 10., 1., 2., 1., 6., 0., 0., 0., 0., 0., 16., 1., 0., 0., 4., 0., 1., 0., 3., 0., 0., 0., 0., 2., 0., 0., 5., 0., 1., 0., 1., 0., 0., 0., 3., 0., 0., 3., 2., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 14., 0., 1., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 2., 13., 0., 13., 2., 8., 59., 3., 9., 59., 1., 3., 4., 0., 4., 71., 10., 9., 88., 18., 90., 11., 7., 0., 0., 4., 2., 11., 10., 55., 11., 1., 36., 27., 13., 6., 0., 1., 7., 4., 16., 3., 27., 12., 12., 12., 1., 3., 0., 8., 6., 14., 9., 18., 2., 5., 3., 5., 38., 4., 7., 1., 0., 16., 7., 6., 1., 13., 2., 2., 1., 1., 0., 0., 7., 1., 14., 7., 4., 4., 0., 2., 0., 0., 0., 0., 0., 9., 0., 1., 1., 4., 1., 0., 0., 1., 0., 1., 0., 0., 5., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 0., 2., 2., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 22., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 5., 5., 14., 0., 9., 1., 10., 54., 2., 9., 55., 1., 5., 1., 0., 3., 87., 6., 7., 77., 12., 89., 10., 3., 0., 0., 3., 2., 14., 7., 44., 11., 2., 34., 41., 10., 2., 0., 2., 0., 3., 18., 6., 21., 8., 13., 11., 0., 1., 0., 7., 6., 20., 4., 16., 7., 5., 4., 4., 41., 9., 4., 1., 0., 15., 4., 7., 1., 10., 2., 2., 1., 0., 2., 0., 1., 1., 28., 9., 2., 4., 1., 3., 0., 0., 0., 0., 0., 6., 3., 1., 4., 2., 0., 0., 0., 0., 0., 0., 0., 1., 6., 2., 0., 2., 0., 0., 0., 2., 0., 0., 0., 2., 0., 2., 2., 3., 0., 0., 0., 2., 0., 6., 0., 0., 0., 0., 28., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 3., 3., 8., 24., 5., 25., 1., 12., 151., 4., 29., 203., 1., 20., 4., 0., 4., 74., 3., 9., 277., 32., 340., 36., 18., 0., 4., 7., 2., 38., 34., 224., 29., 8., 159., 10., 31., 7., 0., 0., 22., 15., 95., 15., 84., 20., 35., 53., 11., 3., 1., 27., 9., 33., 8., 41., 12., 33., 4., 5., 7., 3., 0., 1., 0., 21., 6., 16., 2., 33., 5., 16., 5., 1., 3., 0., 0., 3., 0., 15., 5., 8., 2., 7., 0., 2., 5., 124., 8., 1829., 98., 91., 219., 95., 96., 73., 16., 10., 21., 6., 0., 1., 7., 6., 4., 6., 9., 29., 12., 30., 23., 41., 8., 13., 2., 4., 7., 6., 3., 6., 6., 12., 3., 0., 2., 7., 22., 4., 0., 8., 8., 4., 0., 5., 1., 1., 29., 2., 15., 3., 16., 4., 19., 3., 2., 8., 2., 28., 2., 24., 1., 8., 7., 3., 26., 5., 15., 5.,

14., 1., 3., 6., 30., 9., 31., 5., 9., 153., 2., 31., 201., 9., 15., 9., 1., 3., 93., 5., 13., 266., 46., 355., 54., 16., 1., 1., 8., 2., 44., 24., 211., 51., 4., 148., 16., 40., 3., 0., 2., 23., 5., 83., 25., 87., 14., 40., 39., 14., 2., 1., 30., 6., 46., 8., 43., 4., 33., 8., 10., 2., 2., 0., 1., 0., 26., 0., 13., 0., 25., 3., 7., 2., 2., 3., 0., 0., 2., 3., 12., 0., 10., 3., 6., 1., 3., 3., 130., 6., 1837., 79., 105., 224., 76., 96., 68., 14., 6., 17., 13., 1., 1., 5., 7., 3., 10., 8., 27., 18., 26., 14., 43., 2., 6., 4., 7., 4., 9., 2., 4., 1., 11., 1., 0., 5., 9., 16., 1., 0., 8., 6., 5., 0., 0., 1., 4., 32., 0., 18., 1., 12., 3., 17., 5., 8., 3., 4., 30., 2., 29., 5., 2., 6., 6., 34., 12., 18., 9.,

13., 2., 2., 4., 27., 4., 38., 3., 23., 158., 4., 30., 238., 3., 15., 9., 1., 6., 88., 2., 20., 294., 54., 315., 54., 20., 1., 5., 12., 10., 38., 35., 254., 35., 7., 151., 13., 33., 4., 0., 1., 19., 8., 84., 15., 91., 14., 56., 44., 12., 1., 2., 23., 10., 40., 8., 47., 12., 38., 5., 8., 7., 3., 0., 0., 0., 24., 6., 10., 3., 29., 7., 10., 2., 3., 4., 3., 3., 3., 0., 13., 4., 10., 1., 4., 1., 1., 6., 165., 8., 1904., 94., 81., 234., 89., 119., 71., 19., 13., 22., 8., 2., 3., 5., 5., 3., 12., 9., 38., 16., 35., 17., 47., 7., 8., 5., 11., 13., 5., 0., 3., 2., 9., 5., 0., 10., 7., 14., 3., 0., 4., 5., 4., 0., 2., 1., 1., 35., 5., 12., 4., 11., 5., 24., 9., 7., 5., 5., 22., 3., 25., 9., 4., 5., 6., 28., 7., 9., 8.,

14., 1., 2., 5., 20., 6., 26., 2., 12., 163., 1., 28., 217., 3., 17., 5., 1., 2., 84., 1., 23., 295., 34., 322., 39., 20., 2., 1., 8., 7., 39., 35., 217., 46., 8., 158., 12., 42., 2., 0., 0., 15., 5., 86., 18., 100., 15., 32., 46., 5., 4., 0., 26., 8., 41., 9., 38., 16., 26., 3., 17., 6., 2., 0., 1., 0., 24., 4., 16., 1., 31., 4., 6., 6., 2., 3., 3., 0., 1., 3., 16., 2., 6., 3., 10., 2., 2., 5., 161., 9., 1827., 92., 99., 195., 92., 121., 72., 16., 13., 15., 11., 1., 2., 4., 8., 4., 8., 4., 33., 22., 39., 13., 39., 5., 5., 2., 2., 2., 4., 6., 3., 5., 12., 7., 0., 4., 6., 13., 2., 0., 14., 9., 3., 0., 7., 3., 0., 21., 1., 6., 4., 6., 0., 27., 2., 1., 8., 2., 23., 9., 23., 5., 2., 6., 7., 35., 7., 14., 5.,

13., 0., 1., 4., 16., 6., 23., 1., 13., 149., 2., 24., 202., 5., 20., 13., 1., 8., 67., 0., 13., 305., 42., 329., 46., 24., 0., 2., 11., 4., 32., 36., 247., 40., 3., 154., 17., 38., 9., 0., 1., 17., 4., 86., 31., 78., 12., 26., 35., 15., 4., 5., 21., 3., 43., 12., 35., 12., 29., 7., 12., 5., 1., 0., 1., 0., 23., 5., 14., 2., 30., 5., 10., 2., 0., 2., 2., 3., 0., 3., 20., 4., 6., 2., 13., 0., 0., 5., 144., 5., 1852., 94., 86., 226., 92., 106., 74., 16., 14., 10., 15., 1., 0., 5., 10., 6., 10., 12., 31., 17., 26., 12., 45., 8., 11., 3., 10., 5., 7., 1., 6., 2., 6., 1., 0., 3., 4., 14., 0., 0., 9., 5., 3., 0., 3., 1., 3., 29., 5., 9., 3., 17., 3., 15., 5., 3., 4., 6., 22., 2., 46., 3., 9., 2., 3., 21., 5., 11., 2.,

10., 2., 5., 9., 27., 3., 27., 1., 19., 168., 3., 27., 199., 5., 13., 9., 0., 4., 80., 1., 15., 312., 39., 301., 44., 18., 0., 1., 7., 4., 45., 27., 211., 40., 8., 164., 9., 50., 5., 0., 3., 9., 9., 90., 17., 84., 13., 37., 46., 14., 4., 0., 22., 10., 38., 8., 55., 9., 27., 7., 6., 7., 1., 0., 0., 0., 27., 4., 21., 1., 38., 5., 7., 4., 2., 3., 0., 1., 4., 3., 10., 2., 8., 4., 10., 2., 2., 3., 143., 7., 1825., 99., 103., 229., 82., 118., 70., 19., 14., 18., 14., 1., 2., 13., 6., 6., 10., 4., 44., 10., 32., 27., 52., 5., 11., 6., 5., 8., 2., 0., 2., 4., 9., 3., 0., 3., 9., 15., 3., 0., 4., 6., 5., 0., 7., 6., 2., 41., 1., 8., 7., 14., 3., 25., 4., 4., 2., 5., 28., 4., 40., 2., 8., 7., 6., 37., 15., 17., 4.,

17., 2., 2., 11., 25., 7., 40., 0., 21., 175., 5., 26., 188., 2., 19., 6., 0., 5., 76., 5., 17., 286., 48., 325., 33., 18., 0., 0., 4., 7., 51., 33., 215., 35., 5., 134., 3., 29., 5., 0., 4., 22., 7., 67., 20., 75., 9., 35., 32., 15., 2., 3., 24., 7., 36., 16., 57., 6., 25., 3., 8., 9., 1., 0., 1., 0., 18., 6., 14., 0., 39., 0., 9., 1., 3., 2., 1., 1., 3., 2., 9., 4., 9., 2., 6., 1., 1., 5., 146., 6., 1906., 102., 88., 238., 103., 131., 69., 16., 8., 15., 10., 1., 4., 11., 7., 2., 8., 6., 30., 19., 33., 14., 40., 7., 10., 2., 3., 5., 5., 1., 1., 0., 9., 5., 0., 3., 6., 15., 3., 0., 8., 6., 0., 0., 7., 3., 0., 35., 0., 8., 1., 10., 6., 14., 2., 3., 2., 4., 28., 3., 31., 11., 4., 8., 4., 39., 7., 14., 5.,

6., 1., 1., 3., 5., 2., 13., 2., 1., 18., 1., 16., 24., 3., 12., 5., 3., 3., 7., 5., 1., 22., 13., 27., 28., 4., 0., 0., 2., 0., 7., 6., 21., 15., 3., 13., 5., 9., 10., 2., 1., 4., 1., 18., 10., 14., 38., 14., 27., 7., 2., 0., 2., 3., 9., 4., 7., 3., 14., 15., 8., 22., 12., 3., 0., 3., 4., 1., 3., 3., 4., 2., 4., 3., 1., 4., 2., 0., 0., 1., 5., 0., 1., 0., 2., 6., 3., 7., 3., 2., 6., 0., 1., 0., 2., 9., 2., 0., 1., 0., 3., 3., 1., 2., 2., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 1., 4., 9., 4., 6., 0., 8., 19., 1., 15., 31., 0., 17., 2., 1., 1., 24., 0., 6., 25., 13., 29., 31., 5., 1., 2., 1., 5., 8., 13., 35., 20., 2., 8., 1., 16., 9., 2., 0., 1., 1., 14., 8., 11., 34., 16., 19., 6., 4., 6., 5., 3., 8., 3., 8., 6., 7., 18., 7., 29., 10., 2., 1., 2., 5., 0., 1., 0., 3., 3., 6., 1., 1., 4., 2., 2., 0., 1., 1., 0., 3., 3., 3., 12., 0., 6., 1., 1., 6., 1., 2., 2., 2., 6., 1., 0., 1., 3., 0., 5., 4., 4., 1., 1., 4., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 1., 7., 5., 6., 1., 8., 14., 0., 15., 12., 3., 18., 2., 1., 1., 26., 3., 3., 28., 11., 12., 25., 4., 0., 2., 3., 1., 11., 8., 26., 13., 3., 16., 6., 18., 7., 1., 0., 1., 3., 14., 18., 22., 44., 14., 17., 10., 5., 0., 6., 0., 6., 2., 14., 3., 9., 17., 9., 31., 7., 4., 0., 1., 10., 1., 2., 4., 4., 3., 2., 2., 5., 3., 2., 0., 2., 2., 2., 0., 0., 4., 0., 6., 3., 2., 2., 1., 5., 0., 2., 1., 1., 11., 2., 0., 0., 1., 3., 1., 1., 3., 1., 1., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 3., 2., 3., 6., 3., 4., 1., 7., 27., 1., 11., 25., 0., 17., 5., 1., 2., 19., 2., 3., 13., 16., 19., 31., 10., 1., 2., 3., 2., 9., 11., 34., 25., 7., 20., 3., 10., 4., 5., 0., 2., 3., 10., 10., 21., 31., 14., 26., 7., 5., 1., 3., 1., 6., 6., 17., 6., 7., 14., 5., 20., 10., 3., 0., 3., 7., 1., 2., 2., 4., 6., 0., 3., 3., 7., 2., 4., 2., 3., 2., 0., 3., 1., 2., 5., 1., 3., 2., 4., 2., 0., 2., 0., 3., 5., 1., 0., 5., 6., 0., 1., 3., 3., 3., 0., 6., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 2., 3., 9., 1., 4., 0., 6., 19., 0., 11., 23., 2., 17., 4., 1., 4., 6., 2., 4., 31., 13., 22., 21., 8., 2., 2., 3., 5., 7., 6., 28., 10., 4., 18., 5., 19., 12., 2., 0., 4., 1., 15., 8., 14., 40., 14., 17., 8., 4., 3., 4., 1., 6., 1., 8., 3., 6., 15., 6., 19., 10., 4., 2., 0., 6., 1., 2., 2., 3., 5., 3., 7., 2., 6., 0., 4., 1., 5., 3., 0., 0., 4., 0., 8., 2., 5., 2., 1., 0., 0., 0., 1., 1., 5., 3., 0., 1., 0., 1., 1., 1., 3., 3., 1., 0., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 4., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 1., 4., 5., 4., 7., 2., 5., 26., 1., 12., 22., 0., 12., 0., 0., 0., 12., 0., 7., 11., 5., 22., 28., 4., 0., 0., 5., 2., 8., 8., 37., 12., 2., 11., 7., 9., 7., 5., 2., 5., 0., 13., 8., 17., 48., 14., 28., 7., 3., 1., 5., 3., 9., 4., 3., 11., 7., 12., 7., 28., 13., 1., 1., 1., 6., 0., 4., 2., 6., 4., 5., 5., 0., 2., 2., 1., 2., 2., 3., 0., 1., 2., 1., 12., 1., 5., 2., 3., 2., 2., 1., 2., 1., 6., 0., 0., 3., 1., 3., 1., 5., 4., 2., 1., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 2., 0., 7., 2., 6., 1., 4., 27., 1., 13., 27., 1., 10., 0., 0., 3., 13., 3., 6., 22., 12., 24., 23., 5., 1., 2., 0., 1., 6., 5., 18., 11., 3., 19., 4., 11., 8., 3., 1., 5., 3., 13., 17., 15., 30., 16., 18., 4., 0., 1., 5., 3., 11., 4., 10., 9., 9., 14., 6., 25., 9., 3., 0., 1., 7., 0., 2., 0., 6., 3., 2., 6., 0., 4., 6., 1., 1., 2., 0., 0., 3., 3., 0., 3., 1., 3., 1., 3., 4., 0., 1., 1., 1., 10., 1., 0., 2., 4., 1., 2., 2., 2., 2., 1., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 0., 4., 11., 2., 4., 2., 10., 29., 2., 18., 21., 0., 10., 1., 3., 0., 7., 1., 7., 22., 18., 33., 20., 6., 0., 1., 4., 1., 6., 10., 28., 15., 3., 19., 2., 14., 8., 2., 0., 4., 1., 8., 18., 23., 46., 9., 19., 4., 7., 1., 4., 2., 4., 1., 9., 4., 8., 17., 9., 21., 10., 1., 0., 0., 1., 0., 4., 4., 3., 3., 4., 7., 0., 5., 6., 1., 2., 1., 3., 0., 2., 0., 2., 8., 3., 6., 4., 3., 4., 0., 4., 1., 1., 7., 1., 0., 0., 6., 2., 0., 2., 2., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 3., 5., 11., 3., 13., 2., 9., 22., 3., 18., 25., 0., 16., 4., 2., 1., 36., 2., 2., 11., 11., 15., 25., 7., 1., 1., 3., 2., 8., 11., 23., 16., 2., 13., 3., 9., 5., 3., 0., 6., 3., 11., 11., 17., 57., 12., 23., 11., 2., 0., 5., 1., 6., 3., 10., 4., 7., 15., 4., 23., 8., 5., 3., 0., 3., 1., 5., 3., 7., 1., 5., 2., 3., 2., 0., 2., 1., 1., 2., 0., 1., 0., 4., 11., 2., 3., 0., 2., 1., 2., 4., 0., 1., 6., 3., 0., 2., 1., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 5., 5., 8., 3., 5., 1., 6., 27., 2., 14., 14., 1., 17., 2., 1., 1., 24., 3., 4., 13., 19., 27., 32., 2., 1., 0., 4., 3., 5., 9., 21., 17., 1., 24., 4., 15., 9., 2., 0., 5., 4., 14., 14., 22., 41., 15., 23., 10., 3., 1., 3., 2., 9., 4., 11., 8., 9., 21., 5., 22., 7., 2., 1., 2., 7., 2., 1., 2., 5., 7., 2., 4., 1., 3., 4., 2., 1., 0., 0., 0., 5., 2., 0., 9., 1., 4., 4., 3., 1., 1., 3., 1., 2., 11., 4., 0., 2., 2., 1., 0., 1., 3., 1., 0., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 4., 5., 9., 9., 5., 3., 1., 4., 24., 0., 11., 14., 0., 17., 0., 0., 0., 18., 4., 10., 27., 11., 23., 24., 5., 0., 0., 3., 1., 7., 4., 29., 14., 6., 13., 4., 8., 6., 1., 1., 3., 2., 13., 5., 19., 33., 10., 25., 9., 3., 1., 6., 1., 7., 2., 14., 10., 4., 13., 4., 18., 3., 1., 1., 1., 2., 1., 2., 3., 8., 2., 2., 5., 3., 3., 2., 4., 2., 4., 5., 0., 4., 1., 1., 6., 3., 4., 1., 1., 6., 1., 0., 0., 1., 1., 1., 0., 2., 2., 0., 2., 3., 2., 1., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 3., 3., 7., 2., 7., 0., 5., 35., 1., 13., 20., 0., 12., 2., 0., 4., 6., 1., 3., 16., 6., 25., 26., 3., 0., 2., 5., 4., 7., 1., 34., 13., 3., 11., 3., 14., 6., 3., 0., 8., 4., 17., 13., 18., 38., 16., 28., 5., 6., 3., 11., 3., 9., 4., 10., 9., 14., 19., 4., 17., 11., 3., 0., 0., 5., 0., 4., 0., 2., 2., 5., 2., 3., 6., 3., 2., 1., 0., 1., 0., 3., 4., 0., 8., 6., 4., 2., 0., 3., 0., 6., 0., 4., 5., 1., 0., 2., 4., 3., 4., 1., 1., 2., 0., 5., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 0., 2., 13., 2., 3., 0., 7., 19., 2., 17., 17., 0., 16., 3., 1., 2., 13., 0., 5., 27., 13., 18., 27., 5., 1., 6., 2., 4., 2., 9., 21., 22., 2., 15., 4., 10., 9., 4., 1., 5., 3., 14., 11., 13., 44., 10., 26., 9., 2., 0., 5., 2., 5., 5., 12., 3., 9., 12., 4., 19., 9., 3., 0., 1., 9., 1., 5., 3., 5., 3., 3., 1., 3., 6., 3., 0., 0., 1., 2., 0., 2., 1., 3., 5., 0., 2., 2., 1., 5., 0., 2., 1., 4., 7., 3., 0., 3., 1., 2., 2., 1., 0., 2., 1., 0., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 6., 8., 1., 7., 1., 3., 13., 0., 23., 17., 1., 16., 4., 3., 4., 5., 2., 4., 23., 13., 17., 23., 7., 2., 2., 1., 2., 12., 7., 25., 18., 5., 20., 4., 11., 11., 1., 2., 2., 1., 15., 9., 16., 63., 9., 26., 10., 8., 0., 7., 3., 5., 3., 6., 6., 5., 15., 5., 22., 8., 2., 1., 2., 10., 1., 4., 4., 9., 1., 5., 8., 3., 4., 4., 5., 0., 2., 2., 0., 3., 0., 0., 7., 1., 3., 0., 1., 5., 0., 4., 1., 2., 1., 2., 0., 1., 3., 1., 3., 3., 3., 2., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 1., 3., 5., 3., 8., 1., 1., 16., 0., 15., 26., 1., 17., 2., 0., 1., 18., 0., 2., 18., 5., 37., 28., 2., 2., 0., 6., 1., 9., 8., 36., 11., 2., 18., 6., 19., 14., 2., 1., 3., 0., 11., 13., 11., 53., 12., 26., 15., 4., 0., 8., 3., 7., 0., 10., 5., 4., 18., 6., 18., 5., 2., 0., 1., 7., 2., 0., 1., 6., 0., 6., 3., 4., 13., 4., 0., 0., 2., 4., 0., 2., 3., 0., 11., 2., 6., 1., 2., 6., 1., 0., 0., 2., 5., 3., 0., 5., 1., 2., 3., 3., 2., 2., 1., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 1., 2., 6., 5., 6., 0., 6., 14., 0., 12., 12., 0., 16., 2., 1., 3., 33., 2., 4., 29., 6., 31., 25., 10., 0., 1., 1., 0., 5., 6., 27., 18., 2., 14., 1., 13., 11., 0., 1., 4., 2., 12., 14., 14., 51., 16., 18., 9., 1., 0., 4., 2., 6., 1., 10., 7., 9., 15., 5., 21., 5., 5., 0., 2., 9., 0., 1., 2., 7., 3., 8., 8., 4., 1., 8., 1., 2., 0., 1., 0., 1., 2., 3., 5., 2., 2., 4., 1., 3., 1., 2., 2., 5., 2., 2., 0., 2., 6., 1., 2., 3., 1., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 0., 6., 5., 3., 5., 0., 4., 11., 2., 14., 15., 2., 26., 3., 2., 1., 4., 2., 1., 20., 15., 36., 27., 2., 0., 0., 3., 2., 8., 9., 19., 19., 2., 23., 5., 16., 5., 3., 1., 4., 1., 17., 19., 9., 47., 5., 17., 12., 2., 0., 4., 2., 5., 2., 12., 3., 10., 10., 7., 12., 6., 2., 0., 3., 11., 0., 3., 3., 7., 1., 1., 4., 2., 5., 2., 1., 2., 3., 4., 0., 1., 1., 3., 12., 4., 10., 0., 2., 1., 3., 3., 0., 4., 12., 1., 0., 3., 1., 4., 2., 1., 1., 2., 3., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 3., 4., 12., 4., 8., 2., 7., 25., 2., 13., 27., 1., 10., 2., 2., 3., 13., 2., 3., 32., 9., 24., 27., 5., 0., 1., 6., 2., 7., 8., 20., 14., 5., 18., 6., 17., 8., 2., 1., 9., 2., 13., 11., 23., 42., 9., 21., 5., 2., 3., 2., 1., 4., 2., 9., 7., 14., 17., 5., 27., 4., 2., 0., 1., 9., 1., 2., 2., 6., 4., 2., 3., 2., 1., 3., 3., 0., 0., 2., 0., 2., 2., 3., 8., 1., 5., 0., 2., 4., 2., 1., 1., 3., 3., 2., 0., 1., 2., 2., 4., 2., 4., 2., 0., 1., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 1., 5., 8., 3., 11., 0., 7., 27., 1., 7., 26., 0., 16., 6., 1., 3., 31., 2., 3., 14., 11., 24., 32., 4., 2., 1., 4., 6., 3., 6., 28., 11., 3., 9., 3., 13., 10., 2., 2., 5., 3., 11., 9., 17., 44., 12., 20., 5., 3., 3., 6., 2., 4., 2., 13., 6., 11., 9., 4., 17., 8., 5., 1., 1., 12., 1., 1., 3., 5., 6., 1., 4., 1., 3., 2., 5., 1., 1., 3., 0., 2., 2., 3., 4., 1., 4., 3., 2., 7., 1., 3., 1., 4., 5., 4., 0., 4., 2., 2., 1., 1., 1., 3., 0., 2., 0., 0., 0., 0., 2., 0., 0., 5., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 1., 4., 9., 2., 6., 2., 4., 24., 3., 13., 21., 1., 18., 2., 0., 3., 16., 0., 6., 23., 6., 21., 22., 7., 0., 1., 4., 3., 8., 11., 27., 17., 3., 11., 6., 17., 8., 3., 1., 4., 3., 10., 11., 19., 50., 13., 16., 13., 9., 0., 8., 1., 7., 2., 15., 7., 8., 18., 3., 33., 12., 3., 0., 1., 8., 2., 0., 2., 5., 2., 4., 4., 5., 5., 4., 1., 1., 2., 3., 0., 4., 2., 3., 5., 2., 4., 2., 2., 4., 0., 1., 0., 5., 5., 3., 0., 3., 3., 1., 4., 2., 2., 3., 4., 2., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 2., 2., 7., 2., 4., 0., 5., 27., 0., 9., 19., 0., 15., 1., 1., 3., 19., 4., 6., 27., 12., 32., 28., 7., 1., 0., 3., 1., 9., 9., 25., 17., 3., 17., 5., 9., 4., 2., 0., 6., 2., 11., 16., 19., 39., 13., 22., 11., 0., 1., 7., 2., 4., 5., 9., 2., 12., 21., 6., 29., 4., 7., 0., 2., 6., 2., 6., 2., 6., 3., 3., 3., 2., 2., 0., 1., 0., 4., 3., 0., 1., 3., 3., 6., 3., 8., 2., 4., 8., 0., 2., 0., 5., 2., 2., 0., 3., 2., 1., 3., 4., 1., 3., 0., 3., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 3., 1., 14., 5., 6., 0., 7., 10., 1., 11., 23., 4., 9., 2., 1., 3., 19., 2., 4., 35., 15., 31., 26., 7., 0., 1., 2., 1., 6., 2., 24., 21., 2., 20., 3., 17., 10., 4., 1., 11., 4., 7., 12., 23., 46., 11., 22., 7., 0., 0., 9., 4., 5., 2., 14., 8., 7., 18., 6., 14., 12., 5., 0., 3., 4., 2., 4., 2., 4., 5., 2., 5., 2., 5., 4., 7., 1., 1., 3., 0., 2., 0., 2., 6., 2., 6., 2., 1., 6., 0., 4., 1., 2., 5., 4., 0., 2., 1., 3., 5., 3., 0., 2., 0., 2., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 2., 1., 6., 0., 22., 2., 7., 50., 0., 11., 79., 1., 8., 2., 0., 2., 79., 10., 5., 84., 14., 86., 17., 5., 0., 3., 2., 1., 15., 14., 54., 11., 4., 38., 27., 15., 4., 0., 1., 8., 2., 23., 6., 29., 4., 11., 7., 4., 4., 0., 10., 2., 13., 9., 14., 5., 9., 5., 6., 51., 3., 5., 3., 0., 12., 5., 9., 2., 13., 2., 3., 4., 2., 1., 0., 6., 2., 8., 17., 1., 2., 0., 3., 0., 0., 0., 0., 0., 6., 1., 4., 2., 3., 1., 3., 0., 1., 0., 3., 0., 1., 3., 2., 0., 2., 0., 4., 0., 0., 0., 0., 0., 1., 0., 3., 2., 5., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 22., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 4., 12., 0., 14., 1., 12., 52., 1., 9., 63., 2., 7., 2., 0., 1., 66., 7., 13., 64., 6., 73., 15., 2., 0., 4., 2., 1., 12., 13., 68., 12., 2., 35., 36., 13., 6., 0., 1., 2., 4., 23., 3., 20., 5., 9., 7., 2., 2., 0., 9., 3., 14., 9., 15., 3., 5., 5., 5., 47., 9., 5., 4., 0., 7., 8., 5., 2., 15., 1., 2., 1., 0., 2., 0., 7., 3., 18., 14., 0., 2., 2., 5., 0., 0., 0., 0., 0., 6., 1., 4., 2., 2., 1., 3., 0., 1., 0., 2., 0., 1., 2., 2., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 0., 3., 2., 1., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 21., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 1., 3., 12., 0., 11., 3., 8., 68., 0., 11., 59., 0., 2., 2., 0., 0., 69., 6., 13., 92., 23., 74., 14., 7., 0., 3., 4., 2., 13., 9., 57., 13., 3., 37., 45., 12., 1., 0., 1., 3., 5., 22., 5., 22., 4., 11., 5., 4., 1., 0., 11., 2., 10., 9., 16., 2., 12., 3., 3., 49., 6., 6., 0., 0., 15., 7., 8., 3., 10., 5., 4., 2., 2., 1., 0., 12., 1., 15., 7., 2., 2., 3., 0., 0., 0., 0., 0., 0., 10., 2., 1., 2., 2., 4., 1., 0., 1., 0., 1., 0., 0., 5., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 1., 0., 2., 1., 3., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 19., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 4., 3., 10., 26., 7., 47., 1., 19., 163., 6., 28., 181., 6., 29., 4., 2., 2., 75., 1., 20., 283., 39., 299., 48., 17., 0., 3., 9., 4., 56., 36., 250., 42., 8., 175., 18., 35., 7., 0., 2., 16., 9., 86., 21., 96., 9., 44., 41., 14., 3., 1., 31., 7., 29., 13., 46., 8., 30., 5., 11., 4., 1., 0., 0., 0., 28., 6., 14., 2., 20., 2., 9., 6., 1., 2., 0., 1., 1., 5., 8., 2., 5., 1., 2., 0., 0., 4., 140., 10., 1854., 82., 101., 213., 104., 116., 62., 14., 13., 18., 13., 0., 5., 5., 7., 4., 9., 13., 29., 16., 31., 20., 42., 5., 16., 4., 5., 7., 4., 2., 2., 5., 12., 3., 0., 0., 3., 14., 2., 0., 14., 2., 2., 0., 5., 2., 3., 34., 2., 6., 2., 9., 2., 14., 3., 3., 2., 3., 23., 5., 35., 11., 6., 5., 6., 29., 5., 7., 1.,

11., 1., 0., 6., 14., 5., 31., 0., 19., 156., 2., 27., 204., 3., 15., 1., 1., 5., 88., 0., 9., 290., 50., 298., 26., 12., 4., 0., 7., 4., 41., 30., 222., 39., 11., 152., 13., 39., 7., 0., 3., 16., 13., 81., 24., 111., 20., 37., 22., 12., 5., 0., 32., 11., 46., 9., 40., 6., 34., 3., 10., 8., 2., 0., 0., 0., 27., 5., 5., 2., 24., 6., 12., 3., 0., 2., 0., 0., 5., 0., 7., 5., 12., 0., 8., 2., 2., 2., 157., 9., 1902., 77., 96., 206., 91., 119., 72., 16., 12., 17., 22., 0., 2., 9., 4., 4., 6., 11., 35., 13., 39., 17., 32., 7., 7., 5., 8., 3., 6., 2., 7., 4., 13., 5., 0., 3., 2., 16., 1., 0., 7., 1., 4., 0., 6., 2., 7., 24., 6., 16., 4., 17., 4., 14., 5., 5., 3., 10., 22., 5., 32., 5., 6., 6., 3., 28., 11., 11., 9.,

14., 3., 4., 8., 19., 2., 31., 0., 13., 162., 1., 27., 202., 5., 15., 7., 1., 3., 99., 0., 31., 290., 46., 363., 54., 19., 1., 3., 6., 4., 50., 27., 208., 56., 4., 176., 11., 31., 7., 0., 1., 10., 11., 78., 21., 95., 7., 41., 56., 8., 4., 1., 16., 9., 42., 10., 49., 7., 32., 10., 8., 5., 2., 0., 1., 0., 20., 6., 9., 4., 31., 10., 7., 3., 2., 1., 3., 0., 5., 2., 10., 3., 4., 7., 6., 1., 1., 6., 125., 12., 1767., 87., 94., 229., 92., 126., 74., 15., 12., 15., 19., 1., 2., 9., 2., 4., 8., 11., 30., 15., 29., 17., 35., 9., 12., 4., 6., 10., 5., 2., 5., 0., 8., 2., 0., 3., 8., 15., 3., 0., 9., 2., 2., 0., 6., 7., 8., 39., 6., 10., 2., 12., 2., 21., 4., 2., 8., 4., 26., 2., 30., 4., 5., 7., 7., 40., 3., 15., 5.,

15., 1., 1., 8., 25., 5., 36., 3., 9., 188., 8., 27., 203., 4., 16., 6., 1., 5., 67., 2., 30., 293., 55., 306., 32., 20., 2., 1., 6., 8., 43., 33., 233., 43., 11., 172., 9., 38., 11., 0., 2., 22., 8., 74., 14., 95., 12., 36., 37., 17., 3., 2., 27., 7., 35., 5., 38., 9., 28., 6., 9., 4., 4., 0., 1., 0., 22., 5., 11., 0., 48., 1., 5., 3., 0., 2., 2., 2., 2., 1., 15., 4., 13., 2., 15., 0., 1., 4., 136., 9., 1915., 79., 76., 225., 106., 104., 56., 30., 6., 18., 12., 0., 1., 8., 10., 3., 12., 7., 32., 26., 29., 12., 30., 5., 10., 5., 4., 6., 4., 1., 1., 4., 8., 5., 0., 4., 3., 22., 5., 0., 10., 6., 3., 0., 8., 3., 3., 32., 3., 17., 3., 7., 3., 19., 2., 3., 5., 4., 31., 6., 23., 7., 0., 9., 5., 25., 9., 13., 1.,

12., 1., 3., 12., 24., 2., 23., 0., 19., 140., 2., 23., 211., 7., 19., 2., 1., 4., 73., 1., 5., 309., 53., 316., 39., 18., 0., 1., 8., 8., 38., 29., 240., 30., 11., 151., 15., 43., 4., 0., 2., 13., 4., 66., 13., 103., 14., 38., 35., 4., 0., 0., 35., 8., 45., 12., 51., 14., 35., 8., 10., 7., 2., 0., 0., 0., 23., 6., 15., 1., 38., 5., 11., 5., 2., 3., 3., 0., 3., 1., 11., 3., 12., 0., 7., 0., 0., 6., 135., 12., 1918., 86., 98., 193., 95., 106., 83., 10., 11., 19., 10., 2., 5., 8., 5., 7., 9., 7., 35., 17., 24., 16., 45., 7., 9., 3., 8., 7., 6., 0., 3., 1., 11., 4., 0., 6., 4., 19., 2., 0., 10., 2., 1., 0., 2., 3., 2., 30., 4., 13., 1., 17., 2., 18., 6., 2., 6., 4., 27., 3., 31., 10., 4., 6., 4., 29., 5., 17., 2.,

15., 2., 0., 10., 27., 9., 40., 2., 21., 176., 4., 30., 208., 8., 15., 3., 0., 8., 70., 2., 12., 275., 39., 311., 43., 10., 0., 0., 7., 5., 43., 34., 268., 30., 11., 165., 18., 37., 5., 0., 0., 20., 9., 77., 21., 102., 14., 37., 46., 13., 2., 1., 24., 1., 42., 10., 46., 7., 32., 3., 8., 7., 4., 0., 0., 0., 25., 4., 23., 6., 19., 10., 10., 3., 2., 2., 0., 1., 1., 0., 11., 0., 12., 4., 9., 1., 1., 5., 150., 14., 1864., 90., 94., 231., 108., 103., 62., 16., 9., 18., 8., 0., 0., 3., 5., 4., 11., 7., 38., 24., 43., 19., 50., 10., 12., 4., 4., 6., 2., 5., 3., 8., 8., 1., 0., 5., 9., 15., 0., 0., 13., 4., 1., 0., 2., 5., 2., 38., 3., 20., 3., 14., 4., 24., 7., 4., 7., 6., 31., 2., 34., 5., 5., 10., 4., 25., 6., 12., 4.,

8., 3., 1., 9., 11., 4., 7., 2., 8., 29., 1., 2., 22., 3., 9., 5., 2., 2., 17., 8., 8., 23., 16., 33., 29., 6., 4., 0., 2., 3., 10., 4., 15., 17., 7., 16., 4., 17., 11., 5., 2., 7., 2., 6., 13., 23., 58., 9., 23., 6., 6., 4., 6., 0., 7., 4., 8., 5., 8., 20., 6., 21., 13., 4., 3., 2., 5., 2., 7., 1., 4., 6., 4., 4., 1., 2., 6., 3., 2., 6., 5., 0., 1., 1., 2., 6., 1., 2., 0., 2., 0., 1., 4., 3., 1., 14., 0., 0., 1., 3., 2., 1., 2., 0., 1., 2., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 1., 1., 6., 5., 7., 0., 10., 14., 1., 15., 30., 1., 18., 2., 2., 1., 19., 3., 6., 18., 15., 15., 29., 5., 0., 2., 2., 1., 6., 9., 21., 21., 0., 23., 5., 11., 11., 2., 2., 4., 2., 6., 6., 21., 42., 11., 18., 4., 8., 1., 2., 6., 5., 1., 17., 11., 8., 22., 4., 20., 9., 2., 3., 2., 16., 2., 2., 1., 4., 4., 2., 6., 2., 2., 3., 3., 0., 2., 0., 0., 1., 1., 4., 9., 1., 0., 1., 2., 4., 2., 3., 2., 3., 3., 4., 0., 1., 1., 0., 2., 1., 4., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 5., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 9., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 2., 7., 2., 4., 6., 1., 7., 17., 2., 14., 14., 0., 20., 4., 2., 2., 24., 1., 4., 23., 14., 17., 24., 4., 1., 0., 3., 2., 8., 9., 23., 17., 4., 13., 3., 18., 7., 3., 2., 5., 0., 14., 8., 13., 39., 9., 26., 7., 3., 0., 4., 1., 8., 0., 9., 8., 4., 16., 7., 18., 10., 4., 1., 2., 0., 3., 2., 4., 6., 7., 6., 3., 1., 3., 1., 4., 0., 3., 1., 0., 3., 0., 3., 3., 2., 6., 3., 1., 5., 2., 2., 0., 2., 3., 3., 0., 1., 1., 1., 2., 3., 2., 1., 1., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 3., 2., 9., 9., 1., 7., 1., 5., 10., 0., 12., 11., 2., 12., 4., 1., 2., 3., 2., 4., 24., 14., 24., 25., 8., 1., 2., 2., 0., 12., 6., 24., 19., 4., 20., 7., 21., 8., 2., 1., 6., 1., 6., 18., 24., 64., 10., 16., 13., 1., 0., 7., 0., 10., 2., 7., 9., 6., 20., 6., 24., 6., 2., 1., 0., 4., 0., 3., 1., 6., 4., 6., 2., 1., 6., 1., 1., 2., 1., 3., 0., 4., 2., 2., 6., 0., 4., 1., 3., 2., 0., 2., 1., 2., 8., 1., 0., 0., 1., 1., 0., 1., 3., 3., 1., 6., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 3., 2., 9., 3., 6., 1., 6., 20., 3., 20., 36., 3., 24., 3., 1., 4., 16., 1., 6., 23., 9., 20., 23., 2., 2., 1., 3., 1., 6., 9., 33., 18., 11., 21., 1., 21., 6., 4., 0., 3., 3., 12., 9., 22., 44., 13., 25., 10., 7., 2., 2., 1., 5., 3., 3., 5., 7., 17., 4., 23., 15., 6., 3., 0., 7., 0., 3., 3., 3., 7., 2., 3., 2., 8., 1., 2., 1., 2., 1., 0., 2., 4., 2., 5., 2., 7., 0., 3., 2., 2., 1., 1., 2., 5., 2., 0., 0., 2., 2., 1., 2., 1., 1., 0., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 8., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 1., 7., 9., 6., 8., 0., 6., 28., 1., 12., 24., 1., 12., 6., 1., 2., 11., 0., 5., 18., 16., 13., 31., 7., 2., 2., 3., 4., 5., 4., 13., 18., 3., 15., 4., 12., 6., 3., 0., 1., 1., 10., 7., 18., 46., 13., 14., 4., 3., 0., 9., 2., 4., 5., 13., 5., 9., 16., 8., 13., 9., 4., 1., 0., 12., 0., 4., 4., 9., 0., 3., 3., 0., 2., 1., 1., 0., 0., 3., 0., 1., 0., 4., 9., 3., 6., 2., 2., 7., 1., 4., 0., 5., 3., 1., 0., 2., 7., 4., 2., 2., 0., 2., 0., 3., 0., 0., 0., 0., 5., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 2., 4., 2., 4., 3., 2., 7., 12., 1., 15., 23., 0., 19., 7., 1., 5., 17., 3., 3., 21., 20., 10., 39., 6., 0., 0., 1., 2., 7., 3., 37., 23., 2., 6., 7., 20., 8., 1., 2., 4., 2., 5., 9., 12., 41., 13., 20., 11., 5., 3., 5., 2., 7., 1., 13., 4., 11., 20., 6., 24., 9., 3., 2., 2., 10., 1., 1., 3., 4., 0., 6., 1., 1., 3., 6., 3., 1., 1., 4., 0., 1., 1., 1., 5., 1., 8., 1., 0., 5., 2., 2., 1., 4., 7., 2., 0., 1., 1., 2., 0., 5., 4., 3., 0., 2., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 7., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 0., 8., 3., 3., 3., 0., 4., 18., 1., 17., 23., 1., 10., 3., 3., 0., 14., 2., 7., 18., 14., 38., 24., 13., 3., 0., 5., 2., 7., 7., 46., 20., 3., 10., 4., 21., 16., 2., 1., 5., 0., 16., 8., 20., 52., 15., 28., 15., 4., 0., 5., 2., 10., 4., 12., 5., 7., 17., 8., 25., 10., 4., 1., 2., 11., 0., 3., 0., 2., 3., 7., 5., 2., 4., 4., 1., 4., 1., 3., 0., 6., 2., 2., 2., 0., 3., 1., 1., 2., 1., 1., 1., 3., 8., 1., 0., 1., 0., 3., 1., 3., 1., 4., 4., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 3., 5., 2., 6., 1., 5., 1., 6., 14., 0., 19., 26., 0., 14., 6., 0., 3., 29., 1., 6., 29., 12., 26., 20., 4., 0., 0., 2., 1., 12., 6., 33., 18., 3., 17., 4., 13., 5., 1., 1., 2., 3., 10., 10., 24., 42., 12., 23., 11., 4., 2., 4., 2., 7., 6., 11., 6., 9., 17., 7., 22., 10., 1., 1., 2., 9., 2., 2., 2., 5., 2., 1., 8., 2., 2., 3., 3., 0., 2., 3., 0., 1., 4., 4., 11., 4., 7., 2., 3., 7., 2., 2., 2., 4., 8., 3., 0., 3., 0., 0., 1., 4., 4., 0., 1., 0., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 4., 5., 3., 2., 1., 6., 28., 2., 19., 21., 1., 13., 1., 1., 4., 22., 0., 6., 30., 13., 19., 28., 11., 1., 3., 1., 2., 8., 5., 23., 23., 2., 20., 3., 10., 6., 2., 1., 4., 0., 10., 8., 15., 51., 13., 15., 4., 3., 2., 3., 1., 10., 3., 8., 6., 13., 17., 7., 20., 8., 3., 0., 0., 8., 0., 5., 3., 5., 4., 2., 5., 0., 1., 4., 2., 1., 2., 1., 0., 4., 3., 2., 7., 3., 3., 3., 7., 7., 3., 4., 2., 2., 7., 2., 0., 0., 0., 5., 4., 0., 1., 3., 0., 3., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 4., 4., 9., 3., 6., 0., 8., 28., 0., 15., 23., 1., 14., 1., 0., 2., 18., 3., 4., 15., 11., 27., 32., 8., 0., 3., 5., 3., 9., 8., 27., 18., 5., 13., 5., 11., 8., 1., 1., 4., 4., 15., 13., 10., 40., 7., 16., 7., 7., 3., 5., 1., 7., 3., 6., 8., 10., 14., 6., 21., 4., 5., 1., 1., 7., 0., 3., 0., 7., 1., 5., 0., 2., 5., 3., 4., 0., 2., 2., 0., 4., 0., 3., 6., 2., 3., 3., 0., 5., 1., 1., 1., 1., 7., 2., 0., 1., 2., 1., 0., 4., 2., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 3., 2., 0., 2., 9., 1., 7., 14., 0., 6., 29., 1., 16., 3., 0., 4., 15., 1., 1., 28., 10., 11., 27., 3., 0., 1., 2., 1., 10., 5., 27., 12., 1., 8., 2., 14., 12., 2., 1., 4., 1., 16., 11., 25., 51., 14., 24., 5., 4., 0., 5., 1., 6., 1., 5., 8., 9., 13., 7., 25., 5., 1., 1., 3., 8., 1., 0., 2., 6., 3., 12., 1., 3., 6., 3., 4., 0., 2., 1., 0., 1., 3., 1., 5., 1., 7., 3., 1., 5., 1., 0., 1., 1., 6., 0., 0., 1., 0., 2., 1., 3., 2., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 2., 9., 13., 1., 5., 1., 11., 27., 0., 9., 24., 2., 12., 1., 0., 1., 13., 2., 5., 18., 14., 25., 23., 10., 0., 0., 1., 3., 11., 12., 33., 13., 4., 16., 2., 6., 9., 2., 0., 3., 4., 6., 15., 21., 40., 9., 19., 11., 1., 1., 0., 3., 7., 4., 10., 6., 10., 14., 8., 27., 9., 2., 1., 2., 6., 0., 3., 4., 3., 1., 8., 4., 1., 4., 1., 2., 2., 3., 4., 0., 1., 2., 2., 4., 2., 3., 2., 8., 6., 0., 2., 1., 3., 8., 1., 0., 0., 2., 3., 0., 1., 0., 1., 3., 3., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 3., 4., 12., 1., 5., 1., 8., 27., 1., 6., 30., 4., 16., 4., 0., 1., 20., 1., 1., 34., 9., 26., 26., 1., 1., 0., 2., 0., 8., 4., 27., 19., 5., 15., 2., 14., 10., 3., 1., 4., 1., 6., 9., 17., 45., 15., 16., 9., 4., 1., 3., 4., 1., 3., 7., 7., 7., 14., 4., 22., 3., 2., 2., 2., 4., 3., 2., 3., 6., 7., 3., 9., 2., 3., 4., 2., 2., 1., 1., 0., 3., 1., 3., 3., 1., 7., 2., 4., 7., 3., 0., 0., 1., 7., 2., 0., 1., 1., 0., 2., 0., 0., 2., 2., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 1., 9., 10., 5., 3., 0., 5., 14., 0., 9., 24., 0., 15., 5., 3., 2., 9., 0., 8., 28., 17., 22., 37., 6., 1., 2., 3., 1., 8., 11., 22., 17., 6., 13., 2., 14., 7., 0., 2., 5., 2., 9., 10., 18., 52., 9., 17., 9., 5., 1., 5., 1., 11., 2., 14., 9., 13., 11., 11., 24., 9., 2., 0., 2., 12., 0., 1., 1., 6., 0., 1., 4., 0., 4., 2., 4., 0., 3., 2., 0., 1., 1., 4., 9., 3., 5., 3., 3., 5., 0., 3., 1., 2., 12., 1., 0., 2., 3., 2., 0., 3., 1., 3., 4., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 0., 2., 8., 11., 3., 4., 1., 11., 11., 0., 11., 19., 1., 12., 3., 1., 1., 16., 3., 5., 28., 11., 32., 32., 9., 0., 2., 1., 2., 9., 6., 19., 13., 1., 14., 2., 14., 9., 1., 2., 4., 3., 16., 6., 19., 54., 14., 11., 8., 7., 2., 6., 2., 9., 2., 12., 6., 9., 14., 4., 28., 14., 1., 0., 1., 10., 0., 1., 0., 1., 5., 3., 3., 1., 5., 3., 2., 2., 1., 1., 0., 4., 1., 0., 4., 1., 9., 3., 0., 3., 0., 2., 0., 2., 6., 3., 0., 2., 0., 2., 2., 2., 4., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 1., 3., 7., 1., 9., 1., 4., 14., 1., 16., 22., 2., 7., 4., 1., 0., 15., 3., 4., 22., 18., 22., 19., 6., 0., 2., 3., 3., 12., 8., 16., 19., 4., 8., 4., 14., 14., 1., 1., 4., 4., 11., 18., 20., 37., 9., 24., 7., 3., 0., 6., 1., 6., 2., 8., 12., 6., 16., 5., 21., 11., 3., 0., 0., 6., 0., 4., 2., 2., 1., 4., 2., 1., 2., 3., 4., 1., 1., 1., 0., 2., 1., 2., 2., 4., 6., 0., 1., 3., 2., 2., 2., 1., 6., 0., 0., 1., 1., 1., 2., 1., 0., 2., 1., 0., 0., 0., 0., 0., 2., 0., 0., 6., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 0., 4., 11., 1., 3., 3., 6., 31., 1., 16., 20., 1., 12., 5., 1., 0., 17., 2., 6., 23., 17., 20., 23., 7., 1., 1., 3., 3., 2., 5., 34., 24., 2., 15., 4., 15., 5., 2., 1., 3., 3., 12., 18., 20., 59., 11., 20., 6., 1., 2., 4., 5., 4., 3., 8., 7., 10., 15., 7., 17., 6., 2., 3., 0., 8., 3., 2., 2., 4., 6., 3., 4., 3., 7., 3., 1., 2., 1., 1., 0., 1., 2., 2., 4., 2., 3., 2., 2., 2., 1., 2., 2., 4., 7., 1., 0., 6., 0., 1., 2., 2., 1., 3., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 1., 4., 2., 13., 2., 7., 1., 3., 18., 1., 8., 27., 2., 13., 4., 1., 4., 23., 2., 5., 17., 12., 31., 17., 6., 2., 3., 1., 3., 11., 4., 25., 15., 6., 14., 1., 13., 8., 3., 0., 5., 2., 9., 17., 14., 42., 13., 15., 9., 6., 1., 7., 1., 11., 2., 6., 8., 9., 16., 6., 23., 7., 4., 1., 1., 2., 1., 3., 0., 4., 3., 1., 5., 0., 6., 3., 0., 1., 2., 3., 0., 1., 4., 3., 7., 3., 5., 2., 2., 1., 0., 2., 0., 4., 6., 6., 0., 2., 1., 2., 4., 1., 5., 2., 1., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 2., 1., 12., 5., 9., 0., 5., 34., 3., 14., 20., 1., 19., 1., 1., 2., 10., 3., 4., 12., 15., 27., 24., 4., 1., 0., 3., 3., 5., 5., 28., 23., 4., 8., 4., 9., 14., 1., 0., 4., 2., 14., 9., 14., 58., 17., 27., 6., 4., 1., 6., 2., 3., 4., 4., 5., 6., 14., 3., 18., 7., 7., 0., 0., 7., 0., 0., 1., 3., 1., 3., 4., 0., 2., 3., 2., 6., 5., 1., 0., 1., 0., 6., 6., 2., 4., 4., 0., 5., 0., 3., 1., 3., 8., 2., 0., 0., 1., 2., 2., 2., 3., 1., 1., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 3., 2., 3., 10., 2., 3., 2., 7., 14., 0., 15., 32., 2., 8., 2., 1., 2., 13., 3., 5., 24., 7., 31., 22., 5., 1., 0., 1., 2., 4., 3., 31., 19., 2., 17., 4., 14., 5., 1., 1., 2., 1., 9., 12., 16., 43., 13., 28., 7., 6., 1., 7., 1., 8., 0., 7., 2., 11., 12., 5., 20., 8., 3., 0., 1., 11., 0., 3., 1., 5., 3., 5., 6., 2., 4., 1., 5., 1., 2., 2., 0., 1., 1., 1., 5., 3., 3., 1., 1., 4., 1., 1., 1., 3., 9., 1., 0., 2., 1., 3., 1., 2., 1., 3., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 3., 2., 9., 1., 4., 3., 6., 17., 0., 9., 24., 1., 12., 2., 0., 2., 16., 2., 5., 24., 7., 34., 27., 9., 1., 1., 4., 4., 4., 3., 34., 11., 3., 12., 5., 11., 6., 1., 1., 4., 0., 14., 14., 21., 47., 15., 17., 8., 3., 0., 2., 1., 12., 5., 14., 5., 9., 16., 4., 15., 12., 2., 6., 0., 11., 0., 2., 2., 3., 5., 5., 3., 3., 8., 1., 2., 0., 2., 0., 0., 1., 4., 3., 3., 3., 2., 2., 0., 0., 0., 4., 3., 2., 5., 2., 0., 2., 2., 1., 2., 1., 2., 2., 1., 3., 0., 0., 0., 0., 5., 0., 0., 1., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 3., 9., 0., 14., 0., 8., 44., 1., 11., 66., 0., 5., 0., 0., 0., 74., 8., 10., 87., 15., 75., 11., 1., 0., 1., 7., 2., 10., 7., 46., 11., 3., 35., 22., 10., 5., 0., 2., 6., 2., 20., 6., 27., 6., 18., 1., 2., 3., 0., 13., 7., 15., 4., 10., 4., 4., 4., 6., 33., 12., 4., 2., 0., 9., 2., 12., 3., 14., 2., 3., 1., 1., 1., 0., 7., 2., 11., 9., 5., 2., 0., 1., 0., 0., 0., 0., 0., 10., 1., 2., 2., 4., 0., 2., 0., 1., 0., 0., 0., 0., 4., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 6., 4., 2., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 29., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 3., 5., 2., 0., 18., 0., 10., 32., 1., 7., 43., 0., 7., 2., 0., 2., 69., 11., 7., 72., 16., 70., 12., 5., 0., 2., 1., 1., 13., 9., 48., 13., 4., 47., 30., 17., 4., 0., 2., 10., 3., 26., 8., 29., 10., 7., 10., 3., 1., 0., 17., 4., 19., 7., 16., 6., 11., 2., 2., 40., 6., 7., 2., 0., 14., 4., 8., 2., 10., 2., 2., 2., 1., 0., 0., 5., 5., 16., 10., 3., 9., 0., 2., 0., 0., 0., 0., 0., 9., 2., 3., 1., 5., 2., 2., 0., 0., 0., 0., 0., 2., 2., 2., 0., 4., 0., 0., 0., 2., 0., 0., 0., 0., 0., 2., 2., 1., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 26., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 3., 6., 4., 17., 0., 12., 1., 12., 41., 1., 4., 52., 0., 7., 0., 0., 0., 76., 10., 4., 84., 14., 67., 17., 5., 0., 1., 0., 2., 10., 6., 55., 5., 2., 40., 31., 13., 9., 0., 0., 7., 2., 20., 3., 15., 10., 11., 10., 1., 2., 0., 11., 5., 13., 5., 18., 4., 5., 2., 1., 38., 13., 5., 1., 0., 11., 4., 10., 3., 15., 2., 5., 3., 2., 0., 0., 2., 2., 12., 5., 5., 1., 2., 2., 0., 0., 0., 0., 0., 10., 2., 1., 2., 6., 1., 1., 0., 1., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 1., 7., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 17., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 2., 3., 10., 0., 8., 2., 6., 49., 0., 9., 63., 2., 4., 2., 0., 2., 55., 14., 7., 79., 20., 83., 10., 4., 0., 1., 2., 0., 14., 10., 47., 20., 4., 37., 28., 19., 7., 0., 0., 10., 3., 28., 5., 20., 3., 13., 3., 4., 1., 0., 7., 4., 16., 5., 13., 2., 5., 3., 3., 38., 11., 6., 3., 0., 17., 1., 8., 5., 8., 6., 7., 1., 0., 1., 0., 5., 2., 14., 6., 1., 3., 1., 5., 0., 0., 0., 0., 0., 13., 2., 1., 1., 1., 0., 1., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 7., 1., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 25., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

22., 2., 5., 9., 21., 7., 43., 0., 13., 154., 3., 26., 221., 5., 13., 12., 0., 3., 89., 1., 16., 297., 37., 341., 48., 24., 1., 1., 6., 5., 33., 29., 218., 43., 9., 143., 11., 33., 5., 0., 3., 15., 7., 76., 8., 105., 19., 34., 46., 14., 1., 1., 25., 5., 44., 9., 52., 15., 27., 8., 7., 4., 1., 0., 2., 0., 24., 6., 11., 1., 30., 7., 11., 5., 1., 3., 0., 0., 5., 0., 6., 1., 5., 3., 2., 2., 3., 5., 135., 3., 1894., 88., 115., 204., 100., 103., 70., 16., 11., 17., 20., 1., 2., 11., 5., 5., 9., 11., 28., 18., 36., 22., 58., 6., 11., 7., 8., 6., 5., 2., 2., 1., 4., 3., 0., 3., 2., 23., 2., 0., 11., 4., 4., 0., 2., 5., 4., 31., 2., 10., 2., 14., 3., 20., 5., 1., 3., 5., 32., 2., 19., 6., 4., 11., 9., 29., 11., 17., 2.,

23., 1., 1., 4., 22., 5., 35., 4., 17., 150., 2., 31., 210., 6., 20., 7., 0., 6., 67., 2., 11., 312., 55., 347., 38., 14., 2., 2., 10., 2., 38., 30., 247., 40., 6., 154., 16., 33., 4., 0., 3., 16., 9., 94., 25., 80., 14., 28., 42., 10., 8., 0., 31., 7., 44., 7., 50., 13., 33., 7., 7., 5., 3., 0., 0., 0., 28., 5., 12., 2., 27., 2., 12., 3., 0., 5., 2., 1., 3., 3., 5., 3., 8., 1., 8., 3., 2., 4., 141., 6., 1836., 91., 90., 206., 103., 122., 60., 10., 11., 14., 14., 1., 1., 7., 4., 0., 11., 7., 34., 13., 32., 16., 48., 10., 9., 2., 5., 7., 7., 1., 0., 2., 6., 3., 0., 1., 6., 11., 2., 0., 16., 1., 8., 0., 7., 1., 4., 31., 3., 9., 3., 6., 7., 23., 4., 2., 3., 5., 32., 3., 29., 6., 4., 9., 7., 25., 8., 18., 4.,

15., 0., 1., 7., 22., 8., 38., 1., 13., 154., 6., 27., 201., 6., 12., 8., 1., 4., 76., 1., 17., 283., 60., 295., 37., 19., 2., 3., 10., 3., 42., 34., 226., 45., 9., 168., 8., 39., 7., 0., 2., 14., 4., 79., 19., 82., 16., 27., 45., 12., 3., 1., 26., 2., 43., 10., 45., 4., 32., 7., 12., 9., 1., 0., 0., 0., 28., 6., 9., 4., 30., 4., 14., 4., 2., 3., 1., 0., 6., 1., 12., 4., 8., 1., 5., 0., 2., 1., 149., 12., 1826., 86., 119., 223., 103., 111., 87., 16., 9., 8., 13., 1., 2., 8., 4., 3., 14., 13., 34., 16., 23., 18., 39., 4., 9., 5., 3., 10., 6., 1., 2., 0., 7., 3., 0., 6., 4., 14., 3., 0., 10., 7., 3., 0., 1., 1., 2., 32., 1., 12., 4., 18., 1., 19., 3., 2., 4., 6., 17., 5., 31., 7., 8., 5., 5., 35., 7., 16., 0.,

19., 5., 3., 10., 30., 8., 30., 0., 13., 149., 2., 30., 188., 8., 22., 6., 1., 3., 63., 0., 16., 259., 51., 325., 48., 25., 2., 2., 8., 6., 42., 43., 222., 34., 4., 160., 14., 39., 4., 0., 1., 9., 4., 84., 25., 96., 13., 34., 47., 10., 3., 1., 24., 8., 51., 14., 47., 6., 34., 5., 13., 3., 2., 0., 2., 0., 19., 10., 9., 3., 39., 3., 11., 6., 3., 4., 0., 0., 2., 3., 8., 1., 6., 2., 5., 0., 1., 6., 137., 7., 1888., 87., 91., 231., 90., 112., 84., 29., 8., 21., 13., 3., 1., 5., 6., 3., 8., 9., 40., 13., 28., 18., 40., 11., 11., 2., 6., 8., 9., 1., 8., 5., 13., 6., 0., 5., 4., 17., 1., 0., 10., 4., 5., 0., 6., 2., 4., 35., 3., 13., 1., 17., 1., 18., 4., 2., 6., 5., 31., 3., 23., 3., 5., 7., 3., 28., 7., 16., 4.,

15., 2., 1., 11., 22., 6., 32., 0., 12., 144., 1., 22., 216., 4., 24., 8., 1., 3., 91., 1., 10., 310., 42., 325., 34., 24., 0., 4., 8., 3., 41., 32., 242., 47., 11., 162., 20., 39., 3., 0., 1., 10., 16., 81., 18., 82., 17., 37., 57., 11., 2., 3., 17., 4., 64., 5., 41., 11., 21., 5., 12., 4., 1., 0., 1., 0., 31., 4., 16., 2., 26., 5., 12., 6., 5., 3., 1., 0., 1., 4., 5., 1., 5., 2., 12., 0., 2., 6., 158., 10., 1888., 81., 98., 213., 101., 127., 68., 20., 9., 16., 14., 0., 1., 13., 3., 3., 12., 6., 32., 14., 33., 14., 45., 5., 12., 5., 7., 5., 4., 1., 4., 5., 13., 5., 0., 4., 5., 16., 2., 0., 8., 4., 1., 0., 6., 3., 5., 30., 2., 9., 1., 13., 2., 18., 1., 4., 7., 6., 27., 8., 33., 7., 4., 3., 4., 27., 4., 9., 2.,

14., 2., 3., 8., 6., 3., 8., 1., 5., 2., 1., 16., 22., 2., 13., 2., 1., 0., 20., 0., 3., 21., 9., 30., 27., 4., 0., 0., 1., 2., 7., 8., 14., 22., 0., 13., 2., 23., 8., 2., 1., 2., 3., 11., 16., 13., 51., 14., 24., 6., 5., 1., 4., 1., 6., 6., 10., 6., 6., 16., 2., 18., 5., 3., 0., 0., 8., 0., 4., 3., 6., 7., 3., 7., 1., 3., 1., 1., 1., 2., 0., 0., 2., 1., 1., 4., 2., 3., 0., 3., 3., 2., 1., 0., 3., 8., 0., 0., 2., 1., 2., 3., 1., 4., 0., 2., 7., 0., 0., 0., 0., 5., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 4., 4., 10., 1., 5., 2., 4., 16., 0., 12., 36., 3., 17., 2., 4., 3., 25., 2., 1., 12., 8., 17., 25., 9., 0., 3., 6., 2., 8., 5., 30., 13., 2., 17., 0., 15., 9., 1., 2., 3., 2., 14., 20., 21., 46., 13., 16., 7., 1., 2., 4., 0., 8., 7., 13., 6., 13., 14., 1., 20., 10., 3., 1., 0., 2., 2., 2., 2., 7., 3., 4., 2., 1., 6., 1., 1., 1., 0., 1., 0., 3., 5., 0., 6., 2., 2., 4., 1., 5., 3., 4., 2., 4., 9., 3., 0., 1., 0., 2., 8., 2., 1., 2., 3., 0., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 1., 6., 6., 6., 4., 1., 4., 19., 0., 14., 22., 1., 21., 2., 2., 1., 26., 1., 5., 16., 16., 28., 25., 4., 0., 2., 3., 1., 9., 12., 18., 18., 7., 22., 6., 12., 7., 1., 1., 2., 1., 8., 9., 16., 49., 11., 19., 7., 6., 2., 3., 3., 11., 4., 9., 6., 6., 11., 10., 25., 9., 3., 2., 0., 7., 1., 2., 1., 6., 1., 4., 5., 1., 4., 5., 2., 0., 1., 2., 0., 0., 1., 0., 3., 3., 3., 2., 0., 2., 1., 1., 4., 1., 9., 2., 0., 1., 4., 3., 0., 2., 3., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 2., 5., 3., 8., 0., 9., 16., 1., 14., 14., 3., 21., 8., 0., 0., 17., 3., 4., 19., 9., 27., 25., 6., 2., 1., 2., 0., 8., 8., 22., 11., 3., 12., 2., 17., 5., 3., 1., 3., 0., 17., 14., 17., 43., 16., 15., 11., 2., 0., 3., 2., 7., 2., 10., 4., 7., 14., 6., 22., 5., 3., 0., 3., 6., 0., 3., 2., 3., 5., 3., 5., 4., 1., 4., 2., 0., 0., 3., 0., 2., 9., 0., 9., 3., 1., 0., 0., 4., 1., 2., 0., 2., 4., 3., 0., 1., 0., 2., 2., 2., 5., 1., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 8., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 4., 7., 1., 8., 0., 6., 22., 0., 12., 28., 2., 10., 5., 2., 0., 13., 0., 7., 15., 13., 25., 22., 10., 1., 0., 1., 3., 5., 7., 23., 16., 5., 9., 1., 14., 7., 3., 2., 8., 2., 14., 13., 25., 41., 17., 16., 12., 4., 1., 2., 3., 8., 2., 10., 9., 2., 18., 7., 33., 8., 3., 3., 1., 10., 2., 3., 2., 7., 4., 1., 5., 1., 3., 2., 3., 2., 0., 7., 0., 2., 3., 2., 7., 3., 5., 1., 4., 6., 0., 0., 1., 3., 8., 4., 0., 1., 2., 2., 0., 0., 1., 0., 0., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 3., 2., 15., 4., 8., 0., 5., 22., 1., 15., 12., 0., 10., 3., 5., 4., 16., 1., 2., 13., 13., 33., 34., 4., 0., 0., 4., 1., 17., 11., 23., 16., 5., 15., 3., 13., 16., 1., 0., 2., 0., 11., 10., 9., 43., 13., 28., 9., 3., 1., 3., 2., 5., 4., 12., 5., 6., 20., 5., 23., 11., 6., 1., 2., 5., 3., 0., 0., 4., 3., 4., 5., 2., 4., 1., 3., 1., 0., 2., 0., 1., 1., 1., 6., 3., 4., 2., 2., 5., 2., 2., 1., 5., 7., 3., 0., 5., 3., 4., 2., 0., 2., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 4., 2., 6., 2., 5., 2., 3., 34., 0., 12., 28., 0., 19., 1., 1., 3., 20., 2., 7., 14., 13., 21., 40., 5., 2., 3., 6., 3., 5., 8., 33., 25., 4., 16., 1., 19., 8., 2., 0., 2., 1., 13., 13., 9., 45., 13., 15., 6., 0., 2., 8., 2., 4., 0., 8., 6., 15., 10., 6., 28., 4., 4., 2., 2., 3., 2., 5., 2., 6., 2., 3., 4., 2., 2., 3., 1., 2., 5., 4., 0., 2., 0., 2., 4., 4., 2., 3., 4., 5., 2., 1., 0., 4., 8., 0., 0., 2., 3., 2., 2., 1., 3., 3., 1., 4., 0., 0., 0., 0., 5., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 0., 4., 7., 6., 2., 5., 2., 5., 16., 1., 9., 25., 0., 22., 4., 0., 2., 28., 1., 1., 29., 9., 31., 21., 8., 1., 1., 3., 0., 11., 4., 25., 15., 4., 12., 6., 18., 8., 2., 1., 1., 4., 10., 10., 17., 42., 13., 18., 16., 2., 1., 2., 1., 5., 4., 9., 3., 11., 18., 10., 25., 10., 0., 1., 2., 9., 1., 6., 1., 2., 5., 7., 4., 2., 2., 4., 3., 1., 0., 2., 0., 1., 0., 4., 10., 3., 4., 5., 1., 5., 1., 2., 0., 2., 3., 2., 0., 1., 7., 3., 0., 1., 0., 2., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 4., 3., 4., 3., 1., 9., 0., 8., 16., 0., 15., 20., 0., 20., 3., 0., 3., 14., 0., 5., 32., 10., 22., 25., 7., 1., 0., 4., 2., 14., 6., 21., 17., 6., 15., 5., 14., 11., 0., 1., 7., 3., 8., 11., 16., 53., 8., 18., 13., 4., 1., 5., 4., 7., 4., 3., 3., 7., 14., 4., 27., 5., 4., 1., 0., 5., 2., 4., 3., 2., 3., 2., 1., 1., 2., 0., 3., 0., 2., 0., 0., 2., 3., 1., 8., 1., 2., 0., 3., 1., 0., 2., 1., 1., 7., 4., 0., 2., 1., 2., 1., 3., 0., 1., 1., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 3., 0., 6., 10., 2., 6., 2., 3., 27., 1., 14., 11., 0., 17., 4., 1., 4., 12., 0., 5., 20., 13., 31., 20., 3., 0., 0., 5., 1., 10., 8., 11., 19., 0., 9., 4., 15., 9., 1., 1., 5., 6., 6., 13., 15., 35., 16., 17., 7., 4., 2., 3., 5., 6., 3., 7., 2., 7., 17., 3., 18., 6., 2., 1., 1., 4., 0., 5., 3., 2., 1., 5., 6., 3., 3., 3., 2., 4., 1., 2., 0., 2., 4., 3., 7., 1., 1., 2., 2., 6., 2., 5., 0., 3., 13., 2., 0., 2., 0., 2., 1., 4., 1., 3., 1., 4., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 0., 6., 11., 2., 4., 0., 5., 11., 2., 13., 25., 1., 12., 4., 3., 1., 13., 3., 4., 34., 14., 32., 29., 13., 1., 0., 2., 3., 9., 10., 28., 13., 2., 14., 3., 8., 5., 2., 1., 4., 2., 11., 15., 20., 37., 14., 24., 14., 3., 2., 1., 3., 10., 1., 7., 5., 9., 14., 8., 18., 8., 1., 0., 1., 8., 0., 2., 2., 5., 2., 5., 2., 4., 3., 1., 0., 0., 1., 2., 0., 3., 9., 1., 2., 0., 4., 2., 1., 5., 1., 3., 4., 1., 12., 3., 0., 4., 3., 2., 2., 1., 1., 1., 0., 3., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 3., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 0., 1., 3., 1., 7., 0., 5., 28., 2., 17., 18., 1., 12., 3., 2., 2., 24., 7., 2., 23., 6., 27., 24., 5., 0., 1., 0., 2., 8., 12., 17., 10., 1., 9., 6., 10., 7., 3., 1., 3., 2., 9., 13., 13., 41., 7., 23., 9., 6., 1., 8., 3., 12., 2., 7., 8., 6., 12., 2., 16., 14., 4., 1., 0., 8., 1., 3., 1., 7., 5., 3., 8., 4., 2., 3., 0., 0., 3., 3., 0., 4., 3., 1., 6., 2., 7., 4., 3., 1., 0., 4., 0., 3., 6., 3., 0., 3., 3., 2., 2., 1., 2., 3., 2., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 0., 2., 1., 5., 5., 10., 0., 5., 17., 1., 8., 14., 0., 25., 3., 0., 4., 10., 0., 5., 29., 12., 27., 21., 6., 0., 0., 4., 2., 6., 3., 21., 21., 2., 22., 2., 16., 7., 2., 1., 3., 2., 12., 14., 16., 37., 14., 20., 8., 5., 1., 3., 2., 7., 2., 13., 4., 13., 10., 7., 20., 10., 1., 0., 0., 4., 2., 3., 0., 3., 5., 1., 6., 8., 5., 3., 1., 1., 1., 2., 0., 1., 0., 3., 6., 0., 8., 1., 1., 5., 0., 5., 2., 3., 4., 0., 0., 6., 1., 1., 2., 1., 2., 3., 0., 3., 0., 0., 0., 0., 4., 0., 0., 1., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 3., 9., 2., 5., 0., 3., 15., 2., 9., 13., 0., 9., 1., 0., 2., 19., 4., 1., 27., 10., 28., 28., 8., 0., 2., 5., 1., 4., 6., 28., 10., 2., 12., 3., 11., 13., 4., 1., 1., 4., 13., 7., 15., 43., 12., 25., 10., 1., 2., 8., 4., 5., 2., 11., 9., 8., 17., 7., 29., 5., 4., 3., 0., 6., 0., 1., 3., 8., 0., 4., 4., 1., 6., 4., 2., 1., 3., 0., 0., 4., 3., 1., 6., 1., 5., 4., 0., 2., 2., 0., 2., 3., 7., 3., 0., 2., 3., 1., 2., 3., 1., 3., 0., 1., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 1., 1., 8., 4., 8., 1., 7., 24., 3., 9., 23., 0., 16., 2., 0., 1., 10., 3., 5., 37., 12., 24., 19., 5., 0., 2., 1., 2., 7., 9., 22., 18., 3., 14., 1., 15., 9., 1., 3., 1., 2., 10., 9., 15., 41., 10., 29., 9., 6., 2., 5., 2., 6., 3., 13., 8., 12., 15., 11., 18., 8., 4., 0., 0., 11., 0., 7., 1., 7., 4., 3., 4., 2., 4., 6., 2., 1., 1., 3., 0., 1., 2., 3., 3., 2., 3., 5., 2., 6., 1., 0., 2., 2., 1., 1., 0., 1., 2., 2., 2., 3., 3., 3., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 1., 3., 12., 6., 3., 1., 5., 11., 0., 16., 25., 1., 14., 2., 0., 5., 21., 0., 6., 27., 16., 26., 35., 6., 1., 1., 7., 0., 9., 9., 21., 14., 2., 10., 3., 15., 13., 1., 1., 3., 2., 10., 10., 17., 41., 11., 15., 11., 4., 1., 7., 3., 12., 3., 16., 11., 10., 15., 6., 23., 5., 4., 2., 1., 5., 0., 1., 2., 4., 4., 3., 0., 3., 3., 2., 1., 0., 2., 5., 0., 4., 4., 0., 10., 2., 3., 4., 1., 2., 1., 2., 2., 4., 9., 1., 0., 2., 1., 1., 4., 2., 4., 2., 1., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 5., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 2., 5., 1., 0., 7., 2., 4., 31., 0., 21., 25., 0., 10., 0., 0., 0., 15., 4., 6., 23., 10., 15., 25., 7., 0., 1., 5., 1., 15., 4., 32., 16., 1., 16., 2., 16., 8., 3., 0., 3., 3., 13., 21., 15., 50., 8., 21., 10., 6., 3., 10., 3., 8., 5., 9., 5., 6., 18., 6., 27., 2., 1., 0., 4., 5., 1., 3., 2., 6., 1., 3., 6., 3., 2., 1., 1., 2., 3., 0., 0., 1., 2., 1., 10., 0., 2., 3., 2., 4., 1., 1., 1., 2., 2., 1., 0., 0., 0., 2., 3., 3., 1., 1., 2., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 2., 11., 2., 4., 2., 4., 14., 3., 3., 23., 0., 17., 3., 0., 4., 20., 2., 4., 21., 10., 21., 30., 8., 3., 0., 3., 2., 8., 6., 25., 14., 3., 22., 4., 8., 12., 0., 1., 4., 0., 11., 10., 19., 51., 14., 14., 20., 6., 0., 3., 2., 5., 4., 6., 2., 9., 16., 4., 21., 5., 2., 2., 2., 7., 0., 3., 1., 2., 0., 4., 8., 2., 1., 1., 2., 0., 2., 2., 0., 4., 0., 3., 13., 2., 3., 1., 5., 5., 2., 2., 1., 0., 7., 1., 0., 2., 0., 2., 0., 0., 2., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 1., 3., 7., 1., 7., 1., 8., 19., 1., 13., 26., 1., 21., 2., 0., 1., 26., 3., 5., 27., 8., 18., 25., 5., 1., 0., 3., 3., 8., 9., 23., 15., 2., 14., 7., 19., 7., 3., 2., 5., 2., 17., 13., 15., 47., 13., 29., 11., 5., 0., 5., 4., 7., 5., 5., 6., 2., 18., 10., 16., 6., 7., 0., 1., 9., 0., 5., 2., 4., 3., 3., 4., 6., 4., 2., 1., 0., 5., 4., 0., 0., 0., 3., 6., 2., 4., 2., 3., 1., 1., 2., 0., 0., 6., 3., 0., 1., 1., 2., 1., 2., 1., 1., 1., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 1., 8., 0., 8., 1., 5., 26., 0., 19., 13., 2., 21., 4., 4., 0., 11., 1., 5., 12., 7., 28., 24., 7., 2., 1., 4., 1., 6., 4., 25., 12., 3., 15., 4., 12., 5., 0., 0., 3., 4., 15., 13., 15., 49., 8., 18., 10., 4., 3., 6., 0., 6., 0., 6., 4., 8., 20., 6., 33., 6., 4., 2., 1., 8., 0., 1., 1., 7., 3., 4., 2., 2., 1., 4., 3., 1., 1., 3., 0., 1., 1., 1., 5., 2., 8., 2., 1., 6., 2., 3., 1., 3., 2., 2., 0., 0., 4., 2., 1., 1., 1., 4., 1., 1., 0., 0., 0., 0., 5., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 2., 5., 6., 5., 5., 1., 6., 28., 1., 10., 24., 0., 20., 3., 3., 3., 17., 4., 0., 10., 18., 27., 27., 5., 0., 1., 0., 1., 8., 6., 14., 21., 4., 20., 5., 12., 13., 2., 2., 5., 2., 13., 10., 19., 35., 9., 14., 6., 5., 2., 7., 2., 7., 2., 8., 10., 7., 17., 4., 25., 9., 3., 0., 1., 7., 2., 5., 3., 3., 7., 1., 5., 3., 9., 2., 0., 1., 2., 4., 0., 2., 4., 1., 6., 4., 0., 0., 4., 12., 2., 2., 0., 1., 13., 3., 0., 1., 2., 4., 1., 4., 5., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 6., 4., 6., 7., 4., 8., 17., 3., 11., 16., 2., 8., 2., 3., 1., 14., 0., 6., 25., 14., 30., 32., 10., 2., 2., 1., 0., 12., 7., 16., 10., 4., 23., 6., 15., 9., 0., 1., 3., 1., 13., 14., 15., 49., 18., 19., 10., 1., 2., 6., 2., 11., 3., 9., 7., 14., 13., 7., 21., 8., 7., 2., 1., 6., 1., 5., 2., 5., 0., 3., 3., 7., 2., 3., 0., 2., 2., 3., 0., 2., 2., 1., 6., 1., 7., 3., 0., 2., 3., 2., 0., 0., 8., 3., 0., 1., 0., 3., 3., 1., 3., 2., 3., 5., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 0., 5., 12., 0., 19., 0., 3., 43., 2., 10., 59., 1., 10., 3., 0., 3., 46., 6., 6., 66., 15., 90., 18., 2., 0., 0., 1., 0., 11., 11., 37., 14., 1., 37., 35., 11., 4., 0., 0., 9., 3., 22., 9., 33., 9., 11., 7., 6., 2., 0., 11., 5., 15., 6., 9., 3., 6., 6., 2., 47., 9., 5., 4., 0., 18., 3., 7., 3., 13., 2., 5., 0., 1., 3., 0., 3., 1., 10., 6., 3., 2., 1., 3., 0., 0., 0., 0., 0., 8., 1., 4., 4., 4., 0., 2., 0., 2., 0., 0., 0., 0., 3., 3., 0., 2., 0., 2., 0., 2., 0., 0., 0., 0., 0., 4., 3., 3., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 25., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 3., 1., 5., 7., 0., 18., 4., 6., 32., 0., 6., 82., 1., 8., 5., 0., 1., 45., 10., 8., 77., 11., 81., 18., 1., 0., 2., 5., 3., 3., 10., 44., 22., 2., 46., 32., 15., 6., 0., 2., 3., 3., 17., 8., 10., 11., 18., 5., 2., 3., 0., 11., 4., 8., 3., 15., 3., 9., 6., 2., 35., 8., 4., 0., 0., 6., 0., 8., 0., 8., 2., 8., 2., 0., 2., 0., 6., 4., 9., 9., 1., 6., 1., 2., 0., 0., 0., 0., 0., 10., 0., 3., 4., 2., 1., 2., 0., 1., 0., 1., 0., 2., 4., 4., 0., 3., 0., 0., 0., 1., 0., 0., 0., 1., 0., 1., 3., 2., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 18., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 2., 12., 0., 13., 3., 6., 65., 2., 7., 48., 1., 3., 2., 0., 5., 93., 8., 7., 69., 19., 85., 12., 2., 0., 1., 4., 1., 10., 7., 59., 15., 1., 35., 29., 16., 2., 0., 1., 7., 4., 31., 6., 21., 7., 12., 1., 3., 2., 0., 7., 1., 20., 4., 20., 3., 9., 1., 2., 41., 7., 3., 3., 0., 13., 3., 3., 4., 8., 1., 2., 1., 1., 2., 0., 3., 1., 13., 12., 5., 5., 2., 4., 0., 0., 0., 0., 0., 16., 3., 2., 5., 2., 0., 1., 0., 0., 0., 1., 0., 1., 5., 2., 0., 3., 0., 1., 0., 1., 0., 0., 0., 1., 0., 2., 2., 3., 0., 0., 0., 4., 0., 5., 0., 0., 0., 0., 28., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 4., 3., 5., 18., 0., 17., 3., 6., 62., 1., 11., 66., 2., 5., 1., 0., 2., 73., 11., 9., 70., 9., 99., 12., 4., 0., 2., 2., 3., 6., 9., 58., 14., 3., 32., 38., 16., 8., 0., 1., 7., 3., 17., 7., 26., 9., 12., 6., 1., 2., 0., 13., 4., 13., 5., 25., 1., 6., 5., 0., 32., 4., 5., 3., 0., 11., 2., 11., 2., 8., 1., 1., 1., 2., 2., 0., 6., 1., 15., 14., 4., 1., 1., 1., 0., 0., 0., 0., 0., 13., 2., 1., 5., 2., 0., 0., 0., 3., 0., 1., 0., 2., 5., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 0., 3., 3., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 21., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 2., 1., 14., 0., 19., 1., 8., 44., 1., 7., 65., 0., 5., 0., 0., 0., 52., 5., 15., 84., 19., 79., 6., 2., 0., 2., 4., 3., 17., 9., 49., 12., 1., 39., 35., 18., 10., 0., 0., 1., 3., 25., 7., 18., 5., 14., 8., 3., 3., 0., 12., 3., 11., 2., 10., 4., 6., 3., 2., 38., 8., 10., 4., 0., 17., 2., 11., 1., 11., 3., 5., 0., 3., 2., 0., 6., 0., 15., 5., 3., 2., 1., 4., 0., 0., 0., 0., 0., 14., 1., 2., 1., 1., 1., 0., 0., 1., 0., 1., 0., 0., 0., 2., 0., 5., 0., 1., 0., 1., 0., 0., 0., 2., 0., 0., 1., 1., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 22., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 1., 4., 8., 23., 6., 33., 3., 19., 167., 5., 31., 198., 6., 18., 8., 0., 5., 83., 1., 20., 289., 51., 305., 42., 11., 0., 2., 7., 6., 47., 30., 245., 45., 5., 162., 13., 40., 6., 0., 1., 24., 11., 91., 30., 72., 12., 28., 41., 13., 1., 1., 23., 12., 40., 8., 52., 14., 26., 7., 6., 11., 1., 0., 3., 0., 28., 3., 14., 4., 22., 4., 10., 8., 2., 3., 3., 1., 0., 0., 9., 4., 5., 2., 7., 2., 2., 7., 137., 5., 1855., 78., 90., 230., 97., 139., 65., 9., 9., 13., 7., 2., 1., 6., 6., 4., 10., 7., 40., 20., 38., 15., 37., 8., 15., 6., 2., 3., 4., 1., 0., 6., 14., 4., 0., 2., 5., 10., 3., 0., 8., 4., 3., 0., 9., 1., 2., 21., 4., 9., 2., 12., 5., 22., 2., 0., 4., 10., 24., 7., 26., 3., 5., 7., 6., 34., 4., 18., 8.,

15., 3., 2., 12., 23., 4., 20., 1., 16., 161., 3., 29., 197., 1., 17., 9., 2., 6., 97., 3., 15., 305., 40., 292., 29., 19., 0., 2., 8., 5., 47., 38., 214., 44., 6., 130., 11., 47., 7., 0., 2., 17., 9., 80., 21., 81., 12., 48., 65., 8., 2., 3., 27., 2., 39., 18., 51., 9., 36., 6., 8., 8., 4., 0., 1., 0., 40., 3., 10., 3., 27., 9., 4., 5., 3., 4., 4., 0., 3., 2., 18., 3., 7., 1., 7., 0., 2., 4., 133., 5., 1924., 91., 99., 247., 96., 117., 70., 13., 6., 18., 15., 1., 5., 7., 3., 4., 18., 8., 32., 11., 46., 15., 33., 6., 7., 4., 6., 8., 3., 3., 1., 2., 5., 2., 0., 4., 4., 11., 1., 0., 6., 3., 5., 0., 5., 2., 3., 33., 2., 14., 4., 11., 3., 30., 4., 4., 1., 5., 31., 7., 27., 8., 6., 6., 9., 41., 5., 9., 6.,

12., 1., 1., 7., 21., 9., 32., 2., 22., 174., 4., 27., 262., 9., 11., 4., 0., 5., 65., 0., 15., 271., 41., 329., 42., 16., 0., 0., 8., 4., 41., 29., 238., 50., 9., 165., 16., 45., 6., 0., 3., 21., 8., 69., 12., 83., 18., 35., 40., 11., 1., 2., 28., 11., 32., 11., 41., 13., 22., 5., 12., 11., 2., 0., 1., 0., 31., 4., 18., 3., 25., 5., 9., 4., 4., 3., 3., 4., 6., 1., 14., 4., 4., 2., 10., 2., 0., 6., 137., 12., 1862., 87., 103., 214., 92., 125., 56., 15., 18., 22., 12., 0., 2., 3., 9., 3., 6., 8., 40., 15., 29., 15., 37., 13., 13., 2., 7., 5., 1., 0., 2., 3., 8., 0., 0., 7., 5., 13., 2., 0., 9., 6., 2., 0., 1., 2., 3., 37., 7., 13., 3., 10., 2., 21., 0., 2., 6., 4., 26., 3., 40., 5., 5., 8., 6., 32., 6., 13., 6.,

18., 1., 3., 1., 21., 10., 26., 1., 23., 159., 2., 22., 242., 10., 17., 5., 1., 9., 86., 0., 15., 280., 42., 351., 41., 27., 0., 3., 11., 6., 31., 29., 229., 44., 3., 160., 16., 40., 4., 0., 2., 18., 3., 77., 23., 101., 13., 36., 47., 6., 2., 0., 18., 8., 32., 13., 55., 16., 25., 3., 10., 4., 1., 0., 1., 0., 18., 4., 18., 2., 34., 3., 16., 8., 5., 4., 0., 1., 3., 2., 13., 6., 7., 1., 7., 0., 0., 6., 143., 9., 1870., 84., 99., 214., 112., 103., 75., 13., 10., 17., 10., 1., 1., 14., 5., 3., 8., 7., 33., 17., 32., 23., 58., 7., 14., 3., 7., 7., 3., 4., 3., 3., 10., 4., 0., 1., 8., 10., 0., 0., 11., 4., 3., 0., 7., 3., 3., 31., 0., 17., 3., 15., 3., 22., 2., 0., 2., 2., 23., 7., 32., 6., 7., 11., 6., 32., 8., 15., 4.,

22., 1., 1., 8., 17., 9., 35., 0., 14., 167., 2., 24., 229., 3., 13., 13., 2., 3., 82., 3., 16., 300., 48., 314., 55., 15., 0., 0., 7., 2., 44., 42., 245., 39., 5., 165., 5., 41., 3., 0., 1., 21., 8., 72., 21., 96., 23., 36., 48., 11., 2., 4., 16., 6., 36., 9., 45., 6., 35., 8., 11., 9., 0., 0., 1., 0., 22., 8., 14., 1., 26., 7., 9., 8., 1., 4., 1., 1., 4., 2., 14., 1., 8., 1., 3., 1., 0., 2., 138., 10., 1835., 80., 109., 219., 103., 119., 65., 19., 9., 14., 16., 0., 2., 6., 5., 2., 11., 3., 32., 18., 29., 10., 37., 4., 8., 4., 3., 10., 3., 0., 2., 1., 4., 2., 0., 5., 2., 11., 0., 0., 2., 4., 1., 0., 5., 2., 2., 30., 4., 14., 0., 15., 4., 19., 0., 5., 3., 4., 37., 6., 29., 10., 5., 3., 8., 44., 5., 10., 4.,

9., 2., 1., 5., 10., 5., 8., 2., 6., 18., 1., 23., 23., 1., 10., 3., 2., 0., 16., 0., 7., 21., 19., 32., 16., 4., 2., 2., 2., 2., 4., 7., 30., 20., 2., 12., 3., 12., 10., 1., 0., 5., 4., 10., 12., 12., 44., 5., 20., 13., 4., 2., 8., 4., 4., 6., 7., 6., 9., 9., 13., 20., 11., 4., 0., 0., 6., 0., 3., 1., 3., 3., 3., 1., 2., 4., 3., 0., 1., 5., 2., 0., 0., 6., 2., 10., 1., 4., 3., 2., 5., 0., 2., 1., 1., 3., 2., 0., 3., 2., 2., 0., 3., 1., 1., 0., 4., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 5., 5., 2., 4., 1., 8., 21., 0., 16., 22., 1., 8., 4., 0., 3., 25., 2., 5., 31., 12., 20., 26., 3., 1., 0., 2., 3., 7., 8., 19., 19., 4., 10., 6., 19., 10., 3., 0., 5., 1., 13., 9., 17., 48., 6., 14., 7., 7., 0., 5., 2., 5., 3., 11., 5., 7., 18., 11., 25., 10., 8., 0., 0., 6., 4., 2., 2., 3., 2., 3., 2., 2., 1., 0., 3., 0., 3., 4., 0., 1., 4., 5., 6., 0., 4., 2., 2., 4., 0., 1., 1., 4., 9., 4., 0., 2., 3., 1., 4., 4., 1., 5., 0., 1., 0., 0., 0., 0., 4., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 0., 8., 13., 2., 5., 1., 4., 21., 2., 22., 17., 2., 13., 4., 1., 5., 12., 4., 6., 16., 15., 24., 27., 5., 0., 0., 1., 2., 11., 4., 13., 21., 5., 19., 3., 13., 7., 3., 1., 6., 5., 10., 13., 19., 61., 8., 18., 10., 2., 2., 11., 4., 9., 5., 15., 3., 12., 18., 3., 19., 8., 3., 0., 0., 4., 1., 3., 2., 7., 2., 4., 4., 2., 3., 4., 0., 0., 4., 0., 0., 3., 0., 3., 8., 1., 5., 1., 3., 4., 3., 1., 0., 4., 7., 3., 0., 7., 2., 2., 1., 4., 4., 2., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 7., 4., 3., 5., 0., 6., 14., 1., 21., 24., 1., 12., 3., 3., 2., 22., 2., 4., 27., 10., 31., 21., 5., 1., 1., 1., 2., 4., 3., 24., 13., 4., 17., 5., 12., 2., 2., 1., 6., 2., 19., 10., 14., 54., 13., 18., 9., 3., 2., 7., 4., 7., 3., 11., 6., 10., 15., 2., 28., 9., 5., 1., 4., 5., 1., 2., 0., 6., 2., 7., 6., 2., 5., 3., 3., 3., 4., 5., 0., 1., 2., 3., 4., 2., 5., 1., 1., 4., 2., 2., 0., 3., 7., 0., 0., 2., 2., 1., 3., 4., 2., 2., 3., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 6., 10., 1., 3., 0., 4., 10., 2., 5., 22., 0., 12., 2., 2., 1., 20., 2., 2., 24., 11., 29., 27., 5., 1., 2., 4., 1., 7., 9., 30., 22., 2., 17., 3., 6., 12., 3., 0., 1., 0., 19., 11., 16., 49., 13., 18., 11., 6., 0., 1., 2., 6., 2., 12., 3., 7., 15., 5., 20., 8., 4., 2., 2., 1., 4., 3., 3., 3., 3., 6., 3., 0., 8., 3., 1., 1., 2., 0., 0., 1., 3., 3., 5., 0., 5., 5., 3., 2., 1., 3., 1., 0., 7., 2., 0., 2., 0., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 2., 4., 3., 11., 2., 2., 0., 4., 16., 0., 16., 29., 0., 18., 4., 0., 3., 19., 2., 4., 30., 15., 27., 25., 5., 3., 1., 3., 1., 5., 6., 22., 14., 1., 12., 2., 13., 10., 2., 2., 5., 4., 7., 13., 28., 45., 9., 23., 13., 2., 1., 5., 2., 4., 1., 13., 7., 7., 16., 6., 24., 11., 3., 2., 1., 5., 2., 4., 2., 8., 2., 3., 4., 0., 2., 1., 0., 0., 0., 1., 0., 2., 2., 0., 7., 2., 4., 2., 0., 4., 0., 1., 1., 1., 7., 1., 0., 1., 3., 3., 3., 1., 1., 2., 0., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 0., 1., 4., 2., 10., 1., 10., 18., 2., 8., 15., 0., 15., 1., 0., 2., 19., 2., 2., 36., 10., 16., 25., 7., 2., 1., 2., 2., 4., 7., 24., 16., 4., 11., 3., 14., 6., 2., 1., 6., 1., 21., 10., 16., 31., 9., 24., 11., 0., 2., 4., 1., 9., 4., 7., 5., 11., 18., 5., 19., 6., 3., 2., 1., 2., 0., 1., 0., 5., 2., 5., 7., 3., 3., 4., 2., 1., 0., 3., 0., 0., 2., 1., 8., 2., 5., 1., 2., 3., 0., 1., 1., 2., 5., 1., 0., 2., 3., 3., 2., 2., 0., 4., 1., 2., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 6., 2., 10., 2., 8., 0., 8., 29., 0., 16., 25., 1., 12., 3., 1., 1., 9., 1., 10., 14., 16., 32., 30., 6., 0., 2., 5., 1., 6., 7., 28., 12., 1., 14., 3., 8., 13., 1., 0., 5., 6., 16., 8., 17., 52., 14., 15., 14., 7., 1., 7., 2., 2., 2., 9., 5., 11., 12., 9., 22., 11., 4., 2., 1., 5., 1., 2., 2., 4., 4., 6., 3., 2., 4., 1., 1., 1., 5., 2., 0., 2., 0., 1., 6., 1., 2., 2., 3., 2., 2., 0., 0., 3., 4., 0., 0., 4., 2., 1., 0., 2., 3., 2., 1., 3., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 3., 10., 5., 2., 1., 4., 32., 0., 10., 24., 1., 8., 2., 0., 1., 12., 3., 2., 25., 13., 24., 27., 4., 2., 0., 3., 1., 11., 2., 31., 18., 1., 9., 2., 12., 6., 8., 1., 9., 2., 10., 11., 22., 52., 15., 23., 7., 6., 1., 5., 4., 5., 3., 9., 5., 10., 16., 4., 15., 9., 2., 0., 0., 6., 1., 2., 2., 3., 0., 4., 4., 2., 7., 3., 0., 0., 4., 2., 0., 2., 0., 0., 2., 4., 5., 0., 1., 2., 0., 4., 2., 0., 11., 2., 0., 0., 3., 4., 3., 5., 2., 1., 0., 2., 0., 0., 0., 0., 5., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 0., 4., 8., 5., 8., 0., 10., 19., 1., 10., 18., 1., 10., 1., 1., 0., 19., 2., 3., 18., 13., 25., 29., 7., 0., 2., 2., 0., 12., 1., 27., 21., 2., 21., 4., 16., 9., 1., 1., 1., 1., 20., 10., 22., 51., 14., 24., 8., 3., 1., 7., 2., 6., 1., 12., 8., 2., 15., 2., 22., 8., 3., 0., 1., 10., 2., 4., 4., 5., 3., 1., 4., 1., 1., 4., 0., 0., 1., 0., 0., 2., 3., 2., 8., 2., 4., 1., 0., 7., 2., 3., 1., 4., 8., 3., 0., 2., 7., 2., 3., 2., 0., 2., 1., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 4., 2., 10., 5., 6., 0., 4., 41., 0., 2., 22., 1., 18., 2., 0., 4., 18., 2., 2., 28., 15., 35., 22., 6., 1., 1., 2., 2., 10., 4., 26., 13., 5., 20., 3., 14., 6., 1., 0., 0., 0., 13., 10., 15., 34., 12., 22., 8., 3., 1., 8., 6., 2., 0., 9., 7., 10., 19., 7., 22., 8., 2., 1., 0., 2., 1., 3., 0., 2., 5., 3., 5., 2., 2., 2., 2., 0., 2., 3., 0., 2., 1., 3., 12., 3., 3., 3., 5., 4., 2., 4., 1., 1., 12., 0., 0., 1., 1., 3., 3., 0., 2., 1., 1., 0., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 2., 3., 3., 5., 8., 0., 6., 11., 0., 9., 20., 2., 12., 6., 0., 1., 17., 2., 0., 21., 10., 30., 32., 3., 2., 1., 3., 5., 8., 8., 31., 21., 1., 13., 4., 6., 12., 5., 1., 3., 4., 9., 8., 16., 40., 11., 13., 11., 1., 0., 5., 2., 11., 7., 12., 3., 6., 19., 6., 24., 8., 1., 3., 2., 8., 0., 8., 4., 8., 0., 3., 6., 1., 2., 4., 3., 3., 4., 0., 0., 2., 2., 1., 6., 1., 5., 0., 4., 7., 3., 1., 2., 2., 6., 2., 0., 1., 3., 2., 3., 1., 3., 2., 1., 4., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 3., 6., 11., 4., 6., 1., 3., 34., 1., 12., 18., 1., 15., 4., 1., 2., 24., 4., 7., 29., 13., 12., 22., 4., 2., 0., 3., 3., 6., 7., 33., 16., 4., 13., 6., 10., 9., 2., 2., 2., 2., 16., 15., 17., 52., 12., 27., 8., 3., 1., 6., 0., 2., 2., 14., 7., 8., 16., 11., 24., 8., 2., 1., 0., 9., 0., 4., 2., 4., 2., 5., 6., 0., 10., 2., 1., 2., 2., 3., 0., 2., 2., 0., 3., 3., 3., 2., 0., 4., 1., 1., 1., 1., 3., 2., 0., 0., 0., 1., 2., 3., 6., 2., 0., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 1., 4., 4., 4., 2., 6., 0., 8., 15., 0., 13., 14., 0., 15., 3., 0., 0., 19., 2., 2., 36., 13., 23., 22., 5., 2., 0., 6., 0., 10., 4., 27., 24., 3., 22., 4., 13., 8., 0., 1., 5., 2., 14., 16., 25., 62., 15., 24., 10., 3., 2., 6., 5., 7., 4., 12., 7., 12., 7., 7., 17., 13., 2., 0., 1., 7., 2., 5., 3., 4., 3., 4., 4., 3., 2., 5., 3., 1., 3., 3., 0., 4., 1., 0., 8., 0., 4., 2., 1., 2., 0., 5., 0., 1., 7., 1., 0., 1., 1., 0., 3., 2., 1., 0., 2., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 1., 2., 4., 4., 2., 1., 7., 32., 1., 9., 29., 0., 12., 7., 0., 1., 20., 2., 5., 15., 13., 26., 38., 4., 0., 1., 5., 9., 12., 4., 18., 13., 3., 16., 3., 18., 16., 1., 2., 2., 0., 13., 15., 15., 53., 11., 17., 13., 7., 2., 4., 1., 9., 3., 7., 7., 8., 16., 6., 19., 10., 5., 0., 0., 7., 0., 3., 4., 8., 5., 5., 6., 2., 7., 5., 2., 0., 0., 2., 0., 0., 2., 4., 4., 5., 5., 3., 1., 3., 3., 2., 2., 2., 9., 1., 0., 2., 2., 2., 2., 2., 1., 0., 3., 7., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 4., 3., 13., 2., 3., 0., 3., 21., 5., 18., 12., 1., 11., 3., 2., 2., 18., 3., 3., 18., 6., 37., 37., 7., 0., 1., 5., 4., 6., 9., 36., 11., 3., 11., 1., 13., 7., 3., 0., 4., 3., 13., 5., 19., 51., 13., 25., 6., 2., 1., 1., 1., 6., 2., 12., 5., 5., 17., 6., 26., 5., 3., 2., 1., 10., 0., 5., 3., 5., 1., 4., 5., 1., 4., 2., 2., 2., 1., 2., 0., 0., 1., 1., 6., 0., 6., 1., 0., 2., 0., 3., 1., 2., 6., 1., 0., 3., 1., 2., 2., 2., 3., 4., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 2., 4., 11., 2., 7., 1., 5., 24., 0., 16., 8., 0., 13., 5., 2., 1., 19., 1., 2., 22., 9., 26., 28., 4., 1., 0., 1., 3., 9., 6., 15., 20., 5., 7., 2., 9., 7., 1., 3., 4., 2., 6., 8., 12., 48., 8., 20., 12., 5., 2., 7., 1., 2., 4., 6., 1., 9., 18., 6., 21., 7., 4., 0., 1., 7., 2., 5., 5., 2., 3., 4., 6., 2., 5., 1., 0., 1., 2., 1., 0., 3., 4., 1., 7., 1., 4., 2., 3., 6., 1., 0., 1., 3., 8., 0., 0., 2., 2., 2., 2., 3., 2., 3., 3., 1., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 4., 7., 4., 7., 0., 9., 25., 0., 15., 23., 2., 16., 2., 2., 1., 26., 4., 3., 29., 11., 29., 35., 4., 1., 2., 1., 5., 17., 2., 34., 13., 1., 6., 2., 18., 7., 2., 1., 6., 3., 15., 9., 18., 56., 16., 27., 9., 6., 4., 4., 4., 5., 5., 13., 10., 7., 20., 8., 15., 7., 2., 1., 0., 8., 1., 3., 2., 2., 2., 6., 3., 4., 5., 5., 1., 0., 5., 1., 0., 1., 4., 2., 7., 2., 4., 2., 3., 1., 2., 4., 1., 2., 2., 1., 0., 1., 2., 1., 5., 3., 2., 5., 1., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 0., 4., 7., 0., 9., 1., 2., 13., 0., 13., 12., 3., 14., 3., 0., 1., 14., 1., 2., 25., 11., 27., 27., 6., 0., 4., 6., 1., 0., 11., 35., 19., 1., 14., 3., 13., 8., 0., 3., 4., 1., 10., 14., 16., 39., 16., 25., 7., 1., 1., 3., 4., 9., 1., 12., 3., 9., 13., 4., 20., 6., 4., 1., 2., 10., 3., 5., 3., 3., 8., 3., 2., 1., 3., 1., 4., 1., 1., 4., 0., 1., 1., 0., 5., 3., 5., 2., 5., 4., 0., 3., 1., 4., 8., 2., 0., 1., 1., 2., 2., 3., 3., 2., 2., 5., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 5., 5., 7., 7., 0., 8., 29., 0., 13., 13., 2., 20., 4., 0., 1., 6., 1., 5., 29., 13., 22., 35., 3., 2., 2., 3., 0., 9., 9., 31., 12., 3., 17., 3., 9., 12., 3., 1., 2., 2., 6., 9., 14., 48., 8., 18., 10., 5., 0., 8., 3., 4., 6., 4., 10., 3., 9., 5., 16., 12., 3., 0., 2., 4., 1., 1., 1., 5., 4., 8., 6., 1., 3., 4., 1., 1., 1., 0., 0., 2., 5., 2., 8., 4., 5., 0., 3., 5., 0., 5., 2., 0., 9., 1., 0., 4., 2., 4., 3., 2., 5., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 3., 3., 9., 5., 7., 3., 6., 20., 2., 13., 24., 1., 15., 3., 0., 5., 13., 1., 7., 19., 6., 21., 24., 10., 0., 1., 0., 2., 9., 11., 33., 11., 0., 13., 5., 15., 12., 0., 0., 4., 5., 14., 14., 16., 46., 11., 18., 12., 0., 0., 4., 3., 6., 2., 13., 4., 3., 12., 10., 18., 7., 2., 2., 3., 4., 2., 2., 1., 4., 3., 3., 5., 5., 4., 3., 1., 0., 3., 0., 0., 1., 2., 2., 6., 0., 5., 4., 1., 3., 1., 0., 0., 0., 3., 2., 0., 1., 3., 5., 2., 3., 3., 0., 2., 3., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 4., 5., 1., 4., 0., 0., 15., 2., 14., 21., 0., 16., 3., 1., 1., 21., 1., 3., 19., 15., 21., 35., 5., 2., 2., 2., 1., 7., 5., 21., 22., 2., 17., 2., 16., 10., 2., 2., 3., 2., 18., 16., 19., 41., 13., 18., 9., 4., 1., 3., 0., 6., 4., 11., 4., 3., 20., 2., 28., 7., 3., 2., 2., 6., 1., 4., 0., 3., 5., 4., 2., 3., 3., 7., 5., 1., 1., 1., 0., 2., 1., 4., 5., 1., 5., 3., 1., 3., 2., 1., 0., 2., 8., 4., 0., 4., 0., 4., 0., 1., 0., 1., 2., 5., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 5., 10., 0., 19., 7., 8., 54., 0., 9., 57., 1., 8., 2., 0., 1., 59., 0., 9., 83., 8., 78., 9., 3., 0., 1., 2., 1., 12., 10., 57., 7., 1., 40., 34., 13., 4., 0., 3., 5., 2., 13., 3., 26., 4., 11., 7., 4., 2., 0., 14., 2., 25., 7., 16., 1., 15., 3., 0., 38., 10., 7., 0., 0., 15., 2., 14., 0., 9., 3., 2., 0., 1., 2., 0., 9., 5., 24., 8., 5., 3., 2., 4., 0., 0., 0., 0., 0., 12., 2., 3., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 2., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 3., 4., 1., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 33., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

17., 0., 3., 2., 10., 0., 14., 2., 8., 58., 2., 7., 55., 2., 8., 4., 0., 4., 81., 12., 9., 86., 24., 76., 11., 4., 0., 1., 5., 3., 15., 9., 68., 10., 3., 49., 26., 17., 3., 0., 1., 5., 5., 28., 6., 20., 2., 14., 6., 2., 1., 0., 9., 5., 14., 2., 9., 5., 7., 5., 1., 31., 8., 7., 1., 0., 10., 3., 2., 1., 9., 5., 4., 1., 1., 0., 0., 6., 6., 10., 7., 2., 3., 2., 3., 0., 0., 0., 0., 0., 10., 0., 3., 4., 2., 1., 1., 0., 3., 0., 2., 0., 0., 2., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 1., 2., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 27., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 4., 8., 18., 0., 10., 3., 8., 56., 1., 9., 42., 1., 6., 0., 0., 1., 94., 10., 13., 98., 19., 77., 15., 6., 0., 1., 3., 1., 18., 11., 51., 9., 1., 36., 26., 13., 7., 0., 0., 9., 2., 26., 2., 16., 5., 17., 3., 2., 3., 0., 21., 5., 15., 5., 19., 4., 11., 2., 2., 34., 10., 15., 1., 0., 9., 3., 12., 2., 14., 3., 1., 2., 2., 0., 0., 5., 0., 16., 8., 4., 1., 2., 2., 0., 0., 0., 0., 0., 7., 5., 3., 2., 6., 1., 1., 0., 3., 0., 2., 0., 1., 2., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 4., 2., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 19., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

17., 0., 2., 9., 11., 0., 17., 3., 8., 57., 0., 12., 61., 1., 11., 2., 0., 3., 79., 4., 8., 74., 16., 71., 12., 4., 0., 1., 3., 1., 12., 8., 43., 7., 2., 42., 30., 14., 4., 0., 1., 6., 2., 34., 5., 24., 12., 7., 7., 1., 2., 0., 10., 7., 21., 5., 14., 4., 7., 4., 3., 31., 6., 4., 1., 0., 20., 5., 7., 2., 7., 1., 2., 1., 1., 1., 0., 5., 1., 12., 5., 2., 5., 1., 3., 0., 0., 0., 0., 0., 6., 4., 6., 1., 4., 1., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 3., 3., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 27., 0., 2., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 1., 3., 4., 13., 0., 12., 0., 9., 58., 2., 13., 49., 0., 9., 1., 0., 1., 73., 1., 9., 43., 11., 78., 12., 1., 0., 0., 2., 4., 12., 10., 67., 9., 3., 34., 40., 13., 4., 0., 0., 6., 2., 23., 9., 18., 9., 16., 6., 1., 3., 0., 6., 4., 17., 4., 11., 1., 8., 5., 1., 28., 10., 11., 5., 0., 19., 4., 9., 4., 11., 2., 6., 1., 0., 0., 0., 8., 1., 17., 8., 5., 8., 3., 5., 0., 0., 0., 0., 0., 10., 0., 3., 2., 4., 0., 1., 0., 0., 0., 1., 0., 1., 2., 4., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 25., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 4., 5., 20., 6., 17., 0., 13., 191., 2., 19., 215., 3., 12., 5., 1., 5., 82., 5., 20., 281., 48., 353., 37., 13., 1., 3., 10., 6., 54., 35., 243., 52., 11., 161., 8., 48., 6., 0., 2., 17., 4., 84., 18., 92., 16., 33., 49., 15., 0., 2., 20., 7., 35., 9., 46., 11., 26., 3., 9., 4., 4., 0., 1., 0., 20., 2., 5., 1., 23., 3., 9., 7., 5., 1., 1., 0., 4., 1., 6., 3., 4., 3., 6., 1., 2., 6., 146., 10., 1962., 87., 100., 223., 102., 122., 74., 17., 14., 18., 11., 1., 4., 9., 4., 5., 6., 9., 41., 11., 38., 20., 40., 8., 12., 2., 1., 10., 2., 0., 2., 6., 7., 2., 0., 3., 8., 15., 0., 0., 14., 2., 3., 0., 4., 2., 3., 25., 4., 7., 3., 14., 7., 21., 3., 3., 2., 4., 27., 5., 32., 12., 4., 9., 8., 22., 4., 17., 4.,

14., 3., 6., 10., 27., 5., 34., 1., 15., 149., 5., 20., 193., 3., 15., 3., 1., 5., 86., 1., 10., 327., 45., 342., 54., 21., 0., 5., 5., 4., 43., 29., 236., 39., 8., 147., 8., 44., 7., 0., 2., 17., 9., 69., 13., 88., 18., 46., 43., 9., 1., 1., 24., 6., 48., 14., 37., 6., 33., 6., 10., 7., 0., 0., 0., 0., 28., 2., 15., 1., 27., 5., 7., 7., 1., 4., 1., 1., 2., 2., 11., 2., 9., 0., 11., 0., 0., 5., 137., 6., 1813., 93., 102., 226., 97., 113., 61., 9., 9., 18., 17., 0., 3., 5., 6., 3., 9., 5., 32., 13., 27., 19., 39., 4., 11., 6., 3., 6., 5., 3., 2., 2., 9., 4., 0., 6., 1., 10., 1., 0., 4., 6., 5., 0., 4., 4., 1., 32., 2., 10., 4., 19., 1., 19., 2., 6., 3., 3., 21., 4., 31., 6., 4., 7., 2., 19., 13., 17., 6.,

15., 4., 3., 9., 21., 3., 26., 1., 9., 150., 0., 17., 207., 7., 12., 7., 1., 1., 90., 3., 17., 281., 46., 347., 38., 22., 3., 5., 6., 8., 43., 24., 223., 44., 7., 146., 15., 36., 5., 0., 1., 16., 11., 85., 16., 97., 15., 41., 49., 11., 3., 0., 27., 11., 32., 11., 59., 3., 20., 6., 9., 6., 0., 0., 1., 0., 28., 7., 15., 7., 31., 4., 11., 8., 2., 3., 2., 2., 2., 1., 13., 5., 10., 7., 6., 1., 2., 5., 150., 7., 1859., 76., 97., 208., 94., 96., 65., 10., 13., 14., 13., 1., 3., 2., 7., 4., 9., 13., 44., 21., 28., 16., 45., 7., 7., 4., 5., 6., 4., 1., 2., 5., 9., 1., 0., 3., 3., 12., 2., 0., 8., 0., 6., 0., 1., 1., 1., 25., 3., 11., 2., 13., 2., 25., 3., 2., 5., 9., 32., 7., 39., 6., 2., 2., 6., 27., 12., 9., 3.,

9., 5., 2., 8., 27., 3., 41., 0., 18., 159., 2., 30., 202., 7., 7., 7., 0., 7., 70., 1., 19., 304., 37., 338., 44., 26., 1., 4., 6., 11., 44., 31., 236., 37., 9., 130., 12., 31., 6., 0., 2., 18., 11., 86., 17., 92., 9., 34., 47., 18., 3., 1., 26., 7., 31., 11., 52., 9., 28., 7., 10., 11., 1., 0., 0., 0., 26., 7., 15., 3., 28., 2., 11., 6., 6., 2., 1., 4., 1., 6., 14., 4., 6., 0., 13., 1., 0., 4., 153., 10., 1913., 103., 73., 227., 98., 98., 68., 17., 17., 19., 10., 0., 2., 11., 6., 4., 8., 8., 43., 15., 38., 18., 47., 8., 15., 5., 6., 13., 6., 2., 2., 0., 9., 2., 0., 4., 7., 12., 1., 0., 10., 2., 2., 0., 3., 5., 3., 28., 1., 10., 2., 10., 5., 16., 2., 2., 3., 5., 32., 7., 41., 7., 3., 8., 5., 30., 6., 15., 6.,

6., 1., 5., 4., 9., 3., 7., 0., 7., 28., 0., 9., 21., 1., 13., 3., 1., 3., 18., 2., 5., 18., 13., 28., 25., 8., 0., 0., 2., 1., 10., 14., 21., 10., 5., 20., 1., 17., 7., 1., 1., 6., 4., 8., 9., 28., 48., 10., 19., 3., 3., 1., 4., 1., 7., 7., 9., 6., 10., 6., 10., 19., 7., 4., 1., 1., 7., 1., 2., 1., 3., 1., 3., 2., 1., 5., 4., 1., 0., 1., 2., 0., 1., 3., 2., 8., 2., 4., 1., 5., 1., 3., 1., 2., 0., 7., 0., 0., 2., 3., 2., 4., 3., 4., 5., 2., 1., 0., 0., 0., 0., 4., 0., 0., 1., 0., 0., 0., 3., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 3., 3., 4., 7., 2., 9., 1., 5., 21., 0., 13., 15., 3., 13., 1., 1., 1., 17., 1., 3., 23., 10., 31., 25., 4., 2., 1., 2., 2., 8., 6., 15., 11., 1., 17., 7., 10., 10., 3., 0., 6., 2., 14., 12., 25., 48., 8., 21., 8., 7., 1., 7., 3., 9., 3., 15., 9., 6., 16., 3., 27., 15., 3., 0., 0., 5., 3., 4., 2., 5., 3., 1., 6., 1., 2., 4., 6., 0., 1., 1., 0., 1., 6., 5., 6., 1., 1., 3., 1., 8., 2., 0., 0., 1., 10., 2., 0., 4., 2., 2., 0., 3., 3., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 3., 7., 8., 4., 12., 2., 3., 15., 0., 15., 30., 0., 15., 3., 4., 2., 23., 1., 1., 17., 8., 24., 24., 0., 0., 1., 0., 3., 2., 2., 15., 15., 2., 12., 4., 10., 13., 2., 1., 2., 2., 13., 11., 15., 49., 12., 24., 2., 4., 4., 3., 2., 8., 1., 7., 3., 13., 17., 7., 26., 1., 1., 1., 0., 12., 0., 0., 3., 2., 5., 7., 1., 1., 4., 2., 4., 0., 1., 3., 0., 1., 3., 3., 3., 4., 6., 2., 1., 6., 0., 2., 0., 0., 9., 0., 0., 1., 1., 2., 0., 1., 0., 2., 2., 2., 0., 0., 0., 0., 1., 0., 0., 5., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 3., 5., 12., 3., 6., 2., 4., 24., 2., 11., 22., 1., 13., 3., 0., 2., 24., 1., 3., 28., 18., 36., 35., 8., 2., 1., 2., 2., 5., 4., 28., 11., 3., 6., 5., 13., 5., 1., 0., 4., 2., 13., 12., 25., 49., 15., 23., 6., 2., 1., 5., 3., 6., 4., 11., 4., 6., 16., 4., 28., 8., 1., 1., 1., 5., 0., 0., 1., 11., 4., 4., 4., 4., 4., 3., 0., 2., 2., 2., 0., 3., 1., 2., 1., 1., 6., 2., 4., 5., 0., 3., 1., 3., 4., 2., 0., 0., 1., 0., 2., 1., 2., 3., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 5., 5., 3., 1., 0., 5., 20., 3., 10., 26., 0., 15., 7., 0., 1., 18., 0., 3., 31., 12., 29., 22., 8., 2., 0., 1., 1., 5., 7., 27., 27., 3., 9., 4., 12., 10., 3., 1., 4., 3., 11., 16., 23., 35., 17., 29., 11., 4., 1., 4., 0., 7., 2., 11., 5., 16., 24., 6., 27., 9., 2., 2., 0., 8., 1., 3., 2., 6., 0., 4., 2., 2., 4., 4., 1., 1., 2., 1., 0., 2., 1., 3., 6., 0., 7., 1., 0., 6., 0., 2., 0., 4., 8., 7., 0., 2., 2., 3., 2., 2., 0., 1., 0., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 1., 2., 8., 2., 10., 3., 4., 17., 1., 11., 18., 1., 15., 2., 1., 3., 21., 3., 7., 19., 10., 33., 15., 5., 0., 1., 3., 3., 14., 12., 22., 17., 2., 17., 3., 10., 8., 3., 1., 2., 1., 17., 6., 16., 56., 10., 16., 6., 7., 2., 4., 3., 6., 3., 8., 4., 10., 17., 6., 27., 3., 3., 1., 1., 8., 2., 2., 0., 5., 5., 3., 2., 2., 9., 5., 3., 0., 4., 0., 0., 3., 2., 2., 5., 2., 3., 1., 3., 3., 0., 2., 1., 2., 7., 1., 0., 3., 4., 2., 2., 3., 0., 2., 1., 4., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 2., 3., 10., 5., 6., 1., 4., 29., 0., 14., 22., 1., 16., 1., 2., 3., 23., 3., 6., 11., 10., 28., 27., 10., 0., 0., 0., 2., 10., 10., 32., 13., 3., 18., 5., 16., 9., 1., 1., 3., 4., 11., 10., 13., 44., 15., 23., 12., 3., 0., 3., 3., 8., 7., 11., 3., 7., 13., 5., 25., 8., 2., 0., 1., 8., 0., 10., 6., 1., 5., 3., 5., 3., 3., 1., 1., 0., 1., 2., 0., 3., 1., 2., 6., 2., 4., 0., 2., 2., 0., 1., 3., 4., 3., 1., 0., 1., 2., 1., 2., 4., 2., 1., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 3., 4., 10., 3., 6., 3., 6., 21., 1., 17., 24., 1., 17., 2., 1., 3., 21., 2., 5., 22., 13., 23., 31., 5., 1., 0., 3., 4., 6., 7., 29., 14., 2., 10., 5., 12., 7., 5., 3., 3., 5., 7., 4., 16., 36., 13., 28., 12., 5., 1., 5., 4., 8., 3., 8., 3., 9., 15., 10., 21., 6., 4., 1., 1., 6., 0., 1., 1., 2., 4., 2., 1., 4., 10., 2., 2., 1., 1., 3., 0., 3., 3., 2., 6., 4., 5., 2., 2., 3., 0., 1., 1., 0., 11., 0., 0., 4., 1., 2., 2., 5., 5., 1., 1., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 3., 1., 5., 11., 1., 3., 2., 4., 21., 1., 8., 16., 0., 10., 4., 2., 2., 15., 2., 3., 20., 11., 31., 24., 5., 0., 3., 2., 3., 5., 7., 25., 16., 1., 11., 3., 12., 11., 3., 2., 6., 2., 16., 13., 15., 45., 5., 22., 12., 5., 1., 6., 4., 5., 2., 5., 7., 7., 11., 6., 26., 9., 1., 0., 1., 4., 1., 6., 2., 3., 3., 7., 3., 0., 1., 4., 5., 1., 1., 0., 0., 3., 1., 4., 3., 0., 3., 3., 3., 6., 1., 2., 2., 1., 7., 1., 0., 2., 2., 0., 6., 0., 0., 3., 3., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 1., 6., 8., 1., 4., 1., 5., 28., 0., 13., 30., 0., 12., 4., 0., 3., 23., 0., 4., 32., 15., 24., 21., 6., 3., 0., 2., 1., 8., 12., 29., 16., 3., 12., 6., 13., 8., 4., 0., 3., 2., 17., 12., 15., 56., 15., 22., 9., 5., 0., 7., 1., 3., 3., 8., 5., 6., 19., 8., 22., 6., 3., 0., 1., 9., 0., 4., 1., 7., 6., 5., 3., 1., 5., 5., 2., 2., 2., 2., 0., 0., 1., 2., 9., 3., 2., 0., 4., 0., 1., 3., 1., 0., 10., 1., 0., 4., 1., 2., 2., 1., 0., 0., 2., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 2., 3., 3., 6., 3., 5., 1., 9., 27., 0., 6., 26., 1., 14., 7., 1., 1., 18., 3., 7., 18., 12., 19., 27., 10., 3., 1., 4., 1., 11., 5., 25., 15., 3., 17., 6., 11., 7., 1., 2., 4., 0., 14., 12., 12., 52., 9., 17., 5., 7., 1., 5., 3., 5., 5., 15., 6., 7., 16., 7., 25., 10., 2., 0., 0., 11., 2., 4., 2., 10., 4., 4., 2., 2., 5., 2., 5., 0., 1., 2., 0., 2., 2., 0., 4., 0., 5., 3., 2., 6., 2., 1., 1., 1., 8., 5., 0., 4., 1., 1., 1., 3., 0., 1., 1., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 1., 6., 7., 5., 5., 0., 6., 20., 1., 14., 17., 0., 14., 2., 1., 2., 17., 2., 4., 25., 11., 24., 20., 10., 2., 1., 5., 0., 8., 11., 33., 13., 3., 16., 5., 7., 9., 0., 1., 4., 0., 9., 12., 10., 42., 9., 21., 8., 4., 2., 4., 4., 6., 2., 8., 3., 11., 16., 5., 28., 12., 3., 0., 2., 9., 2., 3., 4., 8., 4., 1., 2., 2., 2., 0., 4., 2., 1., 2., 0., 3., 2., 1., 7., 0., 8., 4., 1., 3., 0., 2., 1., 1., 8., 1., 0., 1., 3., 2., 2., 2., 3., 3., 1., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 5., 3., 10., 2., 9., 0., 5., 14., 0., 10., 12., 1., 16., 4., 0., 2., 21., 1., 3., 31., 11., 16., 25., 6., 3., 0., 2., 1., 5., 6., 26., 24., 7., 18., 3., 16., 13., 3., 2., 4., 1., 20., 12., 13., 47., 16., 27., 10., 3., 1., 5., 5., 6., 2., 11., 8., 7., 20., 8., 19., 9., 2., 1., 1., 9., 1., 3., 3., 5., 2., 2., 1., 2., 2., 5., 2., 0., 2., 1., 0., 0., 2., 4., 3., 3., 6., 2., 1., 3., 2., 3., 1., 1., 13., 1., 0., 2., 2., 2., 3., 3., 2., 0., 2., 1., 0., 0., 0., 0., 7., 0., 0., 4., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 3., 8., 4., 2., 1., 10., 27., 0., 11., 26., 2., 13., 2., 2., 3., 14., 1., 4., 33., 12., 27., 17., 7., 0., 1., 5., 4., 13., 11., 37., 15., 5., 10., 4., 16., 9., 2., 1., 2., 1., 13., 9., 17., 41., 15., 20., 12., 5., 1., 2., 0., 8., 6., 10., 9., 8., 11., 11., 19., 11., 5., 1., 3., 8., 3., 4., 4., 5., 1., 8., 4., 2., 5., 0., 4., 1., 3., 0., 0., 2., 0., 4., 5., 2., 1., 1., 3., 5., 0., 5., 3., 5., 2., 2., 0., 1., 3., 1., 0., 0., 1., 4., 0., 2., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 6., 5., 7., 3., 3., 0., 5., 17., 1., 9., 11., 0., 12., 2., 0., 5., 25., 1., 3., 14., 0., 33., 33., 4., 0., 0., 1., 5., 6., 4., 22., 18., 1., 21., 3., 8., 9., 2., 1., 3., 1., 15., 15., 17., 39., 14., 27., 8., 8., 2., 4., 2., 8., 5., 9., 7., 3., 10., 7., 31., 10., 1., 3., 2., 2., 1., 2., 0., 9., 5., 7., 6., 2., 0., 5., 4., 2., 2., 0., 0., 1., 0., 1., 2., 3., 4., 2., 2., 3., 1., 2., 0., 3., 5., 0., 0., 0., 2., 3., 3., 4., 3., 3., 1., 2., 0., 0., 0., 0., 4., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 3., 3., 2., 6., 0., 8., 10., 1., 11., 18., 1., 17., 0., 0., 5., 19., 2., 7., 32., 10., 19., 21., 8., 0., 1., 4., 0., 10., 7., 24., 8., 1., 12., 6., 17., 8., 1., 0., 5., 5., 8., 4., 22., 42., 8., 27., 11., 2., 1., 5., 2., 2., 2., 6., 1., 5., 14., 6., 18., 9., 4., 1., 0., 8., 0., 5., 0., 4., 4., 3., 6., 1., 6., 4., 0., 0., 2., 2., 0., 2., 2., 1., 1., 3., 3., 1., 0., 6., 1., 2., 0., 3., 9., 1., 0., 4., 0., 5., 2., 4., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 1., 4., 7., 4., 12., 1., 6., 17., 0., 17., 17., 0., 17., 4., 2., 4., 9., 1., 3., 26., 12., 25., 20., 9., 1., 1., 3., 5., 10., 5., 11., 21., 3., 18., 3., 17., 11., 4., 0., 2., 1., 14., 10., 17., 47., 12., 29., 10., 4., 0., 5., 3., 9., 2., 11., 9., 6., 15., 2., 17., 8., 3., 0., 2., 12., 1., 7., 4., 4., 4., 5., 3., 2., 7., 6., 3., 1., 2., 1., 0., 2., 1., 1., 4., 2., 5., 3., 2., 4., 0., 1., 1., 2., 7., 3., 0., 0., 1., 1., 3., 0., 1., 0., 1., 3., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 2., 6., 10., 4., 5., 0., 13., 5., 1., 18., 23., 0., 21., 6., 2., 4., 24., 6., 0., 1., 9., 17., 33., 6., 1., 2., 3., 0., 12., 13., 25., 19., 2., 21., 6., 9., 4., 0., 1., 4., 2., 13., 12., 18., 43., 11., 19., 14., 2., 0., 6., 1., 8., 2., 10., 7., 12., 15., 6., 17., 6., 3., 4., 0., 9., 2., 3., 1., 8., 4., 5., 5., 3., 4., 2., 1., 3., 1., 0., 0., 2., 3., 2., 7., 3., 6., 1., 4., 5., 2., 3., 2., 4., 4., 5., 0., 2., 0., 4., 3., 2., 2., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 3., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 0., 3., 7., 3., 7., 2., 10., 16., 0., 18., 33., 1., 15., 4., 1., 0., 8., 0., 5., 34., 11., 15., 30., 11., 3., 0., 4., 2., 9., 5., 28., 7., 3., 15., 5., 14., 10., 3., 0., 5., 2., 8., 15., 14., 45., 11., 25., 5., 4., 1., 2., 1., 7., 2., 9., 10., 5., 23., 5., 15., 11., 3., 1., 2., 5., 1., 1., 2., 2., 4., 3., 3., 3., 5., 4., 4., 0., 3., 3., 0., 3., 3., 1., 9., 5., 3., 2., 2., 4., 0., 1., 0., 4., 10., 1., 0., 0., 1., 1., 4., 0., 4., 1., 2., 3., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 1., 1., 2., 7., 4., 7., 1., 6., 30., 3., 15., 21., 0., 23., 2., 0., 1., 10., 1., 5., 17., 10., 22., 29., 4., 2., 2., 2., 4., 6., 1., 36., 14., 1., 16., 9., 16., 6., 2., 1., 5., 4., 20., 12., 14., 54., 12., 21., 15., 4., 0., 4., 2., 10., 2., 5., 5., 7., 22., 3., 25., 8., 3., 1., 1., 7., 0., 7., 2., 14., 2., 4., 5., 4., 2., 4., 4., 1., 3., 2., 0., 0., 0., 1., 4., 2., 3., 1., 2., 5., 2., 0., 1., 2., 10., 0., 0., 4., 4., 2., 2., 3., 2., 0., 2., 2., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 4., 2., 3., 1., 6., 1., 4., 20., 1., 16., 15., 0., 15., 4., 1., 2., 15., 1., 9., 25., 8., 15., 30., 6., 0., 1., 4., 2., 5., 11., 27., 14., 2., 14., 3., 22., 15., 3., 1., 2., 3., 10., 14., 14., 46., 16., 31., 7., 4., 0., 5., 3., 13., 4., 14., 5., 4., 19., 7., 21., 6., 9., 1., 2., 5., 2., 7., 1., 3., 6., 3., 3., 3., 4., 2., 3., 0., 2., 4., 0., 5., 4., 2., 3., 1., 2., 1., 1., 5., 0., 1., 0., 1., 7., 1., 0., 6., 1., 2., 0., 1., 3., 2., 3., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 5., 3., 7., 0., 11., 0., 4., 27., 0., 11., 12., 0., 11., 3., 1., 0., 17., 1., 10., 25., 8., 33., 17., 5., 1., 0., 3., 2., 15., 4., 28., 14., 2., 9., 4., 12., 11., 4., 1., 2., 0., 4., 8., 12., 48., 13., 13., 18., 4., 0., 0., 2., 8., 5., 7., 6., 6., 16., 6., 21., 7., 1., 2., 0., 6., 0., 1., 2., 3., 3., 4., 4., 1., 7., 7., 2., 1., 5., 2., 0., 7., 1., 2., 9., 5., 5., 4., 3., 3., 1., 1., 2., 0., 8., 4., 0., 2., 3., 1., 1., 2., 1., 1., 1., 3., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 3., 4., 14., 0., 16., 3., 5., 46., 0., 8., 62., 1., 6., 3., 0., 0., 72., 3., 9., 81., 14., 73., 11., 3., 0., 2., 3., 1., 5., 15., 56., 8., 2., 38., 35., 10., 11., 0., 0., 10., 0., 32., 10., 23., 6., 16., 7., 3., 0., 0., 7., 2., 17., 7., 16., 5., 12., 5., 3., 40., 4., 9., 2., 0., 13., 4., 5., 1., 6., 4., 7., 1., 1., 0., 0., 0., 0., 12., 5., 1., 6., 0., 2., 0., 0., 0., 0., 0., 14., 0., 3., 0., 2., 1., 0., 0., 1., 0., 2., 0., 4., 5., 0., 0., 3., 0., 0., 0., 3., 0., 0., 0., 0., 0., 4., 4., 2., 0., 0., 0., 3., 0., 7., 0., 0., 0., 0., 24., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 0., 2., 13., 0., 20., 1., 2., 67., 2., 13., 55., 1., 11., 0., 0., 4., 68., 8., 7., 86., 13., 83., 19., 2., 0., 1., 6., 4., 15., 6., 44., 16., 3., 37., 30., 17., 8., 0., 3., 5., 2., 27., 3., 32., 6., 18., 9., 6., 4., 0., 7., 5., 20., 1., 8., 2., 10., 7., 2., 36., 5., 11., 2., 0., 19., 1., 9., 2., 10., 3., 1., 1., 0., 2., 0., 6., 1., 20., 8., 2., 5., 0., 3., 0., 0., 0., 0., 0., 11., 0., 2., 2., 1., 2., 0., 0., 0., 0., 4., 0., 2., 3., 3., 0., 3., 0., 2., 0., 2., 0., 0., 0., 0., 0., 2., 2., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 27., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 0., 1., 8., 0., 18., 0., 6., 49., 0., 12., 61., 0., 3., 0., 0., 2., 71., 6., 5., 84., 9., 65., 11., 3., 0., 2., 4., 2., 8., 6., 53., 18., 0., 47., 23., 14., 5., 0., 1., 9., 4., 18., 6., 25., 9., 7., 10., 2., 3., 0., 11., 3., 13., 6., 14., 5., 9., 3., 1., 37., 6., 7., 0., 0., 12., 5., 7., 0., 20., 0., 5., 2., 1., 0., 0., 4., 0., 28., 13., 2., 1., 2., 2., 0., 0., 0., 0., 0., 5., 3., 5., 1., 2., 2., 0., 0., 2., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 4., 1., 3., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 22., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 3., 7., 11., 0., 12., 1., 8., 49., 3., 10., 44., 2., 3., 1., 0., 4., 71., 7., 3., 85., 11., 67., 13., 2., 0., 1., 1., 4., 17., 10., 60., 9., 3., 32., 34., 14., 6., 0., 2., 8., 3., 31., 4., 18., 9., 11., 1., 1., 2., 0., 10., 1., 19., 9., 14., 5., 6., 8., 7., 39., 8., 11., 4., 0., 10., 7., 16., 1., 18., 0., 3., 0., 2., 1., 0., 6., 0., 12., 8., 2., 4., 1., 0., 0., 0., 0., 0., 0., 10., 2., 6., 1., 2., 2., 3., 0., 2., 0., 1., 0., 1., 2., 3., 0., 2., 0., 0., 0., 1., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 8., 0., 0., 0., 0., 20., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 0., 4., 9., 0., 15., 2., 4., 50., 1., 13., 55., 0., 4., 1., 0., 4., 57., 8., 7., 74., 12., 82., 9., 5., 0., 0., 2., 2., 17., 9., 61., 14., 3., 35., 27., 16., 6., 0., 1., 4., 1., 19., 7., 29., 8., 13., 7., 3., 1., 0., 8., 6., 21., 8., 11., 0., 11., 3., 2., 31., 6., 4., 2., 0., 14., 2., 13., 2., 12., 0., 3., 2., 1., 3., 0., 7., 1., 13., 10., 6., 2., 0., 2., 0., 0., 0., 0., 0., 14., 2., 3., 5., 3., 1., 0., 0., 2., 0., 1., 0., 1., 1., 0., 0., 7., 0., 1., 0., 1., 0., 0., 0., 3., 0., 0., 1., 5., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 25., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 2., 1., 7., 0., 17., 1., 6., 55., 1., 8., 62., 0., 4., 3., 0., 3., 61., 7., 3., 87., 11., 73., 9., 5., 0., 0., 1., 3., 15., 10., 64., 7., 2., 33., 30., 15., 8., 0., 1., 4., 0., 18., 7., 30., 2., 16., 5., 3., 2., 0., 12., 5., 20., 10., 16., 4., 14., 3., 5., 41., 12., 5., 0., 0., 11., 4., 6., 3., 9., 2., 1., 1., 2., 0., 0., 8., 3., 13., 14., 2., 2., 1., 1., 0., 0., 0., 0., 0., 12., 1., 6., 2., 4., 0., 0., 0., 0., 0., 2., 0., 4., 2., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 3., 0., 5., 2., 3., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 27., 0., 0., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

16., 2., 1., 3., 21., 2., 37., 4., 12., 167., 0., 16., 220., 3., 24., 3., 0., 4., 92., 4., 19., 261., 40., 370., 45., 19., 1., 2., 6., 5., 57., 32., 230., 40., 8., 148., 17., 33., 8., 0., 2., 12., 14., 84., 15., 87., 18., 47., 43., 14., 6., 2., 24., 4., 37., 7., 45., 10., 28., 6., 13., 10., 1., 0., 2., 0., 17., 4., 8., 5., 20., 2., 5., 4., 2., 5., 1., 1., 7., 0., 13., 1., 11., 0., 4., 4., 0., 8., 138., 12., 1946., 89., 102., 198., 95., 108., 74., 16., 12., 14., 8., 3., 2., 2., 2., 1., 7., 7., 42., 20., 37., 25., 39., 2., 17., 4., 6., 7., 3., 2., 2., 5., 6., 2., 0., 3., 5., 12., 2., 0., 7., 2., 1., 0., 5., 2., 3., 20., 3., 14., 6., 12., 3., 23., 5., 1., 5., 8., 26., 10., 42., 6., 3., 5., 5., 27., 2., 13., 4.,

14., 2., 3., 6., 16., 2., 33., 0., 9., 162., 1., 27., 197., 4., 8., 7., 1., 4., 80., 4., 21., 288., 45., 355., 42., 18., 1., 3., 7., 10., 49., 29., 249., 42., 11., 161., 18., 43., 6., 0., 2., 24., 10., 79., 12., 89., 10., 34., 42., 8., 6., 2., 29., 6., 39., 8., 55., 11., 41., 8., 13., 5., 1., 0., 2., 0., 31., 4., 10., 6., 30., 4., 19., 2., 3., 3., 0., 1., 2., 3., 10., 1., 11., 2., 8., 2., 0., 6., 144., 8., 1868., 84., 113., 250., 99., 109., 56., 19., 9., 15., 16., 1., 1., 10., 5., 4., 8., 7., 51., 20., 35., 13., 42., 8., 14., 3., 6., 6., 4., 3., 5., 3., 10., 3., 0., 5., 4., 10., 1., 0., 7., 3., 9., 0., 5., 2., 2., 29., 3., 13., 2., 15., 3., 11., 0., 3., 1., 4., 21., 5., 33., 2., 3., 8., 5., 31., 5., 4., 3.,

14., 1., 5., 11., 16., 7., 31., 0., 9., 152., 1., 22., 219., 4., 12., 8., 0., 3., 74., 3., 12., 299., 36., 295., 42., 15., 1., 1., 6., 9., 50., 29., 223., 40., 8., 183., 12., 45., 8., 0., 2., 20., 7., 73., 15., 71., 17., 26., 51., 15., 2., 0., 16., 8., 32., 11., 49., 7., 38., 7., 11., 7., 1., 0., 0., 0., 23., 4., 20., 1., 29., 7., 12., 6., 4., 4., 1., 1., 1., 3., 14., 0., 7., 0., 7., 1., 2., 2., 135., 11., 1921., 90., 92., 216., 125., 120., 66., 16., 13., 16., 16., 4., 5., 8., 4., 6., 12., 9., 40., 13., 30., 13., 42., 5., 8., 6., 4., 5., 8., 2., 1., 3., 8., 1., 0., 4., 5., 8., 2., 0., 14., 1., 4., 0., 8., 1., 1., 39., 1., 11., 1., 13., 4., 12., 0., 2., 2., 8., 23., 8., 39., 3., 3., 10., 4., 28., 11., 19., 5.,

8., 1., 4., 2., 8., 4., 10., 2., 10., 31., 1., 15., 25., 1., 15., 4., 2., 5., 17., 1., 6., 17., 11., 19., 30., 8., 2., 1., 0., 1., 4., 10., 21., 15., 4., 19., 4., 9., 10., 4., 2., 4., 0., 22., 13., 13., 47., 16., 14., 9., 2., 1., 6., 3., 10., 5., 10., 4., 7., 21., 6., 33., 11., 3., 0., 1., 6., 2., 4., 7., 4., 1., 3., 4., 0., 5., 3., 2., 0., 2., 2., 0., 2., 1., 3., 6., 3., 4., 5., 4., 4., 3., 1., 1., 1., 9., 4., 0., 6., 1., 2., 4., 6., 2., 4., 1., 4., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 1., 2., 9., 7., 6., 0., 5., 24., 0., 15., 25., 0., 11., 1., 0., 0., 25., 0., 6., 33., 13., 21., 26., 7., 3., 3., 3., 2., 15., 10., 26., 18., 1., 7., 5., 13., 11., 0., 2., 2., 2., 10., 12., 16., 43., 12., 20., 6., 2., 1., 8., 1., 2., 4., 7., 8., 8., 12., 5., 25., 10., 2., 1., 4., 4., 3., 1., 1., 6., 4., 6., 3., 1., 2., 6., 0., 0., 3., 0., 0., 3., 1., 0., 8., 2., 0., 3., 2., 5., 1., 2., 0., 6., 9., 2., 0., 2., 3., 2., 1., 0., 2., 1., 1., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 3., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 1., 4., 11., 4., 6., 1., 8., 14., 3., 11., 23., 2., 16., 2., 1., 4., 16., 0., 0., 9., 15., 22., 26., 1., 0., 0., 4., 1., 8., 5., 20., 11., 5., 18., 3., 10., 7., 2., 0., 3., 1., 12., 11., 15., 51., 11., 19., 12., 6., 1., 5., 1., 11., 1., 17., 5., 7., 12., 8., 26., 8., 6., 3., 1., 6., 1., 1., 4., 4., 2., 6., 7., 3., 5., 0., 3., 1., 1., 3., 0., 2., 5., 3., 9., 2., 6., 1., 1., 5., 0., 1., 0., 4., 6., 4., 0., 2., 1., 3., 0., 1., 2., 4., 0., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 0., 3., 7., 4., 5., 2., 8., 17., 0., 14., 18., 3., 18., 1., 1., 3., 19., 1., 4., 26., 10., 24., 24., 5., 0., 2., 1., 1., 9., 8., 23., 12., 2., 10., 4., 11., 7., 1., 2., 3., 3., 12., 6., 22., 38., 9., 18., 6., 7., 3., 6., 4., 10., 3., 10., 6., 8., 15., 5., 19., 15., 8., 2., 1., 7., 2., 1., 4., 6., 4., 3., 6., 2., 3., 2., 3., 2., 1., 2., 0., 3., 1., 1., 9., 3., 2., 3., 3., 4., 0., 2., 2., 2., 6., 0., 0., 1., 1., 2., 4., 2., 4., 3., 0., 2., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 1., 3., 9., 2., 5., 2., 8., 34., 1., 9., 17., 0., 17., 1., 1., 1., 16., 0., 5., 32., 10., 22., 30., 9., 1., 0., 1., 0., 5., 7., 33., 11., 0., 23., 5., 14., 5., 2., 1., 0., 3., 11., 10., 20., 45., 14., 27., 10., 3., 2., 9., 2., 8., 7., 7., 7., 10., 11., 7., 13., 4., 4., 0., 1., 6., 0., 1., 2., 4., 2., 2., 3., 2., 7., 2., 3., 1., 5., 1., 0., 2., 3., 1., 10., 0., 2., 3., 1., 4., 0., 1., 0., 0., 7., 2., 0., 0., 1., 2., 1., 2., 0., 4., 2., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 2., 4., 7., 1., 7., 0., 5., 20., 4., 13., 23., 1., 14., 2., 0., 3., 14., 1., 3., 26., 11., 37., 26., 4., 0., 2., 6., 3., 6., 9., 29., 12., 2., 13., 5., 11., 11., 1., 0., 4., 1., 16., 10., 17., 46., 12., 16., 6., 3., 0., 3., 1., 3., 5., 8., 6., 5., 10., 6., 18., 12., 3., 3., 0., 8., 0., 3., 1., 9., 4., 5., 4., 0., 5., 2., 4., 2., 2., 2., 0., 4., 2., 3., 6., 0., 3., 4., 1., 3., 0., 1., 0., 1., 6., 1., 0., 2., 1., 4., 3., 1., 0., 4., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 0., 3., 9., 4., 4., 2., 4., 26., 1., 13., 18., 2., 24., 4., 1., 2., 13., 0., 4., 22., 15., 20., 32., 3., 2., 1., 1., 0., 7., 3., 30., 13., 6., 17., 3., 16., 7., 2., 0., 4., 4., 5., 5., 17., 56., 16., 18., 6., 9., 0., 5., 2., 13., 2., 11., 4., 8., 18., 7., 27., 9., 2., 0., 2., 6., 1., 1., 3., 5., 5., 8., 3., 3., 4., 2., 3., 3., 2., 1., 0., 0., 2., 3., 6., 2., 4., 0., 2., 5., 0., 2., 2., 0., 5., 1., 0., 2., 0., 4., 2., 1., 0., 1., 2., 3., 0., 0., 0., 0., 2., 0., 0., 5., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 2., 2., 7., 2., 8., 2., 5., 17., 1., 15., 24., 0., 8., 2., 1., 2., 7., 2., 4., 16., 7., 22., 19., 5., 0., 1., 0., 1., 5., 4., 19., 14., 1., 15., 2., 14., 11., 3., 1., 4., 5., 10., 12., 17., 49., 14., 19., 10., 6., 1., 6., 3., 8., 5., 10., 2., 5., 18., 12., 28., 8., 3., 1., 2., 11., 1., 1., 0., 5., 3., 6., 10., 3., 3., 4., 3., 2., 2., 1., 0., 2., 4., 3., 8., 1., 3., 4., 1., 1., 1., 1., 2., 0., 6., 3., 0., 2., 0., 0., 0., 3., 3., 2., 1., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 7., 6., 3., 1., 0., 6., 19., 1., 14., 12., 0., 14., 1., 4., 1., 28., 2., 1., 15., 13., 22., 21., 4., 0., 1., 5., 1., 7., 5., 20., 18., 4., 10., 5., 13., 12., 0., 0., 3., 2., 14., 14., 18., 55., 11., 19., 7., 0., 0., 3., 1., 6., 3., 8., 3., 5., 19., 5., 16., 3., 1., 1., 3., 10., 3., 2., 3., 3., 3., 6., 7., 0., 2., 4., 2., 2., 3., 2., 0., 3., 4., 3., 6., 2., 4., 5., 2., 0., 2., 2., 0., 0., 6., 1., 0., 1., 4., 0., 4., 0., 4., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 0., 5., 6., 2., 14., 1., 7., 18., 3., 10., 18., 0., 11., 4., 1., 1., 24., 1., 5., 23., 23., 15., 25., 4., 1., 1., 1., 2., 5., 7., 23., 15., 3., 16., 2., 16., 12., 0., 1., 3., 3., 16., 13., 11., 36., 13., 21., 13., 4., 0., 5., 3., 17., 6., 10., 8., 7., 15., 9., 16., 8., 3., 2., 1., 2., 2., 3., 3., 5., 5., 6., 3., 1., 6., 1., 0., 0., 3., 2., 0., 4., 1., 3., 5., 1., 6., 0., 2., 2., 0., 2., 0., 2., 8., 1., 0., 2., 1., 1., 3., 3., 4., 1., 1., 4., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 7., 8., 4., 0., 1., 6., 25., 1., 13., 37., 3., 19., 4., 3., 1., 13., 1., 6., 26., 13., 26., 33., 5., 0., 0., 4., 2., 9., 7., 15., 17., 3., 20., 3., 7., 10., 3., 0., 2., 1., 11., 7., 20., 44., 10., 26., 14., 8., 2., 4., 6., 4., 2., 6., 6., 10., 16., 14., 16., 5., 2., 2., 0., 12., 1., 4., 3., 5., 1., 2., 2., 2., 2., 4., 2., 1., 1., 4., 0., 1., 1., 1., 6., 2., 6., 3., 1., 4., 0., 0., 0., 3., 8., 0., 0., 2., 2., 2., 1., 2., 3., 1., 1., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 1., 5., 12., 4., 6., 1., 4., 25., 2., 7., 26., 0., 10., 5., 0., 1., 23., 1., 4., 18., 12., 28., 29., 5., 3., 0., 2., 0., 13., 9., 20., 9., 2., 18., 3., 15., 5., 0., 1., 4., 0., 12., 7., 15., 52., 14., 22., 12., 2., 1., 11., 1., 3., 4., 9., 6., 8., 19., 7., 27., 6., 4., 3., 1., 6., 0., 4., 2., 4., 0., 1., 7., 2., 5., 5., 3., 2., 3., 2., 0., 1., 1., 2., 4., 5., 7., 2., 0., 5., 1., 3., 2., 4., 6., 1., 0., 1., 2., 2., 3., 1., 2., 2., 0., 5., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 6., 7., 2., 6., 4., 6., 13., 0., 21., 19., 1., 14., 1., 2., 2., 15., 3., 5., 27., 12., 28., 30., 6., 1., 0., 5., 2., 8., 7., 28., 11., 4., 14., 5., 8., 3., 1., 2., 4., 0., 9., 12., 21., 33., 7., 25., 10., 5., 0., 5., 2., 8., 1., 16., 3., 12., 13., 5., 25., 6., 3., 2., 1., 4., 1., 1., 1., 8., 1., 2., 1., 3., 5., 2., 6., 0., 5., 2., 0., 2., 3., 0., 8., 1., 5., 2., 1., 3., 4., 1., 0., 3., 4., 2., 0., 0., 3., 4., 2., 2., 1., 4., 2., 0., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 4., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 1., 6., 7., 1., 3., 2., 6., 26., 1., 6., 11., 0., 17., 3., 1., 2., 17., 1., 5., 16., 16., 19., 20., 5., 2., 2., 5., 1., 7., 7., 25., 22., 4., 20., 8., 12., 9., 4., 2., 2., 5., 8., 5., 14., 49., 10., 18., 8., 3., 0., 4., 1., 8., 2., 13., 6., 11., 8., 6., 20., 4., 5., 0., 0., 6., 0., 0., 3., 8., 2., 5., 4., 2., 7., 4., 2., 0., 1., 3., 0., 5., 2., 4., 2., 5., 4., 0., 2., 5., 2., 4., 2., 3., 6., 1., 0., 4., 0., 2., 3., 1., 2., 4., 1., 2., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 2., 5., 2., 11., 3., 5., 1., 5., 29., 0., 16., 27., 2., 19., 6., 2., 3., 20., 4., 3., 18., 7., 26., 18., 9., 1., 1., 2., 1., 8., 6., 42., 15., 3., 12., 3., 19., 8., 2., 2., 4., 1., 15., 11., 17., 32., 8., 15., 5., 8., 2., 9., 1., 3., 2., 11., 7., 4., 20., 7., 28., 8., 4., 1., 0., 4., 1., 4., 2., 2., 6., 5., 4., 0., 4., 2., 4., 3., 1., 3., 0., 2., 1., 2., 10., 0., 6., 2., 1., 3., 0., 1., 1., 2., 6., 1., 0., 2., 0., 1., 1., 0., 1., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 3., 2., 6., 4., 3., 0., 3., 30., 3., 17., 27., 0., 19., 4., 1., 3., 19., 12., 5., 26., 10., 20., 24., 5., 1., 0., 2., 4., 15., 8., 28., 14., 5., 18., 3., 14., 11., 2., 3., 5., 2., 11., 14., 25., 46., 15., 19., 12., 4., 1., 5., 2., 12., 2., 15., 6., 4., 8., 6., 19., 11., 1., 1., 0., 10., 1., 3., 2., 7., 3., 3., 4., 1., 3., 1., 3., 0., 0., 2., 0., 2., 0., 0., 4., 2., 0., 1., 0., 4., 1., 3., 0., 2., 12., 4., 0., 3., 2., 1., 1., 2., 0., 0., 2., 3., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 2., 5., 11., 2., 5., 0., 4., 25., 1., 20., 36., 1., 10., 6., 0., 2., 20., 0., 1., 31., 14., 28., 27., 9., 1., 2., 2., 0., 9., 6., 33., 12., 3., 18., 4., 15., 5., 0., 0., 7., 4., 10., 19., 19., 44., 15., 17., 8., 3., 2., 4., 0., 8., 2., 10., 5., 9., 24., 4., 20., 9., 3., 1., 0., 4., 1., 1., 3., 9., 2., 1., 7., 1., 3., 2., 1., 0., 2., 2., 0., 3., 0., 3., 5., 3., 1., 9., 2., 1., 1., 2., 1., 2., 6., 2., 0., 0., 1., 1., 1., 1., 4., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 5., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 0., 2., 10., 1., 6., 0., 7., 15., 2., 1., 12., 2., 12., 3., 1., 3., 18., 2., 3., 17., 15., 16., 27., 4., 2., 2., 1., 1., 15., 12., 30., 14., 3., 16., 4., 16., 9., 5., 0., 5., 0., 10., 7., 22., 41., 12., 15., 7., 5., 2., 10., 3., 7., 5., 5., 7., 5., 11., 8., 23., 5., 4., 1., 1., 6., 2., 2., 1., 6., 4., 2., 5., 4., 7., 3., 4., 3., 1., 2., 0., 4., 1., 4., 3., 2., 6., 3., 2., 3., 0., 1., 1., 5., 9., 0., 0., 0., 0., 2., 2., 2., 4., 3., 2., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 3., 10., 3., 7., 1., 4., 14., 1., 15., 14., 0., 8., 3., 1., 2., 23., 2., 2., 27., 12., 26., 39., 7., 1., 1., 2., 4., 11., 6., 18., 15., 1., 13., 3., 20., 5., 2., 0., 2., 1., 8., 12., 19., 58., 12., 17., 3., 6., 1., 4., 0., 10., 3., 9., 9., 17., 16., 2., 23., 5., 4., 2., 1., 2., 1., 1., 4., 7., 1., 4., 1., 3., 5., 2., 0., 0., 1., 1., 0., 1., 2., 3., 4., 2., 9., 2., 2., 2., 2., 0., 3., 1., 5., 3., 0., 1., 2., 5., 3., 3., 1., 1., 2., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 5., 3., 2., 1., 6., 2., 8., 31., 1., 9., 18., 2., 12., 5., 0., 4., 18., 4., 2., 10., 12., 31., 35., 1., 0., 0., 3., 0., 5., 5., 14., 17., 6., 18., 4., 16., 10., 2., 2., 4., 4., 3., 9., 17., 52., 17., 28., 12., 3., 3., 3., 2., 8., 6., 12., 5., 5., 21., 5., 23., 7., 2., 0., 2., 8., 1., 1., 7., 5., 3., 2., 4., 0., 2., 3., 5., 1., 1., 0., 0., 3., 4., 1., 2., 0., 5., 2., 0., 3., 0., 7., 0., 4., 7., 4., 0., 2., 5., 2., 4., 2., 1., 3., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 3., 5., 10., 4., 5., 3., 8., 24., 1., 26., 30., 0., 11., 7., 1., 0., 18., 2., 8., 14., 13., 19., 30., 8., 2., 0., 5., 1., 8., 7., 22., 17., 3., 23., 5., 15., 12., 3., 3., 3., 2., 13., 10., 8., 47., 10., 21., 9., 3., 1., 7., 2., 8., 4., 9., 9., 11., 18., 4., 12., 11., 4., 6., 1., 3., 1., 2., 3., 4., 1., 4., 4., 1., 4., 4., 1., 0., 2., 4., 0., 2., 3., 5., 4., 2., 4., 3., 0., 5., 3., 2., 1., 2., 9., 1., 0., 3., 2., 4., 3., 2., 1., 1., 1., 0., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 1., 1., 12., 1., 3., 0., 5., 28., 0., 15., 29., 1., 15., 8., 0., 3., 13., 3., 11., 9., 16., 32., 26., 10., 2., 3., 3., 3., 9., 10., 37., 18., 1., 16., 3., 16., 11., 0., 1., 4., 1., 15., 9., 17., 58., 9., 28., 15., 7., 2., 2., 5., 8., 4., 9., 6., 9., 19., 2., 20., 10., 1., 1., 0., 6., 1., 1., 1., 6., 3., 6., 3., 0., 5., 2., 2., 2., 4., 2., 0., 1., 1., 3., 7., 4., 0., 3., 4., 2., 1., 1., 1., 3., 11., 4., 0., 3., 1., 1., 4., 2., 2., 0., 1., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 2., 9., 15., 0., 12., 1., 6., 52., 2., 9., 56., 2., 1., 1., 0., 1., 74., 6., 11., 89., 18., 71., 16., 0., 0., 1., 2., 3., 16., 7., 60., 13., 6., 43., 33., 21., 4., 0., 1., 2., 2., 23., 8., 29., 7., 15., 3., 2., 3., 0., 5., 7., 20., 9., 9., 0., 6., 4., 6., 37., 8., 6., 4., 0., 13., 3., 3., 0., 14., 1., 3., 1., 0., 1., 0., 4., 0., 14., 9., 5., 3., 2., 1., 0., 0., 0., 0., 0., 10., 2., 4., 4., 4., 0., 1., 0., 1., 0., 0., 0., 2., 2., 2., 0., 3., 0., 1., 0., 1., 0., 0., 0., 2., 0., 1., 2., 1., 0., 0., 0., 3., 0., 5., 0., 0., 0., 0., 23., 0., 4., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 2., 3., 13., 0., 12., 1., 8., 45., 1., 3., 65., 3., 3., 1., 0., 2., 63., 14., 10., 80., 12., 101., 10., 6., 0., 3., 0., 0., 18., 11., 59., 16., 2., 41., 32., 14., 4., 0., 2., 5., 6., 19., 5., 21., 7., 9., 9., 1., 2., 0., 9., 4., 16., 4., 15., 4., 8., 2., 5., 33., 11., 6., 3., 0., 14., 2., 1., 5., 11., 2., 0., 0., 1., 0., 0., 3., 1., 12., 10., 1., 4., 3., 5., 0., 0., 0., 0., 0., 7., 0., 4., 4., 3., 2., 1., 0., 1., 0., 0., 0., 1., 1., 1., 0., 2., 0., 2., 0., 3., 0., 0., 0., 0., 0., 2., 1., 3., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 14., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 5., 11., 0., 17., 1., 6., 51., 1., 4., 48., 0., 1., 1., 0., 1., 61., 15., 9., 63., 15., 83., 7., 4., 0., 0., 3., 4., 10., 11., 46., 12., 2., 37., 27., 8., 6., 0., 0., 3., 7., 16., 7., 11., 10., 19., 8., 1., 3., 0., 6., 4., 13., 6., 9., 1., 11., 3., 3., 28., 7., 6., 1., 0., 16., 3., 8., 3., 17., 2., 3., 2., 0., 1., 0., 6., 1., 18., 8., 4., 4., 3., 3., 0., 0., 0., 0., 0., 9., 8., 2., 2., 2., 2., 0., 0., 2., 0., 1., 0., 0., 2., 1., 0., 4., 0., 0., 0., 1., 0., 0., 0., 0., 0., 5., 2., 3., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 23., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 0., 5., 7., 0., 17., 0., 7., 38., 2., 10., 54., 2., 3., 1., 0., 3., 64., 8., 7., 62., 21., 96., 17., 3., 0., 0., 4., 1., 12., 11., 56., 8., 3., 36., 38., 12., 2., 0., 2., 7., 2., 31., 4., 24., 6., 16., 3., 3., 2., 0., 11., 2., 22., 4., 13., 1., 7., 4., 2., 43., 9., 11., 4., 0., 19., 3., 7., 4., 5., 1., 4., 2., 1., 2., 0., 6., 0., 16., 7., 5., 4., 0., 4., 0., 0., 0., 0., 0., 9., 3., 4., 2., 8., 1., 1., 0., 1., 0., 1., 0., 2., 2., 5., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 3., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 25., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 2., 3., 9., 0., 19., 2., 5., 56., 0., 9., 62., 0., 6., 1., 0., 4., 90., 10., 6., 90., 15., 81., 9., 6., 0., 0., 5., 1., 17., 8., 55., 11., 2., 50., 27., 16., 4., 0., 2., 11., 3., 27., 7., 28., 13., 14., 2., 2., 2., 0., 5., 2., 15., 4., 19., 5., 11., 3., 3., 37., 12., 6., 2., 0., 6., 2., 11., 1., 6., 1., 4., 1., 2., 0., 0., 8., 4., 18., 12., 4., 3., 1., 1., 0., 0., 0., 0., 0., 15., 1., 5., 3., 5., 1., 0., 0., 0., 0., 1., 0., 0., 3., 2., 0., 3., 0., 3., 0., 1., 0., 0., 0., 0., 0., 2., 2., 1., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 20., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 3., 3., 17., 0., 16., 0., 4., 59., 1., 8., 52., 2., 7., 2., 0., 1., 70., 9., 8., 69., 15., 89., 10., 4., 0., 2., 2., 1., 15., 18., 50., 9., 4., 39., 38., 12., 4., 0., 0., 9., 0., 22., 6., 17., 6., 13., 8., 3., 2., 0., 5., 3., 13., 4., 11., 1., 6., 3., 3., 27., 6., 7., 3., 0., 18., 5., 13., 2., 15., 3., 4., 1., 1., 1., 0., 4., 1., 13., 9., 2., 5., 1., 2., 0., 0., 0., 0., 0., 13., 2., 3., 0., 7., 0., 1., 0., 1., 0., 1., 0., 3., 4., 4., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 2., 3., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 26., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 6., 6., 0., 11., 1., 11., 41., 1., 9., 58., 1., 5., 1., 0., 3., 65., 11., 6., 88., 15., 88., 11., 4., 0., 0., 5., 3., 18., 9., 53., 6., 3., 45., 33., 16., 2., 0., 2., 7., 2., 29., 6., 21., 4., 13., 4., 3., 2., 0., 13., 5., 19., 5., 15., 2., 7., 0., 6., 39., 8., 5., 1., 0., 11., 6., 5., 6., 12., 2., 5., 2., 0., 0., 0., 4., 3., 19., 11., 2., 2., 0., 1., 0., 0., 0., 0., 0., 9., 2., 3., 3., 4., 2., 1., 0., 0., 0., 0., 0., 1., 1., 2., 0., 2., 0., 1., 0., 1., 0., 0., 0., 1., 0., 2., 2., 3., 0., 0., 0., 0., 0., 8., 0., 0., 0., 0., 35., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

20., 3., 2., 12., 16., 7., 31., 3., 13., 173., 4., 31., 212., 5., 12., 7., 0., 8., 82., 2., 21., 291., 42., 352., 46., 16., 1., 1., 7., 6., 55., 25., 239., 42., 8., 159., 11., 41., 3., 0., 2., 15., 12., 85., 20., 77., 15., 38., 36., 9., 1., 1., 28., 5., 41., 7., 45., 12., 31., 8., 10., 7., 4., 0., 0., 0., 12., 2., 23., 3., 25., 4., 12., 5., 6., 0., 0., 1., 1., 1., 14., 4., 5., 3., 5., 1., 0., 7., 137., 8., 1875., 93., 107., 206., 87., 97., 70., 7., 9., 13., 12., 1., 1., 5., 3., 2., 8., 5., 40., 24., 33., 10., 37., 5., 9., 5., 6., 10., 5., 0., 4., 5., 7., 1., 0., 4., 6., 14., 3., 0., 8., 2., 2., 0., 6., 4., 5., 27., 0., 14., 3., 20., 3., 13., 3., 3., 1., 9., 26., 2., 37., 7., 7., 7., 3., 29., 8., 12., 9.,

10., 3., 2., 12., 28., 3., 29., 3., 19., 157., 5., 28., 194., 7., 11., 5., 1., 10., 75., 6., 15., 293., 48., 309., 55., 13., 4., 1., 6., 5., 46., 34., 209., 34., 5., 148., 17., 45., 8., 0., 0., 18., 8., 91., 15., 77., 23., 33., 44., 14., 4., 0., 24., 6., 34., 7., 43., 9., 28., 2., 9., 6., 1., 0., 3., 0., 23., 3., 11., 1., 30., 4., 7., 3., 2., 4., 1., 1., 1., 0., 6., 5., 6., 1., 6., 0., 1., 7., 142., 11., 1928., 98., 105., 202., 106., 100., 74., 21., 16., 19., 13., 1., 2., 3., 2., 3., 7., 11., 41., 13., 35., 16., 44., 11., 8., 0., 6., 3., 3., 0., 5., 1., 7., 1., 0., 2., 5., 9., 1., 0., 13., 2., 2., 0., 8., 4., 2., 32., 2., 12., 2., 8., 1., 23., 5., 1., 1., 6., 23., 3., 25., 11., 1., 9., 0., 32., 4., 10., 7.,

16., 4., 3., 10., 38., 9., 33., 4., 15., 172., 5., 33., 199., 4., 15., 9., 1., 7., 83., 2., 19., 307., 49., 329., 38., 19., 0., 2., 11., 4., 50., 22., 264., 28., 9., 154., 16., 49., 6., 0., 4., 12., 11., 88., 20., 89., 12., 33., 44., 14., 4., 1., 21., 6., 35., 11., 55., 8., 31., 6., 11., 8., 2., 0., 0., 0., 14., 10., 12., 0., 36., 5., 10., 1., 1., 0., 0., 3., 4., 1., 18., 4., 8., 2., 10., 1., 1., 4., 162., 9., 1813., 80., 107., 225., 95., 107., 83., 17., 7., 20., 3., 0., 3., 17., 6., 3., 10., 8., 27., 12., 29., 21., 55., 3., 14., 3., 2., 6., 5., 1., 5., 1., 10., 0., 0., 3., 3., 15., 4., 0., 12., 3., 6., 0., 8., 1., 4., 26., 2., 17., 5., 17., 1., 19., 2., 4., 4., 4., 22., 6., 27., 6., 10., 3., 7., 41., 4., 16., 5.,

10., 0., 3., 7., 11., 4., 7., 1., 8., 12., 1., 22., 32., 0., 16., 5., 1., 3., 8., 3., 4., 21., 14., 21., 21., 8., 1., 0., 6., 3., 9., 9., 35., 8., 7., 16., 2., 17., 11., 1., 1., 5., 0., 11., 9., 30., 51., 9., 25., 4., 4., 2., 4., 2., 3., 4., 15., 2., 7., 18., 4., 25., 9., 6., 1., 1., 10., 2., 5., 2., 6., 4., 5., 5., 0., 3., 2., 0., 1., 5., 0., 0., 1., 2., 4., 5., 3., 4., 4., 1., 1., 1., 0., 2., 1., 3., 2., 0., 1., 3., 0., 2., 4., 1., 2., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 3., 7., 8., 3., 8., 0., 7., 10., 0., 11., 22., 1., 15., 3., 2., 2., 12., 0., 1., 26., 9., 28., 24., 5., 1., 1., 0., 3., 10., 6., 29., 13., 2., 8., 6., 11., 11., 0., 0., 4., 1., 7., 10., 24., 44., 12., 19., 8., 4., 1., 2., 1., 11., 4., 7., 10., 4., 19., 10., 9., 11., 0., 0., 0., 2., 1., 3., 1., 3., 9., 2., 2., 2., 2., 4., 3., 0., 2., 1., 0., 2., 1., 2., 7., 1., 1., 3., 1., 5., 2., 2., 2., 2., 4., 3., 0., 3., 0., 1., 2., 3., 5., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 1., 5., 5., 3., 7., 2., 11., 28., 3., 14., 17., 1., 18., 1., 0., 1., 7., 2., 7., 30., 12., 32., 30., 7., 1., 1., 4., 2., 4., 12., 30., 28., 3., 15., 4., 12., 10., 3., 0., 5., 3., 8., 14., 18., 52., 16., 22., 8., 2., 2., 0., 2., 13., 3., 5., 7., 2., 12., 8., 15., 3., 3., 1., 1., 12., 1., 2., 2., 4., 3., 3., 8., 4., 4., 4., 1., 2., 1., 2., 0., 3., 3., 0., 4., 5., 2., 3., 1., 4., 1., 1., 0., 1., 9., 3., 0., 3., 1., 1., 1., 6., 2., 3., 0., 3., 0., 0., 0., 0., 6., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 3., 5., 1., 7., 2., 7., 36., 0., 14., 35., 2., 13., 4., 0., 4., 12., 0., 4., 29., 13., 31., 23., 7., 1., 3., 4., 2., 4., 4., 31., 13., 3., 11., 4., 13., 10., 4., 1., 2., 0., 8., 8., 17., 50., 13., 28., 5., 4., 1., 1., 3., 8., 2., 9., 6., 8., 11., 6., 22., 8., 4., 2., 0., 2., 1., 5., 1., 5., 3., 0., 2., 1., 6., 5., 2., 2., 0., 3., 0., 2., 2., 2., 2., 0., 3., 2., 0., 5., 0., 5., 0., 2., 5., 0., 0., 1., 2., 0., 1., 1., 2., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 0., 1., 7., 10., 7., 5., 1., 10., 22., 2., 6., 17., 0., 12., 2., 2., 4., 18., 7., 2., 19., 15., 23., 31., 5., 1., 2., 1., 2., 8., 19., 20., 18., 5., 11., 3., 17., 12., 0., 0., 3., 5., 12., 10., 17., 54., 16., 20., 12., 2., 1., 5., 2., 5., 1., 9., 5., 8., 10., 9., 28., 8., 4., 0., 3., 6., 0., 3., 1., 4., 2., 0., 4., 2., 2., 0., 6., 3., 3., 3., 0., 0., 3., 2., 6., 2., 4., 4., 0., 6., 1., 1., 2., 3., 4., 3., 0., 5., 2., 1., 2., 3., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 1., 9., 12., 2., 8., 0., 8., 29., 1., 8., 14., 2., 18., 2., 0., 1., 16., 1., 5., 24., 13., 15., 29., 4., 0., 1., 0., 2., 8., 6., 21., 15., 4., 11., 2., 12., 13., 5., 1., 3., 0., 14., 15., 17., 44., 12., 26., 6., 8., 2., 3., 1., 3., 2., 7., 7., 6., 10., 11., 25., 4., 4., 2., 3., 4., 1., 3., 0., 9., 3., 4., 1., 2., 5., 2., 2., 0., 2., 4., 0., 1., 1., 5., 6., 2., 5., 2., 2., 6., 1., 2., 1., 1., 11., 7., 0., 2., 0., 3., 1., 2., 1., 3., 2., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 7., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 3., 8., 15., 2., 5., 2., 7., 23., 1., 15., 19., 0., 11., 1., 0., 3., 16., 2., 3., 11., 12., 27., 19., 9., 2., 1., 4., 3., 10., 6., 22., 18., 4., 18., 7., 12., 9., 4., 1., 4., 5., 16., 7., 11., 42., 12., 23., 11., 4., 2., 5., 2., 7., 4., 11., 6., 7., 18., 3., 19., 9., 2., 3., 0., 5., 0., 4., 3., 9., 2., 7., 5., 0., 4., 3., 2., 1., 2., 0., 0., 0., 1., 1., 3., 2., 4., 3., 2., 6., 0., 2., 0., 3., 9., 2., 0., 1., 3., 4., 1., 1., 2., 3., 3., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 4., 5., 5., 2., 1., 7., 15., 2., 11., 18., 2., 15., 4., 0., 3., 14., 3., 3., 20., 7., 15., 24., 3., 1., 1., 1., 2., 8., 4., 30., 15., 3., 11., 4., 12., 9., 2., 1., 4., 4., 13., 11., 15., 48., 20., 16., 8., 4., 1., 5., 1., 6., 1., 10., 5., 6., 17., 3., 16., 8., 5., 1., 1., 7., 2., 3., 2., 6., 7., 3., 5., 0., 3., 2., 3., 0., 1., 2., 0., 1., 3., 2., 8., 3., 5., 1., 1., 7., 1., 4., 1., 0., 5., 2., 0., 3., 3., 2., 5., 3., 0., 3., 1., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 3., 9., 8., 0., 5., 0., 4., 29., 1., 10., 28., 2., 21., 5., 1., 4., 20., 1., 4., 35., 7., 21., 18., 6., 2., 1., 2., 1., 9., 8., 28., 15., 3., 9., 11., 20., 15., 1., 1., 5., 4., 13., 14., 16., 45., 13., 13., 13., 5., 1., 4., 2., 5., 0., 12., 5., 12., 21., 6., 19., 6., 4., 1., 0., 8., 0., 3., 1., 2., 5., 7., 7., 1., 5., 2., 2., 1., 2., 3., 0., 2., 3., 4., 0., 3., 2., 2., 1., 1., 0., 5., 1., 0., 11., 2., 0., 2., 2., 1., 1., 1., 0., 4., 1., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 2., 3., 7., 2., 9., 0., 4., 15., 1., 5., 23., 0., 14., 4., 3., 2., 16., 2., 7., 30., 18., 27., 31., 8., 3., 1., 4., 2., 5., 11., 22., 20., 4., 14., 6., 13., 10., 0., 0., 4., 1., 18., 7., 25., 43., 11., 30., 7., 6., 2., 8., 1., 8., 7., 7., 4., 7., 16., 6., 33., 4., 4., 2., 0., 3., 0., 1., 1., 9., 6., 5., 3., 0., 1., 1., 0., 2., 3., 5., 0., 2., 1., 2., 8., 2., 5., 3., 0., 2., 1., 3., 3., 2., 7., 1., 0., 3., 0., 0., 2., 1., 0., 6., 0., 2., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 1., 6., 9., 3., 2., 0., 7., 20., 0., 13., 18., 2., 19., 3., 0., 0., 25., 4., 3., 14., 14., 31., 31., 8., 1., 0., 1., 4., 6., 8., 29., 20., 2., 7., 3., 11., 3., 1., 0., 6., 0., 10., 15., 10., 56., 10., 29., 10., 8., 1., 4., 2., 17., 1., 6., 8., 7., 13., 4., 21., 10., 2., 1., 2., 5., 0., 3., 4., 8., 0., 7., 2., 3., 5., 2., 1., 1., 4., 2., 0., 1., 3., 4., 12., 4., 2., 1., 1., 2., 0., 2., 0., 1., 7., 4., 0., 1., 2., 2., 2., 1., 0., 3., 0., 3., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 0., 4., 12., 2., 7., 1., 2., 8., 2., 13., 27., 0., 14., 3., 0., 2., 10., 0., 5., 25., 12., 21., 20., 9., 1., 2., 5., 3., 9., 5., 27., 20., 1., 22., 2., 21., 9., 2., 2., 4., 3., 10., 8., 29., 46., 5., 23., 9., 3., 2., 7., 2., 6., 3., 8., 5., 7., 13., 10., 21., 5., 3., 0., 0., 6., 4., 3., 2., 5., 2., 4., 2., 4., 3., 4., 1., 2., 3., 3., 0., 0., 1., 2., 7., 0., 2., 1., 0., 4., 1., 0., 3., 4., 8., 0., 0., 4., 0., 3., 3., 1., 4., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 1., 3., 9., 2., 3., 3., 4., 25., 1., 13., 21., 0., 12., 1., 2., 1., 23., 2., 3., 13., 9., 30., 28., 6., 1., 1., 7., 0., 5., 5., 30., 21., 4., 17., 3., 18., 10., 2., 2., 5., 1., 16., 10., 19., 47., 10., 24., 9., 3., 0., 5., 5., 8., 5., 9., 9., 4., 19., 6., 26., 9., 2., 0., 2., 6., 1., 6., 1., 5., 4., 8., 3., 0., 4., 0., 3., 0., 4., 3., 0., 2., 2., 0., 8., 0., 1., 2., 1., 3., 0., 6., 2., 0., 12., 0., 0., 3., 3., 2., 3., 1., 2., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 3., 2., 4., 2., 6., 0., 12., 20., 2., 15., 28., 3., 15., 4., 0., 3., 14., 5., 5., 22., 6., 22., 27., 7., 0., 1., 1., 1., 8., 5., 41., 20., 2., 15., 4., 15., 9., 1., 1., 3., 1., 16., 5., 18., 39., 8., 18., 7., 6., 1., 7., 1., 5., 3., 12., 8., 9., 11., 8., 27., 6., 3., 1., 2., 11., 0., 3., 1., 4., 2., 4., 5., 1., 1., 4., 0., 0., 4., 2., 0., 1., 2., 1., 7., 3., 6., 1., 2., 7., 3., 2., 1., 2., 10., 3., 0., 2., 1., 0., 1., 2., 0., 2., 3., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 2., 3., 5., 11., 3., 4., 0., 6., 10., 0., 16., 23., 3., 19., 6., 0., 1., 23., 4., 6., 22., 11., 33., 30., 12., 1., 1., 7., 0., 9., 7., 29., 16., 2., 19., 4., 15., 5., 1., 2., 2., 3., 13., 17., 20., 47., 7., 21., 9., 4., 0., 6., 2., 11., 1., 12., 4., 9., 14., 4., 26., 7., 4., 0., 1., 9., 2., 5., 0., 3., 1., 6., 3., 7., 4., 7., 1., 3., 4., 4., 0., 1., 1., 2., 5., 3., 5., 0., 1., 3., 1., 2., 0., 1., 8., 2., 0., 2., 2., 2., 2., 4., 3., 5., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 2., 8., 2., 8., 5., 6., 4., 0., 17., 25., 0., 14., 5., 1., 1., 17., 5., 5., 23., 11., 18., 21., 7., 1., 1., 4., 0., 6., 13., 25., 13., 4., 12., 2., 10., 10., 1., 2., 4., 1., 14., 8., 11., 49., 13., 18., 8., 6., 0., 4., 1., 4., 5., 6., 5., 9., 14., 5., 22., 9., 3., 2., 1., 10., 1., 3., 2., 7., 3., 3., 7., 1., 0., 3., 2., 0., 3., 0., 0., 5., 1., 1., 7., 2., 5., 4., 4., 3., 3., 4., 1., 3., 7., 1., 0., 1., 1., 1., 3., 2., 1., 4., 1., 4., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 3., 7., 14., 5., 10., 2., 2., 25., 0., 16., 14., 1., 12., 4., 2., 2., 16., 2., 2., 15., 12., 13., 26., 4., 1., 1., 3., 1., 7., 9., 21., 13., 2., 4., 2., 18., 8., 2., 0., 1., 3., 9., 12., 18., 39., 12., 29., 4., 3., 1., 10., 3., 9., 3., 9., 10., 5., 12., 1., 27., 9., 4., 0., 1., 5., 1., 2., 2., 5., 2., 5., 4., 3., 6., 3., 3., 0., 2., 0., 0., 1., 1., 0., 9., 2., 1., 3., 4., 1., 2., 2., 0., 0., 9., 4., 0., 1., 2., 0., 2., 1., 4., 4., 0., 2., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 6., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 6., 10., 4., 4., 0., 4., 39., 1., 9., 27., 1., 16., 1., 2., 2., 26., 0., 6., 10., 8., 30., 26., 7., 2., 2., 1., 0., 6., 11., 24., 16., 6., 5., 5., 12., 6., 1., 2., 3., 2., 15., 6., 18., 39., 18., 15., 11., 8., 1., 6., 2., 4., 5., 8., 5., 11., 11., 6., 18., 4., 1., 1., 2., 12., 1., 0., 2., 6., 2., 6., 3., 1., 3., 2., 2., 0., 2., 1., 0., 0., 0., 1., 5., 3., 4., 2., 2., 7., 1., 2., 1., 4., 5., 1., 0., 1., 5., 0., 4., 5., 0., 1., 0., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 2., 7., 7., 2., 6., 0., 5., 14., 2., 12., 26., 3., 17., 2., 3., 2., 27., 3., 2., 19., 6., 17., 31., 4., 1., 1., 3., 2., 12., 9., 32., 12., 4., 14., 4., 13., 9., 4., 2., 1., 4., 15., 13., 22., 46., 20., 15., 11., 2., 2., 9., 1., 5., 1., 9., 3., 11., 13., 7., 23., 9., 1., 0., 4., 10., 0., 2., 1., 6., 4., 2., 0., 2., 5., 3., 3., 1., 2., 3., 0., 1., 2., 3., 6., 2., 3., 2., 0., 7., 2., 1., 1., 2., 6., 1., 0., 2., 4., 2., 2., 4., 4., 3., 2., 3., 0., 0., 0., 0., 4., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 1., 4., 7., 5., 9., 0., 7., 18., 2., 17., 20., 2., 9., 4., 2., 2., 13., 4., 2., 14., 18., 23., 27., 2., 1., 0., 4., 4., 9., 12., 26., 20., 2., 17., 3., 17., 5., 3., 1., 3., 5., 15., 5., 33., 41., 14., 22., 6., 6., 2., 4., 2., 10., 2., 2., 5., 10., 15., 9., 30., 6., 5., 1., 2., 6., 1., 7., 1., 4., 3., 3., 5., 3., 5., 7., 4., 2., 3., 5., 0., 4., 1., 1., 7., 3., 7., 2., 3., 5., 0., 2., 2., 3., 6., 3., 0., 4., 4., 1., 6., 4., 4., 4., 1., 2., 0., 0., 0., 0., 2., 0., 0., 6., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 4., 7., 7., 2., 7., 1., 4., 35., 2., 8., 21., 2., 20., 2., 2., 3., 17., 0., 5., 28., 9., 27., 17., 2., 1., 0., 1., 1., 9., 5., 24., 19., 4., 24., 8., 17., 10., 1., 0., 1., 4., 14., 14., 14., 42., 13., 23., 9., 8., 2., 3., 1., 6., 1., 11., 9., 8., 18., 3., 26., 7., 7., 0., 0., 8., 0., 1., 1., 6., 0., 5., 2., 1., 3., 4., 6., 2., 4., 0., 0., 0., 5., 0., 8., 0., 5., 1., 4., 4., 1., 1., 2., 2., 4., 0., 0., 3., 3., 2., 3., 2., 1., 2., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 3., 1., 7., 3., 3., 2., 6., 32., 0., 9., 16., 0., 9., 1., 1., 0., 17., 1., 3., 12., 11., 31., 23., 6., 3., 0., 4., 2., 7., 10., 19., 18., 4., 12., 1., 17., 10., 5., 1., 5., 0., 16., 7., 14., 45., 14., 24., 4., 5., 3., 0., 1., 4., 2., 14., 5., 7., 18., 3., 23., 7., 2., 1., 1., 7., 0., 1., 1., 5., 7., 2., 1., 2., 5., 1., 4., 0., 2., 2., 0., 3., 2., 3., 7., 1., 1., 3., 1., 4., 2., 1., 0., 4., 8., 2., 0., 2., 2., 3., 1., 1., 0., 2., 0., 2., 0., 0., 0., 0., 1., 0., 0., 5., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 0., 4., 10., 0., 15., 1., 7., 44., 0., 9., 62., 0., 4., 2., 0., 0., 69., 9., 12., 77., 15., 84., 9., 2., 0., 1., 6., 4., 16., 6., 43., 12., 1., 42., 38., 23., 6., 0., 2., 12., 0., 24., 2., 20., 6., 18., 3., 3., 0., 0., 8., 7., 8., 3., 19., 4., 10., 1., 3., 41., 10., 8., 1., 0., 13., 2., 12., 4., 14., 1., 3., 0., 0., 1., 0., 3., 0., 17., 8., 1., 4., 0., 2., 0., 0., 0., 0., 0., 10., 3., 1., 0., 5., 1., 0., 0., 3., 0., 1., 0., 0., 3., 2., 0., 1., 0., 2., 0., 1., 0., 0., 0., 1., 0., 1., 0., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 23., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 3., 5., 12., 0., 16., 3., 8., 45., 1., 6., 69., 1., 4., 1., 0., 2., 81., 6., 5., 91., 20., 74., 13., 4., 0., 1., 3., 1., 14., 8., 55., 10., 2., 32., 41., 12., 6., 0., 0., 11., 4., 26., 3., 26., 8., 16., 4., 3., 2., 0., 7., 2., 19., 6., 17., 4., 10., 2., 5., 33., 7., 10., 0., 0., 11., 8., 11., 3., 10., 2., 6., 3., 1., 0., 0., 9., 3., 11., 6., 2., 3., 1., 2., 0., 0., 0., 0., 0., 11., 5., 1., 1., 3., 1., 1., 0., 4., 0., 1., 0., 0., 2., 0., 0., 4., 0., 0., 0., 3., 0., 0., 0., 1., 0., 3., 1., 2., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 22., 0., 4., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 2., 5., 9., 0., 10., 1., 11., 55., 2., 5., 56., 1., 4., 0., 0., 4., 66., 7., 12., 81., 15., 82., 16., 3., 0., 2., 3., 5., 17., 10., 59., 19., 2., 41., 30., 18., 1., 0., 1., 3., 9., 20., 9., 18., 7., 14., 12., 3., 2., 0., 11., 3., 16., 4., 12., 3., 13., 6., 5., 35., 11., 2., 1., 0., 7., 3., 6., 3., 12., 1., 4., 0., 0., 2., 0., 6., 0., 18., 11., 3., 4., 1., 0., 0., 0., 0., 0., 0., 9., 4., 3., 1., 2., 1., 2., 0., 0., 0., 2., 0., 1., 3., 2., 0., 4., 0., 1., 0., 0., 0., 0., 0., 1., 0., 2., 1., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 19., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 2., 5., 9., 0., 15., 3., 9., 53., 2., 6., 47., 2., 7., 1., 0., 1., 66., 4., 5., 83., 14., 93., 8., 0., 0., 2., 2., 3., 21., 7., 73., 14., 3., 44., 30., 9., 8., 0., 1., 4., 5., 18., 6., 25., 7., 12., 5., 2., 1., 0., 12., 4., 10., 5., 17., 2., 10., 3., 4., 45., 11., 5., 4., 0., 9., 4., 13., 3., 9., 4., 3., 0., 0., 0., 0., 2., 1., 16., 8., 5., 2., 1., 3., 0., 0., 0., 0., 0., 13., 1., 3., 1., 1., 0., 1., 0., 2., 0., 3., 0., 0., 0., 1., 0., 2., 0., 1., 0., 1., 0., 0., 0., 1., 0., 1., 1., 3., 0., 0., 0., 0., 0., 9., 0., 0., 0., 0., 23., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 7., 12., 0., 17., 1., 5., 50., 0., 6., 62., 1., 7., 0., 0., 1., 58., 8., 6., 77., 20., 84., 13., 5., 0., 1., 2., 1., 10., 8., 42., 9., 1., 43., 29., 15., 1., 0., 0., 5., 1., 21., 5., 26., 6., 10., 4., 1., 3., 0., 10., 9., 20., 4., 11., 1., 6., 4., 5., 42., 3., 9., 3., 0., 11., 3., 5., 2., 9., 3., 3., 1., 1., 0., 0., 2., 1., 9., 11., 7., 4., 0., 3., 0., 0., 0., 0., 0., 10., 3., 4., 1., 6., 0., 2., 0., 0., 0., 1., 0., 0., 2., 3., 0., 3., 0., 1., 0., 1., 0., 0., 0., 1., 0., 0., 1., 1., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 28., 0., 4., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 1., 8., 9., 0., 9., 2., 12., 54., 3., 4., 73., 0., 6., 1., 0., 3., 81., 9., 7., 70., 13., 80., 10., 6., 0., 0., 2., 3., 17., 14., 43., 13., 2., 39., 32., 12., 5., 0., 2., 2., 2., 28., 5., 13., 8., 6., 2., 5., 2., 0., 7., 4., 19., 3., 16., 3., 6., 5., 1., 30., 9., 8., 1., 0., 16., 5., 9., 2., 8., 2., 5., 0., 1., 0., 0., 4., 1., 18., 17., 4., 4., 1., 1., 0., 0., 0., 0., 0., 10., 2., 4., 4., 4., 2., 1., 0., 1., 0., 0., 0., 1., 2., 3., 0., 1., 0., 1., 0., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 2., 0., 7., 0., 0., 0., 0., 25., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 4., 11., 0., 17., 5., 9., 56., 1., 11., 64., 4., 4., 2., 0., 0., 88., 8., 9., 74., 18., 77., 15., 3., 0., 4., 6., 2., 17., 16., 60., 8., 2., 37., 42., 14., 3., 0., 1., 4., 1., 31., 7., 24., 7., 13., 1., 2., 2., 0., 6., 2., 18., 5., 21., 4., 9., 6., 1., 40., 8., 6., 3., 0., 15., 2., 9., 2., 12., 2., 5., 0., 1., 1., 0., 7., 3., 14., 8., 6., 5., 0., 3., 0., 0., 0., 0., 0., 11., 2., 2., 1., 4., 3., 1., 0., 0., 0., 0., 0., 2., 3., 0., 0., 3., 0., 1., 0., 1., 0., 0., 0., 1., 0., 2., 4., 3., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 21., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

27., 2., 2., 8., 19., 3., 32., 1., 20., 173., 1., 23., 213., 7., 25., 4., 0., 6., 93., 1., 16., 308., 40., 330., 29., 18., 0., 2., 6., 2., 29., 41., 234., 43., 4., 160., 16., 39., 8., 0., 5., 23., 6., 91., 19., 98., 10., 32., 48., 15., 1., 2., 34., 11., 25., 7., 50., 11., 21., 4., 14., 9., 3., 0., 1., 0., 24., 7., 14., 0., 35., 4., 16., 10., 0., 6., 1., 0., 4., 3., 7., 0., 8., 3., 9., 1., 0., 5., 127., 10., 1851., 92., 105., 245., 102., 97., 69., 16., 18., 25., 15., 0., 2., 5., 5., 7., 11., 8., 34., 16., 36., 13., 32., 5., 8., 4., 3., 5., 7., 0., 1., 5., 8., 4., 0., 4., 4., 19., 4., 0., 8., 5., 3., 0., 4., 2., 4., 28., 1., 12., 2., 11., 2., 14., 3., 2., 5., 7., 26., 7., 27., 13., 6., 9., 5., 35., 9., 7., 5.,

12., 6., 6., 8., 23., 6., 28., 2., 17., 167., 3., 28., 173., 4., 12., 7., 0., 7., 84., 2., 14., 273., 42., 303., 38., 12., 0., 1., 5., 5., 34., 25., 215., 34., 8., 155., 13., 35., 3., 0., 5., 7., 9., 79., 23., 77., 14., 32., 42., 19., 1., 1., 33., 5., 32., 13., 50., 11., 29., 11., 13., 8., 1., 0., 2., 0., 32., 11., 8., 3., 23., 6., 7., 9., 1., 2., 0., 0., 3., 1., 9., 3., 6., 3., 8., 2., 1., 3., 144., 10., 1924., 92., 112., 259., 92., 97., 75., 16., 15., 14., 20., 0., 3., 6., 6., 4., 8., 16., 35., 16., 39., 21., 38., 6., 7., 6., 6., 5., 6., 2., 6., 5., 6., 3., 0., 5., 3., 11., 2., 0., 12., 2., 1., 0., 3., 1., 3., 33., 2., 4., 1., 13., 5., 21., 1., 2., 1., 1., 28., 3., 33., 4., 3., 9., 3., 38., 6., 4., 7.,

12., 0., 1., 6., 8., 2., 6., 0., 8., 18., 0., 11., 22., 0., 15., 2., 0., 3., 16., 0., 10., 23., 11., 19., 38., 12., 1., 1., 2., 3., 6., 5., 15., 19., 2., 12., 2., 16., 8., 1., 1., 7., 3., 12., 12., 14., 55., 8., 16., 6., 5., 2., 5., 2., 6., 3., 16., 1., 10., 13., 5., 23., 9., 3., 2., 0., 4., 1., 1., 3., 2., 5., 1., 5., 2., 5., 3., 2., 3., 2., 2., 0., 1., 1., 2., 7., 2., 3., 0., 7., 5., 0., 4., 1., 2., 6., 4., 0., 0., 2., 4., 1., 4., 3., 3., 0., 3., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

16., 2., 1., 6., 5., 0., 8., 3., 4., 26., 0., 17., 21., 1., 15., 4., 0., 2., 16., 3., 2., 6., 12., 35., 21., 5., 0., 1., 2., 3., 9., 4., 36., 18., 1., 12., 2., 16., 6., 1., 1., 2., 1., 16., 15., 16., 43., 18., 12., 13., 3., 1., 5., 1., 6., 5., 10., 8., 10., 21., 4., 19., 8., 2., 2., 4., 10., 2., 2., 1., 3., 4., 3., 4., 3., 3., 2., 5., 1., 1., 2., 0., 3., 2., 0., 4., 2., 6., 5., 1., 3., 0., 6., 1., 3., 8., 2., 0., 3., 0., 2., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 3., 9., 5., 9., 2., 6., 22., 3., 2., 34., 1., 16., 3., 1., 0., 22., 1., 4., 30., 17., 32., 23., 4., 2., 3., 4., 0., 6., 4., 31., 18., 1., 12., 2., 12., 7., 4., 3., 3., 2., 8., 18., 15., 54., 11., 13., 6., 4., 1., 3., 2., 5., 1., 9., 5., 6., 25., 5., 25., 3., 4., 1., 2., 6., 0., 4., 3., 7., 4., 4., 6., 1., 4., 5., 2., 2., 2., 3., 0., 4., 2., 2., 10., 0., 3., 1., 3., 5., 4., 2., 0., 5., 6., 0., 0., 1., 3., 3., 5., 0., 2., 1., 1., 2., 0., 0., 0., 0., 3., 0., 0., 5., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 1., 7., 4., 1., 4., 0., 9., 26., 0., 11., 18., 1., 13., 4., 0., 2., 19., 2., 5., 22., 13., 23., 24., 5., 1., 1., 4., 2., 6., 11., 31., 16., 4., 15., 0., 17., 11., 2., 1., 2., 2., 13., 11., 10., 51., 18., 20., 7., 3., 1., 5., 5., 15., 1., 5., 7., 12., 16., 8., 18., 5., 2., 3., 0., 4., 3., 3., 2., 2., 2., 3., 5., 2., 8., 1., 2., 2., 2., 1., 0., 1., 1., 2., 12., 0., 1., 3., 1., 4., 1., 4., 0., 1., 10., 0., 0., 2., 0., 0., 2., 1., 3., 4., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 3., 3., 2., 9., 2., 5., 0., 10., 16., 3., 11., 31., 3., 12., 8., 0., 2., 25., 2., 4., 6., 12., 14., 23., 5., 0., 0., 1., 4., 15., 5., 38., 15., 2., 15., 3., 15., 3., 3., 0., 3., 1., 13., 9., 11., 50., 7., 26., 10., 5., 0., 7., 2., 11., 3., 6., 5., 7., 12., 5., 19., 8., 2., 3., 2., 8., 1., 3., 2., 4., 3., 4., 3., 2., 6., 4., 0., 0., 3., 2., 0., 3., 0., 1., 10., 3., 6., 3., 1., 3., 1., 2., 0., 2., 6., 1., 0., 2., 2., 4., 1., 3., 3., 2., 1., 1., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 2., 1., 3., 17., 5., 7., 1., 3., 23., 0., 15., 20., 1., 16., 4., 1., 2., 25., 1., 6., 32., 18., 19., 28., 7., 1., 1., 4., 1., 4., 7., 17., 16., 5., 26., 9., 17., 10., 1., 0., 4., 2., 15., 12., 23., 44., 9., 20., 5., 3., 0., 1., 2., 6., 4., 11., 1., 3., 10., 3., 21., 5., 1., 2., 0., 10., 0., 2., 1., 1., 4., 2., 5., 1., 0., 2., 2., 2., 1., 4., 0., 3., 4., 3., 7., 2., 4., 0., 0., 5., 0., 3., 0., 2., 8., 2., 0., 5., 6., 5., 1., 1., 1., 1., 0., 1., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 6., 6., 5., 6., 0., 5., 10., 1., 12., 25., 1., 13., 1., 1., 1., 17., 3., 5., 22., 12., 12., 25., 2., 1., 1., 4., 5., 9., 9., 21., 15., 2., 16., 2., 12., 7., 2., 3., 2., 2., 10., 7., 15., 60., 11., 16., 8., 4., 0., 7., 3., 6., 2., 7., 6., 8., 9., 6., 23., 11., 1., 1., 1., 11., 0., 1., 1., 5., 4., 7., 5., 3., 5., 2., 3., 1., 1., 0., 0., 1., 0., 2., 7., 4., 2., 3., 0., 2., 0., 0., 2., 2., 11., 3., 0., 2., 0., 2., 2., 1., 1., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 1., 5., 6., 3., 5., 1., 6., 25., 0., 13., 16., 2., 15., 2., 2., 2., 8., 1., 5., 21., 10., 13., 31., 5., 0., 2., 2., 1., 11., 15., 25., 16., 1., 13., 2., 13., 10., 2., 3., 5., 1., 7., 10., 17., 41., 9., 14., 9., 3., 3., 5., 2., 7., 2., 12., 7., 2., 19., 6., 20., 6., 0., 2., 0., 8., 0., 3., 0., 3., 2., 2., 5., 1., 6., 5., 3., 0., 2., 2., 0., 2., 2., 3., 1., 1., 6., 3., 0., 5., 1., 3., 0., 1., 10., 4., 0., 2., 0., 2., 3., 1., 2., 0., 2., 3., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 7., 8., 1., 6., 0., 8., 30., 0., 11., 20., 1., 25., 7., 0., 5., 15., 2., 1., 5., 13., 23., 27., 2., 1., 0., 4., 2., 10., 6., 18., 19., 3., 22., 4., 15., 11., 3., 1., 5., 2., 12., 7., 15., 44., 6., 19., 6., 2., 1., 4., 5., 3., 2., 4., 9., 11., 19., 8., 16., 10., 5., 1., 2., 5., 0., 3., 3., 9., 3., 6., 4., 1., 1., 3., 0., 2., 0., 5., 0., 4., 3., 5., 8., 2., 4., 0., 1., 4., 3., 0., 0., 4., 2., 2., 0., 4., 2., 2., 3., 2., 0., 3., 1., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 3., 1., 8., 2., 2., 2., 9., 9., 1., 16., 15., 0., 19., 2., 2., 3., 25., 5., 2., 29., 9., 35., 15., 8., 1., 0., 3., 1., 12., 4., 22., 16., 5., 13., 3., 18., 9., 4., 0., 5., 2., 16., 14., 11., 52., 13., 24., 12., 3., 0., 2., 2., 5., 3., 7., 4., 9., 18., 3., 30., 4., 3., 0., 0., 8., 0., 3., 1., 3., 3., 6., 3., 1., 6., 6., 3., 1., 1., 3., 0., 3., 3., 2., 7., 3., 2., 2., 4., 6., 0., 2., 0., 0., 4., 2., 0., 1., 0., 2., 4., 0., 4., 4., 0., 0., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 3., 4., 4., 5., 9., 1., 4., 36., 0., 2., 24., 0., 20., 4., 3., 4., 15., 1., 3., 30., 15., 21., 26., 9., 1., 0., 3., 1., 5., 5., 33., 14., 3., 16., 2., 8., 6., 2., 2., 5., 0., 17., 7., 16., 47., 11., 23., 9., 3., 1., 6., 3., 5., 1., 13., 7., 12., 15., 9., 20., 11., 4., 2., 3., 4., 1., 3., 1., 6., 5., 2., 2., 2., 4., 2., 4., 0., 4., 2., 0., 3., 1., 2., 7., 1., 10., 2., 0., 3., 1., 1., 0., 1., 6., 3., 0., 4., 3., 3., 0., 1., 1., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 0., 1., 7., 5., 1., 4., 1., 5., 14., 0., 14., 25., 0., 16., 5., 1., 3., 20., 4., 5., 13., 9., 23., 21., 6., 0., 2., 2., 1., 4., 3., 23., 17., 3., 12., 1., 15., 10., 5., 3., 5., 1., 12., 11., 13., 47., 7., 11., 11., 3., 0., 6., 3., 4., 1., 13., 3., 10., 18., 5., 23., 4., 3., 1., 0., 6., 1., 3., 1., 2., 2., 4., 3., 4., 4., 5., 1., 1., 2., 2., 0., 0., 1., 0., 3., 0., 4., 2., 3., 3., 1., 2., 2., 2., 5., 2., 0., 1., 2., 4., 3., 3., 1., 2., 1., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 3., 1., 6., 5., 0., 8., 1., 4., 22., 1., 10., 17., 1., 15., 4., 0., 1., 12., 1., 6., 19., 11., 23., 27., 4., 2., 0., 5., 1., 7., 9., 21., 17., 3., 18., 4., 13., 13., 5., 0., 2., 3., 20., 8., 22., 48., 10., 22., 9., 9., 5., 5., 1., 5., 2., 6., 4., 10., 16., 6., 21., 9., 4., 0., 3., 5., 1., 1., 0., 3., 3., 2., 5., 0., 4., 2., 1., 2., 3., 4., 0., 5., 5., 1., 7., 2., 8., 0., 5., 7., 0., 1., 1., 4., 9., 1., 0., 2., 1., 2., 1., 2., 1., 2., 0., 3., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 0., 3., 5., 2., 5., 4., 8., 29., 1., 9., 32., 2., 14., 1., 3., 3., 16., 8., 7., 24., 13., 28., 33., 2., 0., 3., 4., 2., 9., 2., 19., 12., 2., 20., 0., 18., 8., 4., 0., 3., 3., 12., 17., 25., 55., 10., 33., 6., 4., 0., 7., 2., 8., 3., 9., 9., 7., 16., 7., 21., 12., 5., 2., 0., 6., 4., 0., 4., 8., 6., 2., 6., 3., 3., 4., 2., 0., 1., 1., 0., 4., 1., 2., 5., 4., 3., 2., 0., 10., 0., 1., 2., 5., 6., 5., 0., 1., 1., 3., 3., 1., 2., 3., 3., 1., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 2., 2., 6., 3., 8., 0., 4., 26., 1., 8., 16., 0., 16., 0., 0., 1., 17., 2., 3., 26., 8., 22., 25., 6., 0., 1., 2., 2., 3., 12., 21., 15., 4., 18., 3., 11., 9., 1., 1., 3., 0., 16., 10., 20., 37., 14., 23., 8., 5., 0., 1., 0., 3., 7., 11., 5., 8., 20., 8., 22., 11., 2., 2., 1., 6., 2., 6., 3., 5., 2., 7., 3., 3., 7., 2., 5., 0., 4., 5., 0., 2., 1., 3., 3., 6., 4., 2., 5., 7., 1., 2., 2., 1., 7., 3., 0., 2., 3., 5., 1., 4., 3., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 3., 2., 3., 5., 1., 8., 2., 6., 7., 2., 11., 9., 3., 17., 1., 1., 2., 8., 3., 2., 20., 13., 27., 30., 6., 0., 1., 6., 1., 10., 5., 35., 18., 0., 10., 4., 4., 9., 2., 0., 5., 2., 13., 9., 17., 48., 22., 33., 10., 8., 2., 6., 3., 14., 2., 8., 3., 7., 17., 8., 15., 8., 6., 2., 2., 9., 2., 1., 0., 8., 2., 6., 5., 3., 7., 4., 1., 0., 0., 5., 0., 3., 0., 2., 9., 3., 3., 5., 1., 2., 1., 2., 0., 1., 6., 4., 0., 3., 3., 3., 1., 2., 2., 5., 2., 3., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 2., 1., 3., 7., 3., 4., 3., 8., 13., 2., 20., 24., 2., 13., 2., 0., 3., 21., 3., 3., 25., 2., 17., 28., 9., 0., 2., 6., 3., 7., 2., 21., 13., 6., 12., 4., 16., 11., 0., 1., 1., 2., 8., 9., 22., 55., 16., 29., 4., 3., 2., 5., 1., 5., 0., 6., 9., 12., 17., 7., 14., 5., 5., 1., 1., 9., 0., 5., 0., 5., 5., 4., 3., 6., 7., 6., 1., 1., 1., 3., 0., 1., 3., 1., 7., 1., 3., 0., 1., 1., 0., 3., 1., 0., 9., 1., 0., 2., 5., 1., 4., 3., 1., 3., 3., 1., 0., 0., 0., 0., 1., 0., 0., 8., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 1., 6., 6., 9., 1., 9., 0., 0., 19., 0., 16., 31., 3., 13., 2., 2., 1., 27., 0., 2., 22., 17., 15., 23., 10., 0., 1., 1., 4., 10., 14., 27., 16., 3., 16., 4., 9., 8., 3., 2., 3., 1., 23., 13., 18., 40., 12., 22., 14., 1., 0., 4., 4., 10., 4., 9., 4., 9., 19., 11., 16., 8., 4., 1., 3., 2., 1., 5., 2., 3., 1., 4., 4., 1., 3., 3., 5., 1., 2., 2., 0., 4., 1., 3., 2., 1., 8., 0., 3., 4., 0., 2., 0., 2., 2., 3., 0., 0., 1., 0., 2., 2., 0., 2., 2., 1., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 3., 1., 2., 10., 3., 7., 1., 9., 26., 1., 13., 22., 0., 15., 3., 1., 5., 21., 2., 8., 4., 12., 24., 29., 5., 1., 0., 2., 0., 4., 5., 17., 11., 3., 14., 5., 10., 12., 4., 0., 4., 3., 14., 14., 17., 44., 14., 24., 9., 1., 0., 3., 4., 10., 2., 12., 7., 7., 23., 8., 20., 5., 1., 1., 4., 4., 1., 1., 1., 3., 4., 4., 4., 1., 7., 2., 4., 0., 1., 3., 0., 0., 1., 3., 7., 1., 3., 2., 2., 4., 1., 1., 3., 4., 10., 3., 0., 5., 3., 3., 3., 1., 3., 2., 2., 0., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 2., 1., 4., 9., 3., 3., 0., 4., 28., 0., 14., 19., 0., 9., 3., 2., 1., 23., 2., 4., 21., 15., 23., 27., 2., 0., 1., 3., 2., 6., 7., 14., 8., 5., 18., 5., 8., 9., 2., 0., 4., 3., 12., 7., 17., 48., 10., 28., 5., 4., 1., 1., 1., 2., 0., 19., 11., 5., 11., 4., 12., 6., 4., 0., 3., 8., 1., 6., 1., 8., 3., 7., 7., 3., 5., 2., 3., 1., 4., 3., 0., 4., 2., 2., 3., 0., 5., 3., 4., 3., 1., 2., 0., 2., 7., 3., 0., 2., 3., 1., 1., 4., 1., 1., 0., 3., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 2., 6., 2., 3., 4., 2., 7., 23., 1., 14., 25., 1., 14., 2., 1., 2., 21., 2., 4., 31., 14., 26., 32., 6., 2., 1., 4., 3., 11., 6., 10., 16., 3., 17., 6., 19., 12., 3., 0., 8., 2., 10., 13., 10., 37., 11., 21., 10., 3., 1., 6., 3., 7., 4., 9., 7., 12., 13., 7., 24., 7., 3., 1., 2., 8., 1., 3., 1., 2., 1., 6., 4., 2., 4., 3., 0., 5., 1., 3., 0., 1., 2., 0., 7., 0., 8., 3., 4., 4., 2., 3., 0., 5., 4., 1., 0., 2., 4., 5., 1., 3., 4., 2., 3., 3., 0., 0., 0., 0., 3., 0., 0., 5., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 0., 1., 8., 5., 4., 0., 10., 21., 2., 10., 12., 1., 14., 4., 1., 1., 17., 4., 4., 24., 13., 33., 17., 6., 0., 1., 2., 1., 5., 4., 33., 14., 4., 20., 3., 10., 7., 1., 3., 6., 2., 6., 11., 15., 51., 18., 19., 12., 4., 1., 5., 4., 2., 2., 9., 5., 5., 13., 5., 21., 8., 3., 0., 1., 7., 0., 2., 0., 7., 2., 6., 6., 0., 2., 3., 2., 1., 0., 0., 0., 4., 2., 0., 5., 4., 4., 0., 1., 5., 1., 4., 2., 3., 5., 0., 0., 4., 1., 1., 2., 2., 1., 2., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 2., 3., 1., 17., 0., 17., 0., 6., 45., 1., 8., 57., 1., 4., 3., 0., 1., 64., 5., 6., 69., 12., 71., 9., 5., 0., 1., 2., 2., 20., 17., 49., 9., 1., 38., 35., 19., 4., 0., 0., 8., 5., 22., 5., 23., 10., 10., 6., 3., 3., 0., 6., 5., 15., 6., 15., 3., 9., 1., 3., 43., 11., 3., 0., 0., 16., 3., 5., 0., 8., 3., 2., 0., 0., 2., 0., 3., 2., 18., 8., 4., 4., 2., 2., 0., 0., 0., 0., 0., 7., 1., 5., 1., 1., 1., 1., 0., 0., 0., 0., 0., 1., 2., 1., 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 0., 1., 0., 0., 0., 0., 0., 7., 0., 0., 0., 0., 35., 0., 2., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 2., 2., 10., 0., 11., 1., 9., 44., 1., 10., 48., 0., 4., 1., 0., 1., 78., 8., 5., 76., 14., 79., 13., 0., 0., 1., 2., 4., 11., 10., 41., 17., 2., 39., 32., 20., 5., 0., 3., 3., 2., 20., 5., 22., 7., 21., 3., 5., 5., 0., 9., 5., 20., 2., 22., 3., 9., 3., 6., 30., 19., 9., 1., 0., 8., 3., 8., 2., 16., 1., 2., 0., 2., 0., 0., 4., 2., 18., 8., 2., 4., 2., 2., 0., 0., 0., 0., 0., 8., 3., 1., 1., 3., 1., 0., 0., 1., 0., 2., 0., 1., 5., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 2., 1., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 17., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 1., 7., 10., 0., 13., 1., 5., 52., 1., 8., 63., 1., 4., 2., 0., 1., 69., 8., 11., 101., 19., 71., 7., 6., 0., 0., 0., 2., 18., 7., 51., 10., 0., 38., 28., 12., 1., 0., 1., 5., 3., 29., 13., 17., 11., 14., 8., 5., 3., 0., 11., 4., 10., 7., 15., 6., 10., 1., 2., 33., 10., 5., 2., 0., 15., 3., 10., 1., 12., 0., 4., 0., 0., 1., 0., 8., 3., 14., 7., 2., 4., 2., 3., 0., 0., 0., 0., 0., 9., 2., 4., 5., 3., 1., 0., 0., 0., 0., 0., 0., 0., 4., 2., 0., 1., 0., 1., 0., 0., 0., 0., 0., 1., 0., 2., 5., 2., 0., 0., 0., 2., 0., 7., 0., 0., 0., 0., 23., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 1., 4., 12., 0., 8., 2., 4., 60., 1., 7., 62., 1., 6., 0., 0., 0., 80., 2., 10., 81., 13., 79., 13., 4., 0., 0., 3., 0., 20., 14., 63., 11., 2., 35., 40., 7., 3., 0., 0., 4., 2., 21., 6., 21., 8., 11., 3., 1., 5., 0., 7., 6., 23., 5., 16., 3., 7., 2., 2., 29., 8., 10., 3., 0., 12., 2., 5., 1., 14., 2., 2., 0., 1., 2., 0., 2., 1., 21., 8., 3., 5., 1., 2., 0., 0., 0., 0., 0., 10., 6., 3., 1., 2., 2., 2., 0., 1., 0., 1., 0., 1., 0., 2., 0., 1., 0., 0., 0., 2., 0., 0., 0., 3., 0., 1., 2., 0., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 19., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 7., 6., 12., 0., 15., 0., 10., 59., 1., 10., 61., 0., 6., 0., 0., 4., 79., 10., 8., 77., 11., 61., 12., 2., 0., 1., 0., 1., 17., 6., 44., 11., 2., 35., 36., 16., 3., 0., 1., 5., 5., 27., 7., 34., 10., 15., 4., 4., 6., 0., 4., 5., 20., 4., 14., 5., 6., 3., 2., 42., 9., 3., 1., 0., 13., 0., 6., 5., 11., 3., 4., 4., 1., 0., 0., 3., 0., 17., 11., 3., 4., 0., 1., 0., 0., 0., 0., 0., 10., 3., 4., 3., 4., 1., 0., 0., 0., 0., 0., 0., 0., 2., 5., 0., 1., 0., 0., 0., 2., 0., 0., 0., 1., 0., 3., 4., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 24., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 2., 9., 0., 19., 2., 10., 36., 1., 6., 43., 2., 6., 2., 0., 1., 76., 7., 7., 45., 21., 66., 16., 2., 0., 4., 3., 1., 13., 3., 48., 11., 4., 46., 24., 10., 15., 0., 2., 6., 2., 16., 5., 25., 6., 8., 12., 4., 1., 0., 14., 1., 18., 5., 20., 3., 10., 6., 3., 41., 9., 3., 2., 0., 12., 4., 5., 3., 12., 1., 10., 2., 2., 1., 0., 6., 4., 10., 16., 5., 1., 0., 1., 0., 0., 0., 0., 0., 7., 2., 3., 2., 2., 2., 2., 0., 1., 0., 0., 0., 3., 4., 2., 0., 2., 0., 0., 0., 1., 0., 0., 0., 2., 0., 5., 1., 0., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 25., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 1., 2., 9., 0., 14., 2., 6., 45., 2., 7., 63., 1., 5., 2., 0., 2., 74., 18., 7., 78., 14., 56., 8., 5., 0., 0., 2., 3., 16., 7., 47., 11., 2., 36., 35., 17., 4., 0., 2., 8., 2., 21., 10., 28., 6., 10., 6., 2., 2., 0., 8., 7., 25., 5., 21., 2., 7., 4., 6., 40., 7., 5., 0., 0., 14., 5., 12., 4., 13., 1., 5., 0., 1., 0., 0., 4., 2., 14., 10., 2., 5., 0., 4., 0., 0., 0., 0., 0., 8., 4., 5., 0., 2., 0., 0., 0., 2., 0., 2., 0., 1., 5., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 35., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 4., 4., 11., 0., 14., 1., 8., 44., 1., 6., 71., 1., 9., 1., 0., 2., 76., 10., 5., 92., 18., 59., 9., 5., 0., 0., 5., 1., 13., 6., 50., 12., 1., 42., 33., 16., 5., 0., 0., 5., 0., 28., 10., 30., 8., 14., 8., 7., 2., 0., 7., 3., 19., 4., 19., 2., 12., 6., 4., 35., 5., 5., 1., 0., 19., 6., 7., 2., 15., 2., 6., 0., 1., 2., 0., 7., 1., 21., 9., 5., 1., 1., 1., 0., 0., 0., 0., 0., 7., 4., 0., 3., 6., 0., 0., 0., 3., 0., 2., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 2., 3., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 31., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 0., 3., 4., 21., 5., 29., 1., 15., 153., 2., 29., 230., 5., 19., 3., 4., 4., 86., 1., 8., 289., 52., 351., 42., 18., 1., 0., 3., 6., 39., 36., 229., 41., 7., 145., 12., 29., 10., 0., 4., 16., 7., 69., 21., 86., 15., 27., 38., 12., 2., 3., 32., 5., 36., 12., 49., 6., 26., 3., 8., 3., 3., 0., 0., 0., 20., 5., 13., 5., 36., 7., 13., 10., 2., 5., 0., 1., 4., 4., 13., 2., 5., 2., 8., 0., 1., 5., 153., 9., 1858., 98., 101., 220., 106., 111., 66., 21., 10., 21., 8., 1., 2., 2., 3., 2., 13., 10., 34., 15., 34., 21., 38., 9., 12., 2., 5., 1., 4., 2., 4., 1., 13., 8., 0., 3., 5., 17., 1., 0., 13., 4., 2., 0., 5., 2., 4., 36., 1., 6., 0., 18., 2., 21., 4., 2., 2., 8., 20., 7., 26., 4., 7., 8., 2., 26., 5., 9., 5.,

18., 1., 6., 7., 32., 9., 35., 1., 7., 163., 2., 30., 199., 3., 16., 3., 0., 4., 78., 3., 16., 277., 52., 327., 45., 19., 3., 2., 10., 2., 37., 34., 203., 41., 5., 144., 9., 53., 9., 0., 5., 12., 9., 76., 25., 93., 19., 26., 46., 15., 2., 2., 19., 3., 50., 9., 59., 12., 39., 8., 4., 5., 1., 0., 1., 0., 18., 5., 15., 3., 33., 3., 15., 5., 0., 3., 0., 1., 2., 0., 12., 2., 12., 0., 6., 0., 0., 4., 136., 6., 1880., 78., 118., 214., 106., 137., 70., 17., 14., 15., 15., 0., 2., 5., 4., 2., 9., 8., 28., 12., 33., 17., 39., 10., 14., 2., 6., 5., 3., 3., 1., 4., 7., 4., 0., 4., 5., 12., 0., 0., 10., 2., 2., 0., 7., 4., 3., 25., 1., 8., 2., 9., 3., 16., 4., 3., 4., 8., 19., 6., 34., 6., 1., 7., 3., 32., 11., 18., 1.,

9., 6., 4., 5., 6., 3., 6., 0., 5., 23., 0., 11., 19., 0., 10., 3., 0., 2., 10., 2., 4., 23., 17., 17., 28., 4., 1., 0., 2., 1., 5., 9., 18., 11., 4., 22., 1., 15., 10., 3., 0., 5., 0., 18., 10., 14., 57., 8., 19., 5., 4., 2., 5., 1., 6., 3., 4., 5., 12., 12., 6., 23., 11., 2., 1., 2., 9., 1., 2., 0., 5., 5., 4., 6., 2., 5., 2., 1., 2., 2., 2., 0., 0., 1., 1., 6., 2., 4., 1., 2., 4., 2., 0., 3., 1., 8., 0., 0., 1., 1., 0., 4., 1., 2., 3., 1., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 7., 10., 5., 6., 1., 7., 24., 1., 12., 15., 1., 14., 5., 1., 1., 7., 2., 5., 35., 13., 27., 24., 5., 2., 0., 2., 4., 6., 11., 31., 13., 1., 11., 4., 13., 6., 2., 1., 3., 1., 15., 6., 15., 44., 5., 17., 9., 2., 3., 8., 2., 8., 2., 6., 5., 9., 12., 8., 22., 7., 2., 0., 0., 6., 1., 2., 1., 9., 2., 5., 2., 1., 1., 3., 4., 0., 1., 0., 0., 4., 2., 4., 7., 2., 3., 3., 2., 2., 0., 3., 1., 1., 9., 2., 0., 2., 4., 3., 3., 2., 2., 4., 2., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

17., 1., 1., 1., 5., 2., 2., 3., 3., 31., 0., 17., 15., 0., 15., 1., 2., 1., 25., 2., 2., 12., 7., 20., 29., 5., 1., 4., 3., 0., 10., 11., 24., 18., 5., 19., 4., 21., 7., 1., 1., 4., 2., 12., 9., 23., 65., 9., 22., 11., 5., 0., 2., 2., 7., 2., 10., 9., 7., 13., 8., 32., 7., 3., 0., 1., 7., 0., 1., 2., 7., 4., 6., 3., 0., 2., 2., 2., 1., 1., 1., 0., 1., 1., 0., 6., 3., 3., 1., 1., 7., 2., 2., 0., 1., 10., 1., 0., 2., 0., 3., 2., 1., 1., 4., 1., 3., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

18., 0., 1., 5., 12., 5., 4., 0., 10., 13., 1., 12., 16., 0., 14., 2., 2., 1., 8., 0., 2., 27., 18., 25., 25., 6., 1., 1., 3., 4., 8., 11., 16., 12., 2., 20., 3., 23., 12., 1., 0., 5., 0., 20., 9., 17., 35., 12., 21., 8., 7., 1., 3., 2., 9., 5., 8., 5., 10., 16., 11., 24., 13., 5., 1., 0., 5., 1., 6., 3., 11., 2., 5., 9., 1., 8., 3., 1., 0., 2., 5., 0., 2., 1., 3., 8., 3., 3., 1., 4., 1., 1., 3., 0., 3., 4., 3., 0., 3., 0., 1., 1., 1., 3., 2., 0., 2., 0., 0., 0., 0., 5., 0., 0., 4., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 0., 3., 7., 4., 7., 1., 6., 16., 0., 9., 29., 2., 10., 2., 1., 1., 16., 1., 1., 9., 16., 28., 24., 4., 1., 0., 1., 1., 7., 7., 22., 17., 1., 14., 7., 18., 10., 2., 1., 6., 2., 19., 8., 12., 53., 13., 28., 9., 5., 1., 4., 2., 4., 4., 4., 6., 13., 16., 4., 26., 12., 3., 3., 1., 10., 1., 5., 1., 6., 4., 5., 4., 5., 0., 1., 3., 3., 1., 1., 0., 2., 1., 1., 12., 5., 6., 0., 1., 3., 1., 1., 2., 2., 9., 0., 0., 3., 3., 3., 4., 1., 2., 0., 2., 0., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 4., 0., 3., 5., 6., 0., 5., 5., 1., 19., 26., 3., 13., 2., 0., 3., 20., 1., 0., 25., 11., 34., 30., 5., 1., 0., 1., 2., 7., 6., 21., 16., 3., 11., 4., 13., 10., 4., 1., 2., 2., 14., 10., 9., 50., 14., 25., 6., 1., 0., 5., 3., 4., 3., 9., 10., 12., 14., 5., 26., 9., 1., 0., 0., 6., 5., 4., 0., 3., 2., 7., 5., 1., 0., 4., 2., 0., 2., 4., 0., 1., 2., 1., 8., 4., 3., 3., 0., 5., 1., 4., 1., 2., 6., 6., 0., 3., 3., 3., 1., 1., 1., 7., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 2., 12., 2., 7., 2., 6., 3., 3., 14., 25., 2., 9., 3., 1., 1., 19., 0., 5., 28., 10., 36., 23., 3., 1., 0., 2., 2., 10., 7., 20., 20., 1., 21., 3., 15., 8., 3., 0., 6., 4., 7., 11., 22., 51., 9., 18., 13., 2., 2., 7., 2., 10., 5., 10., 10., 9., 17., 2., 24., 8., 1., 1., 2., 8., 1., 5., 1., 7., 2., 3., 3., 4., 6., 3., 2., 3., 5., 1., 0., 0., 1., 2., 9., 0., 4., 3., 2., 2., 3., 3., 1., 1., 7., 0., 0., 5., 3., 3., 4., 1., 2., 2., 1., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 3., 6., 6., 5., 9., 0., 3., 31., 0., 16., 22., 2., 22., 4., 1., 2., 16., 4., 4., 30., 12., 32., 27., 8., 3., 0., 3., 2., 9., 9., 25., 13., 2., 16., 4., 14., 10., 3., 0., 6., 5., 15., 7., 10., 42., 10., 24., 11., 6., 2., 3., 0., 8., 3., 13., 11., 12., 11., 5., 22., 7., 2., 2., 0., 9., 1., 3., 5., 6., 5., 3., 4., 3., 5., 3., 1., 0., 3., 1., 0., 1., 1., 2., 7., 1., 4., 0., 1., 1., 0., 4., 2., 2., 7., 3., 0., 5., 4., 1., 4., 1., 1., 2., 0., 2., 0., 0., 0., 0., 3., 0., 0., 6., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 3., 4., 11., 2., 4., 2., 7., 29., 0., 15., 22., 1., 11., 2., 2., 2., 18., 3., 7., 28., 6., 45., 32., 6., 1., 3., 5., 1., 6., 3., 26., 17., 2., 16., 4., 14., 10., 1., 2., 5., 2., 13., 10., 11., 40., 8., 13., 10., 6., 1., 8., 1., 6., 0., 8., 6., 8., 7., 3., 17., 9., 3., 3., 2., 10., 1., 2., 3., 5., 1., 8., 5., 4., 7., 2., 2., 2., 3., 2., 0., 2., 2., 3., 11., 1., 3., 2., 2., 2., 2., 2., 0., 3., 5., 2., 0., 2., 3., 2., 2., 2., 3., 2., 0., 3., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 5., 9., 5., 4., 0., 7., 28., 3., 14., 27., 1., 11., 2., 2., 6., 25., 4., 3., 13., 9., 43., 18., 4., 0., 1., 4., 0., 11., 5., 25., 16., 0., 13., 4., 11., 13., 0., 1., 8., 3., 11., 12., 18., 49., 14., 14., 7., 7., 0., 4., 0., 11., 4., 6., 10., 3., 18., 6., 23., 9., 0., 1., 1., 13., 0., 3., 1., 5., 4., 7., 3., 4., 4., 3., 3., 0., 2., 1., 0., 2., 1., 1., 4., 0., 8., 0., 2., 2., 0., 3., 1., 3., 7., 3., 0., 3., 2., 1., 3., 2., 1., 1., 0., 1., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 1., 3., 8., 2., 6., 0., 5., 18., 0., 11., 21., 0., 11., 1., 0., 2., 15., 4., 1., 31., 6., 16., 15., 11., 0., 0., 1., 4., 8., 6., 42., 18., 3., 10., 0., 12., 11., 1., 0., 4., 1., 10., 11., 19., 40., 8., 14., 9., 3., 1., 4., 5., 8., 3., 13., 5., 8., 19., 5., 17., 12., 3., 0., 1., 4., 0., 1., 5., 3., 1., 5., 3., 1., 6., 1., 1., 0., 0., 1., 0., 3., 3., 3., 8., 4., 4., 1., 6., 2., 2., 1., 2., 4., 6., 2., 0., 3., 4., 3., 3., 3., 2., 4., 0., 3., 0., 0., 0., 0., 3., 0., 0., 5., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 1., 3., 4., 3., 2., 3., 5., 29., 2., 11., 21., 0., 18., 2., 1., 2., 24., 1., 5., 14., 13., 29., 36., 1., 0., 3., 4., 2., 7., 4., 25., 13., 1., 16., 3., 6., 6., 1., 1., 2., 5., 23., 9., 23., 43., 15., 19., 8., 2., 0., 3., 1., 6., 4., 9., 7., 6., 22., 3., 28., 8., 4., 0., 1., 11., 2., 3., 1., 5., 0., 2., 6., 2., 3., 0., 0., 2., 2., 4., 0., 5., 1., 3., 12., 1., 2., 3., 1., 5., 2., 1., 0., 3., 7., 1., 0., 4., 2., 2., 1., 1., 1., 1., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 4., 2., 3., 14., 3., 5., 1., 3., 28., 1., 12., 25., 4., 18., 4., 1., 2., 3., 0., 4., 25., 15., 15., 33., 6., 0., 1., 3., 1., 11., 5., 27., 22., 4., 18., 5., 9., 8., 2., 3., 7., 3., 17., 13., 19., 48., 15., 10., 13., 7., 2., 3., 0., 2., 0., 9., 8., 5., 15., 6., 31., 8., 2., 0., 0., 9., 1., 5., 0., 3., 3., 4., 2., 1., 4., 3., 4., 0., 1., 2., 0., 0., 4., 3., 4., 1., 1., 2., 2., 3., 1., 4., 4., 0., 8., 2., 0., 0., 0., 2., 2., 2., 1., 1., 1., 3., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 0., 5., 12., 5., 9., 2., 7., 0., 0., 14., 22., 0., 14., 2., 0., 1., 15., 2., 6., 10., 9., 26., 32., 1., 3., 2., 3., 1., 12., 16., 34., 16., 1., 8., 7., 12., 10., 2., 1., 2., 3., 8., 9., 12., 43., 14., 24., 10., 6., 2., 4., 0., 6., 4., 11., 6., 10., 21., 7., 25., 6., 3., 2., 1., 6., 2., 0., 2., 6., 3., 2., 4., 0., 5., 5., 5., 2., 2., 4., 0., 0., 2., 2., 6., 0., 5., 1., 2., 2., 0., 2., 2., 1., 7., 4., 0., 0., 0., 1., 1., 2., 0., 1., 2., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 0., 6., 10., 2., 16., 0., 6., 24., 1., 22., 19., 1., 15., 2., 1., 4., 9., 1., 5., 23., 15., 35., 26., 5., 1., 0., 5., 1., 6., 11., 26., 14., 3., 29., 3., 11., 12., 2., 0., 7., 0., 14., 13., 21., 50., 10., 18., 5., 3., 0., 6., 0., 7., 2., 15., 3., 9., 15., 6., 31., 8., 7., 1., 1., 8., 2., 4., 4., 4., 2., 6., 6., 1., 4., 2., 6., 1., 3., 3., 0., 2., 5., 3., 11., 2., 2., 6., 1., 3., 0., 1., 0., 1., 5., 2., 0., 3., 0., 3., 5., 3., 0., 2., 1., 1., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 3., 4., 8., 5., 4., 0., 5., 16., 0., 12., 10., 1., 19., 3., 1., 3., 21., 0., 5., 27., 15., 19., 28., 3., 1., 1., 2., 5., 9., 11., 20., 15., 6., 18., 3., 21., 7., 1., 3., 4., 1., 15., 11., 19., 44., 11., 26., 8., 1., 1., 3., 1., 4., 7., 7., 5., 9., 12., 5., 26., 6., 2., 1., 1., 3., 0., 3., 4., 6., 2., 3., 1., 2., 4., 1., 0., 1., 3., 2., 0., 4., 5., 3., 6., 2., 2., 3., 0., 4., 0., 2., 0., 0., 7., 1., 0., 4., 1., 0., 1., 2., 6., 2., 1., 2., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 2., 3., 13., 5., 5., 1., 8., 32., 1., 14., 27., 1., 16., 3., 1., 1., 15., 1., 1., 33., 18., 46., 28., 4., 0., 0., 1., 0., 4., 8., 22., 24., 2., 15., 6., 14., 6., 0., 3., 6., 3., 11., 12., 12., 45., 11., 18., 7., 3., 1., 2., 3., 9., 2., 6., 7., 5., 13., 6., 22., 10., 1., 1., 1., 4., 0., 2., 0., 5., 0., 3., 4., 2., 5., 5., 0., 3., 1., 3., 0., 2., 1., 2., 8., 1., 5., 6., 2., 3., 2., 1., 2., 5., 8., 3., 0., 0., 1., 3., 4., 3., 0., 2., 1., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 2., 6., 7., 4., 8., 0., 8., 29., 1., 15., 16., 2., 17., 1., 3., 1., 15., 1., 6., 25., 9., 12., 19., 8., 0., 0., 4., 2., 5., 9., 18., 16., 3., 15., 6., 12., 8., 4., 0., 0., 2., 4., 10., 10., 54., 13., 14., 8., 5., 3., 9., 3., 5., 1., 10., 6., 11., 25., 8., 34., 10., 2., 1., 2., 7., 1., 0., 2., 6., 2., 2., 5., 2., 6., 3., 1., 2., 2., 2., 0., 4., 2., 1., 9., 4., 2., 3., 3., 6., 2., 2., 2., 2., 8., 2., 0., 4., 2., 0., 3., 0., 2., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 3., 8., 4., 2., 0., 4., 21., 0., 17., 14., 2., 17., 1., 0., 3., 18., 1., 3., 18., 17., 26., 35., 6., 2., 0., 2., 2., 5., 4., 28., 14., 3., 14., 3., 15., 7., 2., 0., 2., 1., 14., 13., 18., 33., 15., 19., 12., 5., 2., 7., 3., 7., 0., 7., 5., 7., 18., 7., 14., 7., 4., 2., 2., 4., 0., 2., 3., 6., 4., 4., 1., 2., 2., 1., 1., 1., 2., 1., 0., 3., 0., 3., 9., 1., 3., 2., 3., 4., 1., 2., 0., 1., 7., 1., 0., 2., 3., 1., 1., 3., 3., 3., 1., 3., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 3., 2., 1., 6., 4., 4., 1., 12., 21., 0., 13., 18., 1., 18., 1., 1., 5., 30., 4., 2., 24., 8., 18., 16., 9., 0., 0., 3., 1., 4., 7., 33., 15., 2., 9., 4., 15., 12., 0., 3., 4., 1., 18., 7., 19., 43., 17., 22., 6., 3., 0., 3., 1., 8., 4., 8., 9., 6., 11., 8., 15., 12., 1., 1., 2., 8., 0., 1., 3., 5., 3., 3., 6., 2., 2., 7., 3., 1., 1., 3., 0., 4., 2., 3., 2., 4., 6., 4., 1., 7., 3., 5., 1., 2., 8., 3., 0., 5., 1., 0., 4., 5., 3., 1., 1., 3., 0., 0., 0., 0., 5., 0., 0., 4., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 2., 3., 4., 8., 5., 7., 1., 8., 16., 0., 9., 23., 0., 16., 2., 1., 0., 12., 5., 3., 15., 17., 18., 26., 7., 0., 3., 5., 2., 5., 8., 16., 22., 3., 15., 7., 7., 12., 2., 0., 1., 3., 13., 17., 18., 47., 11., 21., 10., 6., 0., 6., 3., 7., 2., 14., 8., 7., 11., 7., 20., 4., 3., 0., 0., 7., 2., 1., 3., 2., 4., 5., 4., 4., 4., 1., 2., 1., 1., 4., 0., 2., 0., 0., 2., 2., 3., 2., 2., 5., 0., 2., 2., 1., 8., 0., 0., 3., 1., 0., 4., 2., 4., 2., 4., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 4., 4., 22., 0., 16., 4., 10., 48., 1., 6., 60., 1., 8., 2., 0., 1., 59., 13., 8., 65., 18., 83., 13., 4., 0., 1., 1., 2., 15., 11., 60., 13., 1., 26., 36., 11., 2., 0., 2., 6., 1., 20., 8., 22., 4., 12., 7., 4., 1., 0., 7., 3., 13., 4., 14., 4., 9., 5., 0., 35., 3., 8., 0., 0., 16., 5., 7., 0., 14., 4., 7., 4., 1., 0., 0., 3., 2., 16., 9., 6., 2., 1., 4., 0., 0., 0., 0., 0., 8., 1., 2., 3., 4., 4., 0., 0., 1., 0., 2., 0., 2., 4., 3., 0., 3., 0., 1., 0., 1., 0., 0., 0., 1., 0., 0., 2., 1., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 21., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 3., 5., 22., 0., 11., 1., 5., 49., 1., 5., 58., 1., 5., 1., 0., 3., 69., 8., 9., 68., 9., 85., 8., 3., 0., 0., 2., 3., 11., 11., 59., 10., 4., 36., 44., 13., 4., 0., 0., 6., 2., 27., 5., 27., 4., 13., 13., 5., 1., 0., 9., 5., 16., 3., 15., 0., 11., 7., 5., 42., 6., 6., 0., 0., 15., 1., 7., 3., 12., 4., 6., 1., 2., 0., 0., 7., 2., 15., 10., 1., 2., 1., 2., 0., 0., 0., 0., 0., 9., 2., 0., 4., 3., 2., 0., 0., 0., 0., 1., 0., 0., 5., 1., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 0., 3., 0., 3., 0., 0., 0., 0., 0., 7., 0., 0., 0., 0., 25., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 1., 3., 10., 0., 26., 2., 4., 45., 1., 9., 80., 0., 5., 5., 0., 3., 68., 19., 9., 57., 18., 57., 9., 5., 0., 0., 0., 6., 13., 7., 53., 8., 3., 31., 43., 13., 4., 0., 1., 5., 6., 29., 7., 25., 6., 15., 4., 2., 3., 0., 16., 6., 22., 2., 15., 4., 5., 2., 3., 38., 8., 11., 2., 0., 18., 3., 8., 1., 9., 4., 5., 1., 0., 0., 0., 3., 3., 8., 7., 6., 4., 0., 2., 0., 0., 0., 0., 0., 10., 1., 4., 2., 2., 2., 1., 0., 1., 0., 0., 0., 1., 4., 3., 0., 1., 0., 1., 0., 0., 0., 0., 0., 1., 0., 2., 2., 2., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 29., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 2., 7., 6., 14., 0., 11., 0., 5., 39., 0., 7., 66., 1., 6., 1., 0., 4., 71., 5., 9., 80., 8., 81., 19., 2., 0., 2., 1., 0., 19., 7., 35., 22., 3., 41., 36., 15., 5., 0., 1., 9., 7., 23., 5., 23., 4., 14., 5., 2., 1., 0., 9., 5., 10., 7., 16., 4., 10., 2., 1., 40., 9., 7., 0., 0., 10., 2., 8., 1., 13., 1., 3., 0., 0., 3., 0., 6., 4., 18., 9., 2., 1., 1., 5., 0., 0., 0., 0., 0., 5., 0., 3., 0., 3., 3., 1., 0., 0., 0., 0., 0., 1., 6., 1., 0., 1., 0., 1., 0., 3., 0., 0., 0., 1., 0., 2., 3., 2., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 15., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 5., 12., 0., 12., 1., 4., 53., 1., 4., 42., 3., 7., 1., 0., 2., 57., 10., 7., 79., 12., 66., 12., 5., 0., 0., 3., 4., 11., 7., 48., 11., 5., 52., 25., 20., 3., 0., 1., 4., 3., 10., 10., 32., 5., 15., 6., 2., 1., 0., 9., 4., 20., 3., 16., 2., 4., 1., 0., 55., 10., 11., 1., 0., 6., 1., 12., 2., 16., 1., 5., 3., 1., 2., 0., 8., 0., 25., 7., 1., 5., 1., 4., 0., 0., 0., 0., 0., 7., 4., 5., 2., 4., 0., 1., 0., 1., 0., 0., 0., 3., 3., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 1., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 20., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 2., 4., 18., 0., 14., 1., 11., 55., 1., 13., 42., 1., 4., 1., 0., 2., 64., 8., 5., 81., 11., 76., 12., 3., 0., 0., 1., 1., 11., 10., 52., 9., 0., 39., 31., 15., 3., 0., 0., 8., 2., 11., 4., 20., 11., 12., 4., 2., 2., 0., 11., 6., 18., 6., 10., 4., 8., 1., 4., 34., 11., 8., 1., 0., 10., 1., 5., 2., 10., 4., 2., 0., 0., 1., 0., 5., 2., 15., 8., 5., 7., 0., 4., 0., 0., 0., 0., 0., 5., 1., 1., 1., 3., 2., 0., 0., 1., 0., 1., 0., 0., 1., 3., 0., 1., 0., 2., 0., 0., 0., 0., 0., 2., 0., 3., 0., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 27., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 2., 2., 10., 0., 22., 0., 8., 56., 2., 6., 55., 0., 7., 3., 0., 3., 72., 7., 4., 79., 5., 72., 10., 5., 0., 0., 4., 1., 10., 10., 58., 9., 4., 46., 29., 13., 4., 0., 0., 4., 5., 19., 6., 25., 3., 14., 11., 5., 0., 0., 9., 3., 18., 7., 13., 2., 16., 1., 7., 39., 12., 4., 3., 0., 10., 3., 7., 1., 12., 2., 2., 2., 2., 0., 0., 0., 3., 13., 10., 3., 1., 3., 2., 0., 0., 0., 0., 0., 6., 1., 4., 2., 4., 1., 0., 0., 2., 0., 1., 0., 1., 3., 2., 0., 1., 0., 2., 0., 1., 0., 0., 0., 2., 0., 1., 2., 3., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 17., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 1., 2., 7., 0., 18., 2., 13., 38., 1., 8., 50., 2., 5., 4., 0., 6., 69., 5., 6., 73., 19., 83., 17., 4., 0., 1., 2., 3., 19., 11., 47., 12., 3., 34., 26., 14., 3., 0., 0., 10., 5., 25., 5., 26., 4., 10., 2., 2., 4., 0., 7., 1., 23., 7., 15., 2., 5., 2., 4., 35., 8., 9., 1., 0., 15., 4., 9., 1., 14., 1., 5., 0., 1., 3., 0., 7., 3., 14., 6., 5., 1., 2., 4., 0., 0., 0., 0., 0., 11., 1., 2., 2., 2., 0., 2., 0., 0., 0., 1., 0., 2., 5., 1., 0., 3., 0., 1., 0., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 26., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 2., 4., 13., 0., 21., 1., 7., 56., 0., 7., 56., 1., 5., 4., 0., 2., 66., 15., 3., 91., 15., 79., 20., 2., 0., 1., 4., 1., 13., 5., 58., 16., 4., 56., 40., 11., 6., 0., 3., 7., 5., 15., 2., 30., 5., 9., 3., 2., 1., 0., 10., 5., 11., 4., 15., 0., 15., 2., 5., 37., 16., 5., 1., 0., 14., 5., 3., 0., 13., 3., 1., 3., 1., 0., 0., 7., 1., 16., 9., 4., 4., 0., 0., 0., 0., 0., 0., 0., 9., 0., 3., 0., 1., 2., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 24., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 4., 2., 5., 19., 5., 39., 0., 21., 158., 3., 19., 180., 3., 13., 9., 2., 7., 90., 4., 13., 262., 42., 307., 38., 25., 1., 0., 6., 8., 42., 30., 221., 37., 9., 151., 12., 48., 5., 0., 6., 22., 15., 74., 18., 70., 18., 33., 52., 9., 2., 2., 23., 14., 34., 12., 58., 12., 26., 4., 9., 9., 0., 0., 1., 0., 36., 6., 16., 4., 25., 7., 6., 4., 2., 6., 2., 2., 5., 3., 7., 4., 6., 1., 6., 0., 0., 2., 125., 14., 1946., 106., 111., 210., 92., 120., 78., 9., 12., 18., 8., 1., 0., 8., 4., 1., 10., 4., 38., 14., 39., 18., 38., 9., 13., 2., 6., 14., 5., 4., 3., 4., 7., 2., 0., 5., 6., 16., 1., 0., 6., 6., 2., 0., 2., 4., 4., 27., 3., 12., 1., 18., 4., 22., 4., 4., 2., 2., 25., 6., 40., 7., 8., 11., 0., 26., 6., 9., 6.,

13., 3., 4., 6., 25., 5., 35., 2., 14., 172., 2., 31., 231., 7., 18., 6., 0., 7., 74., 0., 17., 254., 36., 310., 38., 18., 2., 2., 9., 5., 51., 33., 238., 35., 6., 161., 6., 43., 2., 0., 2., 9., 8., 83., 17., 102., 12., 35., 29., 13., 2., 1., 32., 5., 49., 11., 48., 11., 32., 6., 11., 5., 3., 0., 1., 0., 28., 4., 12., 1., 28., 4., 10., 1., 2., 2., 1., 0., 4., 5., 5., 8., 5., 3., 6., 2., 1., 5., 133., 9., 1854., 92., 101., 211., 78., 126., 71., 17., 17., 17., 20., 1., 1., 1., 10., 2., 6., 9., 38., 14., 41., 21., 38., 2., 7., 4., 4., 11., 5., 4., 5., 5., 9., 5., 0., 1., 4., 15., 1., 0., 9., 4., 4., 0., 6., 4., 3., 27., 3., 16., 1., 21., 0., 24., 3., 3., 7., 8., 24., 3., 30., 7., 5., 11., 6., 36., 6., 17., 3.,

10., 1., 0., 1., 10., 4., 10., 2., 0., 25., 0., 16., 18., 1., 14., 2., 0., 2., 11., 2., 2., 23., 12., 30., 28., 9., 1., 0., 2., 1., 5., 6., 23., 15., 3., 19., 5., 14., 10., 0., 0., 3., 1., 13., 8., 14., 54., 15., 18., 10., 0., 1., 4., 2., 11., 3., 11., 4., 7., 16., 6., 21., 5., 3., 2., 1., 8., 1., 1., 1., 6., 5., 3., 5., 3., 2., 2., 1., 1., 4., 2., 0., 1., 1., 4., 7., 1., 3., 0., 2., 3., 1., 2., 1., 1., 2., 2., 0., 2., 3., 1., 4., 4., 0., 2., 1., 2., 0., 0., 0., 0., 0., 0., 0., 6., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 5., 5., 8., 3., 5., 1., 5., 27., 2., 14., 16., 1., 24., 2., 1., 3., 20., 3., 6., 22., 9., 31., 16., 4., 1., 0., 7., 2., 9., 10., 43., 16., 5., 17., 5., 14., 11., 1., 1., 2., 0., 17., 11., 12., 37., 13., 19., 9., 2., 1., 1., 4., 8., 5., 10., 7., 7., 11., 5., 14., 10., 4., 2., 0., 8., 1., 2., 4., 6., 5., 3., 2., 1., 5., 1., 2., 3., 1., 5., 0., 4., 3., 0., 2., 1., 2., 3., 1., 4., 1., 1., 1., 0., 6., 3., 0., 2., 0., 4., 0., 1., 4., 2., 0., 0., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 0., 3., 3., 1., 8., 0., 9., 20., 2., 15., 21., 1., 19., 3., 0., 0., 16., 1., 10., 31., 15., 21., 27., 8., 0., 0., 3., 2., 11., 6., 22., 19., 3., 17., 2., 13., 7., 1., 2., 1., 2., 16., 8., 21., 50., 13., 16., 11., 5., 1., 5., 3., 2., 4., 9., 7., 6., 12., 7., 19., 16., 4., 2., 1., 6., 3., 5., 6., 5., 2., 2., 3., 2., 9., 5., 3., 0., 4., 6., 0., 2., 1., 2., 4., 2., 8., 2., 2., 3., 0., 5., 2., 2., 2., 2., 0., 1., 2., 1., 2., 4., 1., 2., 2., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 2., 8., 7., 4., 7., 1., 5., 29., 1., 18., 35., 1., 13., 2., 2., 3., 18., 4., 4., 24., 12., 37., 22., 7., 4., 2., 3., 3., 9., 8., 35., 15., 2., 12., 6., 20., 6., 1., 2., 3., 2., 12., 17., 16., 50., 18., 21., 9., 3., 1., 7., 1., 14., 3., 10., 2., 13., 13., 8., 28., 9., 7., 0., 1., 7., 3., 5., 3., 2., 2., 2., 3., 1., 7., 4., 4., 0., 2., 1., 0., 0., 1., 3., 4., 2., 1., 2., 0., 10., 2., 0., 0., 2., 9., 2., 0., 1., 3., 1., 2., 2., 0., 2., 0., 5., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 4., 2., 5., 1., 7., 0., 8., 28., 3., 7., 22., 1., 15., 2., 0., 3., 21., 1., 4., 23., 16., 28., 28., 3., 2., 1., 3., 4., 7., 7., 33., 20., 4., 19., 5., 12., 9., 1., 0., 1., 0., 12., 11., 21., 56., 11., 25., 9., 0., 1., 4., 1., 11., 4., 13., 5., 9., 14., 7., 20., 7., 1., 1., 0., 4., 1., 3., 0., 1., 2., 1., 5., 2., 4., 1., 4., 1., 1., 3., 0., 3., 1., 2., 7., 2., 0., 2., 5., 1., 1., 5., 2., 2., 12., 2., 0., 2., 3., 1., 3., 2., 3., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 2., 11., 3., 6., 0., 5., 27., 0., 13., 17., 0., 17., 0., 2., 3., 20., 2., 11., 15., 9., 28., 22., 6., 3., 0., 0., 5., 9., 10., 19., 18., 2., 10., 4., 13., 10., 3., 1., 5., 2., 15., 10., 17., 36., 8., 14., 8., 5., 0., 5., 6., 8., 4., 10., 2., 6., 18., 2., 18., 10., 0., 2., 0., 10., 1., 1., 5., 4., 6., 7., 2., 1., 3., 2., 2., 3., 5., 2., 0., 1., 2., 3., 6., 2., 2., 3., 2., 3., 2., 1., 0., 3., 4., 6., 0., 1., 2., 1., 4., 0., 1., 3., 0., 4., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 7., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 3., 2., 6., 4., 8., 1., 12., 18., 1., 14., 18., 0., 26., 4., 2., 0., 17., 0., 4., 30., 9., 21., 24., 3., 1., 1., 5., 1., 13., 8., 24., 16., 2., 20., 4., 8., 8., 2., 2., 3., 4., 15., 11., 23., 46., 5., 16., 7., 4., 1., 5., 3., 3., 1., 9., 3., 7., 14., 4., 22., 8., 3., 0., 2., 7., 0., 4., 3., 8., 3., 6., 6., 3., 8., 2., 3., 1., 2., 2., 0., 3., 1., 4., 4., 1., 4., 0., 3., 4., 1., 3., 0., 2., 9., 4., 0., 4., 3., 3., 2., 1., 1., 3., 2., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 5., 2., 2., 9., 2., 5., 0., 5., 18., 0., 10., 30., 1., 13., 9., 2., 1., 18., 2., 2., 2., 20., 16., 22., 4., 1., 2., 2., 2., 7., 12., 23., 13., 1., 10., 5., 16., 13., 3., 1., 4., 5., 12., 9., 16., 51., 10., 20., 9., 6., 1., 7., 2., 2., 4., 12., 5., 5., 20., 8., 15., 12., 3., 1., 2., 7., 0., 4., 3., 7., 3., 4., 6., 2., 4., 1., 3., 0., 2., 2., 0., 1., 2., 0., 6., 0., 6., 1., 2., 2., 3., 4., 2., 0., 9., 3., 0., 3., 2., 2., 2., 3., 0., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 2., 7., 11., 1., 11., 3., 6., 8., 0., 7., 21., 0., 13., 2., 1., 1., 22., 3., 2., 34., 5., 15., 20., 6., 0., 1., 0., 5., 3., 8., 27., 12., 5., 14., 4., 10., 11., 1., 2., 5., 5., 17., 11., 15., 53., 17., 19., 5., 2., 1., 2., 2., 8., 2., 13., 5., 9., 16., 3., 17., 7., 4., 0., 0., 4., 1., 1., 1., 2., 3., 2., 2., 3., 4., 4., 3., 1., 2., 2., 0., 1., 1., 1., 6., 1., 1., 3., 2., 1., 1., 1., 2., 4., 5., 0., 0., 1., 1., 4., 2., 2., 2., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

18., 0., 3., 6., 14., 5., 3., 0., 7., 22., 0., 12., 18., 1., 15., 1., 0., 1., 20., 2., 3., 30., 8., 35., 21., 7., 1., 1., 2., 1., 9., 6., 16., 13., 4., 10., 3., 16., 8., 0., 0., 1., 3., 17., 16., 19., 59., 6., 18., 11., 3., 0., 2., 3., 7., 4., 5., 5., 4., 15., 4., 29., 8., 2., 1., 0., 16., 1., 6., 2., 8., 3., 2., 4., 5., 1., 3., 1., 1., 2., 4., 0., 0., 1., 0., 3., 4., 4., 1., 1., 6., 2., 3., 1., 4., 2., 3., 0., 0., 3., 4., 0., 2., 2., 2., 1., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 3., 10., 5., 4., 1., 7., 31., 3., 22., 24., 2., 18., 3., 2., 2., 16., 3., 2., 21., 7., 17., 27., 9., 2., 1., 1., 5., 6., 5., 23., 15., 1., 11., 5., 11., 9., 1., 3., 3., 2., 11., 16., 17., 41., 9., 21., 4., 4., 2., 1., 1., 7., 2., 9., 7., 8., 20., 7., 24., 7., 1., 0., 1., 7., 1., 6., 3., 3., 2., 5., 4., 3., 3., 4., 2., 0., 4., 2., 0., 1., 0., 2., 5., 4., 4., 1., 4., 8., 5., 3., 0., 1., 14., 0., 0., 2., 3., 3., 1., 2., 2., 3., 1., 3., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 2., 0., 6., 14., 7., 8., 0., 6., 24., 0., 14., 16., 2., 12., 5., 0., 3., 16., 0., 2., 9., 0., 25., 23., 10., 1., 0., 2., 2., 11., 6., 29., 17., 3., 16., 7., 11., 9., 1., 0., 3., 4., 18., 10., 14., 43., 11., 22., 6., 2., 4., 6., 1., 7., 4., 13., 5., 7., 20., 2., 26., 8., 1., 1., 2., 9., 0., 3., 7., 8., 3., 5., 2., 2., 4., 5., 1., 1., 5., 2., 0., 2., 2., 2., 4., 2., 9., 1., 2., 6., 2., 2., 0., 6., 10., 1., 0., 5., 2., 3., 1., 2., 3., 1., 0., 4., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 4., 2., 10., 3., 4., 0., 4., 25., 2., 11., 13., 2., 11., 1., 0., 2., 31., 1., 4., 25., 15., 24., 38., 2., 1., 4., 5., 1., 8., 9., 32., 18., 5., 17., 4., 13., 5., 1., 0., 4., 0., 10., 12., 10., 45., 18., 27., 3., 7., 0., 9., 1., 9., 4., 9., 4., 9., 19., 3., 24., 9., 3., 0., 0., 6., 0., 1., 4., 5., 4., 3., 4., 4., 4., 4., 2., 1., 6., 4., 0., 1., 3., 4., 7., 1., 6., 3., 2., 4., 0., 4., 1., 5., 8., 0., 0., 4., 1., 2., 1., 1., 5., 2., 0., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 0., 5., 6., 3., 6., 0., 1., 21., 3., 9., 30., 2., 19., 0., 0., 5., 25., 2., 1., 30., 7., 28., 33., 8., 0., 1., 6., 3., 8., 5., 13., 16., 2., 20., 1., 15., 11., 3., 0., 10., 3., 12., 14., 17., 49., 14., 18., 9., 7., 0., 6., 5., 8., 5., 12., 5., 7., 13., 3., 20., 12., 1., 1., 3., 6., 0., 2., 2., 5., 4., 3., 6., 4., 6., 4., 1., 0., 1., 3., 0., 1., 4., 4., 7., 6., 2., 3., 1., 4., 1., 3., 1., 2., 5., 2., 0., 2., 2., 1., 2., 5., 4., 1., 0., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 0., 2., 4., 1., 6., 1., 4., 7., 1., 9., 19., 0., 23., 2., 3., 0., 14., 2., 4., 25., 8., 27., 39., 7., 1., 1., 3., 1., 7., 2., 31., 20., 1., 10., 4., 13., 13., 2., 1., 5., 1., 3., 13., 19., 48., 11., 30., 10., 7., 0., 4., 6., 6., 5., 11., 8., 9., 12., 13., 20., 10., 2., 1., 0., 12., 1., 3., 3., 4., 2., 3., 5., 2., 4., 3., 1., 2., 2., 3., 0., 0., 1., 2., 7., 0., 9., 0., 4., 5., 2., 1., 1., 1., 4., 3., 0., 1., 0., 6., 0., 1., 2., 1., 3., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 1., 5., 8., 6., 6., 1., 6., 23., 0., 14., 23., 0., 13., 1., 1., 1., 27., 3., 5., 22., 12., 31., 24., 6., 0., 3., 2., 5., 6., 11., 26., 22., 1., 16., 3., 18., 8., 1., 0., 6., 2., 3., 11., 15., 59., 14., 17., 13., 3., 1., 8., 3., 6., 2., 6., 4., 10., 9., 4., 23., 4., 4., 0., 2., 11., 2., 4., 2., 10., 5., 6., 1., 3., 4., 2., 3., 0., 2., 4., 0., 2., 1., 1., 7., 4., 4., 3., 1., 6., 1., 2., 1., 1., 9., 2., 0., 2., 0., 3., 1., 1., 0., 1., 4., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 3., 7., 9., 3., 8., 1., 6., 20., 0., 12., 20., 0., 8., 3., 2., 2., 5., 2., 4., 34., 5., 22., 32., 4., 1., 1., 4., 1., 9., 8., 27., 16., 1., 15., 2., 16., 2., 2., 0., 4., 1., 10., 13., 21., 43., 14., 20., 10., 5., 0., 5., 2., 8., 6., 6., 5., 8., 8., 7., 26., 12., 4., 2., 0., 4., 2., 3., 4., 5., 7., 6., 1., 2., 2., 3., 3., 0., 2., 3., 0., 0., 4., 3., 8., 2., 6., 1., 1., 6., 1., 2., 1., 1., 10., 2., 0., 2., 2., 0., 2., 2., 4., 4., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

19., 1., 2., 5., 6., 4., 9., 0., 1., 26., 1., 10., 13., 1., 12., 7., 2., 3., 19., 1., 3., 40., 13., 21., 29., 4., 3., 1., 2., 1., 4., 4., 20., 13., 5., 19., 3., 13., 7., 2., 1., 5., 2., 19., 11., 7., 40., 13., 22., 8., 2., 0., 3., 2., 7., 7., 9., 6., 7., 21., 8., 20., 13., 2., 2., 3., 8., 1., 3., 0., 4., 1., 3., 4., 2., 3., 4., 1., 2., 2., 2., 0., 3., 2., 3., 5., 2., 3., 0., 0., 8., 1., 3., 2., 2., 8., 3., 0., 2., 2., 5., 1., 1., 3., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 1., 2., 10., 3., 4., 2., 9., 18., 0., 16., 18., 2., 14., 5., 0., 1., 32., 2., 0., 13., 10., 32., 20., 11., 0., 1., 3., 2., 4., 12., 31., 11., 4., 21., 2., 11., 9., 2., 1., 6., 5., 8., 11., 8., 40., 8., 14., 11., 4., 1., 3., 4., 7., 4., 6., 5., 4., 17., 6., 21., 8., 5., 1., 0., 7., 1., 2., 2., 2., 3., 5., 3., 1., 9., 5., 0., 0., 1., 7., 0., 3., 3., 1., 6., 1., 3., 2., 1., 6., 2., 2., 0., 0., 11., 2., 0., 1., 5., 0., 4., 1., 1., 2., 0., 3., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 2., 2., 2., 2., 4., 2., 6., 26., 0., 11., 27., 0., 7., 1., 1., 2., 23., 2., 6., 25., 8., 40., 32., 8., 1., 0., 5., 3., 11., 7., 24., 10., 5., 21., 8., 14., 10., 5., 1., 2., 3., 12., 6., 20., 41., 15., 28., 11., 3., 1., 9., 1., 10., 3., 14., 8., 3., 24., 10., 21., 7., 2., 2., 0., 7., 0., 2., 0., 2., 4., 3., 2., 3., 5., 3., 2., 0., 2., 4., 0., 1., 2., 0., 6., 2., 4., 3., 4., 3., 2., 3., 0., 4., 8., 1., 0., 1., 1., 1., 2., 3., 1., 3., 3., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 1., 2., 13., 0., 15., 1., 5., 42., 0., 4., 61., 0., 8., 0., 0., 1., 78., 10., 14., 71., 12., 92., 8., 4., 0., 1., 0., 2., 21., 6., 53., 13., 2., 43., 32., 16., 8., 0., 0., 6., 4., 21., 5., 17., 9., 9., 6., 1., 0., 0., 8., 2., 18., 3., 15., 5., 12., 4., 2., 42., 7., 8., 3., 0., 14., 1., 11., 1., 14., 4., 6., 0., 0., 2., 0., 9., 3., 16., 10., 1., 4., 3., 1., 0., 0., 0., 0., 0., 10., 1., 3., 4., 4., 0., 0., 0., 1., 0., 0., 0., 0., 3., 2., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 2., 2., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 22., 0., 5., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 2., 3., 4., 12., 0., 8., 1., 8., 51., 0., 8., 48., 1., 1., 6., 0., 3., 68., 11., 7., 59., 14., 53., 17., 3., 0., 0., 2., 1., 15., 11., 49., 17., 1., 37., 38., 17., 10., 0., 0., 9., 1., 29., 4., 26., 9., 10., 3., 2., 4., 0., 11., 6., 14., 3., 19., 1., 11., 2., 3., 33., 10., 5., 2., 0., 10., 3., 8., 3., 11., 3., 3., 0., 1., 1., 0., 6., 2., 18., 10., 4., 3., 0., 1., 0., 0., 0., 0., 0., 9., 1., 1., 1., 3., 1., 2., 0., 1., 0., 0., 0., 1., 3., 2., 0., 2., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 2., 5., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 21., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 0., 2., 13., 0., 11., 3., 7., 48., 1., 12., 58., 3., 1., 2., 0., 4., 78., 8., 3., 76., 11., 82., 11., 4., 0., 0., 3., 3., 15., 14., 46., 9., 0., 41., 32., 8., 6., 0., 1., 6., 1., 20., 4., 31., 3., 9., 6., 3., 2., 0., 9., 9., 14., 8., 19., 4., 9., 7., 3., 38., 8., 4., 2., 0., 13., 1., 7., 3., 12., 3., 3., 0., 1., 3., 0., 0., 5., 15., 11., 5., 4., 1., 1., 0., 0., 0., 0., 0., 9., 2., 2., 3., 0., 0., 1., 0., 2., 0., 1., 0., 0., 6., 0., 0., 1., 0., 1., 0., 3., 0., 0., 0., 3., 0., 0., 2., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 17., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 2., 4., 4., 0., 18., 1., 9., 47., 0., 5., 39., 1., 5., 1., 0., 1., 75., 7., 12., 76., 10., 104., 11., 5., 0., 0., 4., 1., 18., 9., 48., 15., 3., 47., 44., 17., 9., 0., 2., 5., 7., 23., 9., 28., 9., 15., 10., 2., 1., 0., 13., 5., 14., 6., 15., 1., 7., 4., 4., 38., 8., 5., 3., 0., 12., 3., 11., 3., 12., 0., 4., 1., 0., 1., 0., 3., 0., 23., 10., 2., 2., 0., 7., 0., 0., 0., 0., 0., 6., 1., 3., 4., 1., 1., 0., 0., 2., 0., 2., 0., 2., 4., 5., 0., 1., 0., 3., 0., 3., 0., 0., 0., 2., 0., 2., 2., 1., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 24., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 1., 3., 8., 0., 21., 3., 6., 54., 0., 7., 56., 2., 4., 3., 0., 2., 47., 12., 6., 84., 15., 69., 18., 6., 0., 0., 0., 2., 4., 7., 43., 13., 0., 43., 36., 15., 4., 0., 1., 4., 3., 25., 6., 26., 10., 8., 3., 3., 2., 0., 19., 7., 12., 6., 11., 3., 2., 2., 1., 39., 9., 4., 3., 0., 10., 1., 10., 6., 8., 3., 6., 0., 5., 2., 0., 6., 4., 7., 4., 1., 5., 0., 4., 0., 0., 0., 0., 0., 7., 2., 0., 2., 2., 0., 2., 0., 1., 0., 1., 0., 4., 2., 3., 0., 0., 0., 2., 0., 1., 0., 0., 0., 3., 0., 0., 1., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 23., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 1., 4., 12., 0., 15., 2., 7., 68., 0., 13., 55., 1., 3., 2., 0., 5., 79., 11., 4., 73., 15., 72., 8., 3., 0., 0., 3., 1., 8., 12., 43., 15., 1., 37., 36., 13., 11., 0., 0., 4., 2., 25., 4., 35., 7., 10., 6., 4., 1., 0., 10., 6., 17., 3., 17., 4., 5., 1., 5., 32., 9., 10., 3., 0., 10., 2., 11., 2., 6., 0., 7., 0., 0., 1., 0., 3., 1., 11., 6., 2., 1., 0., 3., 0., 0., 0., 0., 0., 12., 0., 3., 1., 2., 1., 0., 0., 3., 0., 0., 0., 2., 4., 2., 0., 4., 0., 2., 0., 0., 0., 0., 0., 1., 0., 3., 1., 1., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 22., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 1., 3., 15., 0., 12., 2., 7., 41., 1., 7., 68., 2., 3., 3., 0., 1., 82., 7., 11., 84., 18., 85., 12., 3., 0., 0., 2., 2., 15., 16., 56., 15., 1., 35., 24., 13., 7., 0., 0., 10., 4., 29., 4., 21., 10., 12., 5., 4., 2., 0., 8., 3., 15., 4., 12., 3., 4., 3., 1., 39., 8., 7., 2., 0., 18., 4., 9., 2., 7., 3., 4., 1., 3., 0., 0., 5., 2., 15., 11., 4., 5., 2., 4., 0., 0., 0., 0., 0., 9., 2., 3., 1., 4., 0., 1., 0., 2., 0., 0., 0., 0., 2., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 4., 0., 4., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 26., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 4., 6., 15., 0., 11., 5., 4., 56., 4., 2., 45., 1., 4., 1., 0., 1., 74., 9., 12., 80., 11., 78., 11., 7., 0., 2., 5., 2., 12., 11., 66., 13., 2., 41., 29., 11., 6., 0., 1., 5., 6., 29., 8., 22., 8., 5., 7., 5., 1., 0., 15., 5., 22., 1., 13., 4., 8., 5., 9., 32., 11., 3., 2., 0., 12., 4., 9., 1., 5., 3., 2., 1., 0., 1., 0., 5., 3., 8., 14., 5., 4., 0., 8., 0., 0., 0., 0., 0., 7., 1., 3., 3., 1., 1., 0., 0., 0., 0., 1., 0., 1., 3., 1., 0., 2., 0., 2., 0., 1., 0., 0., 0., 2., 0., 0., 3., 1., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 20., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 2., 4., 13., 0., 18., 1., 7., 63., 0., 14., 57., 2., 5., 3., 0., 3., 83., 7., 7., 75., 13., 62., 15., 4., 0., 2., 2., 3., 10., 6., 57., 5., 5., 40., 28., 13., 5., 0., 1., 6., 3., 18., 7., 24., 11., 16., 5., 2., 3., 0., 11., 3., 16., 2., 14., 3., 6., 1., 1., 34., 5., 12., 1., 0., 15., 2., 6., 5., 11., 4., 5., 1., 0., 0., 0., 3., 0., 14., 11., 1., 2., 3., 4., 0., 0., 0., 0., 0., 9., 4., 4., 1., 2., 1., 2., 0., 0., 0., 2., 0., 1., 4., 3., 0., 2., 0., 1., 0., 1., 0., 0., 0., 0., 0., 5., 0., 3., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 15., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 4., 8., 0., 14., 1., 5., 30., 1., 13., 56., 1., 7., 2., 0., 0., 57., 13., 7., 78., 16., 76., 11., 5., 0., 0., 3., 1., 13., 4., 51., 10., 1., 41., 29., 12., 5., 0., 0., 4., 2., 22., 5., 21., 5., 9., 10., 5., 3., 0., 10., 3., 23., 3., 11., 3., 6., 5., 3., 40., 6., 4., 0., 0., 8., 2., 7., 2., 13., 4., 3., 0., 1., 1., 0., 5., 0., 12., 14., 2., 0., 0., 1., 0., 0., 0., 0., 0., 17., 2., 3., 2., 6., 2., 0., 0., 0., 0., 1., 0., 1., 3., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 2., 0., 3., 1., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 28., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 3., 4., 6., 20., 3., 35., 1., 11., 127., 1., 35., 198., 7., 18., 8., 2., 11., 63., 2., 16., 260., 54., 349., 35., 16., 1., 2., 2., 2., 41., 42., 273., 36., 9., 168., 17., 48., 2., 0., 1., 21., 8., 59., 25., 79., 16., 29., 59., 12., 4., 1., 28., 4., 34., 13., 48., 11., 27., 5., 11., 7., 0., 0., 0., 0., 22., 3., 14., 2., 33., 6., 16., 8., 3., 1., 1., 1., 5., 2., 7., 3., 13., 4., 4., 3., 0., 1., 148., 6., 1882., 86., 113., 222., 105., 113., 60., 19., 14., 10., 14., 0., 0., 5., 3., 7., 5., 8., 36., 20., 52., 18., 40., 11., 13., 2., 5., 5., 6., 3., 5., 4., 5., 1., 0., 4., 5., 18., 1., 0., 4., 4., 4., 0., 4., 3., 1., 36., 3., 15., 5., 19., 4., 34., 2., 0., 6., 4., 24., 3., 36., 6., 4., 8., 6., 27., 5., 12., 1.,

10., 2., 1., 3., 10., 2., 6., 1., 4., 33., 4., 7., 11., 2., 16., 3., 2., 4., 11., 2., 7., 37., 13., 21., 21., 9., 2., 2., 3., 1., 9., 10., 24., 16., 1., 14., 3., 19., 11., 0., 1., 4., 4., 10., 7., 21., 47., 15., 23., 8., 1., 3., 4., 1., 3., 2., 7., 7., 5., 20., 6., 21., 8., 3., 1., 1., 9., 1., 1., 3., 5., 2., 5., 2., 1., 4., 5., 1., 0., 0., 1., 0., 5., 2., 1., 6., 3., 5., 1., 3., 6., 0., 2., 1., 1., 6., 2., 0., 4., 1., 2., 1., 1., 0., 2., 1., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 1., 4., 13., 9., 2., 2., 3., 22., 2., 18., 16., 3., 8., 7., 0., 8., 17., 2., 7., 11., 11., 26., 21., 7., 1., 3., 3., 1., 10., 9., 20., 12., 3., 18., 1., 20., 9., 2., 2., 3., 2., 9., 9., 19., 49., 7., 15., 11., 5., 0., 5., 0., 8., 4., 3., 11., 9., 18., 8., 24., 13., 3., 0., 0., 4., 1., 3., 1., 7., 2., 3., 3., 2., 3., 5., 1., 1., 0., 0., 0., 2., 3., 1., 5., 1., 2., 2., 1., 4., 1., 4., 2., 1., 10., 4., 0., 2., 4., 3., 1., 2., 2., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 5., 2., 8., 2., 9., 1., 7., 24., 1., 12., 24., 2., 18., 1., 1., 3., 23., 0., 4., 20., 12., 25., 39., 6., 1., 1., 2., 2., 8., 11., 25., 13., 1., 16., 5., 17., 11., 1., 1., 4., 1., 11., 10., 11., 45., 12., 22., 7., 3., 0., 7., 1., 9., 5., 8., 3., 9., 14., 6., 27., 10., 2., 1., 1., 8., 2., 1., 1., 6., 2., 3., 1., 4., 1., 2., 1., 0., 1., 1., 0., 3., 0., 2., 4., 3., 3., 2., 5., 5., 0., 1., 0., 5., 12., 3., 0., 2., 0., 2., 3., 1., 3., 2., 1., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 1., 5., 8., 1., 7., 0., 9., 34., 0., 8., 27., 1., 12., 3., 1., 2., 18., 1., 3., 28., 6., 18., 25., 4., 4., 0., 7., 1., 3., 10., 17., 14., 3., 13., 3., 22., 7., 1., 0., 4., 2., 14., 8., 16., 46., 14., 13., 9., 3., 2., 3., 2., 5., 3., 6., 5., 6., 13., 7., 26., 8., 3., 1., 0., 2., 2., 3., 4., 6., 2., 3., 5., 1., 4., 3., 4., 2., 2., 2., 0., 2., 2., 2., 7., 2., 2., 1., 0., 4., 1., 1., 1., 2., 9., 2., 0., 1., 2., 1., 2., 2., 2., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 3., 2., 5., 0., 5., 1., 5., 21., 1., 19., 20., 1., 20., 1., 2., 1., 22., 3., 1., 21., 13., 33., 27., 7., 1., 1., 7., 4., 5., 9., 26., 20., 4., 13., 2., 8., 7., 2., 0., 5., 5., 16., 12., 16., 30., 15., 16., 6., 1., 1., 4., 0., 6., 3., 13., 2., 2., 23., 6., 25., 9., 5., 0., 1., 7., 1., 4., 0., 7., 1., 9., 3., 1., 4., 3., 2., 0., 2., 1., 0., 5., 2., 1., 10., 1., 5., 1., 1., 3., 0., 4., 2., 1., 8., 0., 0., 4., 6., 3., 2., 0., 3., 3., 1., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 5., 4., 5., 4., 12., 0., 4., 13., 2., 21., 2., 3., 14., 5., 2., 2., 18., 2., 5., 27., 8., 28., 22., 7., 4., 1., 5., 3., 4., 6., 21., 15., 2., 14., 1., 15., 15., 1., 2., 3., 1., 13., 10., 18., 39., 16., 27., 11., 3., 0., 4., 1., 6., 4., 8., 5., 8., 20., 3., 20., 8., 7., 3., 2., 7., 1., 3., 2., 5., 5., 5., 2., 2., 5., 4., 3., 1., 1., 2., 0., 2., 4., 1., 6., 3., 1., 3., 3., 4., 3., 5., 0., 2., 6., 3., 0., 4., 4., 2., 0., 3., 2., 1., 1., 2., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 8., 7., 3., 7., 2., 9., 22., 0., 17., 15., 3., 18., 3., 1., 5., 20., 1., 5., 29., 11., 29., 23., 4., 2., 4., 1., 3., 5., 14., 40., 16., 2., 25., 4., 15., 12., 5., 0., 4., 2., 12., 14., 26., 55., 13., 18., 9., 1., 1., 4., 0., 7., 1., 9., 8., 8., 15., 12., 28., 9., 6., 1., 1., 6., 0., 3., 1., 2., 3., 3., 3., 3., 3., 2., 2., 1., 1., 2., 0., 2., 3., 3., 7., 3., 3., 4., 2., 4., 2., 1., 2., 2., 7., 1., 0., 0., 3., 1., 2., 1., 4., 3., 0., 2., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 3., 1., 3., 6., 3., 7., 0., 7., 12., 0., 13., 15., 2., 12., 3., 0., 1., 22., 2., 3., 14., 11., 31., 27., 5., 0., 1., 3., 2., 6., 10., 17., 11., 3., 19., 4., 16., 5., 1., 0., 2., 1., 14., 6., 28., 48., 10., 19., 11., 3., 0., 2., 2., 6., 3., 4., 12., 5., 14., 5., 24., 11., 4., 1., 0., 12., 1., 4., 1., 11., 3., 4., 6., 0., 3., 0., 2., 1., 3., 3., 0., 3., 3., 2., 13., 1., 3., 2., 5., 4., 1., 0., 0., 2., 7., 3., 0., 2., 3., 0., 1., 3., 2., 3., 1., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 4., 6., 9., 1., 8., 0., 7., 26., 1., 9., 17., 1., 16., 2., 1., 1., 18., 3., 1., 31., 15., 15., 29., 5., 0., 1., 1., 3., 8., 14., 17., 25., 0., 13., 4., 12., 9., 0., 0., 1., 2., 14., 5., 20., 49., 10., 17., 9., 4., 1., 4., 4., 4., 6., 10., 4., 6., 16., 8., 17., 9., 1., 0., 0., 6., 0., 5., 3., 5., 4., 3., 4., 3., 3., 1., 2., 1., 2., 2., 0., 3., 0., 2., 4., 0., 2., 2., 0., 8., 0., 2., 0., 2., 8., 4., 0., 2., 0., 4., 2., 0., 6., 2., 2., 3., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 1., 7., 9., 4., 9., 0., 10., 13., 1., 24., 28., 0., 21., 5., 2., 4., 18., 2., 4., 15., 16., 31., 25., 6., 1., 2., 4., 2., 5., 2., 16., 5., 7., 22., 7., 21., 8., 1., 1., 4., 2., 15., 12., 14., 60., 8., 24., 8., 7., 0., 4., 0., 12., 3., 10., 5., 8., 24., 6., 37., 6., 1., 2., 0., 10., 0., 1., 1., 2., 2., 3., 3., 2., 3., 2., 3., 1., 1., 2., 0., 0., 5., 3., 8., 0., 5., 3., 3., 5., 0., 2., 1., 3., 9., 2., 0., 2., 1., 1., 5., 3., 6., 3., 0., 5., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 3., 6., 3., 3., 4., 1., 12., 14., 1., 10., 21., 1., 14., 2., 1., 1., 15., 2., 7., 11., 3., 21., 30., 7., 0., 2., 4., 1., 13., 6., 38., 17., 5., 20., 5., 7., 7., 4., 1., 5., 2., 19., 9., 14., 51., 14., 21., 14., 4., 1., 5., 1., 10., 5., 9., 7., 4., 22., 4., 19., 7., 3., 1., 0., 6., 1., 1., 1., 6., 0., 3., 3., 2., 6., 4., 2., 2., 2., 1., 0., 3., 1., 2., 5., 1., 4., 2., 1., 5., 1., 0., 0., 3., 12., 3., 0., 3., 2., 2., 3., 1., 1., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 3., 0., 1., 11., 4., 5., 0., 4., 22., 0., 10., 30., 1., 18., 5., 1., 0., 19., 2., 7., 31., 11., 19., 34., 3., 2., 1., 0., 4., 3., 9., 26., 14., 4., 20., 6., 16., 8., 6., 2., 6., 1., 18., 7., 19., 54., 14., 15., 9., 2., 1., 4., 0., 4., 1., 11., 11., 13., 20., 5., 24., 4., 3., 1., 2., 7., 0., 5., 3., 1., 5., 5., 2., 3., 2., 4., 2., 0., 2., 1., 0., 1., 1., 4., 7., 3., 4., 4., 0., 5., 1., 1., 1., 2., 3., 2., 0., 5., 3., 2., 2., 4., 3., 2., 0., 3., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 0., 2., 8., 6., 4., 1., 4., 19., 2., 17., 26., 2., 15., 2., 4., 2., 13., 3., 2., 9., 10., 22., 26., 7., 0., 1., 1., 2., 3., 7., 26., 19., 1., 15., 7., 13., 7., 2., 2., 3., 2., 10., 14., 25., 44., 12., 19., 5., 4., 1., 2., 3., 8., 5., 15., 5., 7., 10., 5., 20., 14., 2., 0., 3., 12., 1., 2., 0., 3., 2., 3., 3., 0., 4., 8., 2., 0., 2., 2., 0., 2., 2., 0., 6., 0., 2., 1., 2., 5., 1., 3., 1., 2., 5., 2., 0., 1., 4., 0., 3., 1., 0., 2., 0., 0., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 1., 1., 10., 3., 2., 6., 3., 19., 2., 15., 8., 0., 14., 2., 0., 1., 15., 7., 7., 38., 7., 25., 20., 6., 3., 0., 3., 1., 9., 9., 36., 19., 5., 17., 1., 13., 8., 1., 1., 7., 3., 16., 7., 15., 49., 8., 17., 5., 2., 1., 6., 4., 9., 3., 8., 3., 10., 22., 7., 21., 9., 1., 1., 2., 5., 0., 3., 1., 3., 0., 3., 4., 2., 3., 4., 1., 1., 0., 5., 0., 2., 3., 4., 3., 3., 4., 4., 1., 0., 1., 3., 0., 2., 6., 2., 0., 3., 3., 3., 3., 4., 1., 0., 1., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 4., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 0., 5., 9., 0., 5., 1., 5., 24., 0., 10., 13., 3., 15., 1., 0., 0., 26., 2., 3., 34., 14., 14., 29., 6., 2., 3., 1., 2., 10., 6., 28., 11., 1., 14., 3., 14., 7., 1., 2., 2., 2., 18., 18., 18., 41., 19., 13., 14., 5., 0., 4., 1., 7., 2., 13., 12., 9., 8., 5., 14., 8., 4., 2., 1., 8., 1., 4., 1., 5., 1., 10., 6., 2., 3., 2., 2., 1., 1., 2., 0., 1., 2., 1., 8., 3., 3., 0., 2., 4., 0., 3., 0., 3., 8., 2., 0., 2., 4., 0., 4., 1., 2., 2., 2., 4., 0., 0., 0., 0., 5., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 2., 3., 4., 12., 3., 4., 1., 2., 12., 1., 11., 23., 1., 12., 5., 0., 2., 17., 0., 3., 36., 11., 26., 25., 7., 2., 0., 5., 0., 9., 6., 5., 23., 4., 19., 2., 20., 12., 3., 1., 3., 2., 12., 7., 22., 51., 9., 29., 14., 9., 3., 2., 3., 6., 1., 12., 6., 10., 13., 3., 28., 11., 5., 1., 2., 8., 1., 3., 0., 3., 1., 0., 5., 2., 6., 1., 1., 1., 3., 2., 0., 0., 1., 4., 6., 1., 3., 4., 6., 4., 2., 1., 1., 2., 9., 3., 0., 1., 3., 4., 1., 1., 2., 0., 2., 0., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 1., 3., 1., 7., 1., 2., 2., 5., 13., 0., 12., 19., 1., 8., 2., 0., 5., 15., 4., 1., 27., 10., 29., 29., 5., 1., 1., 2., 2., 7., 4., 12., 17., 2., 14., 7., 20., 10., 3., 0., 6., 3., 14., 11., 27., 60., 7., 15., 7., 3., 0., 3., 5., 8., 5., 8., 10., 14., 20., 6., 18., 11., 2., 0., 0., 5., 1., 5., 3., 5., 1., 2., 6., 2., 5., 1., 4., 0., 2., 1., 0., 2., 0., 0., 3., 2., 1., 0., 2., 5., 1., 1., 1., 0., 7., 2., 0., 2., 2., 0., 1., 5., 0., 4., 1., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 3., 2., 7., 1., 5., 1., 9., 17., 1., 10., 28., 1., 14., 1., 0., 2., 17., 4., 6., 22., 17., 21., 24., 4., 0., 0., 3., 2., 8., 5., 43., 22., 1., 8., 3., 19., 10., 3., 0., 7., 1., 13., 4., 23., 46., 17., 28., 12., 5., 1., 3., 3., 5., 6., 7., 6., 10., 14., 13., 15., 8., 0., 0., 1., 4., 1., 3., 1., 6., 1., 5., 4., 3., 4., 2., 1., 0., 3., 2., 0., 3., 1., 1., 8., 5., 3., 1., 2., 4., 1., 3., 0., 3., 8., 4., 0., 3., 5., 4., 1., 2., 2., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 2., 1., 5., 2., 9., 0., 10., 8., 2., 8., 20., 0., 16., 1., 3., 0., 18., 4., 2., 15., 9., 28., 28., 8., 2., 0., 2., 0., 8., 12., 22., 23., 2., 10., 3., 15., 9., 3., 1., 3., 1., 14., 9., 17., 50., 14., 22., 7., 2., 1., 9., 2., 8., 1., 9., 4., 11., 13., 7., 25., 4., 5., 1., 1., 13., 1., 1., 3., 7., 5., 2., 2., 2., 4., 3., 3., 0., 3., 0., 0., 1., 2., 0., 4., 1., 3., 3., 3., 4., 0., 3., 1., 1., 6., 3., 0., 1., 4., 4., 1., 2., 2., 1., 3., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 2., 3., 6., 3., 3., 1., 5., 26., 2., 18., 27., 2., 12., 4., 1., 1., 18., 5., 8., 24., 12., 17., 31., 7., 1., 1., 1., 2., 4., 6., 27., 10., 1., 22., 4., 15., 7., 3., 2., 6., 3., 12., 10., 19., 43., 11., 23., 9., 5., 0., 2., 1., 10., 1., 13., 4., 11., 15., 10., 19., 9., 3., 0., 1., 8., 0., 3., 5., 6., 2., 3., 3., 1., 3., 1., 1., 3., 1., 3., 0., 3., 1., 0., 2., 1., 4., 3., 2., 3., 1., 1., 0., 3., 15., 0., 0., 2., 4., 1., 2., 2., 2., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 4., 5., 11., 0., 25., 0., 6., 62., 1., 13., 71., 1., 4., 1., 0., 2., 76., 9., 9., 82., 16., 76., 10., 4., 0., 2., 1., 1., 19., 9., 52., 8., 4., 45., 33., 8., 6., 0., 0., 4., 4., 17., 7., 23., 4., 7., 4., 3., 2., 0., 17., 6., 12., 3., 22., 4., 8., 2., 2., 34., 10., 11., 2., 0., 14., 7., 10., 4., 18., 2., 5., 2., 1., 0., 0., 7., 1., 19., 12., 1., 5., 0., 4., 0., 0., 0., 0., 0., 6., 0., 2., 2., 5., 0., 0., 0., 0., 0., 1., 0., 1., 0., 1., 0., 3., 0., 2., 0., 2., 0., 0., 0., 3., 0., 3., 4., 4., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 26., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 1., 2., 5., 0., 12., 2., 7., 34., 3., 8., 52., 1., 6., 1., 0., 1., 45., 14., 10., 81., 10., 77., 7., 2., 0., 0., 2., 2., 11., 6., 37., 11., 3., 45., 37., 19., 3., 0., 0., 7., 3., 23., 8., 25., 8., 12., 6., 5., 2., 0., 9., 1., 18., 8., 14., 0., 11., 4., 3., 27., 9., 10., 6., 0., 13., 7., 4., 1., 12., 1., 2., 1., 2., 1., 0., 2., 3., 14., 12., 2., 7., 3., 0., 0., 0., 0., 0., 0., 9., 1., 6., 2., 4., 0., 0., 0., 1., 0., 0., 0., 1., 3., 2., 0., 3., 0., 0., 0., 2., 0., 0., 0., 2., 0., 1., 0., 4., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 22., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 7., 7., 0., 20., 5., 5., 57., 1., 6., 61., 2., 7., 1., 0., 3., 69., 9., 12., 61., 16., 79., 14., 5., 0., 2., 1., 1., 17., 4., 49., 10., 2., 36., 35., 9., 6., 0., 0., 4., 4., 22., 4., 28., 8., 5., 8., 1., 0., 0., 7., 6., 16., 3., 17., 1., 14., 2., 0., 44., 7., 9., 4., 0., 18., 3., 7., 3., 9., 5., 4., 0., 3., 0., 0., 2., 4., 14., 7., 3., 3., 0., 2., 0., 0., 0., 0., 0., 12., 1., 1., 0., 3., 1., 1., 0., 2., 0., 1., 0., 2., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 21., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 6., 12., 0., 16., 3., 13., 47., 0., 5., 42., 1., 6., 0., 0., 4., 64., 10., 8., 72., 15., 71., 14., 1., 0., 2., 2., 2., 19., 7., 65., 9., 1., 33., 30., 14., 3., 0., 1., 8., 2., 22., 7., 26., 11., 7., 7., 3., 0., 0., 12., 5., 24., 5., 9., 4., 5., 3., 3., 38., 5., 7., 0., 0., 17., 1., 7., 1., 13., 0., 1., 1., 4., 1., 0., 6., 0., 21., 9., 2., 4., 1., 1., 0., 0., 0., 0., 0., 8., 1., 4., 3., 2., 0., 1., 0., 2., 0., 0., 0., 4., 3., 2., 0., 2., 0., 0., 0., 1., 0., 0., 0., 2., 0., 5., 1., 0., 0., 0., 0., 2., 0., 6., 0., 0., 0., 0., 28., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 3., 0., 11., 0., 11., 2., 8., 48., 1., 9., 46., 0., 4., 0., 0., 1., 75., 3., 12., 73., 12., 82., 6., 7., 0., 0., 3., 2., 18., 8., 61., 11., 3., 33., 32., 10., 4., 0., 1., 9., 4., 19., 7., 26., 9., 10., 5., 3., 2., 0., 6., 8., 19., 2., 23., 2., 8., 2., 6., 39., 5., 6., 3., 0., 12., 2., 8., 3., 7., 4., 3., 1., 0., 0., 0., 5., 1., 18., 12., 2., 6., 1., 3., 0., 0., 0., 0., 0., 13., 1., 4., 3., 1., 2., 1., 0., 3., 0., 2., 0., 1., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 3., 1., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 20., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 7., 4., 11., 0., 19., 0., 4., 58., 2., 7., 57., 0., 4., 3., 0., 1., 80., 17., 8., 79., 14., 77., 9., 5., 0., 1., 2., 3., 7., 6., 57., 6., 0., 36., 37., 9., 3., 0., 0., 7., 6., 25., 3., 14., 5., 11., 6., 3., 0., 0., 9., 6., 20., 4., 19., 4., 6., 4., 3., 34., 8., 9., 1., 0., 17., 2., 10., 1., 13., 5., 3., 1., 1., 0., 0., 7., 2., 13., 9., 2., 5., 2., 3., 0., 0., 0., 0., 0., 18., 0., 3., 4., 2., 0., 1., 0., 1., 0., 1., 0., 2., 4., 4., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 4., 3., 1., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 22., 0., 2., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 3., 6., 8., 0., 15., 1., 8., 47., 0., 3., 64., 2., 4., 1., 0., 0., 75., 4., 5., 84., 5., 98., 5., 5., 0., 1., 5., 3., 11., 6., 46., 16., 3., 38., 34., 7., 4., 0., 2., 7., 5., 32., 9., 25., 5., 4., 4., 4., 1., 0., 11., 3., 12., 6., 13., 4., 6., 6., 3., 32., 11., 10., 0., 0., 11., 3., 5., 1., 6., 0., 3., 2., 3., 0., 0., 3., 1., 14., 12., 5., 2., 1., 4., 0., 0., 0., 0., 0., 5., 1., 2., 5., 3., 1., 0., 0., 0., 0., 0., 0., 1., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 1., 0., 7., 0., 0., 0., 0., 18., 0., 2., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 2., 2., 13., 0., 13., 1., 15., 57., 0., 6., 53., 1., 2., 1., 0., 3., 74., 9., 8., 79., 16., 76., 13., 2., 0., 1., 4., 1., 14., 9., 53., 9., 2., 34., 33., 14., 4., 0., 0., 8., 5., 19., 6., 22., 6., 13., 3., 1., 2., 0., 11., 8., 11., 8., 15., 3., 12., 3., 2., 38., 11., 7., 2., 0., 7., 3., 7., 3., 8., 4., 4., 0., 0., 0., 0., 2., 2., 21., 8., 3., 2., 3., 3., 0., 0., 0., 0., 0., 16., 4., 2., 0., 1., 0., 0., 0., 1., 0., 1., 0., 1., 6., 2., 0., 1., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 3., 1., 0., 0., 0., 1., 0., 7., 0., 0., 0., 0., 28., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 1., 2., 9., 0., 17., 4., 10., 49., 1., 11., 40., 1., 8., 1., 0., 0., 70., 15., 12., 68., 16., 90., 12., 3., 0., 2., 1., 4., 21., 6., 35., 10., 3., 39., 22., 12., 4., 0., 2., 7., 5., 22., 5., 19., 5., 11., 1., 2., 1., 0., 14., 4., 12., 5., 11., 3., 4., 2., 4., 43., 8., 4., 0., 0., 12., 7., 10., 2., 15., 2., 3., 0., 0., 1., 0., 6., 1., 17., 7., 3., 5., 1., 4., 0., 0., 0., 0., 0., 11., 0., 2., 3., 2., 0., 5., 0., 0., 0., 0., 0., 1., 4., 1., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 3., 4., 3., 0., 0., 0., 3., 0., 4., 0., 0., 0., 0., 24., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 2., 4., 12., 0., 9., 1., 8., 47., 2., 11., 48., 1., 2., 1., 0., 1., 79., 6., 10., 64., 14., 56., 11., 2., 0., 0., 4., 1., 13., 7., 81., 14., 0., 38., 33., 19., 3., 0., 1., 6., 4., 24., 8., 28., 6., 11., 1., 5., 1., 0., 15., 4., 18., 5., 20., 2., 10., 4., 3., 49., 11., 6., 2., 0., 15., 3., 9., 1., 10., 3., 6., 1., 0., 2., 0., 3., 1., 11., 9., 2., 7., 0., 3., 0., 0., 0., 0., 0., 7., 3., 2., 0., 4., 0., 0., 0., 1., 0., 0., 0., 0., 2., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 1., 5., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 28., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 2., 2., 1., 13., 0., 16., 3., 7., 43., 1., 10., 57., 0., 8., 0., 0., 4., 73., 12., 1., 81., 10., 94., 10., 8., 0., 0., 6., 0., 14., 18., 43., 12., 2., 36., 28., 9., 6., 0., 0., 4., 6., 17., 8., 20., 8., 16., 5., 4., 0., 0., 12., 5., 19., 6., 20., 1., 8., 4., 5., 44., 15., 7., 1., 0., 14., 4., 7., 4., 11., 4., 6., 0., 3., 1., 0., 6., 2., 12., 11., 2., 7., 0., 2., 0., 0., 0., 0., 0., 16., 1., 5., 1., 4., 0., 1., 0., 1., 0., 0., 0., 1., 2., 5., 0., 3., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 2., 5., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 27., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 4., 1., 8., 31., 8., 24., 3., 16., 147., 2., 17., 186., 10., 11., 7., 0., 4., 79., 1., 12., 284., 37., 327., 41., 19., 1., 6., 8., 6., 52., 35., 202., 37., 8., 168., 12., 50., 11., 0., 0., 11., 9., 67., 23., 91., 18., 44., 43., 10., 5., 1., 26., 8., 39., 12., 50., 8., 37., 2., 14., 5., 1., 0., 0., 0., 25., 5., 16., 2., 30., 4., 14., 5., 2., 6., 0., 2., 5., 1., 14., 3., 7., 0., 10., 1., 1., 7., 132., 7., 1762., 81., 115., 228., 77., 111., 67., 15., 12., 15., 16., 2., 2., 10., 1., 4., 11., 7., 36., 20., 29., 18., 56., 4., 8., 5., 5., 7., 6., 1., 5., 4., 4., 4., 0., 1., 7., 17., 1., 0., 6., 4., 2., 0., 3., 5., 5., 42., 3., 9., 2., 13., 4., 20., 2., 4., 6., 4., 34., 5., 40., 5., 0., 7., 2., 32., 6., 11., 11.,

9., 2., 2., 8., 8., 5., 6., 0., 10., 18., 1., 13., 19., 3., 16., 2., 1., 0., 18., 2., 3., 28., 6., 27., 28., 5., 1., 0., 1., 1., 12., 7., 21., 16., 1., 20., 7., 13., 6., 1., 0., 4., 2., 9., 9., 21., 44., 10., 14., 5., 4., 0., 6., 0., 9., 4., 14., 5., 7., 14., 7., 22., 8., 3., 0., 0., 6., 1., 3., 1., 4., 5., 2., 5., 2., 4., 2., 2., 2., 1., 3., 0., 2., 3., 6., 7., 3., 9., 3., 1., 7., 0., 4., 2., 4., 9., 2., 0., 1., 0., 2., 3., 2., 1., 4., 2., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 2., 4., 11., 1., 5., 1., 12., 20., 2., 12., 17., 3., 13., 3., 2., 0., 17., 3., 4., 27., 12., 17., 26., 5., 2., 0., 1., 1., 8., 11., 29., 13., 6., 19., 3., 17., 5., 2., 1., 6., 1., 8., 13., 19., 45., 7., 23., 7., 1., 2., 8., 2., 8., 2., 4., 5., 4., 22., 6., 11., 9., 7., 2., 0., 8., 1., 5., 1., 4., 3., 3., 3., 2., 4., 2., 0., 1., 1., 3., 0., 1., 0., 1., 3., 0., 3., 3., 0., 5., 3., 1., 1., 4., 6., 1., 0., 1., 3., 1., 3., 3., 1., 4., 0., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 2., 1., 1., 12., 3., 6., 0., 10., 31., 3., 9., 21., 0., 17., 2., 0., 3., 13., 0., 5., 19., 12., 19., 17., 8., 0., 2., 4., 6., 11., 7., 36., 8., 3., 11., 2., 17., 9., 2., 3., 10., 1., 13., 8., 23., 38., 20., 23., 13., 4., 2., 5., 3., 7., 4., 12., 3., 9., 9., 8., 20., 9., 3., 2., 0., 10., 2., 3., 2., 7., 1., 4., 2., 0., 1., 4., 6., 2., 3., 1., 0., 1., 1., 3., 7., 2., 4., 2., 0., 6., 1., 0., 1., 2., 5., 1., 0., 1., 1., 5., 2., 2., 2., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 3., 8., 8., 5., 8., 2., 9., 14., 1., 10., 24., 3., 14., 5., 2., 3., 12., 0., 1., 14., 15., 25., 23., 5., 0., 0., 6., 0., 5., 4., 22., 7., 2., 15., 8., 9., 7., 1., 0., 5., 2., 7., 6., 14., 51., 14., 17., 9., 8., 1., 5., 1., 6., 2., 6., 4., 5., 19., 9., 15., 9., 3., 1., 0., 7., 2., 6., 4., 7., 1., 7., 2., 1., 0., 5., 3., 2., 2., 1., 0., 5., 3., 3., 12., 2., 6., 0., 3., 4., 2., 2., 1., 0., 6., 4., 0., 1., 5., 3., 3., 2., 4., 2., 2., 0., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 1., 7., 7., 4., 14., 1., 6., 21., 2., 8., 30., 1., 20., 5., 2., 4., 17., 3., 5., 29., 12., 9., 24., 10., 3., 3., 0., 1., 4., 11., 22., 26., 1., 19., 2., 20., 8., 1., 0., 4., 1., 14., 5., 20., 40., 16., 20., 6., 4., 3., 6., 3., 6., 5., 8., 11., 7., 12., 3., 32., 5., 1., 1., 0., 9., 1., 5., 1., 2., 1., 6., 7., 0., 5., 2., 1., 2., 1., 2., 0., 1., 4., 2., 4., 2., 5., 1., 4., 2., 0., 4., 0., 2., 3., 1., 0., 2., 2., 1., 1., 1., 0., 1., 1., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 6., 9., 3., 9., 0., 3., 24., 0., 18., 23., 1., 12., 8., 1., 1., 11., 2., 1., 28., 15., 32., 29., 5., 0., 1., 2., 1., 7., 9., 14., 18., 4., 12., 3., 8., 11., 3., 0., 5., 0., 9., 13., 9., 38., 9., 17., 5., 3., 1., 5., 3., 11., 4., 9., 9., 8., 16., 6., 30., 11., 4., 2., 2., 8., 0., 1., 3., 5., 1., 2., 1., 3., 3., 9., 1., 1., 4., 3., 0., 0., 3., 2., 7., 3., 4., 1., 2., 6., 2., 3., 2., 0., 4., 3., 0., 4., 2., 3., 1., 4., 5., 3., 0., 0., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 4., 1., 8., 2., 4., 1., 5., 16., 0., 14., 13., 1., 8., 2., 0., 0., 29., 3., 5., 21., 14., 20., 29., 4., 0., 2., 2., 2., 6., 5., 22., 18., 2., 18., 3., 13., 5., 0., 1., 5., 3., 6., 13., 9., 40., 7., 16., 5., 1., 2., 2., 2., 9., 1., 9., 8., 1., 15., 5., 19., 14., 4., 1., 0., 9., 1., 3., 1., 2., 2., 6., 10., 1., 3., 6., 1., 0., 4., 3., 0., 3., 0., 1., 8., 2., 8., 1., 0., 5., 0., 2., 0., 0., 3., 3., 0., 2., 4., 4., 3., 3., 2., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 4., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 2., 5., 8., 0., 6., 1., 5., 11., 2., 12., 35., 0., 21., 4., 4., 1., 9., 3., 6., 38., 12., 17., 30., 7., 0., 1., 2., 2., 8., 5., 15., 17., 5., 13., 2., 20., 9., 0., 1., 5., 2., 20., 5., 20., 45., 10., 23., 9., 1., 0., 4., 2., 5., 1., 11., 5., 9., 16., 5., 32., 9., 4., 1., 3., 8., 0., 7., 4., 8., 2., 2., 5., 0., 4., 4., 1., 0., 1., 2., 0., 4., 2., 1., 5., 2., 4., 0., 5., 3., 3., 0., 3., 2., 4., 2., 0., 5., 1., 2., 1., 0., 5., 4., 0., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 2., 2., 3., 7., 0., 5., 2., 4., 20., 1., 19., 14., 1., 13., 3., 0., 3., 14., 1., 2., 32., 10., 16., 24., 5., 0., 0., 1., 4., 8., 4., 24., 15., 1., 9., 9., 13., 10., 3., 2., 1., 1., 6., 14., 14., 52., 15., 33., 8., 2., 1., 5., 0., 4., 0., 7., 6., 6., 17., 8., 20., 6., 1., 0., 0., 7., 2., 3., 2., 7., 2., 4., 2., 3., 2., 1., 2., 0., 3., 3., 0., 2., 1., 2., 6., 1., 6., 1., 1., 8., 1., 0., 3., 6., 9., 6., 0., 2., 2., 0., 2., 0., 2., 4., 1., 4., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 2., 3., 9., 2., 10., 0., 5., 35., 0., 12., 17., 4., 12., 5., 0., 4., 17., 3., 2., 33., 15., 18., 33., 3., 2., 2., 2., 3., 7., 4., 27., 19., 3., 19., 5., 16., 8., 1., 0., 4., 3., 13., 12., 18., 52., 8., 30., 5., 3., 0., 7., 5., 5., 3., 10., 6., 5., 13., 4., 25., 12., 2., 2., 1., 5., 1., 3., 4., 4., 1., 4., 6., 4., 1., 2., 2., 2., 1., 3., 0., 1., 3., 0., 5., 2., 4., 2., 1., 2., 2., 1., 0., 1., 13., 2., 0., 0., 4., 1., 3., 1., 1., 4., 2., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 0., 4., 7., 2., 2., 0., 3., 21., 1., 11., 28., 3., 18., 2., 2., 1., 24., 5., 3., 19., 11., 20., 26., 8., 2., 1., 2., 2., 7., 13., 23., 16., 3., 17., 4., 12., 10., 1., 3., 6., 4., 10., 14., 10., 50., 11., 31., 7., 3., 1., 9., 2., 7., 1., 8., 6., 10., 9., 11., 20., 4., 1., 0., 2., 8., 1., 2., 4., 8., 2., 9., 2., 2., 8., 1., 3., 2., 2., 0., 0., 4., 0., 4., 3., 1., 3., 4., 0., 1., 1., 1., 1., 3., 7., 2., 0., 1., 0., 4., 2., 0., 3., 3., 0., 0., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 3., 3., 4., 4., 8., 1., 5., 15., 0., 15., 18., 0., 23., 4., 0., 5., 20., 2., 4., 17., 13., 12., 18., 11., 1., 1., 1., 1., 11., 9., 26., 23., 0., 13., 5., 12., 9., 0., 0., 1., 5., 16., 10., 30., 52., 8., 22., 13., 2., 1., 5., 2., 6., 6., 9., 5., 7., 12., 4., 10., 7., 2., 2., 0., 5., 0., 4., 1., 1., 3., 4., 4., 2., 5., 1., 3., 1., 4., 2., 0., 2., 1., 0., 4., 2., 10., 1., 1., 0., 3., 1., 1., 1., 5., 3., 0., 2., 1., 4., 1., 1., 2., 2., 2., 2., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 2., 1., 5., 9., 5., 5., 1., 6., 31., 3., 15., 16., 1., 17., 4., 1., 0., 16., 1., 3., 6., 13., 29., 29., 7., 2., 1., 3., 4., 6., 10., 44., 21., 2., 16., 4., 17., 8., 0., 2., 4., 3., 16., 8., 15., 51., 14., 18., 12., 0., 3., 2., 5., 8., 2., 9., 4., 3., 12., 4., 22., 8., 3., 0., 0., 6., 0., 2., 2., 5., 1., 3., 3., 1., 2., 7., 1., 1., 3., 2., 0., 2., 3., 5., 3., 3., 6., 3., 1., 6., 2., 3., 1., 4., 13., 6., 0., 0., 0., 3., 3., 0., 5., 2., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 4., 4., 10., 5., 4., 1., 4., 21., 0., 16., 19., 2., 14., 1., 3., 2., 15., 4., 5., 19., 15., 27., 22., 5., 0., 1., 5., 2., 5., 14., 20., 16., 1., 11., 2., 13., 5., 0., 0., 7., 4., 15., 11., 15., 33., 9., 28., 11., 4., 1., 10., 4., 5., 3., 9., 6., 9., 13., 4., 26., 7., 0., 0., 1., 8., 0., 3., 2., 5., 8., 1., 4., 1., 4., 6., 0., 0., 0., 2., 0., 2., 3., 2., 7., 2., 3., 3., 2., 3., 1., 2., 1., 1., 9., 4., 0., 1., 2., 1., 2., 3., 2., 3., 2., 5., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 6., 2., 6., 1., 3., 1., 6., 22., 0., 8., 26., 0., 15., 2., 0., 4., 22., 2., 6., 17., 8., 19., 25., 7., 0., 1., 3., 1., 10., 2., 28., 16., 2., 8., 5., 7., 8., 0., 0., 3., 2., 15., 15., 20., 44., 10., 20., 8., 5., 0., 10., 3., 10., 1., 8., 6., 9., 29., 4., 22., 10., 3., 0., 0., 7., 2., 3., 3., 6., 0., 2., 4., 0., 5., 5., 2., 0., 0., 0., 0., 5., 3., 2., 5., 5., 4., 3., 0., 2., 0., 4., 0., 1., 9., 6., 0., 3., 0., 1., 3., 2., 2., 1., 3., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 6., 1., 4., 1., 8., 1., 4., 16., 1., 14., 32., 2., 18., 3., 1., 1., 21., 3., 0., 20., 12., 18., 28., 6., 0., 1., 2., 2., 9., 9., 29., 16., 3., 14., 0., 8., 10., 0., 1., 9., 1., 3., 16., 20., 45., 12., 23., 8., 5., 0., 4., 2., 4., 4., 19., 4., 8., 14., 7., 20., 9., 3., 0., 1., 8., 1., 3., 1., 7., 3., 1., 1., 4., 3., 2., 2., 0., 4., 1., 0., 3., 2., 1., 7., 5., 8., 0., 2., 4., 2., 3., 0., 2., 11., 2., 0., 1., 1., 1., 4., 2., 5., 1., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0.,

16., 4., 6., 5., 4., 4., 4., 0., 6., 8., 0., 21., 33., 0., 15., 1., 1., 0., 19., 0., 2., 22., 10., 18., 29., 6., 0., 2., 4., 0., 12., 11., 35., 16., 0., 18., 2., 11., 15., 0., 2., 4., 2., 12., 8., 18., 46., 14., 22., 12., 2., 0., 3., 0., 2., 3., 8., 9., 5., 8., 3., 24., 4., 2., 1., 1., 4., 2., 1., 2., 7., 5., 4., 1., 2., 4., 5., 2., 3., 2., 5., 0., 4., 0., 1., 7., 2., 4., 2., 2., 4., 0., 3., 0., 1., 5., 1., 0., 2., 7., 2., 5., 2., 1., 1., 2., 3., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 2., 7., 3., 4., 0., 10., 29., 1., 13., 23., 2., 15., 2., 0., 2., 18., 2., 2., 10., 15., 17., 28., 3., 1., 0., 5., 2., 9., 5., 38., 24., 2., 12., 5., 11., 7., 2., 1., 2., 2., 13., 10., 16., 45., 17., 12., 13., 5., 1., 5., 1., 3., 2., 12., 4., 7., 22., 3., 21., 5., 1., 0., 2., 5., 1., 0., 3., 5., 2., 3., 4., 1., 4., 1., 0., 2., 2., 1., 0., 1., 3., 2., 5., 2., 3., 3., 2., 4., 0., 3., 1., 1., 7., 3., 0., 0., 0., 1., 2., 0., 4., 2., 0., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 3., 6., 7., 3., 7., 2., 6., 18., 1., 13., 23., 0., 19., 3., 1., 2., 31., 2., 5., 43., 13., 28., 35., 4., 1., 0., 2., 1., 4., 9., 27., 14., 8., 26., 4., 17., 8., 0., 2., 1., 0., 9., 6., 19., 52., 20., 25., 8., 3., 0., 5., 1., 7., 4., 7., 8., 10., 8., 4., 19., 3., 2., 2., 2., 7., 0., 2., 4., 3., 2., 1., 3., 6., 3., 3., 1., 0., 3., 1., 0., 3., 2., 2., 11., 3., 4., 0., 0., 2., 0., 2., 0., 1., 6., 1., 0., 3., 4., 4., 2., 3., 1., 1., 1., 4., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 2., 1., 13., 0., 23., 6., 9., 46., 1., 6., 61., 1., 4., 3., 0., 0., 63., 10., 6., 69., 16., 93., 16., 3., 0., 2., 3., 0., 21., 6., 35., 10., 1., 37., 23., 11., 4., 0., 2., 2., 0., 28., 6., 32., 9., 16., 5., 2., 4., 0., 4., 6., 15., 9., 17., 3., 13., 2., 3., 45., 6., 12., 0., 0., 10., 1., 6., 3., 18., 2., 3., 1., 0., 2., 0., 4., 3., 16., 9., 1., 7., 3., 4., 0., 0., 0., 0., 0., 13., 3., 1., 4., 0., 1., 3., 0., 1., 0., 0., 0., 1., 1., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 3., 2., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 19., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 3., 1., 6., 13., 0., 19., 3., 6., 40., 2., 4., 62., 1., 5., 1., 0., 4., 80., 3., 11., 63., 16., 71., 7., 4., 0., 1., 2., 0., 13., 7., 61., 8., 3., 36., 38., 10., 8., 0., 2., 8., 5., 25., 5., 14., 7., 6., 8., 2., 3., 0., 7., 5., 19., 5., 20., 0., 5., 5., 1., 31., 9., 9., 3., 0., 20., 4., 6., 0., 10., 3., 0., 0., 2., 3., 0., 3., 2., 10., 22., 1., 3., 2., 2., 0., 0., 0., 0., 0., 7., 4., 3., 3., 2., 1., 0., 0., 0., 0., 3., 0., 0., 4., 2., 0., 1., 0., 1., 0., 3., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 23., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 2., 5., 8., 0., 9., 0., 6., 56., 1., 13., 48., 0., 4., 1., 0., 2., 67., 10., 5., 65., 10., 72., 13., 8., 0., 0., 4., 1., 16., 13., 53., 18., 1., 39., 31., 17., 4., 0., 1., 3., 1., 24., 5., 27., 6., 10., 11., 2., 2., 0., 13., 3., 27., 5., 14., 2., 7., 1., 4., 43., 12., 12., 1., 0., 15., 4., 11., 4., 10., 1., 4., 2., 4., 1., 0., 6., 2., 17., 10., 5., 5., 1., 3., 0., 0., 0., 0., 0., 7., 2., 2., 1., 2., 0., 1., 0., 1., 0., 1., 0., 0., 4., 4., 0., 5., 0., 3., 0., 0., 0., 0., 0., 0., 0., 2., 2., 4., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 18., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 5., 1., 8., 0., 20., 1., 3., 44., 2., 7., 58., 1., 5., 3., 0., 2., 64., 7., 8., 83., 14., 81., 8., 3., 0., 2., 1., 4., 14., 8., 42., 15., 3., 36., 30., 14., 7., 0., 1., 7., 4., 25., 14., 19., 7., 11., 4., 6., 1., 0., 10., 3., 11., 5., 17., 4., 10., 4., 4., 51., 12., 7., 2., 0., 23., 4., 9., 5., 15., 2., 4., 1., 0., 1., 0., 2., 3., 14., 12., 1., 2., 2., 2., 0., 0., 0., 0., 0., 9., 1., 2., 0., 2., 0., 2., 0., 0., 0., 1., 0., 0., 2., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 3., 4., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 17., 0., 2., 0., 8., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 4., 1., 7., 0., 11., 1., 8., 34., 1., 8., 64., 1., 4., 1., 0., 3., 55., 5., 7., 69., 16., 90., 12., 2., 0., 2., 3., 0., 20., 8., 47., 17., 1., 43., 33., 20., 5., 0., 0., 4., 2., 17., 7., 31., 11., 22., 8., 2., 2., 0., 9., 5., 17., 9., 18., 3., 6., 3., 3., 36., 6., 6., 2., 0., 5., 3., 9., 2., 7., 1., 3., 1., 3., 1., 0., 2., 1., 16., 12., 2., 1., 1., 5., 0., 0., 0., 0., 0., 12., 1., 2., 0., 3., 0., 1., 0., 1., 0., 3., 0., 6., 0., 2., 0., 2., 0., 3., 0., 1., 0., 0., 0., 1., 0., 1., 4., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 27., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 4., 1., 10., 0., 9., 1., 7., 56., 0., 7., 56., 3., 2., 3., 0., 1., 56., 5., 4., 73., 12., 94., 11., 6., 0., 2., 3., 1., 16., 6., 58., 11., 1., 43., 37., 16., 4., 0., 2., 4., 2., 23., 7., 24., 3., 13., 5., 2., 2., 0., 7., 8., 12., 5., 16., 0., 6., 4., 2., 45., 1., 7., 0., 0., 13., 2., 7., 1., 15., 1., 4., 2., 1., 0., 0., 5., 2., 13., 3., 3., 3., 2., 0., 0., 0., 0., 0., 0., 12., 0., 6., 1., 2., 0., 0., 0., 1., 0., 4., 0., 1., 5., 2., 0., 4., 0., 1., 0., 3., 0., 0., 0., 1., 0., 2., 1., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 27., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 1., 4., 8., 0., 17., 3., 8., 42., 1., 9., 40., 2., 9., 1., 0., 1., 73., 5., 5., 90., 14., 81., 16., 3., 0., 4., 1., 3., 9., 11., 53., 15., 3., 33., 26., 18., 6., 0., 0., 6., 7., 26., 8., 26., 9., 11., 5., 6., 2., 0., 5., 7., 14., 4., 15., 5., 10., 2., 6., 38., 7., 13., 3., 0., 8., 5., 5., 2., 6., 4., 5., 2., 0., 1., 0., 4., 1., 11., 6., 6., 2., 0., 3., 0., 0., 0., 0., 0., 8., 5., 3., 1., 6., 0., 0., 0., 0., 0., 1., 0., 0., 5., 1., 0., 2., 0., 0., 0., 1., 0., 0., 0., 2., 0., 1., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 26., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 4., 1., 3., 8., 0., 10., 2., 4., 62., 2., 8., 46., 1., 6., 3., 0., 2., 55., 7., 9., 72., 20., 78., 11., 6., 0., 0., 2., 2., 15., 9., 52., 12., 1., 37., 36., 17., 7., 0., 0., 4., 2., 19., 5., 25., 4., 11., 5., 1., 2., 0., 7., 10., 15., 6., 17., 3., 6., 2., 6., 37., 7., 9., 2., 0., 13., 5., 11., 2., 10., 3., 3., 1., 0., 0., 0., 3., 5., 22., 5., 3., 1., 0., 1., 0., 0., 0., 0., 0., 10., 2., 1., 1., 4., 1., 0., 0., 2., 0., 0., 0., 1., 5., 1., 0., 4., 0., 0., 0., 4., 0., 0., 0., 1., 0., 0., 4., 2., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 28., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 2., 4., 17., 0., 12., 5., 6., 50., 0., 8., 51., 0., 4., 3., 0., 2., 67., 7., 7., 78., 13., 59., 15., 0., 0., 1., 4., 0., 18., 12., 49., 19., 2., 29., 40., 14., 9., 0., 1., 8., 5., 15., 8., 26., 8., 9., 5., 1., 4., 0., 14., 3., 11., 8., 18., 1., 9., 5., 1., 31., 9., 10., 1., 0., 7., 5., 6., 0., 10., 2., 7., 3., 1., 1., 0., 2., 0., 13., 7., 5., 2., 2., 1., 0., 0., 0., 0., 0., 3., 1., 2., 3., 7., 0., 0., 0., 1., 0., 1., 0., 0., 5., 1., 0., 5., 0., 3., 0., 2., 0., 0., 0., 1., 0., 4., 1., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 20., 0., 3., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 3., 6., 18., 0., 10., 4., 6., 59., 3., 8., 77., 4., 6., 2., 0., 1., 82., 9., 12., 73., 19., 91., 7., 4., 0., 1., 3., 5., 11., 9., 42., 11., 2., 45., 32., 16., 2., 0., 0., 7., 1., 26., 3., 25., 4., 17., 6., 2., 1., 0., 14., 6., 11., 3., 14., 4., 12., 3., 7., 20., 8., 9., 2., 0., 13., 1., 10., 3., 13., 1., 4., 2., 0., 1., 0., 4., 4., 20., 9., 3., 4., 1., 6., 0., 0., 0., 0., 0., 5., 3., 3., 3., 3., 0., 2., 0., 2., 0., 4., 0., 2., 4., 2., 0., 1., 0., 1., 0., 2., 0., 0., 0., 1., 0., 2., 4., 3., 0., 0., 0., 2., 0., 7., 0., 0., 0., 0., 18., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 4., 8., 12., 0., 21., 2., 8., 41., 0., 7., 58., 1., 7., 2., 0., 1., 70., 10., 9., 79., 11., 90., 19., 4., 0., 1., 6., 1., 16., 5., 47., 10., 3., 37., 28., 19., 3., 0., 2., 5., 4., 24., 4., 28., 2., 14., 11., 2., 1., 0., 8., 2., 15., 7., 16., 2., 6., 2., 3., 35., 14., 8., 1., 0., 13., 6., 5., 1., 12., 0., 4., 1., 0., 2., 0., 3., 3., 17., 4., 2., 6., 2., 3., 0., 0., 0., 0., 0., 11., 1., 6., 2., 1., 1., 2., 0., 1., 0., 3., 0., 0., 1., 4., 0., 2., 0., 2., 0., 0., 0., 0., 0., 1., 0., 1., 3., 4., 0., 0., 0., 2., 0., 6., 0., 0., 0., 0., 19., 0., 3., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 0., 2., 13., 0., 13., 0., 6., 56., 0., 10., 53., 2., 4., 1., 0., 1., 65., 17., 13., 72., 22., 85., 7., 5., 0., 0., 4., 5., 17., 5., 58., 10., 3., 40., 33., 20., 6., 0., 0., 7., 1., 32., 6., 27., 7., 19., 7., 2., 2., 0., 12., 4., 14., 4., 15., 1., 8., 2., 4., 33., 7., 8., 3., 0., 10., 4., 6., 3., 4., 1., 9., 0., 1., 0., 0., 4., 0., 18., 9., 3., 7., 1., 2., 0., 0., 0., 0., 0., 7., 1., 2., 1., 2., 1., 1., 0., 2., 0., 2., 0., 4., 2., 3., 0., 1., 0., 2., 0., 0., 0., 0., 0., 1., 0., 2., 2., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 24., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 3., 3., 8., 26., 9., 27., 2., 14., 169., 2., 30., 196., 7., 17., 3., 0., 5., 99., 1., 13., 263., 51., 357., 59., 18., 0., 2., 5., 4., 51., 32., 261., 44., 11., 148., 17., 49., 6., 0., 2., 16., 10., 80., 18., 90., 21., 36., 40., 13., 1., 0., 30., 6., 30., 7., 54., 11., 35., 6., 7., 9., 0., 0., 1., 0., 19., 3., 15., 3., 30., 4., 12., 4., 2., 2., 3., 2., 3., 0., 14., 3., 10., 0., 9., 2., 0., 4., 133., 8., 1846., 89., 116., 211., 99., 113., 72., 19., 16., 26., 9., 0., 1., 9., 5., 6., 7., 2., 41., 15., 30., 15., 37., 1., 11., 3., 4., 7., 9., 2., 2., 3., 8., 1., 0., 5., 5., 11., 2., 0., 9., 3., 1., 0., 4., 3., 3., 33., 2., 14., 2., 8., 1., 27., 2., 3., 1., 5., 30., 7., 23., 4., 4., 6., 7., 49., 7., 10., 6.,

12., 1., 3., 4., 6., 2., 6., 4., 4., 23., 0., 8., 29., 2., 11., 1., 3., 4., 19., 3., 3., 21., 10., 28., 22., 5., 0., 2., 4., 2., 5., 5., 26., 14., 1., 14., 4., 14., 10., 1., 1., 3., 2., 5., 12., 15., 54., 10., 25., 10., 9., 2., 3., 2., 6., 2., 14., 12., 9., 10., 8., 22., 10., 2., 0., 1., 6., 2., 3., 3., 2., 3., 6., 1., 2., 2., 0., 2., 0., 2., 2., 0., 2., 2., 2., 10., 3., 3., 0., 2., 7., 2., 4., 0., 0., 6., 4., 0., 2., 2., 2., 1., 4., 8., 3., 1., 0., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 1., 3., 7., 1., 7., 1., 11., 31., 1., 8., 25., 1., 10., 1., 2., 1., 20., 2., 9., 29., 13., 29., 39., 11., 2., 2., 5., 0., 4., 7., 32., 18., 4., 18., 1., 13., 6., 4., 0., 2., 0., 5., 11., 20., 46., 9., 20., 6., 8., 1., 8., 3., 5., 3., 14., 9., 10., 24., 7., 17., 7., 3., 1., 1., 3., 1., 3., 2., 6., 1., 5., 6., 2., 0., 0., 2., 3., 3., 0., 0., 3., 1., 1., 5., 5., 3., 2., 7., 2., 0., 1., 0., 3., 11., 3., 0., 2., 3., 2., 2., 2., 2., 2., 0., 0., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 6., 7., 3., 11., 0., 6., 29., 2., 8., 21., 0., 18., 5., 0., 3., 13., 3., 2., 31., 6., 22., 21., 5., 1., 0., 3., 1., 4., 5., 31., 14., 3., 10., 4., 10., 9., 2., 1., 7., 3., 14., 8., 17., 54., 5., 23., 12., 4., 0., 8., 1., 7., 3., 7., 9., 11., 19., 9., 25., 7., 3., 2., 0., 6., 0., 7., 2., 10., 3., 3., 4., 1., 5., 5., 1., 3., 3., 2., 0., 2., 1., 2., 3., 2., 4., 3., 3., 3., 0., 2., 1., 3., 7., 3., 0., 2., 5., 0., 0., 1., 3., 3., 2., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 0., 4., 5., 8., 4., 4., 2., 9., 20., 0., 13., 24., 0., 25., 6., 3., 2., 20., 4., 6., 16., 11., 31., 31., 5., 1., 0., 6., 1., 14., 7., 28., 16., 1., 18., 3., 18., 3., 3., 0., 0., 3., 18., 8., 16., 43., 18., 19., 8., 5., 1., 4., 4., 12., 2., 5., 7., 15., 16., 8., 18., 7., 1., 0., 2., 4., 2., 4., 3., 5., 7., 3., 6., 1., 2., 2., 0., 1., 8., 3., 0., 3., 2., 3., 4., 0., 2., 2., 2., 6., 1., 4., 2., 1., 10., 0., 0., 3., 1., 4., 0., 2., 2., 0., 0., 3., 0., 0., 0., 0., 1., 0., 0., 7., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 6., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 1., 6., 3., 4., 2., 5., 13., 0., 9., 19., 0., 7., 1., 0., 3., 26., 1., 2., 24., 12., 25., 24., 7., 4., 0., 1., 3., 7., 9., 35., 11., 2., 23., 3., 17., 8., 3., 0., 7., 0., 11., 13., 16., 40., 11., 25., 9., 5., 0., 6., 2., 5., 3., 14., 7., 10., 16., 8., 18., 6., 5., 2., 4., 7., 1., 2., 1., 6., 4., 3., 4., 1., 5., 4., 1., 3., 5., 5., 0., 1., 0., 1., 5., 2., 4., 4., 0., 2., 0., 6., 1., 2., 12., 1., 0., 1., 2., 2., 3., 2., 1., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 0., 3., 11., 3., 6., 0., 7., 13., 1., 12., 19., 0., 22., 3., 1., 0., 31., 3., 6., 20., 10., 22., 21., 4., 0., 2., 0., 5., 5., 4., 27., 16., 7., 25., 3., 14., 10., 4., 5., 5., 2., 7., 6., 24., 48., 14., 15., 15., 4., 0., 8., 3., 2., 2., 11., 4., 11., 14., 5., 20., 11., 5., 1., 0., 10., 2., 2., 2., 3., 1., 9., 1., 2., 5., 4., 1., 0., 4., 1., 0., 0., 2., 1., 9., 0., 5., 1., 4., 9., 0., 1., 0., 0., 4., 2., 0., 4., 1., 4., 2., 1., 1., 1., 2., 3., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 2., 3., 12., 1., 6., 1., 4., 30., 1., 11., 25., 3., 9., 2., 0., 2., 22., 3., 2., 19., 14., 10., 27., 7., 1., 0., 1., 1., 4., 6., 28., 17., 2., 15., 4., 10., 7., 4., 1., 3., 0., 9., 3., 17., 42., 18., 20., 10., 5., 0., 3., 4., 9., 1., 4., 7., 8., 15., 6., 19., 10., 0., 1., 0., 2., 1., 2., 1., 2., 3., 3., 2., 2., 1., 4., 2., 1., 4., 2., 0., 3., 3., 1., 4., 3., 1., 0., 0., 4., 0., 1., 1., 2., 5., 2., 0., 2., 3., 0., 4., 3., 4., 2., 2., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

0., 3., 3., 7., 11., 1., 5., 1., 7., 8., 0., 15., 24., 0., 14., 2., 0., 1., 20., 2., 6., 31., 12., 23., 21., 5., 2., 0., 3., 4., 18., 6., 17., 16., 6., 13., 2., 12., 7., 0., 1., 4., 2., 18., 7., 16., 45., 11., 20., 15., 3., 0., 5., 2., 6., 3., 16., 5., 9., 19., 3., 23., 5., 5., 0., 1., 8., 3., 3., 4., 7., 2., 6., 4., 1., 2., 4., 1., 0., 4., 2., 0., 2., 5., 2., 6., 0., 3., 0., 2., 5., 2., 1., 1., 2., 7., 0., 0., 2., 2., 2., 1., 0., 4., 1., 1., 1., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 4., 1., 2., 3., 5., 1., 4., 11., 5., 15., 24., 1., 12., 3., 1., 1., 10., 4., 2., 14., 19., 39., 25., 8., 2., 1., 3., 3., 5., 6., 32., 11., 3., 19., 5., 6., 7., 3., 1., 4., 1., 11., 10., 15., 42., 7., 26., 6., 2., 1., 4., 3., 4., 3., 10., 5., 5., 16., 9., 19., 7., 0., 0., 1., 8., 0., 4., 0., 2., 3., 1., 1., 4., 0., 1., 3., 0., 3., 1., 0., 3., 2., 1., 7., 0., 0., 1., 1., 3., 1., 0., 0., 2., 9., 1., 0., 1., 1., 6., 3., 4., 2., 3., 0., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 2., 0., 5., 5., 3., 6., 4., 7., 25., 1., 11., 16., 1., 18., 4., 3., 3., 18., 4., 6., 14., 11., 37., 27., 4., 1., 1., 3., 5., 7., 11., 14., 22., 6., 17., 1., 11., 8., 2., 1., 3., 2., 8., 16., 12., 43., 10., 18., 12., 8., 2., 3., 1., 8., 3., 4., 4., 11., 19., 6., 18., 9., 4., 2., 0., 6., 0., 4., 1., 6., 2., 5., 6., 3., 5., 3., 2., 2., 1., 2., 0., 0., 0., 2., 5., 2., 6., 2., 2., 2., 0., 2., 1., 2., 2., 1., 0., 1., 3., 0., 3., 3., 5., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 0., 4., 11., 4., 10., 1., 10., 11., 1., 14., 28., 0., 10., 6., 0., 3., 19., 3., 2., 13., 13., 27., 28., 6., 1., 1., 1., 3., 7., 9., 20., 13., 1., 13., 5., 12., 11., 1., 0., 3., 3., 13., 10., 14., 50., 18., 20., 10., 4., 0., 5., 4., 8., 2., 8., 6., 8., 15., 6., 22., 7., 5., 0., 2., 6., 0., 1., 1., 0., 5., 5., 4., 0., 7., 3., 1., 2., 3., 0., 0., 3., 1., 2., 7., 0., 3., 3., 2., 6., 1., 2., 1., 4., 4., 4., 0., 0., 1., 0., 0., 2., 4., 1., 1., 4., 0., 0., 0., 0., 1., 0., 0., 5., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 4., 3., 6., 4., 5., 0., 5., 24., 0., 15., 17., 1., 14., 3., 1., 1., 16., 2., 3., 20., 10., 29., 29., 2., 0., 1., 3., 4., 7., 5., 15., 19., 2., 12., 5., 16., 5., 2., 0., 2., 5., 8., 10., 25., 52., 11., 17., 8., 6., 2., 4., 3., 6., 1., 12., 9., 8., 8., 8., 14., 4., 2., 1., 1., 8., 1., 3., 1., 5., 2., 5., 3., 0., 2., 3., 2., 0., 2., 1., 0., 1., 3., 2., 7., 4., 2., 2., 1., 5., 1., 2., 0., 2., 10., 3., 0., 3., 2., 2., 3., 1., 3., 3., 1., 1., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 4., 8., 3., 2., 1., 9., 34., 0., 17., 26., 2., 19., 1., 0., 2., 16., 3., 5., 35., 14., 31., 30., 6., 2., 1., 2., 3., 6., 4., 35., 15., 2., 17., 1., 14., 12., 1., 1., 4., 3., 16., 13., 18., 54., 9., 25., 10., 3., 0., 10., 4., 7., 2., 6., 10., 7., 20., 11., 13., 14., 7., 1., 0., 2., 0., 2., 2., 5., 2., 5., 5., 3., 2., 4., 0., 0., 0., 1., 0., 1., 0., 1., 8., 1., 2., 6., 1., 2., 2., 2., 1., 1., 8., 2., 0., 1., 0., 1., 2., 5., 2., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 5., 0., 0., 0., 4., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 1., 5., 12., 2., 1., 1., 6., 32., 0., 14., 15., 1., 15., 4., 0., 1., 11., 3., 4., 18., 17., 26., 24., 9., 1., 1., 0., 3., 9., 9., 29., 15., 2., 12., 6., 17., 9., 1., 2., 5., 1., 9., 14., 21., 47., 12., 24., 10., 8., 0., 8., 4., 13., 0., 8., 7., 8., 15., 4., 21., 8., 1., 0., 1., 9., 3., 5., 2., 4., 5., 1., 4., 0., 6., 4., 4., 0., 3., 3., 0., 4., 1., 4., 4., 4., 2., 3., 4., 2., 1., 1., 1., 3., 4., 2., 0., 2., 3., 2., 2., 3., 2., 2., 0., 0., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 0., 4., 13., 5., 14., 0., 6., 16., 0., 10., 24., 0., 18., 0., 1., 1., 8., 0., 8., 27., 13., 10., 23., 4., 3., 1., 1., 3., 7., 11., 28., 19., 5., 20., 3., 14., 8., 1., 1., 4., 3., 10., 3., 15., 40., 10., 23., 13., 7., 2., 4., 0., 8., 3., 8., 6., 9., 13., 4., 19., 5., 1., 1., 1., 5., 0., 3., 1., 3., 2., 5., 1., 0., 5., 7., 5., 1., 1., 1., 0., 5., 2., 1., 3., 1., 1., 1., 2., 5., 1., 4., 1., 1., 6., 1., 0., 0., 1., 3., 0., 1., 6., 1., 1., 4., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 4., 6., 10., 7., 5., 1., 8., 19., 1., 11., 29., 1., 14., 2., 3., 3., 17., 4., 3., 23., 17., 30., 27., 4., 1., 1., 4., 4., 10., 6., 21., 10., 4., 17., 3., 18., 9., 1., 2., 4., 3., 20., 14., 19., 36., 11., 21., 8., 6., 1., 4., 3., 8., 2., 10., 8., 9., 17., 8., 16., 13., 4., 0., 1., 8., 3., 3., 1., 7., 0., 9., 5., 0., 4., 6., 2., 0., 1., 2., 0., 2., 0., 1., 4., 1., 2., 2., 0., 2., 1., 1., 0., 3., 8., 0., 0., 2., 0., 3., 0., 1., 1., 3., 1., 2., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 2., 8., 2., 7., 0., 5., 21., 3., 8., 19., 3., 20., 3., 2., 1., 18., 1., 2., 36., 10., 19., 29., 12., 1., 1., 4., 2., 3., 7., 15., 19., 5., 17., 3., 7., 9., 0., 1., 4., 1., 15., 17., 20., 50., 17., 18., 2., 4., 1., 10., 0., 3., 2., 12., 5., 8., 12., 2., 15., 6., 5., 2., 0., 12., 1., 7., 2., 9., 2., 1., 4., 3., 5., 2., 0., 1., 2., 0., 0., 1., 1., 1., 6., 1., 0., 1., 5., 2., 0., 2., 0., 1., 5., 0., 0., 1., 3., 2., 2., 2., 1., 1., 2., 2., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 3., 4., 12., 0., 16., 3., 5., 42., 2., 6., 55., 1., 3., 3., 0., 1., 67., 8., 14., 79., 16., 87., 7., 5., 0., 0., 5., 4., 6., 10., 48., 15., 0., 30., 35., 13., 7., 0., 0., 7., 4., 22., 6., 21., 6., 7., 4., 5., 1., 0., 11., 9., 20., 9., 11., 7., 7., 3., 2., 32., 6., 12., 3., 0., 11., 1., 8., 1., 13., 1., 6., 3., 2., 1., 0., 7., 1., 18., 13., 4., 4., 0., 2., 0., 0., 0., 0., 0., 15., 3., 6., 1., 2., 2., 1., 0., 0., 0., 1., 0., 2., 6., 2., 0., 5., 0., 2., 0., 2., 0., 0., 0., 1., 0., 6., 3., 3., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 18., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 2., 6., 16., 0., 15., 3., 6., 51., 0., 12., 58., 3., 1., 0., 0., 0., 52., 5., 8., 74., 11., 74., 11., 2., 0., 1., 3., 3., 10., 9., 39., 11., 0., 35., 36., 20., 4., 0., 2., 3., 2., 18., 10., 17., 6., 16., 14., 3., 1., 0., 10., 4., 19., 6., 15., 3., 9., 3., 1., 42., 8., 6., 2., 0., 22., 5., 8., 2., 17., 1., 6., 2., 1., 1., 0., 7., 4., 12., 10., 0., 6., 1., 1., 0., 0., 0., 0., 0., 9., 4., 4., 0., 5., 1., 1., 0., 2., 0., 1., 0., 0., 3., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 1., 0., 6., 2., 2., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 22., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 1., 4., 7., 0., 14., 1., 3., 48., 3., 6., 59., 2., 6., 3., 0., 1., 82., 12., 7., 62., 12., 70., 16., 1., 0., 2., 3., 2., 12., 5., 66., 4., 1., 36., 28., 15., 5., 0., 2., 4., 2., 23., 5., 27., 6., 15., 6., 1., 8., 0., 13., 1., 13., 6., 29., 3., 7., 2., 2., 34., 8., 6., 4., 0., 17., 4., 7., 0., 13., 3., 1., 1., 1., 2., 0., 11., 1., 13., 6., 7., 10., 0., 2., 0., 0., 0., 0., 0., 4., 2., 6., 1., 3., 2., 1., 0., 1., 0., 1., 0., 0., 3., 4., 0., 4., 0., 1., 0., 0., 0., 0., 0., 2., 0., 2., 4., 2., 0., 0., 0., 3., 0., 4., 0., 0., 0., 0., 23., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 3., 6., 8., 0., 14., 0., 5., 38., 1., 4., 59., 2., 9., 3., 0., 1., 78., 9., 11., 76., 11., 76., 8., 3., 0., 0., 4., 2., 9., 6., 61., 11., 1., 43., 37., 17., 8., 0., 0., 8., 2., 26., 5., 26., 10., 11., 2., 5., 3., 0., 10., 1., 6., 3., 20., 2., 12., 4., 1., 34., 9., 4., 4., 0., 10., 6., 9., 2., 13., 0., 5., 0., 1., 2., 0., 4., 4., 25., 6., 8., 4., 1., 1., 0., 0., 0., 0., 0., 10., 6., 7., 4., 1., 3., 0., 0., 2., 0., 2., 0., 1., 4., 0., 0., 1., 0., 1., 0., 1., 0., 0., 0., 3., 0., 1., 3., 3., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 17., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 2., 4., 7., 7., 0., 10., 2., 8., 49., 0., 7., 58., 1., 8., 2., 0., 2., 72., 14., 6., 65., 13., 66., 10., 3., 0., 1., 2., 0., 4., 8., 62., 10., 4., 38., 35., 17., 4., 0., 1., 4., 4., 22., 3., 21., 4., 14., 5., 1., 3., 0., 7., 2., 23., 3., 12., 1., 10., 1., 4., 34., 2., 5., 3., 0., 11., 0., 8., 1., 10., 3., 6., 1., 1., 1., 0., 6., 1., 20., 9., 6., 5., 2., 2., 0., 0., 0., 0., 0., 7., 0., 4., 1., 4., 1., 1., 0., 2., 0., 1., 0., 0., 5., 4., 0., 4., 0., 1., 0., 1., 0., 0., 0., 0., 0., 2., 4., 2., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 25., 0., 4., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 2., 4., 3., 14., 0., 10., 3., 10., 57., 0., 10., 56., 0., 6., 0., 0., 3., 70., 7., 11., 76., 9., 85., 16., 4., 0., 2., 2., 2., 12., 8., 40., 12., 3., 40., 33., 15., 6., 0., 0., 5., 3., 30., 5., 24., 6., 9., 7., 3., 0., 0., 10., 10., 19., 7., 12., 4., 9., 5., 4., 31., 6., 10., 2., 0., 12., 7., 5., 0., 7., 2., 4., 0., 2., 1., 0., 7., 3., 20., 6., 3., 1., 1., 2., 0., 0., 0., 0., 0., 12., 1., 2., 1., 5., 1., 2., 0., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 3., 3., 0., 0., 0., 2., 0., 6., 0., 0., 0., 0., 27., 0., 5., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 1., 6., 9., 0., 19., 4., 5., 49., 2., 9., 60., 2., 5., 1., 0., 2., 54., 12., 6., 73., 14., 75., 16., 4., 0., 0., 3., 1., 12., 10., 37., 18., 1., 43., 28., 11., 5., 0., 0., 4., 1., 21., 0., 33., 5., 13., 9., 6., 2., 0., 10., 5., 18., 10., 10., 3., 12., 1., 5., 47., 11., 8., 4., 0., 11., 4., 6., 3., 7., 1., 6., 1., 1., 1., 0., 5., 1., 18., 14., 0., 3., 1., 2., 0., 0., 0., 0., 0., 13., 0., 4., 2., 3., 0., 1., 0., 0., 0., 2., 0., 2., 2., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 0., 5., 3., 1., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 22., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 1., 7., 5., 0., 13., 3., 10., 66., 0., 4., 46., 0., 3., 0., 0., 1., 68., 10., 11., 71., 22., 96., 5., 0., 0., 4., 8., 1., 13., 3., 46., 14., 3., 42., 34., 16., 8., 0., 1., 6., 6., 21., 5., 24., 5., 17., 4., 4., 1., 0., 11., 6., 8., 5., 23., 3., 8., 0., 2., 37., 2., 12., 1., 0., 17., 9., 13., 1., 10., 5., 3., 0., 0., 0., 0., 9., 3., 13., 9., 6., 4., 4., 3., 0., 0., 0., 0., 0., 13., 2., 1., 1., 3., 2., 1., 0., 1., 0., 0., 0., 1., 3., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 4., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 25., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 8., 11., 0., 10., 2., 5., 42., 2., 6., 62., 0., 7., 2., 0., 3., 77., 13., 10., 88., 13., 82., 12., 7., 0., 1., 0., 1., 18., 5., 53., 13., 2., 38., 27., 13., 3., 0., 1., 4., 7., 28., 7., 21., 6., 16., 11., 3., 0., 0., 11., 1., 14., 7., 18., 1., 2., 3., 2., 28., 7., 11., 3., 0., 14., 1., 14., 5., 11., 2., 5., 0., 3., 1., 0., 3., 5., 12., 8., 2., 6., 3., 6., 0., 0., 0., 0., 0., 9., 1., 0., 2., 1., 1., 0., 0., 1., 0., 3., 0., 0., 2., 1., 0., 2., 0., 1., 0., 0., 0., 0., 0., 2., 0., 2., 2., 2., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 28., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 1., 0., 4., 14., 0., 11., 2., 5., 66., 1., 11., 53., 1., 6., 2., 0., 2., 64., 8., 4., 78., 12., 97., 12., 5., 0., 2., 4., 1., 11., 13., 59., 15., 1., 33., 24., 11., 1., 0., 0., 3., 2., 32., 7., 33., 8., 12., 8., 2., 0., 0., 7., 5., 10., 5., 16., 8., 11., 3., 2., 34., 6., 5., 1., 0., 15., 4., 10., 1., 4., 0., 6., 1., 2., 0., 0., 2., 3., 14., 13., 4., 3., 0., 2., 0., 0., 0., 0., 0., 6., 1., 2., 2., 3., 0., 0., 0., 0., 0., 1., 0., 1., 3., 1., 0., 3., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 1., 2., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 31., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 0., 7., 16., 0., 12., 1., 5., 64., 0., 8., 61., 0., 3., 1., 0., 1., 61., 13., 12., 69., 11., 86., 14., 3., 0., 2., 4., 1., 20., 10., 41., 11., 3., 41., 37., 16., 7., 0., 2., 6., 2., 21., 4., 16., 8., 8., 8., 7., 3., 0., 9., 2., 17., 3., 18., 5., 7., 5., 3., 37., 10., 7., 4., 0., 13., 0., 11., 3., 11., 0., 5., 4., 1., 1., 0., 6., 2., 10., 11., 2., 2., 0., 3., 0., 0., 0., 0., 0., 8., 2., 1., 2., 3., 2., 0., 0., 0., 0., 1., 0., 2., 5., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 2., 0., 1., 3., 2., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 26., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 4., 4., 15., 0., 15., 2., 9., 61., 1., 9., 62., 1., 3., 2., 0., 1., 89., 7., 12., 72., 13., 89., 6., 7., 0., 1., 4., 4., 20., 7., 56., 11., 2., 31., 45., 10., 3., 0., 1., 7., 4., 27., 8., 25., 13., 12., 4., 4., 0., 0., 11., 3., 23., 1., 22., 7., 10., 2., 2., 29., 14., 9., 4., 0., 13., 2., 7., 2., 5., 2., 3., 1., 0., 2., 0., 2., 2., 15., 13., 4., 6., 1., 2., 0., 0., 0., 0., 0., 13., 0., 2., 4., 2., 0., 1., 0., 2., 0., 1., 0., 0., 2., 2., 0., 1., 0., 3., 0., 1., 0., 0., 0., 0., 0., 1., 2., 3., 0., 0., 0., 3., 0., 5., 0., 0., 0., 0., 21., 0., 2., 0., 8., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 2., 1., 11., 0., 20., 3., 4., 47., 0., 10., 66., 1., 4., 2., 0., 0., 80., 4., 9., 99., 11., 71., 19., 4., 0., 0., 1., 3., 12., 8., 53., 10., 1., 33., 24., 16., 5., 0., 2., 4., 1., 25., 3., 26., 4., 6., 0., 1., 5., 0., 7., 2., 19., 3., 11., 2., 11., 1., 2., 30., 7., 7., 1., 0., 14., 1., 10., 1., 11., 0., 4., 1., 0., 1., 0., 6., 1., 13., 6., 2., 4., 1., 4., 0., 0., 0., 0., 0., 3., 1., 4., 0., 1., 3., 2., 0., 0., 0., 2., 0., 0., 4., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 3., 0., 0., 0., 4., 0., 4., 0., 0., 0., 0., 25., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 1., 2., 3., 10., 0., 16., 3., 9., 49., 2., 8., 57., 1., 2., 3., 0., 1., 77., 7., 8., 77., 9., 85., 10., 4., 0., 0., 2., 5., 21., 10., 48., 8., 3., 43., 35., 17., 8., 0., 0., 10., 2., 23., 9., 24., 6., 11., 7., 5., 4., 0., 7., 4., 15., 1., 18., 4., 12., 1., 2., 34., 9., 8., 2., 0., 15., 2., 15., 0., 10., 4., 5., 0., 3., 1., 0., 2., 2., 19., 5., 5., 4., 1., 3., 0., 0., 0., 0., 0., 8., 1., 3., 1., 3., 0., 0., 0., 2., 0., 4., 0., 1., 3., 2., 0., 1., 0., 0., 0., 2., 0., 0., 0., 3., 0., 5., 1., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 15., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 7., 16., 1., 6., 1., 9., 28., 0., 8., 20., 3., 10., 6., 1., 3., 10., 5., 4., 19., 12., 22., 32., 1., 1., 2., 1., 4., 10., 8., 23., 15., 2., 8., 4., 15., 8., 0., 2., 3., 4., 11., 5., 19., 45., 11., 20., 8., 6., 3., 7., 5., 10., 2., 9., 3., 3., 17., 12., 16., 7., 2., 0., 0., 5., 3., 5., 2., 2., 1., 4., 0., 1., 8., 3., 1., 0., 1., 4., 0., 2., 3., 5., 3., 1., 4., 3., 1., 5., 0., 4., 1., 4., 13., 2., 0., 0., 1., 4., 1., 1., 4., 1., 4., 3., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 2., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 2., 5., 9., 4., 4., 1., 13., 24., 1., 6., 12., 2., 11., 2., 2., 0., 20., 2., 5., 12., 6., 30., 25., 6., 0., 0., 6., 0., 10., 9., 29., 15., 3., 13., 2., 16., 14., 1., 0., 3., 1., 11., 12., 27., 47., 25., 25., 12., 4., 0., 4., 2., 9., 1., 5., 11., 3., 16., 8., 18., 17., 3., 0., 1., 1., 0., 3., 2., 8., 4., 7., 3., 3., 4., 1., 3., 1., 1., 2., 0., 1., 2., 4., 7., 2., 5., 2., 0., 4., 2., 2., 2., 1., 9., 1., 0., 0., 0., 0., 2., 2., 0., 3., 1., 4., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 3., 9., 5., 5., 1., 1., 37., 1., 13., 28., 0., 17., 5., 2., 4., 23., 1., 6., 28., 14., 32., 22., 6., 3., 0., 3., 4., 5., 5., 24., 17., 5., 22., 7., 10., 12., 3., 1., 1., 3., 12., 8., 18., 39., 12., 25., 7., 2., 0., 5., 0., 14., 3., 8., 8., 16., 12., 1., 26., 9., 2., 1., 2., 7., 1., 3., 4., 3., 2., 1., 5., 4., 3., 3., 3., 1., 1., 3., 0., 1., 2., 0., 5., 2., 2., 3., 1., 4., 0., 2., 2., 2., 11., 0., 0., 3., 3., 3., 2., 2., 2., 1., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 2., 1., 10., 3., 4., 0., 12., 26., 1., 18., 16., 0., 12., 0., 2., 1., 19., 2., 6., 27., 14., 14., 31., 8., 2., 0., 4., 4., 10., 5., 33., 19., 3., 20., 4., 14., 8., 2., 4., 5., 1., 17., 13., 10., 36., 17., 21., 4., 3., 1., 6., 2., 4., 2., 13., 4., 10., 7., 5., 18., 7., 2., 1., 0., 8., 0., 7., 1., 8., 2., 6., 5., 3., 2., 2., 2., 2., 0., 2., 0., 3., 2., 1., 5., 3., 4., 2., 2., 4., 4., 1., 1., 0., 9., 3., 0., 3., 2., 2., 1., 1., 2., 4., 1., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 5., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 3., 7., 5., 9., 0., 7., 20., 1., 12., 21., 0., 16., 3., 1., 5., 19., 1., 8., 35., 12., 26., 34., 6., 2., 3., 2., 3., 5., 2., 28., 20., 4., 15., 6., 15., 7., 3., 0., 4., 0., 13., 7., 22., 34., 13., 18., 6., 7., 0., 6., 1., 3., 1., 8., 7., 10., 19., 6., 9., 5., 2., 1., 0., 5., 2., 2., 2., 5., 1., 3., 5., 5., 2., 4., 4., 2., 3., 2., 0., 3., 4., 0., 5., 1., 1., 2., 1., 3., 1., 1., 1., 3., 6., 3., 0., 2., 1., 2., 2., 1., 3., 2., 2., 2., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 5., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 3., 8., 3., 4., 9., 2., 8., 23., 0., 10., 16., 2., 12., 3., 1., 2., 16., 0., 6., 23., 14., 27., 18., 3., 0., 1., 7., 2., 5., 4., 39., 18., 2., 14., 4., 13., 5., 3., 2., 4., 3., 8., 7., 13., 56., 6., 26., 4., 2., 2., 2., 2., 11., 6., 13., 3., 10., 15., 2., 25., 10., 2., 1., 0., 2., 3., 5., 1., 5., 3., 2., 3., 2., 4., 2., 0., 1., 2., 5., 0., 1., 3., 2., 4., 2., 0., 3., 0., 2., 0., 2., 0., 1., 5., 1., 0., 1., 2., 1., 3., 1., 1., 0., 3., 2., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 2., 3., 12., 4., 7., 1., 3., 15., 1., 17., 13., 1., 11., 1., 1., 1., 21., 3., 6., 15., 11., 20., 29., 8., 2., 0., 3., 3., 10., 7., 14., 14., 3., 15., 6., 10., 12., 0., 1., 3., 0., 16., 11., 19., 50., 14., 26., 13., 2., 0., 3., 0., 2., 0., 10., 9., 7., 18., 5., 26., 9., 7., 1., 1., 9., 1., 6., 3., 5., 5., 5., 6., 1., 3., 6., 1., 0., 4., 5., 0., 0., 3., 1., 8., 3., 2., 2., 3., 4., 2., 1., 3., 1., 10., 4., 0., 1., 4., 1., 4., 1., 2., 2., 0., 4., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 2., 6., 6., 4., 1., 6., 28., 0., 9., 23., 0., 16., 5., 0., 3., 19., 0., 1., 20., 13., 22., 22., 7., 1., 0., 4., 3., 5., 11., 33., 18., 7., 26., 5., 13., 4., 1., 1., 6., 1., 20., 8., 17., 50., 8., 22., 11., 9., 0., 7., 3., 4., 3., 12., 9., 6., 14., 5., 22., 6., 5., 1., 1., 12., 3., 7., 1., 3., 4., 6., 5., 0., 3., 7., 1., 3., 4., 5., 0., 3., 2., 4., 10., 4., 4., 3., 1., 3., 0., 3., 0., 4., 3., 5., 0., 1., 4., 3., 7., 3., 2., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 4., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 5., 3., 5., 0., 6., 0., 4., 31., 0., 13., 27., 1., 11., 3., 0., 3., 25., 2., 3., 13., 16., 25., 25., 6., 0., 1., 6., 2., 10., 3., 25., 9., 1., 9., 4., 13., 4., 1., 1., 5., 2., 13., 9., 8., 41., 12., 18., 9., 7., 0., 2., 4., 7., 3., 5., 7., 15., 16., 11., 26., 10., 2., 0., 0., 2., 1., 2., 4., 6., 1., 3., 7., 3., 1., 4., 4., 1., 0., 2., 0., 3., 1., 0., 0., 0., 4., 3., 3., 1., 0., 1., 0., 3., 7., 0., 0., 1., 2., 1., 2., 4., 1., 1., 0., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 0., 2., 7., 0., 10., 1., 11., 20., 2., 9., 10., 0., 8., 3., 2., 0., 24., 1., 2., 21., 6., 19., 16., 10., 0., 0., 2., 1., 8., 10., 20., 14., 2., 11., 7., 12., 10., 5., 0., 1., 4., 10., 12., 22., 36., 10., 11., 8., 6., 1., 5., 1., 10., 5., 5., 3., 10., 16., 3., 19., 12., 1., 2., 1., 4., 0., 2., 2., 8., 0., 5., 4., 1., 6., 4., 1., 0., 2., 2., 0., 3., 4., 3., 6., 2., 2., 1., 2., 3., 0., 2., 1., 1., 9., 2., 0., 2., 1., 1., 1., 1., 1., 0., 0., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 9., 4., 4., 4., 1., 4., 31., 0., 9., 26., 1., 16., 1., 1., 3., 27., 3., 4., 31., 19., 17., 25., 6., 3., 2., 6., 2., 8., 3., 38., 19., 4., 20., 4., 20., 7., 1., 1., 5., 0., 12., 8., 20., 46., 11., 20., 12., 4., 1., 6., 1., 4., 0., 16., 10., 11., 15., 11., 22., 5., 3., 1., 2., 7., 0., 1., 2., 8., 2., 5., 5., 2., 1., 3., 1., 0., 2., 0., 0., 1., 2., 1., 2., 2., 5., 3., 3., 4., 1., 5., 0., 3., 10., 1., 0., 0., 5., 0., 6., 2., 3., 3., 2., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 3., 10., 3., 6., 1., 6., 14., 2., 11., 19., 0., 11., 4., 0., 2., 22., 3., 4., 22., 15., 28., 26., 5., 3., 2., 3., 1., 6., 6., 29., 15., 5., 19., 3., 15., 8., 1., 1., 4., 0., 9., 14., 13., 53., 12., 14., 7., 4., 1., 2., 3., 8., 1., 10., 8., 9., 15., 4., 23., 5., 3., 0., 2., 2., 0., 2., 2., 8., 1., 7., 8., 2., 2., 2., 4., 0., 2., 0., 0., 2., 3., 5., 5., 1., 3., 0., 4., 7., 1., 2., 2., 3., 6., 2., 0., 1., 2., 1., 3., 3., 0., 2., 0., 3., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 3., 8., 4., 3., 0., 7., 19., 0., 16., 29., 0., 14., 4., 2., 0., 30., 4., 1., 32., 20., 34., 26., 8., 1., 0., 4., 1., 7., 7., 40., 19., 3., 16., 2., 21., 20., 2., 1., 5., 1., 15., 8., 22., 52., 12., 33., 12., 3., 0., 4., 3., 6., 2., 13., 1., 9., 25., 6., 16., 8., 2., 1., 0., 5., 1., 4., 2., 6., 4., 5., 5., 2., 2., 0., 2., 2., 0., 2., 0., 2., 2., 0., 4., 4., 6., 0., 0., 4., 0., 6., 0., 1., 3., 3., 0., 3., 2., 2., 1., 2., 2., 1., 1., 3., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 1., 3., 5., 3., 6., 0., 8., 6., 1., 16., 22., 0., 19., 3., 0., 4., 24., 4., 2., 29., 14., 29., 23., 11., 2., 3., 6., 2., 5., 13., 21., 7., 1., 11., 5., 20., 4., 3., 1., 6., 2., 7., 9., 12., 37., 10., 26., 7., 7., 0., 7., 3., 6., 2., 10., 9., 7., 12., 10., 17., 5., 2., 1., 1., 7., 3., 4., 4., 7., 5., 2., 3., 0., 3., 5., 2., 0., 3., 1., 0., 3., 2., 1., 5., 2., 2., 2., 4., 4., 0., 3., 2., 3., 6., 0., 0., 4., 0., 2., 3., 2., 5., 3., 1., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 3., 2., 5., 9., 3., 7., 3., 6., 25., 1., 18., 22., 1., 20., 0., 2., 2., 20., 2., 6., 18., 10., 27., 33., 6., 1., 1., 3., 1., 4., 12., 45., 16., 3., 20., 2., 11., 10., 1., 1., 4., 3., 10., 16., 15., 41., 10., 20., 13., 3., 3., 6., 0., 7., 1., 5., 6., 5., 11., 8., 21., 4., 4., 0., 1., 7., 0., 1., 2., 7., 1., 5., 6., 4., 5., 0., 1., 0., 3., 1., 0., 2., 0., 2., 5., 3., 7., 0., 1., 4., 1., 1., 0., 4., 11., 4., 0., 2., 2., 1., 6., 1., 1., 4., 3., 1., 0., 0., 0., 0., 3., 0., 0., 3., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 2., 1., 17., 0., 6., 0., 5., 25., 1., 9., 28., 3., 13., 2., 2., 3., 22., 1., 2., 23., 10., 16., 32., 4., 1., 1., 4., 3., 9., 6., 23., 18., 4., 19., 1., 15., 6., 1., 2., 5., 2., 15., 6., 22., 35., 14., 16., 10., 3., 0., 7., 1., 8., 5., 9., 4., 11., 22., 6., 18., 7., 3., 1., 0., 6., 2., 3., 2., 6., 5., 4., 4., 5., 1., 6., 1., 0., 1., 0., 0., 0., 1., 0., 6., 0., 5., 2., 3., 3., 1., 1., 1., 3., 3., 3., 0., 2., 3., 2., 1., 1., 3., 2., 3., 8., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 4., 10., 2., 8., 0., 4., 13., 1., 14., 22., 2., 20., 2., 1., 2., 22., 1., 10., 33., 13., 22., 26., 9., 0., 1., 4., 2., 8., 8., 32., 13., 3., 17., 4., 13., 7., 5., 0., 3., 0., 15., 10., 13., 50., 15., 15., 8., 6., 1., 6., 2., 8., 3., 6., 3., 6., 11., 4., 25., 3., 0., 2., 3., 9., 4., 2., 2., 6., 3., 5., 1., 2., 1., 5., 3., 1., 3., 1., 0., 3., 0., 1., 8., 2., 2., 4., 6., 1., 1., 4., 0., 2., 7., 2., 0., 2., 1., 1., 1., 0., 2., 4., 1., 1., 0., 0., 0., 0., 4., 0., 0., 5., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 1., 6., 9., 0., 26., 0., 1., 36., 2., 8., 54., 0., 7., 3., 0., 3., 75., 9., 8., 68., 10., 86., 16., 4., 0., 1., 5., 2., 14., 10., 59., 10., 2., 33., 34., 22., 7., 0., 1., 5., 5., 15., 2., 28., 7., 14., 10., 1., 1., 0., 10., 3., 15., 2., 19., 4., 5., 2., 4., 33., 9., 7., 0., 0., 20., 3., 14., 4., 9., 1., 3., 1., 0., 1., 0., 3., 1., 17., 9., 3., 6., 1., 3., 0., 0., 0., 0., 0., 9., 2., 1., 3., 0., 0., 2., 0., 2., 0., 3., 0., 0., 1., 1., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 1., 4., 0., 0., 0., 4., 0., 5., 0., 0., 0., 0., 30., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 3., 10., 0., 9., 0., 2., 40., 2., 7., 63., 0., 2., 1., 0., 4., 54., 14., 11., 92., 13., 87., 9., 7., 0., 1., 2., 1., 11., 7., 45., 12., 3., 54., 34., 22., 4., 0., 0., 10., 9., 18., 6., 21., 8., 11., 9., 5., 4., 0., 12., 3., 16., 6., 12., 4., 7., 5., 3., 42., 11., 8., 1., 0., 19., 5., 9., 4., 13., 3., 4., 0., 1., 4., 0., 10., 0., 5., 12., 4., 7., 1., 2., 0., 0., 0., 0., 0., 7., 3., 4., 4., 3., 0., 1., 0., 0., 0., 1., 0., 1., 1., 1., 0., 3., 0., 3., 0., 0., 0., 0., 0., 2., 0., 2., 2., 1., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 20., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 7., 7., 0., 14., 3., 6., 42., 2., 6., 40., 3., 5., 4., 0., 1., 83., 15., 10., 84., 15., 85., 6., 7., 0., 1., 1., 2., 17., 8., 52., 11., 1., 41., 35., 16., 7., 0., 2., 5., 5., 27., 4., 17., 6., 8., 7., 1., 3., 0., 9., 1., 17., 5., 15., 4., 5., 2., 7., 32., 7., 8., 3., 0., 21., 0., 4., 1., 11., 1., 2., 2., 1., 2., 0., 4., 1., 16., 12., 2., 2., 1., 3., 0., 0., 0., 0., 0., 7., 0., 2., 0., 1., 1., 0., 0., 1., 0., 0., 0., 2., 3., 1., 0., 1., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 29., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 0., 4., 9., 0., 14., 4., 9., 46., 1., 12., 59., 0., 8., 0., 0., 6., 52., 9., 10., 60., 22., 75., 15., 4., 0., 2., 2., 2., 16., 6., 55., 14., 2., 40., 29., 15., 7., 0., 0., 6., 2., 21., 6., 29., 7., 13., 3., 2., 0., 0., 13., 3., 25., 9., 10., 2., 9., 3., 2., 35., 10., 6., 1., 0., 11., 3., 8., 0., 16., 2., 2., 1., 0., 0., 0., 4., 3., 20., 8., 0., 7., 0., 3., 0., 0., 0., 0., 0., 7., 1., 6., 4., 3., 1., 2., 0., 0., 0., 1., 0., 0., 2., 4., 0., 3., 0., 2., 0., 3., 0., 0., 0., 1., 0., 3., 1., 2., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 20., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 0., 4., 12., 0., 9., 1., 2., 60., 0., 7., 70., 2., 7., 1., 0., 2., 64., 8., 8., 64., 10., 70., 9., 3., 0., 1., 3., 3., 11., 9., 36., 17., 2., 37., 30., 12., 8., 0., 3., 7., 2., 24., 7., 19., 8., 13., 10., 2., 1., 0., 5., 2., 14., 7., 28., 1., 10., 3., 3., 43., 11., 10., 0., 0., 14., 5., 8., 0., 11., 1., 2., 2., 1., 2., 0., 4., 2., 11., 12., 2., 2., 1., 6., 0., 0., 0., 0., 0., 13., 2., 2., 3., 4., 1., 4., 0., 1., 0., 0., 0., 0., 2., 3., 0., 0., 0., 1., 0., 1., 0., 0., 0., 1., 0., 2., 5., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 22., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 3., 4., 9., 0., 12., 0., 11., 53., 1., 7., 55., 3., 9., 5., 0., 3., 86., 7., 9., 63., 8., 87., 12., 6., 0., 1., 1., 4., 13., 9., 38., 13., 3., 39., 34., 13., 6., 0., 0., 6., 2., 19., 3., 34., 6., 17., 3., 2., 0., 0., 13., 3., 15., 5., 20., 3., 10., 3., 3., 25., 11., 6., 1., 0., 6., 3., 9., 5., 10., 3., 5., 1., 3., 0., 0., 5., 1., 15., 11., 3., 3., 0., 1., 0., 0., 0., 0., 0., 10., 2., 1., 2., 4., 0., 1., 0., 1., 0., 1., 0., 1., 6., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 2., 0., 5., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 17., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 3., 3., 12., 0., 18., 3., 11., 50., 1., 8., 33., 1., 2., 0., 0., 2., 77., 11., 10., 80., 16., 98., 22., 2., 0., 2., 3., 0., 8., 8., 49., 12., 0., 46., 25., 10., 5., 0., 4., 8., 2., 31., 7., 22., 12., 12., 6., 2., 2., 0., 11., 3., 17., 4., 15., 1., 9., 3., 4., 39., 6., 8., 2., 0., 11., 3., 11., 4., 11., 0., 2., 1., 0., 0., 0., 4., 0., 20., 5., 2., 5., 2., 1., 0., 0., 0., 0., 0., 9., 3., 3., 3., 1., 1., 2., 0., 0., 0., 2., 0., 1., 2., 2., 0., 1., 0., 1., 0., 2., 0., 0., 0., 0., 0., 3., 1., 2., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 24., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 3., 3., 5., 8., 0., 14., 1., 7., 52., 0., 9., 62., 2., 3., 1., 0., 2., 57., 8., 7., 74., 11., 80., 8., 4., 0., 1., 2., 0., 8., 11., 59., 12., 0., 39., 29., 19., 7., 0., 0., 6., 5., 32., 7., 26., 8., 9., 7., 8., 1., 0., 11., 5., 13., 5., 14., 3., 7., 3., 7., 33., 7., 8., 1., 0., 10., 4., 4., 1., 15., 2., 3., 1., 0., 0., 0., 4., 3., 19., 9., 4., 4., 1., 4., 0., 0., 0., 0., 0., 12., 1., 5., 3., 1., 1., 0., 0., 2., 0., 1., 0., 0., 6., 3., 0., 2., 0., 1., 0., 1., 0., 0., 0., 2., 0., 2., 2., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 32., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 0., 4., 18., 0., 20., 2., 6., 40., 4., 13., 58., 0., 3., 2., 0., 2., 58., 7., 8., 86., 18., 90., 9., 1., 0., 1., 6., 2., 13., 16., 48., 10., 1., 35., 27., 16., 4., 0., 1., 4., 3., 21., 5., 26., 5., 18., 6., 4., 3., 0., 13., 1., 21., 5., 15., 0., 8., 6., 1., 38., 8., 3., 3., 0., 12., 1., 7., 1., 8., 3., 7., 0., 2., 1., 0., 6., 1., 15., 7., 2., 5., 3., 1., 0., 0., 0., 0., 0., 11., 3., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 2., 4., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 1., 0., 1., 0., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 27., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 3., 1., 6., 0., 19., 1., 2., 47., 2., 6., 55., 0., 9., 5., 0., 3., 64., 11., 10., 85., 15., 95., 16., 2., 0., 0., 6., 2., 19., 9., 55., 9., 4., 47., 27., 16., 4., 0., 1., 9., 1., 24., 3., 27., 5., 12., 12., 4., 1., 0., 10., 3., 14., 4., 21., 2., 8., 2., 3., 23., 11., 9., 5., 0., 18., 3., 8., 3., 5., 2., 3., 1., 1., 1., 0., 2., 2., 17., 8., 6., 7., 4., 3., 0., 0., 0., 0., 0., 14., 0., 6., 0., 7., 1., 0., 0., 0., 0., 0., 0., 0., 8., 2., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 4., 3., 2., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 38., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 1., 4., 13., 0., 8., 0., 9., 50., 1., 7., 53., 0., 4., 1., 0., 0., 76., 7., 6., 75., 17., 94., 13., 3., 0., 2., 0., 1., 16., 8., 48., 11., 2., 42., 41., 15., 5., 0., 0., 2., 3., 29., 7., 37., 13., 15., 7., 3., 1., 0., 6., 5., 8., 6., 19., 1., 16., 3., 2., 35., 12., 7., 1., 0., 13., 2., 7., 2., 12., 2., 4., 0., 2., 0., 0., 5., 2., 9., 6., 10., 6., 0., 4., 0., 0., 0., 0., 0., 6., 2., 5., 0., 1., 1., 1., 0., 2., 0., 0., 0., 1., 0., 4., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 2., 1., 2., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 16., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 2., 4., 16., 0., 15., 0., 5., 63., 2., 3., 63., 1., 5., 2., 0., 2., 76., 9., 8., 63., 14., 73., 15., 2., 0., 2., 4., 0., 13., 7., 49., 13., 2., 31., 43., 10., 3., 0., 0., 5., 0., 26., 8., 27., 2., 13., 7., 4., 0., 0., 11., 1., 16., 4., 9., 3., 12., 6., 2., 38., 8., 5., 2., 0., 13., 1., 9., 2., 12., 4., 3., 2., 0., 1., 0., 7., 2., 17., 11., 5., 1., 0., 2., 0., 0., 0., 0., 0., 11., 1., 3., 3., 3., 0., 3., 0., 1., 0., 0., 0., 2., 6., 5., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 4., 2., 3., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 22., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 2., 2., 6., 0., 12., 3., 7., 55., 0., 10., 64., 1., 2., 2., 0., 3., 59., 9., 12., 68., 16., 72., 6., 2., 0., 0., 0., 1., 14., 16., 54., 8., 1., 45., 38., 16., 6., 0., 2., 6., 1., 29., 10., 26., 5., 17., 12., 5., 4., 0., 7., 4., 13., 5., 17., 5., 7., 4., 2., 34., 8., 7., 3., 0., 12., 2., 11., 2., 13., 2., 5., 3., 1., 2., 0., 1., 2., 14., 7., 2., 6., 2., 3., 0., 0., 0., 0., 0., 9., 2., 6., 2., 2., 1., 0., 0., 3., 0., 2., 0., 0., 3., 3., 0., 3., 0., 1., 0., 1., 0., 0., 0., 2., 0., 1., 2., 2., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 29., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 3., 1., 3., 15., 0., 16., 0., 11., 70., 1., 6., 88., 0., 4., 2., 0., 1., 65., 13., 3., 68., 19., 75., 19., 6., 0., 1., 5., 2., 21., 8., 63., 15., 1., 33., 26., 24., 8., 0., 1., 4., 2., 18., 3., 16., 12., 10., 4., 1., 2., 0., 9., 4., 12., 5., 14., 4., 13., 6., 3., 30., 4., 10., 5., 0., 11., 0., 5., 0., 6., 3., 3., 2., 1., 1., 0., 5., 2., 20., 14., 4., 9., 0., 5., 0., 0., 0., 0., 0., 10., 2., 2., 4., 2., 0., 0., 0., 1., 0., 2., 0., 1., 3., 0., 0., 4., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 3., 2., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 18., 0., 3., 0., 8., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 0., 5., 12., 0., 12., 0., 6., 56., 0., 11., 70., 1., 5., 1., 0., 1., 82., 4., 10., 64., 12., 94., 14., 2., 0., 0., 1., 3., 12., 6., 67., 18., 2., 47., 33., 14., 8., 0., 2., 8., 5., 15., 5., 22., 4., 13., 8., 3., 2., 0., 13., 4., 21., 3., 17., 1., 4., 5., 0., 43., 13., 6., 1., 0., 14., 1., 5., 2., 12., 0., 11., 1., 1., 4., 0., 4., 1., 18., 7., 6., 5., 1., 2., 0., 0., 0., 0., 0., 11., 1., 3., 2., 2., 1., 2., 0., 3., 0., 0., 0., 0., 3., 0., 0., 3., 0., 1., 0., 2., 0., 0., 0., 1., 0., 3., 1., 1., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 12., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 3., 2., 4., 9., 3., 11., 2., 6., 11., 4., 15., 25., 2., 11., 3., 0., 0., 16., 3., 6., 19., 16., 23., 26., 6., 1., 1., 7., 0., 8., 6., 41., 21., 3., 16., 2., 9., 12., 3., 1., 3., 4., 14., 12., 13., 56., 13., 16., 10., 6., 0., 2., 2., 6., 0., 16., 4., 3., 12., 10., 24., 11., 4., 0., 3., 7., 1., 1., 3., 9., 1., 4., 3., 2., 1., 4., 3., 2., 5., 2., 0., 1., 1., 3., 6., 3., 2., 1., 2., 8., 2., 4., 0., 2., 11., 0., 0., 2., 5., 5., 1., 1., 2., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 9., 8., 4., 10., 3., 9., 24., 0., 12., 26., 0., 20., 3., 1., 1., 13., 1., 5., 22., 13., 31., 27., 4., 0., 1., 3., 3., 10., 11., 25., 15., 6., 15., 1., 13., 9., 2., 2., 3., 1., 12., 12., 17., 41., 6., 16., 11., 4., 0., 4., 2., 4., 2., 4., 7., 9., 9., 5., 27., 11., 0., 1., 2., 6., 1., 3., 2., 10., 6., 1., 2., 1., 6., 3., 2., 0., 2., 1., 0., 3., 2., 1., 4., 4., 5., 2., 2., 4., 1., 1., 0., 3., 6., 3., 0., 2., 3., 1., 5., 2., 5., 0., 0., 2., 0., 0., 0., 0., 5., 0., 0., 5., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 2., 4., 11., 0., 4., 0., 9., 23., 1., 10., 26., 1., 10., 5., 1., 4., 19., 2., 2., 14., 12., 31., 32., 5., 0., 0., 1., 0., 6., 2., 22., 20., 3., 23., 4., 16., 10., 1., 1., 7., 4., 7., 6., 22., 52., 9., 19., 5., 4., 0., 9., 1., 6., 1., 8., 8., 7., 14., 5., 21., 12., 1., 3., 0., 6., 3., 0., 3., 3., 1., 5., 4., 3., 10., 2., 2., 0., 3., 1., 0., 3., 2., 1., 5., 5., 4., 3., 2., 2., 1., 2., 0., 3., 6., 2., 0., 3., 2., 3., 1., 1., 3., 2., 0., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 2., 5., 12., 3., 4., 1., 6., 17., 1., 17., 21., 1., 12., 5., 1., 3., 26., 1., 3., 17., 14., 22., 24., 7., 0., 0., 4., 1., 3., 9., 19., 10., 2., 17., 6., 15., 13., 2., 0., 3., 4., 13., 6., 18., 59., 14., 20., 14., 1., 0., 6., 4., 10., 2., 8., 7., 6., 25., 3., 25., 3., 3., 1., 3., 6., 2., 4., 0., 4., 2., 5., 4., 2., 3., 3., 3., 0., 4., 0., 0., 2., 3., 2., 4., 2., 5., 1., 0., 6., 0., 3., 2., 1., 9., 1., 0., 0., 0., 6., 0., 2., 3., 3., 0., 0., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 3., 1., 9., 1., 7., 1., 10., 24., 3., 13., 24., 0., 9., 3., 1., 0., 18., 2., 2., 22., 10., 16., 24., 8., 0., 0., 3., 4., 5., 8., 23., 20., 1., 9., 5., 16., 7., 2., 1., 4., 2., 10., 10., 12., 46., 14., 21., 1., 2., 1., 5., 5., 6., 1., 9., 7., 6., 14., 3., 17., 11., 3., 0., 1., 6., 1., 3., 3., 5., 3., 4., 2., 2., 4., 2., 1., 0., 1., 1., 0., 3., 1., 0., 6., 0., 4., 2., 1., 4., 2., 1., 1., 2., 10., 1., 0., 3., 2., 2., 2., 1., 4., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 3., 4., 10., 1., 6., 1., 3., 21., 0., 13., 35., 4., 11., 0., 2., 4., 19., 2., 3., 28., 13., 19., 17., 6., 1., 0., 1., 3., 8., 2., 24., 14., 2., 18., 4., 10., 8., 2., 0., 5., 1., 16., 19., 21., 50., 11., 22., 5., 6., 2., 10., 2., 3., 4., 6., 8., 5., 12., 6., 21., 9., 4., 2., 0., 6., 2., 2., 2., 6., 3., 4., 5., 2., 2., 2., 1., 1., 1., 0., 0., 2., 3., 4., 8., 1., 3., 0., 2., 4., 1., 7., 2., 1., 8., 1., 0., 4., 2., 1., 2., 4., 4., 2., 0., 2., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 2., 4., 10., 3., 4., 0., 6., 25., 0., 13., 20., 1., 11., 3., 0., 1., 12., 1., 2., 13., 8., 30., 26., 8., 1., 0., 1., 3., 6., 9., 27., 16., 5., 16., 6., 15., 6., 3., 0., 3., 2., 19., 4., 19., 56., 6., 15., 13., 6., 4., 7., 3., 11., 5., 17., 8., 6., 13., 10., 12., 5., 2., 0., 2., 7., 1., 1., 6., 2., 2., 4., 5., 2., 6., 3., 1., 2., 2., 2., 0., 4., 3., 3., 8., 3., 5., 3., 1., 7., 2., 1., 0., 2., 6., 2., 0., 3., 1., 3., 1., 2., 4., 2., 2., 1., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 0., 1., 4., 11., 3., 5., 3., 6., 11., 1., 19., 19., 0., 12., 5., 1., 0., 24., 0., 8., 36., 8., 18., 24., 4., 0., 0., 4., 3., 4., 6., 20., 20., 6., 11., 5., 20., 8., 2., 1., 4., 1., 10., 10., 18., 54., 15., 16., 7., 4., 1., 5., 2., 5., 3., 10., 7., 7., 24., 4., 21., 13., 2., 1., 0., 6., 1., 0., 4., 5., 3., 7., 1., 1., 5., 2., 1., 1., 1., 4., 0., 1., 0., 2., 2., 6., 1., 2., 1., 6., 2., 1., 1., 2., 4., 1., 0., 1., 2., 3., 1., 1., 0., 3., 0., 1., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 0., 2., 10., 2., 6., 1., 7., 27., 2., 9., 18., 0., 21., 5., 1., 4., 18., 1., 3., 18., 9., 18., 22., 7., 1., 0., 4., 1., 8., 3., 34., 14., 4., 18., 5., 16., 7., 0., 0., 8., 3., 15., 14., 17., 44., 9., 23., 3., 2., 0., 0., 3., 10., 2., 15., 9., 8., 15., 4., 16., 12., 5., 1., 1., 10., 1., 2., 2., 9., 8., 4., 3., 3., 7., 4., 2., 2., 3., 2., 0., 2., 1., 3., 3., 3., 4., 4., 2., 2., 0., 2., 0., 2., 6., 5., 0., 2., 3., 2., 4., 3., 1., 2., 1., 1., 0., 0., 0., 0., 2., 0., 0., 7., 0., 0., 0., 1., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 3., 4., 5., 7., 2., 10., 1., 5., 23., 1., 17., 27., 1., 9., 1., 3., 3., 14., 1., 3., 16., 11., 25., 28., 1., 1., 0., 2., 2., 13., 14., 30., 14., 7., 18., 4., 12., 10., 2., 0., 5., 1., 8., 14., 15., 52., 17., 28., 9., 5., 0., 7., 2., 7., 6., 6., 2., 5., 12., 7., 15., 3., 2., 1., 0., 5., 2., 3., 4., 4., 4., 7., 4., 1., 1., 3., 2., 0., 3., 4., 0., 2., 0., 1., 2., 5., 4., 3., 4., 5., 2., 0., 1., 1., 6., 4., 0., 4., 3., 2., 3., 3., 0., 2., 1., 4., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 1., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 0., 6., 9., 1., 8., 0., 3., 19., 0., 11., 30., 1., 9., 5., 0., 2., 8., 0., 2., 32., 11., 24., 26., 4., 1., 2., 3., 3., 12., 9., 35., 17., 4., 21., 2., 20., 5., 2., 3., 4., 2., 15., 13., 13., 43., 15., 26., 11., 3., 0., 8., 2., 1., 4., 12., 8., 5., 23., 10., 28., 8., 3., 0., 0., 10., 0., 0., 2., 2., 1., 2., 1., 1., 3., 3., 3., 2., 1., 4., 0., 0., 1., 1., 5., 2., 7., 3., 2., 3., 0., 2., 1., 4., 6., 1., 0., 2., 1., 4., 4., 0., 2., 1., 1., 2., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 5., 5., 5., 2., 6., 0., 10., 20., 0., 11., 18., 2., 18., 3., 0., 0., 11., 1., 4., 42., 8., 20., 24., 8., 0., 1., 4., 4., 5., 8., 12., 18., 2., 12., 4., 13., 8., 3., 0., 3., 3., 13., 17., 18., 39., 13., 19., 11., 6., 1., 6., 2., 11., 2., 13., 1., 7., 27., 4., 26., 8., 2., 2., 2., 6., 1., 5., 2., 2., 4., 3., 4., 2., 4., 2., 5., 2., 4., 3., 0., 1., 1., 1., 9., 3., 2., 1., 3., 1., 0., 1., 3., 4., 6., 5., 0., 3., 2., 2., 4., 2., 1., 3., 0., 3., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 4., 2., 9., 2., 6., 0., 10., 27., 4., 15., 32., 1., 16., 3., 1., 2., 11., 1., 1., 27., 7., 22., 34., 5., 3., 0., 5., 0., 10., 4., 25., 17., 3., 18., 9., 13., 12., 0., 1., 4., 0., 15., 13., 11., 55., 12., 15., 12., 2., 1., 2., 2., 9., 3., 8., 5., 7., 22., 4., 28., 9., 3., 0., 0., 10., 3., 4., 4., 4., 4., 4., 3., 1., 7., 6., 4., 1., 3., 2., 0., 2., 4., 0., 10., 2., 8., 1., 1., 5., 0., 2., 2., 2., 14., 2., 0., 1., 2., 4., 2., 1., 2., 2., 1., 2., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 1., 11., 5., 2., 3., 0., 7., 25., 1., 12., 21., 0., 20., 2., 1., 1., 14., 1., 6., 20., 11., 27., 19., 9., 2., 1., 2., 4., 5., 3., 26., 18., 3., 12., 5., 19., 8., 3., 1., 10., 0., 14., 9., 17., 45., 9., 20., 14., 1., 1., 3., 2., 2., 3., 10., 1., 7., 9., 5., 24., 10., 3., 3., 3., 12., 2., 2., 1., 5., 6., 3., 1., 1., 4., 2., 5., 1., 1., 2., 0., 0., 3., 1., 4., 3., 3., 1., 0., 4., 0., 1., 1., 1., 10., 0., 0., 4., 4., 1., 2., 1., 4., 0., 1., 5., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 5., 6., 8., 5., 9., 1., 7., 22., 0., 9., 19., 1., 19., 4., 1., 2., 17., 2., 7., 31., 11., 11., 29., 3., 4., 0., 1., 2., 7., 0., 22., 22., 1., 13., 4., 14., 6., 1., 2., 2., 2., 7., 12., 23., 36., 11., 25., 9., 5., 2., 1., 1., 2., 3., 11., 4., 3., 13., 5., 19., 4., 1., 1., 1., 3., 1., 2., 1., 8., 4., 3., 4., 2., 3., 1., 1., 0., 2., 0., 0., 1., 1., 3., 6., 4., 2., 1., 1., 4., 0., 2., 0., 1., 6., 3., 0., 4., 1., 0., 1., 2., 4., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 4., 3., 12., 0., 18., 2., 13., 39., 0., 5., 67., 0., 6., 2., 0., 3., 68., 6., 15., 79., 8., 77., 16., 4., 0., 2., 4., 2., 13., 12., 50., 13., 0., 43., 37., 10., 4., 0., 1., 6., 3., 22., 8., 23., 6., 7., 8., 1., 2., 0., 5., 4., 19., 7., 18., 2., 9., 3., 3., 39., 5., 7., 2., 0., 17., 2., 4., 3., 17., 2., 5., 0., 0., 2., 0., 5., 2., 13., 11., 4., 8., 0., 2., 0., 0., 0., 0., 0., 9., 0., 1., 2., 2., 1., 1., 0., 0., 0., 0., 0., 1., 3., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 3., 1., 1., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 23., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 2., 11., 0., 16., 1., 9., 49., 0., 13., 57., 1., 6., 3., 0., 3., 73., 7., 3., 95., 10., 68., 7., 6., 0., 1., 4., 2., 14., 9., 47., 9., 1., 51., 42., 15., 4., 0., 1., 11., 4., 18., 6., 23., 4., 10., 3., 2., 3., 0., 5., 4., 19., 4., 14., 0., 7., 0., 3., 31., 7., 6., 2., 0., 10., 1., 10., 4., 11., 2., 3., 1., 3., 5., 0., 7., 2., 20., 7., 4., 7., 3., 2., 0., 0., 0., 0., 0., 9., 0., 3., 6., 3., 0., 0., 0., 0., 0., 0., 0., 0., 6., 4., 0., 1., 0., 4., 0., 2., 0., 0., 0., 3., 0., 4., 4., 0., 0., 0., 0., 0., 0., 8., 0., 0., 0., 0., 21., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 5., 12., 0., 14., 2., 6., 55., 1., 12., 55., 2., 9., 0., 0., 0., 48., 9., 7., 71., 15., 94., 10., 0., 0., 2., 3., 1., 10., 9., 41., 18., 3., 45., 28., 9., 4., 0., 0., 5., 6., 16., 7., 22., 10., 12., 2., 0., 3., 0., 6., 6., 17., 4., 12., 3., 9., 3., 5., 41., 7., 9., 3., 0., 16., 1., 7., 2., 8., 0., 5., 2., 0., 0., 0., 7., 0., 13., 6., 5., 5., 1., 1., 0., 0., 0., 0., 0., 8., 1., 2., 2., 3., 2., 2., 0., 1., 0., 2., 0., 1., 1., 2., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 2., 0., 6., 0., 0., 0., 0., 27., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 1., 3., 12., 0., 17., 2., 7., 44., 2., 9., 54., 1., 6., 1., 0., 0., 65., 5., 6., 87., 16., 95., 12., 2., 0., 2., 1., 2., 19., 10., 51., 15., 1., 45., 27., 9., 5., 0., 1., 5., 2., 18., 5., 27., 9., 17., 7., 0., 4., 0., 13., 4., 12., 4., 16., 3., 8., 2., 1., 43., 11., 3., 3., 0., 20., 6., 9., 2., 11., 1., 5., 3., 2., 0., 0., 2., 2., 26., 10., 4., 7., 0., 3., 0., 0., 0., 0., 0., 8., 1., 3., 2., 1., 2., 1., 0., 3., 0., 0., 0., 0., 1., 1., 0., 1., 0., 1., 0., 2., 0., 0., 0., 2., 0., 2., 2., 2., 0., 0., 0., 5., 0., 7., 0., 0., 0., 0., 28., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 2., 2., 8., 0., 15., 2., 11., 50., 2., 16., 52., 1., 7., 3., 0., 4., 55., 12., 4., 55., 18., 85., 12., 5., 0., 1., 1., 1., 19., 4., 46., 11., 0., 44., 34., 18., 4., 0., 3., 4., 2., 29., 9., 35., 12., 18., 5., 4., 4., 0., 9., 3., 22., 4., 16., 2., 8., 4., 2., 37., 12., 3., 1., 0., 9., 3., 4., 2., 15., 0., 6., 0., 2., 1., 0., 6., 2., 19., 10., 2., 0., 2., 2., 0., 0., 0., 0., 0., 6., 3., 3., 3., 3., 1., 2., 0., 0., 0., 3., 0., 0., 4., 2., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 4., 3., 3., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 34., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 3., 15., 0., 11., 4., 5., 53., 2., 3., 64., 1., 6., 1., 0., 0., 70., 14., 6., 91., 8., 76., 11., 10., 0., 0., 4., 0., 14., 6., 35., 14., 1., 38., 38., 21., 4., 0., 0., 3., 4., 25., 8., 18., 7., 14., 5., 4., 3., 0., 9., 5., 16., 3., 19., 4., 8., 8., 4., 43., 9., 9., 2., 0., 15., 8., 8., 3., 10., 1., 4., 3., 0., 2., 0., 2., 3., 13., 12., 4., 6., 0., 1., 0., 0., 0., 0., 0., 8., 2., 1., 1., 4., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 4., 2., 2., 0., 0., 0., 2., 0., 8., 0., 0., 0., 0., 30., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 2., 5., 9., 0., 16., 0., 7., 53., 0., 6., 65., 0., 5., 3., 0., 2., 72., 8., 8., 79., 13., 88., 15., 4., 0., 0., 1., 2., 14., 11., 59., 17., 1., 45., 30., 11., 6., 0., 0., 7., 4., 38., 7., 26., 4., 9., 11., 3., 2., 0., 15., 2., 18., 6., 19., 2., 9., 2., 0., 30., 14., 4., 1., 0., 15., 3., 7., 2., 9., 1., 7., 1., 2., 0., 0., 4., 4., 17., 5., 4., 4., 0., 1., 0., 0., 0., 0., 0., 9., 4., 2., 0., 6., 0., 0., 0., 0., 0., 2., 0., 2., 4., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 4., 2., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 22., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 1., 3., 8., 0., 21., 0., 7., 54., 0., 5., 56., 2., 5., 4., 0., 1., 61., 14., 9., 71., 16., 95., 12., 4., 0., 1., 1., 1., 15., 9., 36., 10., 2., 39., 23., 20., 6., 0., 1., 8., 1., 22., 6., 20., 4., 17., 4., 1., 3., 0., 11., 2., 11., 3., 14., 3., 5., 5., 4., 35., 9., 6., 3., 0., 23., 4., 7., 1., 10., 2., 4., 2., 4., 2., 0., 2., 3., 11., 9., 1., 3., 1., 6., 0., 0., 0., 0., 0., 13., 1., 4., 5., 2., 1., 2., 0., 1., 0., 2., 0., 2., 0., 2., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 6., 4., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 19., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 0., 5., 10., 0., 15., 1., 9., 52., 2., 3., 40., 1., 2., 3., 0., 2., 85., 12., 9., 75., 13., 68., 12., 3., 0., 1., 3., 3., 21., 5., 40., 13., 3., 34., 31., 17., 6., 0., 0., 5., 4., 25., 4., 24., 10., 17., 6., 2., 2., 0., 13., 7., 9., 5., 14., 4., 8., 0., 3., 29., 7., 7., 0., 0., 20., 3., 10., 2., 18., 2., 3., 2., 2., 1., 0., 6., 1., 17., 8., 5., 5., 0., 2., 0., 0., 0., 0., 0., 11., 2., 5., 3., 1., 0., 1., 0., 2., 0., 0., 0., 0., 2., 3., 0., 1., 0., 3., 0., 2., 0., 0., 0., 0., 0., 1., 1., 2., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 36., 0., 3., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 4., 6., 17., 0., 9., 6., 12., 28., 0., 10., 52., 2., 3., 1., 0., 2., 70., 8., 5., 70., 12., 95., 15., 5., 0., 0., 5., 3., 9., 11., 42., 12., 0., 45., 37., 13., 4., 0., 0., 9., 0., 25., 2., 26., 8., 11., 2., 6., 1., 0., 11., 4., 17., 4., 10., 1., 6., 4., 4., 36., 10., 9., 1., 0., 20., 2., 6., 1., 15., 2., 1., 0., 0., 3., 0., 8., 0., 14., 7., 3., 3., 1., 3., 0., 0., 0., 0., 0., 8., 5., 3., 1., 4., 0., 0., 0., 0., 0., 0., 0., 3., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 3., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 28., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 3., 9., 0., 12., 2., 5., 43., 1., 6., 54., 2., 7., 2., 0., 0., 68., 6., 13., 87., 17., 72., 19., 3., 0., 1., 3., 2., 12., 5., 71., 12., 1., 34., 36., 21., 4., 0., 1., 9., 3., 20., 6., 25., 8., 16., 8., 4., 3., 0., 10., 7., 14., 5., 6., 2., 7., 5., 2., 34., 3., 12., 0., 0., 10., 3., 7., 5., 14., 3., 7., 2., 2., 0., 0., 7., 0., 21., 8., 1., 5., 0., 4., 0., 0., 0., 0., 0., 8., 4., 7., 2., 2., 0., 2., 0., 1., 0., 0., 0., 1., 6., 1., 0., 3., 0., 1., 0., 1., 0., 0., 0., 4., 0., 1., 0., 1., 0., 0., 0., 3., 0., 7., 0., 0., 0., 0., 20., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 3., 1., 6., 0., 25., 0., 17., 46., 0., 2., 66., 1., 5., 3., 0., 1., 62., 7., 5., 75., 14., 62., 12., 2., 0., 2., 6., 2., 9., 10., 49., 11., 1., 42., 31., 14., 3., 0., 0., 8., 2., 21., 5., 26., 8., 8., 9., 4., 0., 0., 10., 3., 15., 8., 13., 1., 8., 5., 4., 44., 4., 5., 2., 0., 14., 3., 8., 2., 16., 5., 3., 1., 4., 2., 0., 4., 1., 22., 6., 2., 3., 2., 3., 0., 0., 0., 0., 0., 6., 4., 2., 3., 1., 1., 0., 0., 1., 0., 2., 0., 1., 5., 0., 0., 2., 0., 3., 0., 2., 0., 0., 0., 2., 0., 1., 0., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 25., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

20., 0., 5., 7., 11., 0., 18., 2., 9., 64., 3., 5., 61., 3., 6., 5., 0., 0., 45., 8., 6., 90., 20., 72., 16., 5., 0., 0., 1., 0., 18., 18., 52., 11., 1., 41., 28., 18., 3., 0., 3., 4., 3., 20., 8., 25., 6., 14., 10., 5., 3., 0., 5., 2., 15., 7., 16., 3., 10., 1., 1., 44., 10., 9., 1., 0., 16., 4., 11., 3., 10., 0., 5., 1., 2., 0., 0., 5., 2., 15., 7., 4., 7., 1., 2., 0., 0., 0., 0., 0., 10., 1., 1., 4., 5., 0., 0., 0., 3., 0., 2., 0., 3., 3., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 5., 1., 4., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 22., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 1., 4., 10., 0., 13., 4., 5., 53., 1., 8., 64., 0., 3., 1., 0., 5., 80., 17., 7., 65., 13., 81., 10., 5., 0., 1., 2., 0., 20., 10., 51., 12., 4., 26., 23., 11., 3., 0., 0., 3., 1., 31., 7., 26., 3., 13., 3., 1., 3., 0., 13., 0., 15., 6., 15., 1., 8., 5., 5., 28., 13., 6., 2., 0., 18., 0., 5., 4., 9., 4., 6., 0., 1., 0., 0., 7., 2., 13., 9., 5., 6., 0., 3., 0., 0., 0., 0., 0., 6., 1., 1., 1., 3., 3., 1., 0., 0., 0., 3., 0., 4., 3., 2., 0., 2., 0., 1., 0., 0., 0., 0., 0., 2., 0., 1., 3., 1., 0., 0., 0., 3., 0., 4., 0., 0., 0., 0., 31., 0., 2., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 2., 4., 9., 0., 11., 1., 7., 42., 0., 8., 58., 1., 4., 4., 0., 1., 70., 13., 10., 71., 17., 84., 10., 4., 0., 0., 3., 4., 18., 10., 51., 4., 0., 42., 28., 21., 2., 0., 1., 4., 2., 17., 3., 31., 7., 12., 3., 3., 0., 0., 10., 5., 19., 6., 15., 5., 10., 4., 4., 39., 8., 9., 0., 0., 14., 3., 10., 3., 9., 3., 6., 1., 0., 1., 0., 5., 4., 16., 8., 3., 4., 1., 4., 0., 0., 0., 0., 0., 8., 5., 3., 0., 3., 1., 1., 0., 0., 0., 2., 0., 0., 0., 2., 0., 5., 0., 3., 0., 1., 0., 0., 0., 0., 0., 1., 1., 3., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 30., 0., 1., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 1., 6., 9., 0., 17., 2., 9., 48., 1., 5., 50., 0., 7., 0., 0., 0., 73., 15., 12., 71., 22., 74., 11., 4., 0., 1., 2., 1., 17., 4., 48., 15., 1., 40., 39., 15., 8., 0., 0., 7., 1., 20., 6., 30., 5., 22., 6., 1., 4., 0., 5., 3., 20., 3., 16., 4., 5., 1., 1., 33., 8., 5., 3., 0., 10., 4., 9., 5., 7., 1., 4., 0., 0., 1., 0., 6., 3., 13., 5., 1., 3., 1., 1., 0., 0., 0., 0., 0., 14., 1., 2., 2., 1., 2., 0., 0., 1., 0., 1., 0., 2., 2., 2., 0., 4., 0., 2., 0., 3., 0., 0., 0., 0., 0., 1., 6., 1., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 25., 0., 4., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 1., 4., 11., 0., 15., 1., 4., 63., 1., 3., 65., 0., 6., 2., 0., 1., 62., 7., 9., 65., 12., 75., 11., 2., 0., 1., 0., 1., 10., 8., 56., 11., 2., 49., 32., 22., 6., 0., 1., 7., 2., 23., 9., 32., 6., 10., 3., 2., 4., 0., 15., 3., 20., 3., 17., 2., 4., 4., 4., 30., 4., 6., 3., 0., 15., 2., 9., 2., 14., 5., 5., 0., 2., 2., 0., 6., 1., 16., 9., 2., 3., 1., 0., 0., 0., 0., 0., 0., 3., 2., 6., 1., 2., 2., 1., 0., 1., 0., 2., 0., 0., 3., 1., 0., 2., 0., 1., 0., 4., 0., 0., 0., 0., 0., 2., 5., 4., 0., 0., 0., 1., 0., 9., 0., 0., 0., 0., 20., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 4., 3., 4., 1., 3., 0., 5., 35., 2., 8., 21., 1., 10., 3., 0., 3., 13., 3., 2., 19., 11., 23., 36., 2., 0., 0., 2., 1., 10., 5., 22., 13., 4., 19., 2., 19., 17., 2., 1., 3., 3., 15., 13., 21., 36., 10., 18., 10., 3., 1., 6., 3., 6., 2., 5., 6., 10., 11., 5., 27., 3., 3., 1., 1., 8., 0., 3., 2., 3., 2., 4., 5., 1., 7., 1., 0., 1., 2., 1., 0., 1., 4., 3., 7., 3., 3., 3., 3., 2., 0., 2., 1., 3., 8., 3., 0., 2., 4., 3., 1., 2., 3., 2., 1., 0., 0., 0., 0., 0., 4., 0., 0., 2., 0., 0., 0., 1., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 1., 2., 9., 2., 5., 1., 8., 24., 1., 14., 27., 0., 9., 4., 0., 3., 24., 3., 2., 21., 5., 23., 21., 10., 3., 3., 2., 1., 8., 12., 31., 16., 3., 17., 3., 13., 16., 4., 1., 3., 3., 6., 10., 20., 38., 9., 21., 14., 4., 1., 7., 2., 5., 2., 8., 6., 13., 12., 6., 26., 8., 3., 2., 0., 5., 0., 4., 3., 5., 4., 4., 5., 3., 4., 3., 0., 1., 2., 1., 0., 4., 0., 3., 7., 1., 3., 1., 1., 6., 2., 2., 2., 2., 6., 1., 0., 0., 3., 3., 1., 0., 1., 4., 2., 1., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 5., 6., 3., 5., 2., 1., 30., 1., 13., 18., 0., 18., 5., 1., 3., 13., 3., 8., 21., 8., 24., 23., 8., 1., 0., 4., 1., 10., 2., 22., 14., 7., 10., 6., 27., 7., 1., 0., 4., 2., 17., 8., 12., 48., 13., 20., 6., 2., 2., 4., 1., 8., 2., 7., 11., 7., 13., 5., 17., 7., 1., 0., 0., 3., 0., 3., 4., 6., 2., 7., 2., 0., 4., 3., 2., 1., 0., 1., 0., 2., 2., 2., 5., 4., 4., 0., 3., 7., 1., 2., 0., 2., 4., 0., 0., 4., 3., 2., 0., 2., 4., 1., 0., 2., 0., 0., 0., 0., 2., 0., 0., 5., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 2., 1., 8., 4., 12., 3., 7., 22., 3., 16., 35., 5., 11., 5., 1., 2., 21., 3., 4., 15., 10., 34., 23., 3., 1., 1., 3., 1., 6., 4., 18., 19., 1., 13., 4., 20., 9., 0., 0., 4., 1., 10., 11., 18., 52., 9., 13., 9., 5., 0., 3., 1., 11., 4., 9., 7., 11., 18., 5., 17., 10., 5., 0., 2., 9., 3., 1., 0., 6., 6., 6., 3., 1., 5., 3., 4., 1., 1., 1., 0., 2., 2., 3., 7., 0., 4., 3., 5., 4., 1., 2., 2., 3., 7., 1., 0., 3., 1., 3., 1., 1., 4., 1., 1., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 3., 3., 1., 6., 2., 2., 1., 5., 15., 2., 14., 12., 1., 13., 4., 1., 3., 22., 4., 5., 14., 14., 35., 34., 5., 5., 1., 3., 3., 8., 6., 27., 15., 2., 17., 5., 21., 11., 1., 1., 5., 2., 15., 5., 22., 58., 7., 18., 5., 7., 1., 4., 2., 13., 4., 10., 4., 5., 15., 3., 28., 9., 3., 2., 0., 5., 2., 4., 1., 3., 2., 4., 3., 3., 1., 3., 2., 0., 3., 0., 0., 2., 0., 2., 4., 0., 1., 2., 1., 4., 0., 4., 0., 0., 4., 3., 0., 5., 1., 2., 4., 6., 2., 3., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 6., 9., 1., 7., 0., 4., 40., 0., 13., 27., 2., 17., 3., 0., 0., 9., 1., 6., 25., 12., 17., 28., 5., 0., 2., 6., 2., 9., 6., 16., 15., 3., 20., 5., 9., 9., 2., 1., 4., 2., 10., 19., 18., 46., 12., 16., 9., 3., 1., 4., 3., 5., 2., 4., 6., 8., 9., 7., 26., 6., 1., 1., 0., 3., 2., 2., 0., 3., 2., 3., 5., 3., 5., 1., 2., 0., 3., 4., 0., 3., 5., 2., 6., 3., 6., 1., 3., 3., 2., 6., 0., 1., 9., 3., 0., 2., 1., 1., 4., 2., 2., 2., 0., 4., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 3., 2., 6., 5., 4., 3., 1., 9., 27., 4., 18., 34., 1., 17., 0., 1., 6., 21., 3., 3., 16., 16., 30., 29., 3., 1., 2., 0., 2., 4., 8., 22., 13., 1., 16., 6., 15., 10., 0., 0., 2., 3., 12., 6., 11., 45., 8., 18., 10., 3., 1., 5., 1., 6., 1., 8., 4., 9., 19., 6., 19., 1., 2., 1., 1., 6., 0., 4., 3., 10., 4., 4., 4., 1., 3., 4., 1., 1., 0., 1., 0., 0., 1., 3., 5., 2., 3., 1., 1., 5., 0., 3., 1., 1., 12., 2., 0., 2., 2., 1., 3., 1., 1., 3., 0., 4., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 4., 9., 3., 1., 1., 6., 26., 2., 17., 30., 0., 18., 3., 1., 1., 7., 0., 7., 34., 9., 14., 27., 1., 1., 0., 0., 2., 8., 5., 14., 19., 1., 12., 3., 11., 8., 3., 2., 8., 2., 18., 14., 22., 48., 17., 15., 13., 4., 2., 5., 2., 5., 5., 16., 7., 6., 21., 5., 19., 10., 1., 1., 0., 4., 0., 3., 1., 4., 2., 4., 5., 5., 5., 1., 3., 3., 0., 1., 0., 1., 7., 1., 7., 5., 4., 3., 6., 3., 1., 2., 1., 2., 8., 2., 0., 3., 0., 3., 2., 1., 1., 3., 1., 2., 0., 0., 0., 0., 0., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 2., 6., 5., 5., 4., 2., 11., 20., 3., 17., 15., 0., 18., 1., 0., 0., 19., 1., 2., 26., 18., 13., 24., 8., 1., 0., 2., 1., 7., 6., 23., 21., 4., 13., 8., 19., 8., 3., 0., 4., 2., 18., 8., 20., 44., 10., 23., 8., 4., 0., 9., 2., 11., 4., 7., 4., 5., 21., 4., 31., 4., 2., 2., 1., 8., 1., 4., 2., 0., 2., 6., 4., 3., 3., 2., 3., 2., 0., 2., 0., 2., 1., 2., 10., 2., 7., 3., 2., 4., 2., 3., 1., 1., 11., 3., 0., 2., 2., 2., 2., 0., 5., 2., 0., 0., 0., 0., 0., 0., 5., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 4., 12., 3., 7., 3., 5., 38., 0., 18., 26., 1., 13., 5., 0., 0., 25., 2., 7., 27., 14., 19., 33., 8., 2., 0., 4., 2., 9., 4., 22., 24., 6., 26., 1., 9., 11., 3., 3., 1., 0., 12., 15., 14., 50., 14., 12., 10., 1., 3., 5., 0., 7., 2., 15., 4., 5., 19., 4., 22., 9., 0., 1., 1., 9., 1., 5., 1., 0., 2., 0., 3., 0., 4., 2., 4., 1., 0., 0., 0., 1., 3., 2., 5., 1., 3., 1., 2., 2., 3., 4., 0., 1., 5., 2., 0., 4., 2., 1., 1., 0., 2., 1., 0., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 0., 3., 9., 12., 3., 4., 0., 5., 26., 1., 10., 20., 1., 13., 1., 0., 3., 13., 0., 2., 25., 12., 25., 32., 8., 2., 0., 2., 4., 5., 11., 16., 14., 4., 15., 3., 17., 6., 1., 1., 5., 4., 9., 11., 14., 46., 14., 13., 12., 1., 0., 5., 4., 11., 6., 7., 7., 8., 20., 8., 30., 6., 4., 0., 4., 17., 1., 2., 2., 6., 3., 2., 3., 1., 5., 5., 2., 2., 1., 0., 0., 5., 1., 1., 3., 0., 6., 1., 3., 5., 2., 2., 1., 1., 10., 0., 0., 3., 0., 3., 1., 2., 2., 0., 2., 1., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 3., 4., 9., 4., 9., 1., 7., 26., 2., 15., 24., 1., 20., 3., 0., 1., 18., 2., 9., 35., 14., 15., 24., 4., 2., 1., 4., 1., 7., 5., 17., 14., 4., 15., 5., 15., 11., 2., 1., 5., 2., 7., 9., 21., 49., 9., 22., 8., 4., 0., 5., 1., 5., 1., 6., 5., 7., 15., 7., 23., 4., 2., 0., 2., 5., 0., 5., 1., 8., 3., 2., 5., 2., 6., 3., 0., 1., 4., 1., 0., 0., 4., 4., 9., 3., 6., 0., 2., 2., 2., 2., 2., 0., 8., 1., 0., 0., 0., 2., 5., 0., 2., 2., 2., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 1., 4., 13., 4., 7., 3., 10., 14., 0., 13., 14., 1., 12., 4., 2., 3., 19., 3., 4., 32., 11., 16., 23., 6., 1., 0., 5., 2., 10., 14., 33., 17., 3., 15., 3., 11., 6., 2., 2., 8., 1., 12., 12., 18., 44., 13., 21., 10., 4., 0., 4., 1., 3., 4., 11., 6., 8., 11., 5., 22., 9., 6., 0., 0., 2., 1., 3., 3., 4., 7., 2., 2., 0., 2., 7., 2., 0., 1., 0., 0., 2., 1., 1., 7., 2., 5., 5., 0., 4., 0., 3., 2., 1., 4., 4., 0., 3., 1., 2., 3., 1., 0., 3., 1., 2., 0., 0., 0., 0., 5., 0., 0., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 2., 4., 8., 5., 4., 3., 7., 25., 0., 11., 14., 2., 14., 1., 0., 3., 14., 2., 5., 18., 16., 18., 32., 5., 1., 0., 3., 2., 8., 10., 23., 26., 7., 16., 5., 20., 10., 2., 1., 2., 3., 11., 10., 13., 38., 16., 27., 9., 3., 0., 3., 0., 5., 4., 14., 4., 6., 15., 8., 28., 4., 2., 0., 1., 8., 3., 2., 1., 7., 5., 7., 5., 0., 3., 4., 4., 0., 3., 2., 0., 3., 3., 4., 6., 3., 3., 1., 0., 3., 0., 2., 2., 3., 7., 0., 0., 3., 0., 0., 1., 2., 1., 4., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 2., 0., 3., 8., 0., 10., 4., 9., 54., 1., 3., 72., 0., 7., 1., 0., 1., 75., 5., 12., 93., 20., 75., 13., 3., 0., 1., 3., 2., 14., 12., 44., 12., 2., 33., 36., 18., 3., 0., 0., 8., 2., 22., 4., 26., 12., 14., 2., 4., 5., 0., 8., 1., 17., 8., 15., 4., 8., 4., 2., 44., 5., 6., 2., 0., 5., 4., 14., 2., 17., 1., 6., 0., 0., 1., 0., 3., 3., 19., 13., 2., 4., 0., 4., 0., 0., 0., 0., 0., 10., 1., 5., 2., 2., 1., 0., 0., 0., 0., 1., 0., 2., 3., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 1., 0., 7., 0., 3., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 24., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 4., 8., 0., 16., 1., 8., 60., 1., 12., 47., 0., 7., 1., 0., 2., 86., 11., 11., 66., 14., 80., 14., 4., 0., 0., 7., 3., 14., 8., 52., 12., 2., 40., 32., 13., 5., 0., 3., 5., 6., 20., 6., 32., 8., 10., 6., 2., 1., 0., 8., 4., 7., 3., 18., 0., 8., 3., 4., 30., 12., 8., 5., 0., 13., 6., 7., 0., 12., 1., 7., 2., 0., 1., 0., 5., 3., 11., 5., 3., 2., 1., 2., 0., 0., 0., 0., 0., 8., 1., 4., 1., 5., 3., 1., 0., 2., 0., 1., 0., 1., 3., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 0., 2., 2., 1., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 22., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 0., 4., 11., 0., 15., 3., 8., 31., 1., 7., 49., 0., 5., 3., 0., 1., 71., 6., 6., 71., 5., 71., 8., 8., 0., 0., 3., 3., 16., 10., 65., 15., 3., 34., 32., 19., 0., 0., 0., 3., 2., 26., 3., 22., 7., 11., 4., 2., 2., 0., 9., 4., 14., 5., 15., 4., 10., 3., 2., 38., 15., 5., 2., 0., 16., 4., 5., 0., 9., 1., 5., 3., 1., 1., 0., 6., 1., 20., 11., 3., 3., 3., 4., 0., 0., 0., 0., 0., 10., 2., 1., 1., 2., 1., 0., 0., 0., 0., 0., 0., 1., 3., 3., 0., 4., 0., 0., 0., 1., 0., 0., 0., 1., 0., 4., 0., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 16., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 4., 6., 3., 0., 12., 5., 7., 60., 1., 6., 62., 0., 6., 3., 0., 0., 70., 10., 8., 67., 13., 68., 7., 6., 0., 0., 3., 0., 16., 8., 57., 12., 0., 31., 20., 13., 3., 0., 0., 6., 9., 21., 4., 17., 5., 14., 6., 2., 4., 0., 9., 3., 16., 6., 23., 4., 5., 6., 1., 44., 5., 12., 2., 0., 17., 2., 7., 1., 10., 1., 6., 4., 1., 2., 0., 7., 1., 21., 10., 1., 1., 2., 2., 0., 0., 0., 0., 0., 7., 2., 5., 2., 4., 0., 0., 0., 2., 0., 0., 0., 3., 4., 2., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 1., 1., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 30., 0., 4., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 2., 21., 0., 20., 3., 4., 60., 1., 8., 67., 0., 3., 1., 0., 2., 92., 4., 7., 87., 19., 89., 7., 4., 0., 2., 4., 2., 13., 10., 49., 14., 4., 42., 34., 19., 4., 0., 0., 13., 2., 17., 4., 26., 6., 15., 5., 2., 3., 0., 10., 5., 10., 7., 16., 4., 5., 8., 2., 25., 11., 3., 2., 0., 10., 1., 8., 3., 10., 3., 1., 2., 1., 1., 0., 4., 2., 17., 10., 0., 9., 0., 2., 0., 0., 0., 0., 0., 12., 4., 4., 1., 5., 1., 0., 0., 0., 0., 0., 0., 0., 3., 2., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 3., 4., 2., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 24., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 3., 2., 9., 13., 0., 17., 1., 12., 55., 1., 11., 63., 0., 7., 3., 0., 4., 69., 10., 8., 82., 10., 84., 10., 5., 0., 2., 3., 2., 14., 10., 48., 11., 2., 40., 20., 10., 3., 0., 1., 6., 4., 25., 5., 19., 6., 13., 10., 2., 1., 0., 7., 2., 12., 5., 17., 3., 6., 5., 1., 38., 5., 7., 1., 0., 11., 1., 6., 1., 5., 0., 4., 0., 1., 1., 0., 2., 2., 23., 6., 4., 3., 1., 3., 0., 0., 0., 0., 0., 1., 2., 1., 2., 4., 1., 0., 0., 0., 0., 3., 0., 1., 2., 0., 0., 2., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 4., 3., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 24., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 1., 4., 6., 0., 10., 1., 5., 51., 1., 3., 67., 2., 5., 2., 0., 1., 80., 7., 6., 70., 19., 91., 11., 6., 0., 1., 3., 1., 13., 8., 52., 12., 2., 47., 35., 9., 5., 0., 0., 7., 4., 16., 11., 25., 8., 17., 8., 2., 1., 0., 11., 3., 10., 3., 16., 0., 11., 2., 2., 38., 11., 9., 4., 0., 15., 4., 5., 0., 11., 5., 3., 1., 2., 1., 0., 7., 2., 14., 12., 4., 5., 0., 3., 0., 0., 0., 0., 0., 10., 2., 4., 1., 4., 1., 0., 0., 1., 0., 1., 0., 0., 7., 2., 0., 2., 0., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 29., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 5., 7., 12., 0., 18., 4., 8., 38., 0., 10., 67., 2., 4., 3., 0., 2., 81., 11., 6., 66., 15., 68., 9., 4., 0., 4., 5., 2., 9., 3., 42., 12., 0., 47., 26., 13., 9., 0., 2., 8., 1., 23., 7., 35., 2., 13., 3., 1., 0., 0., 10., 4., 19., 4., 15., 3., 8., 2., 3., 42., 6., 8., 1., 0., 11., 1., 11., 1., 16., 3., 5., 3., 0., 1., 0., 5., 1., 15., 11., 9., 3., 3., 2., 0., 0., 0., 0., 0., 10., 2., 2., 5., 2., 0., 3., 0., 1., 0., 0., 0., 2., 2., 1., 0., 2., 0., 2., 0., 1., 0., 0., 0., 1., 0., 2., 1., 1., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 30., 0., 0., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 1., 2., 3., 8., 0., 13., 2., 7., 64., 2., 7., 55., 0., 5., 1., 0., 1., 85., 6., 2., 83., 15., 68., 12., 3., 0., 1., 1., 0., 16., 10., 58., 12., 0., 40., 26., 11., 8., 0., 0., 3., 1., 22., 14., 24., 8., 17., 3., 6., 2., 0., 9., 1., 10., 5., 16., 5., 11., 2., 4., 37., 10., 9., 1., 0., 17., 4., 13., 1., 4., 4., 6., 1., 0., 0., 0., 3., 2., 20., 14., 3., 6., 1., 6., 0., 0., 0., 0., 0., 8., 2., 1., 1., 8., 1., 0., 0., 0., 0., 0., 0., 2., 8., 5., 0., 2., 0., 1., 0., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 19., 0., 3., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 3., 2., 5., 12., 0., 16., 1., 5., 68., 1., 7., 42., 1., 7., 5., 0., 4., 58., 12., 9., 94., 15., 72., 15., 7., 0., 0., 4., 2., 14., 7., 56., 11., 0., 44., 43., 6., 6., 0., 1., 6., 0., 25., 4., 23., 5., 13., 6., 1., 1., 0., 4., 3., 11., 6., 14., 4., 4., 1., 6., 54., 8., 5., 2., 0., 13., 1., 3., 1., 10., 1., 4., 1., 3., 1., 0., 5., 1., 15., 8., 4., 6., 0., 3., 0., 0., 0., 0., 0., 8., 2., 2., 3., 5., 0., 1., 0., 0., 0., 2., 0., 0., 4., 4., 0., 5., 0., 1., 0., 1., 0., 0., 0., 1., 0., 1., 2., 2., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 23., 0., 3., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

5., 1., 4., 2., 18., 0., 10., 4., 7., 43., 2., 6., 49., 1., 1., 3., 0., 3., 60., 4., 11., 70., 22., 73., 7., 7., 0., 1., 2., 3., 13., 8., 55., 10., 2., 30., 31., 11., 8., 0., 0., 9., 8., 19., 5., 20., 5., 17., 6., 8., 3., 0., 14., 6., 16., 5., 18., 2., 5., 1., 2., 29., 6., 3., 2., 0., 17., 1., 8., 2., 16., 5., 2., 3., 2., 0., 0., 4., 0., 20., 8., 1., 3., 2., 4., 0., 0., 0., 0., 0., 11., 1., 4., 5., 1., 2., 0., 0., 0., 0., 0., 0., 1., 3., 2., 0., 2., 0., 0., 0., 3., 0., 0., 0., 2., 0., 2., 1., 1., 0., 0., 0., 1., 0., 7., 0., 0., 0., 0., 21., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

19., 1., 1., 5., 4., 0., 14., 0., 5., 58., 0., 12., 63., 0., 5., 3., 0., 1., 70., 9., 12., 92., 9., 75., 14., 5., 0., 0., 2., 3., 18., 4., 35., 11., 2., 39., 29., 16., 0., 0., 1., 9., 3., 27., 2., 23., 11., 15., 4., 2., 2., 0., 6., 7., 13., 6., 11., 2., 4., 0., 3., 39., 12., 9., 3., 0., 14., 2., 10., 4., 17., 2., 5., 0., 1., 1., 0., 3., 3., 9., 6., 4., 5., 1., 5., 0., 0., 0., 0., 0., 2., 0., 4., 2., 3., 3., 2., 0., 2., 0., 2., 0., 1., 2., 2., 0., 4., 0., 1., 0., 3., 0., 0., 0., 0., 0., 2., 3., 3., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 23., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 2., 3., 12., 0., 16., 1., 11., 47., 0., 11., 64., 3., 5., 2., 0., 3., 75., 5., 10., 66., 15., 91., 13., 3., 0., 0., 4., 1., 15., 5., 44., 6., 4., 40., 28., 12., 6., 0., 0., 6., 1., 28., 8., 18., 8., 12., 8., 3., 2., 0., 14., 5., 19., 4., 15., 2., 4., 1., 2., 30., 7., 3., 1., 0., 17., 3., 9., 2., 7., 1., 2., 0., 0., 2., 0., 6., 3., 16., 5., 6., 3., 0., 2., 0., 0., 0., 0., 0., 14., 0., 2., 3., 2., 2., 0., 0., 0., 0., 1., 0., 1., 3., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 5., 3., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 20., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 1., 5., 13., 0., 15., 1., 7., 42., 0., 10., 60., 2., 3., 1., 0., 2., 68., 10., 4., 79., 13., 81., 13., 3., 0., 1., 5., 3., 12., 14., 51., 10., 6., 37., 35., 18., 6., 0., 2., 7., 3., 17., 2., 18., 8., 19., 12., 2., 4., 0., 5., 2., 8., 9., 8., 2., 6., 3., 2., 33., 6., 5., 0., 0., 11., 0., 4., 0., 10., 1., 4., 1., 0., 0., 0., 3., 2., 19., 13., 7., 3., 3., 4., 0., 0., 0., 0., 0., 8., 0., 4., 1., 6., 1., 2., 0., 0., 0., 1., 0., 1., 6., 2., 0., 3., 0., 1., 0., 0., 0., 0., 0., 4., 0., 0., 3., 1., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 27., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 3., 7., 16., 0., 14., 3., 6., 55., 0., 2., 64., 2., 1., 2., 0., 1., 78., 6., 5., 91., 10., 74., 12., 3., 0., 2., 3., 3., 12., 12., 55., 10., 5., 37., 30., 10., 4., 0., 0., 5., 2., 32., 5., 32., 4., 8., 5., 4., 1., 0., 8., 4., 12., 2., 14., 4., 6., 6., 2., 33., 8., 9., 2., 0., 13., 0., 7., 3., 18., 5., 8., 0., 4., 2., 0., 5., 1., 18., 10., 0., 3., 4., 0., 0., 0., 0., 0., 0., 7., 1., 1., 1., 4., 1., 1., 0., 0., 0., 1., 0., 2., 4., 2., 0., 2., 0., 3., 0., 2., 0., 0., 0., 0., 0., 1., 1., 0., 0., 0., 0., 2., 0., 6., 0., 0., 0., 0., 25., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 2., 0., 16., 0., 12., 1., 3., 52., 1., 7., 47., 1., 6., 4., 0., 3., 55., 10., 8., 79., 18., 78., 9., 3., 0., 0., 3., 0., 16., 8., 57., 18., 0., 46., 29., 11., 8., 0., 1., 10., 3., 23., 8., 28., 5., 12., 4., 3., 0., 0., 7., 5., 19., 4., 14., 3., 12., 2., 2., 36., 9., 13., 2., 0., 20., 3., 9., 5., 7., 2., 6., 0., 1., 0., 0., 6., 2., 26., 8., 0., 2., 2., 2., 0., 0., 0., 0., 0., 6., 0., 2., 1., 3., 1., 0., 0., 0., 0., 1., 0., 0., 2., 2., 0., 0., 0., 3., 0., 4., 0., 0., 0., 1., 0., 3., 1., 3., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 13., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 5., 2., 7., 0., 17., 2., 7., 60., 2., 11., 55., 0., 2., 1., 0., 2., 71., 11., 7., 78., 16., 79., 14., 2., 0., 2., 2., 2., 10., 9., 54., 5., 3., 32., 29., 15., 4., 0., 2., 3., 2., 21., 7., 31., 10., 12., 8., 2., 4., 0., 8., 3., 15., 4., 18., 2., 6., 2., 1., 29., 6., 9., 0., 0., 14., 4., 13., 3., 4., 1., 3., 2., 0., 0., 0., 7., 2., 20., 7., 2., 9., 1., 2., 0., 0., 0., 0., 0., 5., 2., 3., 2., 4., 1., 1., 0., 1., 0., 1., 0., 1., 7., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 4., 0., 2., 4., 1., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 27., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 0., 2., 4., 13., 0., 16., 1., 5., 61., 0., 9., 68., 1., 5., 2., 0., 1., 62., 6., 1., 72., 13., 67., 13., 4., 0., 3., 5., 1., 22., 8., 40., 8., 0., 29., 35., 11., 9., 0., 0., 7., 3., 18., 4., 23., 9., 15., 6., 0., 2., 0., 11., 1., 17., 9., 20., 3., 8., 1., 3., 30., 13., 6., 2., 0., 15., 6., 15., 2., 16., 0., 4., 0., 1., 1., 0., 5., 2., 24., 11., 1., 5., 0., 4., 0., 0., 0., 0., 0., 5., 3., 2., 2., 1., 3., 1., 0., 3., 0., 1., 0., 1., 4., 1., 0., 3., 0., 2., 0., 2., 0., 0., 0., 0., 0., 5., 4., 3., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 22., 0., 2., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 1., 0., 3., 8., 2., 8., 0., 6., 17., 1., 10., 11., 0., 13., 2., 2., 1., 15., 3., 0., 20., 20., 33., 29., 10., 0., 1., 4., 6., 4., 8., 29., 20., 5., 13., 3., 11., 9., 1., 0., 6., 4., 9., 16., 26., 50., 14., 12., 12., 6., 1., 4., 2., 8., 5., 7., 4., 8., 10., 6., 21., 4., 2., 1., 1., 7., 0., 5., 0., 7., 4., 4., 3., 3., 2., 7., 2., 0., 1., 1., 0., 0., 1., 2., 4., 2., 2., 3., 1., 7., 0., 1., 0., 0., 3., 3., 0., 1., 3., 3., 1., 0., 1., 1., 0., 2., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 3., 1., 6., 9., 5., 11., 2., 5., 21., 1., 18., 18., 3., 16., 3., 1., 1., 22., 1., 4., 30., 13., 12., 21., 8., 0., 0., 0., 1., 9., 5., 13., 18., 3., 6., 5., 14., 6., 4., 2., 4., 0., 12., 8., 24., 51., 12., 30., 9., 5., 0., 5., 2., 5., 4., 11., 6., 7., 15., 3., 16., 9., 5., 2., 1., 5., 0., 4., 1., 6., 3., 3., 5., 2., 2., 4., 2., 0., 3., 1., 0., 3., 2., 0., 3., 1., 4., 0., 3., 7., 0., 2., 1., 4., 7., 2., 0., 4., 1., 2., 0., 2., 3., 4., 0., 1., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 3., 7., 2., 5., 1., 5., 28., 3., 4., 22., 2., 24., 3., 2., 1., 24., 2., 3., 7., 8., 19., 29., 2., 0., 2., 5., 1., 15., 15., 18., 11., 7., 12., 5., 13., 15., 4., 1., 6., 5., 14., 8., 25., 51., 14., 19., 13., 4., 1., 5., 3., 5., 2., 9., 4., 3., 19., 5., 14., 10., 3., 1., 4., 5., 1., 3., 2., 5., 2., 3., 6., 0., 5., 1., 2., 1., 4., 1., 0., 6., 0., 1., 7., 2., 9., 2., 7., 6., 1., 1., 0., 1., 6., 2., 0., 2., 1., 3., 2., 0., 1., 1., 2., 3., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 1., 4., 6., 2., 3., 0., 5., 18., 0., 11., 13., 2., 18., 2., 1., 1., 14., 1., 5., 27., 10., 24., 22., 10., 0., 1., 2., 1., 4., 4., 19., 13., 3., 16., 8., 15., 3., 3., 0., 2., 0., 10., 10., 8., 46., 10., 25., 10., 3., 3., 6., 1., 5., 3., 17., 6., 9., 12., 8., 21., 13., 1., 1., 1., 6., 2., 4., 1., 4., 0., 2., 5., 4., 1., 1., 1., 1., 2., 2., 0., 4., 2., 2., 7., 2., 3., 4., 0., 7., 1., 4., 1., 4., 4., 4., 0., 1., 4., 5., 4., 1., 1., 1., 0., 4., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 5., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 4., 2., 8., 4., 4., 1., 9., 23., 0., 9., 24., 1., 13., 2., 3., 2., 20., 3., 5., 22., 18., 17., 26., 8., 2., 3., 3., 2., 3., 12., 44., 9., 2., 16., 6., 15., 9., 1., 0., 5., 2., 6., 17., 18., 56., 11., 14., 10., 5., 0., 3., 3., 4., 5., 9., 4., 5., 22., 4., 24., 6., 4., 1., 1., 11., 0., 2., 2., 3., 1., 4., 5., 2., 6., 4., 4., 1., 3., 2., 0., 4., 1., 5., 8., 2., 3., 7., 1., 6., 1., 3., 0., 2., 8., 3., 0., 1., 3., 0., 3., 3., 2., 0., 2., 4., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 3., 11., 1., 7., 0., 9., 24., 2., 16., 20., 1., 16., 0., 0., 1., 22., 2., 4., 28., 17., 39., 32., 5., 1., 2., 2., 3., 5., 8., 32., 22., 1., 14., 6., 7., 11., 3., 0., 2., 4., 24., 10., 10., 39., 7., 17., 11., 6., 0., 7., 4., 6., 6., 14., 5., 11., 15., 5., 21., 12., 2., 0., 0., 3., 0., 6., 3., 3., 1., 4., 3., 1., 2., 5., 1., 1., 5., 3., 0., 1., 2., 1., 7., 3., 3., 5., 2., 4., 1., 2., 1., 1., 11., 2., 0., 4., 1., 1., 4., 2., 2., 5., 1., 3., 0., 0., 0., 0., 2., 0., 0., 7., 0., 0., 0., 2., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 0., 5., 7., 1., 5., 2., 10., 25., 2., 12., 30., 4., 12., 4., 1., 4., 10., 1., 2., 33., 8., 33., 26., 7., 1., 3., 1., 1., 7., 12., 25., 18., 6., 15., 1., 15., 9., 1., 1., 1., 1., 7., 15., 15., 49., 12., 19., 10., 6., 0., 5., 1., 1., 1., 8., 8., 13., 18., 6., 20., 4., 2., 0., 1., 7., 1., 4., 0., 5., 2., 2., 6., 2., 5., 5., 1., 1., 1., 2., 0., 1., 2., 2., 4., 2., 3., 1., 3., 3., 1., 1., 1., 3., 9., 1., 0., 1., 1., 3., 4., 2., 4., 2., 0., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 4., 2., 11., 3., 5., 1., 4., 14., 1., 12., 24., 0., 11., 2., 1., 1., 15., 2., 6., 18., 13., 17., 29., 8., 0., 0., 4., 0., 10., 8., 20., 17., 1., 15., 3., 14., 8., 1., 0., 2., 2., 12., 6., 11., 49., 6., 29., 6., 1., 1., 6., 1., 8., 3., 13., 6., 9., 22., 4., 27., 8., 6., 0., 0., 6., 1., 5., 0., 3., 3., 3., 3., 1., 7., 4., 2., 2., 1., 2., 0., 0., 2., 1., 4., 2., 3., 3., 6., 2., 2., 1., 2., 4., 5., 0., 0., 4., 0., 2., 7., 1., 3., 2., 3., 5., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 0., 4., 5., 1., 9., 0., 4., 25., 1., 13., 24., 1., 16., 4., 2., 1., 21., 2., 2., 21., 11., 19., 21., 6., 0., 1., 6., 1., 6., 5., 26., 12., 3., 15., 2., 22., 13., 2., 0., 7., 1., 3., 10., 17., 40., 20., 29., 7., 1., 0., 4., 1., 9., 1., 8., 10., 9., 16., 4., 26., 10., 3., 4., 2., 7., 2., 2., 3., 4., 2., 6., 9., 2., 5., 6., 2., 1., 5., 4., 0., 2., 1., 4., 3., 1., 4., 3., 2., 2., 0., 1., 1., 3., 8., 3., 0., 4., 2., 1., 3., 1., 1., 2., 1., 3., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 0., 4., 2., 7., 6., 7., 1., 5., 27., 2., 10., 22., 0., 19., 3., 0., 1., 12., 2., 4., 25., 8., 30., 29., 10., 0., 0., 5., 2., 12., 7., 22., 25., 3., 15., 5., 20., 6., 2., 1., 3., 1., 16., 9., 11., 40., 13., 20., 13., 6., 2., 4., 1., 15., 2., 12., 7., 6., 15., 8., 24., 8., 2., 0., 0., 6., 1., 6., 0., 5., 4., 7., 3., 1., 4., 5., 1., 0., 4., 1., 0., 0., 2., 3., 7., 1., 3., 1., 2., 0., 1., 1., 0., 2., 6., 2., 0., 0., 1., 0., 0., 2., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

15., 2., 0., 4., 8., 0., 9., 2., 11., 22., 1., 10., 27., 2., 16., 2., 0., 4., 18., 1., 1., 23., 14., 32., 16., 6., 0., 2., 1., 1., 4., 11., 27., 17., 1., 13., 6., 18., 5., 1., 0., 5., 1., 11., 10., 20., 50., 14., 24., 13., 2., 1., 5., 0., 7., 4., 15., 5., 7., 16., 6., 24., 8., 1., 1., 0., 3., 1., 3., 1., 7., 6., 5., 2., 1., 3., 3., 0., 4., 2., 2., 0., 3., 2., 2., 4., 3., 4., 1., 3., 7., 2., 1., 1., 2., 10., 5., 0., 1., 2., 3., 2., 6., 3., 2., 0., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 1., 6., 12., 1., 5., 2., 6., 23., 0., 22., 26., 2., 15., 2., 0., 3., 9., 3., 3., 23., 19., 32., 20., 2., 1., 3., 1., 3., 13., 4., 29., 14., 3., 8., 7., 19., 13., 3., 1., 2., 0., 8., 14., 19., 32., 10., 14., 14., 3., 2., 4., 1., 9., 1., 9., 5., 17., 20., 5., 18., 12., 2., 0., 1., 11., 1., 3., 4., 5., 2., 1., 7., 1., 6., 0., 3., 1., 1., 2., 0., 3., 1., 3., 4., 2., 5., 2., 2., 4., 2., 4., 1., 3., 3., 1., 0., 1., 2., 3., 5., 2., 2., 0., 1., 3., 0., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 0., 2., 3., 10., 0., 15., 3., 5., 47., 0., 12., 60., 3., 8., 2., 0., 2., 72., 13., 4., 92., 18., 97., 8., 2., 0., 0., 3., 3., 20., 13., 33., 14., 1., 38., 19., 7., 0., 0., 0., 6., 3., 29., 4., 21., 5., 14., 9., 4., 1., 0., 9., 4., 11., 3., 15., 2., 7., 3., 3., 29., 11., 12., 0., 0., 7., 3., 10., 2., 11., 0., 3., 1., 1., 1., 0., 3., 3., 19., 9., 5., 2., 1., 2., 0., 0., 0., 0., 0., 10., 2., 0., 1., 3., 1., 3., 0., 0., 0., 1., 0., 2., 4., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 0., 0., 0., 4., 0., 5., 0., 0., 0., 0., 27., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 4., 5., 11., 0., 11., 3., 9., 43., 1., 11., 61., 1., 8., 2., 0., 5., 58., 10., 9., 53., 7., 78., 10., 4., 0., 0., 4., 3., 19., 10., 48., 9., 5., 34., 26., 11., 4., 0., 0., 4., 1., 32., 6., 36., 7., 11., 6., 3., 2., 0., 5., 4., 17., 2., 22., 3., 16., 0., 2., 37., 7., 6., 0., 0., 14., 2., 7., 4., 13., 0., 2., 1., 3., 1., 0., 4., 6., 28., 8., 4., 4., 0., 7., 0., 0., 0., 0., 0., 11., 1., 1., 5., 1., 1., 1., 0., 0., 0., 0., 0., 0., 3., 4., 0., 2., 0., 1., 0., 1., 0., 0., 0., 3., 0., 2., 2., 2., 0., 0., 0., 2., 0., 5., 0., 0., 0., 0., 36., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

1., 0., 0., 4., 14., 0., 9., 3., 5., 49., 3., 5., 55., 2., 9., 0., 0., 4., 76., 8., 9., 85., 17., 76., 5., 2., 0., 1., 2., 1., 12., 6., 59., 9., 2., 38., 44., 14., 5., 0., 0., 4., 3., 27., 5., 28., 5., 10., 10., 5., 0., 0., 10., 7., 15., 1., 19., 2., 6., 4., 5., 36., 13., 4., 4., 0., 10., 7., 10., 3., 14., 4., 3., 1., 1., 3., 0., 5., 1., 13., 13., 3., 2., 0., 1., 0., 0., 0., 0., 0., 11., 4., 3., 6., 2., 1., 0., 0., 2., 0., 0., 0., 0., 4., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 5., 0., 3., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 33., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 2., 1., 1., 8., 0., 11., 3., 7., 46., 2., 11., 57., 2., 6., 4., 0., 1., 72., 9., 8., 67., 16., 68., 15., 1., 0., 1., 2., 3., 16., 13., 49., 11., 4., 33., 37., 15., 2., 0., 1., 0., 2., 20., 6., 29., 9., 8., 4., 3., 4., 0., 7., 5., 19., 6., 20., 3., 11., 1., 3., 49., 8., 7., 2., 0., 14., 2., 9., 2., 10., 1., 4., 0., 0., 3., 0., 1., 2., 11., 9., 1., 4., 0., 6., 0., 0., 0., 0., 0., 5., 2., 3., 3., 0., 1., 3., 0., 1., 0., 2., 0., 2., 5., 3., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 23., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 2., 3., 8., 0., 13., 2., 12., 49., 0., 3., 48., 3., 5., 2., 0., 5., 80., 11., 5., 79., 11., 71., 8., 3., 0., 2., 1., 0., 14., 9., 43., 15., 1., 44., 34., 11., 2., 0., 0., 8., 3., 22., 9., 27., 6., 10., 7., 1., 2., 0., 11., 5., 23., 6., 12., 2., 7., 2., 2., 43., 10., 6., 2., 0., 6., 4., 8., 2., 12., 1., 1., 2., 0., 1., 0., 2., 2., 22., 9., 2., 3., 1., 1., 0., 0., 0., 0., 0., 8., 2., 1., 4., 2., 1., 1., 0., 0., 0., 0., 0., 0., 2., 1., 0., 1., 0., 3., 0., 1., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 18., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 2., 5., 6., 0., 13., 4., 6., 42., 2., 5., 55., 3., 6., 1., 0., 4., 76., 5., 10., 88., 12., 86., 4., 4., 0., 2., 2., 2., 13., 13., 39., 12., 2., 37., 29., 11., 8., 0., 2., 9., 4., 27., 3., 17., 12., 11., 8., 0., 0., 0., 11., 4., 20., 8., 14., 3., 8., 4., 2., 47., 10., 5., 2., 0., 22., 3., 9., 3., 13., 8., 4., 1., 1., 1., 0., 8., 2., 15., 13., 2., 4., 1., 4., 0., 0., 0., 0., 0., 13., 2., 2., 5., 1., 1., 2., 0., 0., 0., 2., 0., 0., 3., 3., 0., 1., 0., 1., 0., 2., 0., 0., 0., 0., 0., 3., 2., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 26., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 1., 3., 8., 0., 15., 1., 7., 47., 0., 6., 63., 3., 5., 3., 0., 1., 79., 10., 6., 71., 15., 85., 14., 6., 0., 1., 5., 0., 18., 7., 34., 15., 1., 42., 36., 10., 6., 0., 1., 8., 5., 23., 7., 20., 8., 9., 5., 5., 1., 0., 4., 5., 23., 8., 17., 3., 7., 1., 8., 39., 5., 4., 5., 0., 13., 1., 10., 1., 6., 0., 3., 0., 0., 1., 0., 3., 0., 17., 11., 0., 4., 2., 3., 0., 0., 0., 0., 0., 10., 0., 0., 0., 4., 3., 1., 0., 3., 0., 1., 0., 0., 2., 0., 0., 0., 0., 1., 0., 3., 0., 0., 0., 1., 0., 2., 1., 2., 0., 0., 0., 3., 0., 4., 0., 0., 0., 0., 23., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

19., 0., 4., 6., 8., 0., 16., 7., 7., 39., 0., 3., 70., 1., 5., 3., 0., 3., 62., 11., 11., 54., 14., 74., 11., 7., 0., 2., 1., 0., 12., 5., 66., 17., 2., 44., 33., 17., 4., 0., 0., 7., 7., 24., 8., 24., 4., 15., 3., 2., 2., 0., 10., 7., 22., 4., 14., 2., 8., 2., 4., 48., 6., 5., 0., 0., 9., 4., 6., 3., 12., 0., 4., 2., 0., 0., 0., 3., 2., 22., 8., 3., 4., 0., 1., 0., 0., 0., 0., 0., 11., 5., 6., 2., 3., 1., 1., 0., 2., 0., 1., 0., 0., 5., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 1., 1., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 33., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 2., 3., 12., 0., 15., 2., 8., 69., 0., 5., 59., 1., 5., 2., 0., 4., 65., 10., 7., 76., 14., 74., 17., 4., 0., 0., 0., 2., 11., 15., 55., 12., 1., 33., 34., 14., 4., 0., 2., 6., 0., 24., 8., 35., 11., 11., 2., 2., 0., 0., 6., 6., 13., 4., 15., 2., 5., 0., 4., 35., 8., 5., 4., 0., 15., 1., 7., 1., 7., 3., 5., 1., 1., 1., 0., 0., 2., 20., 7., 3., 2., 0., 5., 0., 0., 0., 0., 0., 9., 1., 4., 1., 4., 3., 1., 0., 1., 0., 0., 0., 1., 3., 1., 0., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 3., 2., 1., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 23., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 0., 14., 0., 19., 2., 7., 45., 2., 9., 61., 1., 4., 1., 0., 5., 62., 8., 3., 81., 17., 87., 11., 2., 0., 1., 2., 1., 15., 12., 48., 10., 1., 43., 39., 14., 6., 0., 0., 6., 2., 29., 4., 24., 8., 13., 7., 2., 2., 0., 8., 2., 13., 5., 15., 3., 7., 2., 4., 42., 7., 8., 1., 0., 13., 3., 6., 4., 9., 4., 7., 0., 1., 1., 0., 2., 4., 17., 7., 1., 1., 2., 2., 0., 0., 0., 0., 0., 13., 5., 2., 1., 3., 1., 0., 0., 3., 0., 1., 0., 2., 3., 2., 0., 2., 0., 0., 0., 1., 0., 0., 0., 2., 0., 0., 2., 4., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 30., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 2., 0., 5., 13., 0., 17., 0., 7., 51., 3., 6., 55., 1., 1., 1., 0., 3., 70., 6., 9., 77., 23., 71., 10., 2., 0., 3., 4., 0., 16., 16., 51., 9., 1., 44., 34., 10., 6., 0., 1., 8., 4., 13., 5., 25., 5., 11., 8., 5., 3., 0., 6., 3., 14., 10., 15., 7., 9., 6., 3., 38., 4., 6., 3., 0., 10., 1., 6., 0., 21., 2., 1., 0., 1., 2., 0., 2., 1., 14., 10., 6., 2., 1., 3., 0., 0., 0., 0., 0., 11., 1., 4., 2., 0., 0., 1., 0., 0., 0., 1., 0., 0., 3., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 4., 3., 0., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 25., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 6., 12., 0., 16., 0., 4., 56., 2., 6., 54., 0., 3., 3., 0., 4., 69., 8., 11., 80., 13., 77., 14., 5., 0., 2., 1., 2., 11., 3., 45., 16., 2., 41., 26., 5., 4., 0., 2., 5., 0., 23., 6., 25., 7., 15., 7., 6., 3., 0., 9., 6., 12., 9., 15., 6., 8., 4., 8., 31., 9., 5., 2., 0., 16., 3., 5., 1., 8., 1., 2., 0., 0., 0., 0., 4., 2., 19., 10., 6., 4., 0., 2., 0., 0., 0., 0., 0., 7., 2., 6., 5., 2., 2., 1., 0., 1., 0., 1., 0., 0., 3., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 2., 2., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 26., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 1., 1., 1., 12., 0., 15., 0., 6., 44., 1., 12., 60., 1., 5., 5., 0., 2., 69., 13., 7., 72., 20., 97., 12., 4., 0., 0., 5., 3., 11., 11., 63., 13., 7., 41., 26., 9., 6., 0., 1., 6., 6., 26., 9., 21., 4., 11., 2., 1., 3., 0., 13., 2., 13., 4., 21., 4., 7., 2., 3., 40., 1., 4., 4., 0., 14., 2., 9., 4., 11., 1., 4., 1., 2., 1., 0., 2., 2., 24., 6., 2., 10., 3., 3., 0., 0., 0., 0., 0., 7., 3., 1., 2., 6., 1., 1., 0., 1., 0., 1., 0., 0., 5., 3., 0., 5., 0., 0., 0., 2., 0., 0., 0., 0., 0., 2., 3., 2., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 24., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 3., 3., 11., 0., 17., 3., 14., 50., 0., 12., 44., 1., 4., 3., 0., 4., 56., 4., 12., 86., 17., 86., 11., 6., 0., 1., 3., 4., 10., 10., 59., 10., 0., 49., 31., 18., 1., 0., 1., 6., 2., 27., 9., 33., 9., 8., 5., 1., 1., 0., 9., 5., 16., 5., 21., 5., 10., 3., 4., 35., 4., 4., 3., 0., 8., 6., 10., 3., 8., 3., 2., 1., 0., 2., 0., 7., 3., 17., 12., 1., 3., 0., 2., 0., 0., 0., 0., 0., 12., 2., 7., 2., 6., 2., 1., 0., 0., 0., 1., 0., 1., 4., 4., 0., 3., 0., 7., 0., 1., 0., 0., 0., 0., 0., 6., 3., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 35., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 3., 2., 12., 0., 17., 4., 6., 47., 1., 9., 65., 1., 2., 0., 0., 1., 83., 5., 9., 67., 16., 76., 12., 5., 0., 1., 2., 1., 14., 8., 46., 14., 4., 44., 35., 14., 5., 0., 3., 7., 1., 24., 5., 15., 7., 12., 7., 1., 1., 0., 7., 7., 13., 0., 17., 4., 5., 5., 3., 45., 11., 10., 2., 0., 17., 2., 7., 4., 13., 2., 6., 0., 1., 1., 0., 6., 3., 15., 8., 4., 6., 0., 3., 0., 0., 0., 0., 0., 11., 2., 3., 5., 1., 2., 2., 0., 3., 0., 1., 0., 1., 4., 2., 0., 1., 0., 2., 0., 2., 0., 0., 0., 0., 0., 4., 4., 1., 0., 0., 0., 1., 0., 7., 0., 0., 0., 0., 24., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

3., 1., 1., 4., 12., 0., 12., 3., 9., 57., 0., 7., 47., 1., 2., 1., 0., 5., 80., 13., 10., 79., 13., 82., 16., 3., 0., 3., 1., 1., 15., 8., 68., 10., 1., 45., 25., 11., 8., 0., 0., 7., 1., 16., 4., 17., 3., 15., 6., 3., 2., 0., 12., 7., 17., 6., 20., 3., 7., 4., 1., 30., 6., 5., 2., 0., 15., 4., 14., 4., 12., 0., 4., 1., 1., 1., 0., 9., 2., 14., 11., 2., 5., 0., 2., 0., 0., 0., 0., 0., 13., 3., 4., 2., 4., 3., 2., 0., 0., 0., 0., 0., 2., 6., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 1., 1., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 28., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 5., 3., 6., 0., 15., 0., 6., 59., 2., 9., 66., 0., 4., 4., 0., 1., 76., 6., 9., 77., 16., 84., 5., 5., 0., 0., 4., 1., 11., 17., 59., 10., 2., 32., 26., 15., 4., 0., 1., 2., 5., 22., 5., 16., 12., 10., 3., 3., 1., 0., 8., 6., 17., 3., 18., 2., 5., 4., 2., 51., 4., 6., 1., 0., 12., 5., 10., 1., 20., 2., 5., 1., 2., 2., 0., 8., 1., 19., 12., 3., 4., 0., 4., 0., 0., 0., 0., 0., 8., 2., 5., 3., 2., 2., 1., 0., 3., 0., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 3., 1., 2., 0., 0., 0., 1., 0., 8., 0., 0., 0., 0., 25., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 2., 3., 13., 0., 19., 4., 5., 52., 0., 7., 46., 1., 5., 3., 0., 3., 77., 11., 6., 83., 14., 88., 8., 4., 0., 1., 4., 3., 22., 16., 56., 14., 0., 39., 36., 11., 11., 0., 1., 7., 2., 18., 6., 32., 6., 9., 3., 3., 1., 0., 3., 5., 16., 6., 17., 3., 12., 3., 2., 37., 5., 6., 2., 0., 22., 4., 5., 0., 11., 3., 3., 0., 6., 2., 0., 5., 0., 18., 11., 3., 4., 0., 1., 0., 0., 0., 0., 0., 7., 1., 4., 1., 1., 1., 1., 0., 0., 0., 1., 0., 1., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 4., 2., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 27., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 0., 2., 4., 13., 0., 9., 3., 5., 58., 0., 8., 59., 0., 7., 2., 0., 0., 65., 10., 11., 92., 15., 92., 11., 4., 0., 3., 6., 3., 10., 9., 40., 17., 1., 22., 35., 13., 4., 0., 0., 6., 2., 31., 6., 21., 6., 14., 6., 3., 2., 0., 15., 6., 14., 6., 19., 5., 10., 3., 3., 38., 6., 3., 3., 0., 13., 3., 7., 2., 4., 0., 1., 3., 0., 1., 0., 2., 2., 16., 11., 3., 4., 1., 5., 0., 0., 0., 0., 0., 6., 1., 3., 2., 3., 1., 1., 0., 0., 0., 1., 0., 1., 2., 5., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 5., 3., 1., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 35., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 0., 7., 16., 0., 13., 1., 10., 51., 1., 5., 46., 1., 8., 3., 0., 4., 62., 12., 5., 65., 22., 74., 11., 2., 0., 0., 2., 3., 13., 10., 49., 17., 0., 37., 43., 14., 6., 0., 1., 7., 1., 29., 3., 21., 9., 12., 5., 3., 1., 0., 8., 3., 16., 11., 15., 2., 9., 4., 7., 27., 8., 9., 1., 0., 11., 8., 11., 1., 10., 2., 3., 2., 0., 0., 0., 4., 2., 17., 10., 3., 6., 1., 2., 0., 0., 0., 0., 0., 8., 2., 4., 0., 3., 2., 1., 0., 2., 0., 0., 0., 0., 1., 1., 0., 4., 0., 1., 0., 0., 0., 0., 0., 2., 0., 0., 3., 2., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 22., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 1., 4., 8., 1., 11., 1., 8., 15., 0., 22., 18., 0., 16., 4., 0., 2., 19., 2., 4., 24., 12., 17., 27., 6., 1., 1., 4., 2., 5., 8., 29., 14., 3., 14., 3., 11., 17., 5., 0., 7., 3., 9., 8., 13., 50., 6., 22., 16., 3., 0., 5., 1., 8., 2., 6., 6., 9., 19., 10., 17., 15., 1., 2., 0., 2., 0., 7., 4., 6., 4., 4., 1., 3., 8., 2., 0., 0., 5., 1., 0., 2., 1., 4., 7., 4., 4., 3., 3., 4., 2., 0., 0., 2., 7., 4., 0., 3., 1., 1., 0., 1., 2., 0., 0., 1., 0., 0., 0., 0., 3., 0., 0., 2., 0., 0., 0., 3., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 4., 3., 7., 3., 3., 0., 5., 19., 3., 11., 19., 1., 13., 3., 2., 2., 15., 4., 2., 30., 13., 25., 39., 4., 1., 3., 5., 3., 8., 4., 21., 20., 3., 15., 4., 13., 7., 2., 0., 1., 0., 11., 8., 16., 59., 21., 24., 12., 5., 5., 5., 4., 5., 5., 13., 5., 8., 16., 5., 22., 9., 5., 1., 2., 4., 0., 2., 2., 3., 4., 4., 2., 1., 1., 2., 0., 3., 5., 4., 0., 4., 5., 2., 7., 3., 2., 3., 0., 6., 0., 0., 2., 1., 5., 3., 0., 0., 2., 2., 5., 2., 3., 2., 2., 5., 0., 0., 0., 0., 2., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

2., 0., 4., 3., 9., 8., 2., 0., 5., 30., 2., 16., 22., 1., 12., 1., 1., 1., 16., 0., 1., 31., 13., 27., 36., 4., 0., 0., 4., 2., 10., 10., 22., 15., 3., 12., 1., 9., 9., 1., 1., 3., 3., 8., 11., 20., 47., 9., 12., 8., 6., 0., 2., 2., 8., 3., 11., 6., 5., 11., 6., 25., 9., 2., 1., 0., 7., 0., 2., 2., 11., 4., 2., 5., 3., 4., 4., 1., 1., 4., 0., 0., 2., 0., 0., 3., 0., 3., 6., 0., 3., 2., 2., 0., 1., 8., 0., 0., 1., 0., 0., 3., 4., 0., 2., 0., 2., 0., 0., 0., 0., 1., 0., 0., 1., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 2., 3., 6., 0., 6., 5., 5., 23., 0., 9., 19., 0., 9., 6., 2., 3., 22., 4., 1., 38., 10., 9., 23., 5., 0., 1., 0., 5., 8., 3., 31., 22., 1., 13., 4., 16., 7., 2., 3., 6., 1., 11., 4., 17., 51., 11., 20., 11., 4., 0., 6., 4., 7., 6., 9., 7., 5., 17., 6., 22., 8., 6., 1., 1., 6., 2., 2., 1., 10., 0., 5., 4., 1., 4., 4., 3., 0., 1., 1., 0., 3., 5., 4., 6., 4., 9., 2., 3., 4., 0., 2., 1., 2., 6., 3., 0., 2., 3., 2., 0., 1., 2., 0., 2., 2., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 2., 4., 9., 2., 3., 2., 4., 32., 1., 8., 17., 2., 21., 2., 1., 3., 31., 3., 2., 15., 13., 22., 37., 5., 3., 0., 2., 2., 5., 3., 26., 11., 2., 14., 3., 14., 7., 4., 0., 8., 3., 6., 13., 16., 58., 7., 18., 7., 4., 0., 8., 1., 8., 3., 17., 3., 3., 11., 5., 23., 7., 3., 1., 0., 4., 1., 1., 2., 8., 1., 8., 5., 0., 10., 2., 1., 1., 1., 0., 0., 2., 1., 3., 9., 4., 2., 3., 4., 4., 0., 3., 0., 1., 5., 2., 0., 3., 2., 3., 0., 3., 2., 1., 1., 2., 0., 0., 0., 0., 3., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 1., 4., 9., 9., 3., 4., 3., 4., 22., 0., 15., 19., 0., 16., 1., 0., 2., 11., 4., 3., 34., 17., 20., 30., 5., 0., 1., 3., 1., 11., 3., 20., 17., 1., 11., 7., 14., 11., 4., 0., 3., 2., 20., 8., 10., 56., 12., 19., 7., 6., 2., 7., 0., 6., 3., 15., 2., 7., 19., 4., 24., 9., 3., 1., 3., 4., 0., 4., 1., 6., 4., 5., 6., 0., 2., 1., 0., 2., 1., 4., 0., 2., 1., 2., 4., 3., 1., 5., 0., 3., 0., 4., 1., 1., 7., 1., 0., 1., 5., 2., 4., 1., 0., 3., 0., 2., 0., 0., 0., 0., 4., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 7., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 0., 3., 11., 1., 8., 0., 4., 20., 0., 10., 22., 1., 15., 2., 2., 0., 18., 2., 5., 14., 15., 28., 29., 6., 0., 0., 2., 2., 11., 10., 21., 13., 4., 15., 1., 13., 12., 6., 0., 5., 2., 20., 9., 18., 46., 6., 31., 8., 4., 1., 11., 6., 9., 3., 11., 5., 4., 10., 11., 27., 12., 2., 0., 1., 3., 2., 1., 1., 3., 1., 0., 6., 2., 5., 2., 2., 0., 4., 3., 0., 1., 1., 0., 6., 0., 5., 5., 1., 5., 0., 1., 0., 1., 12., 3., 0., 1., 5., 2., 2., 4., 1., 0., 1., 3., 0., 0., 0., 0., 1., 0., 0., 4., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 4., 2., 9., 2., 7., 1., 11., 5., 2., 11., 37., 3., 14., 3., 1., 0., 10., 3., 3., 21., 15., 31., 18., 6., 4., 0., 8., 1., 8., 6., 33., 18., 4., 19., 6., 15., 8., 2., 2., 4., 3., 12., 15., 21., 49., 19., 24., 6., 1., 0., 5., 4., 6., 3., 7., 5., 7., 14., 2., 27., 6., 2., 0., 3., 8., 1., 5., 2., 3., 4., 5., 1., 0., 2., 3., 3., 0., 2., 3., 0., 2., 2., 3., 4., 3., 6., 2., 3., 3., 1., 1., 2., 3., 2., 4., 0., 2., 2., 3., 1., 1., 1., 2., 1., 0., 0., 0., 0., 0., 2., 0., 0., 5., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 5., 4., 9., 3., 6., 1., 12., 20., 0., 9., 14., 0., 10., 4., 1., 2., 15., 1., 1., 29., 15., 14., 32., 6., 1., 2., 3., 2., 9., 3., 36., 13., 1., 17., 8., 12., 10., 3., 1., 2., 2., 13., 9., 14., 49., 3., 14., 9., 3., 1., 8., 2., 8., 2., 13., 6., 5., 19., 11., 21., 8., 3., 2., 1., 7., 1., 6., 3., 5., 3., 5., 10., 1., 5., 4., 2., 1., 1., 5., 0., 2., 1., 1., 12., 1., 6., 7., 2., 4., 0., 5., 0., 1., 9., 0., 0., 2., 3., 0., 3., 2., 1., 3., 0., 1., 0., 0., 0., 0., 2., 0., 0., 2., 0., 0., 0., 5., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

18., 1., 1., 5., 19., 0., 16., 1., 7., 41., 1., 7., 45., 3., 2., 5., 0., 4., 66., 8., 6., 72., 16., 79., 11., 5., 0., 0., 4., 2., 26., 9., 49., 11., 1., 44., 28., 18., 6., 0., 0., 5., 4., 12., 5., 24., 6., 12., 6., 5., 2., 0., 11., 3., 7., 10., 18., 2., 5., 1., 2., 37., 13., 6., 2., 0., 10., 5., 16., 3., 14., 4., 4., 2., 2., 3., 0., 5., 3., 13., 10., 2., 5., 1., 3., 0., 0., 0., 0., 0., 10., 1., 8., 4., 2., 1., 0., 0., 0., 0., 4., 0., 3., 1., 1., 0., 1., 0., 2., 0., 0., 0., 0., 0., 2., 0., 4., 2., 3., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 23., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 0., 2., 13., 0., 5., 1., 3., 56., 0., 10., 61., 2., 5., 7., 0., 0., 75., 7., 9., 72., 16., 74., 13., 3., 0., 1., 2., 1., 17., 14., 60., 15., 1., 41., 27., 11., 6., 0., 1., 5., 2., 33., 9., 26., 12., 11., 5., 3., 3., 0., 10., 4., 17., 8., 19., 1., 9., 4., 5., 51., 10., 3., 2., 0., 9., 4., 10., 1., 10., 1., 3., 2., 2., 1., 0., 5., 2., 14., 5., 2., 0., 0., 4., 0., 0., 0., 0., 0., 5., 2., 2., 4., 2., 1., 0., 0., 2., 0., 0., 0., 2., 2., 7., 0., 1., 0., 3., 0., 0., 0., 0., 0., 1., 0., 5., 1., 2., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 28., 0., 2., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 2., 4., 12., 0., 14., 3., 9., 46., 1., 3., 56., 1., 8., 1., 0., 2., 68., 14., 11., 80., 11., 80., 12., 1., 0., 1., 1., 1., 13., 14., 53., 10., 1., 32., 26., 9., 5., 0., 0., 5., 7., 15., 3., 23., 4., 8., 5., 4., 3., 0., 10., 2., 9., 3., 20., 0., 5., 6., 3., 36., 8., 10., 1., 0., 11., 5., 7., 0., 8., 2., 5., 4., 1., 0., 0., 7., 3., 20., 6., 7., 2., 5., 4., 0., 0., 0., 0., 0., 5., 2., 5., 3., 4., 2., 1., 0., 1., 0., 1., 0., 0., 2., 1., 0., 0., 0., 2., 0., 4., 0., 0., 0., 1., 0., 2., 0., 3., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 23., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 1., 2., 7., 0., 14., 1., 6., 45., 1., 10., 55., 0., 2., 6., 0., 0., 71., 13., 12., 53., 17., 87., 13., 7., 0., 0., 4., 2., 11., 6., 49., 17., 0., 33., 29., 18., 3., 0., 0., 4., 5., 28., 7., 37., 6., 15., 7., 0., 1., 0., 10., 5., 14., 5., 17., 0., 10., 4., 5., 37., 6., 6., 2., 0., 14., 3., 4., 2., 8., 3., 2., 2., 2., 1., 0., 5., 2., 13., 16., 8., 4., 3., 3., 0., 0., 0., 0., 0., 8., 1., 3., 2., 3., 1., 1., 0., 0., 0., 1., 0., 2., 1., 3., 0., 0., 0., 1., 0., 2., 0., 0., 0., 1., 0., 1., 3., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 15., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 1., 3., 4., 15., 0., 13., 0., 11., 59., 2., 9., 54., 1., 3., 5., 0., 2., 61., 5., 12., 71., 12., 87., 11., 2., 0., 0., 3., 2., 15., 7., 46., 11., 1., 47., 35., 14., 5., 0., 2., 4., 2., 21., 7., 25., 15., 14., 6., 2., 2., 0., 10., 6., 18., 11., 9., 5., 11., 0., 1., 35., 5., 6., 6., 0., 9., 3., 4., 1., 13., 3., 1., 0., 1., 3., 0., 7., 5., 18., 11., 3., 1., 3., 3., 0., 0., 0., 0., 0., 14., 1., 1., 1., 2., 1., 1., 0., 1., 0., 1., 0., 2., 6., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 1., 0., 1., 1., 3., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 18., 0., 5., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 4., 3., 13., 0., 10., 3., 4., 54., 1., 10., 57., 1., 2., 4., 0., 1., 70., 11., 12., 69., 15., 89., 7., 5., 0., 0., 4., 0., 14., 11., 39., 7., 1., 38., 20., 18., 9., 0., 2., 5., 2., 21., 12., 26., 8., 16., 7., 4., 0., 0., 12., 7., 15., 8., 14., 0., 7., 3., 3., 39., 16., 8., 5., 0., 17., 2., 5., 1., 14., 0., 7., 0., 0., 0., 0., 4., 1., 19., 8., 2., 2., 1., 4., 0., 0., 0., 0., 0., 9., 0., 5., 4., 4., 0., 1., 0., 1., 0., 1., 0., 0., 3., 1., 0., 2., 0., 1., 0., 0., 0., 0., 0., 1., 0., 1., 3., 4., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 33., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 1., 3., 7., 0., 12., 3., 9., 45., 0., 6., 47., 2., 2., 3., 0., 1., 74., 12., 6., 66., 11., 80., 16., 7., 0., 2., 3., 3., 12., 10., 42., 14., 0., 37., 40., 14., 5., 0., 2., 7., 2., 18., 8., 25., 7., 15., 8., 2., 5., 0., 7., 5., 12., 4., 13., 1., 6., 1., 4., 48., 13., 8., 5., 0., 13., 5., 10., 4., 10., 3., 4., 0., 1., 0., 0., 2., 2., 21., 5., 3., 5., 0., 5., 0., 0., 0., 0., 0., 7., 3., 3., 5., 1., 2., 0., 0., 0., 0., 1., 0., 0., 4., 1., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 4., 4., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 22., 0., 4., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 3., 2., 3., 14., 0., 15., 1., 6., 29., 0., 9., 64., 0., 3., 4., 0., 1., 75., 10., 10., 68., 16., 86., 16., 5., 0., 0., 4., 1., 14., 12., 58., 12., 2., 35., 46., 18., 4., 0., 0., 6., 2., 23., 8., 25., 8., 4., 7., 3., 3., 0., 15., 3., 17., 3., 10., 4., 10., 1., 3., 24., 16., 8., 1., 0., 13., 1., 7., 0., 12., 7., 1., 2., 1., 0., 0., 3., 3., 13., 7., 6., 7., 2., 0., 0., 0., 0., 0., 0., 10., 3., 3., 2., 3., 0., 1., 0., 0., 0., 2., 0., 1., 0., 1., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 13., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 2., 2., 4., 0., 17., 0., 3., 38., 1., 6., 51., 0., 4., 5., 0., 4., 55., 9., 9., 72., 15., 84., 17., 4., 0., 0., 5., 4., 14., 8., 53., 13., 5., 46., 38., 14., 2., 0., 0., 6., 2., 37., 9., 30., 7., 12., 8., 2., 1., 0., 10., 4., 20., 5., 17., 2., 10., 6., 3., 34., 8., 5., 3., 0., 14., 2., 6., 1., 15., 2., 6., 2., 0., 2., 0., 4., 0., 10., 11., 0., 5., 0., 0., 0., 0., 0., 0., 0., 6., 0., 3., 2., 8., 2., 1., 0., 0., 0., 1., 0., 1., 5., 1., 0., 2., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 30., 0., 3., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 1., 0., 5., 15., 0., 17., 1., 3., 48., 2., 8., 68., 0., 8., 3., 0., 3., 83., 6., 8., 66., 22., 76., 14., 2., 0., 0., 5., 1., 17., 13., 41., 12., 3., 37., 39., 8., 4., 0., 2., 3., 1., 19., 7., 27., 5., 10., 4., 5., 1., 0., 14., 0., 25., 6., 19., 5., 10., 3., 6., 31., 6., 8., 1., 0., 13., 3., 12., 2., 10., 2., 5., 0., 1., 1., 0., 7., 2., 12., 5., 1., 2., 0., 2., 0., 0., 0., 0., 0., 6., 2., 4., 2., 4., 0., 0., 0., 1., 0., 0., 0., 0., 2., 2., 0., 1., 0., 1., 0., 2., 0., 0., 0., 1., 0., 1., 1., 2., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 23., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

17., 0., 3., 4., 21., 0., 14., 4., 6., 54., 3., 4., 77., 2., 4., 2., 0., 1., 75., 9., 8., 65., 14., 85., 8., 5., 0., 0., 2., 2., 20., 8., 58., 9., 0., 38., 27., 10., 3., 0., 2., 5., 3., 29., 7., 17., 6., 8., 7., 3., 5., 0., 4., 3., 9., 4., 21., 5., 3., 1., 3., 31., 8., 7., 2., 0., 14., 1., 13., 4., 7., 1., 4., 2., 2., 2., 0., 5., 5., 13., 10., 3., 4., 1., 3., 0., 0., 0., 0., 0., 21., 1., 1., 2., 1., 2., 0., 0., 2., 0., 0., 0., 0., 5., 3., 0., 2., 0., 2., 0., 0., 0., 0., 0., 1., 0., 2., 5., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 26., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 1., 6., 15., 0., 23., 1., 4., 56., 1., 6., 58., 0., 8., 4., 0., 2., 74., 9., 8., 73., 5., 62., 17., 1., 0., 1., 4., 3., 15., 8., 58., 19., 3., 52., 27., 23., 4., 0., 1., 7., 5., 23., 0., 26., 4., 5., 8., 3., 1., 0., 8., 5., 14., 4., 20., 1., 11., 2., 7., 51., 10., 7., 1., 0., 14., 3., 5., 0., 14., 1., 4., 0., 1., 0., 0., 6., 4., 17., 10., 4., 5., 2., 5., 0., 0., 0., 0., 0., 5., 3., 4., 0., 4., 1., 1., 0., 1., 0., 0., 0., 1., 4., 4., 0., 0., 0., 1., 0., 1., 0., 0., 0., 3., 0., 0., 0., 2., 0., 0., 0., 0., 0., 7., 0., 0., 0., 0., 15., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 3., 6., 13., 0., 14., 3., 9., 49., 0., 10., 50., 0., 10., 1., 0., 0., 67., 19., 7., 81., 13., 72., 12., 0., 0., 5., 1., 2., 14., 13., 65., 7., 1., 52., 30., 11., 10., 0., 1., 9., 1., 23., 4., 26., 10., 13., 4., 4., 1., 0., 6., 5., 17., 4., 16., 2., 10., 7., 2., 38., 13., 6., 1., 0., 14., 2., 8., 1., 9., 1., 6., 0., 0., 1., 0., 4., 3., 25., 8., 3., 8., 2., 5., 0., 0., 0., 0., 0., 10., 3., 5., 3., 3., 1., 2., 0., 3., 0., 3., 0., 0., 2., 3., 0., 2., 0., 0., 0., 2., 0., 0., 0., 1., 0., 1., 4., 0., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 31., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 0., 4., 14., 0., 13., 0., 4., 53., 1., 6., 56., 1., 5., 0., 0., 4., 75., 7., 13., 73., 7., 95., 18., 6., 0., 1., 4., 4., 16., 8., 48., 14., 5., 41., 45., 10., 4., 0., 1., 3., 4., 23., 6., 36., 12., 11., 6., 4., 2., 0., 12., 4., 10., 5., 31., 3., 12., 2., 4., 34., 11., 10., 2., 0., 13., 2., 4., 3., 6., 1., 1., 0., 1., 2., 0., 5., 0., 17., 7., 3., 5., 1., 3., 0., 0., 0., 0., 0., 15., 1., 2., 2., 2., 0., 0., 0., 2., 0., 0., 0., 2., 5., 0., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 0., 2., 2., 5., 0., 0., 0., 1., 0., 10., 0., 0., 0., 0., 20., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 4., 3., 11., 0., 13., 2., 10., 55., 1., 8., 57., 1., 7., 2., 0., 3., 65., 10., 13., 74., 20., 66., 8., 7., 0., 1., 6., 2., 22., 6., 58., 11., 0., 40., 30., 19., 8., 0., 2., 3., 3., 17., 8., 18., 10., 13., 8., 4., 4., 0., 9., 6., 11., 6., 20., 4., 9., 5., 1., 32., 8., 13., 3., 0., 14., 2., 9., 6., 10., 1., 4., 1., 0., 0., 0., 4., 2., 17., 3., 2., 5., 1., 1., 0., 0., 0., 0., 0., 13., 1., 3., 0., 4., 1., 1., 0., 0., 0., 3., 0., 0., 3., 0., 0., 3., 0., 1., 0., 1., 0., 0., 0., 2., 0., 1., 1., 2., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 22., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 2., 2., 3., 10., 0., 17., 1., 8., 44., 0., 8., 47., 2., 4., 3., 0., 2., 63., 6., 9., 78., 16., 80., 17., 5., 0., 1., 3., 3., 21., 3., 61., 16., 2., 42., 33., 17., 4., 0., 0., 7., 3., 19., 5., 22., 7., 7., 7., 2., 3., 0., 6., 6., 18., 3., 16., 5., 5., 6., 4., 30., 6., 12., 3., 0., 13., 4., 9., 2., 13., 1., 1., 2., 1., 1., 0., 8., 2., 14., 7., 1., 2., 2., 7., 0., 0., 0., 0., 0., 6., 2., 3., 0., 3., 0., 1., 0., 1., 0., 1., 0., 2., 2., 1., 0., 2., 0., 0., 0., 1., 0., 0., 0., 1., 0., 1., 2., 2., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 26., 0., 1., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 1., 4., 16., 0., 13., 1., 4., 57., 2., 5., 65., 0., 5., 2., 0., 0., 62., 7., 9., 69., 16., 87., 8., 3., 0., 0., 5., 3., 14., 9., 52., 15., 0., 29., 36., 13., 1., 0., 1., 5., 2., 26., 3., 15., 5., 10., 3., 7., 2., 0., 13., 5., 19., 5., 16., 1., 6., 3., 3., 31., 11., 9., 1., 0., 19., 7., 6., 2., 14., 3., 2., 0., 2., 0., 0., 6., 1., 22., 6., 0., 7., 1., 1., 0., 0., 0., 0., 0., 18., 3., 2., 0., 2., 0., 4., 0., 3., 0., 1., 0., 0., 3., 2., 0., 1., 0., 2., 0., 2., 0., 0., 0., 0., 0., 1., 2., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 25., 0., 3., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 4., 4., 12., 0., 9., 2., 9., 52., 2., 11., 44., 2., 2., 4., 0., 7., 66., 12., 8., 82., 15., 89., 11., 12., 0., 0., 6., 2., 10., 9., 43., 14., 2., 40., 34., 10., 6., 0., 2., 6., 2., 23., 4., 21., 14., 11., 8., 4., 1., 0., 15., 0., 13., 5., 17., 5., 6., 1., 4., 45., 8., 11., 2., 0., 14., 2., 11., 1., 10., 4., 7., 1., 0., 2., 0., 2., 1., 11., 4., 4., 4., 0., 2., 0., 0., 0., 0., 0., 2., 2., 2., 1., 1., 0., 0., 0., 0., 0., 0., 0., 3., 3., 1., 0., 0., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 1., 2., 0., 0., 0., 2., 0., 3., 0., 0., 0., 0., 26., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

13., 1., 1., 4., 4., 0., 11., 3., 8., 63., 0., 8., 54., 0., 1., 2., 0., 3., 82., 5., 10., 73., 17., 74., 16., 0., 0., 0., 4., 0., 13., 10., 63., 14., 0., 32., 30., 10., 9., 0., 0., 1., 3., 22., 3., 21., 7., 13., 10., 6., 2., 0., 9., 2., 27., 4., 23., 2., 12., 3., 1., 32., 13., 8., 2., 0., 15., 4., 12., 1., 8., 4., 4., 1., 0., 1., 0., 1., 2., 15., 12., 1., 3., 0., 2., 0., 0., 0., 0., 0., 10., 1., 5., 2., 2., 1., 2., 0., 4., 0., 0., 0., 3., 2., 2., 0., 2., 0., 2., 0., 1., 0., 0., 0., 1., 0., 3., 1., 5., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 31., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 5., 11., 0., 11., 3., 5., 52., 2., 9., 68., 2., 8., 1., 0., 0., 79., 13., 7., 81., 14., 90., 11., 4., 0., 0., 5., 2., 16., 10., 51., 10., 3., 43., 32., 10., 6., 0., 3., 10., 4., 15., 9., 15., 2., 7., 6., 4., 2., 0., 7., 7., 18., 3., 12., 3., 11., 1., 2., 33., 11., 12., 2., 0., 15., 2., 19., 1., 5., 0., 1., 1., 0., 2., 0., 9., 1., 12., 9., 4., 3., 1., 4., 0., 0., 0., 0., 0., 4., 7., 5., 1., 2., 0., 3., 0., 1., 0., 1., 0., 0., 1., 3., 0., 2., 0., 2., 0., 1., 0., 0., 0., 2., 0., 1., 4., 4., 0., 0., 0., 0., 0., 7., 0., 0., 0., 0., 30., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 3., 1., 13., 0., 19., 1., 4., 40., 3., 4., 64., 3., 4., 0., 0., 2., 82., 6., 7., 74., 13., 90., 10., 1., 0., 2., 3., 3., 16., 17., 64., 12., 1., 41., 30., 14., 4., 0., 0., 4., 2., 19., 7., 23., 5., 8., 8., 1., 0., 0., 10., 4., 14., 4., 15., 3., 10., 5., 2., 29., 13., 1., 4., 0., 10., 2., 5., 5., 10., 0., 4., 1., 4., 1., 0., 5., 0., 19., 7., 3., 4., 1., 4., 0., 0., 0., 0., 0., 5., 2., 0., 1., 4., 2., 2., 0., 0., 0., 1., 0., 0., 2., 0., 0., 0., 0., 2., 0., 1., 0., 0., 0., 2., 0., 1., 0., 1., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 24., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 3., 1., 5., 15., 0., 12., 1., 7., 47., 0., 10., 51., 3., 5., 2., 0., 1., 74., 9., 4., 73., 23., 90., 8., 2., 0., 2., 0., 1., 13., 11., 48., 13., 2., 29., 37., 15., 1., 0., 1., 8., 6., 25., 4., 23., 11., 14., 11., 2., 6., 0., 9., 7., 15., 3., 22., 4., 3., 0., 0., 30., 10., 6., 2., 0., 9., 3., 7., 1., 11., 6., 5., 0., 1., 0., 0., 5., 4., 16., 11., 1., 5., 0., 2., 0., 0., 0., 0., 0., 9., 2., 4., 2., 3., 1., 0., 0., 0., 0., 1., 0., 1., 1., 3., 0., 0., 0., 1., 0., 1., 0., 0., 0., 1., 0., 2., 1., 3., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 26., 0., 2., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 2., 5., 8., 0., 11., 4., 6., 64., 1., 4., 59., 0., 4., 1., 0., 1., 59., 8., 8., 67., 19., 74., 10., 3., 0., 0., 3., 2., 13., 9., 56., 7., 1., 53., 37., 17., 2., 0., 2., 10., 1., 23., 2., 15., 7., 10., 8., 1., 1., 0., 10., 3., 22., 5., 16., 3., 6., 5., 5., 37., 5., 8., 0., 0., 18., 4., 7., 0., 5., 1., 3., 1., 1., 1., 0., 4., 3., 9., 9., 1., 4., 6., 3., 0., 0., 0., 0., 0., 11., 0., 5., 0., 4., 3., 2., 0., 0., 0., 1., 0., 1., 3., 2., 0., 2., 0., 4., 0., 2., 0., 0., 0., 2., 0., 0., 1., 3., 0., 0., 0., 2., 0., 7., 0., 0., 0., 0., 19., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 2., 2., 2., 9., 4., 4., 0., 1., 13., 1., 15., 27., 1., 12., 4., 1., 0., 20., 1., 4., 16., 14., 17., 20., 4., 0., 0., 2., 0., 10., 7., 23., 18., 5., 13., 3., 16., 5., 1., 1., 5., 3., 11., 14., 28., 38., 11., 28., 16., 2., 2., 7., 2., 2., 2., 5., 9., 6., 15., 4., 17., 3., 3., 1., 1., 5., 2., 5., 3., 4., 6., 2., 7., 1., 1., 4., 2., 0., 0., 2., 0., 0., 2., 1., 3., 3., 0., 1., 2., 2., 1., 2., 0., 0., 8., 2., 0., 2., 3., 3., 2., 0., 1., 0., 1., 3., 0., 0., 0., 0., 6., 0., 0., 1., 0., 0., 0., 1., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 3., 3., 8., 3., 6., 0., 3., 35., 1., 12., 24., 1., 12., 3., 0., 1., 15., 2., 5., 31., 7., 21., 32., 6., 3., 2., 3., 4., 7., 11., 20., 14., 3., 15., 2., 16., 9., 4., 0., 7., 1., 11., 14., 16., 44., 6., 28., 11., 6., 2., 2., 2., 7., 4., 16., 4., 3., 10., 5., 18., 7., 1., 0., 1., 14., 0., 1., 1., 8., 3., 4., 5., 1., 3., 3., 3., 3., 0., 2., 0., 0., 0., 2., 4., 3., 5., 4., 3., 5., 1., 4., 0., 2., 4., 3., 0., 1., 6., 4., 3., 3., 4., 2., 1., 0., 0., 0., 0., 0., 2., 0., 0., 3., 0., 0., 0., 7., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 1., 1., 4., 4., 4., 7., 1., 7., 23., 2., 13., 25., 1., 9., 2., 2., 5., 15., 2., 5., 9., 8., 31., 27., 5., 1., 1., 2., 2., 12., 5., 28., 17., 2., 13., 3., 15., 8., 4., 2., 2., 2., 15., 12., 15., 41., 10., 27., 10., 7., 1., 3., 3., 3., 1., 16., 10., 8., 15., 6., 17., 9., 3., 3., 3., 4., 0., 4., 0., 7., 2., 1., 2., 0., 4., 1., 0., 0., 4., 2., 0., 4., 1., 1., 2., 2., 4., 2., 2., 4., 0., 3., 0., 2., 10., 1., 0., 3., 1., 2., 1., 3., 3., 3., 1., 0., 0., 0., 0., 0., 3., 0., 0., 4., 0., 0., 0., 4., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 4., 12., 2., 2., 0., 4., 19., 1., 6., 15., 1., 13., 2., 0., 2., 7., 1., 2., 29., 17., 22., 25., 4., 2., 1., 5., 4., 12., 5., 24., 16., 5., 20., 1., 18., 11., 0., 1., 3., 5., 7., 10., 28., 50., 11., 13., 11., 4., 0., 5., 3., 2., 0., 13., 15., 7., 16., 4., 16., 6., 2., 1., 2., 3., 1., 4., 2., 6., 1., 4., 4., 2., 2., 2., 4., 0., 2., 1., 0., 5., 0., 2., 6., 1., 4., 2., 3., 3., 1., 4., 0., 1., 3., 1., 0., 4., 1., 1., 5., 1., 3., 4., 1., 3., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 2., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 0., 4., 4., 2., 8., 3., 6., 30., 0., 18., 21., 1., 14., 4., 1., 2., 15., 4., 4., 21., 14., 28., 34., 2., 0., 0., 3., 3., 9., 7., 14., 13., 1., 17., 5., 15., 8., 3., 1., 1., 3., 13., 13., 17., 38., 14., 16., 9., 3., 0., 1., 3., 4., 4., 16., 9., 5., 10., 8., 24., 5., 3., 0., 1., 7., 2., 4., 3., 9., 3., 4., 7., 2., 1., 2., 2., 0., 3., 3., 0., 0., 4., 3., 6., 2., 7., 1., 4., 3., 3., 4., 2., 2., 6., 2., 0., 5., 3., 1., 0., 1., 7., 0., 0., 1., 0., 0., 0., 0., 1., 0., 0., 5., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 3., 0., 4., 10., 5., 8., 1., 4., 22., 0., 11., 17., 1., 17., 3., 1., 2., 27., 0., 6., 30., 13., 23., 29., 7., 0., 0., 1., 0., 6., 3., 24., 11., 5., 8., 5., 12., 11., 0., 0., 2., 5., 10., 13., 22., 39., 8., 21., 12., 2., 3., 3., 2., 12., 3., 6., 6., 5., 15., 12., 21., 6., 1., 2., 0., 7., 0., 2., 1., 7., 5., 5., 5., 2., 4., 2., 2., 2., 3., 3., 0., 4., 1., 1., 4., 2., 5., 4., 2., 4., 1., 5., 0., 1., 7., 2., 0., 2., 5., 1., 2., 5., 1., 2., 1., 1., 0., 0., 0., 0., 4., 0., 0., 4., 0., 0., 0., 3., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 7., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 1., 2., 2., 13., 0., 14., 1., 8., 46., 0., 6., 48., 0., 4., 2., 0., 2., 54., 9., 9., 83., 12., 84., 8., 5., 0., 1., 2., 4., 12., 7., 64., 15., 0., 31., 31., 17., 5., 0., 1., 5., 3., 37., 6., 22., 9., 9., 4., 4., 3., 0., 13., 4., 15., 3., 12., 6., 7., 6., 4., 33., 6., 5., 1., 0., 13., 2., 9., 3., 14., 2., 6., 0., 0., 1., 0., 3., 3., 16., 15., 4., 5., 1., 3., 0., 0., 0., 0., 0., 10., 3., 1., 1., 1., 0., 3., 0., 1., 0., 0., 0., 1., 4., 2., 0., 0., 0., 1., 0., 3., 0., 0., 0., 3., 0., 0., 0., 5., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 22., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 3., 3., 7., 10., 0., 13., 2., 5., 58., 1., 10., 63., 0., 10., 3., 0., 4., 72., 8., 9., 100., 8., 83., 14., 2., 0., 1., 4., 3., 13., 12., 55., 13., 3., 39., 30., 16., 5., 0., 0., 9., 1., 21., 7., 18., 5., 13., 7., 1., 0., 0., 7., 4., 21., 6., 16., 3., 3., 5., 5., 34., 1., 7., 5., 0., 11., 3., 10., 3., 7., 2., 4., 1., 3., 1., 0., 6., 0., 15., 6., 6., 4., 0., 3., 0., 0., 0., 0., 0., 11., 2., 1., 1., 2., 1., 0., 0., 1., 0., 0., 0., 1., 0., 1., 0., 2., 0., 1., 0., 3., 0., 0., 0., 0., 0., 2., 2., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 31., 0., 3., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 0., 1., 7., 8., 0., 13., 1., 4., 55., 1., 7., 62., 1., 5., 2., 0., 2., 72., 16., 10., 68., 21., 88., 12., 2., 0., 0., 4., 2., 13., 10., 65., 14., 1., 41., 25., 8., 9., 0., 0., 10., 5., 16., 4., 22., 4., 15., 5., 3., 1., 0., 5., 7., 6., 3., 15., 1., 7., 4., 0., 41., 8., 7., 2., 0., 15., 1., 4., 0., 19., 0., 6., 1., 2., 2., 0., 8., 2., 20., 9., 0., 1., 0., 4., 0., 0., 0., 0., 0., 11., 1., 1., 2., 6., 1., 2., 0., 0., 0., 0., 0., 0., 7., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 2., 0., 1., 1., 3., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 33., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 4., 1., 7., 15., 0., 16., 1., 10., 66., 0., 12., 48., 0., 2., 2., 0., 1., 54., 9., 6., 64., 11., 71., 14., 4., 0., 3., 2., 0., 9., 9., 48., 11., 1., 32., 27., 15., 5., 0., 0., 8., 2., 32., 7., 19., 3., 12., 3., 1., 1., 0., 11., 3., 20., 5., 19., 5., 6., 5., 6., 34., 5., 8., 2., 0., 11., 5., 7., 3., 10., 2., 3., 0., 1., 0., 0., 4., 3., 20., 14., 5., 7., 2., 4., 0., 0., 0., 0., 0., 6., 4., 6., 3., 4., 1., 1., 0., 1., 0., 0., 0., 1., 6., 2., 0., 0., 0., 1., 0., 1., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 1., 0., 7., 0., 0., 0., 0., 23., 0., 3., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

17., 0., 1., 6., 13., 0., 15., 0., 3., 47., 0., 8., 54., 1., 7., 1., 0., 0., 67., 11., 6., 80., 15., 82., 13., 3., 0., 0., 3., 2., 27., 12., 55., 13., 1., 51., 26., 17., 6., 0., 1., 1., 1., 24., 4., 19., 7., 10., 5., 4., 2., 0., 7., 5., 22., 7., 15., 0., 7., 2., 0., 42., 5., 5., 3., 0., 10., 3., 4., 2., 10., 2., 3., 2., 0., 1., 0., 7., 3., 11., 7., 1., 4., 1., 5., 0., 0., 0., 0., 0., 9., 3., 4., 3., 1., 3., 3., 0., 1., 0., 0., 0., 1., 4., 4., 0., 2., 0., 1., 0., 2., 0., 0., 0., 2., 0., 2., 0., 1., 0., 0., 0., 1., 0., 4., 0., 0., 0., 0., 25., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 0., 2., 4., 14., 0., 16., 1., 5., 39., 2., 7., 71., 0., 2., 0., 0., 2., 56., 6., 3., 74., 11., 89., 15., 1., 0., 0., 5., 1., 14., 12., 50., 8., 3., 57., 44., 20., 3., 0., 1., 12., 5., 19., 12., 23., 3., 12., 9., 3., 1., 0., 7., 5., 25., 8., 18., 1., 9., 3., 4., 41., 8., 6., 2., 0., 14., 1., 8., 1., 11., 3., 6., 1., 1., 2., 0., 6., 1., 12., 9., 3., 3., 2., 5., 0., 0., 0., 0., 0., 5., 6., 4., 1., 3., 1., 4., 0., 1., 0., 0., 0., 0., 2., 2., 0., 2., 0., 0., 0., 3., 0., 0., 0., 1., 0., 2., 1., 1., 0., 0., 0., 0., 0., 4., 0., 0., 0., 0., 27., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 2., 1., 3., 11., 0., 10., 1., 7., 48., 0., 10., 42., 1., 6., 2., 0., 0., 69., 9., 7., 95., 12., 107., 10., 3., 0., 3., 6., 3., 17., 8., 54., 13., 0., 45., 39., 19., 5., 0., 0., 7., 9., 11., 6., 27., 6., 14., 5., 6., 1., 0., 6., 6., 14., 4., 11., 3., 14., 0., 1., 40., 9., 5., 4., 0., 14., 4., 9., 0., 19., 2., 6., 2., 1., 0., 0., 2., 3., 18., 6., 4., 4., 0., 0., 0., 0., 0., 0., 0., 5., 5., 1., 1., 4., 2., 2., 0., 0., 0., 2., 0., 3., 3., 2., 0., 6., 0., 0., 0., 1., 0., 0., 0., 3., 0., 4., 1., 2., 0., 0., 0., 0., 0., 3., 0., 0., 0., 0., 26., 0., 4., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

10., 0., 1., 2., 7., 0., 10., 0., 4., 41., 0., 10., 47., 2., 6., 5., 0., 0., 71., 4., 7., 70., 12., 64., 10., 2., 0., 0., 1., 2., 15., 12., 48., 10., 2., 46., 31., 8., 11., 0., 2., 3., 5., 23., 4., 29., 15., 13., 10., 2., 1., 0., 10., 5., 20., 5., 18., 3., 6., 3., 2., 32., 7., 5., 2., 0., 16., 3., 6., 3., 6., 2., 4., 0., 0., 1., 0., 6., 3., 13., 16., 3., 4., 1., 3., 0., 0., 0., 0., 0., 5., 2., 2., 2., 3., 0., 1., 0., 3., 0., 3., 0., 1., 2., 3., 0., 2., 0., 1., 0., 0., 0., 0., 0., 1., 0., 1., 2., 1., 0., 0., 0., 0., 0., 6., 0., 0., 0., 0., 27., 0., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 2., 3., 14., 0., 14., 6., 4., 54., 1., 8., 75., 2., 2., 2., 0., 3., 64., 11., 11., 87., 13., 87., 8., 7., 0., 2., 5., 3., 16., 11., 73., 8., 4., 47., 29., 12., 6., 0., 0., 2., 2., 25., 10., 26., 11., 14., 6., 4., 3., 0., 7., 2., 13., 1., 20., 3., 6., 2., 2., 41., 5., 5., 3., 0., 13., 3., 8., 1., 16., 2., 2., 0., 2., 2., 0., 3., 2., 9., 7., 6., 7., 1., 2., 0., 0., 0., 0., 0., 4., 2., 4., 1., 4., 2., 0., 0., 1., 0., 1., 0., 2., 0., 0., 0., 1., 0., 0., 0., 2., 0., 0., 0., 1., 0., 0., 1., 2., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 25., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

14., 1., 2., 3., 10., 0., 12., 1., 3., 49., 2., 12., 53., 1., 5., 2., 0., 5., 73., 11., 6., 74., 9., 100., 7., 4., 0., 1., 2., 3., 13., 10., 39., 9., 3., 32., 39., 16., 6., 0., 1., 6., 5., 23., 8., 18., 13., 8., 13., 3., 3., 0., 7., 6., 12., 6., 13., 3., 6., 5., 4., 36., 14., 10., 2., 0., 10., 4., 7., 3., 20., 3., 3., 0., 3., 1., 0., 7., 4., 17., 14., 3., 6., 2., 0., 0., 0., 0., 0., 0., 6., 3., 3., 2., 2., 2., 0., 0., 1., 0., 0., 0., 2., 3., 2., 0., 3., 0., 0., 0., 2., 0., 0., 0., 1., 0., 2., 2., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 24., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 1., 1., 9., 14., 0., 21., 1., 9., 33., 0., 15., 78., 1., 7., 2., 0., 3., 63., 10., 11., 77., 12., 68., 9., 2., 0., 1., 4., 1., 13., 13., 50., 9., 3., 43., 31., 11., 4., 0., 1., 5., 4., 26., 6., 26., 10., 10., 7., 4., 4., 0., 12., 4., 11., 5., 12., 4., 3., 5., 1., 44., 5., 7., 4., 0., 17., 6., 7., 1., 7., 3., 7., 1., 1., 1., 0., 3., 2., 10., 10., 2., 4., 1., 3., 0., 0., 0., 0., 0., 9., 2., 2., 2., 5., 2., 1., 0., 0., 0., 0., 0., 2., 4., 2., 0., 2., 0., 1., 0., 2., 0., 0., 0., 0., 0., 1., 0., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 19., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 1., 4., 2., 10., 0., 13., 2., 6., 60., 1., 12., 57., 1., 4., 2., 0., 1., 82., 5., 8., 78., 16., 82., 11., 4., 0., 2., 3., 2., 18., 12., 54., 10., 4., 40., 34., 17., 3., 0., 0., 5., 7., 23., 8., 22., 11., 17., 4., 4., 2., 0., 12., 4., 15., 0., 11., 3., 9., 4., 3., 33., 7., 7., 3., 0., 12., 0., 8., 3., 8., 4., 6., 1., 2., 2., 0., 2., 2., 16., 10., 4., 2., 0., 2., 0., 0., 0., 0., 0., 5., 3., 3., 2., 2., 1., 0., 0., 2., 0., 3., 0., 0., 3., 0., 0., 4., 0., 2., 0., 1., 0., 0., 0., 3., 0., 0., 2., 2., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 23., 0., 2., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 3., 5., 3., 6., 0., 17., 2., 10., 38., 2., 6., 59., 0., 12., 1., 0., 1., 68., 13., 9., 79., 13., 76., 15., 1., 0., 1., 3., 2., 14., 10., 35., 17., 2., 34., 34., 13., 3., 0., 1., 6., 2., 32., 8., 17., 12., 16., 6., 6., 0., 0., 17., 3., 24., 4., 19., 2., 8., 0., 7., 37., 7., 7., 3., 0., 13., 1., 7., 0., 6., 3., 5., 0., 2., 0., 0., 5., 1., 20., 11., 6., 3., 0., 3., 0., 0., 0., 0., 0., 11., 3., 2., 3., 1., 1., 2., 0., 0., 0., 0., 0., 2., 3., 2., 0., 1., 0., 1., 0., 2., 0., 0., 0., 2., 0., 2., 3., 0., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 27., 0., 1., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 4., 1., 1., 12., 0., 13., 3., 6., 56., 3., 8., 47., 1., 3., 1., 0., 3., 81., 8., 4., 66., 17., 75., 11., 4., 0., 0., 5., 0., 20., 5., 48., 12., 2., 34., 21., 12., 3., 0., 1., 8., 7., 24., 8., 22., 10., 13., 7., 0., 2., 0., 13., 7., 24., 0., 8., 3., 5., 2., 2., 44., 10., 8., 1., 0., 12., 3., 5., 6., 18., 1., 4., 0., 0., 3., 0., 2., 1., 19., 2., 2., 3., 1., 6., 0., 0., 0., 0., 0., 13., 1., 3., 0., 2., 2., 1., 0., 0., 0., 1., 0., 0., 1., 2., 0., 1., 0., 1., 0., 1., 0., 0., 0., 1., 0., 1., 1., 2., 0., 0., 0., 1., 0., 6., 0., 0., 0., 0., 21., 0., 0., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 2., 1., 0., 12., 0., 16., 3., 10., 58., 0., 4., 59., 3., 3., 0., 0., 3., 69., 8., 10., 68., 8., 98., 8., 3., 0., 1., 5., 4., 7., 9., 53., 7., 3., 34., 41., 12., 2., 0., 1., 8., 2., 18., 6., 17., 9., 15., 10., 2., 1., 0., 6., 5., 20., 6., 14., 3., 8., 0., 4., 40., 5., 4., 1., 0., 16., 4., 7., 3., 11., 2., 6., 2., 2., 2., 0., 1., 1., 21., 6., 2., 5., 4., 3., 0., 0., 0., 0., 0., 18., 2., 1., 3., 3., 1., 6., 0., 3., 0., 1., 0., 1., 4., 0., 0., 3., 0., 1., 0., 0., 0., 0., 0., 2., 0., 1., 3., 4., 0., 0., 0., 0., 0., 5., 0., 0., 0., 0., 20., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 1., 4., 14., 0., 12., 0., 4., 58., 2., 4., 54., 2., 5., 2., 0., 0., 68., 11., 7., 80., 13., 92., 13., 3., 0., 0., 1., 4., 13., 9., 50., 17., 2., 25., 32., 16., 6., 0., 0., 5., 2., 20., 6., 22., 4., 19., 7., 4., 0., 0., 11., 7., 16., 6., 9., 4., 11., 4., 4., 39., 5., 11., 2., 0., 17., 3., 8., 1., 7., 4., 3., 2., 1., 3., 0., 10., 0., 15., 4., 5., 3., 1., 0., 0., 0., 0., 0., 0., 3., 1., 2., 2., 2., 1., 5., 0., 3., 0., 0., 0., 2., 5., 0., 0., 2., 0., 1., 0., 0., 0., 0., 0., 0., 0., 1., 2., 0., 0., 0., 0., 1., 0., 5., 0., 0., 0., 0., 29., 0., 0., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 1., 3., 10., 0., 17., 2., 5., 28., 0., 10., 62., 2., 4., 4., 0., 0., 73., 14., 6., 78., 13., 66., 18., 5., 0., 1., 3., 0., 15., 10., 57., 14., 2., 35., 35., 15., 6., 0., 0., 4., 5., 26., 6., 16., 9., 15., 8., 3., 1., 0., 9., 0., 23., 6., 11., 5., 4., 2., 6., 49., 7., 7., 0., 0., 11., 0., 3., 0., 15., 3., 5., 1., 2., 2., 0., 7., 4., 18., 7., 1., 2., 1., 6., 0., 0., 0., 0., 0., 5., 0., 5., 2., 9., 1., 1., 0., 1., 0., 0., 0., 1., 0., 2., 0., 1., 0., 0., 0., 2., 0., 0., 0., 3., 0., 2., 4., 1., 0., 0., 0., 0., 0., 2., 0., 0., 0., 0., 33., 0., 3., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 2., 2., 2., 12., 0., 20., 2., 7., 55., 0., 13., 56., 2., 6., 1., 0., 4., 72., 9., 6., 71., 13., 91., 9., 0., 0., 0., 7., 3., 15., 10., 52., 7., 6., 41., 42., 17., 11., 0., 1., 3., 3., 23., 5., 28., 13., 14., 3., 4., 1., 0., 9., 4., 11., 2., 13., 3., 7., 5., 2., 29., 15., 12., 3., 0., 24., 6., 10., 1., 12., 0., 11., 1., 2., 1., 0., 6., 7., 10., 10., 4., 1., 0., 1., 0., 0., 0., 0., 0., 8., 3., 3., 3., 4., 2., 2., 0., 2., 0., 1., 0., 3., 2., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 1., 0., 2., 2., 1., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 25., 0., 0., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 2., 3., 4., 5., 0., 15., 1., 7., 51., 2., 7., 63., 0., 1., 3., 0., 1., 56., 15., 10., 79., 13., 83., 12., 6., 0., 1., 4., 0., 16., 8., 44., 9., 2., 30., 31., 11., 5., 0., 1., 6., 2., 17., 12., 27., 8., 11., 9., 1., 5., 0., 10., 8., 11., 2., 15., 9., 7., 5., 1., 41., 9., 5., 1., 0., 6., 2., 7., 1., 11., 0., 6., 0., 1., 0., 0., 5., 2., 13., 6., 0., 7., 0., 1., 0., 0., 0., 0., 0., 8., 0., 3., 0., 6., 1., 2., 0., 1., 0., 1., 0., 1., 4., 3., 0., 1., 0., 0., 0., 2., 0., 0., 0., 0., 0., 1., 3., 5., 0., 0., 0., 1., 0., 3., 0., 0., 0., 0., 20., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

11., 0., 3., 1., 14., 0., 12., 4., 11., 41., 1., 6., 50., 1., 4., 2., 0., 3., 75., 13., 4., 64., 15., 84., 16., 10., 0., 0., 4., 3., 13., 4., 54., 11., 4., 44., 31., 15., 7., 0., 2., 4., 3., 23., 5., 13., 3., 13., 2., 6., 1., 0., 10., 7., 9., 1., 11., 3., 10., 4., 1., 35., 6., 8., 0., 0., 20., 2., 11., 1., 6., 3., 5., 1., 1., 3., 0., 6., 0., 13., 6., 4., 6., 2., 2., 0., 0., 0., 0., 0., 9., 2., 2., 1., 2., 0., 1., 0., 1., 0., 3., 0., 1., 3., 3., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 5., 5., 0., 0., 0., 1., 0., 1., 0., 0., 0., 0., 18., 0., 1., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

8., 3., 2., 3., 15., 0., 13., 0., 8., 47., 2., 5., 73., 1., 4., 0., 0., 0., 69., 12., 10., 72., 16., 81., 10., 3., 0., 1., 4., 2., 14., 13., 53., 12., 6., 37., 31., 15., 3., 0., 0., 6., 4., 18., 3., 27., 9., 10., 8., 4., 1., 0., 11., 6., 15., 5., 21., 1., 7., 2., 1., 37., 6., 7., 3., 0., 8., 2., 11., 4., 10., 6., 1., 0., 1., 0., 0., 7., 2., 14., 8., 2., 3., 1., 1., 0., 0., 0., 0., 0., 9., 1., 5., 3., 4., 0., 0., 0., 1., 0., 3., 0., 1., 2., 2., 0., 4., 0., 1., 0., 0., 0., 0., 0., 0., 0., 5., 0., 5., 0., 0., 0., 1., 0., 9., 0., 0., 0., 0., 27., 0., 1., 0., 5., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

6., 0., 2., 5., 9., 0., 19., 3., 9., 67., 0., 9., 54., 1., 5., 2., 0., 5., 73., 10., 7., 78., 11., 92., 8., 3., 0., 0., 3., 3., 16., 14., 55., 12., 1., 36., 34., 12., 5., 0., 0., 5., 2., 14., 5., 19., 7., 20., 4., 3., 0., 0., 9., 6., 16., 5., 15., 3., 3., 3., 2., 32., 8., 14., 2., 0., 16., 4., 11., 1., 16., 2., 5., 0., 1., 2., 0., 5., 2., 17., 7., 4., 4., 0., 1., 0., 0., 0., 0., 0., 13., 6., 4., 1., 6., 1., 2., 0., 1., 0., 2., 0., 2., 1., 1., 0., 1., 0., 0., 0., 1., 0., 0., 0., 1., 0., 2., 1., 1., 0., 0., 0., 3., 0., 3., 0., 0., 0., 0., 28., 0., 1., 0., 3., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

4., 1., 2., 4., 6., 0., 16., 2., 8., 30., 1., 7., 53., 0., 3., 2., 0., 0., 72., 4., 3., 71., 13., 83., 14., 5., 0., 0., 1., 6., 17., 9., 54., 12., 1., 39., 26., 12., 10., 0., 4., 13., 1., 29., 6., 26., 7., 11., 4., 1., 4., 0., 13., 5., 20., 5., 21., 1., 8., 0., 5., 33., 9., 12., 1., 0., 14., 3., 9., 3., 10., 2., 2., 1., 1., 1., 0., 8., 2., 14., 8., 5., 3., 1., 1., 0., 0., 0., 0., 0., 9., 3., 2., 1., 2., 1., 0., 0., 0., 0., 1., 0., 0., 3., 0., 0., 3., 0., 0., 0., 0., 0., 0., 0., 2., 0., 3., 3., 1., 0., 0., 0., 3., 0., 5., 0., 0., 0., 0., 28., 0., 6., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

7., 0., 4., 5., 12., 0., 15., 2., 6., 47., 1., 7., 61., 0., 10., 1., 0., 0., 95., 12., 3., 78., 23., 81., 11., 2., 0., 0., 2., 2., 7., 10., 45., 19., 0., 37., 33., 18., 3., 0., 0., 7., 3., 32., 3., 21., 6., 9., 5., 3., 5., 0., 5., 4., 21., 5., 22., 2., 6., 3., 0., 38., 2., 5., 3., 0., 9., 4., 6., 2., 10., 3., 1., 0., 2., 1., 0., 7., 2., 9., 6., 5., 5., 3., 2., 0., 0., 0., 0., 0., 4., 3., 5., 2., 6., 1., 1., 0., 0., 0., 0., 0., 0., 8., 1., 0., 1., 0., 2., 0., 2., 0., 0., 0., 2., 0., 2., 1., 4., 0., 0., 0., 2., 0., 4., 0., 0., 0., 0., 24., 0., 2., 0., 7., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

12., 0., 1., 8., 10., 0., 19., 2., 4., 49., 0., 8., 62., 1., 4., 3., 0., 1., 76., 9., 6., 75., 11., 75., 10., 4., 0., 1., 5., 2., 11., 10., 48., 10., 1., 34., 36., 21., 4., 0., 1., 5., 5., 29., 6., 22., 6., 13., 7., 3., 1., 0., 14., 2., 14., 8., 12., 2., 5., 5., 8., 36., 7., 7., 1., 0., 10., 3., 4., 1., 6., 2., 3., 0., 0., 0., 0., 4., 1., 21., 9., 6., 6., 0., 1., 0., 0., 0., 0., 0., 11., 2., 1., 3., 4., 1., 1., 0., 3., 0., 0., 0., 0., 3., 5., 0., 4., 0., 0., 0., 0., 0., 0., 0., 2., 0., 2., 4., 3., 0., 0., 0., 2., 0., 2., 0., 0., 0., 0., 22., 0., 4., 0., 4., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,

9., 1., 3., 4., 14., 0., 15., 2., 5., 39., 0., 9., 64., 0., 4., 2., 0., 1., 69., 8., 9., 60., 15., 72., 12., 4., 0., 0., 2., 2., 10., 11., 42., 16., 0., 38., 37., 13., 6., 0., 2., 8., 2., 27., 5., 26., 5., 10., 7., 2., 4., 0., 3., 5., 21., 5., 13., 6., 8., 4., 1., 36., 11., 5., 3., 0., 12., 2., 10., 1., 11., 2., 0., 2., 0., 0., 0., 2., 0., 16., 11., 4., 5., 1., 3., 0., 0., 0., 0., 0., 11., 2., 3., 3., 4., 1., 0., 0., 1., 0., 2., 0., 1., 6., 2., 0., 2., 0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 0., 0., 0., 1., 0., 7., 0., 0., 0., 0., 30., 0., 4., 0., 6., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.0
};

#endif // VIGRA_UNSUPERVISED_TEST_DATA_HXX
