#!/bin/sh

set -ex

UPSTREAM_VERSION=$2
ORIG_TARBALL=$3

REAL_TARBALL=`readlink -f ${ORIG_TARBALL}`

WORKING_DIR=`dirname ${ORIG_TARBALL}`

ORIG_TARBALL_DFSG=`echo ${ORIG_TARBALL} | sed -e "s/\(${UPSTREAM_VERSION}\)\(\.orig\)/\1+dfsg\2/g"`
ORIG_TARBALL_DIR=`echo ${ORIG_TARBALL_DFSG} | sed -e "s/_\(${UPSTREAM_VERSION}\)/-\1/g" -e "s/\.tar\.gz//g"`
ORIG_TARBALL_DIR_STRIP=`basename ${ORIG_TARBALL_DIR}`
ORIG_TARBALL_DFSG_BZ2=`echo ${ORIG_TARBALL} | sed -e "s/\(${UPSTREAM_VERSION}\)\(\.orig\)/\1+dfsg\2/g" -e "s/\.tar\.gz/\.tar\.bz2/g"`

mkdir -p ${ORIG_TARBALL_DIR}
tar --directory=${ORIG_TARBALL_DIR} --strip 1 -xf ${REAL_TARBALL} || exit 1 
rm -f ${ORIG_TARBALL} ${REAL_TARBALL}

cd ${ORIG_TARBALL_DIR}

rm -rf doc/html

BZIP2=-9 tar --remove-files -cjf ${ORIG_TARBALL_DFSG_BZ2} ${ORIG_TARBALL_DIR} || exit 1

exit 0
