; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=avr | FileCheck %s

define i8 @loadx(ptr %0) {
; CHECK-LABEL: loadx:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r26, r24
; CHECK-NEXT:    mov r27, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    ld r24, X
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  %2 = tail call i8 asm sideeffect "ld $0, ${1:a}", "=r,x"(ptr %0)
  ret i8 %2
}

define i8 @loady(ptr %0) {
; CHECK-LABEL: loady:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r28
; CHECK-NEXT:    push r29
; CHECK-NEXT:    mov r28, r24
; CHECK-NEXT:    mov r29, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    ld r24, Y
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    pop r29
; CHECK-NEXT:    pop r28
; CHECK-NEXT:    ret
  %2 = tail call i8 asm sideeffect "ld $0, ${1:a}", "=r,y"(ptr %0)
  ret i8 %2
}

define i8 @loadz(ptr %0) {
; CHECK-LABEL: loadz:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r30, r24
; CHECK-NEXT:    mov r31, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    ld r24, Z
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  %2 = tail call i8 asm sideeffect "ld $0, ${1:a}", "=r,z"(ptr %0)
  ret i8 %2
}

define i8 @load_ptr_imm() {
; CHECK-LABEL: load_ptr_imm:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldi r26, 210
; CHECK-NEXT:    ldi r27, 4
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    ld r24, X
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  %1 = tail call i8 asm sideeffect "ld $0, $1", "=r,e"(i16 1234)
  ret i8 %1
}

define void @storex(ptr %0, i8 %1) {
; CHECK-LABEL: storex:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r26, r24
; CHECK-NEXT:    mov r27, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    st X, r22
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect "st ${0:a}, $1", "x,r"(ptr %0, i8 %1)
  ret void
}

define void @storey(ptr %0, i8 %1) {
; CHECK-LABEL: storey:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r28
; CHECK-NEXT:    push r29
; CHECK-NEXT:    mov r28, r24
; CHECK-NEXT:    mov r29, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    st Y, r22
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    pop r29
; CHECK-NEXT:    pop r28
; CHECK-NEXT:    ret
  tail call void asm sideeffect "st ${0:a}, $1", "y,r"(ptr %0, i8 %1)
  ret void
}

define void @storez(ptr %0, i8 %1) {
; CHECK-LABEL: storez:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov r30, r24
; CHECK-NEXT:    mov r31, r25
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    st Z, r22
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect "st ${0:a}, $1", "z,r"(ptr %0, i8 %1)
  ret void
}

define void @store_ptr_imm(i8 %0) {
; CHECK-LABEL: store_ptr_imm:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldi r26, 210
; CHECK-NEXT:    ldi r27, 4
; CHECK-NEXT:    ;APP
; CHECK-NEXT:    st X, r24
; CHECK-NEXT:    ;NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect "st $0, $1", "e,r"(i16 1234, i8 %0)
  ret void
}
