; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu < %s \
; RUN:     -verify-machineinstrs -ppc-asm-full-reg-names \
; RUN:     -ppc-vsr-nums-as-vr | FileCheck %s

define void @dcbt_with_hint_test1(i8* %a) {
; CHECK-LABEL: dcbt_with_hint_test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    dcbt 0, r3
; CHECK-NEXT:    blr
entry:
  tail call void @llvm.ppc.dcbt.with.hint(i8* %a, i32 0)
  ret void
}

define void @dcbt_with_hint_test2(i8* %a) {
; CHECK-LABEL: dcbt_with_hint_test2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    dcbt 0, r3, 8
; CHECK-NEXT:    blr
entry:
  tail call void @llvm.ppc.dcbt.with.hint(i8* %a, i32 8)
  ret void
}

define void @dcbt_with_hint_test3(i8* %a) {
; CHECK-LABEL: dcbt_with_hint_test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    dcbt 0, r3, 15
; CHECK-NEXT:    blr
entry:
  tail call void @llvm.ppc.dcbt.with.hint(i8* %a, i32 15)
  ret void
}

define void @dcbtst_with_hint_test1(i8* %a) {
; CHECK-LABEL: dcbtst_with_hint_test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    dcbtst 0, r3
; CHECK-NEXT:    blr
entry:
  tail call void @llvm.ppc.dcbtst.with.hint(i8* %a, i32 0)
  ret void
}

define void @dcbtst_with_hint_test2(i8* %a) {
; CHECK-LABEL: dcbtst_with_hint_test2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    dcbtst 0, r3, 8
; CHECK-NEXT:    blr
entry:
  tail call void @llvm.ppc.dcbtst.with.hint(i8* %a, i32 8)
  ret void
}

define void @dcbtst_with_hint_test3(i8* %a) {
; CHECK-LABEL: dcbtst_with_hint_test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    dcbtst 0, r3, 15
; CHECK-NEXT:    blr
entry:
  tail call void @llvm.ppc.dcbtst.with.hint(i8* %a, i32 15)
  ret void
}

declare void @llvm.ppc.dcbt.with.hint(i8*, i32)
declare void @llvm.ppc.dcbtst.with.hint(i8*, i32)
