/* test-scores.c generated by valac 0.40.0.28-11bab, the Vala compiler
 * generated from test-scores.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 * Copyright © 2016 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libgnome-games-support.h"
#include <gio/gio.h>
#include <gee.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	GMainLoop* main_loop;
	GamesScoresContext* context;
};

struct _Block2Data {
	int _ref_count_;
	GamesScoresCategory* category;
};

struct _Block3Data {
	int _ref_count_;
	GamesScoresCategory* category;
};



GamesScoresCategory* games_scores_category_request (const gchar* category_key);
void games_scores_add_score_sync (GamesScoresContext* context,
                                  gint score,
                                  GamesScoresCategory* category);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* object,
                 GAsyncResult* _result_);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
void games_scores_create_scores (void);
static GamesScoresCategory* _games_scores_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                gpointer self);
gchar* games_scores_get_test_directory_name (void);
gchar* games_scores_get_score_directory_name (void);
gchar* games_scores_get_score_filename_for_category (const gchar* category_name);
void games_scores_delete_scores (void);
void games_scores_test_scores_files_exist (void);
void games_scores_test_save_score_to_file (void);
void games_scores_test_import_from_score_directory (void);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static GamesScoresCategory* ___lambda5_ (Block2Data* _data2_,
                                  const gchar* key);
static GamesScoresCategory* ____lambda5__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
static gchar* ___lambda6_ (const gchar* old_key);
static gchar* ____lambda6__games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                           gpointer self);
void games_scores_test_import_from_history_file (void);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static GamesScoresCategory* ___lambda7_ (Block3Data* _data3_,
                                  const gchar* key);
static GamesScoresCategory* ____lambda7__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
static void ___lambda8_ (Block3Data* _data3_,
                  const gchar* line,
                  GamesScoresScore* * score,
                  GamesScoresCategory* * out_category);
static void ____lambda8__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                           GamesScoresScore* * score,
                                                                           GamesScoresCategory* * category,
                                                                           gpointer self);
void games_scores_test_import_from_nonexistent_history_file (void);
static GamesScoresCategory* __lambda9_ (const gchar* key);
static GamesScoresCategory* ___lambda9__games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self);
static void __lambda10_ (const gchar* line,
                  GamesScoresScore* * score,
                  GamesScoresCategory* * category);
static void ___lambda10__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                           GamesScoresScore* * score,
                                                                           GamesScoresCategory* * category,
                                                                           gpointer self);
gint games_scores_main (const gchar* args,
                        int args_length1);
static void __lambda11_ (void);
static void ___lambda11__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_scores_files_exist_gtest_fixture_func (void* fixture,
                                                               gpointer self);
static void _games_scores_delete_scores_gtest_fixture_func (void* fixture,
                                                     gpointer self);
static void __lambda12_ (void);
static void ___lambda12__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_save_score_to_file_gtest_fixture_func (void* fixture,
                                                               gpointer self);
static void __lambda13_ (void);
static void ___lambda13__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_import_from_score_directory_gtest_fixture_func (void* fixture,
                                                                        gpointer self);
static void __lambda14_ (void);
static void ___lambda14__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_import_from_history_file_gtest_fixture_func (void* fixture,
                                                                     gpointer self);
static void __lambda15_ (void);
static void ___lambda15__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_import_from_nonexistent_history_file_gtest_fixture_func (void* fixture,
                                                                                 gpointer self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GamesScoresCategory*
games_scores_category_request (const gchar* category_key)
{
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
	g_return_val_if_fail (category_key != NULL, NULL);
	_tmp0_ = games_scores_category_new (category_key, category_key);
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->main_loop);
		_g_object_unref0 (_data1_->context);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
__lambda4_ (Block1Data* _data1_,
            GObject* object,
            GAsyncResult* _result_)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = games_scores_context_add_score_finish (_data1_->context, _result_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_main_loop_quit (_data1_->main_loop);
}


static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block1_data_unref (self);
}


void
games_scores_add_score_sync (GamesScoresContext* context,
                             gint score,
                             GamesScoresCategory* category)
{
	Block1Data* _data1_;
	GamesScoresContext* _tmp0_;
	GMainContext* _tmp1_;
	GMainLoop* _tmp2_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (category != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (_data1_->context);
	_data1_->context = _tmp0_;
	_tmp1_ = g_main_context_default ();
	_tmp2_ = g_main_loop_new (_tmp1_, FALSE);
	_data1_->main_loop = _tmp2_;
	games_scores_context_add_score (_data1_->context, (glong) score, category, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	g_main_loop_run (_data1_->main_loop);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static GamesScoresCategory*
_games_scores_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                           gpointer self)
{
	GamesScoresCategory* result;
	result = games_scores_category_request (category_key);
	return result;
}


void
games_scores_create_scores (void)
{
	GamesScoresContext* context = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* cat = NULL;
	GamesScoresCategory* _tmp1_;
	_tmp0_ = games_scores_context_new ("libgnome-games-support-test", "Games Type", NULL, _games_scores_category_request_games_scores_context_category_request_func, NULL, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER);
	context = _tmp0_;
	_tmp1_ = games_scores_category_new ("cat1", "cat1");
	cat = _tmp1_;
	games_scores_add_score_sync (context, 101, cat);
	games_scores_add_score_sync (context, 102, cat);
	games_scores_category_set_key (cat, "cat2");
	games_scores_category_set_name (cat, "cat2");
	games_scores_add_score_sync (context, 21, cat);
	games_scores_add_score_sync (context, 24, cat);
	_g_object_unref0 (cat);
	_g_object_unref0 (context);
}


gchar*
games_scores_get_test_directory_name (void)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "libgnome-games-support-test", NULL, NULL);
	result = _tmp1_;
	return result;
}


gchar*
games_scores_get_score_directory_name (void)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = games_scores_get_test_directory_name ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "scores", NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gchar*
games_scores_get_score_filename_for_category (const gchar* category_name)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (category_name != NULL, NULL);
	_tmp0_ = games_scores_get_score_directory_name ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, category_name, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


void
games_scores_delete_scores (void)
{
	GError * _inner_error_ = NULL;
	{
		GFile* directory = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* parent_directory = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		_tmp0_ = games_scores_get_score_directory_name ();
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		directory = _tmp3_;
		_tmp4_ = directory;
		if (g_file_query_exists (_tmp4_, NULL)) {
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp5_;
			GFileEnumerator* _tmp6_;
			GFileInfo* file_info = NULL;
			GFile* _tmp19_;
			_tmp5_ = directory;
			_tmp6_ = g_file_enumerate_children (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
			enumerator = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (directory);
				goto __catch1_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp7_ = NULL;
				GFileEnumerator* _tmp8_;
				GFileInfo* _tmp9_;
				GFileInfo* _tmp10_;
				GFileInfo* _tmp11_;
				gchar* file_name = NULL;
				GFileInfo* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				GFile* file = NULL;
				GFile* _tmp15_;
				const gchar* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				_tmp8_ = enumerator;
				_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error_);
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (file_info);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (directory);
					goto __catch1_g_error;
				}
				_tmp10_ = _tmp7_;
				_tmp7_ = NULL;
				_g_object_unref0 (file_info);
				file_info = _tmp10_;
				_tmp11_ = file_info;
				if (!(_tmp11_ != NULL)) {
					_g_object_unref0 (_tmp7_);
					break;
				}
				_tmp12_ = file_info;
				_tmp13_ = g_file_info_get_name (_tmp12_);
				_tmp14_ = g_strdup (_tmp13_);
				file_name = _tmp14_;
				_tmp15_ = directory;
				_tmp16_ = file_name;
				_tmp17_ = g_file_get_child (_tmp15_, _tmp16_);
				file = _tmp17_;
				_tmp18_ = file;
				g_file_delete (_tmp18_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (file_name);
					_g_object_unref0 (_tmp7_);
					_g_object_unref0 (file_info);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (directory);
					goto __catch1_g_error;
				}
				_g_object_unref0 (file);
				_g_free0 (file_name);
				_g_object_unref0 (_tmp7_);
			}
			_tmp19_ = directory;
			g_file_delete (_tmp19_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				goto __catch1_g_error;
			}
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
		}
		_tmp20_ = games_scores_get_test_directory_name ();
		_tmp21_ = _tmp20_;
		_tmp22_ = g_file_new_for_path (_tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		parent_directory = _tmp23_;
		_tmp24_ = parent_directory;
		if (g_file_query_exists (_tmp24_, NULL)) {
			GFile* _tmp25_;
			_tmp25_ = parent_directory;
			g_file_delete (_tmp25_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (parent_directory);
				_g_object_unref0 (directory);
				goto __catch1_g_error;
			}
		}
		_g_object_unref0 (parent_directory);
		_g_object_unref0 (directory);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e->message;
		g_error ("test-scores.vala:99: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void
games_scores_test_scores_files_exist (void)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	games_scores_create_scores ();
	_tmp0_ = games_scores_get_score_filename_for_category ("cat1");
	filename = _tmp0_;
	_tmp1_ = filename;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_vala_assert (g_file_query_exists (_tmp3_, NULL), "file.query_exists ()");
	_tmp4_ = games_scores_get_score_filename_for_category ("cat2");
	_g_free0 (filename);
	filename = _tmp4_;
	_tmp5_ = filename;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_g_object_unref0 (file);
	file = _tmp6_;
	_tmp7_ = file;
	_vala_assert (g_file_query_exists (_tmp7_, NULL), "file.query_exists ()");
	_g_object_unref0 (file);
	_g_free0 (filename);
}


void
games_scores_test_save_score_to_file (void)
{
	GError * _inner_error_ = NULL;
	{
		gchar* filename = NULL;
		gchar* _tmp0_;
		GFile* file = NULL;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFileInputStream* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFileInputStream* _tmp5_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp6_;
		gchar* line = NULL;
		gchar* _tmp7_ = NULL;
		GDataInputStream* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar** tokens = NULL;
		const gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		GDataInputStream* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		GDataInputStream* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		GFile* _tmp36_;
		GFileInputStream* _tmp37_ = NULL;
		GFile* _tmp38_;
		GFileInputStream* _tmp39_;
		GDataInputStream* _tmp40_;
		gchar* _tmp41_ = NULL;
		GDataInputStream* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar** _tmp47_;
		gchar** _tmp48_;
		gchar** _tmp49_;
		gint _tmp49__length1;
		gchar** _tmp50_;
		gint _tmp50__length1;
		const gchar* _tmp51_;
		gchar* _tmp52_ = NULL;
		GDataInputStream* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar** _tmp58_;
		gchar** _tmp59_;
		gchar** _tmp60_;
		gint _tmp60__length1;
		gchar** _tmp61_;
		gint _tmp61__length1;
		const gchar* _tmp62_;
		gchar* _tmp63_ = NULL;
		GDataInputStream* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		const gchar* _tmp67_;
		games_scores_create_scores ();
		_tmp0_ = games_scores_get_score_filename_for_category ("cat1");
		filename = _tmp0_;
		_tmp1_ = filename;
		_tmp2_ = g_file_new_for_path (_tmp1_);
		file = _tmp2_;
		_tmp4_ = file;
		_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
		dis = _tmp6_;
		_tmp8_ = dis;
		_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (line);
		line = _tmp10_;
		_tmp11_ = line;
		_vala_assert (_tmp11_ != NULL, "(line = dis.read_line (null)) != null");
		_tmp12_ = line;
		_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, " ", 3);
		tokens = _tmp14_;
		tokens_length1 = _vala_array_length (_tmp13_);
		_tokens_size_ = tokens_length1;
		_tmp15_ = tokens;
		_tmp15__length1 = tokens_length1;
		_vala_assert (_tmp15__length1 == 3, "tokens.length == 3");
		_tmp16_ = tokens;
		_tmp16__length1 = tokens_length1;
		_tmp17_ = _tmp16_[0];
		_vala_assert (g_strcmp0 (_tmp17_, "101") == 0, "tokens[0] == \"101\"");
		_tmp19_ = dis;
		_tmp20_ = g_data_input_stream_read_line (_tmp19_, NULL, NULL, &_inner_error_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp7_);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp21_ = _tmp18_;
		_tmp18_ = NULL;
		_g_free0 (line);
		line = _tmp21_;
		_tmp22_ = line;
		_vala_assert (_tmp22_ != NULL, "(line = dis.read_line (null)) != null");
		_tmp23_ = line;
		_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, " ", 3);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = _tmp25_;
		tokens_length1 = _vala_array_length (_tmp24_);
		_tokens_size_ = tokens_length1;
		_tmp26_ = tokens;
		_tmp26__length1 = tokens_length1;
		_vala_assert (_tmp26__length1 == 3, "tokens.length == 3");
		_tmp27_ = tokens;
		_tmp27__length1 = tokens_length1;
		_tmp28_ = _tmp27_[0];
		_vala_assert (g_strcmp0 (_tmp28_, "102") == 0, "tokens[0] == \"102\"");
		_tmp30_ = dis;
		_tmp31_ = g_data_input_stream_read_line (_tmp30_, NULL, NULL, &_inner_error_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp18_);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp7_);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp32_ = _tmp29_;
		_tmp29_ = NULL;
		_g_free0 (line);
		line = _tmp32_;
		_tmp33_ = line;
		_vala_assert (_tmp33_ == NULL, "(line = dis.read_line (null)) == null");
		_tmp34_ = games_scores_get_score_filename_for_category ("cat2");
		_g_free0 (filename);
		filename = _tmp34_;
		_tmp35_ = filename;
		_tmp36_ = g_file_new_for_path (_tmp35_);
		_g_object_unref0 (file);
		file = _tmp36_;
		_tmp38_ = file;
		_tmp39_ = g_file_read (_tmp38_, NULL, &_inner_error_);
		_tmp37_ = _tmp39_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp29_);
			_g_free0 (_tmp18_);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp7_);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp40_ = g_data_input_stream_new ((GInputStream*) _tmp37_);
		_g_object_unref0 (dis);
		dis = _tmp40_;
		_tmp42_ = dis;
		_tmp43_ = g_data_input_stream_read_line (_tmp42_, NULL, NULL, &_inner_error_);
		_tmp41_ = _tmp43_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp37_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp18_);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp7_);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp44_ = _tmp41_;
		_tmp41_ = NULL;
		_g_free0 (line);
		line = _tmp44_;
		_tmp45_ = line;
		_vala_assert (_tmp45_ != NULL, "(line = dis.read_line (null)) != null");
		_tmp46_ = line;
		_tmp48_ = _tmp47_ = g_strsplit (_tmp46_, " ", 3);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = _tmp48_;
		tokens_length1 = _vala_array_length (_tmp47_);
		_tokens_size_ = tokens_length1;
		_tmp49_ = tokens;
		_tmp49__length1 = tokens_length1;
		_vala_assert (_tmp49__length1 == 3, "tokens.length == 3");
		_tmp50_ = tokens;
		_tmp50__length1 = tokens_length1;
		_tmp51_ = _tmp50_[0];
		_vala_assert (g_strcmp0 (_tmp51_, "21") == 0, "tokens[0] == \"21\"");
		_tmp53_ = dis;
		_tmp54_ = g_data_input_stream_read_line (_tmp53_, NULL, NULL, &_inner_error_);
		_tmp52_ = _tmp54_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp41_);
			_g_object_unref0 (_tmp37_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp18_);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp7_);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp55_ = _tmp52_;
		_tmp52_ = NULL;
		_g_free0 (line);
		line = _tmp55_;
		_tmp56_ = line;
		_vala_assert (_tmp56_ != NULL, "(line = dis.read_line (null)) != null");
		_tmp57_ = line;
		_tmp59_ = _tmp58_ = g_strsplit (_tmp57_, " ", 3);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = _tmp59_;
		tokens_length1 = _vala_array_length (_tmp58_);
		_tokens_size_ = tokens_length1;
		_tmp60_ = tokens;
		_tmp60__length1 = tokens_length1;
		_vala_assert (_tmp60__length1 == 3, "tokens.length == 3");
		_tmp61_ = tokens;
		_tmp61__length1 = tokens_length1;
		_tmp62_ = _tmp61_[0];
		_vala_assert (g_strcmp0 (_tmp62_, "24") == 0, "tokens[0] == \"24\"");
		_tmp64_ = dis;
		_tmp65_ = g_data_input_stream_read_line (_tmp64_, NULL, NULL, &_inner_error_);
		_tmp63_ = _tmp65_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp52_);
			_g_free0 (_tmp41_);
			_g_object_unref0 (_tmp37_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp18_);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp7_);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_free0 (filename);
			goto __catch2_g_error;
		}
		_tmp66_ = _tmp63_;
		_tmp63_ = NULL;
		_g_free0 (line);
		line = _tmp66_;
		_tmp67_ = line;
		_vala_assert (_tmp67_ == NULL, "(line = dis.read_line (null)) == null");
		_g_free0 (_tmp63_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp41_);
		_g_object_unref0 (_tmp37_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp18_);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp7_);
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (file);
		_g_free0 (filename);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp68_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp68_ = e->message;
		g_error ("test-scores.vala:155: %s", _tmp68_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->category);
		g_slice_free (Block2Data, _data2_);
	}
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static GamesScoresCategory*
___lambda5_ (Block2Data* _data2_,
             const gchar* key)
{
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	_vala_assert (g_strcmp0 (key, "new-cat") == 0, "key == \"new-cat\"");
	_tmp0_ = _data2_->category;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static GamesScoresCategory*
____lambda5__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = ___lambda5_ (self, category_key);
	return result;
}


static gchar*
___lambda6_ (const gchar* old_key)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (old_key != NULL, NULL);
	_vala_assert (g_strcmp0 (old_key, "old-cat") == 0, "old_key == \"old-cat\"");
	_tmp0_ = g_strdup ("new-cat");
	result = _tmp0_;
	return result;
}


static gchar*
____lambda6__games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                    gpointer self)
{
	gchar* result;
	result = ___lambda6_ (old_key);
	return result;
}


void
games_scores_test_import_from_score_directory (void)
{
	GError * _inner_error_ = NULL;
	{
		Block2Data* _data2_;
		GamesScoresScore* expected_score = NULL;
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		const gchar* _tmp2_;
		GamesScoresScore* _tmp3_;
		GamesScoresScore* _tmp4_;
		GamesScoresCategory* _tmp5_;
		GFile* test_directory = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFile* old_scores_file = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		GFileOutputStream* stream = NULL;
		GFile* _tmp17_;
		GFileOutputStream* _tmp18_;
		GFileOutputStream* _tmp19_;
		GamesScoresScore* _tmp20_;
		glong _tmp21_;
		glong _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GamesScoresScore* _tmp25_;
		gint64 _tmp26_;
		gint64 _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		guint8* _tmp32_;
		gint _tmp32__length1;
		guint8* _tmp33_;
		gint _tmp33__length1;
		GFileOutputStream* _tmp34_;
		GFile* _tmp35_;
		GamesScoresContext* context = NULL;
		GamesScoresDirectoryImporter* _tmp36_;
		GamesScoresDirectoryImporter* _tmp37_;
		GamesScoresContext* _tmp38_;
		GamesScoresContext* _tmp39_;
		GFile* _tmp40_;
		GeeList* imported_scores = NULL;
		GamesScoresCategory* _tmp41_;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		GamesScoresScore* imported_score = NULL;
		gpointer _tmp45_;
		GamesScoresScore* _tmp46_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_tmp0_ = g_date_time_new_now_local ();
		_tmp1_ = _tmp0_;
		_tmp2_ = g_get_real_name ();
		_tmp3_ = games_scores_score_new ((glong) 42, g_date_time_to_unix (_tmp1_), _tmp2_);
		_tmp4_ = _tmp3_;
		_g_date_time_unref0 (_tmp1_);
		expected_score = _tmp4_;
		_tmp5_ = games_scores_category_new ("new-cat", "");
		_data2_->category = _tmp5_;
		_tmp6_ = games_scores_get_test_directory_name ();
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		test_directory = _tmp9_;
		_tmp10_ = test_directory;
		g_file_make_directory_with_parents (_tmp10_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			goto __catch3_g_error;
		}
		_tmp11_ = games_scores_get_test_directory_name ();
		_tmp12_ = _tmp11_;
		_tmp13_ = g_build_filename (_tmp12_, "old-cat", NULL, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		old_scores_file = _tmp16_;
		_tmp17_ = old_scores_file;
		_tmp18_ = g_file_append_to (_tmp17_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		stream = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (old_scores_file);
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			goto __catch3_g_error;
		}
		_tmp19_ = stream;
		_tmp20_ = expected_score;
		_tmp21_ = games_scores_score_get_score (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf ("%li", _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = expected_score;
		_tmp26_ = games_scores_score_get_time (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp24_, " ", _tmp29_, "\n", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = string_get_data (_tmp31_, &_tmp32__length1);
		_tmp33_ = _tmp32_;
		_tmp33__length1 = _tmp32__length1;
		g_output_stream_write_all ((GOutputStream*) _tmp19_, _tmp33_, (gsize) _tmp33__length1, NULL, NULL, &_inner_error_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp24_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (old_scores_file);
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			goto __catch3_g_error;
		}
		_tmp34_ = stream;
		g_output_stream_close ((GOutputStream*) _tmp34_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (old_scores_file);
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			goto __catch3_g_error;
		}
		_tmp35_ = old_scores_file;
		_vala_assert (g_file_query_exists (_tmp35_, NULL), "old_scores_file.query_exists ()");
		_tmp36_ = games_scores_directory_importer_new_with_convert_func (____lambda6__games_scores_directory_importer_category_convert_func, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = games_scores_context_new_with_importer ("libgnome-games-support-test", "", NULL, ____lambda5__games_scores_context_category_request_func, _data2_, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp37_);
		_tmp39_ = _tmp38_;
		_g_object_unref0 (_tmp37_);
		context = _tmp39_;
		_tmp40_ = old_scores_file;
		_vala_assert (!g_file_query_exists (_tmp40_, NULL), "!old_scores_file.query_exists ()");
		_tmp41_ = _data2_->category;
		_tmp42_ = games_scores_context_get_high_scores (context, _tmp41_, 10);
		imported_scores = _tmp42_;
		_tmp43_ = gee_collection_get_size ((GeeCollection*) imported_scores);
		_tmp44_ = _tmp43_;
		_vala_assert (_tmp44_ == 1, "imported_scores.size == 1");
		_tmp45_ = gee_list_first (imported_scores);
		imported_score = (GamesScoresScore*) _tmp45_;
		_tmp46_ = expected_score;
		_vala_assert (games_scores_score_equals (_tmp46_, imported_score), "Score.equals (expected_score, imported_score)");
		_g_object_unref0 (imported_score);
		_g_object_unref0 (imported_scores);
		_g_object_unref0 (context);
		_g_object_unref0 (stream);
		_g_object_unref0 (old_scores_file);
		_g_object_unref0 (test_directory);
		_g_object_unref0 (expected_score);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp47_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp47_ = e->message;
		g_error ("test-scores.vala:202: %s", _tmp47_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->category);
		g_slice_free (Block3Data, _data3_);
	}
}


static GamesScoresCategory*
___lambda7_ (Block3Data* _data3_,
             const gchar* key)
{
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	_vala_assert (g_strcmp0 (key, "new-cat") == 0, "key == \"new-cat\"");
	_tmp0_ = _data3_->category;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static GamesScoresCategory*
____lambda7__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = ___lambda7_ (self, category_key);
	return result;
}


static void
___lambda8_ (Block3Data* _data3_,
             const gchar* line,
             GamesScoresScore* * score,
             GamesScoresCategory* * out_category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_out_category = NULL;
	GamesScoresScore* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GamesScoresCategory* _tmp3_;
	GamesScoresCategory* _tmp4_;
	g_return_if_fail (line != NULL);
	_vala_assert (g_strcmp0 (line, "2016-02-13T23:15:45-0600 old-cat 42") == 0, "line == \"2016-02-13T23:15:45-0600 old-cat 42\"");
	_tmp0_ = games_scores_score_new ((glong) 42, games_scores_history_file_importer_parse_date ("2016-02-13T23:15:45-0600"), NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = _tmp0_;
	_tmp1_ = games_scores_score_get_time (_vala_score);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ == ((gint64) 1455426945), "score.time == 1455426945");
	_tmp3_ = _data3_->category;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_vala_out_category);
	_vala_out_category = _tmp4_;
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (out_category) {
		*out_category = _vala_out_category;
	} else {
		_g_object_unref0 (_vala_out_category);
	}
}


static void
____lambda8__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                      GamesScoresScore* * score,
                                                                      GamesScoresCategory* * category,
                                                                      gpointer self)
{
	___lambda8_ (self, line, score, category);
}


void
games_scores_test_import_from_history_file (void)
{
	GError * _inner_error_ = NULL;
	{
		Block3Data* _data3_;
		GamesScoresScore* expected_score = NULL;
		const gchar* _tmp0_;
		GamesScoresScore* _tmp1_;
		GamesScoresCategory* _tmp2_;
		GFile* test_directory = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* old_scores_file = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFileOutputStream* stream = NULL;
		GFile* _tmp14_;
		GFileOutputStream* _tmp15_;
		GFileOutputStream* _tmp16_;
		guint8* _tmp17_;
		gint _tmp17__length1;
		guint8* _tmp18_;
		gint _tmp18__length1;
		GFileOutputStream* _tmp19_;
		GFile* _tmp20_;
		GamesScoresContext* context = NULL;
		GamesScoresHistoryFileImporter* _tmp21_;
		GamesScoresHistoryFileImporter* _tmp22_;
		GamesScoresContext* _tmp23_;
		GamesScoresContext* _tmp24_;
		GFile* _tmp25_;
		GeeList* imported_scores = NULL;
		GamesScoresCategory* _tmp26_;
		GeeList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		GamesScoresScore* imported_score = NULL;
		gpointer _tmp30_;
		GamesScoresScore* _tmp31_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_tmp0_ = g_get_real_name ();
		_tmp1_ = games_scores_score_new ((glong) 42, (gint64) 1455426945, _tmp0_);
		expected_score = _tmp1_;
		_tmp2_ = games_scores_category_new ("new-cat", "");
		_data3_->category = _tmp2_;
		_tmp3_ = games_scores_get_test_directory_name ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		test_directory = _tmp6_;
		_tmp7_ = test_directory;
		g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			goto __catch4_g_error;
		}
		_tmp8_ = games_scores_get_test_directory_name ();
		_tmp9_ = _tmp8_;
		_tmp10_ = g_build_filename (_tmp9_, "history", NULL, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_new_for_path (_tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		old_scores_file = _tmp13_;
		_tmp14_ = old_scores_file;
		_tmp15_ = g_file_append_to (_tmp14_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		stream = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (old_scores_file);
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			goto __catch4_g_error;
		}
		_tmp16_ = stream;
		_tmp17_ = string_get_data ("2016-02-13T23:15:45-0600 old-cat 42\n", &_tmp17__length1);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = _tmp17__length1;
		g_output_stream_write_all ((GOutputStream*) _tmp16_, _tmp18_, (gsize) _tmp18__length1, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (old_scores_file);
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			goto __catch4_g_error;
		}
		_tmp19_ = stream;
		g_output_stream_close ((GOutputStream*) _tmp19_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (old_scores_file);
			_g_object_unref0 (test_directory);
			_g_object_unref0 (expected_score);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			goto __catch4_g_error;
		}
		_tmp20_ = old_scores_file;
		_vala_assert (g_file_query_exists (_tmp20_, NULL), "old_scores_file.query_exists ()");
		_tmp21_ = games_scores_history_file_importer_new (____lambda8__games_scores_history_file_importer_history_convert_func, _data3_);
		_tmp22_ = _tmp21_;
		_tmp23_ = games_scores_context_new_with_importer ("libgnome-games-support-test", "", NULL, ____lambda7__games_scores_context_category_request_func, _data3_, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		context = _tmp24_;
		_tmp25_ = old_scores_file;
		_vala_assert (!g_file_query_exists (_tmp25_, NULL), "!old_scores_file.query_exists ()");
		_tmp26_ = _data3_->category;
		_tmp27_ = games_scores_context_get_high_scores (context, _tmp26_, 10);
		imported_scores = _tmp27_;
		_tmp28_ = gee_collection_get_size ((GeeCollection*) imported_scores);
		_tmp29_ = _tmp28_;
		_vala_assert (_tmp29_ == 1, "imported_scores.size == 1");
		_tmp30_ = gee_list_first (imported_scores);
		imported_score = (GamesScoresScore*) _tmp30_;
		_tmp31_ = expected_score;
		_vala_assert (games_scores_score_equals (_tmp31_, imported_score), "Score.equals (expected_score, imported_score)");
		_g_object_unref0 (imported_score);
		_g_object_unref0 (imported_scores);
		_g_object_unref0 (context);
		_g_object_unref0 (stream);
		_g_object_unref0 (old_scores_file);
		_g_object_unref0 (test_directory);
		_g_object_unref0 (expected_score);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = e->message;
		g_error ("test-scores.vala:251: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GamesScoresCategory*
__lambda9_ (const gchar* key)
{
	GamesScoresCategory* result = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	result = NULL;
	return result;
}


static GamesScoresCategory*
___lambda9__games_scores_context_category_request_func (const gchar* category_key,
                                                        gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda9_ (category_key);
	return result;
}


static void
__lambda10_ (const gchar* line,
             GamesScoresScore* * score,
             GamesScoresCategory* * category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	g_return_if_fail (line != NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = NULL;
	_g_object_unref0 (_vala_category);
	_vala_category = NULL;
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (category) {
		*category = _vala_category;
	} else {
		_g_object_unref0 (_vala_category);
	}
}


static void
___lambda10__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                      GamesScoresScore* * score,
                                                                      GamesScoresCategory* * category,
                                                                      gpointer self)
{
	__lambda10_ (line, score, category);
}


void
games_scores_test_import_from_nonexistent_history_file (void)
{
	GamesScoresHistoryFileImporter* _tmp0_;
	GamesScoresHistoryFileImporter* _tmp1_;
	GamesScoresContext* _tmp2_;
	_tmp0_ = games_scores_history_file_importer_new (___lambda10__games_scores_history_file_importer_history_convert_func, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_context_new_with_importer ("libgnome-games-support-test", "", NULL, ___lambda9__games_scores_context_category_request_func, NULL, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}


static void
__lambda11_ (void)
{
}


static void
___lambda11__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
	__lambda11_ ();
}


static void
_games_scores_test_scores_files_exist_gtest_fixture_func (void* fixture,
                                                          gpointer self)
{
	games_scores_test_scores_files_exist ();
}


static void
_games_scores_delete_scores_gtest_fixture_func (void* fixture,
                                                gpointer self)
{
	games_scores_delete_scores ();
}


static void
__lambda12_ (void)
{
}


static void
___lambda12__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
	__lambda12_ ();
}


static void
_games_scores_test_save_score_to_file_gtest_fixture_func (void* fixture,
                                                          gpointer self)
{
	games_scores_test_save_score_to_file ();
}


static void
__lambda13_ (void)
{
}


static void
___lambda13__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
	__lambda13_ ();
}


static void
_games_scores_test_import_from_score_directory_gtest_fixture_func (void* fixture,
                                                                   gpointer self)
{
	games_scores_test_import_from_score_directory ();
}


static void
__lambda14_ (void)
{
}


static void
___lambda14__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
	__lambda14_ ();
}


static void
_games_scores_test_import_from_history_file_gtest_fixture_func (void* fixture,
                                                                gpointer self)
{
	games_scores_test_import_from_history_file ();
}


static void
__lambda15_ (void)
{
}


static void
___lambda15__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
	__lambda15_ ();
}


static void
_games_scores_test_import_from_nonexistent_history_file_gtest_fixture_func (void* fixture,
                                                                            gpointer self)
{
	games_scores_test_import_from_nonexistent_history_file ();
}


gint
games_scores_main (const gchar* args,
                   int args_length1)
{
	gint result = 0;
	GTestSuite* test_suite = NULL;
	GTestSuite* _tmp0_;
	GTestCase* _tmp1_;
	GTestCase* _tmp2_;
	GTestCase* _tmp3_;
	GTestCase* _tmp4_;
	GTestCase* _tmp5_;
	games_scores_delete_scores ();
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	test_suite = _tmp0_;
	_tmp1_ = g_test_create_case ("Scores Files Created", (gsize) 0, NULL, ___lambda11__gtest_fixture_func, _games_scores_test_scores_files_exist_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
	g_test_suite_add (test_suite, _tmp1_);
	_tmp2_ = g_test_create_case ("Save Score to File", (gsize) 0, NULL, ___lambda12__gtest_fixture_func, _games_scores_test_save_score_to_file_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
	g_test_suite_add (test_suite, _tmp2_);
	_tmp3_ = g_test_create_case ("Import from Score Directory", (gsize) 0, NULL, ___lambda13__gtest_fixture_func, _games_scores_test_import_from_score_directory_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
	g_test_suite_add (test_suite, _tmp3_);
	_tmp4_ = g_test_create_case ("Import from History File", (gsize) 0, NULL, ___lambda14__gtest_fixture_func, _games_scores_test_import_from_history_file_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
	g_test_suite_add (test_suite, _tmp4_);
	_tmp5_ = g_test_create_case ("Import from Nonexistent History File", (gsize) 0, NULL, ___lambda15__gtest_fixture_func, _games_scores_test_import_from_nonexistent_history_file_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
	g_test_suite_add (test_suite, _tmp5_);
	result = g_test_run ();
	return result;
}


int
main (int argc,
      char ** argv)
{
	return games_scores_main (argv, argc);
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



