// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Dialog, DialogPresentationMode, ResponseAppearance};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwAlertDialog")]
    pub struct AlertDialog(Object<ffi::AdwAlertDialog, ffi::AdwAlertDialogClass>) @extends Dialog, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::adw_alert_dialog_get_type(),
    }
}

impl AlertDialog {
    pub const NONE: Option<&'static AlertDialog> = None;

    #[doc(alias = "adw_alert_dialog_new")]
    pub fn new(heading: Option<&str>, body: Option<&str>) -> AlertDialog {
        assert_initialized_main_thread!();
        unsafe {
            Dialog::from_glib_none(ffi::adw_alert_dialog_new(
                heading.to_glib_none().0,
                body.to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`AlertDialog`] objects.
    ///
    /// This method returns an instance of [`AlertDialogBuilder`](crate::builders::AlertDialogBuilder) which can be used to create [`AlertDialog`] objects.
    pub fn builder() -> AlertDialogBuilder {
        AlertDialogBuilder::new()
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl Default for AlertDialog {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`AlertDialog`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AlertDialogBuilder {
    builder: glib::object::ObjectBuilder<'static, AlertDialog>,
}

impl AlertDialogBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn body(self, body: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("body", body.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn body_use_markup(self, body_use_markup: bool) -> Self {
        Self {
            builder: self.builder.property("body-use-markup", body_use_markup),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn close_response(self, close_response: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("close-response", close_response.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn default_response(self, default_response: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-response", default_response.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn extra_child(self, extra_child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-child", extra_child.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn heading(self, heading: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("heading", heading.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn heading_use_markup(self, heading_use_markup: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("heading-use-markup", heading_use_markup),
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    pub fn prefer_wide_layout(self, prefer_wide_layout: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("prefer-wide-layout", prefer_wide_layout),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn can_close(self, can_close: bool) -> Self {
        Self {
            builder: self.builder.property("can-close", can_close),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn child(self, child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn content_height(self, content_height: i32) -> Self {
        Self {
            builder: self.builder.property("content-height", content_height),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn content_width(self, content_width: i32) -> Self {
        Self {
            builder: self.builder.property("content-width", content_width),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn default_widget(self, default_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-widget", default_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn focus_widget(self, focus_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("focus-widget", focus_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn follows_content_size(self, follows_content_size: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("follows-content-size", follows_content_size),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn presentation_mode(self, presentation_mode: DialogPresentationMode) -> Self {
        Self {
            builder: self
                .builder
                .property("presentation-mode", presentation_mode),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`AlertDialog`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> AlertDialog {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::AlertDialog>> Sealed for T {}
}

pub trait AlertDialogExt: IsA<AlertDialog> + sealed::Sealed + 'static {
    #[doc(alias = "adw_alert_dialog_add_response")]
    fn add_response(&self, id: &str, label: &str) {
        unsafe {
            ffi::adw_alert_dialog_add_response(
                self.as_ref().to_glib_none().0,
                id.to_glib_none().0,
                label.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_get_body")]
    #[doc(alias = "get_body")]
    fn body(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_alert_dialog_get_body(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_body_use_markup")]
    #[doc(alias = "get_body_use_markup")]
    #[doc(alias = "body-use-markup")]
    fn is_body_use_markup(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_alert_dialog_get_body_use_markup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_close_response")]
    #[doc(alias = "get_close_response")]
    #[doc(alias = "close-response")]
    fn close_response(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_alert_dialog_get_close_response(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_default_response")]
    #[doc(alias = "get_default_response")]
    #[doc(alias = "default-response")]
    fn default_response(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_alert_dialog_get_default_response(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_extra_child")]
    #[doc(alias = "get_extra_child")]
    #[doc(alias = "extra-child")]
    fn extra_child(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_alert_dialog_get_extra_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_heading")]
    #[doc(alias = "get_heading")]
    fn heading(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_alert_dialog_get_heading(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_heading_use_markup")]
    #[doc(alias = "get_heading_use_markup")]
    #[doc(alias = "heading-use-markup")]
    fn is_heading_use_markup(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_alert_dialog_get_heading_use_markup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_prefer_wide_layout")]
    #[doc(alias = "get_prefer_wide_layout")]
    #[doc(alias = "prefer-wide-layout")]
    fn prefers_wide_layout(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_alert_dialog_get_prefer_wide_layout(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_response_appearance")]
    #[doc(alias = "get_response_appearance")]
    fn response_appearance(&self, response: &str) -> ResponseAppearance {
        unsafe {
            from_glib(ffi::adw_alert_dialog_get_response_appearance(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_get_response_enabled")]
    #[doc(alias = "get_response_enabled")]
    fn is_response_enabled(&self, response: &str) -> bool {
        unsafe {
            from_glib(ffi::adw_alert_dialog_get_response_enabled(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_has_response")]
    fn has_response(&self, response: &str) -> bool {
        unsafe {
            from_glib(ffi::adw_alert_dialog_has_response(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_alert_dialog_remove_response")]
    fn remove_response(&self, id: &str) {
        unsafe {
            ffi::adw_alert_dialog_remove_response(
                self.as_ref().to_glib_none().0,
                id.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_body")]
    #[doc(alias = "body")]
    fn set_body(&self, body: &str) {
        unsafe {
            ffi::adw_alert_dialog_set_body(self.as_ref().to_glib_none().0, body.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_alert_dialog_set_body_use_markup")]
    #[doc(alias = "body-use-markup")]
    fn set_body_use_markup(&self, use_markup: bool) {
        unsafe {
            ffi::adw_alert_dialog_set_body_use_markup(
                self.as_ref().to_glib_none().0,
                use_markup.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_close_response")]
    #[doc(alias = "close-response")]
    fn set_close_response(&self, response: &str) {
        unsafe {
            ffi::adw_alert_dialog_set_close_response(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_default_response")]
    #[doc(alias = "default-response")]
    fn set_default_response(&self, response: Option<&str>) {
        unsafe {
            ffi::adw_alert_dialog_set_default_response(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_extra_child")]
    #[doc(alias = "extra-child")]
    fn set_extra_child(&self, child: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::adw_alert_dialog_set_extra_child(
                self.as_ref().to_glib_none().0,
                child.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_heading")]
    #[doc(alias = "heading")]
    fn set_heading(&self, heading: Option<&str>) {
        unsafe {
            ffi::adw_alert_dialog_set_heading(
                self.as_ref().to_glib_none().0,
                heading.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_heading_use_markup")]
    #[doc(alias = "heading-use-markup")]
    fn set_heading_use_markup(&self, use_markup: bool) {
        unsafe {
            ffi::adw_alert_dialog_set_heading_use_markup(
                self.as_ref().to_glib_none().0,
                use_markup.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    #[doc(alias = "adw_alert_dialog_set_prefer_wide_layout")]
    #[doc(alias = "prefer-wide-layout")]
    fn set_prefer_wide_layout(&self, prefer_wide_layout: bool) {
        unsafe {
            ffi::adw_alert_dialog_set_prefer_wide_layout(
                self.as_ref().to_glib_none().0,
                prefer_wide_layout.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_response_appearance")]
    fn set_response_appearance(&self, response: &str, appearance: ResponseAppearance) {
        unsafe {
            ffi::adw_alert_dialog_set_response_appearance(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
                appearance.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_response_enabled")]
    fn set_response_enabled(&self, response: &str, enabled: bool) {
        unsafe {
            ffi::adw_alert_dialog_set_response_enabled(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_alert_dialog_set_response_label")]
    fn set_response_label(&self, response: &str, label: &str) {
        unsafe {
            ffi::adw_alert_dialog_set_response_label(
                self.as_ref().to_glib_none().0,
                response.to_glib_none().0,
                label.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "response")]
    fn connect_response<F: Fn(&Self, &str) + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn response_trampoline<P: IsA<AlertDialog>, F: Fn(&P, &str) + 'static>(
            this: *mut ffi::AdwAlertDialog,
            response: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                AlertDialog::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(response),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            let detailed_signal_name = detail.map(|name| format!("response::{name}\0"));
            let signal_name: &[u8] = detailed_signal_name
                .as_ref()
                .map_or(&b"response\0"[..], |n| n.as_bytes());
            connect_raw(
                self.as_ptr() as *mut _,
                signal_name.as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    response_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "body")]
    fn connect_body_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_body_trampoline<P: IsA<AlertDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::body\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_body_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "body-use-markup")]
    fn connect_body_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_body_use_markup_trampoline<
            P: IsA<AlertDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::body-use-markup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_body_use_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "close-response")]
    fn connect_close_response_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_close_response_trampoline<
            P: IsA<AlertDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::close-response\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_close_response_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "default-response")]
    fn connect_default_response_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_response_trampoline<
            P: IsA<AlertDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-response\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_response_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "extra-child")]
    fn connect_extra_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_child_trampoline<
            P: IsA<AlertDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-child\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_extra_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "heading")]
    fn connect_heading_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_heading_trampoline<P: IsA<AlertDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::heading\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_heading_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "heading-use-markup")]
    fn connect_heading_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_heading_use_markup_trampoline<
            P: IsA<AlertDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::heading-use-markup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_heading_use_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    #[doc(alias = "prefer-wide-layout")]
    fn connect_prefer_wide_layout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_prefer_wide_layout_trampoline<
            P: IsA<AlertDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AlertDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::prefer-wide-layout\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_prefer_wide_layout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<AlertDialog>> AlertDialogExt for O {}
