/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.ValueMath;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DraggablePoint;
import edu.hws.jcm.draw.DrawGeometric;
import edu.hws.jcm.draw.DrawString;
import edu.hws.jcm.draw.Drawable;
import edu.hws.jcm.draw.Graph1D;
import edu.hws.jcm.draw.TangentLine;
import edu.hws.jcm.functions.WrapperFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SecantTangent
extends GenericGraphApplet {
    private Function func;
    VariableInput x1Input = new VariableInput();
    VariableInput x2Input = new VariableInput();

    protected void setUpParameterDefaults() {
        this.parameterDefaults = new Hashtable();
        String string = this.getParameter("Variable", "x");
        this.parameterDefaults.put("Function", " e ^ " + string);
    }

    protected void setUpCanvas() {
        Serializable serializable;
        Object object;
        super.setUpCanvas();
        if (this.functionInput != null) {
            this.func = this.functionInput.getFunction(this.xVar);
        } else {
            object = this.getParameter("Function");
            serializable = new SimpleFunction((Expression)this.parser.parse((String)object), this.xVar);
            this.func = new WrapperFunction((Function)serializable);
        }
        object = new Graph1D(this.func);
        serializable = this.getColorParam("GraphColor", Color.black);
        ((Graph1D)object).setColor((Color)serializable);
        Color color = this.getColorParam("TangentColor", Color.red);
        Color color2 = this.getColorParam("SecantColor", new Color(0, 200, 0));
        DraggablePoint draggablePoint = new DraggablePoint();
        DraggablePoint draggablePoint2 = new DraggablePoint();
        draggablePoint.clampY(this.func);
        draggablePoint2.clampY(this.func);
        draggablePoint.setColor(color);
        draggablePoint.setGhostColor(this.lighten(color));
        draggablePoint2.setColor(color2);
        draggablePoint2.setGhostColor(this.lighten(color2));
        DrawGeometric drawGeometric = new DrawGeometric(1, (Value)draggablePoint.getXVar(), (Value)draggablePoint.getYVar(), draggablePoint2.getXVar(), draggablePoint2.getYVar());
        drawGeometric.setColor(color2);
        TangentLine tangentLine = new TangentLine(draggablePoint.getXVar(), this.func);
        tangentLine.setColor(color);
        this.canvas.add(draggablePoint);
        this.canvas.add(draggablePoint2);
        this.canvas.add(tangentLine);
        this.canvas.add(drawGeometric);
        this.canvas.add((Drawable)object);
        ValueMath valueMath = new ValueMath(this.func.derivative(1), draggablePoint.getXVar());
        ValueMath valueMath2 = new ValueMath(new ValueMath(draggablePoint2.getYVar(), draggablePoint.getYVar(), '-'), new ValueMath(draggablePoint2.getXVar(), draggablePoint.getXVar(), '-'), '/');
        DrawString drawString = "no".equalsIgnoreCase(this.getParameter("ShowTangentSlope", "yes")) ? new DrawString("Secant Slope = #", 0, new Value[]{valueMath2}) : new DrawString("Secant Slope = #\nTangent Slope = #", 0, new Value[]{valueMath2, valueMath});
        drawString.setFont(new Font("Monospaced", 0, 10));
        drawString.setNumSize(7);
        drawString.setColor(this.getColorParam("SlopeTextColor", Color.black));
        drawString.setBackgroundColor(this.getColorParam("SlopeTextBackground", Color.white));
        drawString.setFrameWidth(1);
        this.canvas.add(drawString);
        Panel panel = new Panel();
        panel.setBackground(this.getColorParam("PanelColor", Color.lightGray));
        panel.setLayout(new GridLayout(1, 4, 3, 3));
        panel.add(new Label("Tangent at " + this.xVar.getName() + " = ", 2));
        panel.add(this.x1Input);
        panel.add(new Label("Secant to  " + this.xVar.getName() + " = ", 2));
        panel.add(this.x2Input);
        if (this.inputPanel == null) {
            this.mainPanel.add((Component)panel, "South");
        } else {
            this.inputPanel.add((Component)panel, "South");
        }
        Controller controller = new Controller();
        this.mainController.remove(this.canvas);
        this.mainController.add(object);
        this.mainController.add(controller);
        controller.add(this.x1Input);
        controller.add(this.x2Input);
        controller.add(draggablePoint);
        controller.add(draggablePoint2);
        controller.add(tangentLine);
        controller.add(drawGeometric);
        controller.add(drawString);
        draggablePoint.setOnUserAction(controller);
        draggablePoint2.setOnUserAction(controller);
        this.x1Input.setOnTextChange(controller);
        this.x2Input.setOnTextChange(controller);
        controller.add(new Tie((Tieable)((Object)draggablePoint.getXVar()), this.x1Input));
        controller.add(new Tie((Tieable)((Object)draggablePoint2.getXVar()), this.x2Input));
        double[] dArray = this.getNumericParam("X1");
        double d = dArray != null && dArray.length == 1 ? dArray[0] : 0.0;
        this.x1Input.setVal(d);
        draggablePoint.setLocation(d, 0.0);
        double[] dArray2 = this.getNumericParam("X2");
        double d2 = dArray2 != null && dArray2.length == 1 ? dArray2[0] : 1.0;
        this.x2Input.setVal(d2);
        draggablePoint2.setLocation(d2, 0.0);
    }

    private Color lighten(Color color) {
        int n;
        int n2;
        int n3;
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        if (n4 <= 200 || n5 <= 200 || n6 <= 200) {
            n3 = 255 - (255 - n6) / 3;
            n2 = 255 - (255 - n5) / 3;
            n = 255 - (255 - n4) / 3;
        } else {
            n3 = n6 / 2;
            n2 = n5 / 2;
            n = n4 / 2;
        }
        return new Color(n, n2, n3);
    }

    protected void doLoadExample(String string) {
        Object object;
        int n = string.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            object = string.substring(n + 1);
            string = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,");
            if (stringTokenizer.countTokens() >= 4) {
                for (int i = 0; i < 4; ++i) {
                    try {
                        Double d = new Double(stringTokenizer.nextToken());
                        dArray[i] = d;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (stringTokenizer.countTokens() > 0) {
                    try {
                        Double d = new Double(stringTokenizer.nextToken());
                        this.x1Input.setVal(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (stringTokenizer.countTokens() > 0) {
                    try {
                        Double d = new Double(stringTokenizer.nextToken());
                        this.x2Input.setVal(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
        } else {
            try {
                object = new SimpleFunction((Expression)this.parser.parse(string), this.xVar);
                ((WrapperFunction)this.func).setFunction((Function)object);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object).setLimits(dArray);
        ((CoordinateRect)object).setRestoreBuffer();
        this.mainController.compute();
    }
}

