/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Animator;
import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.ExpressionInput;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DrawTemp;
import edu.hws.jcm.draw.VectorField;
import edu.hws.jcm.functions.WrapperFunction;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class IntegralCurves
extends GenericGraphApplet {
    private Variable yVar;
    private Function xFunc;
    private Function yFunc;
    private ExpressionInput functionInput2;
    private VectorField field;
    private Animator animator;
    private Vector curves = new Vector();
    private VariableInput deltaT;
    double dt = 0.1;
    private VariableInput xStart;
    private VariableInput yStart;
    private Choice methodChoice;
    private Button startCurveButton;
    private Button clearButton;
    private Color curveColor;
    private Draw curveDrawer = new Draw();
    private double[] nextPoint = new double[2];
    private double[] params = new double[2];
    private static final int RK4 = 0;
    private static final int RK2 = 1;
    private static final int EULER = 2;

    protected void setUpParser() {
        this.yVar = new Variable(this.getParameter("Variable2", "y"));
        this.parser.add(this.yVar);
        super.setUpParser();
        this.parameterDefaults = new Hashtable();
        this.parameterDefaults.put("FunctionLabel", " f1(" + this.xVar.getName() + "," + this.yVar.getName() + ") = ");
        this.parameterDefaults.put("FunctionLabel2", " f2(" + this.xVar.getName() + "," + this.yVar.getName() + ") = ");
        this.parameterDefaults.put("Function", " " + this.yVar.getName() + " - 0.1*" + this.xVar.getName());
        this.parameterDefaults.put("Function2", " - " + this.xVar.getName() + " - 0.1*" + this.yVar.getName());
        this.defaultFrameSize = new int[]{580, 440};
    }

    protected void setUpCanvas() {
        Serializable serializable;
        String string;
        super.setUpCanvas();
        if (this.functionInput != null) {
            this.xFunc = this.functionInput.getFunction(new Variable[]{this.xVar, this.yVar});
            this.yFunc = this.functionInput2.getFunction(new Variable[]{this.xVar, this.yVar});
        } else {
            string = this.getParameter("Function");
            String string2 = this.getParameter("Function2");
            serializable = new SimpleFunction((Expression)this.parser.parse(string), new Variable[]{this.xVar, this.yVar});
            this.xFunc = new WrapperFunction((Function)serializable);
            serializable = new SimpleFunction((Expression)this.parser.parse(string2), new Variable[]{this.xVar, this.yVar});
            this.yFunc = new WrapperFunction((Function)serializable);
        }
        string = (this.getParameter("VectorStyle", "") + "A").toUpperCase();
        int n = 0;
        switch (string.charAt(0)) {
            case 'A': {
                n = 0;
                break;
            }
            case 'L': {
                n = 1;
                break;
            }
            case 'S': {
                n = 4;
            }
        }
        this.field = new VectorField(this.xFunc, this.yFunc, n);
        serializable = this.getColorParam("VectorColor");
        if (serializable != null) {
            this.field.setColor((Color)serializable);
        }
        int n2 = n == 1 ? 20 : 30;
        double[] dArray = this.getNumericParam("VectorSpacing");
        if (dArray != null && dArray.length > 0 && dArray[0] >= 1.0) {
            n2 = (int)Math.round(dArray[0]);
        }
        this.field.setPixelSpacing(n2);
        this.canvas.add(this.field);
        this.curveColor = this.getColorParam("CurveColor", Color.magenta);
        if ("yes".equalsIgnoreCase(this.getParameter("MouseStartsCurves", "yes")) && "yes".equalsIgnoreCase(this.getParameter("DoCurves", "yes"))) {
            this.canvas.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    CoordinateRect coordinateRect = IntegralCurves.this.canvas.getCoordinateRect();
                    double d = coordinateRect.pixelToX(mouseEvent.getX());
                    double d2 = coordinateRect.pixelToY(mouseEvent.getY());
                    if (IntegralCurves.this.xStart != null) {
                        IntegralCurves.this.xStart.setVal(d);
                    }
                    if (IntegralCurves.this.yStart != null) {
                        IntegralCurves.this.yStart.setVal(d2);
                    }
                    IntegralCurves.this.startCurve(d, d2);
                }
            });
        }
    }

    protected void setUpBottomPanel() {
        Panel panel;
        Panel panel2;
        Object object;
        double[] dArray = this.getNumericParam("DeltaT");
        if (dArray != null && dArray.length != 0 && !(dArray[0] <= 0.0)) {
            this.dt = dArray[0];
        }
        boolean bl = "yes".equalsIgnoreCase(this.getParameter("DoCurves", "yes"));
        boolean bl2 = "yes".equalsIgnoreCase(this.getParameter("UseFunctionInput", "yes"));
        if (!bl && !bl2) {
            return;
        }
        this.inputPanel = new JCMPanel();
        this.inputPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
        this.mainPanel.add((Component)this.inputPanel, "South");
        JCMPanel jCMPanel = null;
        JCMPanel jCMPanel2 = null;
        if (bl2) {
            if ("yes".equalsIgnoreCase(this.getParameter("UseComputeButton", "yes"))) {
                object = this.getParameter("ComputeButtonName", "New Functions");
                this.computeButton = new Button((String)object);
                this.computeButton.addActionListener(this);
            }
            this.functionInput = new ExpressionInput(this.getParameter("Function"), this.parser);
            jCMPanel = new JCMPanel();
            jCMPanel.add((Component)this.functionInput, "Center");
            jCMPanel.add((Component)new Label(this.getParameter("FunctionLabel")), "West");
            this.functionInput.setOnUserAction(this.mainController);
            this.functionInput2 = new ExpressionInput(this.getParameter("Function2"), this.parser);
            jCMPanel2 = new JCMPanel();
            jCMPanel2.add((Component)this.functionInput2, "Center");
            jCMPanel2.add((Component)new Label(this.getParameter("FunctionLabel2")), "West");
            this.functionInput2.setOnUserAction(this.mainController);
        }
        if (!bl) {
            object = new JCMPanel(2, 1, 3);
            ((Container)object).add(jCMPanel);
            ((Container)object).add(jCMPanel2);
            this.inputPanel.add((Component)object, "Center");
            if (this.computeButton != null) {
                this.inputPanel.add((Component)this.computeButton, "East");
            }
            return;
        }
        this.animator = new Animator(8);
        this.animator.setStopButtonName("Stop Curves");
        this.animator.setOnChange(new Computable(){

            public void compute() {
                IntegralCurves.this.extendCurves();
            }
        });
        this.mainController.add(new InputObject(){

            public void checkInput() {
                IntegralCurves.this.curves.setSize(0);
                IntegralCurves.this.animator.stop();
            }

            public void notifyControllerOnChange(Controller controller) {
            }
        });
        this.clearButton = new Button("Clear");
        this.clearButton.addActionListener(this);
        object = null;
        if ("yes".equalsIgnoreCase(this.getParameter("UseStartInputs", "yes"))) {
            this.xStart = new VariableInput();
            this.xStart.addActionListener(this);
            this.yStart = new VariableInput();
            this.yStart.addActionListener(this);
            object = new Panel();
            this.startCurveButton = new Button("Start curve at:");
            this.startCurveButton.addActionListener(this);
            ((Container)object).add(this.startCurveButton);
            ((Container)object).add(new Label(this.xVar.getName() + " ="));
            ((Container)object).add(this.xStart);
            ((Container)object).add(new Label(this.yVar.getName() + " ="));
            ((Container)object).add(this.yStart);
        }
        boolean bl3 = "yes".equalsIgnoreCase(this.getParameter("UseMethodChoice", "yes"));
        boolean bl4 = "yes".equalsIgnoreCase(this.getParameter("UseDeltaInput", "yes"));
        if (bl3 || bl4) {
            panel2 = new Panel();
            if (bl4) {
                panel2.add(new Label("dt ="));
                this.deltaT = new VariableInput(null, "" + this.dt);
                panel2.add(this.deltaT);
            }
            if (bl3) {
                panel2.add(new Label("Method:"));
                this.methodChoice = new Choice();
                this.methodChoice.add("Runge-Kutta 4");
                this.methodChoice.add("Runge-Kutta 2");
                this.methodChoice.add("Euler");
                panel2.add(this.methodChoice);
            }
            panel2.add(this.animator);
            panel2.add(this.clearButton);
            if (object == null) {
                object = panel2;
            } else {
                panel = new Panel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)panel2, "North");
                panel.add((Component)object, "Center");
                object = panel;
            }
        } else {
            if (object == null) {
                object = new Panel();
            }
            ((Container)object).add(this.animator);
            ((Container)object).add(this.clearButton);
        }
        this.inputPanel.add((Component)object, "Center");
        if (jCMPanel == null) {
            return;
        }
        panel2 = new JCMPanel(1, 2);
        panel2.add(jCMPanel);
        panel2.add(jCMPanel2);
        if (this.computeButton != null) {
            panel = new JCMPanel();
            panel.add((Component)panel2, "Center");
            panel.add((Component)this.computeButton, "East");
            panel2 = panel;
        }
        this.inputPanel.add((Component)panel2, "North");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            Object object = actionEvent.getSource();
            if (object == this.clearButton) {
                this.canvas.clearErrorMessage();
                this.curves.setSize(0);
                this.animator.stop();
                this.canvas.compute();
            } else if (object == this.xStart || object == this.yStart || object == this.startCurveButton) {
                this.canvas.clearErrorMessage();
                double d = 0.0;
                double d2 = 0.0;
                try {
                    this.xStart.checkInput();
                    d = this.xStart.getVal();
                    this.yStart.checkInput();
                    d2 = this.yStart.getVal();
                    this.startCurve(d, d2);
                    if (this.deltaT == null) break block7;
                    this.deltaT.checkInput();
                    this.dt = this.deltaT.getVal();
                    if (this.dt <= 0.0) {
                        this.deltaT.requestFocus();
                        throw new JCMError("dt must be positive", this.deltaT);
                    }
                }
                catch (JCMError jCMError) {
                    this.curves.setSize(0);
                    this.animator.stop();
                    this.canvas.setErrorMessage(null, "Illegal Data For Curve.  " + jCMError.getMessage());
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCurve(double d, double d2) {
        Vector vector = this.curves;
        synchronized (vector) {
            int n;
            if (this.deltaT != null) {
                try {
                    this.deltaT.checkInput();
                    this.dt = this.deltaT.getVal();
                    if (this.dt <= 0.0) {
                        this.deltaT.requestFocus();
                        throw new JCMError("dt must be positive", this.deltaT);
                    }
                }
                catch (JCMError jCMError) {
                    this.curves.setSize(0);
                    this.animator.stop();
                    this.canvas.setErrorMessage(null, "Illegal Data For Curve.  " + jCMError.getMessage());
                    return;
                }
            }
            Curve curve = new Curve();
            curve.dt = this.dt;
            curve.method = n = this.methodChoice == null ? 0 : this.methodChoice.getSelectedIndex();
            curve.x = d;
            curve.y = d2;
            this.curves.addElement(curve);
            this.animator.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendCurves() {
        Vector vector = this.curves;
        synchronized (vector) {
            if (this.canvas == null || this.canvas.getCoordinateRect() == null) {
                return;
            }
            while (this.canvas.getCoordinateRect().getWidth() <= 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            int n = this.curves.size();
            for (int i = 0; i < n; ++i) {
                Curve curve = (Curve)this.curves.elementAt(i);
                curve.lastX = curve.x;
                curve.lastY = curve.y;
                this.nextPoint(curve.x, curve.y, curve.dt, curve.method);
                curve.x = this.nextPoint[0];
                curve.y = this.nextPoint[1];
            }
            CoordinateRect coordinateRect = this.canvas.getCoordinateRect();
            double d = 100000.0 * coordinateRect.getPixelWidth();
            double d2 = 100000.0 * coordinateRect.getPixelHeight();
            for (int i = n - 1; i >= 0; --i) {
                Curve curve = (Curve)this.curves.elementAt(i);
                if (!Double.isNaN(curve.x) && !Double.isNaN(curve.y) && !(Math.abs(curve.x) > d) && !(Math.abs(curve.y) > d)) continue;
                this.curves.removeElementAt(i);
            }
            if (this.curves.size() > 0) {
                this.canvas.drawTemp(this.curveDrawer);
            } else {
                this.animator.stop();
            }
        }
    }

    private void nextPoint(double d, double d2, double d3, int n) {
        switch (n) {
            case 2: {
                this.nextEuler(d, d2, d3);
                break;
            }
            case 1: {
                this.nextRK2(d, d2, d3);
                break;
            }
            case 0: {
                this.nextRK4(d, d2, d3);
            }
        }
    }

    private void nextEuler(double d, double d2, double d3) {
        this.params[0] = d;
        this.params[1] = d2;
        double d4 = this.xFunc.getVal(this.params);
        double d5 = this.yFunc.getVal(this.params);
        this.nextPoint[0] = d + d3 * d4;
        this.nextPoint[1] = d2 + d3 * d5;
    }

    private void nextRK2(double d, double d2, double d3) {
        this.params[0] = d;
        this.params[1] = d2;
        double d4 = this.xFunc.getVal(this.params);
        double d5 = this.yFunc.getVal(this.params);
        double d6 = d + d3 * d4;
        double d7 = d2 + d3 * d5;
        this.params[0] = d6;
        this.params[1] = d7;
        double d8 = this.xFunc.getVal(this.params);
        double d9 = this.yFunc.getVal(this.params);
        this.nextPoint[0] = d + 0.5 * d3 * (d4 + d8);
        this.nextPoint[1] = d2 + 0.5 * d3 * (d5 + d9);
    }

    private void nextRK4(double d, double d2, double d3) {
        this.params[0] = d;
        this.params[1] = d2;
        double d4 = this.xFunc.getVal(this.params);
        double d5 = this.yFunc.getVal(this.params);
        double d6 = d + 0.5 * d3 * d4;
        double d7 = d2 + 0.5 * d3 * d5;
        this.params[0] = d6;
        this.params[1] = d7;
        double d8 = this.xFunc.getVal(this.params);
        double d9 = this.yFunc.getVal(this.params);
        double d10 = d + 0.5 * d3 * d8;
        double d11 = d2 + 0.5 * d3 * d9;
        this.params[0] = d10;
        this.params[1] = d11;
        double d12 = this.xFunc.getVal(this.params);
        double d13 = this.yFunc.getVal(this.params);
        double d14 = d + d3 * d12;
        double d15 = d2 + d3 * d13;
        this.params[0] = d14;
        this.params[1] = d15;
        double d16 = this.xFunc.getVal(this.params);
        double d17 = this.yFunc.getVal(this.params);
        this.nextPoint[0] = d + d3 / 6.0 * (d4 + 2.0 * d8 + 2.0 * d12 + d16);
        this.nextPoint[1] = d2 + d3 / 6.0 * (d5 + 2.0 * d9 + 2.0 * d13 + d17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadExample(String string) {
        Serializable serializable;
        int n;
        Object object;
        int n2;
        if (this.animator != null) {
            this.curves.setSize(0);
            this.animator.stop();
        }
        if ((n2 = string.indexOf(";")) == -1) {
            return;
        }
        String string2 = string.substring(n2 + 1);
        string = string.substring(0, n2);
        n2 = string2.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        StringTokenizer stringTokenizer = null;
        if (n2 > 0) {
            object = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
            stringTokenizer = new StringTokenizer((String)object, " ,");
            if (stringTokenizer.countTokens() >= 4) {
                for (n = 0; n < 4; ++n) {
                    try {
                        serializable = new Double(stringTokenizer.nextToken());
                        dArray[n] = serializable;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                double d = Double.NaN;
                try {
                    d = new Double(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (Double.isNaN(d) || d <= 0.0 || d > 100.0) {
                    d = 0.1;
                }
                if (this.deltaT != null) {
                    this.deltaT.setVal(d);
                } else {
                    this.dt = d;
                }
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
            this.functionInput2.setText(string2);
        } else {
            try {
                object = new SimpleFunction((Expression)this.parser.parse(string), this.xVar);
                ((WrapperFunction)this.xFunc).setFunction((Function)object);
                SimpleFunction simpleFunction = new SimpleFunction((Expression)this.parser.parse(string2), this.xVar);
                ((WrapperFunction)this.yFunc).setFunction(simpleFunction);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object).setLimits(dArray);
        ((CoordinateRect)object).setRestoreBuffer();
        this.mainController.compute();
        if (this.animator != null && stringTokenizer != null && (n = 2 * (stringTokenizer.countTokens() / 2)) > 0) {
            serializable = this.curves;
            synchronized (serializable) {
                for (int i = 0; i < n; ++i) {
                    try {
                        double d = new Double(stringTokenizer.nextToken());
                        double d2 = new Double(stringTokenizer.nextToken());
                        this.startCurve(d, d2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.curves.size() > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void stop() {
        if (this.animator != null) {
            this.curves.setSize(0);
            this.animator.stop();
        }
        super.stop();
    }

    private class Draw
    implements DrawTemp {
        private Draw() {
        }

        public void draw(Graphics graphics, CoordinateRect coordinateRect) {
            int n = IntegralCurves.this.curves.size();
            graphics.setColor(IntegralCurves.this.curveColor);
            for (int i = 0; i < n; ++i) {
                Curve curve = (Curve)IntegralCurves.this.curves.elementAt(i);
                if (Double.isNaN(curve.x) || Double.isNaN(curve.y) || Double.isNaN(curve.lastX) || Double.isNaN(curve.lastY)) continue;
                int n2 = coordinateRect.xToPixel(curve.lastX);
                int n3 = coordinateRect.yToPixel(curve.lastY);
                int n4 = coordinateRect.xToPixel(curve.x);
                int n5 = coordinateRect.yToPixel(curve.y);
                graphics.drawLine(n2, n3, n4, n5);
            }
        }
    }

    private class Curve {
        double dt;
        int method;
        double x;
        double y;
        double lastX = Double.NaN;
        double lastY;

        private Curve() {
        }
    }
}

