# Public Domain CC0
%{?mingw_package_header}
%define _pkg_name viking
Name:		mingw64-%{_pkg_name}
Version:	1.7
Release:	1
Summary:	GPS data editor and analyzer
Group:		Applications/Productivity
License:	GPLv2
URL:		http://sourceforge.net/projects/viking/
Source0:	%{_pkg_name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build
BuildArch:	noarch

# 64bit version only in this file. See mingw-viking.spec for the 32bit version

# Programs to enable the cross build
BuildRequires:	mingw64-filesystem
BuildRequires:	mingw64-binutils
BuildRequires:	mingw64-runtime
BuildRequires:	mingw64-cross-binutils
BuildRequires:	mingw64-cross-gcc
BuildRequires:	mingw64-cross-pkg-config
BuildRequires:	mingw64-gettext-tools
BuildRequires:	mingw64-gnome-doc-utils-devel
BuildRequires:	intltool
BuildRequires:	gdk-pixbuf-devel
# ^For gdk-pixbuf-csource

# Code
# Not worried about versions ATM
BuildRequires:	mingw64-gtk2-devel
# ATM gtk2-devel auto includes at least devel versions of glib2, gobject, zlib and more

# Mandatory libraries
BuildRequires:	mingw64-libexpat-devel
BuildRequires:	mingw64-libcurl-devel
# Optional libraries
BuildRequires:	mingw64-libgexiv2-devel
BuildRequires:	mingw64-libbz2-devel
BuildRequires:	mingw64-file-devel
BuildRequires:	mingw64-libmagic1
BuildRequires:	mingw64-libbz2-1
BuildRequires:	mingw64-sqlite-devel
BuildRequires:	mingw64-libzip-devel
BuildRequires:	mingw64-libnettle-devel
BuildRequires:	mingw64-libgps-devel
BuildRequires:	mingw64-liboauth-devel

# Libs for runtime (and thus also available for the NSIS installer to include the dependencies)
Requires:	mingw64-gtk2
Requires:	mingw64-libexpat1
Requires:	mingw64-libcurl4
Requires:	mingw64-libgexiv2
Requires:	mingw64-libstdc++6
Requires:	mingw64-libsqlite3-0
Requires:	mingw64-libzip4
Requires:	mingw64-libnettle
Requires:	mingw64-liboauth
# Currently running makensis in seperate script - so you will need it then
# NB No 64bit version available
#Requires:	mingw32-cross-nsis

%description
Viking is a free/open source program to manage GPS data.
You can import, plot and create tracks, routes and waypoints, show OSM and other maps, see real-time GPS position, control items, etc.
Other advanced capabilities include Geotagging Images, generate Maps (using Mapnik), Upload and Download tracks from OSM, Routing from OSRM or Google, Name Searches from OSM Nominatim or Google and more.
It is written in mainly in C with some C++ and uses the GTK+2 toolkit.

%prep
%setup -q -n %{_pkg_name}-%{version}

%build
# Create Icon
pushd windows/installer/pixmaps
%{_mingw64_windres} viking_icon.rc -o viking_icon.o
popd

#
# Specifics for Windows build - i.e. no Mapnik yet
%{_mingw64_configure}\
  --disable-mapnik \
  --disable-geoclue \
  --disable-scrollkeeper \
  --enable-windows \
  CFLAGS="-DWINDOWS -DWIN32 -mwindows"
# NB not sure if '-DWIN32' is necessary/applicable for a 64bit build...

%{_mingw64_make} %{?_smp_mflags}
 
%install
pushd src
%{_mingw64_strip} -g %{_pkg_name}.exe
popd

%make_install

%find_lang %{_pkg_name}

%clean
rm -rf %{buildroot}

%files -f %{_pkg_name}.lang
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README.md doc/
%{_mingw64_bindir}/*%{_pkg_name}.exe
%{_mingw64_datadir}/applications/%{_pkg_name}.desktop
%{_mingw64_datadir}/%{_pkg_name}
%{_mingw64_datadir}/icons/hicolor/*/apps/%{_pkg_name}.*
%exclude %{_mingw64_datadir}/icons/hicolor/icon-theme.cache

%changelog
