package internal

import (
	"github.com/sleepinggenius2/gosmi/types"
)

var importConversions map[types.SmiImport]types.SmiImport = map[types.SmiImport]types.SmiImport{
	// From libsmi
	{Module: "RFC1155-SMI", Name: "internet"}:      {Module: "SNMPv2-SMI", Name: "internet"},
	{Module: "RFC1155-SMI", Name: "directory"}:     {Module: "SNMPv2-SMI", Name: "directory"},
	{Module: "RFC1155-SMI", Name: "mgmt"}:          {Module: "SNMPv2-SMI", Name: "mgmt"},
	{Module: "RFC1155-SMI", Name: "experimental"}:  {Module: "SNMPv2-SMI", Name: "experimental"},
	{Module: "RFC1155-SMI", Name: "private"}:       {Module: "SNMPv2-SMI", Name: "private"},
	{Module: "RFC1155-SMI", Name: "enterprises"}:   {Module: "SNMPv2-SMI", Name: "enterprises"},
	{Module: "RFC1155-SMI", Name: "IpAddress"}:     {Module: "SNMPv2-SMI", Name: "IpAddress"},
	{Module: "RFC1155-SMI", Name: "Counter"}:       {Module: "SNMPv2-SMI", Name: "Counter32"},
	{Module: "RFC1155-SMI", Name: "Gauge"}:         {Module: "SNMPv2-SMI", Name: "Gauge32"},
	{Module: "RFC1155-SMI", Name: "TimeTicks"}:     {Module: "SNMPv2-SMI", Name: "TimeTicks"},
	{Module: "RFC1155-SMI", Name: "Opaque"}:        {Module: "SNMPv2-SMI", Name: "Opaque"},
	{Module: "RFC1065-SMI", Name: "internet"}:      {Module: "SNMPv2-SMI", Name: "internet"},
	{Module: "RFC1065-SMI", Name: "directory"}:     {Module: "SNMPv2-SMI", Name: "directory"},
	{Module: "RFC1065-SMI", Name: "mgmt"}:          {Module: "SNMPv2-SMI", Name: "mgmt"},
	{Module: "RFC1065-SMI", Name: "experimental"}:  {Module: "SNMPv2-SMI", Name: "experimental"},
	{Module: "RFC1065-SMI", Name: "private"}:       {Module: "SNMPv2-SMI", Name: "private"},
	{Module: "RFC1065-SMI", Name: "enterprises"}:   {Module: "SNMPv2-SMI", Name: "enterprises"},
	{Module: "RFC1065-SMI", Name: "IpAddress"}:     {Module: "SNMPv2-SMI", Name: "IpAddress"},
	{Module: "RFC1065-SMI", Name: "Counter"}:       {Module: "SNMPv2-SMI", Name: "Counter32"},
	{Module: "RFC1065-SMI", Name: "Gauge"}:         {Module: "SNMPv2-SMI", Name: "Gauge32"},
	{Module: "RFC1065-SMI", Name: "TimeTicks"}:     {Module: "SNMPv2-SMI", Name: "TimeTicks"},
	{Module: "RFC1065-SMI", Name: "Opaque"}:        {Module: "SNMPv2-SMI", Name: "Opaque"},
	{Module: "RFC1213-MIB", Name: "mib-2"}:         {Module: "SNMPv2-SMI", Name: "mib-2"},
	{Module: "RFC1213-MIB", Name: "DisplayString"}: {Module: "SNMPv2-TC", Name: "DisplayString"},

	// Custom
	{Module: "RFC1213-MIB", Name: "PhysAddress"}:             {Module: "SNMPv2-TC", Name: "PhysAddress"},
	{Module: "RFC1213-MIB", Name: "ifAdminStatus"}:           {Module: "IF-MIB", Name: "ifAdminStatus"},
	{Module: "RFC1213-MIB", Name: "ifDescr"}:                 {Module: "IF-MIB", Name: "ifDescr"},
	{Module: "RFC1213-MIB", Name: "ifEntry"}:                 {Module: "IF-MIB", Name: "ifEntry"},
	{Module: "RFC1213-MIB", Name: "ifInErrors"}:              {Module: "IF-MIB", Name: "ifInErrors"},
	{Module: "RFC1213-MIB", Name: "ifIndex"}:                 {Module: "IF-MIB", Name: "ifIndex"},
	{Module: "RFC1213-MIB", Name: "ifOperStatus"}:            {Module: "IF-MIB", Name: "ifOperStatus"},
	{Module: "RFC1213-MIB", Name: "ifOutDiscards"}:           {Module: "IF-MIB", Name: "ifOutDiscards"},
	{Module: "RFC1213-MIB", Name: "ifOutErrors"}:             {Module: "IF-MIB", Name: "ifOutErrors"},
	{Module: "RFC1213-MIB", Name: "ifPhysAddress"}:           {Module: "IF-MIB", Name: "ifPhysAddress"},
	{Module: "RFC1213-MIB", Name: "interfaces"}:              {Module: "IF-MIB", Name: "interfaces"},
	{Module: "RFC1213-MIB", Name: "ip"}:                      {Module: "IP-MIB", Name: "ip"},
	{Module: "RFC1213-MIB", Name: "ipAdEntAddr"}:             {Module: "IP-MIB", Name: "ipAdEntAddr"},
	{Module: "RFC1213-MIB", Name: "ipAddrEntry"}:             {Module: "IP-MIB", Name: "ipAddrEntry"},
	{Module: "RFC1213-MIB", Name: "ipNetToMediaIfIndex"}:     {Module: "IP-MIB", Name: "ipNetToMediaIfIndex"},
	{Module: "RFC1213-MIB", Name: "ipNetToMediaNetAddress"}:  {Module: "IP-MIB", Name: "ipNetToMediaNetAddress"},
	{Module: "RFC1213-MIB", Name: "ipNetToMediaPhysAddress"}: {Module: "IP-MIB", Name: "ipNetToMediaPhysAddress"},
	{Module: "RFC1213-MIB", Name: "ipRouteDest"}:             {Module: "IP-MIB", Name: "ipRouteDest"},
	{Module: "RFC1213-MIB", Name: "snmp"}:                    {Module: "SNMPv2-MIB", Name: "snmp"},
	{Module: "RFC1213-MIB", Name: "sysContact"}:              {Module: "SNMPv2-MIB", Name: "sysContact"},
	{Module: "RFC1213-MIB", Name: "sysDescr"}:                {Module: "SNMPv2-MIB", Name: "sysDescr"},
	{Module: "RFC1213-MIB", Name: "sysLocation"}:             {Module: "SNMPv2-MIB", Name: "sysLocation"},
	{Module: "RFC1213-MIB", Name: "sysName"}:                 {Module: "SNMPv2-MIB", Name: "sysName"},
	{Module: "RFC1213-MIB", Name: "sysObjectID"}:             {Module: "SNMPv2-MIB", Name: "sysObjectID"},
	{Module: "RFC1213-MIB", Name: "sysUpTime"}:               {Module: "SNMPv2-MIB", Name: "sysUpTime"},
	{Module: "RFC1213-MIB", Name: "system"}:                  {Module: "SNMPv2-MIB", Name: "system"},
	{Module: "RFC1213-MIB", Name: "tcpConnLocalAddress"}:     {Module: "TCP-MIB", Name: "tcpConnLocalAddress"},
	{Module: "RFC1213-MIB", Name: "tcpConnLocalPort"}:        {Module: "TCP-MIB", Name: "tcpConnLocalPort"},
	{Module: "RFC1213-MIB", Name: "tcpConnRemAddress"}:       {Module: "TCP-MIB", Name: "tcpConnRemAddress"},
	{Module: "RFC1213-MIB", Name: "tcpConnRemPort"}:          {Module: "TCP-MIB", Name: "tcpConnRemPort"},
	{Module: "RFC1213-MIB", Name: "transmission"}:            {Module: "SNMPv2-SMI", Name: "transmission"},
}
