/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef NANCY10DATA_H
#define NANCY10DATA_H

#include "types.h"

const GameConstants _nancy10Constants ={
	70,												// numItems
	816,											// numEventFlags
	{	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,			// genericEventFlags
		11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
		21, 22, 23, 24, 25, 26, 27, 28, 29, 30 },
	20,												// numCursorTypes
	4000,											// logoEndAfter
	32												// wonGameFlagID
};

const Common::Array<Common::Array<ConditionalDialogue>> _nancy10ConditionalDialogue = {
{	// Dave Gregory, 13 responses
	{	0, 1050, "NDE50",
		{ { kEv, 171, false }, { kEv, 445, false } } },
	{	0, 1051, "NDE51",
		{ { kEv, 323, true }, { kEv, 322, true }, { kEv, 163, false } } },
	{	0, 1052, "NDE52",
		{ { kEv, 168, false }, { kEv, 444, false } } },
	{	0, 1053, "NDE53",
		{ { kEv, 169, false } } },
	{	0, 1061, "NDE61",
		{ { kEv, 309, true }, { kEv, 444, false }, { kEv, 158, false } } },
	{	0, 1054, "NDE54",
		{ { kEv, 463, true }, { kEv, 564, true }, { kEv, 314, false }, { kEv, 173, false } } },
	{	0, 1055, "NDE55",
		{ { kEv, 162, true }, { kEv, 403, false } } },
	{	0, 1056, "NDE56",
		{ { kEv, 162, true }, { kEv, 403, true }, { kEv, 404, false } } },
	{	0, 1057, "NDE57",
		{ { kEv, 434, true }, { kEv, 295, true }, { kEv, 604, false }, { kEv, 532, false }, { kEv, 157, false } } },
	{	0, 1058, "NDE58",
		{ { kEv, 302, true }, { kEv, 166, false } } },
	{	0, 1059, "NDE59",
		{ { kEv, 444, true }, { kEv, 463, true }, { kEv, 314, true }, { kEv, 164, false } } },
	{	0, 1062, "NDE62",
		{ { kEv, 523, true }, { kEv, 420, true }, { kEv, 515, false }, { kEv, 160, false } } },
	{	0, 1066, "NDE66",
		{ { kEv, 523, true }, { kEv, 449, true }, { kEv, 123, false }, { kEv, 161, false } } },
},
{	// Mary Yazzie, 17 responses
	{   0, 1450, "NMS50",
		{ { kEv, 457, true }, { kEv, 445, false }, { kEv, 305, false } } },
	{   0, 1451, "NMS51",
		{ { kEv, 459, true }, { kEv, 458, false }, { kEv, 307, false } } },
	{   0, 1460, "NMS60",
		{ { kEv, 459, false }, { kEv, 458, true }, { kEv, 307, false } } },
	{   0, 1477, "NMS77",
		{ { kEv, 459, true }, { kEv, 458, true }, { kEv, 307, false } } },
	{   0, 1452, "NMS52",
		{ { kEv, 441, true }, { kEv, 535, false }, { kEv, 300, false } } },
	{   0, 1453, "NMS53",
		{ { kEv, 440, true }, { kEv, 445, false }, { kEv, 299, false } } },
	{   0, 1454, "NMS54",
		{ { kEv, 444, true }, { kEv, 306, true }, { kEv, 446, true }, { kEv, 387, false }, { kEv, 298, false } } },
	{   0, 1455, "NMS55",
		{ { kEv, 444, true }, { kEv, 446, true }, { kEv, 387, true }, { kEv, 293, false } } },
	{   0, 1457, "NMS57",
		{ { kEv, 434, true }, { kEv, 445, false }, { kEv, 295, false } } },
	{   0, 1458, "NMS58",
		{ { kEv, 601, true }, { kEv, 302, false } } },
	{   0, 1459, "NMS59",
		{ { kEv, 314, true }, { kEv, 306, false } } },
	{   0, 1466, "NMS66",
		{ { kEv, 312, false }, { kEv, 301, false }, { kIn, 0, true } } },
	{   0, 1469, "NMS69",
		{ { kEv, 147, false }, { kEv, 304, false }, { kIn, 32, true } } },
	{   0, 1478, "NMS78",
		{ { kEv, 147, false }, { kEv, 304, false }, { kIn, 35, true } } },
	{   0, 1470, "NMS70",
		{ { kEv, 392, true }, { kEv, 538, false }, { kEv, 296, false }, { kIn, 38, true } } },
	{   0, 1474, "NMS74",
		{ { kEv, 538, true }, { kEv, 297, false }, { kIn, 50, true } } },
	{   0, 1479, "NMS79",
		{ { kEv, 302, true }, { kEv, 740, false } } },
},
{	// Tex Britten, 24 responses
	{   0, 1250, "NTS02a",
		{ { kEv, 168, true }, { kEv, 576, true }, { kEv, 444, false }, { kEv, 607, false } } },
	{   0, 1251, "NTS02b",
		{ { kEv, 168, false }, { kEv, 444, false }, { kEv, 576, false }, { kEv, 603, false } } },
	{   0, 1252, "NTS52",
		{ { kEv, 168, true }, { kEv, 444, false }, { kEv, 603, true }, { kEv, 597, false } } },
	{   0, 1253, "NTS53",
		{ { kEv, 444, false }, { kEv, 609, false } } },
	{   0, 1229, "NTS53",
		{ { kEv, 609, true }, { kEv, 444, false }, { kEv, 563, false }, { kEv, 605, false } } },
	{   0, 1254, "NTS54",
		{ { kEv, 563, true }, { kEv, 444, false }, { kEv, 310, false }, { kEv, 594, false } } },
	{   0, 1255, "NTS55",
		{ { kEv, 563, true }, { kEv, 444, false }, { kEv, 310, true }, { kEv, 594, true }, { kEv, 606, false } } },
	{   0, 1256, "NTS56",
		{ { kEv, 563, true }, { kEv, 445, false }, { kEv, 310, true }, { kEv, 606, true }, { kEv, 600, false } } },
	{   0, 1257, "NTS57",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 563, false }, { kEv, 609, false } } },
	{   0, 1258, "NTS57",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 563, true }, { kEv, 598, false } } },
	{   0, 1259, "NTS54",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 563, true }, { kEv, 500, true }, { kEv, 595, false } } },
	{   0, 1260, "NTS55",
		{ { kEv, 444, true }, { kEv, 563, true }, { kEv, 595, true }, { kEv, 445, false }, { kEv, 606, false } } },
	{   0, 1261, "NTS57",
		{ { kEv, 445, true }, { kEv, 563, false }, { kEv, 609, false } } },
	{   0, 1262, "NTS57",
		{ { kEv, 445, true }, { kEv, 563, true }, { kEv, 591, false } } },
	{   0, 1263, "NTS63",
		{ { kEv, 563, true }, { kEv, 507, true }, { kEv, 596, false } } },
	{   0, 1264, "NTS55",
		{ { kEv, 563, true }, { kEv, 507, true }, { kEv, 596, true }, { kEv, 606, false } } },
	{   0, 1265, "NTS65",
		{ { kEv, 438, true }, { kEv, 455, true }, { kEv, 589, false } } },
	{   0, 1266, "NTS66",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 592, false } } },
	{   0, 1267, "NTS67",
		{ { kEv, 445, true }, { kEv, 608, false }, { kIn, 15, true } } },
	{   0, 1268, "NTS68",
		{ { kEv, 434, true }, { kEv, 295, true }, { kEv, 445, false }, { kEv, 604, false } } },
	{   0, 1269, "NTS69",
		{ { kEv, 433, true }, { kEv, 601, false } } },
	{   0, 1270, "NTS70",
		{ { kEv, 710, true }, { kEv, 599, false } } },
	{   0, 1271, "NTS71",
		{ { kEv, 714, true }, { kEv, 599, false }, { kEv, 602, false } } },
	{   0, 1272, "NTS72",
		{ { kEv, 463, true }, { kEv, 302, false }, { kEv, 611, false } } },
},
{	// Shorty Thurmond, 12 responses
	{   0, 1375, "NSK76",
		{ { kEv, 444, false }, { kEv, 609, true }, { kEv, 548, true }, { kEv, 550, true }, { kEv, 549, true }, { kEv, 577, false }, { kIn, 46, true } } },
	{   0, 1376, "NSK76",
		{ { kEv, 444, false }, { kEv, 609, true }, { kEv, 577, false }, { kIn, 46, false } } },
	{   0, 1377, "NSK77",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 577, false }, { kIn, 46, false } } },
	{   0, 1386, "NSK86",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 548, true }, { kEv, 550, true }, { kEv, 549, true }, { kEv, 577, false }, { kIn, 46, true } } },
	{   0, 1378, "NSK78",
		{ { kEv, 445, true }, { kEv, 548, false }, { kEv, 550, false }, { kEv, 549, false }, { kEv, 577, false } } },
	{   0, 1387, "NSK78",
		{ { kEv, 445, true }, { kEv, 548, true }, { kEv, 550, true }, { kEv, 549, true }, { kEv, 577, false }, { kIn, 46, true } } },
	{   0, 1379, "NSK79",
		{ { kEv, 444, false }, { kEv, 563, true }, { kEv, 562, false } } },
	{   0, 1380, "NSK80",
		{ { kEv, 318, true }, { kEv, 569, false } } },
	{   0, 1381, "NSK81",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 575, false } } },
	{   0, 1382, "NSK82",
		{ { kEv, 444, true }, { kEv, 314, true }, { kEv, 572, true }, { kEv, 580, false } } },
	{   0, 1384, "NSK84",
		{ { kEv, 444, true }, { kEv, 563, true }, { kEv, 562, false } } },
	{   0, 1352, "NSK77",
		{ { kEv, 444, true }, { kEv, 445, false }, { kEv, 548, false }, { kEv, 550, false }, { kEv, 549, false }, { kEv, 577, false }, { kIn, 46, true } } },
},
{	// Charleena Purcell, 5 responses
	{   0, 1885, "NCP85",
		{ { kEv, 428, true }, { kEv, 660, false }, { kEv, 141, false } } },
	{   0, 1886, "NCP86",
		{ { kEv, 316, true }, { kEv, 145, false }, { kEv, 146, false } } },
	{   0, 1887, "NCP87",
		{ { kEv, 535, true }, { kEv, 145, false } } },
	{   0, 1888, "NCP88",
		{ { kEv, 451, true }, { kEv, 143, false } } },
	{   0, 1889, "NCP89",
		{ { kEv, 164, true }, { kEv, 355, false }, { kEv, 147, false }, { kIn, 32, true }, { kIn, 35, true } } },
},
{	// Bet Rawley, 7 responses
	{   0, 1550, "NRP50",
		{ { kEv, 318, true }, { kEv, 71, false } } },
	{   0, 1551, "NRP51",
		{ { kEv, 607, true }, { kEv, 168, true }, { kEv, 322, true }, { kEv, 444, false }, { kEv, 70, false } } },
	{   0, 1552, "NRP52",
		{ { kEv, 413, true }, { kEv, 70, true }, { kEv, 321, true }, { kEv, 445, false }, { kEv, 67, false } } },
	{   0, 1553, "NRP53",
		{ { kEv, 309, true }, { kEv, 313, true }, { kEv, 323, true }, { kEv, 444, false }, { kEv, 64, false } } },
	{   0, 1554, "NRP54",
		{ { kEv, 438, true }, { kEv, 444, true }, { kEv, 445, false }, { kEv, 69, false } } },
	{   0, 1555, "NRP55",
		{ { kEv, 314, true }, { kEv, 445, false }, { kEv, 73, false } } },
	{   0, 1556, "NRP56",
		{ { kEv, 74, true }, { kEv, 445, true }, { kEv, 65, false } } },
},
{	// Sheriff Hernandez, 7 responses
	{   0, 1840, "NSP40",
		{ { kEv, 444, true }, { kEv, 720, true }, { kEv, 255, false } } },
	{   0, 1841, "NSP41",
		{ { kEv, 607, true }, { kEv, 168, true }, { kEv, 322, true }, { kEv, 444, false }, { kEv, 477, false } } },
	{   0, 1842, "NSP42",
		{ { kEv, 477, true }, { kEv, 255, true }, { kEv, 475, false } } },
	{   0, 1843, "NSP43",
		{ { kEv, 449, true }, { kEv, 277, true }, { kEv, 445, false }, { kEv, 481, false } } },
	{   0, 1844, "NSP44",
		{ { kEv, 445, true }, { kEv, 523, false }, { kEv, 479, false } } },
	{   0, 1845, "NSP45",
		{ { kEv, 523, true }, { kEv, 474, false } } },
	{   0, 1846, "NSP46",
		{ { kEv, 255, true }, { kEv, 414, true }, { kEv, 478, false } } },
},
{	// Bess & George, 44 responses
	{   0, 1660, "NBG60",
		{ { kEv, 168, true }, { kEv, 607, true }, { kEv, 322, true }, { kEv, 444, false }, { kEv, 108, false } } },
	{   0, 1661, "NBG61",
		{ { kEv, 322, true }, { kEv, 444, false }, { kEv, 108, true }, { kEv, 120, false } } },
	{   0, 1662, "NBG62",
		{ { kEv, 168, true }, { kEv, 108, true }, { kEv, 444, false }, { kEv, 199, false }, { kEv, 87, false } } },
	{   0, 1663, "NBG63",
		{ { kEv, 311, true }, { kEv, 546, true }, { kEv, 445, false }, { kEv, 75, false } } },
	{   0, 1664, "NBG64",
		{ { kEv, 87, true }, { kEv, 444, true }, { kEv, 104, false }, { kIn, 4, true }, { kIn, 10, false } } },
	{   0, 1665, "NBG65",
		{ { kEv, 87, true }, { kEv, 463, true }, { kEv, 425, true }, { kEv, 120, true }, { kEv, 122, false } } },
	{   0, 1666, "NBG66",
		{ { kEv, 318, true }, { kEv, 546, false }, { kEv, 87, true }, { kEv, 102, false } } },
	{   0, 1667, "NBG67",
		{ { kEv, 527, true }, { kEv, 314, false }, { kEv, 122, true }, { kEv, 506, false }, { kEv, 80, false } } },
	{   0, 1668, "NBG68",
		{ { kEv, 91, true }, { kEv, 572, true }, { kEv, 455, true }, { kEv, 438, true }, { kEv, 406, true }, { kEv, 445, false }, { kEv, 213, false }, { kEv, 85, false } } },
	{   0, 1669, "NBG69",
		{ { kEv, 506, true }, { kEv, 120, true }, { kEv, 122, true }, { kEv, 424, true }, { kEv, 427, true }, { kEv, 426, true }, { kEv, 445, false }, { kEv, 98, false } } },
	{   0, 1670, "NBG70",
		{ { kEv, 424, true }, { kEv, 78, false }, { kIn, 38, true } } },
	{   0, 1673, "NBG73",
		{ { kEv, 309, true }, { kEv, 96, false }, { kEv, 81, false } } },
	{   0, 1649, "NBG49",
		{ { kEv, 309, true }, { kEv, 442, false }, { kEv, 115, false } } },
	{   0, 1674, "NBG74",
		{ { kEv, 309, true }, { kEv, 442, true }, { kEv, 443, false }, { kEv, 116, false } } },
	{   0, 1924, "NBX24",
		{ { kEv, 309, true }, { kEv, 442, true }, { kEv, 443, true }, { kEv, 117, false } } },
	{   0, 1677, "NBG77",
		{ { kEv, 96, true }, { kEv, 558, true }, { kEv, 510, false }, { kEv, 83, false } } },
	{   0, 1678, "NBG78",
		{ { kEv, 96, true }, { kEv, 577, true }, { kEv, 461, false }, { kEv, 548, false }, { kEv, 121, false } } },
	{   0, 1679, "NBG79",
		{ { kEv, 96, true }, { kEv, 567, true }, { kEv, 658, true }, { kEv, 503, false }, { kEv, 76, false } } },
	{   0, 1680, "NBG80",
		{ { kEv, 96, true }, { kEv, 385, true }, { kEv, 504, false }, { kEv, 79, false } } },
	{   0, 1681, "NBG81",
		{ { kEv, 96, true }, { kEv, 458, true }, { kEv, 694, true }, { kEv, 546, false }, { kEv, 119, false } } },
	{   0, 1683, "NBG83",
		{ { kEv, 96, true }, { kEv, 678, true }, { kEv, 527, false }, { kEv, 99, false }, { kIn, 30, true } } },
	{   0, 1922, "NBX22",
		{ { kEv, 96, true }, { kEv, 527, true }, { kEv, 530, true }, { kEv, 521, false }, { kEv, 522, false }, { kEv, 97, false } } },
	{   0, 1684, "NBG84",
		{ { kEv, 96, true }, { kEv, 535, false }, { kEv, 101, false }, { kIn, 36, true } } },
	{   0, 1685, "NBG85",
		{ { kEv, 96, true }, { kEv, 314, true }, { kEv, 506, false }, { kEv, 428, true }, { kEv, 80, false }, { kIn, 30, true } } },
	{   0, 1686, "NBG86",
		{ { kEv, 96, true }, { kEv, 296, true }, { kEv, 517, false }, { kEv, 86, false } } },
	{   0, 1687, "NBG87",
		{ { kEv, 96, true }, { kEv, 535, true }, { kEv, 145, false }, { kEv, 105, false } } },
	{   0, 1688, "NBG88",
		{ { kEv, 96, true }, { kEv, 537, true }, { kEv, 446, true }, { kEv, 547, false }, { kEv, 92, false } } },
	{   0, 1910, "NBX10",
		{ { kEv, 96, true }, { kEv, 405, true }, { kEv, 100, false }, { kIn, 16, false } } },
	{   0, 1911, "NBX11",
		{ { kEv, 96, true }, { kEv, 405, true }, { kEv, 285, true }, { kEv, 326, false }, { kEv, 124, false } } },
	{   0, 1912, "NBX12",
		{ { kEv, 96, true }, { kEv, 167, true }, { kEv, 663, true }, { kEv, 533, false }, { kEv, 89, false } } },
	{   0, 1913, "NBX13",
		{ { kEv, 96, true }, { kEv, 683, true }, { kEv, 534, false }, { kEv, 106, false }, { kIn, 16, true } } },
	{   0, 1915, "NBX15",
		{ { kEv, 96, true }, { kEv, 245, true }, { kEv, 532, false }, { kEv, 103, false }, { kEv, 90, false } } },
	{   0, 1930, "NBX30",
		{ { kEv, 96, true }, { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, false }, { kEv, 363, false }, { kEv, 271, false }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1931, "NBX31",
		{ { kEv, 96, true }, { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, false }, { kEv, 271, false }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false }, { kIn, 38, true } } },
	{   0, 1932, "NBX32",
		{ { kEv, 96, true }, { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, false }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1933, "NBX33",
		{ { kEv, 96, true }, { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, true }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1934, "NBX34",
		{ { kEv, 96, true }, { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, true }, { kEv, 706, true }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1935, "NBX35",
		{ { kEv, 96, true }, { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, true }, { kEv, 706, true }, { kEv, 284, true }, { kEv, 587, false } } },
	{   0, 1916, "NBX16",
		{ { kEv, 96, true }, { kEv, 523, true }, { kEv, 416, true }, { kEv, 519, false }, { kEv, 95, false } } },
	{   0, 1917, "NBX17",
		{ { kEv, 96, true }, { kEv, 423, true }, { kEv, 110, false }, { kIn, 5, false } } },
	{   0, 1918, "NBX18",
		{ { kEv, 96, true }, { kEv, 532, true }, { kEv, 514, false }, { kEv, 84, false } } },
	{   0, 1919, "NBX19",
		{ { kEv, 96, true }, { kEv, 400, true }, { kEv, 531, false }, { kEv, 107, false } } },
	{   0, 1920, "NBX20",
		{ { kEv, 96, true }, { kEv, 531, true }, { kEv, 436, true }, { kEv, 301, false }, { kEv, 111, false }, { kIn, 0, true } } },
	{   0, 1921, "NBX21",
		{ { kEv, 96, true }, { kEv, 301, true }, { kEv, 499, false }, { kEv, 93, false }, { kIn, 17, true } } },
},
{	// Frank & Joe, 39 responses
	{   0, 1750, "NFJ50",
		{ { kEv, 319, false }, { kEv, 194, false } } },
	{   0, 1751, "NFJ51",
		{ { kEv, 319, true }, { kEv, 321, false }, { kEv, 168, false }, { kEv, 607, false }, { kEv, 444, false }, { kEv, 204, false } } },
	{   0, 1752, "NFJ51",
		{ { kEv, 319, true }, { kEv, 321, true }, { kEv, 168, true }, { kEv, 607, true }, { kEv, 444, false }, { kEv, 204, false }, { kEv, 203, false } } },
	{   0, 1753, "NFJ53",
		{ { kEv, 319, true }, { kEv, 321, true }, { kEv, 444, false }, { kEv, 204, true }, { kEv, 203, false } } },
	{   0, 1754, "NFJ54",
		{ { kEv, 322, true }, { kEv, 199, true }, { kEv, 425, true }, { kEv, 463, true }, { kEv, 445, false }, { kEv, 222, false } } },
	{   0, 1755, "NFJ55",
		{ { kEv, 222, true }, { kEv, 425, true }, { kEv, 463, true }, { kEv, 141, true }, { kEv, 200, false } } },
	{   0, 1756, "NFJ56",
		{ { kEv, 85, false }, { kEv, 589, true }, { kEv, 572, true }, { kEv, 318, true }, { kEv, 314, true }, { kEv, 102, false }, { kEv, 222, true }, { kEv, 515, false }, { kEv, 213, false } } },
	{   0, 1757, "NFJ57",
		{ { kEv, 316, true }, { kEv, 277, true }, { kEv, 449, true }, { kEv, 515, false }, { kEv, 205, false } } },
	{   0, 1758, "NFJ58",
		{ { kEv, 523, true }, { kEv, 155, false }, { kEv, 196, false } } },
	{   0, 1759, "NFJ59",
		{ { kEv, 417, true }, { kEv, 445, false }, { kEv, 208, false } } },
	{   0, 1760, "NBG77",
		{ { kEv, 558, true }, { kEv, 510, false }, { kEv, 195, false } } },
	{   0, 1762, "NBG78",
		{ { kEv, 577, true }, { kEv, 461, false }, { kEv, 548, false }, { kEv, 224, false } } },
	{   0, 1763, "NBG79",
		{ { kEv, 567, true }, { kEv, 658, true }, { kEv, 503, false }, { kEv, 191, false } } },
	{   0, 1764, "NBG80",
		{ { kEv, 385, true }, { kEv, 504, false }, { kEv, 192, false } } },
	{   0, 1765, "NBG81",
		{ { kEv, 458, true }, { kEv, 694, true }, { kEv, 546, false }, { kEv, 223, false } } },
	{   0, 1767, "NBG83",
		{ { kEv, 527, false }, { kEv, 678, true }, { kEv, 210, false }, { kIn, 30, true } } },
	{   0, 1786, "NBX22",
		{ { kEv, 527, true }, { kEv, 530, true }, { kEv, 521, false }, { kEv, 522, false }, { kEv, 209, false } } },
	{   0, 1768, "NBG84",
		{ { kEv, 535, false }, { kEv, 212, false }, { kIn, 36, true } } },
	{   0, 1769, "NBG85",
		{ { kEv, 314, true }, { kEv, 506, false }, { kEv, 428, true }, { kEv, 193, false }, { kIn, 30, true } } },
	{   0, 1770, "NBG86",
		{ { kEv, 296, true }, { kEv, 517, false }, { kEv, 198, false } } },
	{   0, 1771, "NBG87",
		{ { kEv, 535, true }, { kEv, 145, false }, { kEv, 216, false } } },
	{   0, 1772, "NBG88",
		{ { kEv, 537, true }, { kEv, 446, true }, { kEv, 547, false }, { kEv, 202, false } } },
	{   0, 1774, "NBX10",
		{ { kEv, 405, true }, { kEv, 211, false }, { kIn, 16, false } } },
	{   0, 1775, "NBX11",
		{ { kEv, 405, true }, { kEv, 285, true }, { kEv, 326, false }, { kEv, 225, false } } },
	{   0, 1776, "NBX12",
		{ { kEv, 167, true }, { kEv, 663, true }, { kEv, 533, false }, { kEv, 201, false } } },
	{   0, 1777, "NBX13",
		{ { kEv, 683, true }, { kEv, 285, true }, { kEv, 534, false }, { kEv, 217, false } } },
	{   0, 1779, "NBX15",
		{ { kEv, 245, true }, { kEv, 532, false }, { kEv, 214, false } } },
	{   0, 1787, "NBX30",
		{ { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, false }, { kEv, 363, false }, { kEv, 271, false }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1788, "NBX31",
		{ { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, false }, { kEv, 271, false }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false }, { kIn, 38, true } } },
	{   0, 1789, "NBX32",
		{ { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, false }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1795, "NBX33",
		{ { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, true }, { kEv, 706, false }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1796, "NBX34",
		{ { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, true }, { kEv, 706, true }, { kEv, 284, false }, { kEv, 587, false } } },
	{   0, 1797, "NBX35",
		{ { kEv, 245, true }, { kEv, 532, false }, { kEv, 411, true }, { kEv, 152, true }, { kEv, 363, true }, { kEv, 271, true }, { kEv, 706, true }, { kEv, 284, true }, { kEv, 587, false } } },
	{   0, 1780, "NBX16",
		{ { kEv, 523, true }, { kEv, 416, true }, { kEv, 519, false }, { kEv, 207, false } } },
	{   0, 1781, "NBX17",
		{ { kEv, 423, true }, { kEv, 219, false }, { kIn, 5, false } } },
	{   0, 1782, "NBX18",
		{ { kEv, 532, true }, { kEv, 514, false }, { kEv, 197, false } } },
	{   0, 1783, "NBX19",
		{ { kEv, 400, true }, { kEv, 531, false }, { kEv, 218, false } } },
	{   0, 1784, "NBX20",
		{ { kEv, 531, true }, { kEv, 436, true }, { kEv, 301, false }, { kEv, 221, false }, { kIn, 0, true } } },
	{   0, 1785, "NBX21",
		{ { kEv, 301, true }, { kEv, 499, false }, { kEv, 206, false }, { kIn, 17, true } } },
},
};

const Common::Array<Goodbye> _nancy10Goodbyes = {
	{ "NDE90", { { { 1090, 1091, 1092, 1093 }, {}, NOFLAG } } },	// Dave Gregory
	{ "NMS90", { { { 1490, 1491, 1492, 1493 }, {}, NOFLAG } } },	// Mary Yazzie
	{ "NTS90", { { { 1290, 1291, 1292, 1293 }, {}, NOFLAG } } },	// Tex Britten
	{ "NSK90", { { { 1390, 1391, 1392, 1393 }, {}, NOFLAG } } },	// Shorty Thurmond
	{ "NCP95", { { { 1895, 1896, 1897, 1898 }, {}, NOFLAG } } },	// Charleena Purcell
	{ "NRP90", { { { 1590, 1591, 1592, 1593 }, {}, NOFLAG } } },	// Bet Rawley
	{ "NSP35", { { { 1835, 1836, 1837, 1838 }, {}, NOFLAG } } },	// Sheriff Hernandez
	{ "NBG90", { { { 1690, 1691, 1692, 1693 }, {}, NOFLAG } } },	// Bess & George
	{ "NFJ90", { { { 1790, 1791, 1792, 1793 }, {}, NOFLAG } } },	// Frank & Joe
};

const Common::Array<const char *> _nancy10EventFlagNames = {
	"EV_Generic0",
	"EV_Generic1",
	"EV_Generic2",
	"EV_Generic3",
	"EV_Generic4",
	"EV_Generic5",
	"EV_Generic6",
	"EV_Generic7",
	"EV_Generic8",
	"EV_Generic9",
	"EV_Generic10",
	"EV_Generic11",
	"EV_Generic12",
	"EV_Generic13",
	"EV_Generic14",
	"EV_Generic15",
	"EV_Generic16",
	"EV_Generic17",
	"EV_Generic18",
	"EV_Generic19",
	"EV_Generic20",
	"EV_Generic21",
	"EV_Generic22",
	"EV_Generic23",
	"EV_Generic24",
	"EV_Generic25",
	"EV_Generic26",
	"EV_Generic27",
	"EV_Generic28",
	"EV_Generic29",
	"EV_Generic30",
	"EV_TimeForEndgame",
	"EV_PlayerWonGame",
	"EV_StopPlayerScrolling",
	"EV_Easter_Eggs",
	"EV_01",
	"EV_02",
	"EV_03",
	"EV_04",
	"EV_05",
	"EV_06",
	"EV_07",
	"EV_08",
	"EV_09",
	"EV_10",
	"EV_11",
	"EV_12",
	"EV_13",
	"EV_14",
	"EV_15",
	"EV_16",
	"EV_17",
	"EV_18",
	"EV_At_Block",
	"EV_At_Post",
	"EV_Ate_Cake01",
	"EV_Ate_Cake02",
	"EV_Bake_On",
	"EV_Baked_Cake",
	"EV_Beefsteak01_Unripe",
	"EV_Beefsteak02_Unripe",
	"EV_Beefsteak03_Unripe",
	"EV_Beefsteak04_Unripe",
	"EV_Bet_Said_Aunt",
	"EV_Bet_Said_Cowboys",
	"EV_Bet_Said_Dave_Alibi",
	"EV_Bet_Said_Electricity",
	"EV_Bet_Said_Frances",
	"EV_Bet_Said_Infection",
	"EV_Bet_Said_Jane",
	"EV_Bet_Said_Phantom",
	"EV_Bet_Said_Property",
	"EV_Bet_Said_Pumphouse",
	"EV_Bet_Said_Secret_Door",
	"EV_BG_Said_Act_Three",
	"EV_BG_Said_Author",
	"EV_BG_Said_Basket",
	"EV_BG_Said_Bead_Email",
	"EV_BG_Said_Bead_Help",
	"EV_BG_Said_Blanket_Chest",
	"EV_BG_Said_Bottle",
	"EV_BG_Said_Call_Hardys",
	"EV_BG_Said_Call_Rawleys",
	"EV_BG_Said_Campfire",
	"EV_BG_Said_Compartment",
	"EV_BG_Said_Cowboys",
	"EV_BG_Said_Display",
	"EV_BG_Said_Distraction",
	"EV_BG_Said_Excitement",
	"EV_BG_Said_Fence",
	"EV_BG_Said_Flower_Hint",
	"EV_BG_Said_Fog",
	"EV_BG_Said_Fork",
	"EV_BG_Said_Grave",
	"EV_BG_Said_Harrison_URL",
	"EV_BG_Said_Hash",
	"EV_BG_Said_Hints",
	"EV_BG_Said_Inner_Locket",
	"EV_BG_Said_Letters",
	"EV_BG_Said_Locket",
	"EV_BG_Said_Magnet",
	"EV_BG_Said_Map",
	"EV_BG_Said_Mary",
	"EV_BG_Said_Music",
	"EV_BG_Said_Note",
	"EV_BG_Said_Pappy",
	"EV_BG_Said_Petrified",
	"EV_BG_Said_Petro_Two",
	"EV_BG_Said_Phantom",
	"EV_BG_Said_Research",
	"EV_BG_Said_Ring",
	"EV_BG_Said_Rock",
	"EV_BG_Said_Shorty_Suspect",
	"EV_BG_Said_Snake",
	"EV_BG_Said_Sue",
	"EV_BG_Said_Task_List1",
	"EV_BG_Said_Task_List2",
	"EV_BG_Said_Task_List3",
	"EV_BG_Said_Tex_Suspect",
	"EV_BG_Said_Trunk",
	"EV_BG_Said_Valentine",
	"EV_BG_Said_Veggies",
	"EV_BG_Said_Waylaid",
	"EV_BG_Said_Wrapup",
	"EV_BG_Said_Zebra",
	"EV_BG_Stall",
	"EV_BG_Stall1",
	"EV_BG_Stall2",
	"EV_Brick_Angle1",
	"EV_Brick_Angle2",
	"EV_Brick_Angle3",
	"EV_Brick_Angle4",
	"EV_Brick_Angle5",
	"EV_Brick_Power1",
	"EV_Brick_Power2",
	"EV_Brick_Power3",
	"EV_Bridle_Off",
	"EV_Bridle_On",
	"EV_BrokeEggs",
	"EV_Bucket_Full",
	"EV_Cake_Good",
	"EV_Char_Said_Bottle",
	"EV_Char_Said_Cracker_Email",
	"EV_Char_Said_Crackers",
	"EV_Char_Said_Discovered",
	"EV_Char_Said_Pappy",
	"EV_Char_Said_Piano",
	"EV_Char_Said_Token",
	"EV_Char_Stall1",
	"EV_COU_Snake_Encounter",
	"EV_Coyote_Stall1",
	"EV_Coyote_Stall2",
	"EV_Daisy_Hint",
	"EV_Dave_Available",
	"EV_Dave_Stall",
	"EV_Decoded_Note",
	"EV_DG_Available",
	"EV_DG_Said_Ask_Tex",
	"EV_DG_Said_BG",
	"EV_DG_Said_Call",
	"EV_DG_Said_Cameo",
	"EV_DG_Said_Concerned",
	"EV_DG_Said_Confess",
	"EV_DG_Said_First_Hire",
	"EV_DG_Said_Ghost_Town",
	"EV_DG_Said_Mary",
	"EV_DG_Said_MD_Relationship",
	"EV_DG_Said_Night_Task",
	"EV_DG_Said_Phantom",
	"EV_DG_Said_Rolltop_Key",
	"EV_DG_Said_Sheriff",
	"EV_DG_Said_Snake",
	"EV_DG_Said_Thanks",
	"EV_DG_Said_Who_Dirk",
	"EV_Dismounted",
	"EV_DryBean01_Unripe",
	"EV_DryBean02_Unripe",
	"EV_DryBean03_Unripe",
	"EV_DryBean04_Unripe",
	"EV_DryBean05_Unripe",
	"EV_DT_Difficulty_Level",
	"EV_Enough_Feed",
	"EV_Evergreen01_Unripe",
	"EV_Evergreen02_Unripe",
	"EV_Evergreen03_Unripe",
	"EV_EXT_Snake_Encounter",
	"EV_Fed_Wrong",
	"EV_Feed_Ace",
	"EV_Feed_Bad",
	"EV_Feed_Bob",
	"EV_Feed_Clyde",
	"EV_FJ_Said_Basket",
	"EV_FJ_Said_Blanket_Chest",
	"EV_FJ_Said_Bottle",
	"EV_FJ_Said_Call_Them",
	"EV_FJ_Said_Campfire",
	"EV_FJ_Said_Clobbered",
	"EV_FJ_Said_Compartment",
	"EV_FJ_Said_Display",
	"EV_FJ_Said_Distraction",
	"EV_FJ_Said_Father",
	"EV_FJ_Said_Fence",
	"EV_FJ_Said_Fork",
	"EV_FJ_Said_Ghost_Description",
	"EV_FJ_Said_Ghost_Horse",
	"EV_FJ_Said_Ghosts",
	"EV_FJ_Said_Grave",
	"EV_FJ_Said_Hash",
	"EV_FJ_Said_Hoofprint",
	"EV_FJ_Said_Inner_Locket",
	"EV_FJ_Said_Locket",
	"EV_FJ_Said_Magnet",
	"EV_FJ_Said_Map",
	"EV_FJ_Said_Motives",
	"EV_FJ_Said_Music",
	"EV_FJ_Said_Now_What",
	"EV_FJ_Said_Pappy",
	"EV_FJ_Said_Petrified",
	"EV_FJ_Said_Petro_Two",
	"EV_FJ_Said_Ring",
	"EV_FJ_Said_Robbers",
	"EV_FJ_Said_Rock",
	"EV_FJ_Said_Treasure",
	"EV_FJ_Said_Trunk",
	"EV_FJ_Said_Veggies",
	"EV_FJ_Said_Zebra",
	"EV_FootPosA1",
	"EV_FootPosA2",
	"EV_FootPosA3",
	"EV_FootPosB1",
	"EV_FootPosB2",
	"EV_FootPosB3",
	"EV_FootPosC1",
	"EV_FootPosC2",
	"EV_FootPosC3",
	"EV_Found_Arrowhead01",
	"EV_Found_Arrowhead02",
	"EV_Found_Arrowhead03",
	"EV_Found_Arrowhead04",
	"EV_Found_Arrowhead05",
	"EV_Found_Arrowhead06",
	"EV_Found_Arrowhead07",
	"EV_Found_Arrowhead08",
	"EV_Found_Arrowhead09",
	"EV_Found_Arrowhead10",
	"EV_Found_Music_Box",
	"EV_Found_Rock",
	"EV_GHO_Snake_Encounter",
	"EV_GoldenQueen01_Overripe",
	"EV_GoldenQueen01_Unripe",
	"EV_GoldenQueen02_Unripe",
	"EV_Good_Feed_Horse01",
	"EV_Good_Feed_Horse02",
	"EV_Good_Feed_Horse03",
	"EV_Got_All_Unripe",
	"EV_Got_Pumphouse_Okay",
	"EV_GotEgg01",
	"EV_GotEgg02",
	"EV_GotEgg03",
	"EV_GotEgg04",
	"EV_GotEgg05",
	"EV_GotEgg06",
	"EV_GotEgg07",
	"EV_GotEgg08",
	"EV_GotEgg09",
	"EV_GotEgg10",
	"EV_HammerAngle01",
	"EV_HammerAngle02",
	"EV_HammerAngle03",
	"EV_HammerAngle04",
	"EV_HammerAngle05",
	"EV_Harrison_Hint",
	"EV_Has_Arrowhead",
	"EV_Has_ChickenFeed",
	"EV_Has_RationA",
	"EV_Has_RationC",
	"EV_Has_RationD",
	"EV_Heard_Noises",
	"EV_Hen_Available",
	"EV_Hooked",
	"EV_Iced_Cake",
	"EV_IvoryEgg01_Unripe",
	"EV_IvoryEgg02_Unripe",
	"EV_Lasso01",
	"EV_Lily_Hint",
	"EV_Made_Magnet",
	"EV_MazechaseA",
	"EV_MazechaseB",
	"EV_MazechaseC",
	"EV_MazechaseD",
	"EV_MazechaseE",
	"EV_MD_Anger_Over",
	"EV_MD_Said_Angry",
	"EV_MD_Said_Arrowhead_Task",
	"EV_MD_Said_Beads",
	"EV_MD_Said_Denied",
	"EV_MD_Said_Display_Task",
	"EV_MD_Said_Flower",
	"EV_MD_Said_Forks",
	"EV_MD_Said_Petrified1",
	"EV_MD_Said_Petroglyphs",
	"EV_MD_Said_Polish",
	"EV_MD_Said_Relationship",
	"EV_MD_Said_Take_Forks",
	"EV_MD_Said_Token",
	"EV_MD_Said_Trains",
	"EV_MD_Said_Treasure",
	"EV_MD_Said_Trunk",
	"EV_MD_Saw_Arrowheads",
	"EV_Met_BG",
	"EV_Met_Bob",
	"EV_Met_Char",
	"EV_Met_Cliff_Dwellings",
	"EV_Met_DG",
	"EV_Met_DG_Cellar",
	"EV_Met_FJ",
	"EV_Met_Ghost_Town",
	"EV_Met_Map_Guy",
	"EV_Met_MD",
	"EV_Met_Rawleys",
	"EV_Met_Sheriff",
	"EV_Met_Shorty",
	"EV_Met_ST",
	"EV_Met_TB",
	"EV_Miss",
	"EV_Mounted_Up",
	"EV_Moved_Rock",
	"EV_Night",
	"EV_NorthernLights01_Unripe",
	"EV_NorthernLights02_Unripe",
	"EV_NorthernLights03_Unripe",
	"EV_NorthernLights04_Unripe",
	"EV_NorthernLights05_Unripe",
	"EV_Opened_Meryl_Locket",
	"EV_Oven_0",
	"EV_Oven_15",
	"EV_Oven_30",
	"EV_Oven_45",
	"EV_Oven_60",
	"EV_Oven_High",
	"EV_Oven_Low",
	"EV_Oven_Med",
	"EV_Oven_Off",
	"EV_Painted_Green01",
	"EV_Painted_Green02",
	"EV_Painted_Green03",
	"EV_Painted_Pink01",
	"EV_Painted_Pink02",
	"EV_Painted_Pink03",
	"EV_Pan_Large",
	"EV_Pan_Med",
	"EV_Passed_Test",
	"EV_Picked_All",
	"EV_Play_Good",
	"EV_Play_Second_Round",
	"EV_Played_Cowboy_Game1",
	"EV_PoleBean01_Overripe",
	"EV_PoleBean01_Unripe",
	"EV_PoleBean02_Overripe",
	"EV_PoleBean02_Unripe",
	"EV_PoleBean03_Unripe",
	"EV_PoleBean04_Unripe",
	"EV_PoleBean05_Unripe",
	"EV_Purse_Hint",
	"EV_Put_Tack_Away",
	"EV_Rawleys_Said_Just_Land",
	"EV_Riding_Quiz01",
	"EV_Riding_Quiz02",
	"EV_Riding_Quiz03",
	"EV_Riding_Quiz04",
	"EV_Riding_Quiz05",
	"EV_Riding_Quiz06",
	"EV_Riding_Quiz07",
	"EV_Riding_Quiz08",
	"EV_Riding_Quiz09",
	"EV_Riding_Quiz10",
	"EV_Right_Answer",
	"EV_Rode_Out",
	"EV_Saddle_Off",
	"EV_Saddle_On",
	"EV_Saddle_Right",
	"EV_Saddle_Wrong",
	"EV_Saddled_Up",
	"EV_Said_Bead_Thanks",
	"EV_Said_Day1_Ride",
	"EV_Said_Hollow",
	"EV_Said_Take_Break",
	"EV_Said_Tuning_Forks",
	"EV_Saw_Agate_URL",
	"EV_Saw_Arizona_URL",
	"EV_Saw_Arrowhead_URL",
	"EV_Saw_Baddie_Clue",
	"EV_Saw_Bead_Email",
	"EV_Saw_Brand",
	"EV_Saw_Brands_URL",
	"EV_Saw_Cactus_URL",
	"EV_Saw_Campfire_URL",
	"EV_Saw_Char_Number",
	"EV_Saw_Chicken_Wire",
	"EV_Saw_Compartment",
	"EV_Saw_Compartment_Note",
	"EV_Saw_Cowboy_Game",
	"EV_Saw_Cracker_URL",
	"EV_Saw_Dear_Cuz_One",
	"EV_Saw_Dear_Cuz_Two",
	"EV_Saw_Desert_Instructions",
	"EV_Saw_DG_Cellar",
	"EV_Saw_Dirk_Cell_Letter",
	"EV_Saw_Dwellings_URL",
	"EV_Saw_Electricity_Cinematic",
	"EV_Saw_Encoded_Note",
	"EV_Saw_Flower_Refs",
	"EV_Saw_Forks",
	"EV_Saw_Frances_Painting",
	"EV_Saw_Ghost_Lock",
	"EV_Saw_Harrison_URL",
	"EV_Saw_Hash_Marks",
	"EV_Saw_Hoofprint1",
	"EV_Saw_Hoofprint2",
	"EV_Saw_Hoofprint3",
	"EV_Saw_Jail_Letter_V",
	"EV_Saw_Journal",
	"EV_Saw_Knitting_URL",
	"EV_Saw_Lamp_Letter",
	"EV_Saw_Letter_One",
	"EV_Saw_Letter_Ref",
	"EV_Saw_Letter_Three",
	"EV_Saw_Letter_Two",
	"EV_Saw_Locket_Message",
	"EV_Saw_Locket_Watch",
	"EV_Saw_Magnet",
	"EV_Saw_Magnet_URL",
	"EV_Saw_Manual",
	"EV_Saw_MD_And_TB",
	"EV_Saw_MD_On_Ranch",
	"EV_Saw_Meryl_Frances",
	"EV_Saw_Mud_Wall_Note",
	"EV_Saw_Music_Box_Note",
	"EV_Saw_Nasty_Letter",
	"EV_Saw_Novel",
	"EV_Saw_Petrified1",
	"EV_Saw_Petro_Book",
	"EV_Saw_Phantom_Horse_One",
	"EV_Saw_Phantom_Horse_Two",
	"EV_Saw_Phantom_One",
	"EV_Saw_Phantom_Two",
	"EV_Saw_Piano_Note",
	"EV_Saw_Power_Line_URL",
	"EV_Saw_Ring_Display",
	"EV_Saw_Robber_Clue",
	"EV_Saw_Robber_Story",
	"EV_Saw_Rusted_Tin",
	"EV_Saw_Scorpion_URL",
	"EV_Saw_Sheriff_Number",
	"EV_Saw_Shorty_Maps",
	"EV_Saw_Sister_Doc",
	"EV_Saw_Snake",
	"EV_Saw_Trick_Horse",
	"EV_Saw_Trunk",
	"EV_Saw_Trunk_Receipt",
	"EV_Saw_Tuning_Fork_Note",
	"EV_Saw_Veggie_URL",
	"EV_Saw_Waylaid_Envelope",
	"EV_Saw_Waylaid_Letter",
	"EV_Saw_Yellow_Ref",
	"EV_Scooped_Chicken_Feed",
	"EV_Scooped_Corn",
	"EV_Scooped_Cow_Sup",
	"EV_Scooped_Oats",
	"EV_Scooped_Pellets",
	"EV_Selected_Slot1",
	"EV_Selected_Slot2",
	"EV_Selected_Slot3",
	"EV_Selected_Slot4",
	"EV_Sheriff_Said_Clobbered",
	"EV_Sheriff_Said_Cowboys",
	"EV_Sheriff_Said_Excitement",
	"EV_Sheriff_Said_Joke",
	"EV_Sheriff_Said_Lock",
	"EV_Sheriff_Said_No_Sabotage",
	"EV_Sheriff_Said_Spent",
	"EV_Sheriff_Said_Will_Check",
	"EV_Slot_Bad11",
	"EV_Slot_Bad12",
	"EV_Slot_Bad13",
	"EV_Slot_Bad14",
	"EV_Slot_Bad31",
	"EV_Slot_Bad32",
	"EV_Slot_Bad33",
	"EV_Slot_Bad34",
	"EV_Slot_Good21",
	"EV_Slot_Good22",
	"EV_Slot_Good23",
	"EV_Slot_Good24",
	"EV_Slot_Good41",
	"EV_Slot_Good42",
	"EV_Slot_Good43",
	"EV_Slot_Good44",
	"EV_Solved_Ace",
	"EV_Solved_Agate",
	"EV_Solved_Animal_Feed",
	"EV_Solved_Arrowhead_Task",
	"EV_Solved_Barrel_Race",
	"EV_Solved_Basket_Repair",
	"EV_Solved_Blanket_Chest",
	"EV_Solved_Bob",
	"EV_Solved_Bottle",
	"EV_Solved_Bridle_Assembly",
	"EV_Solved_Burnt_Note",
	"EV_Solved_Cake",
	"EV_Solved_Campfire",
	"EV_Solved_Chicken_Feed",
	"EV_Solved_Chicken_Wire",
	"EV_Solved_Clyde",
	"EV_Solved_Compartment",
	"EV_Solved_Cowboy_Game_Good",
	"EV_Solved_Cowboy_Game1",
	"EV_Solved_Display_Task",
	"EV_Solved_Eggs",
	"EV_Solved_Hash_Marks",
	"EV_Solved_Horse_Feed",
	"EV_Solved_Inner_Frances",
	"EV_Solved_Inner_Meryl",
	"EV_Solved_Jail_Escape",
	"EV_Solved_Kindling",
	"EV_Solved_Lasso",
	"EV_Solved_Lasso_Game",
	"EV_Solved_Locket",
	"EV_Solved_Magnet_Shoe",
	"EV_Solved_Marz_Flower",
	"EV_Solved_Meryl_Locket",
	"EV_Solved_Mud_Wall",
	"EV_Solved_Music_Box",
	"EV_Solved_Night_Task",
	"EV_Solved_Petrified",
	"EV_Solved_Petro_Puzzle_One",
	"EV_Solved_Petro_Puzzle_Two",
	"EV_Solved_Piano",
	"EV_Solved_Purse",
	"EV_Solved_Quiz",
	"EV_Solved_Ring_Display",
	"EV_Solved_Rolltop",
	"EV_Solved_Secret_Door_Puzzle",
	"EV_Solved_Store_Game",
	"EV_Solved_Treasure",
	"EV_Solved_Treasure_Decode",
	"EV_Solved_Trunk",
	"EV_Solved_Tuning_Fork_Puzzle",
	"EV_Solved_Veggies",
	"EV_Solved_Veggies_Over",
	"EV_Solved_Veggies_Under",
	"EV_Solved_Water_Bucket",
	"EV_Solved_Wood_Split",
	"EV_Split01",
	"EV_Split02",
	"EV_Split03",
	"EV_ST_Available",
	"EV_ST_Confrontation",
	"EV_ST_Said_Build_Campfire",
	"EV_ST_Said_Bust_Over",
	"EV_ST_Said_Busy",
	"EV_ST_Said_Call",
	"EV_ST_Said_Canteen",
	"EV_ST_Said_Chores_Done",
	"EV_ST_Said_Dirk",
	"EV_ST_Said_Do_Chores",
	"EV_ST_Said_Eggs_Done",
	"EV_ST_Said_Get_Eggs",
	"EV_ST_Said_Get_Tex",
	"EV_ST_Said_Gossip",
	"EV_ST_Said_Have_Cake",
	"EV_ST_Said_Make_Cake",
	"EV_ST_Said_Map_Bust",
	"EV_ST_Said_Nice_Fire",
	"EV_ST_Said_No_Electricity",
	"EV_ST_Said_No_Water",
	"EV_ST_Said_Phantom",
	"EV_ST_Said_Pick_Veggies",
	"EV_ST_Said_Resourceful",
	"EV_ST_Said_Solved_Veggies",
	"EV_ST_Said_Treasure",
	"EV_ST_Said_Water_Bucket",
	"EV_Started_Cake",
	"EV_Started_Game",
	"EV_Stitched01",
	"EV_Stitched02",
	"EV_Stitched03",
	"EV_Sunflower_Hint",
	"EV_TB_Available",
	"EV_TB_Said_Angry",
	"EV_TB_Said_Apology",
	"EV_TB_Said_Bridle_Task",
	"EV_TB_Said_Chase",
	"EV_TB_Said_Corral_Games",
	"EV_TB_Said_Day1_Ride",
	"EV_TB_Said_Day2_Ride",
	"EV_TB_Said_Day3_Ride",
	"EV_TB_Said_Did_See",
	"EV_TB_Said_Feed",
	"EV_TB_Said_Give_Lariat",
	"EV_TB_Said_No_Other",
	"EV_TB_Said_No_Relationship",
	"EV_TB_Said_No_Rope",
	"EV_TB_Said_No_Saw",
	"EV_TB_Said_No_See_MD",
	"EV_TB_Said_Not_Finished",
	"EV_TB_Said_Okay_Ride",
	"EV_TB_Said_Phantom",
	"EV_TB_Said_Shoe",
	"EV_TB_Said_Shorty_Chores",
	"EV_TB_Said_Still_Here",
	"EV_TB_Said_Treasure",
	"EV_TB_Said_Yell",
	"EV_TB_Stall1",
	"EV_TB_Stall2",
	"EV_Took_Beefsteak01",
	"EV_Took_Beefsteak02",
	"EV_Took_Beefsteak03",
	"EV_Took_Beefsteak04",
	"EV_Took_Beefsteak05",
	"EV_Took_Beefsteak06",
	"EV_Took_DryBean01",
	"EV_Took_DryBean02",
	"EV_Took_DryBean03",
	"EV_Took_DryBean04",
	"EV_Took_DryBean05",
	"EV_Took_Evergreen01",
	"EV_Took_Evergreen02",
	"EV_Took_Evergreen03",
	"EV_Took_GoldenQueen01",
	"EV_Took_GoldenQueen02",
	"EV_Took_GoldenQueen03",
	"EV_Took_GoldenQueen04",
	"EV_Took_Green_Brush",
	"EV_Took_IvoryEgg01",
	"EV_Took_IvoryEgg02",
	"EV_Took_IvoryEgg03",
	"EV_Took_IvoryEgg04",
	"EV_Took_IvoryEgg05",
	"EV_Took_NorthernLights01",
	"EV_Took_NorthernLights02",
	"EV_Took_NorthernLights03",
	"EV_Took_NorthernLights04",
	"EV_Took_NorthernLights05",
	"EV_Took_NorthernLights06",
	"EV_Took_NorthernLights07",
	"EV_Took_NorthernLights08",
	"EV_Took_NorthernLights09",
	"EV_Took_NorthernLights10",
	"EV_Took_PoleBean01",
	"EV_Took_PoleBean02",
	"EV_Took_PoleBean03",
	"EV_Took_PoleBean04",
	"EV_Took_PoleBean05",
	"EV_Took_PoleBean06",
	"EV_Took_PoleBean07",
	"EV_Took_Red_Brush",
	"EV_Tried_Agate",
	"EV_Tried_Basket_Repair",
	"EV_Tried_Blanket_Chest",
	"EV_Tried_Bottle",
	"EV_Tried_Bridle_Assembly",
	"EV_Tried_Campfire",
	"EV_Tried_Chicken_Wire",
	"EV_Tried_Compartment",
	"EV_Tried_Cowboy_Game_Good",
	"EV_Tried_Cowboy_Game1",
	"EV_Tried_Eggs",
	"EV_Tried_Feed",
	"EV_Tried_Food_Coloring",
	"EV_Tried_Generator",
	"EV_Tried_Inner_Frances",
	"EV_Tried_Inner_Meryl",
	"EV_Tried_Jail_Escape",
	"EV_Tried_Kindling",
	"EV_Tried_Lamp_Letter",
	"EV_Tried_Lasso",
	"EV_Tried_Lasso_Game",
	"EV_Tried_Locket",
	"EV_Tried_Magnet_Horseshoe",
	"EV_Tried_Marz_Flower",
	"EV_Tried_Mean_Hen",
	"EV_Tried_Music_Box",
	"EV_Tried_Petrified",
	"EV_Tried_Petro_Puzzle_One",
	"EV_Tried_Petro_Puzzle_Two",
	"EV_Tried_Piano",
	"EV_Tried_Purse",
	"EV_Tried_Quiz",
	"EV_Tried_Ring_Display",
	"EV_Tried_Rolltop",
	"EV_Tried_Secret_Door_Puzzle",
	"EV_Tried_Store_Game",
	"EV_Tried_Treasure_Decode",
	"EV_Tried_Trunk",
	"EV_Tried_Tuning_Fork_Puzzle",
	"EV_Tried_Turnk",
	"EV_Tried_Veggies",
	"EV_Tried_Wood_Split",
	"EV_TriedNest01",
	"EV_TriedNest02",
	"EV_TriedNest04",
	"EV_TriedNest05",
	"EV_TriedNest06",
	"EV_TriedNest07",
	"EV_TriedNest08",
	"EV_Tulip_Hint",
	"EV_Unhooked",
	"EV_Untacked",
	"EV_Veggie_ScrewUp1",
	"EV_Won_Corral_Games",
	"EV_Wrong_Answer",
	"EV_Said_Comment01",
	"EV_Said_Comment02",
	"EV_Said_Comment03",
	"EV_Said_Comment04",
	"EV_Said_Comment05",
	"EV_Said_Comment06",
	"EV_Said_Comment07",
	"EV_Said_Comment08",
	"EV_Said_Comment09",
	"EV_Said_Comment10",
	"EV_Said_Comment11",
	"EV_Said_Comment12",
	"EV_Said_Comment13",
	"EV_Said_Comment14",
	"EV_Said_Comment15",
	"EV_Said_Comment16",
	"EV_Said_Comment17",
	"EV_Said_Comment18",
	"EV_Said_Comment19",
	"EV_Said_Comment20",
	"EV_Said_Comment21",
	"EV_Said_Comment22",
	"EV_Said_Comment23",
	"EV_Said_Comment24",
	"EV_Said_Comment25",
	"EV_Empty1",
	"EV_Empty2",
	"EV_Empty3",
	"EV_Empty4",
	"EV_Empty5",
	"EV_Empty6",
	"EV_Empty7",
	"EV_Empty8",
	"EV_Empty9",
	"EV_Empty10",
	"EV_Empty11",
	"EV_Empty12",
	"EV_Empty13",
	"EV_Empty14",
	"EV_Empty15",
	"EV_Empty16",
	"EV_Empty17",
	"EV_Empty18",
	"EV_Empty19",
	"EV_Empty20",
	"EV_Empty21",
	"EV_Empty22",
	"EV_Empty23",
	"EV_Empty24",
	"EV_Empty25",
	"EV_Empty26",
	"EV_Empty27",
	"EV_Empty28",
	"EV_Empty29",
	"EV_Empty30",
	"EV_Empty31",
	"EV_Empty32",
	"EV_Empty33",
	"EV_Empty34",
	"EV_Empty35",
	"EV_Empty36",
	"EV_Empty37",
	"EV_Empty38",
	"EV_Empty39",
	"EV_Empty40",
	"EV_Empty41",
	"EV_Empty42",
	"EV_Empty43",
	"EV_Empty44",
	"EV_Empty45",
	"EV_Empty46",
	"EV_Empty47",
	"EV_Empty48",
	"EV_Empty49",
	"EV_Empty50",
	"EV_Empty51",
	"EV_Empty52",
	"EV_Empty53",
	"EV_Empty54",
	"EV_Empty55",
	"EV_Empty56",
	"EV_Empty57",
	"EV_Empty58",
	"EV_Empty59",
	"EV_Empty60",
	"EV_Empty61",
	"EV_Empty62",
	"EV_Empty63",
	"EV_Empty64",
	"EV_Empty65",
	"EV_Empty66",
	"EV_Empty67",
	"EV_Empty68",
	"EV_Empty69",
	"EV_Empty70",
	"EV_Empty71",
	"EV_Empty72",
	"EV_Empty73",
	"EV_Empty74",
	"EV_Empty75",
	"EV_Empty76",
	"EV_Empty77",
	"EV_Empty78",
	"EV_Empty79"
};

#endif // NANCY10DATA_H
