### New features

* [#10065](https://github.com/rubocop/rubocop/issues/10065): Add new `Gemspec/DeprecatedAttributeAssignment` cop. ([@koic][])
* [#10608](https://github.com/rubocop/rubocop/pull/10608): Add new `Style/MapCompactWithConditionalBlock` cop. ([@nobuyo][])
* [#10627](https://github.com/rubocop/rubocop/issues/10627): Add command-line option `--ignore-unrecognized-cops` to ignore any unknown cops or departments in .rubocop.yml. ([@nobuyo][])
* [#10620](https://github.com/rubocop/rubocop/pull/10620): Add Sorbet's `typed` sigil as a magic comment. ([@zachahn][])

### Bug fixes

* [#10662](https://github.com/rubocop/rubocop/pull/10662): Recover Ruby 2.1 code analysis using `TargetRubyVersion: 2.1`. ([@koic][])
* [#10396](https://github.com/rubocop/rubocop/issues/10396): Fix autocorrect for `Layout/IndentationWidth` to leave module/class body unchanged to avoid infinite autocorrect loop with `Layout/IndentationConsistency` when body trails after class/module definition. ([@johnny-miyake][])
* [#10636](https://github.com/rubocop/rubocop/issues/10636): Fix false positive in `Style/RedundantCondition` when the branches call the same method on different receivers. ([@dvandersluis][])
* [#10651](https://github.com/rubocop/rubocop/issues/10651): Fix autocorrect for `Style/For` when using array with operator methods as collection. ([@nobuyo][])
* [#10629](https://github.com/rubocop/rubocop/pull/10629): Fix default Ruby version from 2.5 to 2.6. ([@koic][])
* [#10661](https://github.com/rubocop/rubocop/pull/10661): Fix a false negative for `Style/SymbolProc` when method has no arguments and `AllowMethodsWithArguments: true`. ([@koic][])
* [#10631](https://github.com/rubocop/rubocop/issues/10631): Fix autocorrect for `Style/RedundantBegin`. ([@johnny-miyake][])
* [#10652](https://github.com/rubocop/rubocop/issues/10652): Fix a false positive for `Style/FetchEnvVar` in conditions. ([@ydah][])
* [#10665](https://github.com/rubocop/rubocop/issues/10665): Fix an incorrect autocorrect for `EnforcedStyle: with_first_argument` of `Layout/ArgumentAlignment` and `EnforcedColonStyle: separator` of `Layout/HashAlignment`. ([@koic][])
* [#10258](https://github.com/rubocop/rubocop/issues/10258): Recover Ruby 2.4 code analysis using `TargetRubyVersion: 2.4`. ([@koic][])
* [#10668](https://github.com/rubocop/rubocop/pull/10668): Recover Ruby 2.0 code analysis using `TargetRubyVersion: 2.0`. ([@koic][])
* [#10644](https://github.com/rubocop/rubocop/pull/10644): Recover Ruby 2.2 code analysis using `TargetRubyVersion: 2.2`. ([@koic][])
* [#10639](https://github.com/rubocop/rubocop/issues/10639): Fix `Style/HashSyntax` to exclude files that violate it with `EnforceHashShorthandSyntax` when running `auto-gen-config`. ([@nobuyo][])
* [#10633](https://github.com/rubocop/rubocop/issues/10633): Fix infinite autocorrection loop in `Style/AccessorGrouping` when combining multiple of the same accessor. ([@dvandersluis][])
* [#10618](https://github.com/rubocop/rubocop/issues/10618): Fix `LineBreakCorrector` so that it won't remove a semicolon in the class/module body. ([@johnny-miyake][])
* [#10646](https://github.com/rubocop/rubocop/issues/10646): Fix an incorrect autocorrect for `Style/SoleNestedConditional` when using `unless` and `&&` without parens in the outer condition and nested modifier condition. ([@koic][])
* [#10659](https://github.com/rubocop/rubocop/issues/10659): Fix automatically appended path for `inherit_from` by `auto-gen-config` is incorrect if specified config file in a subdirectory as an option. ([@nobuyo][])
* [#10640](https://github.com/rubocop/rubocop/pull/10640): Recover Ruby 2.3 code analysis using `TargetRubyVersion: 2.3`. ([@koic][])
* [#10657](https://github.com/rubocop/rubocop/issues/10657): Fix `--auto-gen-config` command option ignores specified config file by option. ([@nobuyo][])

### Changes

* [#10095](https://github.com/rubocop/rubocop/issues/10095): Change "auto-correct" to "autocorrect" in arguments, documentation, messages, comments, and specs. ([@chris-hewitt][])
* [#10656](https://github.com/rubocop/rubocop/issues/10656): Mark `Style/RedundantInterpolation` as unsafe autocorrection. ([@koic][])
* [#10616](https://github.com/rubocop/rubocop/pull/10616): Markdown formatter: skip files with no offenses. ([@rickselby][])

[@koic]: https://github.com/koic
[@nobuyo]: https://github.com/nobuyo
[@zachahn]: https://github.com/zachahn
[@johnny-miyake]: https://github.com/johnny-miyake
[@dvandersluis]: https://github.com/dvandersluis
[@ydah]: https://github.com/ydah
[@chris-hewitt]: https://github.com/chris-hewitt
[@rickselby]: https://github.com/rickselby
