# Change log for remrun, the copy-and-run tool

## 0.2.3 (2022-11-03)

- Python test suite:
  - use version 1.x of the utf8-locale library with no changes
  - adapt the test programs to the new API of version 0.4 of the cfg-diag
    library, hopefully for the last time
- Rust test generation tool:
  - use the anyhow library instead of the expect-exit one for terminating
    the program's operation if an error should occur
  - use version 4.x of the clap library with no changes
  - drop some overrides for the Clippy diagnostic tool, they were not
    even triggered by our source code

## 0.2.2 (2022-09-01)

- Add the `generate_tests` Rust tool for generating
  the `tests/run-test.sh` test suite runner.
- Python test suite:
  - drop the flake8 + hacking test environment
  - add version constraints for all the Python library dependencies
  - use the requirements.txt file in the test setuptools infrastructure
  - adapt the test programs to the new API of the cfg-diag library

## 0.2.1 (2022-07-13)

- Documentation:
  - use "destination" instead of "hostspec" in the manual page and
    the program usage message
  - add some examples to the program usage message
- Python test suite:
  - correct the package name in the internal metadata
  - use Python 3.7 deferred annotations
  - use `dict`, `list`, etc. instead of the `typing` generics
  - use `subprocess.run()` instead of a `Popen` object as appropriate
  - add cfg-diag 0.2.x as allowed dependency versions

## 0.2.0 (2022-03-24)

- Allow options to be passed to the executed program.
- Add support for ssh://[username@]host[:port] URIs.
- Code style improvements:
  - treat the $hostspec, $filename, and $opts variables as global
  - add helper functions for invoking the SSH client
  - add an EditorConfig definitions file
- Test suite improvements:
  - push the tests down into a tests/ directory tree
  - add a Python test suite running an SSH server
  - run the Python test suite in the Makefile's "test" target
  - add helper tools for running the Python test suite in a Docker
    container

## 0.1.0 (2021-12-15)

- First public release.

Comments: [Peter Pentchev](mailto:roam@ringlet.net)
