% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonomize.R
\name{anonomize}
\alias{anonomize}
\title{Create unique anonymous id values}
\usage{
anonomize(x, prefix = "anon")
}
\arguments{
\item{x}{A column of "confidential" names, possibly with repeats}

\item{prefix}{Character string to use as prefix in result.
Default is "anon"}
}
\value{
Named character vector of anonymized id names.
}
\description{
Obscure participant id values by replacing them with "anon-1" and
so forth.
}
\details{
Caution: the true "confidential" names are used as names in the
output vector
}
\author{
Paul Johnson <pauljohn@ku.edu>
x <- c("bill", "bob", "fred", "bill")
(anonomize(x, prefix = "id"))
}
