% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5readAttributes.R
\name{h5_readAttributes}
\alias{h5_readAttributes}
\alias{h5readAttributes}
\title{Read all attributes from a given location in an HDF5 file}
\usage{
h5readAttributes(file, name, native = FALSE, ...)
}
\arguments{
\item{file}{Character vector of length 1, giving the path to the HDF5}

\item{name}{Path within the HDF5 file to the object whose attributes should
be read.}

\item{native}{An object of class \code{logical}. If TRUE, array-like objects
are treated as stored in HDF5 row-major rather than R column-major
orientation.}

\item{\dots}{Further arguments passed to \code{\link{H5Aread}}.}
}
\value{
A named list of the same length as the number of attributes attached
to the specific object.  The names of the list entries correspond to the
attribute names.  If no attributes are found an empty list is returned.
}
\description{
Read all attributes from a given location in an HDF5 file
}
