% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeCWL.R
\name{writeCWL}
\alias{writeCWL}
\title{Write CWL}
\usage{
writeCWL(
  cwl,
  prefix = deparse(substitute(cwl)),
  outdir = tempfile(),
  docker = TRUE,
  libPaths = TRUE,
  ...
)
}
\arguments{
\item{cwl}{A `cwlProcess` or `cwlWorkflow` object.}

\item{prefix}{The prefix of `.cwl` and `.yml` files to be generated.}

\item{outdir}{The output directory for the `.cwl` and `.yml` files.}

\item{docker}{Whether to use docker.}

\item{libPaths}{Whether to add local R libaray paths to R script.}

\item{...}{Other options from `yaml::write_yaml`.}
}
\value{
A CWL file and A YML file.
}
\description{
write `cwlProcess` to cwl and yml.
}
\examples{
input1 <- InputParam(id = "sth")
echo <- cwlProcess(baseCommand = "echo",
                 inputs = InputParamList(input1))
writeCWL(echo)
}
