% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringQualityMetrics.R
\docType{methods}
\name{flagSamplesCtrl,RccSet-method}
\alias{flagSamplesCtrl,RccSet-method}
\alias{flagSamplesCtrl}
\title{flagSamplesCtrl}
\usage{
\S4method{flagSamplesCtrl}{RccSet}(rccSet, method = c("cutoffByMMAD",
  "cutoffByVar"), stringency = 4)
}
\arguments{
\item{rccSet}{An RccSet object}

\item{method}{Character string specifying the method for outlier detection: either
"cutoffByMMAD" or "cutoffByVar".}

\item{stringency}{Numeric value passed to the cutoff function specified by the method
argument (see the 'd' argument of cutoffByMMAD and cutoffByVar).}
}
\value{
A numeric vector giving the indices of samples with outlier values as
described above.
}
\description{
Flag samples based on the performance of their controls.
}
\details{
The method and stringency arguments determine a cutoff value used to
flag outlier samples based on the interquartile range of negative and
positive controls and in the slope of the linear fit of count versus input
of positive controls. Outliers will also be flagged if their positive
control scaling factor (see posCtrlNorm) is outside the NanoString
recommended range (i.e. below 0.3 or greater than 3).
}
\author{
Dorothee Nickles
}
