# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.weightsandbiases import WeightsAndBiasesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWeightsAndBiasesMgmtInstancesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WeightsAndBiasesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_instances_get(self, resource_group):
        response = self.client.instances.get(
            resource_group_name=resource_group.name,
            instancename="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_instances_begin_create_or_update(self, resource_group):
        response = self.client.instances.begin_create_or_update(
            resource_group_name=resource_group.name,
            instancename="str",
            resource={
                "location": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "marketplace": {
                        "offerDetails": {
                            "offerId": "str",
                            "planId": "str",
                            "publisherId": "str",
                            "planName": "str",
                            "termId": "str",
                            "termUnit": "str",
                        },
                        "subscriptionId": "str",
                        "subscriptionStatus": "str",
                    },
                    "partnerProperties": {"region": "str", "subdomain": "str"},
                    "user": {
                        "emailAddress": "str",
                        "firstName": "str",
                        "lastName": "str",
                        "phoneNumber": "str",
                        "upn": "str",
                    },
                    "provisioningState": "str",
                    "singleSignOnProperties": {
                        "type": "str",
                        "aadDomains": ["str"],
                        "enterpriseAppId": "str",
                        "state": "str",
                        "url": "str",
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_instances_update(self, resource_group):
        response = self.client.instances.update(
            resource_group_name=resource_group.name,
            instancename="str",
            properties={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_instances_begin_delete(self, resource_group):
        response = self.client.instances.begin_delete(
            resource_group_name=resource_group.name,
            instancename="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_instances_list_by_resource_group(self, resource_group):
        response = self.client.instances.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_instances_list_by_subscription(self, resource_group):
        response = self.client.instances.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
