# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class OperationContract(Resource):
    """Api Operation details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param template_parameters: Collection of URL template parameters.
    :type template_parameters:
     list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML
     formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies
    :type policies: str
    :param display_name: Required. Operation Name.
    :type display_name: str
    :param method: Required. A Valid HTTP Operation Method. Typical Http
     Methods like GET, PUT, POST but not limited by only them.
    :type method: str
    :param url_template: Required. Relative URL template identifying the
     target resource for this operation. May include parameters. Example:
     /customers/{cid}/orders/{oid}/?date={date}
    :type url_template: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 1000},
        'display_name': {'required': True, 'max_length': 300, 'min_length': 1},
        'method': {'required': True},
        'url_template': {'required': True, 'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'template_parameters': {'key': 'properties.templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'request': {'key': 'properties.request', 'type': 'RequestContract'},
        'responses': {'key': 'properties.responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'properties.policies', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'method': {'key': 'properties.method', 'type': 'str'},
        'url_template': {'key': 'properties.urlTemplate', 'type': 'str'},
    }

    def __init__(self, *, display_name: str, method: str, url_template: str, template_parameters=None, description: str=None, request=None, responses=None, policies: str=None, **kwargs) -> None:
        super(OperationContract, self).__init__(**kwargs)
        self.template_parameters = template_parameters
        self.description = description
        self.request = request
        self.responses = responses
        self.policies = policies
        self.display_name = display_name
        self.method = method
        self.url_template = url_template
