/*
 * Copyright (C) 2025 The Phosh Developers
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include "lcb-enums.h"

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _CbdChannelsRange {
  LcbSeverityLevel level;
  int              start;
  int              end;
} CbdChannelsRange;

#define CBD_TYPE_CHANNEL_MANAGER (cbd_channel_manager_get_type ())

G_DECLARE_FINAL_TYPE (CbdChannelManager, cbd_channel_manager, CBD, CHANNEL_MANAGER, GObject)

CbdChannelManager *   cbd_channel_manager_new (const char *service_providers_database);
const char *          cbd_channel_manager_get_service_providers_database (CbdChannelManager *self);
LcbChannelMode        cbd_channel_manager_get_mode (CbdChannelManager *self);
void                  cbd_channel_manager_set_mode (CbdChannelManager *self, LcbChannelMode mode);
const char *          cbd_channel_manager_get_country (CbdChannelManager *self);
void                  cbd_channel_manager_set_country (CbdChannelManager *self,
                                                       const char        *country);
GArray *              cbd_channel_manager_get_channels (CbdChannelManager *self);
LcbSeverityLevel      cbd_channel_manager_lookup_level (CbdChannelManager *self,
                                                        int                channel);


G_END_DECLS
