// Generated by CoffeeScript 1.10.0
(function() {
  var Fs, Liquid, Path, readFile,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Liquid = require("../liquid");

  Fs = require("fs");

  Path = require("path");

  readFile = function(fpath, encoding) {
    return new Promise(function(resolve, reject) {
      return Fs.readFile(fpath, encoding, function(err, content) {
        if (err) {
          return reject(err);
        } else {
          return resolve(content);
        }
      });
    });
  };

  module.exports = Liquid.LocalFileSystem = (function(superClass) {
    var PathPattern;

    extend(LocalFileSystem, superClass);

    PathPattern = /^[^.\/][a-zA-Z0-9-_\/]+$/;

    function LocalFileSystem(root, extension) {
      if (extension == null) {
        extension = "html";
      }
      this.root = root;
      this.fileExtension = extension;
    }

    LocalFileSystem.prototype.readTemplateFile = function(templatePath) {
      return this.fullPath(templatePath).then(function(fullPath) {
        return readFile(fullPath, 'utf8')["catch"](function(err) {
          throw new Liquid.FileSystemError("Error loading template: " + err.message);
        });
      });
    };

    LocalFileSystem.prototype.fullPath = function(templatePath) {
      if (PathPattern.test(templatePath)) {
        return Promise.resolve(Path.resolve(Path.join(this.root, templatePath + ("." + this.fileExtension))));
      } else {
        return Promise.reject(new Liquid.ArgumentError("Illegal template name '" + templatePath + "'"));
      }
    };

    return LocalFileSystem;

  })(Liquid.BlankFileSystem);

}).call(this);

//# sourceMappingURL=local_file_system.js.map
