<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/fail2ban/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/fail2ban/metadata.yaml"
sidebar_label: "Fail2ban"
learn_status: "Published"
learn_rel_path: "Data Collection/Authentication and Authorization"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Fail2ban


<img src="https://netdata.cloud/img/fail2ban.png" width="150"/>


Plugin: python.d.plugin
Module: fail2ban

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor Fail2ban performance for prime intrusion prevention operations. Monitor ban counts, jail statuses, and failed login attempts to ensure robust network security.


It collects metrics through reading the default log and configuration files of fail2ban.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The `fail2ban.log` file must be readable by the user `netdata`.
  - change the file ownership and access permissions.
  - update `/etc/logrotate.d/fail2ban`` to persist the changes after rotating the log file.

To change the file ownership and access permissions, execute the following:

```shell
sudo chown root:netdata /var/log/fail2ban.log
sudo chmod 640 /var/log/fail2ban.log
```

To persist the changes after rotating the log file, add `create 640 root netdata` to the `/etc/logrotate.d/fail2ban`:

```shell
/var/log/fail2ban.log {

    weekly
    rotate 4
    compress

    delaycompress
    missingok
    postrotate
        fail2ban-client flushlogs 1>/dev/null
    endscript

    # If fail2ban runs as non-root it still needs to have write access
    # to logfiles.
    # create 640 fail2ban adm
    create 640 root netdata
}
```


### Default Behavior

#### Auto-Detection

By default the collector will attempt to read log file at /var/log/fail2ban.log and conf file at /etc/fail2ban/jail.local.
If conf file is not found default jail is ssh.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Fail2ban instance

These metrics refer to the entire monitored application.


This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| fail2ban.failed_attempts | a dimension per jail | attempts/s |
| fail2ban.bans | a dimension per jail | bans/s |
| fail2ban.banned_ips | a dimension per jail | ips |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `python.d/fail2ban.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/fail2ban.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| log_path | path to fail2ban.log. | /var/log/fail2ban.log | False |
| conf_path | path to jail.local/jail.conf. | /etc/fail2ban/jail.local | False |
| conf_dir | path to jail.d/. | /etc/fail2ban/jail.d/ | False |
| exclude | jails you want to exclude from autodetection. |  | False |
| update_every | Sets the default data collection frequency. | 1 | False |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | False |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | False |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | False |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | False |

</details>

#### Examples

##### Basic

A basic example configuration.

```yaml
local:
  log_path: '/var/log/fail2ban.log'
  conf_path: '/etc/fail2ban/jail.local'

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `fail2ban` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin fail2ban debug trace
  ```

### Debug Mode




