//! Data generated by scope analysis, and consumed only by emitter

use std::collections::HashMap;
use stencil::script::ScriptStencilIndex;

/// Data associated to a function.
#[derive(Debug)]
pub struct FunctionProperty {
    is_annex_b: bool,
}

impl FunctionProperty {
    fn is_annex_b_default() -> bool {
        false
    }

    pub fn new() -> Self {
        Self {
            is_annex_b: Self::is_annex_b_default(),
        }
    }

    pub fn mark_annex_b(&mut self) {
        self.is_annex_b = true;
    }

    pub fn is_annex_b(&self) -> bool {
        self.is_annex_b
    }
}

/// Map from function to associated data.
#[derive(Debug)]
pub struct FunctionDeclarationPropertyMap {
    /// This map is populated lazily, only for functions with non-default
    /// property.
    props: HashMap<ScriptStencilIndex, FunctionProperty>,
}

impl FunctionDeclarationPropertyMap {
    pub fn new() -> Self {
        Self {
            props: HashMap::new(),
        }
    }

    pub fn mark_annex_b(&mut self, index: ScriptStencilIndex) {
        if !self.props.contains_key(&index) {
            self.props.insert(index, FunctionProperty::new());
        }

        self.props
            .get_mut(&index)
            .expect("Should exist")
            .mark_annex_b();
    }

    pub fn is_annex_b(&self, index: ScriptStencilIndex) -> bool {
        if !self.props.contains_key(&index) {
            return FunctionProperty::is_annex_b_default();
        }

        self.props.get(&index).expect("Should exist").is_annex_b()
    }
}
