/* moonshot-id.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-id.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gnome-keyring-memory.h>


#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
typedef struct _TrustAnchorPrivate TrustAnchorPrivate;

#define TRUST_ANCHOR_TYPE_TRUST_ANCHOR_TYPE (trust_anchor_trust_anchor_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;
typedef struct _IdCardPrivate IdCardPrivate;

#define ID_CARD_TYPE_DIFF_FLAGS (id_card_diff_flags_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TrustAnchor {
	GObject parent_instance;
	TrustAnchorPrivate * priv;
};

struct _TrustAnchorClass {
	GObjectClass parent_class;
};

struct _TrustAnchorPrivate {
	gchar* _ca_cert;
	gchar* _subject;
	gchar* _subject_alt;
	gchar* _server_cert;
	gchar* _datetime_added;
};

typedef enum  {
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_EMPTY,
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_CA_CERT,
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT
} TrustAnchorTrustAnchorType;

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};

struct _IdCard {
	GObject parent_instance;
	IdCardPrivate * priv;
};

struct _IdCardClass {
	GObjectClass parent_class;
};

struct _IdCardPrivate {
	gchar* _username;
	gchar* _issuer;
	gchar* _display_name;
	const gchar* _password;
	Rule* _rules;
	gint _rules_length1;
	gint __rules_size_;
	GeeArrayList* _services;
	gboolean _temporary;
	TrustAnchor* _trust_anchor;
	gchar* _nai;
	gboolean _store_password;
	gchar* _uuid;
};

typedef enum  {
	ID_CARD_DIFF_FLAGS_DISPLAY_NAME,
	ID_CARD_DIFF_FLAGS_USERNAME,
	ID_CARD_DIFF_FLAGS_PASSWORD,
	ID_CARD_DIFF_FLAGS_ISSUER,
	ID_CARD_DIFF_FLAGS_RULES,
	ID_CARD_DIFF_FLAGS_SERVICES,
	ID_CARD_DIFF_FLAGS_TRUST_ANCHOR
} IdCardDiffFlags;


static gpointer trust_anchor_parent_class = NULL;
extern MoonshotLogger* id_card_logger;
static gpointer id_card_parent_class = NULL;
MoonshotLogger* id_card_logger = NULL;

gchar* get_cert_valid_before (guchar* inbuf, gint inlen, gchar* outbuf, gint outlen);
GType trust_anchor_get_type (void) G_GNUC_CONST;
#define TRUST_ANCHOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRUST_ANCHOR, TrustAnchorPrivate))
enum  {
	TRUST_ANCHOR_DUMMY_PROPERTY,
	TRUST_ANCHOR_CA_CERT,
	TRUST_ANCHOR_SUBJECT,
	TRUST_ANCHOR_SUBJECT_ALT,
	TRUST_ANCHOR_SERVER_CERT,
	TRUST_ANCHOR_DATETIME_ADDED
};
GType trust_anchor_trust_anchor_type_get_type (void) G_GNUC_CONST;
#define TRUST_ANCHOR_CERT_HEADER "-----BEGIN CERTIFICATE-----"
#define TRUST_ANCHOR_CERT_FOOTER "-----END CERTIFICATE-----"
static gchar* trust_anchor_fixup (const gchar* s);
TrustAnchor* trust_anchor_new (const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
TrustAnchor* trust_anchor_construct (GType object_type, const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
TrustAnchor* trust_anchor_new_empty (void);
TrustAnchor* trust_anchor_construct_empty (GType object_type);
gboolean trust_anchor_is_empty (TrustAnchor* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
TrustAnchorTrustAnchorType trust_anchor_get_anchor_type (TrustAnchor* self);
void trust_anchor_set_datetime_added (TrustAnchor* self, const gchar* datetime);
gchar* trust_anchor_format_datetime_now (void);
void trust_anchor_update_server_fingerprint (TrustAnchor* self, const gchar* fingerprint);
gint trust_anchor_Compare (TrustAnchor* self, TrustAnchor* other);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
gchar* trust_anchor_get_expiration_date (TrustAnchor* self, gchar** err_out);
GType moonshot_logger_get_type (void) G_GNUC_CONST;
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
void moonshot_logger_error (MoonshotLogger* self, const gchar* message, GError* e);
const gchar* trust_anchor_get_datetime_added (TrustAnchor* self);
static void trust_anchor_finalize (GObject* obj);
static void _vala_trust_anchor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
gint rule_Compare (Rule *self, Rule* other);
GType id_card_get_type (void) G_GNUC_CONST;
#define ID_CARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ID_CARD, IdCardPrivate))
enum  {
	ID_CARD_DUMMY_PROPERTY,
	ID_CARD_DISPLAY_NAME,
	ID_CARD_USERNAME,
	ID_CARD_ISSUER,
	ID_CARD_PASSWORD,
	ID_CARD_SERVICES,
	ID_CARD_TEMPORARY,
	ID_CARD_TRUST_ANCHOR,
	ID_CARD_NAI,
	ID_CARD_STORE_PASSWORD,
	ID_CARD_UUID
};
void id_card_set_password (IdCard* self, const gchar* value);
GType id_card_diff_flags_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
static void _vala_Rule_array_free (Rule* array, gint array_length);
gchar* id_card_generate_uuid (void);
#define ID_CARD_NO_IDENTITY "No Identity"
static void id_card_update_nai (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
const gchar* id_card_get_issuer (IdCard* self);
gchar* id_card_get_services_string (IdCard* self, const gchar* sep);
void id_card_update_services (IdCard* self, gchar** services, int services_length1);
void id_card_update_services_from_list (IdCard* self, GeeArrayList* services);
void id_card_set_trust_anchor_from_store (IdCard* self, TrustAnchor* ta);
void id_card_clear_trust_anchor (IdCard* self);
gboolean id_card_is_no_identity (IdCard* self);
const gchar* id_card_get_display_name (IdCard* self);
gint id_card_Compare (IdCard* self, IdCard* other);
const gchar* id_card_get_password (IdCard* self);
gint CompareRules (Rule* a, int a_length1, Rule* b, int b_length1);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
gint CompareStringArrayList (GeeArrayList* a, GeeArrayList* b);
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
IdCard* id_card_NewNoIdentity (void);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_add_rule (IdCard* self, Rule* rule);
static void _vala_array_add2 (Rule** array, int* length, int* size, const Rule* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static Rule* _vala_array_dup5 (Rule* self, int length);
GeeArrayList* id_card_get_services (IdCard* self);
gboolean id_card_get_temporary (IdCard* self);
void id_card_set_temporary (IdCard* self, gboolean value);
const gchar* id_card_get_nai (IdCard* self);
static void id_card_set_nai (IdCard* self, const gchar* value);
gboolean id_card_get_store_password (IdCard* self);
void id_card_set_store_password (IdCard* self, gboolean value);
const gchar* id_card_get_uuid (IdCard* self);
static void id_card_finalize (GObject* obj);
static void _vala_id_card_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_id_card_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType trust_anchor_trust_anchor_type_get_type (void) {
	static volatile gsize trust_anchor_trust_anchor_type_type_id__volatile = 0;
	if (g_once_init_enter (&trust_anchor_trust_anchor_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRUST_ANCHOR_TRUST_ANCHOR_TYPE_EMPTY, "TRUST_ANCHOR_TRUST_ANCHOR_TYPE_EMPTY", "empty"}, {TRUST_ANCHOR_TRUST_ANCHOR_TYPE_CA_CERT, "TRUST_ANCHOR_TRUST_ANCHOR_TYPE_CA_CERT", "ca-cert"}, {TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT, "TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT", "server-cert"}, {0, NULL, NULL}};
		GType trust_anchor_trust_anchor_type_type_id;
		trust_anchor_trust_anchor_type_type_id = g_enum_register_static ("TrustAnchorTrustAnchorType", values);
		g_once_init_leave (&trust_anchor_trust_anchor_type_type_id__volatile, trust_anchor_trust_anchor_type_type_id);
	}
	return trust_anchor_trust_anchor_type_type_id__volatile;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1215 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 293 "moonshot-id.c"
}


static gchar* trust_anchor_fixup (const gchar* s) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = s;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp1_ == NULL) {
#line 307 "moonshot-id.c"
		gchar* _tmp2_ = NULL;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp2_ = g_strdup ("");
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (_tmp0_);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = _tmp2_;
#line 315 "moonshot-id.c"
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = s;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp4_ = string_strip (_tmp3_);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (_tmp0_);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = _tmp4_;
#line 327 "moonshot-id.c"
	}
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 333 "moonshot-id.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1388 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1388 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1388 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 346 "moonshot-id.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 377 "moonshot-id.c"
				goto __catch2_g_regex_error;
			}
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 386 "moonshot-id.c"
		}
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 402 "moonshot-id.c"
				goto __catch2_g_regex_error;
			}
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 413 "moonshot-id.c"
		}
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 427 "moonshot-id.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1393 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 441 "moonshot-id.c"
	}
	__finally2:
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 452 "moonshot-id.c"
	}
}


TrustAnchor* trust_anchor_construct (GType object_type, const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt) {
	TrustAnchor * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* cruft = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (ca_cert != NULL, NULL);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (server_cert != NULL, NULL);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (subject_alt != NULL, NULL);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = (TrustAnchor*) g_object_new (object_type, NULL);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = ca_cert;
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = trust_anchor_fixup (_tmp0_);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_ca_cert);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_ca_cert = _tmp1_;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = server_cert;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = trust_anchor_fixup (_tmp2_);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_server_cert);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_server_cert = _tmp3_;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = subject;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = trust_anchor_fixup (_tmp4_);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject = _tmp5_;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = subject_alt;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp7_ = trust_anchor_fixup (_tmp6_);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject_alt);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject_alt = _tmp7_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp8_ = g_strdup ("");
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_datetime_added);
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_datetime_added = _tmp8_;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp9_ = g_strdup ("<!-- Remove the begin and end lines from the PEM output of\n" \
"openssl to produce this format.  Alternatively, base64 encode a DER fo" \
"rmat certificate -->");
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	cruft = _tmp9_;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp10_ = self->priv->_ca_cert;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp11_ = string_replace (_tmp10_, cruft, "");
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_ca_cert);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_ca_cert = _tmp11_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (cruft);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return self;
#line 536 "moonshot-id.c"
}


TrustAnchor* trust_anchor_new (const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt) {
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return trust_anchor_construct (TYPE_TRUST_ANCHOR, ca_cert, server_cert, subject, subject_alt);
#line 543 "moonshot-id.c"
}


TrustAnchor* trust_anchor_construct_empty (GType object_type) {
	TrustAnchor * self = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = (TrustAnchor*) g_object_new (object_type, NULL);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return self;
#line 553 "moonshot-id.c"
}


TrustAnchor* trust_anchor_new_empty (void) {
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return trust_anchor_construct_empty (TYPE_TRUST_ANCHOR);
#line 560 "moonshot-id.c"
}


gboolean trust_anchor_is_empty (TrustAnchor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = trust_anchor_get_ca_cert (self);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp2_, "") == 0) {
#line 577 "moonshot-id.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = trust_anchor_get_server_cert (self);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp4_ = _tmp3_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, "") == 0;
#line 586 "moonshot-id.c"
	} else {
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = FALSE;
#line 590 "moonshot-id.c"
	}
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 596 "moonshot-id.c"
}


TrustAnchorTrustAnchorType trust_anchor_get_anchor_type (TrustAnchor* self) {
	TrustAnchorTrustAnchorType result = 0;
	TrustAnchorTrustAnchorType _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = trust_anchor_get_server_cert (self);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp2_, "") != 0) {
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT;
#line 615 "moonshot-id.c"
	} else {
		TrustAnchorTrustAnchorType _tmp3_ = 0;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp4_ = trust_anchor_get_ca_cert (self);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp5_ = _tmp4_;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		if (g_strcmp0 (_tmp5_, "") != 0) {
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp3_ = TRUST_ANCHOR_TRUST_ANCHOR_TYPE_CA_CERT;
#line 628 "moonshot-id.c"
		} else {
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp3_ = TRUST_ANCHOR_TRUST_ANCHOR_TYPE_EMPTY;
#line 632 "moonshot-id.c"
		}
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = _tmp3_;
#line 636 "moonshot-id.c"
	}
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 642 "moonshot-id.c"
}


void trust_anchor_set_datetime_added (TrustAnchor* self, const gchar* datetime) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (datetime != NULL);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = datetime;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = trust_anchor_fixup (_tmp0_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_datetime_added);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_datetime_added = _tmp1_;
#line 661 "moonshot-id.c"
}


gchar* trust_anchor_format_datetime_now (void) {
	gchar* result = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	gchar* dt = NULL;
	gchar* _tmp1_ = NULL;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = g_date_time_new_now_utc ();
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	now = _tmp0_;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_date_time_format (now, "%b %d %T %Y %Z");
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	dt = _tmp1_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = dt;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_date_time_unref0 (now);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 685 "moonshot-id.c"
}


void trust_anchor_update_server_fingerprint (TrustAnchor* self, const gchar* fingerprint) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* ta_datetime_added = NULL;
	gchar* _tmp2_ = NULL;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (fingerprint != NULL);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = fingerprint;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_server_cert);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_server_cert = _tmp1_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = trust_anchor_format_datetime_now ();
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	ta_datetime_added = _tmp2_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	trust_anchor_set_datetime_added (self, ta_datetime_added);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (ta_datetime_added);
#line 714 "moonshot-id.c"
}


gint trust_anchor_Compare (TrustAnchor* self, TrustAnchor* other) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	TrustAnchor* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	TrustAnchor* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	TrustAnchor* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	TrustAnchor* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = trust_anchor_get_ca_cert (self);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _tmp0_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = other;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = trust_anchor_get_ca_cert (_tmp2_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = _tmp3_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp1_, _tmp4_) != 0) {
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 760 "moonshot-id.c"
	}
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = trust_anchor_get_subject (self);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = _tmp5_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp7_ = other;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp8_ = trust_anchor_get_subject (_tmp7_);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp9_ = _tmp8_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp6_, _tmp9_) != 0) {
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 778 "moonshot-id.c"
	}
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp10_ = trust_anchor_get_subject_alt (self);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp11_ = _tmp10_;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp12_ = other;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp13_ = trust_anchor_get_subject_alt (_tmp12_);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp14_ = _tmp13_;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp11_, _tmp14_) != 0) {
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 796 "moonshot-id.c"
	}
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp15_ = trust_anchor_get_server_cert (self);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp16_ = _tmp15_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp17_ = other;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp18_ = trust_anchor_get_server_cert (_tmp17_);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp19_ = _tmp18_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp16_, _tmp19_) != 0) {
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 814 "moonshot-id.c"
	}
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 820 "moonshot-id.c"
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1199 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1200 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1200 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1201 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1201 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strchomp (_tmp1_);
#line 1202 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1202 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 843 "moonshot-id.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 855 "moonshot-id.c"
}


gchar* trust_anchor_get_expiration_date (TrustAnchor* self, gchar** err_out) {
	gchar* _vala_err_out = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* cert = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guchar* binary = NULL;
	const gchar* _tmp9_ = NULL;
	size_t _tmp10_;
	guchar* _tmp11_ = NULL;
	gint binary_length1 = 0;
	gint _binary_size_ = 0;
	MoonshotLogger* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	guchar* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar buf[64] = {0};
	gchar* err = NULL;
	guchar* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	guchar* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* date = NULL;
	gchar* _tmp31_ = NULL;
	MoonshotLogger* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if ((&_vala_err_out) != NULL) {
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (_vala_err_out);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_vala_err_out = NULL;
#line 909 "moonshot-id.c"
	}
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = trust_anchor_get_ca_cert (self);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _tmp0_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp1_, "") == 0) {
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		if ((&_vala_err_out) != NULL) {
#line 919 "moonshot-id.c"
			gchar* _tmp2_ = NULL;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp2_ = g_strdup ("Trust anchor does not have a ca_certificate");
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_g_free0 (_vala_err_out);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_vala_err_out = _tmp2_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			result = NULL;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			if (err_out) {
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				*err_out = _vala_err_out;
#line 933 "moonshot-id.c"
			} else {
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_g_free0 (_vala_err_out);
#line 937 "moonshot-id.c"
			}
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			return result;
#line 941 "moonshot-id.c"
		}
	}
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = trust_anchor_get_ca_cert (self);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = _tmp3_;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	cert = _tmp5_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = cert;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp7_ = string_chomp (_tmp6_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp8_ = _tmp7_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (_tmp8_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp9_ = cert;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp11_ = g_base64_decode (_tmp9_, &_tmp10_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	binary = _tmp11_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	binary_length1 = _tmp10_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_binary_size_ = binary_length1;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp12_ = id_card_logger;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp13_ = cert;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp14_ = strlen (_tmp13_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp15_ = _tmp14_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp16_ = binary;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp16__length1 = binary_length1;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp17_ = g_strdup_printf ("get_expiration_date: encoded length=%d; decoded length=%d", _tmp15_, _tmp16__length1);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp18_ = _tmp17_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	moonshot_logger_trace (_tmp12_, _tmp18_, NULL);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (_tmp18_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp19_ = binary;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp19__length1 = binary_length1;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp20_ = binary;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp20__length1 = binary_length1;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp21_ = get_cert_valid_before (_tmp19_, _tmp20__length1, buf, 64);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp22_ = g_strdup ((const gchar*) _tmp21_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	err = _tmp22_;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp23_ = err;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp23_, "") != 0) {
#line 1008 "moonshot-id.c"
		MoonshotLogger* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp24_ = id_card_logger;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp25_ = err;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp26_ = string_to_string (_tmp25_);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp27_ = g_strconcat ("get_expiration_date: get_cert_valid_before returned '", _tmp26_, "'", NULL);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp28_ = _tmp27_;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		moonshot_logger_error (_tmp24_, _tmp28_, NULL);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (_tmp28_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		if ((&_vala_err_out) != NULL) {
#line 1030 "moonshot-id.c"
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp29_ = err;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp30_ = g_strdup (_tmp29_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_g_free0 (_vala_err_out);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_vala_err_out = _tmp30_;
#line 1041 "moonshot-id.c"
		}
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = NULL;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (err);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		binary = (g_free (binary), NULL);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (cert);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		if (err_out) {
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			*err_out = _vala_err_out;
#line 1055 "moonshot-id.c"
		} else {
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_g_free0 (_vala_err_out);
#line 1059 "moonshot-id.c"
		}
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 1063 "moonshot-id.c"
	}
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp31_ = g_strdup ((const gchar*) buf);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	date = _tmp31_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp32_ = id_card_logger;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp33_ = date;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp34_ = string_to_string (_tmp33_);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp35_ = g_strconcat ("get_expiration_date: get_cert_valid_before returned '", _tmp34_, "'", NULL);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp36_ = _tmp35_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	moonshot_logger_trace (_tmp32_, _tmp36_, NULL);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (_tmp36_);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = date;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (err);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	binary = (g_free (binary), NULL);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (cert);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (err_out) {
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		*err_out = _vala_err_out;
#line 1095 "moonshot-id.c"
	} else {
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (_vala_err_out);
#line 1099 "moonshot-id.c"
	}
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1103 "moonshot-id.c"
}


const gchar* trust_anchor_get_ca_cert (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_ca_cert;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1118 "moonshot-id.c"
}


const gchar* trust_anchor_get_subject (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_subject;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1133 "moonshot-id.c"
}


const gchar* trust_anchor_get_subject_alt (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_subject_alt;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1148 "moonshot-id.c"
}


const gchar* trust_anchor_get_server_cert (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_server_cert;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1163 "moonshot-id.c"
}


const gchar* trust_anchor_get_datetime_added (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_datetime_added;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1178 "moonshot-id.c"
}


static void trust_anchor_class_init (TrustAnchorClass * klass) {
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	trust_anchor_parent_class = g_type_class_peek_parent (klass);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_type_class_add_private (klass, sizeof (TrustAnchorPrivate));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_trust_anchor_get_property;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->finalize = trust_anchor_finalize;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_CA_CERT, g_param_spec_string ("ca-cert", "ca-cert", "ca-cert", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_SUBJECT, g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_SUBJECT_ALT, g_param_spec_string ("subject-alt", "subject-alt", "subject-alt", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_SERVER_CERT, g_param_spec_string ("server-cert", "server-cert", "server-cert", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_DATETIME_ADDED, g_param_spec_string ("datetime-added", "datetime-added", "datetime-added", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1201 "moonshot-id.c"
}


static void trust_anchor_instance_init (TrustAnchor * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv = TRUST_ANCHOR_GET_PRIVATE (self);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = g_strdup ("");
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_ca_cert = _tmp0_;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup ("");
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject = _tmp1_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = g_strdup ("");
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject_alt = _tmp2_;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = g_strdup ("");
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_server_cert = _tmp3_;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = g_strdup ("");
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_datetime_added = _tmp4_;
#line 1233 "moonshot-id.c"
}


static void trust_anchor_finalize (GObject* obj) {
	TrustAnchor * self;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRUST_ANCHOR, TrustAnchor);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_ca_cert);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject_alt);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_server_cert);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_datetime_added);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (trust_anchor_parent_class)->finalize (obj);
#line 1253 "moonshot-id.c"
}


GType trust_anchor_get_type (void) {
	static volatile gsize trust_anchor_type_id__volatile = 0;
	if (g_once_init_enter (&trust_anchor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrustAnchorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trust_anchor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrustAnchor), 0, (GInstanceInitFunc) trust_anchor_instance_init, NULL };
		GType trust_anchor_type_id;
		trust_anchor_type_id = g_type_register_static (G_TYPE_OBJECT, "TrustAnchor", &g_define_type_info, 0);
		g_once_init_leave (&trust_anchor_type_id__volatile, trust_anchor_type_id);
	}
	return trust_anchor_type_id__volatile;
}


static void _vala_trust_anchor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrustAnchor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TRUST_ANCHOR, TrustAnchor);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	switch (property_id) {
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_CA_CERT:
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_ca_cert (self));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SUBJECT:
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_subject (self));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SUBJECT_ALT:
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_subject_alt (self));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SERVER_CERT:
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_server_cert (self));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_DATETIME_ADDED:
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_datetime_added (self));
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 1304 "moonshot-id.c"
		default:
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 1310 "moonshot-id.c"
	}
}


gint rule_Compare (Rule *self, Rule* other) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Rule _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	Rule _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = (*self).pattern;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = *other;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_.pattern;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp0_, _tmp2_) != 0) {
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 1337 "moonshot-id.c"
	}
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = (*self).always_confirm;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = *other;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = _tmp4_.always_confirm;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp3_, _tmp5_) != 0) {
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 1351 "moonshot-id.c"
	}
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1357 "moonshot-id.c"
}


void rule_copy (const Rule* self, Rule* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = (*self).pattern;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*dest).pattern);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	(*dest).pattern = _tmp1_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = (*self).always_confirm;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*dest).always_confirm);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	(*dest).always_confirm = _tmp3_;
#line 1382 "moonshot-id.c"
}


void rule_destroy (Rule* self) {
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*self).pattern);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*self).always_confirm);
#line 1391 "moonshot-id.c"
}


Rule* rule_dup (const Rule* self) {
	Rule* dup;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	dup = g_new0 (Rule, 1);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	rule_copy (self, dup);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return dup;
#line 1403 "moonshot-id.c"
}


void rule_free (Rule* self) {
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	rule_destroy (self);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_free (self);
#line 1412 "moonshot-id.c"
}


GType rule_get_type (void) {
	static volatile gsize rule_type_id__volatile = 0;
	if (g_once_init_enter (&rule_type_id__volatile)) {
		GType rule_type_id;
		rule_type_id = g_boxed_type_register_static ("Rule", (GBoxedCopyFunc) rule_dup, (GBoxedFreeFunc) rule_free);
		g_once_init_leave (&rule_type_id__volatile, rule_type_id);
	}
	return rule_type_id__volatile;
}


GType id_card_diff_flags_get_type (void) {
	static volatile gsize id_card_diff_flags_type_id__volatile = 0;
	if (g_once_init_enter (&id_card_diff_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{ID_CARD_DIFF_FLAGS_DISPLAY_NAME, "ID_CARD_DIFF_FLAGS_DISPLAY_NAME", "display-name"}, {ID_CARD_DIFF_FLAGS_USERNAME, "ID_CARD_DIFF_FLAGS_USERNAME", "username"}, {ID_CARD_DIFF_FLAGS_PASSWORD, "ID_CARD_DIFF_FLAGS_PASSWORD", "password"}, {ID_CARD_DIFF_FLAGS_ISSUER, "ID_CARD_DIFF_FLAGS_ISSUER", "issuer"}, {ID_CARD_DIFF_FLAGS_RULES, "ID_CARD_DIFF_FLAGS_RULES", "rules"}, {ID_CARD_DIFF_FLAGS_SERVICES, "ID_CARD_DIFF_FLAGS_SERVICES", "services"}, {ID_CARD_DIFF_FLAGS_TRUST_ANCHOR, "ID_CARD_DIFF_FLAGS_TRUST_ANCHOR", "trust-anchor"}, {0, NULL, NULL}};
		GType id_card_diff_flags_type_id;
		id_card_diff_flags_type_id = g_enum_register_static ("IdCardDiffFlags", values);
		g_once_init_leave (&id_card_diff_flags_type_id__volatile, id_card_diff_flags_type_id);
	}
	return id_card_diff_flags_type_id__volatile;
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (array != NULL) {
#line 1442 "moonshot-id.c"
		int i;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			rule_destroy (&array[i]);
#line 1448 "moonshot-id.c"
		}
	}
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_free (array);
#line 1453 "moonshot-id.c"
}


static void id_card_update_nai (IdCard* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = id_card_get_username (self);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _tmp0_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = g_strconcat (_tmp1_, "@", NULL);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = _tmp2_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = id_card_get_issuer (self);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = _tmp4_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_nai);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_nai = _tmp6_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (_tmp3_);
#line 1487 "moonshot-id.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 1062 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 1062 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 1063 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		separator = "";
#line 1504 "moonshot-id.c"
	}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 1514 "moonshot-id.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 1524 "moonshot-id.c"
	}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1530 "moonshot-id.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 1541 "moonshot-id.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 1553 "moonshot-id.c"
		} else {
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 1557 "moonshot-id.c"
		}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 1561 "moonshot-id.c"
	}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1565 "moonshot-id.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 1588 "moonshot-id.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			i = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1597 "moonshot-id.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 1610 "moonshot-id.c"
					gint _tmp10_ = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 1616 "moonshot-id.c"
				}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 1626 "moonshot-id.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 1638 "moonshot-id.c"
				} else {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 1642 "moonshot-id.c"
				}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 1648 "moonshot-id.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 1659 "moonshot-id.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 1674 "moonshot-id.c"
					} else {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 1678 "moonshot-id.c"
					}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 1682 "moonshot-id.c"
				}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					break;
#line 1688 "moonshot-id.c"
				}
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 1700 "moonshot-id.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 1721 "moonshot-id.c"
				} else {
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 1725 "moonshot-id.c"
				}
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 1731 "moonshot-id.c"
			}
		}
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 1738 "moonshot-id.c"
			gchar* _tmp32_ = NULL;
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return result;
#line 1746 "moonshot-id.c"
		}
#line 1074 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 1074 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 1074 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 1077 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 1077 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 1077 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1784 "moonshot-id.c"
		{
			gboolean _tmp46_ = FALSE;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			i = 1;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1793 "moonshot-id.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1809 "moonshot-id.c"
					gint _tmp47_ = 0;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1815 "moonshot-id.c"
				}
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					break;
#line 1829 "moonshot-id.c"
				}
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1849 "moonshot-id.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1864 "moonshot-id.c"
				} else {
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1868 "moonshot-id.c"
				}
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1876 "moonshot-id.c"
			}
		}
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		res = NULL;
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1887 "moonshot-id.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1896 "moonshot-id.c"
	}
}


gchar* id_card_get_services_string (IdCard* self, const gchar* sep) {
	gchar* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** svcs = NULL;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar** _tmp7_ = NULL;
	gint svcs_length1 = 0;
	gint _svcs_size_ = 0;
	const gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gchar* _tmp22_ = NULL;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (sep != NULL, NULL);
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_services;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp2_) {
#line 1929 "moonshot-id.c"
		gchar* _tmp3_ = NULL;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = g_strdup ("");
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = _tmp3_;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 1937 "moonshot-id.c"
	}
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = self->priv->_services;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = _tmp5_;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp7_ = g_new0 (gchar*, _tmp6_ + 1);
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	svcs = _tmp7_;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	svcs_length1 = _tmp6_;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_svcs_size_ = svcs_length1;
#line 1953 "moonshot-id.c"
	{
		gint i = 0;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		i = 0;
#line 1958 "moonshot-id.c"
		{
			gboolean _tmp8_ = FALSE;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp8_ = TRUE;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			while (TRUE) {
#line 1965 "moonshot-id.c"
				gint _tmp10_ = 0;
				GeeArrayList* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				GeeArrayList* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gpointer _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!_tmp8_) {
#line 1979 "moonshot-id.c"
					gint _tmp9_ = 0;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_tmp9_ = i;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					i = _tmp9_ + 1;
#line 1985 "moonshot-id.c"
				}
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp8_ = FALSE;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp10_ = i;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp11_ = self->priv->_services;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp13_ = _tmp12_;
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!(_tmp10_ < _tmp13_)) {
#line 291 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					break;
#line 2001 "moonshot-id.c"
				}
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp14_ = svcs;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp14__length1 = svcs_length1;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp15_ = i;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp16_ = self->priv->_services;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp17_ = i;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_g_free0 (_tmp14_[_tmp15_]);
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp14_[_tmp15_] = (gchar*) _tmp18_;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp19_ = _tmp14_[_tmp15_];
#line 2021 "moonshot-id.c"
			}
		}
	}
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp20_ = sep;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp21_ = svcs;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp21__length1 = svcs_length1;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp22_ = _vala_g_strjoinv (_tmp20_, _tmp21_, _tmp21__length1);
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp22_;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	svcs = (_vala_array_free (svcs, svcs_length1, (GDestroyNotify) g_free), NULL);
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2039 "moonshot-id.c"
}


void id_card_update_services (IdCard* self, gchar** services, int services_length1) {
	GeeArrayList* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_services;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 304 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = services;
#line 304 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = services_length1;
#line 304 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp1_ != NULL) {
#line 2059 "moonshot-id.c"
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp2_ = services;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp2__length1 = services_length1;
#line 2066 "moonshot-id.c"
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			s_collection = _tmp2_;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			s_collection_length1 = _tmp2__length1;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			for (s_it = 0; s_it < _tmp2__length1; s_it = s_it + 1) {
#line 2078 "moonshot-id.c"
				gchar* _tmp3_ = NULL;
				gchar* s = NULL;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp3_ = g_strdup (s_collection[s_it]);
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				s = _tmp3_;
#line 2085 "moonshot-id.c"
				{
					GeeArrayList* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_tmp4_ = self->priv->_services;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_tmp5_ = s;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_g_free0 (s);
#line 2097 "moonshot-id.c"
				}
			}
		}
	}
}


void id_card_update_services_from_list (IdCard* self, GeeArrayList* services) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (services != NULL);
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = services;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = self->priv->_services;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp0_ == _tmp1_) {
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return;
#line 2122 "moonshot-id.c"
	}
#line 317 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = self->priv->_services;
#line 317 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = services;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp3_ != NULL) {
#line 2132 "moonshot-id.c"
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp4_ = self->priv->_services;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp5_ = services;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp5_);
#line 2141 "moonshot-id.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return self ? g_object_ref (self) : NULL;
#line 2149 "moonshot-id.c"
}


void id_card_set_trust_anchor_from_store (IdCard* self, TrustAnchor* ta) {
	TrustAnchor* _tmp0_ = NULL;
	TrustAnchor* _tmp1_ = NULL;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (ta != NULL);
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = ta;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_object_unref0 (self->priv->_trust_anchor);
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_trust_anchor = _tmp1_;
#line 2168 "moonshot-id.c"
}


void id_card_clear_trust_anchor (IdCard* self) {
	TrustAnchor* _tmp0_ = NULL;
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = trust_anchor_new_empty ();
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_object_unref0 (self->priv->_trust_anchor);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_trust_anchor = _tmp0_;
#line 2182 "moonshot-id.c"
}


gchar* id_card_generate_uuid (void) {
	gchar* result = NULL;
	guint32 rand1 = 0U;
	guint32 _tmp0_ = 0U;
	guint32 rand2 = 0U;
	guint32 _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = g_random_int ();
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	rand1 = _tmp0_;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_random_int ();
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	rand2 = _tmp1_;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = trust_anchor_format_datetime_now ();
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = _tmp2_;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = g_strdup_printf ("%08X.%08X::%s", (guint) rand1, (guint) rand2, _tmp3_);
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = _tmp4_;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (_tmp3_);
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp5_;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2218 "moonshot-id.c"
}


gboolean id_card_is_no_identity (IdCard* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
#line 359 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_display_name;
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = g_strcmp0 (_tmp0_, ID_CARD_NO_IDENTITY) == 0;
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2233 "moonshot-id.c"
}


gint id_card_Compare (IdCard* self, IdCard* other) {
	gint result = 0;
	gint diff = 0;
	const gchar* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	IdCard* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	IdCard* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	IdCard* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	Rule* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	Rule* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	IdCard* _tmp24_ = NULL;
	Rule* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	Rule* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gint _tmp27_ = 0;
	GeeArrayList* _tmp29_ = NULL;
	IdCard* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	TrustAnchor* _tmp34_ = NULL;
	TrustAnchor* _tmp35_ = NULL;
	IdCard* _tmp36_ = NULL;
	TrustAnchor* _tmp37_ = NULL;
	TrustAnchor* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gboolean _tmp41_ = FALSE;
	const gchar* _tmp42_ = NULL;
	IdCard* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
#line 374 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 374 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 376 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	diff = 0;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_display_name;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = other;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_->priv->_display_name;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp0_, _tmp2_) != 0) {
#line 2296 "moonshot-id.c"
		gint _tmp3_ = 0;
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = diff;
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp3_ | (1 << ID_CARD_DIFF_FLAGS_DISPLAY_NAME);
#line 2302 "moonshot-id.c"
	}
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = id_card_get_username (self);
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = _tmp4_;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = other;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp7_ = id_card_get_username (_tmp6_);
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp8_ = _tmp7_;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp5_, _tmp8_) != 0) {
#line 2316 "moonshot-id.c"
		gint _tmp9_ = 0;
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp9_ = diff;
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp9_ | (1 << ID_CARD_DIFF_FLAGS_USERNAME);
#line 2322 "moonshot-id.c"
	}
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp10_ = id_card_get_password (self);
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp11_ = _tmp10_;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp12_ = other;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp13_ = id_card_get_password (_tmp12_);
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp14_ = _tmp13_;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp11_, _tmp14_) != 0) {
#line 2336 "moonshot-id.c"
		gint _tmp15_ = 0;
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp15_ = diff;
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp15_ | (1 << ID_CARD_DIFF_FLAGS_PASSWORD);
#line 2342 "moonshot-id.c"
	}
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp16_ = id_card_get_issuer (self);
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp17_ = _tmp16_;
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp18_ = other;
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp19_ = id_card_get_issuer (_tmp18_);
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp20_ = _tmp19_;
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp17_, _tmp20_) != 0) {
#line 2356 "moonshot-id.c"
		gint _tmp21_ = 0;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp21_ = diff;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp21_ | (1 << ID_CARD_DIFF_FLAGS_ISSUER);
#line 2362 "moonshot-id.c"
	}
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp22_ = id_card_get_rules (self, &_tmp22__length1);
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp23_ = _tmp22_;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp23__length1 = _tmp22__length1;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp24_ = other;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp25_ = id_card_get_rules (_tmp24_, &_tmp25__length1);
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp26_ = _tmp25_;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp26__length1 = _tmp25__length1;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp27_ = CompareRules (_tmp23_, _tmp23__length1, _tmp26_, _tmp26__length1);
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp27_ != 0) {
#line 2382 "moonshot-id.c"
		gint _tmp28_ = 0;
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp28_ = diff;
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp28_ | (1 << ID_CARD_DIFF_FLAGS_RULES);
#line 2388 "moonshot-id.c"
	}
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp29_ = self->priv->_services;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp30_ = other;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp31_ = _tmp30_->priv->_services;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp32_ = CompareStringArrayList (_tmp29_, _tmp31_);
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp32_ != 0) {
#line 2400 "moonshot-id.c"
		gint _tmp33_ = 0;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp33_ = diff;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp33_ | (1 << ID_CARD_DIFF_FLAGS_SERVICES);
#line 2406 "moonshot-id.c"
	}
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp34_ = id_card_get_trust_anchor (self);
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp35_ = _tmp34_;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp36_ = other;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp37_ = id_card_get_trust_anchor (_tmp36_);
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp38_ = _tmp37_;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp39_ = trust_anchor_Compare (_tmp35_, _tmp38_);
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp39_ != 0) {
#line 2422 "moonshot-id.c"
		gint _tmp40_ = 0;
#line 396 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp40_ = diff;
#line 396 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp40_ | (1 << ID_CARD_DIFF_FLAGS_TRUST_ANCHOR);
#line 2428 "moonshot-id.c"
	}
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp42_ = self->priv->_display_name;
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp43_ = other;
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp44_ = _tmp43_->priv->_display_name;
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp42_, _tmp44_) == 0) {
#line 2438 "moonshot-id.c"
		gint _tmp45_ = 0;
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp45_ = diff;
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp41_ = _tmp45_ != 0;
#line 2444 "moonshot-id.c"
	} else {
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp41_ = FALSE;
#line 2448 "moonshot-id.c"
	}
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp41_) {
#line 2452 "moonshot-id.c"
		MoonshotLogger* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp46_ = id_card_logger;
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp47_ = self->priv->_display_name;
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp48_ = diff;
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp49_ = g_strdup_printf ("Compare: Two IDs with display_name '%s', but diff_flags=%0x", _tmp47_, (guint) _tmp48_);
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp50_ = _tmp49_;
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		moonshot_logger_trace (_tmp46_, _tmp50_, NULL);
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_g_free0 (_tmp50_);
#line 2472 "moonshot-id.c"
	}
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = diff;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2478 "moonshot-id.c"
}


IdCard* id_card_NewNoIdentity (void) {
	IdCard* result = NULL;
	IdCard* card = NULL;
	IdCard* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 407 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = id_card_new ();
#line 407 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	card = _tmp0_;
#line 408 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_set_display_name (card, ID_CARD_NO_IDENTITY);
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup ("");
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (card->priv->_nai);
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	card->priv->_nai = _tmp1_;
#line 410 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = card;
#line 410 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2503 "moonshot-id.c"
}


static void _vala_array_add2 (Rule** array, int* length, int* size, const Rule* value) {
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if ((*length) == (*size)) {
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		*array = g_renew (Rule, *array, *size);
#line 2514 "moonshot-id.c"
	}
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	(*array)[(*length)++] = *value;
#line 2518 "moonshot-id.c"
}


void id_card_add_rule (IdCard* self, Rule* rule) {
	Rule* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Rule _tmp1_ = {0};
	Rule _tmp2_ = {0};
#line 417 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 417 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (rule != NULL);
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_rules;
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = self->priv->_rules_length1;
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = *rule;
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	rule_copy (&_tmp1_, &_tmp2_);
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_vala_array_add2 (&self->priv->_rules, &self->priv->_rules_length1, &self->priv->__rules_size_, &_tmp2_);
#line 2541 "moonshot-id.c"
}


IdCard* id_card_construct (GType object_type) {
	IdCard * self = NULL;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = (IdCard*) g_object_new (object_type, NULL);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return self;
#line 2551 "moonshot-id.c"
}


IdCard* id_card_new (void) {
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return id_card_construct (TYPE_ID_CARD);
#line 2558 "moonshot-id.c"
}


const gchar* id_card_get_display_name (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_display_name;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2573 "moonshot-id.c"
}


void id_card_set_display_name (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_display_name);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_display_name = _tmp1_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "display-name");
#line 2592 "moonshot-id.c"
}


const gchar* id_card_get_username (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_username;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2607 "moonshot-id.c"
}


void id_card_set_username (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_username);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_username = _tmp1_;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_update_nai (self);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "username");
#line 2628 "moonshot-id.c"
}


const gchar* id_card_get_issuer (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_issuer;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2643 "moonshot-id.c"
}


void id_card_set_issuer (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_issuer);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_issuer = _tmp1_;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_update_nai (self);
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "issuer");
#line 2664 "moonshot-id.c"
}


const gchar* id_card_get_password (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = self->priv->_password;
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp1_ != NULL) {
#line 2678 "moonshot-id.c"
		const gchar* _tmp2_ = NULL;
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp2_ = self->priv->_password;
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = _tmp2_;
#line 2684 "moonshot-id.c"
	} else {
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = "";
#line 2688 "moonshot-id.c"
	}
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2694 "moonshot-id.c"
}


void id_card_set_password (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_password;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp0_ != NULL) {
#line 2707 "moonshot-id.c"
		const gchar* _tmp1_ = NULL;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp1_ = self->priv->_password;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		gnome_keyring_memory_free ((void*) _tmp1_);
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		self->priv->_password = NULL;
#line 2715 "moonshot-id.c"
	}
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = value;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp2_ != NULL) {
#line 2721 "moonshot-id.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = value;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp4_ = gnome_keyring_memory_strdup (_tmp3_);
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		self->priv->_password = _tmp4_;
#line 2730 "moonshot-id.c"
	}
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "password");
#line 2734 "moonshot-id.c"
}


Rule* id_card_get_rules (IdCard* self, int* result_length1) {
	Rule* result;
	Rule* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Rule* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_rules;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = self->priv->_rules_length1;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _tmp0_;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = _tmp0__length1;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (result_length1) {
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		*result_length1 = _tmp1__length1;
#line 2758 "moonshot-id.c"
	}
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp1_;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2764 "moonshot-id.c"
}


static Rule* _vala_array_dup5 (Rule* self, int length) {
	Rule* result;
	int i;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = g_new0 (Rule, length);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	for (i = 0; i < length; i++) {
#line 2775 "moonshot-id.c"
		Rule _tmp0_ = {0};
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		rule_copy (&self[i], &_tmp0_);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result[i] = _tmp0_;
#line 2781 "moonshot-id.c"
	}
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2785 "moonshot-id.c"
}


void id_card_set_rules (IdCard* self, Rule* value, int value_length1) {
	Rule* _tmp0_ = NULL;
	Rule* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	Rule* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	Rule* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = value;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = value_length1;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup5 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2__length1 = _tmp1__length1;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = _tmp2_;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = _tmp2__length1;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	__tmp0__size_ = _tmp0__length1;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp0_ == NULL) {
#line 2817 "moonshot-id.c"
		Rule* _tmp3_ = NULL;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = g_new0 (Rule, 0);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = (_vala_Rule_array_free (_tmp0_, _tmp0__length1), NULL);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = _tmp3_;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0__length1 = 0;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		__tmp0__size_ = _tmp0__length1;
#line 2829 "moonshot-id.c"
	}
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = _tmp0_;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4__length1 = _tmp0__length1;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = NULL;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = 0;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = (_vala_Rule_array_free (self->priv->_rules, self->priv->_rules_length1), NULL);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = _tmp4_;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules_length1 = _tmp4__length1;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->__rules_size_ = self->priv->_rules_length1;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = (_vala_Rule_array_free (_tmp0_, _tmp0__length1), NULL);
#line 2849 "moonshot-id.c"
}


GeeArrayList* id_card_get_services (IdCard* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_services;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2864 "moonshot-id.c"
}


gboolean id_card_get_temporary (IdCard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_temporary;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2879 "moonshot-id.c"
}


void id_card_set_temporary (IdCard* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_temporary = _tmp0_;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "temporary");
#line 2893 "moonshot-id.c"
}


TrustAnchor* id_card_get_trust_anchor (IdCard* self) {
	TrustAnchor* result;
	TrustAnchor* _tmp0_ = NULL;
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_trust_anchor;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2908 "moonshot-id.c"
}


const gchar* id_card_get_nai (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_nai;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2923 "moonshot-id.c"
}


static void id_card_set_nai (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_nai);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_nai = _tmp1_;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "nai");
#line 2942 "moonshot-id.c"
}


gboolean id_card_get_store_password (IdCard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_store_password;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2957 "moonshot-id.c"
}


void id_card_set_store_password (IdCard* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_store_password = _tmp0_;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "store-password");
#line 2971 "moonshot-id.c"
}


const gchar* id_card_get_uuid (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_uuid;
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 2986 "moonshot-id.c"
}


static void id_card_class_init (IdCardClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_parent_class = g_type_class_peek_parent (klass);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_type_class_add_private (klass, sizeof (IdCardPrivate));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_id_card_get_property;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_id_card_set_property;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->finalize = id_card_finalize;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_USERNAME, g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_ISSUER, g_param_spec_string ("issuer", "issuer", "issuer", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_PASSWORD, g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_SERVICES, g_param_spec_object ("services", "services", "services", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_TEMPORARY, g_param_spec_boolean ("temporary", "temporary", "temporary", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_TRUST_ANCHOR, g_param_spec_object ("trust-anchor", "trust-anchor", "trust-anchor", TYPE_TRUST_ANCHOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_NAI, g_param_spec_string ("nai", "nai", "nai", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_STORE_PASSWORD, g_param_spec_boolean ("store-password", "store-password", "store-password", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_UUID, g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = get_logger ("IdCard");
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_logger = _tmp0_;
#line 3026 "moonshot-id.c"
}


static void id_card_instance_init (IdCard * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	Rule* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	TrustAnchor* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv = ID_CARD_GET_PRIVATE (self);
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = g_strdup ("");
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_username = _tmp0_;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup ("");
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_issuer = _tmp1_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = g_strdup ("");
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_display_name = _tmp2_;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = g_new0 (Rule, 0);
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = _tmp3_;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules_length1 = 0;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->__rules_size_ = self->priv->_rules_length1;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_services = _tmp4_;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_temporary = FALSE;
#line 327 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = trust_anchor_new_empty ();
#line 327 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_trust_anchor = _tmp5_;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_store_password = FALSE;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = id_card_generate_uuid ();
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_uuid = _tmp6_;
#line 3076 "moonshot-id.c"
}


static void id_card_finalize (GObject* obj) {
	IdCard * self;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ID_CARD, IdCard);
#line 414 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_set_password (self, NULL);
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_username);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_issuer);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_display_name);
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = (_vala_Rule_array_free (self->priv->_rules, self->priv->_rules_length1), NULL);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_object_unref0 (self->priv->_services);
#line 327 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_object_unref0 (self->priv->_trust_anchor);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_nai);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_uuid);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (id_card_parent_class)->finalize (obj);
#line 3104 "moonshot-id.c"
}


GType id_card_get_type (void) {
	static volatile gsize id_card_type_id__volatile = 0;
	if (g_once_init_enter (&id_card_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdCardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) id_card_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdCard), 0, (GInstanceInitFunc) id_card_instance_init, NULL };
		GType id_card_type_id;
		id_card_type_id = g_type_register_static (G_TYPE_OBJECT, "IdCard", &g_define_type_info, 0);
		g_once_init_leave (&id_card_type_id__volatile, id_card_type_id);
	}
	return id_card_type_id__volatile;
}


static void _vala_id_card_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IdCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ID_CARD, IdCard);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	switch (property_id) {
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_DISPLAY_NAME:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_display_name (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_USERNAME:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_username (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_ISSUER:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_issuer (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_PASSWORD:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_password (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_SERVICES:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_object (value, id_card_get_services (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_TEMPORARY:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_boolean (value, id_card_get_temporary (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_TRUST_ANCHOR:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_object (value, id_card_get_trust_anchor (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_NAI:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_nai (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_STORE_PASSWORD:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_boolean (value, id_card_get_store_password (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_UUID:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_uuid (self));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 3185 "moonshot-id.c"
		default:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 3191 "moonshot-id.c"
	}
}


static void _vala_id_card_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IdCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ID_CARD, IdCard);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	switch (property_id) {
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_DISPLAY_NAME:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_display_name (self, g_value_get_string (value));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_USERNAME:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_username (self, g_value_get_string (value));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_ISSUER:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_issuer (self, g_value_get_string (value));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_PASSWORD:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_password (self, g_value_get_string (value));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_TEMPORARY:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_temporary (self, g_value_get_boolean (value));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_NAI:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_nai (self, g_value_get_string (value));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_STORE_PASSWORD:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_store_password (self, g_value_get_boolean (value));
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 3243 "moonshot-id.c"
		default:
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 3249 "moonshot-id.c"
	}
}


gint CompareRules (Rule* a, int a_length1, Rule* b, int b_length1) {
	gint result = 0;
	Rule* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Rule* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = a;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = a_length1;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = b;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = b_length1;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp0__length1 != _tmp1__length1) {
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 3274 "moonshot-id.c"
	}
	{
		gint i = 0;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		i = 0;
#line 3280 "moonshot-id.c"
		{
			gboolean _tmp2_ = FALSE;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp2_ = TRUE;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			while (TRUE) {
#line 3287 "moonshot-id.c"
				gint _tmp4_ = 0;
				Rule* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				Rule* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				Rule* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				Rule _tmp10_ = {0};
				gint _tmp11_ = 0;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!_tmp2_) {
#line 3301 "moonshot-id.c"
					gint _tmp3_ = 0;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_tmp3_ = i;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					i = _tmp3_ + 1;
#line 3307 "moonshot-id.c"
				}
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp2_ = FALSE;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp4_ = i;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp5_ = a;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp5__length1 = a_length1;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!(_tmp4_ < _tmp5__length1)) {
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					break;
#line 3321 "moonshot-id.c"
				}
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp6_ = a;
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp6__length1 = a_length1;
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp7_ = i;
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp8_ = b;
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp8__length1 = b_length1;
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp9_ = i;
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp11_ = rule_Compare (&_tmp6_[_tmp7_], &_tmp10_);
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (_tmp11_ != 0) {
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					result = 1;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					return result;
#line 3345 "moonshot-id.c"
				}
			}
		}
	}
#line 433 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 433 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 3354 "moonshot-id.c"
}


gint CompareStringArrayList (GeeArrayList* a, GeeArrayList* b) {
	gint result = 0;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeArrayList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 436 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 436 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = a;
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_;
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = b;
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = _tmp4_;
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp2_ != _tmp5_) {
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 3388 "moonshot-id.c"
	}
	{
		gint i = 0;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		i = 0;
#line 3394 "moonshot-id.c"
		{
			gboolean _tmp6_ = FALSE;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp6_ = TRUE;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			while (TRUE) {
#line 3401 "moonshot-id.c"
				gint _tmp8_ = 0;
				GeeArrayList* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GeeArrayList* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gpointer _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				GeeArrayList* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gpointer _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!_tmp6_) {
#line 3417 "moonshot-id.c"
					gint _tmp7_ = 0;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_tmp7_ = i;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					i = _tmp7_ + 1;
#line 3423 "moonshot-id.c"
				}
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp6_ = FALSE;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp8_ = i;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp9_ = a;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp11_ = _tmp10_;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!(_tmp8_ < _tmp11_)) {
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					break;
#line 3439 "moonshot-id.c"
				}
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp12_ = a;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp13_ = i;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp15_ = (gchar*) _tmp14_;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp16_ = b;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp17_ = i;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp19_ = (gchar*) _tmp18_;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp20_ = g_strcmp0 (_tmp15_, _tmp19_) != 0;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_g_free0 (_tmp19_);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_g_free0 (_tmp15_);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (_tmp20_) {
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					result = 1;
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					return result;
#line 3469 "moonshot-id.c"
				}
			}
		}
	}
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 3478 "moonshot-id.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



