// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Text;

namespace System
{
    internal static partial class Environment
    {
        internal static string SystemDirectory
        {
            get
            {
                StringBuilder sb = new StringBuilder(Interop.Kernel32.MAX_PATH);
                int r = Interop.mincore.GetSystemDirectory(sb, Interop.Kernel32.MAX_PATH);
                return sb.ToString();
            }
        }
    }
}
