/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVMISCELANEOUS_H_
#define MVMISCELANEOUS_H_

#include <string>
#include <sstream>
#include <vector>

using namespace std;
namespace metview {

void shellCommand(string&, stringstream&, stringstream&);
bool createWorkDir(string prefix,string& tmpPath,string& errTxt);
double saturationMixingRatio(double t, double p);
double relativeHumidity(double t, double p,double q);
double relativeHumidityFromTd(double t, double td);
double specificHumidity(double t, double p,double r);
double specificHumidityFromTd(double t, double p,double td);
double saturationVapourPressure(double t);
double vapourPressure(double p,double q);
double vapourPPMV(double p,double q);
double ozonePPMV(double r);
double dewPointFromQ(double p, double t, double q, const string& formula);
double speed(double u, double v);
double direction(double u, double v);

template<typename TYPE>
inline string toString(const TYPE& in)
{
	ostringstream os;
	os  <<  in;
	return os.str();
}

} // namespace metview

#endif
