/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQListHelp.h"

#include <QListWidget>
#include <QScrollBar>

#include "HelpFactory.h"
#include "RequestPanel.h"

MvQParamList::MvQParamList(const Parameter &param,QWidget *parent) : 
       QListWidget(parent),
       param_(param)
{
  	//Get items
	param.scan(*this);
	
	adjustHeight();
	
}

void MvQParamList::adjustHeight()
{
	//Try to set the optimal widget height to approximartely 10 rows
	if(count() > 0)
	{
		int itemHeight=rectForIndex(indexFromItem(item(0))).height();
		int totalHeight=itemHeight*10+horizontalScrollBar()->height();
		setMinimumHeight(totalHeight);
		setMaximumHeight(totalHeight);
	}
	else
	{
	  	setMaximumHeight(32);
	}		  
}

void MvQParamList::next(const Parameter&, const char* first,const char* second)
{
	if(isalnum(*first))
   	{
		string astr(first);			
		QListWidgetItem *item=new QListWidgetItem(QString::fromStdString(param_.beautifiedName(astr)),this);
		if(second)
		{	
			item->setData(Qt::UserRole,QString(second));
		}
		else
		{
		  	item->setData(Qt::UserRole,QString(first));
		}
		
		if(param_.multiple())
		{  
			item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled |Qt::ItemIsUserCheckable);
			item->setCheckState(Qt::Unchecked);
		}	
	}	
}

//----------------------------------
// MvQListHelp
//----------------------------------

MvQListHelp::MvQListHelp(RequestPanel& owner,const Parameter& param) :
		   MvQRequestPanelHelp(owner,param)
{
	multiple_=param.multiple();
	
	//Create list
	paramList_=new MvQParamList(param,parentWidget_);
	
	if(!multiple_)
	{	
		paramList_->setSelectionMode(QAbstractItemView::SingleSelection);
	}
			
	connect(paramList_,SIGNAL(itemClicked(QListWidgetItem*)),
		this,SLOT(slotListChanged(QListWidgetItem*)));
}



void MvQListHelp::refresh(const vector<string>& values)
{
	if(!multiple_)
	{  
		if(values.size() > 0)
		{
		  	QString txt(values[0].c_str());
		
			for(int i=0; i < paramList_->count(); i++)
			{
				if(paramList_->item(i)->data(Qt::UserRole).toString().toStdString() == values[0])
				{
					paramList_->setCurrentRow(i);
					return;
				}
			}	
		}	
	}
	else
	{  	
	  	QStringList lst;
		for(int i=0; i < paramList_->count(); i++)
		{
			string s=paramList_->item(i)->data(Qt::UserRole).toString().toStdString();
			
			bool found=false;
			for(vector<string>::const_iterator it = values.begin(); it != values.end(); it++)
			{
				if (s == *it)
				{	
					found=true;
					break;
				}	
			}
			
			if(found)
				paramList_->item(i)->setCheckState(Qt::Checked);
			else
			  	paramList_->item(i)->setCheckState(Qt::Unchecked);
		}	
	}		  
		
}

void MvQListHelp::slotListChanged(QListWidgetItem* item)
{
	if(!item)
	  	return;
  
  	vector<string> val, noVal;
		
	if(!multiple_)
	{
		string s=item->data(Qt::UserRole).toString().toStdString();
		val.push_back(s);
		emit edited(val);
	}	
	else
	{	  	
		//Reverse the items check state 
		//item->setCheckState((item->checkState()==Qt::Checked)?Qt::Unchecked:Qt::Checked);
	  
	  	for(int i=0; i < paramList_->count(); i++)
		{
	  		string s=paramList_->item(i)->data(Qt::UserRole).toString().toStdString();
	  		if(paramList_->item(i)->checkState() == Qt::Checked)
			{
			  	val.push_back(s);
			}
			else
			{
		  		noVal.push_back(s);
			}  
		}	

       	 	emit edited(val,noVal); 
	}	
}

static HelpMaker<MvQListHelp> maker("help_multiple_selection");
