/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.StringTooLongException;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoundingBox
extends Rectangle {
    public static final int LINE_SPACING_PERCENTAGE = 20;
    public static final int VERT_ALIGN_CENTER = 0;
    public static final int VERT_ALIGN_TOP = 1;
    public static final int VERT_ALIGN_BOTTOM = 2;
    public static final int HORIZ_ALIGN_CENTER = 3;
    public static final int HORIZ_ALIGN_LEFT = 4;
    public static final int HORIZ_ALIGN_RIGHT = 5;
    public static final int SUBTRACT_FROM_TOP = 6;
    public static final int SUBTRACT_FROM_BOTTOM = 7;
    public static final int SUBTRACT_FROM_LEFT = 8;
    public static final int SUBTRACT_FROM_RIGHT = 9;
    private static final int[] VERT_ALIGNS = new int[]{0, 1, 2};
    private static final int[] HORIZ_ALIGNS = new int[]{3, 4, 5};
    private static final int[] SUBTRACTS = new int[]{6, 7, 8, 9};
    private final Point drawingPoint;
    private Point absoluteLocation;
    private BoundingBox parent;
    private String[] stringArray;
    private String fullString;

    public BoundingBox(Point point, Dimension dimension) {
        super(point, dimension);
        this.drawingPoint = this.getLocation();
        this.absoluteLocation = this.getLocation();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public BoundingBox getParent() {
        return this.parent;
    }

    public void add(BoundingBox boundingBox) {
        boundingBox.setParent(this);
    }

    public void setParent(BoundingBox boundingBox) {
        if (this == boundingBox) {
            return;
        }
        this.parent = boundingBox;
        if (this.getLocation().equals(this.getAbsoluteLocation())) {
            int n = 0;
            int n2 = 0;
            BoundingBox boundingBox2 = this;
            while (boundingBox2.hasParent()) {
                BoundingBox boundingBox3 = boundingBox2;
                if ((boundingBox2 = boundingBox2.getParent()) == boundingBox3) break;
                n += (int)boundingBox2.getLocation().getX();
                n2 += (int)boundingBox2.getLocation().getY();
            }
            this.getAbsoluteLocation().translate(n, n2);
        }
    }

    public String[] getStringArray() {
        return this.stringArray;
    }

    public void setStringArray(String[] stringArray) {
        this.stringArray = stringArray;
    }

    public void setAbsoluteLocation(Point point) {
        this.absoluteLocation = point;
    }

    public boolean boxExists() {
        return this.getHeight() > 0.0 && this.getWidth() > 0.0;
    }

    public Point getAbsoluteLocation() {
        return this.absoluteLocation;
    }

    public String getFullString() {
        return this.fullString;
    }

    public void setFullString(String string) {
        this.fullString = string;
    }

    public BoundingBox getStringBounds(String string, int n, int n2, FontMetrics fontMetrics, int n3, boolean bl) throws IllegalArgumentException, StringTooLongException {
        Cloneable cloneable;
        if (!this.checkHAlign(n)) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, hAlign invalid : " + n);
        }
        if (!this.checkVAlign(n2)) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, vAlign invalid : " + n);
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, FontMetrics null");
        }
        if (string == null) {
            throw new IllegalArgumentException("BoundingBox.getStringBounds, String null");
        }
        Dimension dimension = this.getSize();
        int n4 = fontMetrics.getMaxAscent();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = n4 + fontMetrics.getMaxDescent();
        int n7 = (int)dimension.getWidth();
        int n8 = (int)dimension.getHeight();
        if (n7 < 0) {
            throw new StringTooLongException("The parent box has a negative width  (" + n7 + ")");
        }
        if (n8 < 0) {
            throw new StringTooLongException("The parent box has a negative height (" + n8 + ")");
        }
        int n9 = n5 + n3 * 2;
        int n10 = n6 + n3 * 2;
        int n11 = (int)this.getX();
        int n12 = (int)this.getY();
        String[] stringArray = null;
        if (n9 > n7 || string.contains("\n")) {
            n9 = n7 - n3 * 2;
            stringArray = this.createStringArray(string, fontMetrics, n3, n7);
            n10 = this.getWrappedHeight(stringArray, fontMetrics, n3);
            if (n10 > n8 && bl) {
                throw new StringTooLongException("The wrapped strings do not fit into the parent box, pw=" + n7 + ", ph=" + n8 + ", ch=" + n10 + ", cw=" + n9 + ", string: " + string);
            }
        }
        int n13 = n2 == 1 ? 0 : (n2 == 0 ? n8 / 2 - n10 / 2 : n8 - n10);
        int n14 = n == 4 ? 0 : (n == 3 ? n7 / 2 - n9 / 2 : n7 - n9);
        Point point = new Point(n14, n13);
        Dimension dimension2 = new Dimension(n9, n10);
        int n15 = 0;
        int n16 = 0;
        BoundingBox boundingBox = this;
        while (boundingBox.hasParent()) {
            cloneable = boundingBox;
            if ((boundingBox = boundingBox.getParent()) == cloneable) break;
            n15 += (int)boundingBox.getLocation().getX();
            n16 += (int)boundingBox.getLocation().getY();
        }
        int n17 = n11 + n14 + n15;
        int n18 = n12 + n13 + n16;
        int n19 = n17 + n3;
        int n20 = n18 + n3 + n4;
        cloneable = new Point(n19, n20);
        BoundingBox boundingBox2 = new BoundingBox(point, dimension2, (Point)cloneable, new Point(n17, n18));
        this.add(boundingBox2);
        boundingBox2.setFullString(string);
        boundingBox2.setStringArray(stringArray);
        return boundingBox2;
    }

    public BoundingBox getStringBounds(String string, int n, int n2, FontMetrics fontMetrics, int n3) throws StringTooLongException, IllegalArgumentException {
        return this.getStringBounds(string, n, n2, fontMetrics, n3, true);
    }

    public void drawWrappedString(Graphics graphics, FontMetrics fontMetrics, int n, int n2) throws IllegalArgumentException, StringTooLongException {
        if (this.getStringArray() == null) {
            Point point = this.getDrawingPoint();
            int n3 = (int)point.getX();
            int n4 = (int)point.getY();
            graphics.drawString(this.getFullString(), n3, n4);
        } else {
            int n5 = this.stringArray.length;
            for (String string : this.stringArray) {
                BoundingBox boundingBox = this.getStringBounds(string, n2, 1, fontMetrics, 0);
                Point point = boundingBox.getDrawingPoint();
                int n6 = (int)point.getX();
                if (n2 == 5) {
                    n6 -= n;
                }
                if (n2 == 4) {
                    n6 += n;
                }
                int n7 = (int)point.getY() + n;
                graphics.drawString(string, n6, n7);
                this.subtract(boundingBox, 7);
            }
        }
    }

    public void drawWrappedStringTruncate(Graphics graphics, FontMetrics fontMetrics, int n, int n2) {
        if (this.getStringArray() == null) {
            Point point = this.getDrawingPoint();
            int n3 = (int)point.getX();
            int n4 = (int)point.getY();
            if (this.getFullString() != null) {
                graphics.drawString(this.getFullString(), n3, n4);
            } else {
                System.err.println("getStringArray and getFullString are null");
            }
        } else {
            int n5 = 0;
            int n6 = this.stringArray.length;
            for (String string : this.stringArray) {
                BoundingBox boundingBox = null;
                try {
                    boundingBox = this.getStringBounds(string, n2, 1, fontMetrics, 0, false);
                    if (this.getParent() != null && (n5 += (int)boundingBox.getHeight()) > (int)this.getParent().getHeight()) {
                        return;
                    }
                }
                catch (StringTooLongException stringTooLongException) {
                    stringTooLongException.printStackTrace();
                    return;
                }
                boundingBox.drawChoppedString(graphics, fontMetrics, n, n2);
                this.subtract(boundingBox, 7);
            }
        }
    }

    public void drawChoppedString(Graphics graphics, FontMetrics fontMetrics, int n, int n2) {
        String string = "";
        string = this.getStringArray() != null ? this.getStringArray()[0] : this.getFullString();
        BoundingBox boundingBox = null;
        try {
            boundingBox = this.getStringBounds(string, n2, 1, fontMetrics, n);
            Point point = boundingBox.getDrawingPoint();
            int n3 = (int)point.getX();
            int n4 = (int)point.getY();
            graphics.drawString(string, n3, n4);
        }
        catch (StringTooLongException stringTooLongException) {
            StringBuilder stringBuilder = new StringBuilder().append(string);
            if (stringBuilder.length() == 0) {
                System.out.println("BoundingBox.drawChoppedString, buf len 0 ??");
                throw new RuntimeException();
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            while (fontMetrics.stringWidth(stringBuilder.toString()) > (int)this.getWidth() && stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            try {
                boundingBox = this.getStringBounds(stringBuilder.toString(), n2, 1, fontMetrics, n);
                Point point = boundingBox.getDrawingPoint();
                int n5 = (int)point.getX();
                int n6 = (int)point.getY();
                graphics.drawString(string, n5, n6);
            }
            catch (StringTooLongException stringTooLongException2) {
                stringTooLongException2.printStackTrace();
            }
        }
    }

    private int getWrappedHeight(String[] stringArray, FontMetrics fontMetrics, int n) {
        int n2 = fontMetrics.getMaxAscent();
        int n3 = fontMetrics.getMaxDescent();
        int n4 = n2 + n3;
        int n5 = n4 / 20;
        int n6 = (n4 += n5) * stringArray.length;
        return n6 + n * 2;
    }

    private String[] createStringArray(String string, FontMetrics fontMetrics, int n, int n2) {
        if (string == null) {
            System.err.println("Tried createStringArray with null String");
            return null;
        }
        if (fontMetrics == null) {
            System.err.println("Tried createStringArray with null FontMetrics");
        }
        int n3 = n2 - n * 2;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f", true);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuilder.append(string2);
            if (fontMetrics.stringWidth(stringBuilder.toString()) < n3 && stringBuilder.toString().charAt(stringBuilder.toString().length() - 1) != '\n' && stringBuilder.toString().charAt(stringBuilder.toString().length() - 1) != '\r') {
                stringBuilder2.append(string2);
                continue;
            }
            vector.addElement(stringBuilder2.toString());
            stringBuilder2.delete(0, stringBuilder2.length());
            stringBuilder.delete(0, stringBuilder.length());
            if (string2.charAt(0) == '\n' || string2.charAt(0) == '\r') continue;
            stringBuilder.append(string2);
            stringBuilder2.append(string2);
        }
        vector.addElement(stringBuilder2.toString());
        int n4 = vector.size();
        String[] stringArray = new String[n4];
        for (int i = 0; i < n4; ++i) {
            String string3;
            stringArray[i] = string3 = (String)vector.get(i);
        }
        return stringArray;
    }

    public BoundingBox subtract(BoundingBox boundingBox, int n) {
        int n22;
        if (boundingBox == null) {
            throw new IllegalArgumentException("BoundingBox.subtract, BoundingBox child is null");
        }
        if (!boundingBox.hasParent()) {
            throw new IllegalArgumentException("BoundingBox.subtract, BoundingBox child has no parent");
        }
        if (boundingBox.getParent() != this) {
            throw new IllegalArgumentException("BoundingBox.subtract, this is not BoundingBox child's parent");
        }
        int n3 = SUBTRACTS.length;
        boolean bl = false;
        for (int n22 : SUBTRACTS) {
            if (n != n22) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("BoundingBox.subtract, subtractFrom invalid: " + n);
        }
        boundingBox.setParent(null);
        int n4 = (int)boundingBox.getLocation().getX();
        int n5 = (int)boundingBox.getLocation().getY();
        int n6 = (int)boundingBox.getSize().getWidth();
        n22 = (int)boundingBox.getSize().getHeight();
        int n7 = (int)this.getLocation().getX();
        int n8 = (int)this.getLocation().getY();
        int n9 = (int)this.getSize().getWidth();
        int n10 = (int)this.getSize().getHeight();
        switch (n) {
            case 8: {
                n9 = n4;
                this.setSize(new Dimension(n9, n10));
                return this;
            }
            case 9: {
                n7 = n7 + n6 + n4;
                n9 = n9 - n6 - n4;
                this.setLocation(new Point(n7, n8));
                this.setSize(new Dimension(n9, n10));
                return this;
            }
            case 7: {
                n8 = n8 + n22 + n5;
                n10 = n10 - n22 - n5;
                this.setLocation(new Point(n7, n8));
                this.setSize(new Dimension(n9, n10));
                return this;
            }
            case 6: {
                n10 = n5;
                this.setSize(new Dimension(n9, n10));
                return this;
            }
        }
        return this;
    }

    public Point getDrawingPoint() {
        return this.drawingPoint;
    }

    public static void main(String[] stringArray) {
        Point point = new Point(5, 5);
        Dimension dimension = new Dimension(100, 100);
        BoundingBox boundingBox = new BoundingBox(point, dimension);
        String string = "Hello World!";
        Font font = new Font("SansSerif", 0, 12);
        Frame frame = new Frame();
        frame.addNotify();
        try {
            Image image = frame.createImage(100, 100);
            if (image == null) {
                System.err.println("image is null");
            }
            Graphics graphics = image.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            BoundingBox boundingBox2 = boundingBox.getStringBounds(string, 4, 1, fontMetrics, 5);
            System.out.println("Drawing Point: " + boundingBox2.getDrawingPoint().toString());
            System.out.println("Now testing subtract() method...");
            boundingBox = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            System.out.println("parent: " + boundingBox.toString());
            boundingBox2 = new BoundingBox(new Point(90, 110), new Dimension(100, 100));
            boundingBox.add(boundingBox2);
            System.out.println("child: " + boundingBox2.toString());
            System.out.println();
            System.out.println("subtracting the child from the parent");
            System.out.println("SUBTRACT_FROM_TOP: ");
            boundingBox = boundingBox.subtract(boundingBox2, 6);
            System.out.println("new parent: " + boundingBox.toString());
            System.out.println();
            System.out.println("Resetting parent");
            boundingBox = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            boundingBox.add(boundingBox2);
            System.out.println("SUBTRACT_FROM_BOTTOM");
            boundingBox.subtract(boundingBox2, 7);
            System.out.println("new parent: " + boundingBox.toString());
            System.out.println();
            System.out.println("Resetting parent");
            boundingBox = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            boundingBox.add(boundingBox2);
            System.out.println("SUBTRACT_FROM_LEFT");
            boundingBox.subtract(boundingBox2, 8);
            System.out.println("new parent: " + boundingBox.toString());
            System.out.println();
            System.out.println("Resetting parent");
            boundingBox = new BoundingBox(new Point(10, 10), new Dimension(300, 300));
            boundingBox.add(boundingBox2);
            System.out.println("SUBTRACT_FROM_RIGHT");
            boundingBox.subtract(boundingBox2, 9);
            System.out.println("new parent: " + boundingBox.toString());
            System.out.println();
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private BoundingBox(Point point, Dimension dimension, Point point2, Point point3) {
        super(point, dimension);
        this.drawingPoint = point2;
        this.absoluteLocation = point3;
    }

    private boolean checkHAlign(int n) {
        int n2 = HORIZ_ALIGNS.length;
        for (int n3 : HORIZ_ALIGNS) {
            if (n != n3) continue;
            return true;
        }
        return false;
    }

    private boolean checkVAlign(int n) {
        int n2 = VERT_ALIGNS.length;
        for (int n3 : VERT_ALIGNS) {
            if (n != n3) continue;
            return true;
        }
        return false;
    }
}

