--  Test for imported and exported entities.
--  Searching for all references to either end should limit the search to the
--  current language, not search in files from the other language.
--  But searching for the body should point to the other language.

-----------------
-- Entity defined in Ada, exported to C
-----------------

REFS ada_fromada:misc.adb
#  1> Ada_Fromada:a.adb:2:14 (body) scope=A:a.ads:1:9
#  2> Ada_Fromada:a.adb:5:8 (label on end line) scope=Ada_Fromada:a.ads:2:14
#  3> Ada_Fromada:a.ads:2:14 (declaration) scope=A:a.ads:1:9
#  4> Ada_Fromada:a.ads:3:22 (implicit reference) scope=A:a.ads:1:9
#  5> Ada_Fromada:misc.adb:4:6 (static call) scope=Misc:misc.adb:2:11

BODY ada_fromada:misc.adb
#  1> Ada_Fromada:a.adb:2:14 (body) scope=A:a.ads:1:9

DOC ada_fromada:misc.adb
#procedure declared at a.ads:2:14
#
#Mangled name: fromada
#

----------------
--  Entity defined in C, importing an entity from Ada
----------------

REFS fromada:utils.c
#  1> fromada:utils.c:2:13 (declaration)
#  2> fromada:utils.c:5:4 (static call) scope=fromc:utils.c:4:6

BODY fromada:utils.c
#  1> Ada_Fromada:a.adb:2:14 (body) scope=A:a.ads:1:9

DOC fromada:utils.c
#procedure declared at utils.c:2:13
#

----------------
--  Entity defined in Ada, importing an entity from C
----------------

REFS ada_fromc:misc.adb
#  1> Ada_Fromc:a.ads:5:14 (declaration) scope=A:a.ads:1:9
#  2> Ada_Fromc:a.ads:6:22 (body) scope=A:a.ads:1:9
#  3> Ada_Fromc:misc.adb:5:6 (static call) scope=Misc:misc.adb:2:11

BODY ada_fromc:misc.adb
#  1> Ada_Fromc:a.ads:6:22 (body) scope=A:a.ads:1:9
#  2> fromc:utils.c:4:6 (body)

DOC ada_fromc:misc.adb
#procedure declared at a.ads:5:14
#
#Mangled name: fromc
#

----------------
--  Entity defined in C, exported to Ada
----------------

REFS fromc:utils.c
#  1> fromc:utils.c:4:6 (body)
#  2> fromc:utils.c:4:6 (declaration)

BODY fromc:utils.c
#  1> fromc:utils.c:4:6 (body)

DOC fromc:utils.c
#procedure declared at utils.c:4:6
#

----------------
--  Entity defined in C++, exported to Ada
----------------

REFS fromcpp:utilspp.cpp:4:6
#  1> fromcpp:utilspp.cpp:4:6 (body)
#  2> fromcpp:utilspp.cpp:4:6 (declaration)
#  3> fromcpp:utilspp.cpp:4:6 (implicit reference)

BODY Ada_FromcppI:a.ads
#  1> Ada_FromcppI:a.ads:9:24 (body) scope=A:a.ads:1:9
#  2> fromcpp:utilspp.cpp:4:6 (body)

BODY Ada_FromcppF:a.ads
#  1> Ada_FromcppF:a.ads:12:24 (body) scope=A:a.ads:1:9
#  2> fromcpp:utilspp.cpp:7:6 (body)
