/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.event;

import alt.jiapi.InstrumentationDescriptor;
import alt.jiapi.event.CatchHook;
import alt.jiapi.event.EventProducer;
import alt.jiapi.event.ExceptionEvent;
import alt.jiapi.event.ExceptionListener;
import alt.jiapi.instrumentor.CatchInstrumentor;
import alt.jiapi.instrumentor.HeadInstrumentor;
import alt.jiapi.instrumentor.InstrumentorChain;
import alt.jiapi.instrumentor.MethodCallInstrumentor;
import alt.jiapi.instrumentor.MethodDispatcherInstrumentor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExceptionEventProducer
extends EventProducer {
    private List listeners = new ArrayList();

    public ExceptionEventProducer(InstrumentationDescriptor id) {
        this(id, "*");
    }

    public ExceptionEventProducer(InstrumentationDescriptor id, String resolution) {
        super(resolution);
        try {
            InstrumentorChain chain = new InstrumentorChain();
            MethodDispatcherInstrumentor dispatcher = new MethodDispatcherInstrumentor();
            CatchInstrumentor selectCatchBlocks = new CatchInstrumentor();
            HeadInstrumentor selectHead = new HeadInstrumentor();
            MethodCallInstrumentor callMethod = new MethodCallInstrumentor(new CatchHook(this));
            selectCatchBlocks.setResolutions(this.getResolutions());
            chain.add(dispatcher);
            chain.add(selectCatchBlocks);
            chain.add(selectHead);
            chain.add(callMethod);
            id.addInstrumentor(chain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void addExceptionListener(ExceptionListener fl) {
        this.listeners.add(fl);
    }

    public synchronized void removeExceptionListener(ExceptionListener fl) {
        this.listeners.remove(fl);
    }

    public void catchTrapped(Object sourceObject, String exceptionName) {
        this.catchTrapped(sourceObject, exceptionName, null);
    }

    public void catchTrapped(Object sourceObject, String exceptionName, Object target) {
        if (!this.isProtected(sourceObject)) {
            this.fireCatchEvent(sourceObject, exceptionName, target);
        }
    }

    protected synchronized void fireCatchEvent(Object sourceObject, String exceptionName, Object target) {
        Iterator i = this.listeners.iterator();
        ExceptionEvent event = new ExceptionEvent(this, sourceObject, exceptionName, target, 1);
        while (i.hasNext()) {
            ExceptionListener el = (ExceptionListener)i.next();
            el.exceptionCaught(event);
        }
    }
}

