/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfPCell;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openide.util.Utilities;

public abstract class iTextStyle {
    public Set<String> availableFonts;
    public List<BaseFont> baseFontList;
    public List<Font> fontList;

    public abstract Color getBackColor(boolean var1);

    public abstract String getFontType(boolean var1);

    public abstract float getFontSize(boolean var1);

    public abstract int getFontStyle(boolean var1);

    public abstract Color getFontColor(boolean var1);

    public abstract int getPadding(boolean var1);

    public abstract int getBorder(boolean var1);

    public List<Font> getFontList(boolean header) {
        this.fontList = new ArrayList<Font>();
        Font preferredFont = FontFactory.getFont((String)this.getFontType(header), (float)this.getFontSize(header), (int)this.getFontStyle(header), (Color)this.getFontColor(header));
        this.fontList.add(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            this.fontList.add(font);
        }
        return this.fontList;
    }

    public FontSelector getFontSelector(boolean header) {
        FontSelector fs = new FontSelector();
        Font preferredFont = FontFactory.getFont((String)this.getFontType(header), (float)this.getFontSize(header), (int)this.getFontStyle(header), (Color)this.getFontColor(header));
        fs.addFont(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            fs.addFont(font);
        }
        return fs;
    }

    public FontSelector getFontSelector(String fontType, float fontSize, int fontStyle, Color color) {
        FontSelector fs = new FontSelector();
        Font preferredFont = FontFactory.getFont((String)fontType, (float)fontSize, (int)fontStyle, (Color)color);
        fs.addFont(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, fontSize, fontStyle, color);
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            fs.addFont(font);
        }
        return fs;
    }

    public PdfPCell getCell(Object item, boolean header) {
        PdfPCell cell = null;
        if (item instanceof Image) {
            cell = new PdfPCell((Image)item);
        } else if (item instanceof Paragraph) {
            cell = new PdfPCell((Phrase)((Paragraph)item));
        } else if (item instanceof Element) {
            cell = new PdfPCell();
            cell.addElement((Element)item);
        } else {
            String text = item.toString();
            cell = this.getHebrewOrArabicCell(text, Character.UnicodeBlock.HEBREW);
            if (cell == null) {
                cell = this.getHebrewOrArabicCell(text, Character.UnicodeBlock.ARABIC);
            }
            if (cell == null) {
                FontSelector fs = this.getFontSelector(header);
                cell = new PdfPCell((Phrase)new Paragraph(fs.process(text)));
            }
        }
        cell.setBackgroundColor(this.getBackColor(header));
        cell.setPaddingBottom((float)this.getPadding(header));
        cell.setBorder(this.getBorder(header));
        return cell;
    }

    private PdfPCell getHebrewOrArabicCell(String text, Character.UnicodeBlock desiredUnicode) {
        if (this.textContainsDesiredUnicode(text, desiredUnicode)) {
            for (char character : text.toCharArray()) {
                if (Character.UnicodeBlock.of(character) != desiredUnicode) continue;
                Font desiredFont = null;
                for (Font font : this.getFontList(false)) {
                    if (!font.getBaseFont().charExists((int)character)) continue;
                    desiredFont = font;
                    if (Utilities.isMac() && Character.UnicodeBlock.ARABIC.equals(desiredUnicode) && !font.getFamilyname().toLowerCase().contains("arabic")) continue;
                    break;
                }
                if (desiredFont == null) continue;
                Phrase phrase = new Phrase(text, desiredFont);
                PdfPCell pdfPCell = new PdfPCell(phrase);
                if (Character.UnicodeBlock.HEBREW == desiredUnicode || Character.UnicodeBlock.ARABIC == desiredUnicode) {
                    pdfPCell.setRunDirection(3);
                }
                return pdfPCell;
            }
        }
        return null;
    }

    private boolean textContainsDesiredUnicode(String text, Character.UnicodeBlock desiredUnicode) {
        for (char character : text.toCharArray()) {
            if (Character.UnicodeBlock.of(character) != desiredUnicode) continue;
            return true;
        }
        return false;
    }
}

