/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard;

import com.paterva.maltego.licensing.ui.wizard.LicenseWebLinksPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LicenseModePanel
extends JPanel {
    private JRadioButton freeRadioButton;
    private LicenseWebLinksPanel licenseWebLinksPanel;
    private JRadioButton licensedRadioButton;
    private JTextArea licensedTextArea;
    private JRadioButton offlineRadioButton;
    private JTextArea offlineTextArea;
    private JRadioButton onlineRadioButton;
    private JTextArea onlineTextArea;

    public LicenseModePanel() {
        this.initComponents();
        Color bg = new JButton().getBackground().brighter();
        this.offlineTextArea.setBackground(bg);
        this.onlineTextArea.setBackground(bg);
        this.licensedTextArea.setBackground(bg);
        this.update();
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseWebLinksPanel.setLicenseKey(licenseKey);
    }

    public void setLicensed(boolean licensed) {
        if (licensed) {
            this.licensedRadioButton.setSelected(true);
        } else {
            this.freeRadioButton.setSelected(true);
        }
        this.update();
    }

    public boolean isLicensed() {
        return this.licensedRadioButton.isSelected();
    }

    public void setOnline(boolean online) {
        if (online) {
            this.onlineRadioButton.setSelected(true);
        } else {
            this.offlineRadioButton.setSelected(true);
        }
    }

    public boolean isOnline() {
        return this.onlineRadioButton.isSelected();
    }

    private void update() {
        boolean licensed = this.isLicensed();
        this.onlineRadioButton.setEnabled(!licensed);
        this.offlineRadioButton.setEnabled(!licensed);
    }

    private void initComponents() {
        ButtonGroup licensedButtonGroup = new ButtonGroup();
        ButtonGroup freeButtonGroup = new ButtonGroup();
        this.licenseWebLinksPanel = new LicenseWebLinksPanel();
        JLabel choiceLabel = new JLabel();
        this.licensedRadioButton = new JRadioButton();
        this.licensedTextArea = new JTextArea();
        this.freeRadioButton = new JRadioButton();
        this.offlineRadioButton = new JRadioButton();
        this.onlineRadioButton = new JRadioButton();
        this.offlineTextArea = new JTextArea();
        this.onlineTextArea = new JTextArea();
        JPanel dummyPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.licenseWebLinksPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)choiceLabel, (String)NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.choiceLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.add((Component)choiceLabel, gridBagConstraints);
        licensedButtonGroup.add(this.licensedRadioButton);
        this.licensedRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.licensedRadioButton, (String)NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.licensedRadioButton.text"));
        this.licensedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseModePanel.this.licensedRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.licensedRadioButton, gridBagConstraints);
        this.licensedTextArea.setEditable(false);
        this.licensedTextArea.setColumns(20);
        this.licensedTextArea.setLineWrap(true);
        this.licensedTextArea.setRows(3);
        this.licensedTextArea.setText(NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.licensedTextArea.text"));
        this.licensedTextArea.setWrapStyleWord(true);
        this.licensedTextArea.setMargin(new Insets(0, 4, 0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 68, 0, 6);
        this.add((Component)this.licensedTextArea, gridBagConstraints);
        licensedButtonGroup.add(this.freeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.freeRadioButton, (String)NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.freeRadioButton.text"));
        this.freeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseModePanel.this.freeRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.freeRadioButton, gridBagConstraints);
        freeButtonGroup.add(this.offlineRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.offlineRadioButton, (String)NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.offlineRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 40, 0, 6);
        this.add((Component)this.offlineRadioButton, gridBagConstraints);
        freeButtonGroup.add(this.onlineRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.onlineRadioButton, (String)NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.onlineRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 40, 0, 6);
        this.add((Component)this.onlineRadioButton, gridBagConstraints);
        this.offlineTextArea.setEditable(false);
        this.offlineTextArea.setColumns(20);
        this.offlineTextArea.setLineWrap(true);
        this.offlineTextArea.setRows(3);
        this.offlineTextArea.setText(NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.offlineTextArea.text"));
        this.offlineTextArea.setWrapStyleWord(true);
        this.offlineTextArea.setMargin(new Insets(0, 4, 0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 68, 0, 6);
        this.add((Component)this.offlineTextArea, gridBagConstraints);
        this.onlineTextArea.setEditable(false);
        this.onlineTextArea.setColumns(20);
        this.onlineTextArea.setLineWrap(true);
        this.onlineTextArea.setRows(3);
        this.onlineTextArea.setText(NbBundle.getMessage(LicenseModePanel.class, (String)"LicenseModePanel.onlineTextArea.text"));
        this.onlineTextArea.setWrapStyleWord(true);
        this.onlineTextArea.setMargin(new Insets(0, 4, 0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 68, 0, 6);
        this.add((Component)this.onlineTextArea, gridBagConstraints);
        GroupLayout dummyPanelLayout = new GroupLayout(dummyPanel);
        dummyPanel.setLayout(dummyPanelLayout);
        dummyPanelLayout.setHorizontalGroup(dummyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        dummyPanelLayout.setVerticalGroup(dummyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)dummyPanel, gridBagConstraints);
    }

    private void freeRadioButtonActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void licensedRadioButtonActionPerformed(ActionEvent evt) {
        this.update();
    }
}

