/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.SpecAction;
import com.paterva.maltego.entity.api.SpecActionDescriptor;
import com.paterva.maltego.entity.api.SpecActionRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class SpecActionMenuFactory {
    public JMenu createMenu(String name, Collection<MaltegoEntity> entities, EntityRegistry registry) {
        JMenu menu = null;
        List<Action> actions = this.getActions(registry, entities);
        if (!actions.isEmpty()) {
            menu = new JMenu(name);
            for (Action action : actions) {
                menu.add(action);
            }
        }
        return menu;
    }

    public JPopupMenu createPopupMenu(String name, List<MaltegoEntity> entities, EntityRegistry registry) {
        JPopupMenu menu = null;
        List<Action> actions = this.getActions(registry, entities);
        if (!actions.isEmpty()) {
            menu = new JPopupMenu(name);
            for (Action action : actions) {
                menu.add(action);
            }
        }
        return menu;
    }

    public List<Action> getActions(EntityRegistry registry, Collection<MaltegoEntity> entities) {
        List<SpecActionDescriptor> descriptors = this.getSortedActionDescriptors(registry, entities);
        ArrayList<Action> menuActions = new ArrayList<Action>(descriptors.size());
        for (SpecActionDescriptor descriptor : descriptors) {
            menuActions.add(new SpecActionMenuAction(registry, descriptor, entities));
        }
        return menuActions;
    }

    private List<SpecActionDescriptor> getSortedActionDescriptors(EntityRegistry registry, Collection<MaltegoEntity> entities) {
        Set<SpecActionDescriptor> actionDescriptors = this.getEnabledActionDescriptors(registry, entities);
        ArrayList<SpecActionDescriptor> descriptors = new ArrayList<SpecActionDescriptor>(actionDescriptors);
        Collections.sort(descriptors, new Comparator<SpecActionDescriptor>(){

            @Override
            public int compare(SpecActionDescriptor o1, SpecActionDescriptor o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return descriptors;
    }

    private Set<SpecActionDescriptor> getEnabledActionDescriptors(EntityRegistry registry, Collection<MaltegoEntity> entities) {
        HashSet<SpecActionDescriptor> actionDescriptors = new HashSet<SpecActionDescriptor>();
        for (MaltegoEntity entity : entities) {
            actionDescriptors.addAll(this.getSpecActions((SpecRegistry<? extends TypeSpec>)registry, entity).keySet());
        }
        return actionDescriptors;
    }

    private Map<SpecActionDescriptor, SpecAction> getSpecActions(SpecRegistry<? extends TypeSpec> specRegistry, MaltegoEntity entity) {
        SpecActionRegistry actionRegistry = SpecActionRegistry.getDefault();
        Collection actionDescriptors = InheritanceHelper.getAggregatedActions(specRegistry, (String)entity.getTypeName());
        HashMap<SpecActionDescriptor, SpecAction> actions = new HashMap<SpecActionDescriptor, SpecAction>();
        for (SpecActionDescriptor descriptor : actionDescriptors) {
            SpecAction action = actionRegistry.getAction(descriptor.getType());
            if (action == null || !action.isEnabledFor(specRegistry, (MaltegoPart)entity, descriptor.getConfig())) continue;
            actions.put(descriptor, action);
        }
        return actions;
    }

    private class SpecActionMenuAction
    extends AbstractAction {
        private final EntityRegistry _registry;
        private final SpecActionDescriptor _descriptor;
        private final Collection<MaltegoEntity> _entities;

        public SpecActionMenuAction(EntityRegistry registry, SpecActionDescriptor descriptor, Collection<MaltegoEntity> entities) {
            super(descriptor.getDisplayName());
            this._registry = registry;
            this._descriptor = descriptor;
            this._entities = entities;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            for (MaltegoEntity entity : this._entities) {
                SpecAction action = (SpecAction)SpecActionMenuFactory.this.getSpecActions((SpecRegistry<? extends TypeSpec>)((SpecRegistry)this._registry), entity).get(this._descriptor);
                if (action == null || !action.isEnabledFor((SpecRegistry)this._registry, (MaltegoPart)entity, this._descriptor.getConfig())) continue;
                action.perform((SpecRegistry)this._registry, (MaltegoPart)entity, this._descriptor.getConfig());
            }
        }
    }
}

