/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.archive.mtz.MtzVersion;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.ClipboardGraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphCopyHelper;
import com.paterva.maltego.ui.graph.actions.CookieAction;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.clipboard.GraphDataFlavor;
import com.paterva.maltego.ui.graph.clipboard.GraphML;
import com.paterva.maltego.ui.graph.clipboard.GraphMLConverter;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainterAnimatorRegistry;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public abstract class AbstractGraphMLPasteAction
extends CookieAction<GraphCookie> {
    public AbstractGraphMLPasteAction() {
        super(GraphCookie.class);
    }

    protected abstract void prePasteGraph(GraphID var1, GraphID var2);

    protected abstract void postPasteGraph(GraphID var1, GraphID var2);

    @Override
    protected void performAction(GraphCookie cookie) {
        MainEntityPainterAnimatorRegistry.allowModifications = false;
        GraphID graphID = cookie.getGraphID();
        this.perform(graphID);
        MainEntityPainterAnimatorRegistry.allowModifications = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(GraphID targetGraphID) {
        GraphStore graphStore = null;
        try {
            WindowUtil.showWaitCursor();
            graphStore = GraphStoreRegistry.getDefault().forGraphID(targetGraphID);
            graphStore.beginUpdate();
            Transferable t = this.getTransferable();
            GraphStore clipboardGraphStore = null;
            GraphID graphToPasteID = null;
            if (t.isDataFlavorSupported(GraphDataFlavor.FLAVOR)) {
                InputStream is = (InputStream)t.getTransferData(GraphDataFlavor.FLAVOR);
                String graphVersion = StringUtilities.toString((InputStream)is, (Charset)StandardCharsets.UTF_8).trim();
                if (!MtzVersion.isGraphVersionSupported((String)graphVersion)) {
                    String msg = "The version of the pasted graph (" + graphVersion + ") is not yet supported in this Maltego client. Please update your client.";
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                } else {
                    GraphID clipboardGraphID = ClipboardGraphID.get();
                    clipboardGraphStore = GraphStoreRegistry.getDefault().forGraphID(clipboardGraphID);
                    clipboardGraphStore.open();
                    graphToPasteID = clipboardGraphID;
                }
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                GraphML graphML = GraphMLConverter.convert(text);
                graphToPasteID = GraphMLConverter.convert(targetGraphID, graphML);
            } else {
                return;
            }
            if (graphToPasteID != null) {
                this.perform(targetGraphID, graphToPasteID);
                if (clipboardGraphStore != null) {
                    clipboardGraphStore.close(false);
                }
                SwingUtilities.invokeLater(() -> ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).actionPerformed((ActionEvent)null));
            }
        }
        catch (UnsupportedFlavorException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Failed to create entities from text.\n" + ex.getMessage()), 0);
            msg.setTitle("Paste Error");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate(null);
            }
            WindowUtil.hideWaitCursor();
        }
    }

    public void perform(GraphID targetGraphID, GraphID graphToPasteID) {
        block7: {
            int pasteLimit = A.A();
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphToPasteID);
                GraphStructureStore structureStore = graphStore.getGraphStructureStore();
                GraphStructureReader structureReader = structureStore.getStructureReader();
                int entityCount = structureReader.getEntityCount();
                if (entityCount <= pasteLimit) break block7;
                String msg = "Only " + pasteLimit + " entities can be pasted on this Maltego Plan.\n\nPlease consider upgrading to unlock more features.\n\nIf you continure, only " + pasteLimit + " entities will be pasted.";
                NotifyDescriptor.Confirmation conf = new NotifyDescriptor.Confirmation((Object)msg, "Paste Limit Reached", 2);
                String upgradeOption = "Upgrade";
                String continueOption = "Continue";
                String cancelOption = "Cancel";
                Object[] options = new String[]{upgradeOption, continueOption, cancelOption};
                conf.setOptions(options);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)conf);
                if (upgradeOption.equals(result)) {
                    BrowseToUrl.upgradePlan(null);
                    ProductSelectionAction.perform();
                    return;
                }
                if (continueOption.equals(result)) {
                    Set entities = structureReader.getEntities();
                    int removeCount = entityCount - pasteLimit;
                    HashSet<EntityID> toRemove = new HashSet<EntityID>(removeCount);
                    for (EntityID entity : entities) {
                        toRemove.add(entity);
                        if (toRemove.size() != removeCount) continue;
                        break;
                    }
                    GraphStoreWriter.removeEntities((GraphID)graphToPasteID, toRemove);
                    break block7;
                }
                return;
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        try {
            this.prePasteGraph(targetGraphID, graphToPasteID);
            this.pasteGraph(targetGraphID, graphToPasteID);
            this.postPasteGraph(targetGraphID, graphToPasteID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void pasteGraph(GraphID targetGraphID, GraphID graphToPasteID) throws GraphStoreException {
        GraphCopyHelper.copy(graphToPasteID, targetGraphID);
    }

    private Transferable getTransferable() {
        Clipboard c = this.getClipboard();
        if (c != null) {
            return c.getContents(this);
        }
        return null;
    }

    private Clipboard getClipboard() {
        return (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

