/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.SchemaPropertyCollector;
import com.pinkmatter.pandora.lucene.serialize.ComplexTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

class SchemaProperty
extends SchemaPropertyCollector {
    private final String _name;
    private final String _prefix;
    private final LinkedHashSet<String> _fields;
    private final TypeConverter _converter;

    public SchemaProperty(String name, TypeConverter converter) {
        this(name, "", converter);
    }

    public SchemaProperty(String name, String prefix, TypeConverter converter) {
        this._name = name;
        this._prefix = prefix;
        this._converter = converter;
        this._fields = new LinkedHashSet();
    }

    @Override
    public void collect(String field) throws PandoraException {
        this._fields.add(field);
        if (this._converter instanceof ComplexTypeConverter) {
            String newPrefix = ((ComplexTypeConverter)this._converter).getParentField(field, this._prefix);
            this.collect(field, newPrefix);
        }
    }

    @Override
    public Set<String> getFields() {
        return this._fields;
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._prefix + this._name;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public TypeConverter getConverter() {
        return this._converter;
    }

    public Class getType() {
        return this._converter.getClassType();
    }

    @Override
    public boolean canReadChildren() {
        if (this._converter instanceof ComplexTypeConverter) {
            return ((ComplexTypeConverter)this._converter).canReadChildSubset();
        }
        return false;
    }

    public String toString() {
        return "SchemaProperty{name=" + this._name + ", prefix=" + this._prefix + ", converter=" + this._converter + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this._name);
        hash = 43 * hash + Objects.hashCode(this._prefix);
        hash = 43 * hash + Objects.hashCode(this._converter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaProperty other = (SchemaProperty)obj;
        if (!Objects.equals(this._name, other._name)) {
            return false;
        }
        if (!Objects.equals(this._prefix, other._prefix)) {
            return false;
        }
        return Objects.equals(this._converter, other._converter);
    }
}

