/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.binding;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.EntitySectionsQuery;
import com.paterva.maltego.graph.store.query.part.PartSectionsQuery;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.treelist.lazy.LazyTreelistSettings;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.openide.util.Exceptions;

public class TestResult {
    private final GraphID _graphID;
    private final EntityID _entityID;
    private final Object _result;

    public TestResult(GraphID graphID, EntityID entityID, Object result) {
        this._graphID = graphID;
        this._entityID = entityID;
        this._result = result;
    }

    public Icon getImage() {
        Icon icon = null;
        try {
            int modelEntityCount = this.getModelEntities().size();
            if (modelEntityCount == 1) {
                icon = EntityImageFactory.forGraph((GraphID)this._graphID).getSmallTypeIcon(this.getTypeName());
            } else {
                int iconSize = LazyTreelistSettings.getDefault().getIconSize()[1];
                int iconWidth = LazyTreelistSettings.getDefault().getIconWidth(false, modelEntityCount);
                icon = GraphicsUtils.getCollectedIcon((int)iconWidth, (int)iconSize, (int)modelEntityCount, (boolean)false, (boolean)false);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return icon;
    }

    public String getDisplayName() {
        String displayName = "Collection";
        try {
            Set<EntityID> modelEntities = this.getModelEntities();
            if (modelEntities.size() == 1) {
                EntityID entityID = modelEntities.iterator().next();
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                EntityDataQuery entityDataQuery = new EntityDataQuery();
                entityDataQuery.setAllProperties(false);
                entityDataQuery.setPropertyNames(Collections.EMPTY_SET);
                entityDataQuery.setAllSections(false);
                EntitySectionsQuery entitySectionsQuery = new EntitySectionsQuery();
                entitySectionsQuery.setQueryCachedDisplayStr(true);
                entityDataQuery.setSections((PartSectionsQuery)entitySectionsQuery);
                MaltegoEntity entity = dataReader.getEntity(entityID, entityDataQuery);
                displayName = entity.getDisplayString();
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return displayName;
    }

    public String getTypeName() {
        String typeName = null;
        try {
            Set<EntityID> modelEntities = this.getModelEntities();
            EntityID entity = modelEntities.iterator().next();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            typeName = dataReader.getEntityType(entity);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return typeName;
    }

    public Object getResult() {
        return this._result;
    }

    public String getResultText() {
        Object result = this.getResult();
        if (result instanceof Exception) {
            Exception ex = (Exception)result;
            String msg = ex.getMessage();
            msg = msg.replaceFirst("^.*EcmaError:", "");
            msg = msg.replaceFirst("^.*Exception:", "");
            msg = msg.replaceFirst("\\s*(\\.\\s*)?\\(<Unknown source>#\\d+\\) in <Unknown source>\\s*", " ");
            result = msg.trim();
        }
        return String.valueOf(result);
    }

    private Set<EntityID> getModelEntities() throws GraphStoreException {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this._graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        Set modelEntities = mappings.getModelEntities(this._entityID);
        return modelEntities;
    }
}

