/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageContainer;
import com.paterva.maltego.imgfactory.impl.ImageID;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ImageMemoryCache
implements ImageContainer {
    private final HashMap<ImageID, ImageData> _cache = new HashMap();

    @Override
    public boolean contains(ImageID imageId) {
        return this._cache.containsKey(imageId);
    }

    @Override
    public Image get(ImageID imageId) {
        ImageData imageData = this._cache.get(imageId);
        imageData.accessTime = new Date();
        return imageData.image;
    }

    @Override
    public void put(ImageID imageId, Image image) {
        ImageData imageData = new ImageData(image, new Date());
        this._cache.put(imageId, imageData);
    }

    @Override
    public void remove(ImageID imageId, boolean allSizes) {
        if (!allSizes) {
            this._cache.remove(imageId);
        } else {
            Iterator<Map.Entry<ImageID, ImageData>> it = this._cache.entrySet().iterator();
            while (it.hasNext()) {
                if (!it.next().getKey().Key.equals(imageId.Key)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void clear() {
        this._cache.clear();
    }

    @Override
    public int size() {
        return this._cache.size();
    }

    public ImageID getOldest() {
        Date oldestDate = null;
        ImageID oldestID = null;
        for (Map.Entry<ImageID, ImageData> entry : this._cache.entrySet()) {
            ImageData imageData = entry.getValue();
            if (oldestDate != null && !imageData.accessTime.before(oldestDate)) continue;
            oldestDate = imageData.accessTime;
            oldestID = entry.getKey();
        }
        return oldestID;
    }

    public void removeOlderThan(Date time, ArrayList<ImageID> outImageIds, ArrayList<Image> outImages) {
        Iterator<ImageID> itr = this._cache.keySet().iterator();
        while (itr.hasNext()) {
            ImageID imageId = itr.next();
            ImageData imageData = this._cache.get(imageId);
            if (!imageData.accessTime.before(time)) continue;
            itr.remove();
            outImageIds.add(imageId);
            outImages.add(imageData.image);
        }
    }

    public String getStatus() {
        long size = 0L;
        int buffered = 0;
        for (Map.Entry<ImageID, ImageData> entry : this._cache.entrySet()) {
            Image image = entry.getValue().image;
            if (!(image instanceof BufferedImage)) continue;
            BufferedImage bImg = (BufferedImage)image;
            ++buffered;
            size += (long)bImg.getData().getDataBuffer().getSize();
        }
        StringBuilder sb = new StringBuilder("Memory Cache\n");
        sb.append("   Images = ");
        sb.append(this._cache.size());
        sb.append(" (");
        sb.append(buffered);
        sb.append(")\n");
        sb.append("   Buffered size = ");
        sb.append(size);
        sb.append("B = ");
        sb.append(size / 1024L);
        sb.append("KB = ");
        sb.append(size / 1024L / 1024L);
        sb.append("MB");
        sb.append("\n");
        return sb.toString();
    }

    private class ImageData {
        Image image;
        Date accessTime;

        public ImageData(Image image, Date accessTime) {
            this.image = image;
            this.accessTime = accessTime;
        }
    }
}

