/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.policy.PasswordPolicyConfigException;
import org.keycloak.policy.PasswordPolicyProvider;

public class PasswordPolicy
implements Serializable {
    public static final String HASH_ALGORITHM_ID = "hashAlgorithm";
    public static final String HASH_ITERATIONS_ID = "hashIterations";
    public static final String PASSWORD_HISTORY_ID = "passwordHistory";
    public static final String FORCE_EXPIRED_ID = "forceExpiredPasswordChange";
    public static final int RECOVERY_CODES_WARNING_THRESHOLD_DEFAULT = 4;
    public static final String RECOVERY_CODES_WARNING_THRESHOLD_ID = "recoveryCodesWarningThreshold";
    public static final String MAX_AUTH_AGE_ID = "maxAuthAge";
    private Map<String, Object> policyConfig;
    private Builder builder;

    public static PasswordPolicy empty() {
        return new PasswordPolicy(null, new HashMap<String, Object>());
    }

    public static Builder build() {
        return new Builder();
    }

    public static PasswordPolicy parse(KeycloakSession session, String policyString) {
        return new Builder(policyString).build(session);
    }

    private PasswordPolicy(Builder builder, Map<String, Object> policyConfig) {
        this.builder = builder;
        this.policyConfig = policyConfig;
    }

    public Set<String> getPolicies() {
        return this.policyConfig.keySet();
    }

    public <T> T getPolicyConfig(String key) {
        return (T)this.policyConfig.get(key);
    }

    public String getHashAlgorithm() {
        if (this.policyConfig.containsKey(HASH_ALGORITHM_ID)) {
            return (String)this.getPolicyConfig(HASH_ALGORITHM_ID);
        }
        return null;
    }

    public int getHashIterations() {
        if (this.policyConfig.containsKey(HASH_ITERATIONS_ID)) {
            return (Integer)this.getPolicyConfig(HASH_ITERATIONS_ID);
        }
        return -1;
    }

    public int getExpiredPasswords() {
        if (this.policyConfig.containsKey(PASSWORD_HISTORY_ID)) {
            return (Integer)this.getPolicyConfig(PASSWORD_HISTORY_ID);
        }
        return -1;
    }

    public int getDaysToExpirePassword() {
        if (this.policyConfig.containsKey(FORCE_EXPIRED_ID)) {
            return (Integer)this.getPolicyConfig(FORCE_EXPIRED_ID);
        }
        return -1;
    }

    public int getRecoveryCodesWarningThreshold() {
        if (this.policyConfig.containsKey(RECOVERY_CODES_WARNING_THRESHOLD_ID)) {
            return (Integer)this.getPolicyConfig(RECOVERY_CODES_WARNING_THRESHOLD_ID);
        }
        return 4;
    }

    public int getMaxAuthAge() {
        if (this.policyConfig.containsKey(MAX_AUTH_AGE_ID)) {
            return (Integer)this.getPolicyConfig(MAX_AUTH_AGE_ID);
        }
        return -1;
    }

    public String toString() {
        return this.builder.asString();
    }

    public Builder toBuilder() {
        return this.builder.clone();
    }

    public static class Builder {
        private LinkedHashMap<String, String> map;

        private Builder() {
            this.map = new LinkedHashMap();
        }

        private Builder(LinkedHashMap<String, String> map) {
            this.map = map;
        }

        private Builder(String policyString) {
            this.map = new LinkedHashMap();
            if (policyString != null && !policyString.trim().isEmpty()) {
                for (String policy : policyString.split(" and ")) {
                    String key;
                    policy = policy.trim();
                    String config = null;
                    int i = policy.indexOf(40);
                    if (i == -1) {
                        key = policy.trim();
                    } else {
                        key = policy.substring(0, i).trim();
                        config = policy.substring(i + 1, policy.length() - 1);
                    }
                    this.map.put(key, config);
                }
            }
        }

        public boolean contains(String key) {
            return this.map.containsKey(key);
        }

        public String get(String key) {
            return this.map.get(key);
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder remove(String key) {
            this.map.remove(key);
            return this;
        }

        public PasswordPolicy build(KeycloakSession session) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            for (Map.Entry<String, String> e : this.map.entrySet()) {
                Object o;
                PasswordPolicyProvider provider = session.getProvider(PasswordPolicyProvider.class, e.getKey());
                if (provider == null) {
                    throw new PasswordPolicyConfigException("Password policy not found");
                }
                try {
                    o = provider.parseConfig(e.getValue());
                }
                catch (PasswordPolicyConfigException ex) {
                    throw new ModelException("Invalid config for " + e.getKey() + ": " + ex.getMessage());
                }
                config.put(e.getKey(), o);
            }
            return new PasswordPolicy(this, config);
        }

        public String asString() {
            if (this.map.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> e : this.map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" and ");
                }
                sb.append(e.getKey());
                String c = e.getValue();
                if (c == null || c.trim().isEmpty()) continue;
                sb.append("(");
                sb.append(c);
                sb.append(")");
            }
            return sb.toString();
        }

        public Builder clone() {
            return new Builder((LinkedHashMap)this.map.clone());
        }
    }
}

