/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.imprt.wizard;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ui.dialog.FileController;
import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ImageUtilities;

class TabularImportFileController
extends FileController {
    public static final FileNameExtensionFilter CSV_EXT_FILTER = new FileNameExtensionFilter("Comma Seperated Values", "csv");
    public static final FileNameExtensionFilter EXCEL_EXT_FILTER = new FileNameExtensionFilter("Excel Spread Sheet", "xls", "xlsx");
    private final JCheckBox importLinkFiles = new JCheckBox();

    public TabularImportFileController() {
        super(0, null, null);
        this.setName("Select File");
        this.setDescription("Choose the grouped/flat entity property table to import from your file system.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/graph/table/ui/resources/TableRecycle.png".replace(".png", "48.png")));
        this.setBackgroundColor(new JPanel().getBackground());
    }

    public void readSettings(WizardDescriptor settings) {
        super.readSettings(settings);
        this.populateFileTypes(settings);
    }

    private void populateFileTypes(WizardDescriptor settings) {
        JFileChooser fileChooser = (JFileChooser)this.component();
        fileChooser.resetChoosableFileFilters();
        fileChooser.setAcceptAllFileFilterUsed(false);
        ArrayList<String> extensions = new ArrayList<String>();
        fileChooser.addChoosableFileFilter(CSV_EXT_FILTER);
        extensions.addAll(Arrays.asList(CSV_EXT_FILTER.getExtensions()));
        fileChooser.addChoosableFileFilter(EXCEL_EXT_FILTER);
        extensions.addAll(Arrays.asList(EXCEL_EXT_FILTER.getExtensions()));
        this.setFileExtensions(extensions.toArray(new String[extensions.size()]));
        fileChooser.setFileFilter(CSV_EXT_FILTER);
        fileChooser.setMultiSelectionEnabled(false);
        Boolean importLinks = (Boolean)settings.getProperty("importLinkFiles");
        this.importLinkFiles.setSelected(importLinks == null ? true : importLinks);
        FileChooserUtil.addAdditionalFieldsToChooser((JFileChooser)fileChooser, (String[])new String[]{"Import associated links file:"}, (JComponent[])new JComponent[]{this.importLinkFiles});
    }

    public void storeSettings(WizardDescriptor settings) {
        super.storeSettings(settings);
        settings.putProperty("importLinkFiles", (Object)this.importLinkFiles.isSelected());
    }

    public void validate() throws WizardValidationException {
        File[] files = this.getSelectedFiles();
        if (files == null || files.length == 0) {
            files = new File[]{this.getSelectedFile()};
        }
        String error = null;
        for (File file2 : files) {
            if (file2 == null || file2.isDirectory()) {
                error = "Please choose a file name. " + (file2 == null ? "" : file2.getName() + " is a directory.");
            } else if (file2.exists() && !file2.canRead()) {
                error = "The selected file " + file2.getName() + " is not readable";
            }
            if (error == null) continue;
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
        List<File> fileList = Arrays.stream(files).filter(file -> file != null && file.isFile()).collect(Collectors.toList());
        if (fileList.isEmpty()) {
            error = "No importer found for the selected file(s)";
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
        if (this.importLinkFiles.isSelected()) {
            ArrayList<File> extraLinkFiles = new ArrayList<File>();
            for (File file2 : fileList) {
                File linkFile;
                String name;
                if (file2 == null || (name = file2.getName()) == null) continue;
                String ext = FileUtilities.getFileExtension((File)file2);
                String nameWithoutExt = name.replace("." + ext, "");
                if (TabularImportFileController.isLinkFile(nameWithoutExt) || !(linkFile = TabularImportFileController.getLinkFile(file2, nameWithoutExt, ext)).isFile() || fileList.contains(linkFile)) continue;
                extraLinkFiles.add(linkFile);
            }
            fileList.addAll(extraLinkFiles);
        }
        try {
            List<List<File>> entityLinkPairs = TabularImportFileController.groupIntoEntityLinkPairs(fileList);
            this.getDescriptor().putProperty("importTableFiles", entityLinkPairs);
        }
        catch (Exception e) {
            throw new WizardValidationException((JComponent)this.component(), e.getMessage(), e.getMessage());
        }
    }

    private static List<List<File>> groupIntoEntityLinkPairs(List<File> fileList) {
        HashMap<File, File> entityLinkMap = new HashMap<File, File>();
        for (File file : fileList) {
            String name;
            if (file == null || (name = file.getName()) == null) continue;
            String ext = FileUtilities.getFileExtension((File)file);
            String nameWithoutExt = name.replace("." + ext, "");
            if (TabularImportFileController.isLinkFile(nameWithoutExt)) continue;
            File linkFile = TabularImportFileController.getLinkFile(file, nameWithoutExt, ext);
            if (fileList.contains(linkFile)) {
                entityLinkMap.put(file, linkFile);
                continue;
            }
            entityLinkMap.put(file, null);
        }
        ArrayList<List<File>> entityLinkPairs = new ArrayList<List<File>>();
        for (Map.Entry entry : entityLinkMap.entrySet()) {
            ArrayList<Object> pair = new ArrayList<Object>();
            pair.add(entry.getKey());
            File link = (File)entry.getValue();
            if (link != null) {
                pair.add(link);
            }
            entityLinkPairs.add(pair);
        }
        return entityLinkPairs;
    }

    private static File getLinkFile(File entityFile, String entityNameWithoutExt, String ext) {
        return new File(entityFile.getParent(), entityNameWithoutExt + "_links" + "." + ext);
    }

    private static boolean isLinkFile(String nameWithoutExt) {
        return nameWithoutExt.endsWith("_links");
    }
}

