/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;

public abstract class ByteValueProfile
extends Profile {
    ByteValueProfile() {
    }

    public abstract byte profile(byte var1);

    public static ByteValueProfile createIdentityProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create();
        }
        return Disabled.INSTANCE;
    }

    public static ByteValueProfile getUncached() {
        return Disabled.INSTANCE;
    }

    static final class Disabled
    extends ByteValueProfile {
        static final ByteValueProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public byte profile(byte value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(ByteValueProfile.class);
        }
    }

    static final class Enabled
    extends ByteValueProfile {
        private static final byte UNINITIALIZED = 0;
        private static final byte SPECIALIZED = 1;
        private static final byte GENERIC = 2;
        @CompilerDirectives.CompilationFinal
        private byte cachedValue;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;

        Enabled() {
        }

        @Override
        public byte profile(byte value) {
            byte localState = this.state;
            if (localState != 2) {
                byte v;
                if (localState == 1 && (v = this.cachedValue) == value) {
                    return v;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0) {
                    this.cachedValue = value;
                    this.state = 1;
                } else {
                    this.state = (byte)2;
                }
            }
            return value;
        }

        boolean isGeneric() {
            return this.state == 2;
        }

        boolean isUninitialized() {
            return this.state == 0;
        }

        byte getCachedValue() {
            return this.cachedValue;
        }

        @Override
        public void disable() {
            this.state = (byte)2;
        }

        @Override
        public void reset() {
            this.state = 0;
        }

        public String toString() {
            return this.toString(ByteValueProfile.class, this.state == 0, this.state == 2, String.format("value == (byte)%s", this.cachedValue));
        }

        static ByteValueProfile create() {
            return new Enabled();
        }
    }
}

