/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.memory;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.AbstractBatchUpdatable;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InMemoryGraphStructureStore
extends AbstractBatchUpdatable<Boolean>
implements GraphStructureStore,
GraphStructureReader,
GraphStructureWriter {
    private static final Logger LOG = Logger.getLogger(InMemoryGraphStructureStore.class.getName());
    private final GraphID _graphID;
    private final boolean IS_CHECK_MODS = true;
    private final Map<EntityID, EntityInfo> _entities = new HashMap<EntityID, EntityInfo>();
    private final Map<LinkID, LinkEntityIDs> _links = new HashMap<LinkID, LinkEntityIDs>();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private GraphStructureMods _eventMods;

    public InMemoryGraphStructureStore(GraphID graphID) {
        this._graphID = graphID;
    }

    public GraphID getGraphID() {
        return this._graphID;
    }

    public GraphStructureReader getStructureReader() {
        return this;
    }

    public GraphStructureWriter getStructureWriter() {
        return this;
    }

    public void endUpdate(Boolean layout) {
        if (layout != null && this._eventMods != null) {
            this._eventMods.setLayoutNew(layout.booleanValue());
        }
        super.endUpdate((Object)layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<EntityID> entityIDs) {
        this.beginUpdate();
        try {
            for (EntityID entityID : entityIDs) {
                this.add(entityID);
            }
        }
        finally {
            this.endUpdate(null);
        }
    }

    public void add(EntityID entityID) {
        this.beginUpdate();
        try {
            if (this.exists(entityID)) {
                throw new IllegalArgumentException("Entity already exists: " + entityID);
            }
            this._entities.put(entityID, null);
            GraphStructureMods event = this.getEventMods();
            if (!event.getEntitiesRemoved().remove(entityID)) {
                event.getEntitiesAdded().add(entityID);
            }
        }
        finally {
            this.endUpdate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map<LinkID, LinkEntityIDs> linkIDs) {
        this.beginUpdate();
        try {
            for (Map.Entry<LinkID, LinkEntityIDs> entry : linkIDs.entrySet()) {
                LinkID linkID = entry.getKey();
                LinkEntityIDs entityIDs = entry.getValue();
                this.connect(linkID, entityIDs.getSourceID(), entityIDs.getTargetID());
            }
        }
        finally {
            this.endUpdate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(LinkID linkID, LinkEntityIDs entityIDs) {
        this.beginUpdate();
        try {
            if (this.exists(linkID)) {
                throw new IllegalArgumentException("Link already exists: " + linkID);
            }
            EntityID sourceID = entityIDs.getSourceID();
            if (!this.exists(sourceID)) {
                throw new IllegalArgumentException("Unable to add link " + linkID + ", source entity does not exist: " + sourceID);
            }
            EntityID targetID = entityIDs.getTargetID();
            if (!this.exists(targetID)) {
                throw new IllegalArgumentException("Unable to add link " + linkID + ", target entity does not exist: " + targetID);
            }
            this.addLinkToSource(sourceID, linkID);
            this.addLinkToTarget(targetID, linkID);
            this._links.put(linkID, entityIDs);
            GraphStructureMods event = this.getEventMods();
            if (event.getLinksRemoved().remove(linkID) == null) {
                event.getLinksAdded().add(linkID);
            }
        }
        finally {
            this.endUpdate(null);
        }
    }

    public void connect(LinkID linkID, EntityID sourceID, EntityID targetID) {
        this.connect(linkID, new LinkEntityIDs(sourceID, targetID));
    }

    private void addLinkToSource(EntityID sourceID, LinkID linkID) throws IllegalArgumentException {
        EntityInfo sourceLinks = this._entities.get(sourceID);
        if (sourceLinks == null) {
            sourceLinks = new EntityInfo();
            this._entities.put(sourceID, sourceLinks);
        }
        if (sourceLinks.out == null) {
            sourceLinks.out = new HashSet<LinkID>(1);
        } else if (sourceLinks.out.contains(linkID)) {
            throw new IllegalArgumentException("Unable to add link " + linkID + ", source entity already associated: " + sourceID);
        }
        sourceLinks.out.add(linkID);
    }

    private void addLinkToTarget(EntityID targetID, LinkID linkID) throws IllegalArgumentException {
        EntityInfo targetLinks = this._entities.get(targetID);
        if (targetLinks == null) {
            targetLinks = new EntityInfo();
            this._entities.put(targetID, targetLinks);
        }
        if (targetLinks.in == null) {
            targetLinks.in = new HashSet<LinkID>(1);
        } else if (targetLinks.in.contains(linkID)) {
            throw new IllegalArgumentException("Unable to add link " + linkID + ", target entity already associated: " + targetID);
        }
        targetLinks.in.add(linkID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LinkID> removeEntities(Collection<EntityID> entityIDs) {
        this.beginUpdate();
        HashSet<LinkID> removedLinks = new HashSet<LinkID>();
        try {
            for (EntityID entityID : entityIDs) {
                Set<LinkID> links = this.removeEntity(entityID);
                removedLinks.addAll(links);
            }
        }
        finally {
            this.endUpdate();
        }
        return removedLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<LinkID> removeEntity(EntityID entityID) {
        this.beginUpdate();
        HashSet<LinkID> removedLinks = new HashSet<LinkID>();
        try {
            if (!this.exists(entityID)) {
                throw new IllegalArgumentException("Entity does not exist: " + entityID);
            }
            EntityInfo links = this._entities.get(entityID);
            if (links != null) {
                if (links.in != null) {
                    removedLinks.addAll(links.in);
                    this.removeLinks(links.in, true);
                }
                if (links.out != null) {
                    removedLinks.addAll(links.out);
                    this.removeLinks(links.out, true);
                }
            }
            this._entities.remove(entityID);
            GraphStructureMods event = this.getEventMods();
            if (!event.getEntitiesAdded().remove(entityID)) {
                event.getEntitiesRemoved().add(entityID);
            }
        }
        finally {
            this.endUpdate();
        }
        return removedLinks;
    }

    public void removeLinks(Collection<LinkID> linkIDs) {
        this.beginUpdate();
        try {
            this.removeLinks(linkIDs, true);
        }
        finally {
            this.endUpdate(null);
        }
    }

    private void removeLinks(Collection<LinkID> linkIDs, boolean removeFromEntities) {
        HashSet<LinkID> copyOfIDs = new HashSet<LinkID>(linkIDs);
        for (LinkID linkID : copyOfIDs) {
            this.removeLink(linkID, removeFromEntities);
        }
    }

    private void removeLink(LinkID linkID, boolean removeFromEntities) {
        GraphStructureMods event;
        if (!this.exists(linkID)) {
            throw new IllegalArgumentException("Link does not exist: " + linkID);
        }
        LinkEntityIDs entities = this._links.remove(linkID);
        if (removeFromEntities) {
            this.removeFromSource(entities.getSourceID(), linkID);
            this.removeFromTarget(entities.getTargetID(), linkID);
        }
        if (!(event = this.getEventMods()).getLinksAdded().remove(linkID)) {
            event.getLinksRemoved().put(linkID, entities);
        }
    }

    private void removeFromSource(EntityID sourceID, LinkID linkID) throws IllegalArgumentException {
        EntityInfo links = this._entities.get(sourceID);
        if (links == null) {
            throw new IllegalArgumentException("Source entity " + sourceID + " does not exist for link " + linkID);
        }
        if (links.out == null || !links.out.contains(linkID)) {
            throw new IllegalArgumentException("Source entity " + sourceID + " does not have outgoing link " + linkID);
        }
        links.out.remove(linkID);
    }

    private void removeFromTarget(EntityID targetID, LinkID linkID) throws IllegalArgumentException {
        EntityInfo links = this._entities.get(targetID);
        if (links == null) {
            throw new IllegalArgumentException("Target entity " + targetID + " does not exist for link " + linkID);
        }
        if (links.in == null || !links.in.contains(linkID)) {
            throw new IllegalArgumentException("Target entity " + targetID + " does not have incoming link " + linkID);
        }
        links.in.remove(linkID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection<EntityID> entityIDs, Collection<LinkID> linkIDs) {
        this.beginUpdate();
        try {
            for (LinkID linkID : linkIDs) {
                this.removeLink(linkID, true);
            }
            for (EntityID entityID : entityIDs) {
                this.removeEntity(entityID);
            }
        }
        finally {
            this.endUpdate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            GraphStructureMods event = this.getEventMods();
            Set entitiesRemoved = event.getEntitiesRemoved();
            entitiesRemoved.addAll(this._entities.keySet());
            Set entitiesAdded = event.getEntitiesAdded();
            entitiesRemoved.removeAll(entitiesAdded);
            entitiesAdded.clear();
            Map linksRemoved = event.getLinksRemoved();
            linksRemoved.putAll(this._links);
            Set linksAdded = event.getLinksAdded();
            linksRemoved.keySet().removeAll(linksAdded);
            linksAdded.clear();
            this._entities.clear();
            this._links.clear();
        }
        finally {
            this.endUpdate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinned(Map<EntityID, Boolean> pinnedMap) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (Map.Entry<EntityID, Boolean> entry : pinnedMap.entrySet()) {
                EntityID entityID = entry.getKey();
                Boolean pinned = entry.getValue();
                this.setPinned(entityID, (boolean)pinned);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinned(Collection<EntityID> entityIDs, boolean pinned) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (EntityID entityID : entityIDs) {
                this.setPinned(entityID, pinned);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    private void setPinned(EntityID entityID, boolean pinned) throws GraphStoreException {
        if (!this._entities.containsKey(entityID)) {
            throw new GraphStoreException("Entity does not exist: " + entityID);
        }
        EntityInfo info = this._entities.get(entityID);
        if (info == null) {
            info = new EntityInfo();
            this._entities.put(entityID, info);
        }
        if (pinned != info.pinned) {
            info.pinned = pinned;
            GraphStructureMods mods = this.getEventMods();
            Set entitiesPinned = mods.getEntitiesPinned();
            Set entitiesUnpinned = mods.getEntitiesUnpinned();
            if (pinned) {
                entitiesUnpinned.remove(entityID);
                entitiesPinned.add(entityID);
            } else {
                entitiesPinned.remove(entityID);
                entitiesUnpinned.add(entityID);
            }
        }
    }

    public boolean exists(EntityID entityID) {
        return this._entities.containsKey(entityID);
    }

    public boolean exists(LinkID linkID) {
        return this._links.containsKey(linkID);
    }

    public int getEntityCount() {
        return this._entities.size();
    }

    public int getLinkCount() {
        return this._links.size();
    }

    public Set<EntityID> getExistingEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashSet<EntityID> existing = new HashSet<EntityID>(entityIDs);
        existing.retainAll(this._entities.keySet());
        return existing;
    }

    public Set<LinkID> getExistingLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        HashSet<LinkID> existing = new HashSet<LinkID>(linkIDs);
        existing.retainAll(this._links.keySet());
        return existing;
    }

    public Set<EntityID> getEntities() {
        return Collections.unmodifiableSet(this._entities.keySet());
    }

    public Set<LinkID> getLinks() {
        return Collections.unmodifiableSet(this._links.keySet());
    }

    public Map<LinkID, LinkEntityIDs> getEntities(Collection<LinkID> linkIDs) {
        HashMap<LinkID, LinkEntityIDs> entityIDs = new HashMap<LinkID, LinkEntityIDs>(linkIDs.size());
        for (LinkID linkID : linkIDs) {
            entityIDs.put(linkID, this.getEntities(linkID));
        }
        return entityIDs;
    }

    public LinkEntityIDs getEntities(LinkID linkID) {
        if (!this.exists(linkID)) {
            throw new IllegalArgumentException("Link does not exist: " + linkID);
        }
        return this._links.get(linkID);
    }

    public Map<LinkID, EntityID> getSources(Collection<LinkID> linkIDs) {
        HashMap<LinkID, EntityID> sourceIDs = new HashMap<LinkID, EntityID>(linkIDs.size());
        for (LinkID linkID : linkIDs) {
            sourceIDs.put(linkID, this.getSource(linkID));
        }
        return sourceIDs;
    }

    public EntityID getSource(LinkID linkID) {
        return this.getEntities(linkID).getSourceID();
    }

    public Map<LinkID, EntityID> getTargets(Collection<LinkID> linkIDs) {
        HashMap<LinkID, EntityID> targetIDs = new HashMap<LinkID, EntityID>(linkIDs.size());
        for (LinkID linkID : linkIDs) {
            targetIDs.put(linkID, this.getTarget(linkID));
        }
        return targetIDs;
    }

    public EntityID getTarget(LinkID linkID) {
        return this.getEntities(linkID).getTargetID();
    }

    public Set<LinkID> getLinksBetween(Collection<EntityID> entityIDs) {
        HashSet<LinkID> links = new HashSet<LinkID>();
        Map<EntityID, Set<LinkID>> incoming = this.getIncoming(entityIDs);
        for (Map.Entry<EntityID, Set<LinkID>> entry : incoming.entrySet()) {
            Set<LinkID> incomingLinks = entry.getValue();
            for (LinkID incomingLink : incomingLinks) {
                EntityID sourceID = this.getSource(incomingLink);
                if (!entityIDs.contains(sourceID)) continue;
                links.add(incomingLink);
            }
        }
        return links;
    }

    public Set<LinkID> getLinks(Collection<EntityID> entityIDs) {
        HashSet<LinkID> linkIDs = new HashSet<LinkID>();
        for (EntityID entityID : entityIDs) {
            linkIDs.addAll(this.getLinks(entityID));
        }
        return linkIDs;
    }

    public Map<EntityID, Set<LinkID>> getLinksMap(Collection<EntityID> entityIDs) {
        HashMap<EntityID, Set<LinkID>> linkIDs = new HashMap<EntityID, Set<LinkID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            linkIDs.put(entityID, this.getLinks(entityID));
        }
        return linkIDs;
    }

    public Set<LinkID> getLinks(EntityID entityID) {
        EntityInfo linkIDs = this.getEntityLinks(entityID);
        return linkIDs != null ? linkIDs.getInAndOut() : Collections.EMPTY_SET;
    }

    public int getLinkCount(EntityID entity) throws GraphStoreException {
        EntityInfo linkIDs = this.getEntityLinks(entity);
        return linkIDs == null ? 0 : linkIDs.getLinkCount();
    }

    public int getIncomingLinkCount(EntityID entity) throws GraphStoreException {
        EntityInfo linkIDs = this.getEntityLinks(entity);
        return linkIDs == null ? 0 : linkIDs.getIncomingLinkCount();
    }

    public int getOutgoingLinkCount(EntityID entity) throws GraphStoreException {
        EntityInfo linkIDs = this.getEntityLinks(entity);
        return linkIDs == null ? 0 : linkIDs.getOutgoingLinkCount();
    }

    public boolean hasLinks(EntityID entity) throws GraphStoreException {
        return this.getLinkCount(entity) != 0;
    }

    public Map<EntityID, Set<LinkID>> getOutgoing(Collection<EntityID> entityIDs) {
        HashMap<EntityID, Set<LinkID>> linkIDs = new HashMap<EntityID, Set<LinkID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            linkIDs.put(entityID, this.getOutgoing(entityID));
        }
        return linkIDs;
    }

    public Set<LinkID> getOutgoing(EntityID entityID) {
        EntityInfo linkIDs = this.getEntityLinks(entityID);
        Set<LinkID> outgoing = linkIDs != null ? linkIDs.out : Collections.EMPTY_SET;
        return outgoing != null ? Collections.unmodifiableSet(outgoing) : Collections.EMPTY_SET;
    }

    public Map<EntityID, Set<LinkID>> getIncoming(Collection<EntityID> entityIDs) {
        HashMap<EntityID, Set<LinkID>> linkIDs = new HashMap<EntityID, Set<LinkID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            linkIDs.put(entityID, this.getIncoming(entityID));
        }
        return linkIDs;
    }

    public Set<LinkID> getIncoming(EntityID entityID) {
        EntityInfo linkIDs = this.getEntityLinks(entityID);
        Set<LinkID> incoming = linkIDs != null ? linkIDs.in : Collections.EMPTY_SET;
        return incoming != null ? Collections.unmodifiableSet(incoming) : Collections.EMPTY_SET;
    }

    private EntityInfo getEntityLinks(EntityID entityID) throws IllegalArgumentException {
        if (!this.exists(entityID)) {
            throw new IllegalArgumentException("Entity does not exist: " + entityID);
        }
        EntityInfo linkIDs = this._entities.get(entityID);
        return linkIDs;
    }

    public Map<EntityID, Set<EntityID>> getParents(Collection<EntityID> entityIDs) {
        HashMap<EntityID, Set<EntityID>> parents = new HashMap<EntityID, Set<EntityID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            parents.put(entityID, this.getParents(entityID));
        }
        return parents;
    }

    public Set<EntityID> getParents(EntityID entityID) {
        HashSet<EntityID> parents = new HashSet<EntityID>();
        Set<LinkID> incoming = this.getIncoming(entityID);
        for (LinkID linkID : incoming) {
            LinkEntityIDs entityIDs = this.getEntities(linkID);
            if (!entityIDs.getTargetID().equals((Object)entityID)) continue;
            parents.add(entityIDs.getSourceID());
        }
        return parents;
    }

    public Map<EntityID, Set<EntityID>> getChildren(Collection<EntityID> entityIDs) {
        HashMap<EntityID, Set<EntityID>> children = new HashMap<EntityID, Set<EntityID>>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            children.put(entityID, this.getChildren(entityID));
        }
        return children;
    }

    public Set<EntityID> getChildren(EntityID entityID) {
        HashSet<EntityID> children = new HashSet<EntityID>();
        Set<LinkID> outgoing = this.getOutgoing(entityID);
        for (LinkID linkID : outgoing) {
            LinkEntityIDs entityIDs = this.getEntities(linkID);
            if (!entityIDs.getSourceID().equals((Object)entityID)) continue;
            children.add(entityIDs.getTargetID());
        }
        return children;
    }

    public Map<EntityID, Boolean> getPinned(Collection<EntityID> entityIDs) throws GraphStoreException {
        HashMap<EntityID, Boolean> pinnedMap = new HashMap<EntityID, Boolean>();
        for (EntityID entityID : entityIDs) {
            pinnedMap.put(entityID, this.getPinned(entityID));
        }
        return pinnedMap;
    }

    public boolean getPinned(EntityID entityID) throws GraphStoreException {
        if (!this._entities.containsKey(entityID)) {
            throw new GraphStoreException("Entity does not exist: " + entityID);
        }
        EntityInfo info = this._entities.get(entityID);
        if (info == null) {
            info = new EntityInfo();
            this._entities.put(entityID, info);
        }
        return info.pinned;
    }

    public Set<EntityID> getAllEntitiesWithoutLinks() throws GraphStoreException {
        HashSet<EntityID> noLinkEnities = new HashSet<EntityID>();
        for (Map.Entry<EntityID, EntityInfo> entry : this._entities.entrySet()) {
            EntityInfo info = entry.getValue();
            Set<LinkID> inAndOut = info.getInAndOut();
            if (inAndOut != null && !inAndOut.isEmpty()) continue;
            noLinkEnities.add(entry.getKey());
        }
        return noLinkEnities;
    }

    public Set<EntityID> getAllSingleLinkChildren(EntityID entityID) throws GraphStoreException {
        HashSet<EntityID> singleLinkChildren = new HashSet<EntityID>();
        for (EntityID childID : this.getChildren(entityID)) {
            EntityInfo info = this._entities.get(childID);
            if (info.out != null && !info.out.isEmpty() || info.in.size() != 1) continue;
            singleLinkChildren.add(childID);
        }
        return singleLinkChildren;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    protected void fireEvent() {
        this.printStructure();
        if (this._eventMods != null && !this._eventMods.isEmpty()) {
            GraphStructureMods eventMods = this._eventMods;
            this._eventMods = null;
            if (!eventMods.isEmpty()) {
                eventMods.makeReadOnly();
                this._changeSupport.firePropertyChange("structureModified", null, eventMods);
            }
        }
    }

    private GraphStructureMods getEventMods() {
        if (this._eventMods == null) {
            this._eventMods = new GraphStructureMods();
        }
        return this._eventMods;
    }

    private void printStructure() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Graph: {0}", this._graphID);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<EntityID, EntityInfo> entry : this._entities.entrySet()) {
                EntityID entityID = entry.getKey();
                sb.append(entityID).append(", ");
            }
            LOG.log(Level.FINEST, "Entities : {0}", sb);
            LOG.finest("Links:");
            for (Map.Entry<EntityID, EntityInfo> entry : this._links.entrySet()) {
                LinkID linkID = (LinkID)entry.getKey();
                LinkEntityIDs entityIDs = (LinkEntityIDs)entry.getValue();
                LOG.log(Level.FINEST, "{0}: {1}", new Object[]{linkID, entityIDs});
            }
        }
    }

    private static class EntityInfo {
        public Set<LinkID> in = null;
        public Set<LinkID> out = null;
        public boolean pinned = false;

        private EntityInfo() {
        }

        public Set<LinkID> getInAndOut() {
            if (this.in == null && this.out == null) {
                return null;
            }
            HashSet<LinkID> links = new HashSet<LinkID>();
            if (this.in != null) {
                links.addAll(this.in);
            }
            if (this.out != null) {
                links.addAll(this.out);
            }
            return links;
        }

        private int getLinkCount() {
            return this.getIncomingLinkCount() + this.getOutgoingLinkCount();
        }

        private int getIncomingLinkCount() {
            return this.in == null ? 0 : this.in.size();
        }

        private int getOutgoingLinkCount() {
            return this.out == null ? 0 : this.out.size();
        }
    }
}

